/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.scope.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.message.factory.MsgServiceFactory;
import com.jxdinfo.crm.salesKPI.message.service.IMsgService;
import com.jxdinfo.crm.salesKPI.rule.model.Rule;
import com.jxdinfo.crm.salesKPI.rule.service.IRuleService;
import com.jxdinfo.crm.salesKPI.rule.vo.RuleVo;
import com.jxdinfo.crm.salesKPI.scope.dao.ScopeDraftMapper;
import com.jxdinfo.crm.salesKPI.scope.dto.ScopeDraftDto;
import com.jxdinfo.crm.salesKPI.scope.dto.ScopeDto;
import com.jxdinfo.crm.salesKPI.scope.dto.ScopeValueDraftDto;
import com.jxdinfo.crm.salesKPI.scope.model.Scope;
import com.jxdinfo.crm.salesKPI.scope.model.ScopeDraft;
import com.jxdinfo.crm.salesKPI.scope.model.ScopeValue;
import com.jxdinfo.crm.salesKPI.scope.model.ScopeValueDraft;
import com.jxdinfo.crm.salesKPI.scope.req.ScopeDraftReq;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeDraftService;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeService;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeValueDraftService;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeValueService;
import com.jxdinfo.crm.salesKPI.scope.vo.ScopeDraftVo;
import com.jxdinfo.crm.salesKPI.scope.vo.ScopeValueDraftVo;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.HussarDelflagEntity;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ScopeDraftServiceImpl
extends HussarServiceImpl<ScopeDraftMapper, ScopeDraft>
implements IScopeDraftService {
    @Resource
    private IScopeValueDraftService scopeValueDraftService;
    @Resource
    private IRuleService ruleService;
    @Resource
    private IScopeService scopeService;
    @Resource
    private IScopeValueService scopeValueService;
    @Resource
    private MsgServiceFactory msgServiceFactory;

    @Override
    public Page<ScopeDraftVo> getSalesKPIScopeDraftList(PageInfo pageInfo, Long ruleId) {
        Page page;
        List<ScopeDraftVo> draftList;
        if (null == pageInfo) {
            pageInfo = new PageInfo(1L, 10L);
        }
        if (!(draftList = ((ScopeDraftMapper)this.baseMapper).getSalesKPIScopeDraftList((Page<ScopeDraftVo>)(page = (Page)BeanUtil.copyProperties((Object)pageInfo, Page.class)), ruleId)).isEmpty()) {
            List scopeDraftIdList = draftList.stream().map(ScopeDraftVo::getScopeDraftId).collect(Collectors.toList());
            List scopeValueDraftList = ((LambdaQueryChainWrapper)this.scopeValueDraftService.lambdaQuery().in(ScopeValueDraft::getScopeDraftId, scopeDraftIdList)).list();
            List valueIds = scopeValueDraftList.stream().map(ScopeValueDraft::getValueId).filter(Objects::nonNull).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(valueIds)) {
                List scopeValueList = ((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().in(ScopeValue::getValueId, valueIds)).list();
                scopeValueDraftList.forEach(scopeValueDraft -> {
                    Optional<ScopeValue> first = scopeValueList.stream().filter(scopeValue -> scopeValue.getValueId().equals(scopeValueDraft.getValueId())).findFirst();
                    first.ifPresent(scopeValue -> scopeValueDraft.setPublishedKpiValue(scopeValue.getKpiValue()));
                });
            }
            Map<Long, List<ScopeValueDraft>> collect = scopeValueDraftList.stream().collect(Collectors.groupingBy(ScopeValueDraft::getScopeDraftId));
            draftList.forEach(ScopeDraftVo2 -> {
                List<ScopeValueDraftVo> scopeValueDraftVoList = ((List)collect.get(ScopeDraftVo2.getScopeDraftId())).stream().sorted(Comparator.comparing(ScopeValueDraft::getSortOrder)).map(scopeValueDraft -> (ScopeValueDraftVo)BeanUtil.copy((Object)scopeValueDraft, ScopeValueDraftVo.class)).collect(Collectors.toList());
                ScopeDraftVo2.setScopeValueDraftList(scopeValueDraftVoList);
            });
        }
        page.setRecords(draftList);
        return page;
    }

    @Override
    @HussarTransactional
    public boolean addScopeDraft(ScopeDraftReq req) {
        Long ruleId = req.getRuleId();
        if (ToolUtil.isEmpty((Object)ruleId)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u8003\u6838\u89c4\u5219");
        }
        List<ScopeDraftDto> scopeDraftDtoList = req.getScopeDraftList();
        if (ToolUtil.isEmpty(scopeDraftDtoList)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u8003\u6838\u5bf9\u8c61");
        }
        List objectIdList = scopeDraftDtoList.stream().map(ScopeDraftDto::getObjectId).collect(Collectors.toList());
        List existName = this.listObjs((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{ScopeDraft::getObjectName}).in(ScopeDraft::getObjectId, objectIdList)).eq(ScopeDraft::getRuleId, (Object)ruleId), Object::toString);
        if (ToolUtil.isNotEmpty((Object)existName)) {
            throw new BaseException("\u8003\u6838\u5bf9\u8c61\uff1a" + String.join((CharSequence)",", existName) + "\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String userName = user.getUserName();
        Long userId = user.getUserId();
        List scopeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.scopeService.lambdaQuery().eq(Scope::getRuleId, (Object)ruleId)).in(Scope::getObjectId, objectIdList)).list();
        Map<Long, Long> objectIdMapScopeId = scopeList.stream().collect(Collectors.toMap(Scope::getObjectId, Scope::getScopeId));
        List<ScopeDraft> scopeDraftList = scopeDraftDtoList.stream().map(scopeDraftDto -> {
            long id = IdWorker.getId(ScopeDraft.class);
            ScopeDraft scopeDraft = new ScopeDraft();
            BeanUtils.copyProperties((Object)scopeDraftDto, (Object)((Object)scopeDraft));
            scopeDraft.setScopeDraftId(id);
            scopeDraft.setCreator(userId);
            scopeDraft.setCreatorName(userName);
            scopeDraft.setLastEditor(userId);
            scopeDraft.setLastEditorName(userName);
            scopeDraft.setLastTime(LocalDateTime.now());
            Long scopeId = (Long)objectIdMapScopeId.get(scopeDraftDto.getObjectId());
            if (ToolUtil.isNotEmpty((Object)scopeId)) {
                scopeDraft.setScopeId(scopeId);
            }
            return scopeDraft;
        }).collect(Collectors.toList());
        ((ScopeDraftMapper)this.baseMapper).batchSave(scopeDraftList);
        Rule rule = (Rule)((Object)this.ruleService.getById(ruleId));
        String checkCycle = rule.getCheckCycle();
        String fiscalYearMonth = rule.getFiscalYearMonth();
        Integer scopeValueListSize = MsgConstants.getScopeValueSizeByCode(Integer.parseInt(checkCycle));
        if (null == scopeValueListSize) {
            throw new BaseException("\u8003\u6838\u5468\u671f\u7c7b\u578b\u9519\u8bef");
        }
        ArrayList<ScopeValueDraft> initList = new ArrayList<ScopeValueDraft>();
        scopeDraftList.forEach(scopeDraft -> {
            if (ToolUtil.isNotEmpty((Object)scopeDraft.getScopeId())) {
                return;
            }
            for (int i = 1; i <= scopeValueListSize; ++i) {
                ScopeValueDraft scopeValueDraft = new ScopeValueDraft();
                scopeValueDraft.setScopeDraftId(scopeDraft.getScopeDraftId());
                scopeValueDraft.setValueSort(i);
                if (MsgConstants.CheckCycle.MONTH.getCode().toString().equals(checkCycle)) {
                    scopeValueDraft.setSortOrder(i - Integer.parseInt(fiscalYearMonth) < 0 ? i - Integer.parseInt(fiscalYearMonth) + 13 : i - Integer.parseInt(fiscalYearMonth) + 1);
                } else {
                    scopeValueDraft.setSortOrder(i);
                }
                scopeValueDraft.setKpiValue(BigDecimal.ZERO);
                scopeValueDraft.setCreator(userId);
                scopeValueDraft.setCreatorName(userName);
                scopeValueDraft.setLastEditor(userId);
                scopeValueDraft.setLastEditorName(userName);
                scopeValueDraft.setLastTime(LocalDateTime.now());
                scopeValueDraft.setDiffFlag("1");
                initList.add(scopeValueDraft);
            }
        });
        if (ToolUtil.isNotEmpty((Object)scopeList)) {
            Map<Long, Long> scopeIdMapScopeDraftId = scopeDraftList.stream().filter(scopeDraft -> ToolUtil.isNotEmpty((Object)scopeDraft.getScopeId())).collect(Collectors.toMap(ScopeDraft::getScopeId, ScopeDraft::getScopeDraftId));
            List scopeIdList = scopeList.stream().map(Scope::getScopeId).collect(Collectors.toList());
            List scopeValueList = ((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().in(ScopeValue::getScopeId, scopeIdList)).list();
            List valueDraftList = scopeValueList.stream().map(scopeValue -> (ScopeValueDraft)((Object)((Object)BeanUtil.copy((Object)scopeValue, ScopeValueDraft.class)))).filter(Objects::nonNull).peek(scopeValueDraft -> {
                Long scopeDraftId = (Long)scopeIdMapScopeDraftId.get(scopeValueDraft.getScopeId());
                scopeValueDraft.setScopeDraftId(scopeDraftId);
                scopeValueDraft.setKpiValue(BigDecimal.ZERO);
                scopeValueDraft.setCreator(userId);
                scopeValueDraft.setCreatorName(userName);
                scopeValueDraft.setLastEditor(userId);
                scopeValueDraft.setLastEditorName(userName);
                scopeValueDraft.setLastTime(LocalDateTime.now());
                scopeValueDraft.setDiffFlag("1");
            }).collect(Collectors.toList());
            initList.addAll(valueDraftList);
        }
        this.scopeValueDraftService.batchSave(initList);
        return true;
    }

    @Override
    @HussarTransactional
    public boolean batchDeleteByIds(List<Long> idList) {
        if (ToolUtil.isEmpty(idList)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8003\u6838\u5bf9\u8c61");
        }
        String userName = BaseSecurityUtil.getUser().getUserName();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.scopeValueDraftService.lambdaUpdate().set(HussarDelflagEntity::getDelFlag, (Object)"1")).set(ScopeValueDraft::getLastEditorName, (Object)userName)).set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).in(ScopeValueDraft::getScopeDraftId, idList)).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(HussarDelflagEntity::getDelFlag, (Object)"1")).set(ScopeDraft::getLastEditorName, (Object)userName)).set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).set(ScopeDraft::getScopeId, null)).in(ScopeDraft::getScopeDraftId, idList)).update();
        return true;
    }

    @Override
    @HussarTransactional
    public boolean saveScopeValueDraft(List<ScopeValueDraftDto> dtoList) {
        if (ToolUtil.isEmpty(dtoList)) {
            throw new BaseException("\u53c2\u6570\u6821\u9a8c\u5931\u8d25,\u65e0\u76ee\u6807\u503c\u4fe1\u606f");
        }
        dtoList.forEach(dto -> {
            if (ToolUtil.isEmpty((Object)dto.getScopeDraftId())) {
                throw new BaseException("\u53c2\u6570\u6821\u9a8c\u5931\u8d25,\u65e0\u8003\u6838\u5bf9\u8c61\u8349\u7a3fid");
            }
        });
        SecurityUser user = BaseSecurityUtil.getUser();
        String userName = user.getUserName();
        Long userId = user.getUserId();
        List valueIds = dtoList.stream().map(ScopeValueDraftDto::getValueId).filter(Objects::nonNull).collect(Collectors.toList());
        List scopeValueList = new ArrayList();
        if (ToolUtil.isNotEmpty(valueIds)) {
            scopeValueList = ((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().in(ScopeValue::getValueId, valueIds)).list();
        }
        Map<Long, BigDecimal> valueMap = scopeValueList.stream().collect(Collectors.toMap(ScopeValue::getValueId, ScopeValue::getKpiValue));
        List<ScopeValueDraft> valueDraftList = dtoList.stream().map(dto -> (ScopeValueDraft)((Object)((Object)BeanUtil.copy((Object)dto, ScopeValueDraft.class)))).filter(Objects::nonNull).peek(valueDraft -> {
            if (ToolUtil.isNotEmpty((Object)valueIds) && ToolUtil.isNotEmpty((Object)valueDraft.getValueId())) {
                BigDecimal publishKPIValue = (BigDecimal)valueMap.get(valueDraft.getValueId());
                if (null != publishKPIValue && publishKPIValue.compareTo(valueDraft.getKpiValue()) != 0) {
                    valueDraft.setDiffFlag("1");
                } else {
                    valueDraft.setDiffFlag("0");
                }
            } else {
                valueDraft.setDiffFlag("1");
            }
            valueDraft.setLastEditor(userId);
            valueDraft.setLastEditorName(userName);
            valueDraft.setLastTime(LocalDateTime.now());
        }).collect(Collectors.toList());
        this.scopeValueDraftService.batchUpdateById(valueDraftList);
        List<ScopeDraft> scopeDraftList = dtoList.stream().map(ScopeValueDraftDto2 -> {
            ScopeDraft scopeDraft = new ScopeDraft();
            scopeDraft.setScopeDraftId(ScopeValueDraftDto2.getScopeDraftId());
            scopeDraft.setValueYear(ScopeValueDraftDto2.getValueYear());
            scopeDraft.setLastEditorName(userName);
            scopeDraft.setLastEditor(userId);
            return scopeDraft;
        }).distinct().collect(Collectors.toList());
        ((ScopeDraftMapper)this.baseMapper).batchUpdateById(scopeDraftList);
        return true;
    }

    @Override
    @HussarTransactional
    public boolean publishScopeDraft(Long ruleId) {
        List valueUpdatetList;
        List<ScopeDraft> addScopeDraftList;
        List<Scope> addScopeList;
        if (ToolUtil.isEmpty((Object)ruleId)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u8003\u6838\u89c4\u5219");
        }
        List scopeDraftList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ScopeDraft::getRuleId, (Object)ruleId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).list();
        List scopeIdList = ((LambdaQueryChainWrapper)this.scopeService.lambdaQuery().eq(Scope::getRuleId, (Object)ruleId)).list().stream().map(Scope::getScopeId).collect(Collectors.toList());
        if (ToolUtil.isEmpty((Object)scopeDraftList)) {
            if (ToolUtil.isEmpty(scopeIdList)) {
                throw new BaseException("\u6682\u65e0\u53ef\u53d1\u5e03\u7684\u6570\u636e");
            }
            ((LambdaUpdateChainWrapper)this.scopeValueService.lambdaUpdate().in(ScopeValue::getScopeId, scopeIdList)).remove();
            List<Map<String, Object>> params = ((LambdaQueryChainWrapper)this.scopeService.lambdaQuery().eq(Scope::getRuleId, (Object)ruleId)).list().stream().map(BeanUtil::beanToMap).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)this.scopeService.lambdaUpdate().eq(Scope::getRuleId, (Object)ruleId)).remove();
            IMsgService deleteMsg = this.msgServiceFactory.getMsgService(MsgConstants.OperationType.DELETE.getCode());
            deleteMsg.sendMsg(params);
            return true;
        }
        List scopeDraftIds = scopeDraftList.stream().map(ScopeDraft::getScopeDraftId).collect(Collectors.toList());
        List scopeValueDraftList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.scopeValueDraftService.lambdaQuery().in(ScopeValueDraft::getScopeDraftId, scopeDraftIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).list();
        List publishedScopeIdList = scopeDraftList.stream().map(ScopeDraft::getScopeId).collect(Collectors.toList());
        List deleteScopeIdList = scopeIdList.stream().filter(scopeId -> !publishedScopeIdList.contains(scopeId)).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(deleteScopeIdList)) {
            ((LambdaUpdateChainWrapper)this.scopeValueService.lambdaUpdate().in(ScopeValue::getScopeId, deleteScopeIdList)).remove();
            List<Map<String, Object>> params = ((LambdaQueryChainWrapper)this.scopeService.lambdaQuery().eq(Scope::getRuleId, (Object)ruleId)).list().stream().map(BeanUtil::beanToMap).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)this.scopeService.lambdaUpdate().in(Scope::getScopeId, deleteScopeIdList)).remove();
            IMsgService deleteMsg = this.msgServiceFactory.getMsgService(MsgConstants.OperationType.DELETE.getCode());
            deleteMsg.sendMsg(params);
        }
        if (ToolUtil.isNotEmpty(addScopeList = (addScopeDraftList = scopeDraftList.stream().filter(scopeDraft -> ToolUtil.isEmpty((Object)scopeDraft.getScopeId())).peek(scopeDraft -> scopeDraft.setScopeId(IdWorker.getId(Scope.class))).collect(Collectors.toList())).stream().map(scopeDraft -> (Scope)((Object)((Object)BeanUtil.copy((Object)scopeDraft, Scope.class)))).collect(Collectors.toList()))) {
            this.scopeService.batchSave(addScopeList);
            ((ScopeDraftMapper)this.baseMapper).batchUpdateById(addScopeDraftList);
            Map<Long, Long> scopeDraftIdMap = addScopeDraftList.stream().collect(Collectors.toMap(ScopeDraft::getScopeDraftId, ScopeDraft::getScopeId));
            List<ScopeValueDraft> addScopeValueDraft = scopeValueDraftList.stream().filter(scopeValueDraft -> ToolUtil.isEmpty((Object)scopeValueDraft.getValueId())).peek(ScopeValueDraft2 -> {
                ScopeValueDraft2.setValueId(IdWorker.getId(ScopeValue.class));
                Long scopeId = (Long)scopeDraftIdMap.get(ScopeValueDraft2.getScopeDraftId());
                if (null != scopeId) {
                    ScopeValueDraft2.setScopeId(scopeId);
                }
                ScopeValueDraft2.setDiffFlag("0");
            }).collect(Collectors.toList());
            List<ScopeValue> addScopeValueList = addScopeValueDraft.stream().map(ScopeValueDraft2 -> (ScopeValue)((Object)((Object)BeanUtil.copy((Object)ScopeValueDraft2, ScopeValue.class)))).collect(Collectors.toList());
            this.scopeValueService.batchSave(addScopeValueList);
            this.scopeValueDraftService.batchUpdateById(addScopeValueDraft);
            List<Map<String, Object>> addMsgParams = addScopeList.stream().map(BeanUtil::beanToMap).collect(Collectors.toList());
            IMsgService addMsg = this.msgServiceFactory.getMsgService(MsgConstants.OperationType.NEW.getCode());
            addMsg.sendMsg(addMsgParams);
        }
        if ((valueUpdatetList = scopeValueDraftList.stream().filter(scopeValueDraft -> ToolUtil.isNotEmpty((Object)scopeValueDraft.getValueId())).filter(scopeValueDraft -> "1".equals(scopeValueDraft.getDiffFlag())).collect(Collectors.toList())).isEmpty()) {
            return true;
        }
        List valueIdList = valueUpdatetList.stream().map(ScopeValueDraft::getValueId).collect(Collectors.toList());
        List updateScopeIdList = ((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().in(ScopeValue::getValueId, valueIdList)).list().stream().map(ScopeValue::getScopeId).distinct().collect(Collectors.toList());
        List<Scope> updateScopeList = scopeDraftList.stream().filter(scopeDraft -> ToolUtil.isNotEmpty((Object)scopeDraft.getScopeId())).filter(scopeDraft -> updateScopeIdList.contains(scopeDraft.getScopeId())).map(scopeDraft -> (Scope)((Object)((Object)BeanUtil.copy((Object)scopeDraft, Scope.class)))).collect(Collectors.toList());
        Map<Long, BigDecimal> scopeIdMapValueYear = updateScopeList.stream().collect(Collectors.toMap(Scope::getScopeId, Scope::getValueYear));
        List<RuleVo> ruleVos = this.ruleService.getSalesKPIRuleList((Rule)((Object)this.ruleService.getById(ruleId)));
        List<Map<String, Object>> updateMsgParam = ((LambdaQueryChainWrapper)this.scopeService.lambdaQuery().in(Scope::getScopeId, updateScopeIdList)).list().stream().map(scope -> (ScopeDto)BeanUtil.copy((Object)scope, ScopeDto.class)).filter(Objects::nonNull).peek(scopeDto -> {
            scopeDto.setOldScopeValueSum(this.dealScopeValue(scopeDto.getValueYear(), ruleVos));
            scopeDto.setNewScopeValueSum(this.dealScopeValue((BigDecimal)scopeIdMapValueYear.get(scopeDto.getScopeId()), ruleVos));
        }).map(BeanUtil::beanToMap).collect(Collectors.toList());
        this.scopeService.batchUpdateById(updateScopeList);
        List<ScopeValueDraft> updateValueDraftList = valueUpdatetList.stream().peek(scopeValueDraft -> scopeValueDraft.setDiffFlag("0")).collect(Collectors.toList());
        List<ScopeValue> updateScopeValueList = updateValueDraftList.stream().map(scopeValueDraft -> (ScopeValue)((Object)((Object)BeanUtil.copy((Object)scopeValueDraft, ScopeValue.class)))).collect(Collectors.toList());
        this.scopeValueService.batchUpdateById(updateScopeValueList);
        this.scopeValueDraftService.batchUpdateById(updateValueDraftList);
        IMsgService updateMsg = this.msgServiceFactory.getMsgService(MsgConstants.OperationType.UPDATE.getCode());
        updateMsg.sendMsg(updateMsgParam);
        return true;
    }

    private String dealScopeValue(BigDecimal scopeValue, List<RuleVo> ruleVos) {
        if (ToolUtil.isEmpty(ruleVos)) {
            return scopeValue.stripTrailingZeros().toPlainString();
        }
        RuleVo ruleVo = ruleVos.get(0);
        Boolean decimal = ruleVo.getDecimal();
        String unit = ruleVo.getUnit();
        Integer decimalNum = ruleVo.getDecimalNum();
        if (decimal.booleanValue()) {
            if (unit.equals("1")) {
                BigDecimal rounded = scopeValue.setScale((int)decimalNum, RoundingMode.HALF_UP);
                return rounded.stripTrailingZeros().toPlainString() + "\u5143";
            }
            BigDecimal tenThousand = new BigDecimal("10000");
            BigDecimal rounded = scopeValue.divide(tenThousand, 4).setScale((int)decimalNum, RoundingMode.HALF_UP);
            return rounded.stripTrailingZeros().toPlainString() + "\u4e07\u5143";
        }
        return scopeValue.stripTrailingZeros().toPlainString();
    }

    @Override
    @HussarTransactional
    public boolean recoverScopeByRuleId(Long ruleId) {
        if (ToolUtil.isEmpty((Object)ruleId)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u8003\u6838\u89c4\u5219");
        }
        List scopeList = ((LambdaQueryChainWrapper)this.scopeService.lambdaQuery().eq(Scope::getRuleId, (Object)ruleId)).list();
        if (ToolUtil.isEmpty((Object)scopeList)) {
            throw new BaseException("\u6682\u65e0\u5df2\u53d1\u5e03\u7684\u6570\u636e");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String userName = user.getUserName();
        Long userId = user.getUserId();
        List<Long> scopeDraftIdList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(ScopeDraft::getRuleId, (Object)ruleId)).list().stream().map(ScopeDraft::getScopeDraftId).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(scopeDraftIdList)) {
            this.scopeValueDraftService.batchDelByScopeDraftIdList(scopeDraftIdList);
        }
        ((ScopeDraftMapper)this.baseMapper).batchDelByRuleId(ruleId);
        List<ScopeDraft> scopeDraftList = scopeList.stream().map(scope -> (ScopeDraft)((Object)((Object)BeanUtil.copy((Object)scope, ScopeDraft.class)))).filter(Objects::nonNull).peek(scopeDraft -> {
            scopeDraft.setLastEditorName(userName);
            scopeDraft.setLastEditor(userId);
            scopeDraft.setLastTime(LocalDateTime.now());
        }).collect(Collectors.toList());
        ((ScopeDraftMapper)this.baseMapper).batchSave(scopeDraftList);
        Map<Long, Long> scopeIdMapScopeDraftId = scopeDraftList.stream().collect(Collectors.toMap(ScopeDraft::getScopeId, ScopeDraft::getScopeDraftId));
        List scopeIdList = scopeList.stream().map(Scope::getScopeId).collect(Collectors.toList());
        List scopeValueList = ((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().in(ScopeValue::getScopeId, scopeIdList)).list();
        List<ScopeValueDraft> valueDraftList = scopeValueList.stream().map(scopeValue -> (ScopeValueDraft)((Object)((Object)BeanUtil.copy((Object)scopeValue, ScopeValueDraft.class)))).filter(Objects::nonNull).peek(scopeValueDraft -> {
            Long scopeDraftId = (Long)scopeIdMapScopeDraftId.get(scopeValueDraft.getScopeId());
            scopeValueDraft.setScopeDraftId(scopeDraftId);
            scopeValueDraft.setDiffFlag("0");
        }).collect(Collectors.toList());
        this.scopeValueDraftService.batchSave(valueDraftList);
        return true;
    }

    @Override
    @HussarTransactional
    public boolean recoverScopeByScopeId(Long scopeId) {
        if (ToolUtil.isEmpty((Object)scopeId)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u8003\u6838\u5bf9\u8c61");
        }
        Scope scope = (Scope)((Object)this.scopeService.getById(scopeId));
        if (ToolUtil.isEmpty((Object)((Object)scope))) {
            throw new BaseException("\u6682\u65e0\u5df2\u53d1\u5e03\u7684\u6570\u636e");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String userName = user.getUserName();
        Long userId = user.getUserId();
        ScopeDraft scopeDraft = (ScopeDraft)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ScopeDraft::getScopeId, (Object)scopeId)).one());
        if (ToolUtil.isNotEmpty((Object)((Object)scopeDraft))) {
            ((LambdaUpdateChainWrapper)this.scopeValueDraftService.lambdaUpdate().eq(ScopeValueDraft::getScopeDraftId, (Object)scopeDraft.getScopeDraftId())).remove();
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ScopeDraft::getScopeId, (Object)scopeId)).remove();
        }
        ScopeDraft scopeDraftRecover = (ScopeDraft)((Object)BeanUtil.copy((Object)((Object)scope), ScopeDraft.class));
        assert (scopeDraftRecover != null);
        scopeDraftRecover.setLastEditorName(userName);
        scopeDraftRecover.setLastEditor(userId);
        scopeDraftRecover.setLastTime(LocalDateTime.now());
        this.save((BaseEntity)scopeDraftRecover);
        List scopeValueList = ((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().eq(ScopeValue::getScopeId, (Object)scopeId)).list();
        List<ScopeValueDraft> valueDraftList = scopeValueList.stream().map(scopeValue -> (ScopeValueDraft)((Object)((Object)BeanUtil.copy((Object)scopeValue, ScopeValueDraft.class)))).filter(Objects::nonNull).peek(scopeValueDraft -> {
            scopeValueDraft.setScopeDraftId(scopeDraftRecover.getScopeDraftId());
            scopeValueDraft.setDiffFlag("0");
        }).collect(Collectors.toList());
        this.scopeValueDraftService.batchSave(valueDraftList);
        return true;
    }

    @Override
    public Map getchangeScopeCount(Long ruleId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer changNum = ((ScopeDraftMapper)this.baseMapper).getchangeScopeCount(ruleId);
        Integer scopNum = ((ScopeDraftMapper)this.baseMapper).getScopeCountByRuleId(ruleId);
        Integer ruleStatus = scopNum == 0 ? Integer.valueOf(1) : (changNum != 0 ? Integer.valueOf(2) : Integer.valueOf(3));
        result.put("changNum", changNum);
        result.put("ruleStatus", ruleStatus);
        return result;
    }
}

