/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.message.service.impl;

import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.message.service.BaseMsgService;
import com.jxdinfo.crm.salesKPI.message.service.IMsgService;
import com.jxdinfo.crm.salesKPI.rule.dto.RuleDto;
import com.jxdinfo.crm.salesKPI.rule.model.RulePermission;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ShareGoal
extends BaseMsgService
implements IMsgService {
    @Override
    public void sendMsg(List<Map<String, Object>> list) {
        if (list.isEmpty()) {
            return;
        }
        List<RuleDto> dtoList = list.stream().map(map -> (RuleDto)BeanUtil.mapToBean((Map)map, RuleDto.class, (boolean)true)).collect(Collectors.toList());
        String userName = BaseSecurityUtil.getUser().getUserName();
        dtoList.forEach(ruleDto -> {
            List<RulePermission> old = ruleDto.getOldRulePermissionList();
            List<RulePermission> now = ruleDto.getRulePermissionList();
            List<String> sendMsgUserIds = this.getSendUserIds(old, now);
            String ruleName = ruleDto.getRuleName();
            String title = "\u3010\u9500\u552e\u76ee\u6807\u63d0\u9192\u3011";
            String content = userName + "\u5206\u4eab\u7ed9\u60a8\u9500\u552e\u76ee\u6807\uff0c\u9500\u552e\u76ee\u6807\u540d\u3010" + ruleName + "\u3011\uff0c\u8bf7\u77e5\u6089";
            if (sendMsgUserIds.isEmpty()) {
                return;
            }
            this.sendNoteMsg(title, content, "#/crm/salesTarget/index", sendMsgUserIds, LocalDateTime.now());
            String mobileTitle = userName + "\u5206\u4eab\u7ed9\u60a8\u9500\u552e\u76ee\u6807";
            String mobileContent = "\u9500\u552e\u76ee\u6807\u540d\u79f0\u3010" + ruleName + "\u3011\uff0c\u8bf7\u5728CRM\u95e8\u6237\u3010CRM\u7cfb\u7edf-\u9500\u552e\u76ee\u6807-\u76ee\u6807\u5b8c\u6210\u60c5\u51b5\u3011\u4e2d\u67e5\u770b\u8be6\u60c5\u3002";
            this.sendJqxNoteMsg(mobileTitle, mobileContent, "/crm/sy/yddsy", sendMsgUserIds);
        });
    }

    private List<String> getSendUserIds(List<RulePermission> old, List<RulePermission> now) {
        ArrayList<String> sendMsgUserIds = new ArrayList<String>();
        if (null == old || old.isEmpty()) {
            sendMsgUserIds.addAll(this.getSendUserIdsByPermission(now));
        } else {
            List<String> oldSendMsgUserIds = this.getSendUserIdsByPermission(old);
            List<String> newSendMsgUserIds = this.getSendUserIdsByPermission(now);
            newSendMsgUserIds.removeAll(oldSendMsgUserIds);
            sendMsgUserIds.addAll(newSendMsgUserIds);
        }
        return sendMsgUserIds;
    }

    private List<String> getSendUserIdsByPermission(List<RulePermission> list) {
        ArrayList sendMsgUserIds = new ArrayList();
        ArrayList deptIds = new ArrayList();
        list.forEach(permission -> {
            if (MsgConstants.PermissionType.PERSON.getCode().toString().equals(permission.getPermissionType())) {
                sendMsgUserIds.add(permission.getPermissionId().toString());
            } else if (MsgConstants.PermissionType.DEPT.getCode().toString().equals(permission.getPermissionType())) {
                deptIds.add(permission.getPermissionId());
            }
        });
        this.organUserBoService.getUserListByDepartmentId(deptIds).stream().map(UserVo::getId).map(String::valueOf).forEach(sendMsgUserIds::add);
        return sendMsgUserIds.stream().distinct().collect(Collectors.toList());
    }
}

