/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.message.service;

import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.salesKPI.rule.service.IRuleService;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeService;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeValueService;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMsgService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected IRuleService ruleService;
    @Resource
    protected IDataRightBoService dataRightBoService;
    @Resource
    protected IOrganUserBoService organUserBoService;
    @Resource
    protected IScopeService scopeService;
    @Resource
    protected IScopeValueService scopeValueService;

    protected void sendNoteMsg(String tile, String content, String url, List<String> sendMsgUserIds, LocalDateTime date) {
        if (!sendMsgUserIds.isEmpty()) {
            int chunkSize = 10;
            int total = sendMsgUserIds.size();
            for (int start = 0; start < total; start += chunkSize) {
                int end = Math.min(start + chunkSize, total);
                List<String> subList = sendMsgUserIds.subList(start, end);
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String userIdToString = StringUtil.join(subList, (String)",");
                addSysMessageType.setMessageContent(tile + content);
                addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                addSysMessageType.setBusinessAddress(url);
                addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType.setUserId(userIdToString);
                addSysMessageType.setOpenWay("1");
                UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
            }
        }
    }

    protected void sendJqxNoteMsg(String title, String content, String url, List<String> sendMsgUserIds) {
        if (!sendMsgUserIds.isEmpty()) {
            EimPushUtil.pushJqxArticleMessage((String)title, (String)content, (String)url, (String)"", sendMsgUserIds);
        }
    }
}

