/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.product.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.product.api.producttargetprofile.dto.OpptyTargetProfileApiDto;
import com.jxdinfo.crm.product.api.producttargetprofile.service.IProductTargetProfileApiService;
import com.jxdinfo.crm.product.api.producttargetprofile.vo.OpptyTargetProfileApiVo;
import com.jxdinfo.crm.product.model.OpptyProductProfileEntity;
import com.jxdinfo.crm.product.service.IOpptyProductProfileService;
import com.jxdinfo.crm.product.service.IProductTargetProfileService;
import com.jxdinfo.crm.product.vo.OpptyTargetProfileVo;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ProductTargetProfileApiServiceImpl
implements IProductTargetProfileApiService {
    @Resource
    private IProductTargetProfileService productTargetProfileService;
    @Resource
    private IOpptyProductProfileService opptyProductProfileService;
    @Resource
    private ISysDicRefService sysDicRefService;

    public ApiResponse<Object> selectOpptyTargetProfileById(Map<String, Object> body) {
        Long opportunityId = null;
        Long productId = null;
        if (!HussarUtils.isNotEmpty((Object)body.get("opportunityId")) || !HussarUtils.isNotEmpty((Object)body.get("productId"))) {
            return null;
        }
        opportunityId = HussarUtils.toLong((Object)body.get("opportunityId"));
        productId = HussarUtils.toLong((Object)body.get("productId"));
        List voList = new ArrayList();
        List<OpptyTargetProfileVo> profileVoList = this.productTargetProfileService.selectOpptyProfileById(opportunityId, productId);
        if (CollectionUtil.isNotEmpty(profileVoList)) {
            voList = BeanUtil.copy(profileVoList, OpptyTargetProfileApiVo.class);
        }
        List industryList = this.sysDicRefService.getDictByType("industry");
        List attributeList = this.sysDicRefService.getDictByType("customer_type");
        for (OpptyTargetProfileApiVo vo : voList) {
            ArrayList<String> dictLabels;
            String[] valueList;
            if ("1".equals(vo.getProfileType())) {
                if (HussarUtils.isEmpty((Object)vo.getProfileValue())) {
                    vo.setProfileValue("\u5ba2\u6237\u884c\u4e1a\uff1a\u4e0d\u9650\u884c\u4e1a");
                    continue;
                }
                valueList = vo.getProfileValue().split(",");
                dictLabels = new ArrayList<String>();
                block1: for (String value : valueList) {
                    for (DicSingle dicSingle : industryList) {
                        if (!dicSingle.getValue().equals(value)) continue;
                        dictLabels.add(dicSingle.getLabel());
                        continue block1;
                    }
                }
                if (dictLabels.isEmpty()) continue;
                vo.setProfileValue("\u5ba2\u6237\u884c\u4e1a\uff1a" + StringUtils.join(dictLabels, (String)","));
                continue;
            }
            if (!"2".equals(vo.getProfileType())) continue;
            if (HussarUtils.isEmpty((Object)vo.getProfileValue())) {
                vo.setProfileValue("\u5ba2\u6237\u6027\u8d28\uff1a\u4e0d\u9650\u6027\u8d28");
                continue;
            }
            valueList = vo.getProfileValue().split(",");
            dictLabels = new ArrayList();
            block3: for (String value : valueList) {
                for (DicSingle dicSingle : attributeList) {
                    if (!dicSingle.getValue().equals(value)) continue;
                    dictLabels.add(dicSingle.getLabel());
                    continue block3;
                }
            }
            if (dictLabels.isEmpty()) continue;
            vo.setProfileValue("\u5ba2\u6237\u6027\u8d28\uff1a" + StringUtils.join(dictLabels, (String)","));
        }
        return ApiResponse.success(voList);
    }

    public Boolean updateOpptyTargetProfile(List<OpptyTargetProfileApiDto> dtoList) {
        LocalDateTime date = LocalDateTime.now();
        List list = BeanUtil.copy(dtoList, OpptyProductProfileEntity.class);
        for (OpptyProductProfileEntity entity : list) {
            entity.setLastTime(date);
        }
        List targetProfileIdList = list.stream().map(OpptyProductProfileEntity::getTargetProfileId).collect(Collectors.toList());
        this.opptyProductProfileService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpptyProductProfileEntity::getOpportunityId, (Object)((OpptyProductProfileEntity)list.get(0)).getOpportunityId())).in(OpptyProductProfileEntity::getTargetProfileId, targetProfileIdList));
        this.opptyProductProfileService.saveBatch(list);
        return true;
    }
}

