/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.product.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.product.constant.CommonConstant;
import com.jxdinfo.crm.product.dao.ProductCategoryMapper;
import com.jxdinfo.crm.product.dto.ProductCategoryChangeDto;
import com.jxdinfo.crm.product.dto.ProductCategoryMoveDto;
import com.jxdinfo.crm.product.model.ProductCategory;
import com.jxdinfo.crm.product.service.ProductCategoryService;
import com.jxdinfo.crm.product.utils.ProductCategoryUtils;
import com.jxdinfo.crm.product.vo.ProductCategoryVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductCategoryServiceImpl
extends HussarServiceImpl<ProductCategoryMapper, ProductCategory>
implements ProductCategoryService {
    @Resource
    ProductCategoryMapper productCategoryMapper;

    @Override
    public IPage<ProductCategory> listProductCategory(Page<ProductCategory> page, Long categoryId) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.page((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ToolUtil.isNotEmpty((Object)categoryId), ProductCategory::getParentId, (Object)categoryId)).eq(ProductCategory::getDelFlag, (Object)"0")).orderByAsc(ProductCategory::getShowOrder));
    }

    @Override
    @Transactional
    public Boolean saveProductCategory(ProductCategory productCategory) {
        if (HussarUtils.isEmpty((Object)((Object)productCategory))) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        productCategory.setLastEditor(user.getUserId());
        productCategory.setLastEditorName(user.getUserName());
        productCategory.setLastTime(date);
        if (HussarUtils.isNotEmpty((Object)productCategory.getCategoryId())) {
            this.updateById((BaseEntity)productCategory);
        } else {
            if (HussarUtils.isNotEmpty((Object)productCategory.getParentId()) && productCategory.getParentId().intValue() != CommonConstant.ROOT_NODE_PARENT.intValue()) {
                ProductCategory parentProductCategory = (ProductCategory)((Object)this.getById(productCategory.getParentId()));
                if ("1".equals(parentProductCategory.getIsLeaf())) {
                    throw new BaseException("\u7236\u7c7b\u4ea7\u54c1\u7c7b\u522b\u4e3a\u53f6\u5b50\u8282\u70b9\uff0c\u65e0\u6cd5\u518d\u6dfb\u52a0\u5b50\u7c7b");
                }
            } else {
                productCategory.setParentId(CommonConstant.ROOT_NODE_PARENT);
            }
            productCategory.setCreator(user.getUserId());
            productCategory.setCreatorName(user.getUserName());
            productCategory.setCreateTime(date);
            productCategory.setDelFlag("0");
            Integer count = this.productCategoryMapper.getSort(productCategory.getParentId());
            productCategory.setShowOrder(count);
            this.save((BaseEntity)productCategory);
            Map<String, String> map = this.getFullPath(productCategory.getCategoryId());
            productCategory.setCategoryFCode(map.get("fCode"));
            productCategory.setCategoryFName(map.get("fName"));
            this.updateById((BaseEntity)productCategory);
        }
        return true;
    }

    @Override
    @HussarTransactional
    public Boolean deleteProductCategory(String categoryId) {
        if (HussarUtils.isEmpty((Object)categoryId)) {
            throw new BaseException("\u4ea7\u54c1\u7c7b\u522bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long deleteId = Long.valueOf(categoryId);
        ProductCategory productCategory = (ProductCategory)((Object)this.getById(deleteId));
        if ("0".equals(productCategory.getIsLeaf())) {
            ArrayList<Long> parentIds = new ArrayList<Long>();
            parentIds.add(deleteId);
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            List productCategoryIds = ProductCategoryUtils.getProductCategoryIdsByParentId(parentIds, categoryIds).stream().filter(id -> !Objects.equals(id, deleteId)).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(productCategoryIds)) {
                throw new BaseException("\u5f53\u524d\u7c7b\u522b\u4e0b\u542b\u6709\u5b50\u7c7b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            List<Long> productIds = this.productCategoryMapper.selectByProductCategoryId(parentIds);
            if (HussarUtils.isNotEmpty(productIds)) {
                throw new BaseException("\u5f53\u524d\u7c7b\u522b\u4e0b\u6709\u5173\u8054\u4ea7\u54c1\uff0c\u8bf7\u79fb\u9664\u4ea7\u54c1\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c");
            }
        } else {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(deleteId);
            List<Long> productIds = this.productCategoryMapper.selectByProductCategoryId(list);
            if (HussarUtils.isNotEmpty(productIds)) {
                throw new BaseException("\u5f53\u524d\u7c7b\u522b\u4e0b\u6709\u5173\u8054\u4ea7\u54c1\uff0c\u8bf7\u79fb\u9664\u4ea7\u54c1\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c");
            }
        }
        productCategory.setLastEditor(user.getUserId());
        productCategory.setLastEditorName(user.getUserName());
        productCategory.setLastTime(date);
        productCategory.setDelFlag("1");
        this.updateById((BaseEntity)productCategory);
        return true;
    }

    @Override
    public ProductCategoryVo detailProductCategory(Long categoryId) {
        if (ToolUtil.isEmpty((Object)categoryId)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        ProductCategoryVo categoryVo = this.productCategoryMapper.getCategoryVoById(categoryId);
        List childrenList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ToolUtil.isNotEmpty((Object)categoryId), ProductCategory::getParentId, (Object)categoryId)).eq(ProductCategory::getDelFlag, (Object)"0"));
        if (ToolUtil.isNotEmpty((Object)childrenList)) {
            categoryVo.setChildrenList(childrenList);
        }
        return categoryVo;
    }

    @Override
    @HussarTransactional
    public Boolean changeParent(ProductCategoryChangeDto dto) {
        Long productCategoryId = dto.getCategoryId();
        Long toCategoryId = dto.getToCategoryId();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        ProductCategory productCategory = (ProductCategory)((Object)this.getById(productCategoryId));
        ProductCategory goalProductCategory = (ProductCategory)((Object)this.getById(toCategoryId));
        List goalSonList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProductCategory::getParentId, (Object)goalProductCategory.getCategoryId())).eq(ProductCategory::getDelFlag, (Object)"0"));
        if (HussarUtils.equals((Object)goalProductCategory.getIsLeaf(), (Object)"1")) {
            throw new BaseException("\u7236\u7c7b\u4ea7\u54c1\u7c7b\u522b\u4e3a\u53f6\u5b50\u8282\u70b9\uff0c\u65e0\u6cd5\u8f6c\u79fb");
        }
        productCategory.setParentId(toCategoryId);
        productCategory.setLastEditor(user.getUserId());
        productCategory.setLastEditorName(user.getUserName());
        productCategory.setLastTime(date);
        productCategory.setShowOrder(goalSonList.stream().mapToInt(ProductCategory::getShowOrder).max().orElse(0) + 1);
        this.saveOrUpdate((BaseEntity)productCategory);
        Map<String, String> map = this.getFullPath(productCategory.getCategoryId());
        productCategory.setCategoryFCode(map.get("fCode"));
        productCategory.setCategoryFName(map.get("fName"));
        return this.updateById((BaseEntity)productCategory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @HussarTransactional
    public Boolean singleMove(ProductCategoryMoveDto dto) {
        Long productCategoryId = dto.getCategoryId();
        String upOrDown = dto.getIsUp();
        ProductCategory productCategory = (ProductCategory)((Object)this.getById(productCategoryId));
        Integer nowSort = productCategory.getShowOrder();
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (HussarUtils.equals((Object)upOrDown, (Object)"0")) {
            List<ProductCategoryVo> preProducts = this.productCategoryMapper.selectChangeSort("0", nowSort, "1", productCategory.getParentId());
            if (!ToolUtil.isNotEmpty(preProducts)) throw new BaseException("\u5df2\u7ecf\u662f\u7b2c\u4e00\u4e2a\uff0c\u65e0\u6cd5\u4e0a\u79fb");
            ProductCategoryVo preProduct = preProducts.get(0);
            Integer previousSort = preProduct.getShowOrder();
            Long preId = preProduct.getCategoryId();
            this.productCategoryMapper.updateShowSort(nowSort, previousSort, preId, user.getUserId(), user.getUserName(), date);
            this.productCategoryMapper.updateShowSort(previousSort, nowSort, productCategoryId, user.getUserId(), user.getUserName(), date);
            return true;
        } else {
            if (!HussarUtils.equals((Object)upOrDown, (Object)"1")) return true;
            List<ProductCategoryVo> nextProducts = this.productCategoryMapper.selectChangeSort("0", nowSort, "2", productCategory.getParentId());
            if (!ToolUtil.isNotEmpty(nextProducts)) throw new BaseException("\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u4e2a\uff0c\u65e0\u6cd5\u4e0b\u79fb");
            ProductCategoryVo nextProduct = nextProducts.get(0);
            Integer nextSort = nextProduct.getShowOrder();
            Long nextId = nextProduct.getCategoryId();
            this.productCategoryMapper.updateShowSort(nowSort, nextSort, nextId, user.getUserId(), user.getUserName(), date);
            this.productCategoryMapper.updateShowSort(nextSort, nowSort, productCategoryId, user.getUserId(), user.getUserName(), date);
        }
        return true;
    }

    @Override
    public Boolean saveTreeOrder(List<ProductCategory> productCategories) {
        if (ToolUtil.isEmpty(productCategories)) {
            throw new BaseException("\u6392\u5e8f\u83dc\u5355\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < productCategories.size(); ++i) {
            productCategories.get(i).setShowOrder(i + 1);
        }
        return this.updateBatchById(productCategories, productCategories.size());
    }

    @Override
    public List<JSTreeModel> treeProductCategory() {
        List<JSTreeModel> productCategoryList = this.productCategoryMapper.getCategoryTree();
        JSTreeModel root = new JSTreeModel();
        root.setId(CommonConstant.ROOT_NODE_PARENT);
        root.setText("\u4ea7\u54c1\u7c7b\u522b");
        root.setIsLeaf("0");
        root.setType("isRoot");
        productCategoryList.add(root);
        return ProductCategoryUtils.merge(productCategoryList);
    }

    @Override
    public List<JSTreeModel> treeProductCategoryById(Long productCategoryId, Boolean isRoot) {
        if (ToolUtil.isEmpty((Object)productCategoryId)) {
            throw new BaseException("\u83dc\u5355id\u4e0d\u5b58\u5728");
        }
        if (ToolUtil.isEmpty((Object)isRoot)) {
            throw new BaseException("\u9700\u8981\u6307\u5b9a\u662f\u5426\u4e3a\u6839\u8282\u70b9");
        }
        List<JSTreeModel> list = this.productCategoryMapper.getSon(productCategoryId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId(CommonConstant.ROOT_NODE_PARENT);
            root.setText("\u4ea7\u54c1\u7c7b\u522b");
            root.setIsLeaf("0");
            root.setType("isRoot");
            list.add(root);
        }
        return ProductCategoryUtils.merge(list);
    }

    @Override
    public List<Long> selectAllChildrenCategoryByCategoryIdList(List<Long> categoryIdList) {
        if (CollectionUtil.isNotEmpty(categoryIdList)) {
            List categoryList = this.list((Wrapper)new LambdaQueryWrapper().eq(ProductCategory::getDelFlag, (Object)"0"));
            HashSet<Long> searchCategoryIdSet = new HashSet<Long>();
            for (Long categoryId : categoryIdList) {
                ArrayList<Long> childCategoryIds = new ArrayList<Long>();
                childCategoryIds.add(categoryId);
                this.getCategoryAllChildId(childCategoryIds, categoryList, categoryId);
                searchCategoryIdSet.addAll(childCategoryIds);
            }
            return CollectionUtil.toList(searchCategoryIdSet);
        }
        return new ArrayList<Long>();
    }

    private void getCategoryAllChildId(List<Long> childCategoryIds, List<ProductCategory> categoryList, Long categoryId) {
        for (ProductCategory pc : categoryList) {
            if (!Objects.equals(pc.getParentId(), categoryId)) continue;
            childCategoryIds.add(pc.getCategoryId());
            this.getCategoryAllChildId(childCategoryIds, categoryList, pc.getCategoryId());
        }
    }

    public Map<String, String> getFullPath(Long categoryId) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder fCode = new StringBuilder();
        StringBuilder fName = new StringBuilder();
        ProductCategory first = (ProductCategory)((Object)this.getById(categoryId));
        LinkedList<ProductCategory> list = new LinkedList<ProductCategory>();
        list.addFirst(first);
        ProductCategory parent = null;
        Long parentCategoryId = first.getParentId();
        while (parentCategoryId != 1L) {
            parent = (ProductCategory)((Object)this.getById(parentCategoryId));
            parentCategoryId = parent.getParentId();
            list.addFirst(parent);
        }
        fCode.append("/");
        fName.append("/");
        for (int i = 0; i < list.size(); ++i) {
            ProductCategory productCategory = (ProductCategory)((Object)list.get(i));
            fCode.append(productCategory.getCategoryId());
            fName.append(productCategory.getCategoryName());
            fCode.append("/");
            if (HussarUtils.equals((Object)i, (Object)(list.size() - 1))) continue;
            fName.append("/");
        }
        map.put("fCode", String.valueOf(fCode));
        map.put("fName", String.valueOf(fName));
        return map;
    }
}

