/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.product.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.core.api.opportunityproduct.service.IOpportunityProductApiService;
import com.jxdinfo.crm.product.dao.SpecificationMapper;
import com.jxdinfo.crm.product.dto.SpecificationDto;
import com.jxdinfo.crm.product.model.SpecificationEntity;
import com.jxdinfo.crm.product.model.SpecificationTypeEntity;
import com.jxdinfo.crm.product.model.SpecificationTypeValueEntity;
import com.jxdinfo.crm.product.service.ISpecificationService;
import com.jxdinfo.crm.product.service.ISpecificationTypeService;
import com.jxdinfo.crm.product.service.ISpecificationTypeValueService;
import com.jxdinfo.crm.transaction.api.service.IPriceListApiService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SpecificationServiceImpl
extends ServiceImpl<SpecificationMapper, SpecificationEntity>
implements ISpecificationService {
    @Resource
    private SpecificationMapper specificationMapper;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IOpportunityProductApiService opportunityProductApiService;
    @Resource
    private ISpecificationTypeService specificationTypeService;
    @Resource
    private ISpecificationTypeValueService specificationTypeValueService;
    @Resource
    private IPriceListApiService priceListApiService;

    @Override
    public Map<String, Object> queryListByProductId(Long productId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List specTypeList = this.specificationTypeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SpecificationTypeEntity::getProductId, (Object)productId)).eq(SpecificationTypeEntity::getDelFlag, (Object)"0"));
        List specTypeValueList = this.specificationTypeValueService.list((Wrapper)new LambdaQueryWrapper().eq(SpecificationTypeValueEntity::getProductId, (Object)productId));
        Map<Long, List<SpecificationTypeValueEntity>> map1 = specTypeValueList.stream().collect(Collectors.groupingBy(SpecificationTypeValueEntity::getSpecificationTypeId));
        for (SpecificationTypeEntity specType : specTypeList) {
            specType.setValueList(map1.get(specType.getSpecificationTypeId()));
        }
        List specList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SpecificationEntity::getProductId, (Object)productId)).eq(SpecificationEntity::getDisplayFlag, (Object)"1")).eq(SpecificationEntity::getDelFlag, (Object)"0"));
        resultMap.put("specTypeList", specTypeList);
        resultMap.put("specList", specList);
        return resultMap;
    }

    @Override
    public ApiResponse<String> changeMainSwitch(String configValue) {
        this.crmBaseConfigBoService.updateConfigValue(configValue, "specification_switch");
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public ApiResponse<String> delCheck(SpecificationDto dto) {
        List<Long> specIdList = dto.getSpecificationIds();
        long count = this.opportunityProductApiService.specCount(specIdList);
        if (count > 0L) {
            return ApiResponse.success((String)"fail");
        }
        List usedIds = this.priceListApiService.isRelevancePrice(specIdList);
        if (CollectionUtil.isNotEmpty((Collection)usedIds)) {
            return ApiResponse.success((String)"fail");
        }
        return ApiResponse.success((String)"ok");
    }
}

