/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.marketing.wallchart.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryNoPageDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.task.dto.TaskAPIDto;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.dto.EimPushMessage;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.CrmLabelUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.marketing.wallchart.dao.WallchartCustomerMapper;
import com.jxdinfo.crm.marketing.wallchart.dao.WallchartMapper;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartAssociativeQueryDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartCustomerDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartEntityDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartOpportunityDto;
import com.jxdinfo.crm.marketing.wallchart.model.Wallchart;
import com.jxdinfo.crm.marketing.wallchart.model.WallchartCustomer;
import com.jxdinfo.crm.marketing.wallchart.model.WallchartRule;
import com.jxdinfo.crm.marketing.wallchart.service.IWallchartAssociativeQueryService;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartCustomerService;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartRuleService;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartService;
import com.jxdinfo.crm.marketing.wallchart.vo.WallchartFullViewVo;
import com.jxdinfo.crm.marketing.wallchart.vo.WallchartOpportunityVo;
import com.jxdinfo.crm.marketing.wallchart.vo.WallchartRuleVo;
import com.jxdinfo.crm.marketing.wallchart.vo.WallchartStageVo;
import com.jxdinfo.crm.marketing.wallchart.vo.WallchartVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WallchartServiceImpl
extends ServiceImpl<WallchartMapper, Wallchart>
implements WallchartService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private IWallchartAssociativeQueryService wallchartAssociativeQueryService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private WallchartCustomerService wallchartCustomerService;
    @Resource
    private WallchartRuleService wallchartRuleService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ILabelService labelService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private WallchartCustomerMapper wallchartCustomerMapper;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ISysDicRefService sysDicRefService;

    public WallchartServiceImpl(CrmCommonProperties crmProperties) {
        this.crmProperties = crmProperties;
    }

    @Override
    public Page<Wallchart> queryWallchartList(WallchartDto wallchartDto) {
        if (StringUtil.isEmpty((Object)wallchartDto.getWallchartView())) {
            wallchartDto.setWallchartView("4");
        }
        SalesStatisticsDto permissionDto = this.wallchartOperate(wallchartDto);
        List<WallchartDto> dtoList = this.getWallchartDtoList(wallchartDto);
        Page page = wallchartDto.getPage();
        List<Wallchart> list = ((WallchartMapper)this.baseMapper).queryWallchartList((Page<Wallchart>)page, wallchartDto.getCurrentUserId(), dtoList, permissionDto, wallchartDto.getTimeOrder());
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.WALLCHART.getModuleId());
            list.forEach(wallchart -> wallchart.setLabelName(CrmLabelUtil.getLabelName((List)labelList, (String)wallchart.getLabelId())));
        }
        page.setRecords(list);
        return page;
    }

    @Override
    @Transactional
    public Long saveWallchart(WallchartEntityDto wallchartEntityDto) {
        Wallchart wallchart = (Wallchart)BeanUtil.copy((Object)wallchartEntityDto, Wallchart.class);
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        assert (wallchart != null);
        if ("1".equals(wallchartEntityDto.getSaveFlag())) {
            wallchart.setLastTime(date);
            wallchart.setLastEditor(user.getUserId());
            wallchart.setLastEditorName(user.getUserName());
            ((WallchartMapper)this.baseMapper).updateById(wallchart);
        } else {
            if (ToolUtil.isNotEmpty((Object)wallchart.getWallchartId())) {
                wallchart.setWallchartId(null);
            }
            wallchart.setDelFlag("0");
            wallchart.setWallchartStatus("1");
            wallchart.setCreateTime(date);
            wallchart.setCreator(user.getUserId());
            wallchart.setCreatorName(user.getUserName());
            wallchart.setCreateDepartment(user.getDeptId());
            wallchart.setCreateDepartmentName(user.getDeptName());
            wallchart.setOwnUnit(user.getTenantId());
            wallchart.setOwnUnitName(user.getTenantName());
            wallchart.setLastTime(date);
            wallchart.setLastEditor(user.getUserId());
            wallchart.setLastEditorName(user.getUserName());
            ((WallchartMapper)this.baseMapper).insert(wallchart);
            if ("0".equals(wallchartEntityDto.getSaveFlag())) {
                this.wallchartRuleService.saveWallchartRule(null, wallchart.getWallchartId());
            }
            this.saveTrackRecord(wallchart.getWallchartId(), wallchart.getWallchartName(), RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId(), null);
        }
        Long wallchartId = wallchart.getWallchartId();
        if (HussarUtils.isNotEmpty((Object)wallchartEntityDto.getSaveLabelDto()) && HussarUtils.isNotEmpty((Object)wallchartEntityDto.getSaveLabelDto().getAddLabelIds())) {
            wallchartEntityDto.getSaveLabelDto().setBusinessId(wallchartId);
            wallchartEntityDto.getSaveLabelDto().setChooseBatch(Boolean.valueOf(false));
            wallchartEntityDto.getSaveLabelDto().setModuleId("wallchart");
            this.labelService.userSaveLabel(wallchartEntityDto.getSaveLabelDto());
        }
        TeamMeberDto teamMeberDto = new TeamMeberDto();
        teamMeberDto.setBusinessId(wallchartId);
        teamMeberDto.setPersonId(wallchart.getChargePersonId());
        teamMeberDto.setDelFlag("0");
        List list = this.teamMeberMapper.selectTeamMeberList(null, teamMeberDto);
        if (list.size() == 0) {
            this.teamMeberService.insertTeamMember(wallchart.getChargePersonName(), wallchart.getChargePersonId(), wallchartId, "1", "1", date, "14");
        } else {
            this.teamMeberMapper.updateIsCharge(String.valueOf(wallchart.getChargePersonId()), wallchartId, "1", null, "1");
        }
        return wallchartId;
    }

    @Override
    @Transactional
    public Long copyWallchart(WallchartEntityDto wallchartEntityDto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long oldWallchartId = wallchartEntityDto.getWallchartId();
        wallchartEntityDto.setWallchartId(null);
        wallchartEntityDto.setSaveFlag("3");
        Long wallchartId = this.saveWallchart(wallchartEntityDto);
        if (ToolUtil.isNotEmpty((Object)wallchartEntityDto.getWallchartRule())) {
            WallchartRule wallchartRule = (WallchartRule)this.wallchartRuleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WallchartRule::getWallchartId, (Object)oldWallchartId)).eq(WallchartRule::getDelFlag, (Object)"0"));
            wallchartRule.setWallchartId(wallchartId);
            wallchartRule.setWallchartRuleId(null);
            wallchartRule.setDelFlag("0");
            wallchartRule.setCreateTime(date);
            wallchartRule.setCreator(user.getUserId());
            wallchartRule.setCreatorName(user.getUserName());
            wallchartRule.setCreateDepartment(user.getDeptId());
            wallchartRule.setCreateDepartmentName(user.getDeptName());
            wallchartRule.setOwnUnit(user.getTenantId());
            wallchartRule.setOwnUnitName(user.getTenantName());
            this.wallchartRuleService.save(wallchartRule);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WallchartCustomer::getWallchartId, (Object)oldWallchartId);
        queryWrapper.eq(WallchartCustomer::getDelFlag, (Object)"0");
        List wallchartCustomerList = this.wallchartCustomerService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)wallchartCustomerList) && wallchartCustomerList.size() > 0) {
            wallchartCustomerList.forEach(wallchartCustomer -> {
                wallchartCustomer.setWallchartId(wallchartId);
                wallchartCustomer.setWallchartCustomerId(null);
            });
            this.wallchartCustomerService.saveOrUpdateBatch(wallchartCustomerList);
        }
        return wallchartId;
    }

    @Override
    public WallchartFullViewVo fullView(WallchartCustomerDto customerDto) {
        if (ToolUtil.isEmpty((Object)customerDto.getWallchartId())) {
            return null;
        }
        Wallchart wallchart = (Wallchart)((WallchartMapper)this.baseMapper).selectById(customerDto.getWallchartId());
        if (ToolUtil.isEmpty((Object)wallchart)) {
            return null;
        }
        WallchartRule wallchartRule = (WallchartRule)this.wallchartRuleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WallchartRule::getWallchartId, (Object)wallchart.getWallchartId())).eq(WallchartRule::getDelFlag, (Object)"0"));
        ArrayList<String> showStatus = new ArrayList<String>(Arrays.asList(wallchartRule.getShowCustomerStatus().split(",")));
        if (ToolUtil.isEmpty((Object)wallchartRule) || ToolUtil.isEmpty((Object)wallchartRule.getCustomerPermission())) {
            this.wallchartCustomerService.addConditionByCustomerPermission(customerDto, "1");
        } else {
            this.wallchartCustomerService.addConditionByCustomerPermission(customerDto, wallchartRule.getCustomerPermission());
        }
        customerDto.setShowStatusList(showStatus);
        if (HussarUtils.isNotEmpty((Object)wallchart.getProductIds()) && CollectionUtil.isNotEmpty(customerDto.getOpportunityStageList())) {
            customerDto.setTargetProductList(Arrays.stream(wallchart.getProductIds().split(",")).map(Long::parseLong).collect(Collectors.toList()));
        }
        WallchartFullViewVo fullViewVo = new WallchartFullViewVo();
        fullViewVo.setCustomerCount(0);
        fullViewVo.setDefaultCount(0);
        fullViewVo.setConnectedCount(0);
        fullViewVo.setFollowCount(0);
        fullViewVo.setSignCount(0);
        fullViewVo.setClosedCount(0);
        List<WallchartCustomer> wallchartCustomerList = this.wallchartCustomerMapper.queryList(null, customerDto);
        if (CollectionUtil.isNotEmpty(wallchartCustomerList)) {
            List opportunityAPIVoList;
            List customerIdList = wallchartCustomerList.stream().map(WallchartCustomer::getSysCustomerId).filter(Objects::nonNull).collect(Collectors.toList());
            OpportunityQueryNoPageDto queryDto = new OpportunityQueryNoPageDto();
            if (CollectionUtil.isNotEmpty(customerIdList)) {
                if (!"1".equals(wallchartRule.getStatisticsBeforeStart())) {
                    queryDto.setCreateDateStart(wallchart.getWallchartStartDate());
                }
                queryDto.setCreateDateEnd(wallchart.getWallchartEndDate());
                queryDto.setProductIdList(customerDto.getTargetProductList());
                queryDto.setCustomerIdList(customerIdList);
                if (CollectionUtil.isNotEmpty(customerDto.getOpportunityStageList())) {
                    queryDto.setStageIdList(customerDto.getOpportunityStageList().stream().map(Long::parseLong).collect(Collectors.toList()));
                }
                if (HussarUtils.isNotEmpty((Object)wallchart.getProductIds())) {
                    queryDto.setProductIdList(Arrays.stream(wallchart.getProductIds().split(",")).map(Long::parseLong).collect(Collectors.toList()));
                }
                opportunityAPIVoList = this.opportunityAPIService.selectOpportunityForWallChart(null, queryDto);
            } else {
                opportunityAPIVoList = new ArrayList();
            }
            Map<Long, List<OpportunityAPIVo>> customerIdOpportunityMap = opportunityAPIVoList.stream().collect(Collectors.groupingBy(OpportunityAPIVo::getCustomerId));
            for (WallchartCustomer wallchartCustomer : wallchartCustomerList) {
                if (!customerIdOpportunityMap.containsKey(wallchartCustomer.getSysCustomerId())) continue;
                wallchartCustomer.setOpportunityList(customerIdOpportunityMap.get(wallchartCustomer.getSysCustomerId()));
            }
            HashMap stageIdmap = new HashMap();
            HashMap<String, Integer> stageCountMap = new HashMap<String, Integer>();
            for (Map.Entry<Long, List<OpportunityAPIVo>> entry : customerIdOpportunityMap.entrySet()) {
                HashSet<String> stageNameExistSet = new HashSet<String>();
                for (OpportunityAPIVo vo : entry.getValue()) {
                    stageNameExistSet.add(vo.getCustomerStageName());
                    if (!stageIdmap.containsKey(vo.getCustomerStageName())) {
                        HashSet<Long> stageIdSet = new HashSet<Long>();
                        stageIdSet.add(Long.valueOf(vo.getCustomerStageId()));
                        stageIdmap.put(vo.getCustomerStageName(), stageIdSet);
                        continue;
                    }
                    ((Set)stageIdmap.get(vo.getCustomerStageName())).add(Long.valueOf(vo.getCustomerStageId()));
                }
                for (String stageName : stageNameExistSet) {
                    if (!stageCountMap.containsKey(stageName)) {
                        stageCountMap.put(stageName, 1);
                        continue;
                    }
                    stageCountMap.put(stageName, 1 + (Integer)stageCountMap.get(stageName));
                }
            }
            ArrayList<WallchartStageVo> wallchartStageVoList = new ArrayList<WallchartStageVo>();
            OpportunityQueryNoPageDto queryDto1 = (OpportunityQueryNoPageDto)BeanUtil.copy((Object)queryDto, OpportunityQueryNoPageDto.class);
            WallchartCustomerDto customerDto1 = (WallchartCustomerDto)((Object)BeanUtil.copy((Object)((Object)customerDto), WallchartCustomerDto.class));
            customerDto1.setOpportunityStageList(null);
            List<WallchartCustomer> wallchartAllCustomerList = this.wallchartCustomerMapper.queryList(null, customerDto1);
            queryDto1.setStageIdList(null);
            queryDto1.setSearchKey(null);
            if (!"1".equals(wallchartRule.getStatisticsBeforeStart())) {
                queryDto1.setCreateDateStart(wallchart.getWallchartStartDate());
            }
            queryDto1.setCreateDateEnd(wallchart.getWallchartEndDate());
            if (HussarUtils.isNotEmpty((Object)wallchart.getProductIds())) {
                queryDto1.setProductIdList(Arrays.stream(wallchart.getProductIds().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            }
            queryDto1.setCustomerIdList(wallchartAllCustomerList.stream().map(WallchartCustomer::getSysCustomerId).collect(Collectors.toList()));
            List opportunityAPIVoListForSelect = this.opportunityAPIService.selectOpportunityForWallChart(null, queryDto1);
            Map<Long, List<OpportunityAPIVo>> customerIdOpportunityMap2 = opportunityAPIVoListForSelect.stream().collect(Collectors.groupingBy(OpportunityAPIVo::getCustomerId));
            HashMap stageIdMap2 = new HashMap();
            HashMap<String, Integer> stageCountMap2 = new HashMap<String, Integer>();
            for (Map.Entry<Long, List<OpportunityAPIVo>> entry : customerIdOpportunityMap2.entrySet()) {
                HashSet<String> stageNameExistSet = new HashSet<String>();
                for (OpportunityAPIVo vo : entry.getValue()) {
                    stageNameExistSet.add(vo.getCustomerStageName());
                    if (!stageIdMap2.containsKey(vo.getCustomerStageName())) {
                        HashSet<Long> stageIdSet = new HashSet<Long>();
                        stageIdSet.add(Long.valueOf(vo.getCustomerStageId()));
                        stageIdMap2.put(vo.getCustomerStageName(), stageIdSet);
                        continue;
                    }
                    ((Set)stageIdMap2.get(vo.getCustomerStageName())).add(Long.valueOf(vo.getCustomerStageId()));
                }
                for (String stageName : stageNameExistSet) {
                    if (!stageCountMap2.containsKey(stageName)) {
                        stageCountMap2.put(stageName, 1);
                        continue;
                    }
                    stageCountMap2.put(stageName, 1 + (Integer)stageCountMap2.get(stageName));
                }
            }
            for (Map.Entry<Long, List<Object>> entry : stageCountMap2.entrySet()) {
                WallchartStageVo vo = new WallchartStageVo();
                vo.setStageName((String)((Object)entry.getKey()));
                vo.setStageCount((Integer)((Object)entry.getValue()));
                vo.setStageIds(new ArrayList<Long>((Collection)stageIdMap2.get(entry.getKey())));
                wallchartStageVoList.add(vo);
            }
            fullViewVo.setOpportunityStageCountList(wallchartStageVoList);
        }
        fullViewVo.setWallchartCustomerList(wallchartCustomerList);
        if (CollectionUtil.isNotEmpty(wallchartCustomerList)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.WALLCUSTOMER.getModuleId());
            wallchartCustomerList.forEach(customer -> customer.setLabelName(CrmLabelUtil.getLabelName((List)labelList, (String)customer.getLabelId())));
            this.customerCountByAreaStatistics(fullViewVo, wallchartCustomerList, customerDto.getProvinceCode());
        }
        customerDto.setStatusList(null);
        List<WallchartCustomer> allCustomerList = this.wallchartCustomerMapper.queryList(null, customerDto);
        if (CollectionUtil.isNotEmpty(allCustomerList)) {
            this.customerCountByStatusStatistics(fullViewVo, allCustomerList);
        }
        return fullViewVo;
    }

    private void customerCountByStatusStatistics(WallchartFullViewVo fullViewVo, List<WallchartCustomer> allCustomerList) {
        int defaultNumber = 0;
        int connectedNumber = 0;
        int followNumber = 0;
        int signNumber = 0;
        int closedNumber = 0;
        for (WallchartCustomer wallchartCustomer : allCustomerList) {
            if ("0".equals(wallchartCustomer.getCustomerStatus())) {
                ++defaultNumber;
                continue;
            }
            if ("1".equals(wallchartCustomer.getCustomerStatus())) {
                ++connectedNumber;
                continue;
            }
            if ("2".equals(wallchartCustomer.getCustomerStatus())) {
                ++followNumber;
                continue;
            }
            if ("3".equals(wallchartCustomer.getCustomerStatus())) {
                ++signNumber;
                continue;
            }
            if (!"4".equals(wallchartCustomer.getCustomerStatus())) continue;
            ++closedNumber;
        }
        fullViewVo.setCustomerCount(allCustomerList.size());
        fullViewVo.setDefaultCount(defaultNumber);
        fullViewVo.setConnectedCount(connectedNumber);
        fullViewVo.setFollowCount(followNumber);
        fullViewVo.setSignCount(signNumber);
        fullViewVo.setClosedCount(closedNumber);
    }

    private void customerCountByAreaStatistics(WallchartFullViewVo fullViewVo, List<WallchartCustomer> wallchartCustomerList, String provinceCode) {
        ArrayList<WallchartFullViewVo> areaCustomerCountVoList = new ArrayList<WallchartFullViewVo>();
        HashMap<String, WallchartFullViewVo> areaCustomerCountMap = new HashMap<String, WallchartFullViewVo>();
        for (WallchartCustomer wallchartCustomer : wallchartCustomerList) {
            String areaCode = String.valueOf(wallchartCustomer.getProvinceCode());
            if (ToolUtil.isNotEmpty((Object)provinceCode)) {
                areaCode = String.valueOf(wallchartCustomer.getCityCode());
            }
            WallchartFullViewVo areaCustomerCountVo = this.getAreaCustomerVo(areaCode, areaCustomerCountMap);
            areaCustomerCountVo.setCustomerCount(areaCustomerCountVo.getCustomerCount() + 1);
            if ("0".equals(wallchartCustomer.getCustomerStatus())) {
                areaCustomerCountVo.setDefaultCount(areaCustomerCountVo.getDefaultCount() + 1);
            } else if ("1".equals(wallchartCustomer.getCustomerStatus())) {
                areaCustomerCountVo.setConnectedCount(areaCustomerCountVo.getConnectedCount() + 1);
            } else if ("2".equals(wallchartCustomer.getCustomerStatus())) {
                areaCustomerCountVo.setFollowCount(areaCustomerCountVo.getFollowCount() + 1);
            } else if ("3".equals(wallchartCustomer.getCustomerStatus())) {
                areaCustomerCountVo.setSignCount(areaCustomerCountVo.getSignCount() + 1);
            }
            if (areaCustomerCountVo.getCustomerCount() != 1) continue;
            areaCustomerCountVoList.add(areaCustomerCountVo);
            areaCustomerCountMap.put(areaCode, areaCustomerCountVo);
        }
        fullViewVo.setAreaCustomerCountList(areaCustomerCountVoList);
    }

    private WallchartFullViewVo getAreaCustomerVo(String areaCode, Map<String, WallchartFullViewVo> areaCustomerCountMap) {
        WallchartFullViewVo areaCustomerCountVo;
        if (null == areaCustomerCountMap.get(areaCode)) {
            areaCustomerCountVo = new WallchartFullViewVo();
            areaCustomerCountVo.setAreaCode(areaCode);
            areaCustomerCountVo.setCustomerCount(0);
            areaCustomerCountVo.setDefaultCount(0);
            areaCustomerCountVo.setConnectedCount(0);
            areaCustomerCountVo.setFollowCount(0);
            areaCustomerCountVo.setSignCount(0);
        } else {
            areaCustomerCountVo = areaCustomerCountMap.get(areaCode);
        }
        return areaCustomerCountVo;
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(WallchartAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getWallchartScreening();
        }
        IWallchartAssociativeQueryService adapterService = this.wallchartAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("input_5Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    @Transactional
    public ApiResponse<?> updateDelFlagByIds(List<String> wallchartIds) {
        List teamList;
        int total = wallchartIds.size();
        List wallchartList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Wallchart::getDelFlag, (Object)"0")).in(Wallchart::getWallchartId, wallchartIds));
        if (CollectionUtil.isEmpty((Collection)wallchartList)) {
            return ApiResponse.fail((String)"\u6240\u9009\u6302\u56fe\u5df2\u5220\u9664");
        }
        Map<Long, Wallchart> dtoMap = wallchartList.stream().collect(Collectors.toMap(Wallchart::getWallchartId, wallchart -> wallchart));
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<Wallchart> transferWallchartList = new ArrayList<Wallchart>();
        for (Object wallchart2 : wallchartList) {
            Long wallchartId = ((Wallchart)wallchart2).getWallchartId();
            int transferPermission = this.getOperatePermission((Wallchart)wallchart2, user);
            if (transferPermission < 0) continue;
            transferWallchartList.add((Wallchart)wallchart2);
            wallchartIds.remove(String.valueOf(wallchartId));
        }
        if (CollectionUtil.isNotEmpty(wallchartIds) && CollectionUtil.isNotEmpty((Collection)(teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getBusinessId, wallchartIds)).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"14"))))) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                Wallchart wallchart3;
                if (!"1".equals(teamMeberEntity.getModifyPower()) || (wallchart3 = dtoMap.get(teamMeberEntity.getBusinessId())) == null) continue;
                transferWallchartList.add(wallchart3);
            }
        }
        if (CollectionUtil.isEmpty(transferWallchartList)) {
            return ApiResponse.fail((String)(String.format("\u6302\u56fe\u4f5c\u6218\uff1a\u5220\u9664\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", total, total) + "\u65e0\u6743\u9650"));
        }
        int canTransferNums = transferWallchartList.size();
        int notUnpublishedCount = 0;
        int successCount = 0;
        ArrayList<String> canDeleteIds = new ArrayList<String>();
        for (Wallchart wallchart4 : transferWallchartList) {
            if (!"1".equals(wallchart4.getWallchartStatus())) {
                ++notUnpublishedCount;
                continue;
            }
            canDeleteIds.add(String.valueOf(wallchart4.getWallchartId()));
            ++successCount;
        }
        if (canDeleteIds.size() > 0) {
            ((WallchartMapper)this.baseMapper).updateDelFlagByIds(canDeleteIds, "1");
            this.teamMeberMapper.updateDelFlagByIds(null, "1", canDeleteIds);
        }
        String msg = String.format("\u6302\u56fe\u4f5c\u6218\uff1a\u5220\u9664\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", successCount, total - successCount);
        msg = msg + "\u65e0\u6743\u9650" + (total - canTransferNums) + "\u6761\uff0c\u4e0d\u662f\u672a\u53d1\u5e03\u72b6\u6001\u7684" + notUnpublishedCount + "\u6761\u3002";
        return ApiResponse.success((String)msg);
    }

    @Override
    @Transactional
    public Boolean publishOrClose(WallchartDto dto) {
        if (dto.getWallchartStatus() != null) {
            SecurityUser user = BaseSecurityUtil.getUser();
            String wallchartStatus = dto.getWallchartStatus().get(0);
            ((WallchartMapper)this.baseMapper).updateWallchartStatusById(dto.getWallchartId(), wallchartStatus);
            Wallchart wallchart = (Wallchart)((WallchartMapper)this.baseMapper).selectById(dto.getWallchartId());
            ArrayList<String> userList = new ArrayList<String>();
            String title = "";
            String content = "";
            String contentUnify = "";
            if ("2".equals(wallchartStatus)) {
                title = user.getDeptName() + "\u90e8\u95e8" + user.getUserName() + "\u53d1\u5e03\u4e86\u65b0\u7684\u6302\u56fe\u4f5c\u6218";
                content = "\u6302\u56fe\u4f5c\u6218\u540d\u79f0\u3010" + wallchart.getWallchartName() + "\u3011\uff0c\u8bf7\u67e5\u9605";
                contentUnify = "\u3010\u53d1\u5e03\u6302\u56fe\u63d0\u9192\u3011" + user.getDeptName() + "\u90e8\u95e8" + user.getUserName() + "\u53d1\u5e03\u4e86\u65b0\u7684\u6302\u56fe\u4f5c\u6218\u3010" + wallchart.getWallchartName() + "\u3011\uff0c\u8bf7\u67e5\u9605\u3002";
                userList.addAll(this.getAppliedRangeUserList(wallchart));
                this.wallchartCustomerService.updateCustomerStatusByWallchart(wallchart);
                this.saveTrackRecord(wallchart.getWallchartId(), wallchart.getWallchartName(), RecordProductTypeEnum.PRODUCE_RELEASE.getId(), wallchart.getWallchartName());
            } else if ("3".equals(wallchartStatus)) {
                title = "\u6302\u56fe\u4f5c\u6218\u5df2\u5173\u95ed";
                content = "\u6302\u56fe\u4f5c\u6218\u540d\u79f0\u3010" + wallchart.getWallchartName() + "\u3011\uff0c\u8bf7\u4e86\u89e3\u6302\u56fe\u6267\u884c\u60c5\u51b5";
                contentUnify = "\u3010\u6302\u56fe\u5173\u95ed\u63d0\u9192\u3011\u6302\u56fe\u4f5c\u6218\u3010" + wallchart.getWallchartName() + "\u3011\u5df2\u5173\u95ed\uff0c\u8bf7\u4e86\u89e3\u6302\u56fe\u6267\u884c\u60c5\u51b5\u3002";
                userList.addAll(this.wallchartCustomerService.getTeamMemberAndFocusUser(wallchart.getWallchartId()));
                this.saveTrackRecord(wallchart.getWallchartId(), wallchart.getWallchartName(), RecordProductTypeEnum.PRODUCE_FILE.getId(), wallchart.getWallchartName());
            }
            if (CollectionUtil.isNotEmpty(userList)) {
                LocalDateTime date = LocalDateTime.now();
                List distinctList = userList.stream().distinct().collect(Collectors.toList());
                ArrayList<EimPushMessage> eimPushMessageList = new ArrayList<EimPushMessage>();
                EimPushMessage eimPushMessage = new EimPushMessage(title, content, "/crm/gt/gtzz/xxzl", dto.getWallchartId().toString(), distinctList);
                eimPushMessageList.add(eimPushMessage);
                if (CollectionUtil.isNotEmpty(eimPushMessageList)) {
                    eimPushMessageList.forEach(message -> EimPushUtil.pushJqxArticleMessage((String)message.getTitle(), (String)message.getContent(), (String)message.getUrl(), (String)message.getBid(), (List)message.getSendUsers()));
                }
                ArrayList<AddSysMessageType> addSysMessageTypeList = new ArrayList<AddSysMessageType>();
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/wallchart/wallDetails" + "?row=" + dto.getWallchartId();
                StringBuilder receiveUserIds = new StringBuilder();
                for (int i = 0; i < distinctList.size(); ++i) {
                    String userId = (String)distinctList.get(i);
                    receiveUserIds.append(userId).append(",");
                    if ((i + 1) % 50 != 0 && i + 1 != distinctList.size()) continue;
                    receiveUserIds.deleteCharAt(receiveUserIds.length() - 1);
                    AddSysMessageType addSysMessageType = new AddSysMessageType();
                    addSysMessageType.setBusinessAddress(unifyWebUrl);
                    UnifyUtil.defaultMessage((AddSysMessageType)addSysMessageType, (String)contentUnify, (LocalDateTime)date, (SecurityUser)user, (String)receiveUserIds.toString(), (String)user.getUserName(), (String)unifyWebUrl, (String)"");
                    addSysMessageTypeList.add(addSysMessageType);
                    receiveUserIds.setLength(0);
                }
                if (CollectionUtil.isNotEmpty(addSysMessageTypeList)) {
                    for (AddSysMessageType messageType : addSysMessageTypeList) {
                        UnifyUtil.sendMessage((AddSysMessageType)messageType);
                    }
                }
            }
        }
        return true;
    }

    @Override
    @Transactional
    public TransferBatchResultVo wallchartTransferBatch(List<WallchartDto> dtos) {
        TransferBatchResultVo customerResultVo = new TransferBatchResultVo();
        customerResultVo.setTransferResult(Boolean.valueOf(true));
        if (CollectionUtil.isEmpty(dtos)) {
            customerResultVo.setTransferResult(Boolean.valueOf(false));
            customerResultVo.setMsgList(Collections.singletonList("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u7f3a\u5c11\u53c2\u6570"));
            return customerResultVo;
        }
        int total = dtos.size();
        int canTransferNums = 0;
        List<WallchartDto> transferList = this.getTransferList(dtos);
        if (CollectionUtil.isEmpty(transferList)) {
            String msg = String.format("\u6302\u56fe\u4f5c\u6218\uff1a\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", canTransferNums, total);
            customerResultVo.setTransferResult(Boolean.valueOf(false));
            customerResultVo.setMsgList(Collections.singletonList(msg + "\u65e0\u6743\u9650"));
            return customerResultVo;
        }
        canTransferNums = transferList.size();
        int noPermissionCount = total - canTransferNums;
        int chargeSameCount = 0;
        int successCount = 0;
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId((String)dtos.get(0).getNewChargePersonId());
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName((String)newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        ArrayList<WallchartDto> updateWallchartList = new ArrayList<WallchartDto>();
        ArrayList<TeamMeberEntity> deleteTeamMemberList = new ArrayList<TeamMeberEntity>();
        ArrayList<TeamMeberEntity> updateTeamMemberList = new ArrayList<TeamMeberEntity>();
        ArrayList<TeamMeberEntity> insertTeamMemberList = new ArrayList<TeamMeberEntity>();
        for (WallchartDto dto : transferList) {
            String keepFlag = dto.getKeepFlag();
            String oldChargePersonId = dto.getOldChargePersonId();
            if (newChargePersonId.equals(oldChargePersonId)) {
                ++chargeSameCount;
                continue;
            }
            LocalDateTime date = LocalDateTime.now();
            Long wallchartId = dto.getWallchartId();
            this.addUpdateWallcharToList(updateWallchartList, date, userId, userName, newChargePersonId, newChargePersonName, newOwnDepartment, newOwnDepartmentName, wallchartId);
            if ("0".equals(keepFlag)) {
                this.addDeleteTeamMemberToList(deleteTeamMemberList, Long.parseLong(oldChargePersonId), wallchartId);
            } else if ("1".equals(keepFlag)) {
                this.addUpdateTeamMemberToList(updateTeamMemberList, Long.parseLong(oldChargePersonId), wallchartId, "0", "6", null);
            }
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(wallchartId);
            teamMeberDto.setPersonId(Long.valueOf(Long.parseLong(newChargePersonId)));
            teamMeberDto.setDelFlag("0");
            teamMeberDto.setBusinessType("14");
            List list = this.teamMeberMapper.selectTeamMeberList(null, teamMeberDto);
            if (CollectionUtil.isEmpty((Collection)list) || list.size() == 0) {
                this.addInsertTeamMemberToList(insertTeamMemberList, newChargePersonName, Long.parseLong(newChargePersonId), wallchartId, "1", "1", date, "14", mapDepartment);
            } else {
                this.addUpdateTeamMemberToList(updateTeamMemberList, Long.parseLong(newChargePersonId), wallchartId, "1", null, "1");
            }
            ++successCount;
        }
        if (CollectionUtil.isNotEmpty(updateWallchartList)) {
            ((WallchartMapper)this.baseMapper).updateChargePersonBatch(updateWallchartList);
        }
        if (CollectionUtil.isNotEmpty(deleteTeamMemberList)) {
            this.teamMeberMapper.deleteChargePersonBatch(deleteTeamMemberList);
        }
        if (CollectionUtil.isNotEmpty(updateTeamMemberList)) {
            this.teamMeberMapper.updateIsChargeBatch(updateTeamMemberList);
        }
        if (CollectionUtil.isNotEmpty(insertTeamMemberList)) {
            this.teamMeberService.saveBatch(insertTeamMemberList);
        }
        if (successCount == dtos.size()) {
            customerResultVo.setMsgList(Collections.singletonList("\u8f6c\u79fb\u6210\u529f"));
        } else {
            String msg = String.format("\u6302\u56fe\u4f5c\u6218\uff1a\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", successCount, noPermissionCount + chargeSameCount);
            msg = msg + "\u65e0\u6743\u9650" + noPermissionCount + "\u6761\uff0c\u65b0\u65e7\u8d1f\u8d23\u4eba\u4e00\u81f4" + chargeSameCount + "\u6761\u3002";
            customerResultVo.setMsgList(Collections.singletonList(msg));
        }
        return customerResultVo;
    }

    @Override
    public Boolean refreshCustomerStatus(WallchartDto dto) {
        Wallchart wallchart = (Wallchart)((WallchartMapper)this.baseMapper).selectById(dto.getWallchartId());
        if (!"3".equals(wallchart.getWallchartStatus())) {
            return this.wallchartCustomerService.updateCustomerStatusByWallchart(wallchart);
        }
        return false;
    }

    @Override
    public WallchartVo getWallchartDetail(Long wallchartId) {
        if (CommonConstant.noPermission.equals(this.isOperate(wallchartId))) {
            return null;
        }
        if (wallchartId == null) {
            throw new BaseException("\u6302\u56fe\u4f5c\u6218id\u4e3a\u7a7a");
        }
        WallchartRule wallchartRule = (WallchartRule)this.wallchartRuleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WallchartRule::getDelFlag, (Object)"0")).eq(WallchartRule::getWallchartId, (Object)wallchartId));
        WallchartCustomerDto customerDto = new WallchartCustomerDto();
        customerDto.setWallchartId(wallchartId);
        if (ToolUtil.isEmpty((Object)wallchartRule) || ToolUtil.isEmpty((Object)wallchartRule.getCustomerPermission())) {
            this.wallchartCustomerService.addConditionByCustomerPermission(customerDto, "1");
        } else {
            this.wallchartCustomerService.addConditionByCustomerPermission(customerDto, wallchartRule.getCustomerPermission());
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Wallchart entity = ((WallchartMapper)this.baseMapper).getWallchartDetail(wallchartId, user.getId(), customerDto);
        if (entity != null && !"1".equals(entity.getDelFlag())) {
            WallchartVo wallchartVo = (WallchartVo)BeanUtil.copy((Object)entity, WallchartVo.class);
            assert (wallchartVo != null);
            WallchartRuleVo wallchartRuleVo = (WallchartRuleVo)BeanUtil.copy((Object)wallchartRule, WallchartRuleVo.class);
            assert (wallchartRuleVo != null);
            wallchartRuleVo.setAppliedRange(wallchartVo.getAppliedRange());
            if (ToolUtil.isEmpty((Object)wallchartRuleVo.getCustomerPermission())) {
                wallchartRuleVo.setCustomerPermission("1");
            }
            wallchartVo.setWallchartRule(wallchartRuleVo);
            wallchartVo.setTeamMemberAmount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)wallchartVo.getWallchartId())).eq(TeamMeberEntity::getBusinessType, (Object)"14")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
            wallchartVo.setCharacterAmount(this.taskAPIService.selectTaskCount("14", wallchartVo.getWallchartId()));
            Wallchart wallchart = (Wallchart)this.getById(wallchartId);
            OpportunityQueryNoPageDto queryDto = new OpportunityQueryNoPageDto();
            if (!"1".equals(wallchartRule.getStatisticsBeforeStart())) {
                queryDto.setCreateDateStart(wallchart.getWallchartStartDate());
            }
            queryDto.setCreateDateEnd(wallchart.getWallchartEndDate());
            if (HussarUtils.isNotEmpty((Object)wallchart.getProductIds())) {
                queryDto.setProductIdList(Arrays.stream(wallchart.getProductIds().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            }
            List<WallchartCustomer> wallchartCustomerList = this.wallchartCustomerMapper.queryList(null, customerDto);
            List customerIdList = wallchartCustomerList.stream().map(WallchartCustomer::getSysCustomerId).filter(Objects::nonNull).collect(Collectors.toList());
            Integer count = 0;
            if (CollectionUtil.isNotEmpty(customerIdList)) {
                queryDto.setCustomerIdList(customerIdList);
                count = this.opportunityAPIService.selectOpportunityCountForWallChart(queryDto);
            }
            wallchartVo.setOpportunityCount(count);
            return wallchartVo;
        }
        return null;
    }

    @Override
    public Integer isOperate(Long wallchartId) {
        if (wallchartId == null) {
            return CommonConstant.noPermission;
        }
        Wallchart wallchart = (Wallchart)this.getById(wallchartId);
        SecurityUser user = BaseSecurityUtil.getUser();
        int rolePermission = this.getOperatePermission(wallchart, user);
        int teamPermission = CommonConstant.noPermission;
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)wallchart.getWallchartId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"14"));
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                if ("1".equals(teamMeberEntity.getModifyPower())) {
                    teamPermission = CommonConstant.otherRole;
                    continue;
                }
                teamPermission = CommonConstant.readOnly;
            }
        }
        int appliedRangePermission = CommonConstant.noPermission;
        if (Integer.parseInt("1") == this.isAppliedRangeUser(wallchart.getWallchartId())) {
            appliedRangePermission = CommonConstant.readOnly;
        }
        return Math.max(Math.max(rolePermission, teamPermission), appliedRangePermission);
    }

    @Override
    public Integer isAppliedRangeUser(Long wallchartId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Wallchart wallchart = (Wallchart)((WallchartMapper)this.baseMapper).selectById(wallchartId);
        if (ToolUtil.isNotEmpty((Object)wallchart.getAppliedRange())) {
            String[] appliedRangeArr = wallchart.getAppliedRange().split(",");
            List<Long> deptIdList = this.getAllDeptIdByParentId(appliedRangeArr);
            if (wallchart.getAppliedRange().contains(user.getId().toString()) || deptIdList.contains(user.getDeptId())) {
                return Integer.parseInt("1");
            }
            return Integer.parseInt("0");
        }
        return Integer.parseInt("1");
    }

    private void saveTrackRecord(Long businessId, String businessName, String productType, String recordContent) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setBusinessType("14");
        operateRecordDO.setProduceType(productType);
        operateRecordDO.setRecordContent(recordContent);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(businessId);
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.WALLCHART, businessId, businessName, LocalDateTime.now(), false, businessIds);
    }

    private List<String> getAppliedRangeUserList(Wallchart wallchart) {
        ArrayList<String> userIdList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)wallchart.getAppliedRange())) {
            String appliedRange = wallchart.getAppliedRange();
            String[] appliedRangeArr = appliedRange.split(",");
            List<Long> deptIdList = this.getAllDeptIdByParentId(appliedRangeArr);
            List userListByDepartmentId = this.organUserBoService.getUserListByDepartmentId(deptIdList);
            if (CollectionUtil.isNotEmpty((Collection)userListByDepartmentId)) {
                userListByDepartmentId.forEach(userVo -> userIdList.add(String.valueOf(userVo.getId())));
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysUsers::getId, Arrays.asList(appliedRangeArr));
            queryWrapper.eq(SysUsers::getAccountStatus, (Object)"1");
            List sysUsersList = this.sysUsersMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)sysUsersList) && sysUsersList.size() > 0) {
                sysUsersList.forEach(sysUser -> userIdList.add(String.valueOf(sysUser.getId())));
            }
        }
        if (CollectionUtil.isNotEmpty(userIdList)) {
            return userIdList.stream().distinct().collect(Collectors.toList());
        }
        return userIdList;
    }

    private List<Long> getAllDeptIdByParentId(String[] appliedRangeArr) {
        List departIdList = Arrays.stream(appliedRangeArr).map(String::trim).map(Long::parseLong).collect(Collectors.toList());
        return this.organUserBoService.getOrganByParentIdContainsParent(departIdList);
    }

    private SalesStatisticsDto wallchartOperate(WallchartDto dto) {
        String wallchartView;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (dto != null && StringUtil.isNotEmpty((Object)(wallchartView = dto.getWallchartView())) && !"0".equals(wallchartView)) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
        }
        return permissionDto;
    }

    private List<WallchartDto> getWallchartDtoList(WallchartDto wallchartDto) {
        ArrayList<WallchartDto> queryDtoList = new ArrayList<WallchartDto>();
        String view = wallchartDto.getWallchartView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long wallchartView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)wallchartView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"wallchart");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        WallchartDto queryDto = (WallchartDto)((Object)JSONObject.parseObject((String)queryValue, WallchartDto.class));
                        queryDto.setWallchartView(String.valueOf(wallchartView));
                        queryDtoList.add(this.wallchartQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.wallchartQueryCondition(wallchartDto));
        return queryDtoList;
    }

    private WallchartDto wallchartQueryCondition(WallchartDto dto) {
        String wallchartTimeFlag;
        String createTimeFlag;
        SecurityUser user;
        if (StringUtil.isEmpty((Object)dto.getWallchartView())) {
            dto.setWallchartView("1");
        }
        if (ToolUtil.isNotEmpty((Object)dto.getWallchartScreening())) {
            dto.setWallchartScreening(dto.getWallchartScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if ((user = BaseSecurityUtil.getUser()) == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        dto.setCurrentUserId(user.getUserId());
        ArrayList<String> chargePersonIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (String createPersonId : dto.getChargePersonIds()) {
                String translateUserId = CommonUtills.translateUserId((String)createPersonId);
                chargePersonIds.add(translateUserId);
            }
            dto.setTransChargePersonIds(chargePersonIds);
        }
        List<String> ownDepartments = dto.getOwnDepartments();
        ArrayList<String> cdpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(ownDepartments) && ownDepartments.size() > 0) {
            for (String cdpId : ownDepartments) {
                ArrayList ids;
                String cdpIsTemp = CommonUtills.translateDepId((String)cdpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)cdpIsTemp, ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                cdpIds.addAll(idsTemp);
            }
            dto.setTransOwnDepartmentIds(cdpIds);
        }
        if (ToolUtil.isNotEmpty((Object)(createTimeFlag = dto.getCreateTimeFlag())) && !"6".equals(createTimeFlag)) {
            DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)createTimeFlag);
            dto.setCreateStartTime(dateConvertVo.getStartDate());
            dto.setCreateFinalTime(dateConvertVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)(wallchartTimeFlag = dto.getWallchartTimeFlag())) && !"6".equals(wallchartTimeFlag)) {
            DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)wallchartTimeFlag);
            dto.setWallchartStartTime(dateConvertVo.getStartDate());
            dto.setWallchartFinalTime(dateConvertVo.getEndDate());
        }
        dto.setDelFlag("0");
        return dto;
    }

    private List<WallchartDto> getTransferList(List<WallchartDto> dtoList) {
        WallchartDto wallchartDto;
        if (CollectionUtil.isEmpty(dtoList)) {
            return null;
        }
        List wallchartIdList = dtoList.stream().map(WallchartDto::getWallchartId).collect(Collectors.toList());
        List wallchartList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Wallchart::getDelFlag, (Object)"0")).in(Wallchart::getWallchartId, wallchartIdList));
        if (CollectionUtil.isEmpty((Collection)wallchartList)) {
            return null;
        }
        Map<Long, WallchartDto> dtoMap = dtoList.stream().collect(Collectors.toMap(WallchartDto::getWallchartId, wallchartDtox -> wallchartDtox));
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<WallchartDto> transferWallchartList = new ArrayList<WallchartDto>();
        for (Wallchart wallchart : wallchartList) {
            int transferPermission;
            Long wallchartId = wallchart.getWallchartId();
            wallchartDto = dtoMap.get(wallchartId);
            if (wallchartDto != null) {
                wallchartDto.setWallchartName(wallchart.getWallchartName());
            }
            if ((transferPermission = this.getOperatePermission(wallchart, user).intValue()) < 0) continue;
            transferWallchartList.add(wallchartDto);
            wallchartIdList.remove(wallchartId);
        }
        if (CollectionUtil.isEmpty(wallchartIdList)) {
            return transferWallchartList;
        }
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getBusinessId, wallchartIdList)).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"14"));
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                if (!"1".equals(teamMeberEntity.getModifyPower()) || (wallchartDto = dtoMap.get(teamMeberEntity.getBusinessId())) == null) continue;
                transferWallchartList.add(wallchartDto);
            }
        }
        return transferWallchartList;
    }

    public Integer getOperatePermission(Wallchart wallchart, SecurityUser user) {
        Long parentId;
        List deptIds;
        List struList;
        if (wallchart == null || "1".equals(wallchart.getDelFlag())) {
            return CommonConstant.noPermission;
        }
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            return CommonConstant.companyLeader;
        }
        List leadershipRoles = DataPermission.getLeadershipRoles();
        if (DataPermission.isLeadship((List)userRoles, (List)leadershipRoles)) {
            struList = DataPermission.getStruCache();
            List struIds = DataPermission.getLeadershipBGList((Long)user.getUserId());
            ArrayList deptIdList = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)struIds)) {
                for (String struId : struIds) {
                    List deptIds2 = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf(struId));
                    deptIdList.addAll(deptIds2);
                }
            }
            if (CollectionUtil.isNotEmpty(deptIdList) && deptIdList.contains(wallchart.getOwnDepartment() == null ? "" : wallchart.getOwnDepartment().toString())) {
                return CommonConstant.leadership;
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) && CollectionUtil.isNotEmpty((Collection)(deptIds = DataPermission.getAllDeptIdByParentId((List)(struList = DataPermission.getStruCache()), (Long)(parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)user.getDeptId()))))) && deptIds.contains(wallchart.getOwnDepartment() == null ? "" : wallchart.getOwnDepartment().toString())) {
            return CommonConstant.bgLeader;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) && user.getDeptId().toString().equals(wallchart.getOwnDepartment() == null ? "" : wallchart.getOwnDepartment().toString())) {
            return CommonConstant.salesGM;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) && user.getDeptId().toString().equals(wallchart.getOwnDepartment() == null ? "" : wallchart.getOwnDepartment().toString())) {
            return CommonConstant.salesDirector;
        }
        if (user.getUserId().toString().equals(wallchart.getChargePersonId() == null ? "" : wallchart.getChargePersonId().toString())) {
            return CommonConstant.salesman;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getMarketingManager()))) {
            return CommonConstant.readOnly;
        }
        return CommonConstant.noPermission;
    }

    private void addUpdateWallcharToList(List<WallchartDto> updateWallchartList, LocalDateTime date, String userId, String userName, String newChargePersonId, String newChargePersonName, Long newOwnDepartment, String newOwnDepartmentName, Long wallchartId) {
        WallchartDto dto = new WallchartDto();
        dto.setWallchartId(wallchartId);
        dto.setChangeTime(date);
        dto.setChangePerson(userId);
        dto.setChangePersonName(userName);
        dto.setNewChargePersonId(newChargePersonId);
        dto.setNewChargePersonName(newChargePersonName);
        dto.setOwnDepartment(newOwnDepartment);
        dto.setOwnDepartmentName(newOwnDepartmentName);
        updateWallchartList.add(dto);
    }

    private void addDeleteTeamMemberToList(List<TeamMeberEntity> deleteTeamMemberList, Long personId, Long wallchartId) {
        TeamMeberEntity deleteTeamMember = new TeamMeberEntity();
        deleteTeamMember.setPersonId(personId);
        deleteTeamMember.setBusinessId(wallchartId);
        deleteTeamMemberList.add(deleteTeamMember);
    }

    private void addUpdateTeamMemberToList(List<TeamMeberEntity> updateTeamMemberList, Long personId, Long wallchartId, String isCharge, String memberRole, String modifyPower) {
        TeamMeberEntity updateTeamMember = new TeamMeberEntity();
        updateTeamMember.setPersonId(personId);
        updateTeamMember.setBusinessId(wallchartId);
        updateTeamMember.setIsCharge(isCharge);
        updateTeamMember.setMemberRole(memberRole);
        updateTeamMember.setModifyPower(modifyPower);
        updateTeamMemberList.add(updateTeamMember);
    }

    private void addInsertTeamMemberToList(List<TeamMeberEntity> insertTeamMemberList, String memberName, Long personId, Long businessId, String modifyPower, String isCharge, LocalDateTime date, String businessType, PersonWithDepInfo dep) {
        SecurityUser user = BaseSecurityUtil.getUser();
        TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
        teamMeberEntity.setTeamMeberId(Long.valueOf(CommonUtills.generateAssignId()));
        teamMeberEntity.setTeamMeberName(memberName);
        teamMeberEntity.setPersonId(personId);
        teamMeberEntity.setBusinessId(businessId);
        teamMeberEntity.setBusinessType(businessType);
        teamMeberEntity.setModifyPower(modifyPower);
        teamMeberEntity.setIsCharge(isCharge);
        teamMeberEntity.setCreatePerson(user.getUserId());
        teamMeberEntity.setCreatePersonName(user.getUserName());
        teamMeberEntity.setCreateTime(date);
        if ("0".equals(teamMeberEntity.getIsCharge())) {
            teamMeberEntity.setMemberRole("6");
        }
        if (ToolUtil.isNotEmpty((Object)dep)) {
            teamMeberEntity.setOwnDepartment(dep.getDepartmentId());
            teamMeberEntity.setOwnDepartmentName(dep.getDepartmentName());
        }
        teamMeberEntity.setUpdatePerson(user.getUserId());
        teamMeberEntity.setUpdateTime(date);
        teamMeberEntity.setUpdatePersonName(user.getUserName());
        teamMeberEntity.setDelFlag("0");
        insertTeamMemberList.add(teamMeberEntity);
    }

    @Override
    public Boolean saveTaskBatch(TaskAPIDto dto) {
        List chargePersonList = this.wallchartCustomerService.listByIds(dto.getWallchartCustomerList()).stream().map(WallchartCustomer::getChargePersonId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        dto.setChargePersonList(chargePersonList);
        return this.taskAPIService.saveTaskBatch(dto);
    }

    @Override
    public Page<WallchartOpportunityVo> queryOpportunityList(WallchartOpportunityDto dto) {
        Wallchart wallchart = (Wallchart)this.getById(dto.getWallchartId());
        OpportunityQueryNoPageDto queryDto = new OpportunityQueryNoPageDto();
        WallchartCustomerDto customerDto = new WallchartCustomerDto();
        customerDto.setWallchartId(dto.getWallchartId());
        WallchartRule wallchartRule = (WallchartRule)this.wallchartRuleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WallchartRule::getWallchartId, (Object)dto.getWallchartId())).eq(WallchartRule::getDelFlag, (Object)"0"));
        List<WallchartCustomer> wallchartCustomerList = this.wallchartCustomerMapper.queryList(null, customerDto);
        List customerIdList = wallchartCustomerList.stream().map(WallchartCustomer::getSysCustomerId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(customerIdList)) {
            return null;
        }
        queryDto.setCustomerId(dto.getCustomerId());
        queryDto.setCustomerIdList(customerIdList);
        if (!"1".equals(wallchartRule.getStatisticsBeforeStart())) {
            queryDto.setCreateDateStart(wallchart.getWallchartStartDate());
        }
        queryDto.setCreateDateEnd(wallchart.getWallchartEndDate());
        if (HussarUtils.isNotEmpty((Object)wallchart.getProductIds())) {
            queryDto.setProductIdList(Arrays.stream(wallchart.getProductIds().split(",")).map(Long::parseLong).collect(Collectors.toList()));
        }
        queryDto.setSearchKey(dto.getSearchKey().replaceAll("%", "/%").replaceAll("_", "/_"));
        queryDto.setStageIdList(dto.getOpportunityStageList());
        Page apiVoPage = new Page(dto.getCurrent().longValue(), dto.getSize().longValue());
        List apiVoList = this.opportunityAPIService.selectOpportunityForWallChart(apiVoPage, queryDto);
        apiVoPage.setRecords(apiVoList);
        ArrayList<WallchartOpportunityVo> wallchartOpportunityVoList = new ArrayList<WallchartOpportunityVo>();
        for (OpportunityAPIVo oav : apiVoList) {
            WallchartOpportunityVo wallchartOpportunityVo = new WallchartOpportunityVo();
            wallchartOpportunityVo.setOpportunityId(oav.getOpportunityId());
            wallchartOpportunityVo.setOpportunityName(oav.getOpportunityName());
            wallchartOpportunityVo.setCustomerStageName(oav.getCustomerStageName());
            wallchartOpportunityVo.setCustomerStageId(oav.getCustomerStageId());
            if (HussarUtils.isNotEmpty((Object)oav.getOpportunityAmount())) {
                wallchartOpportunityVo.setOpportunityAmount(String.valueOf(Double.parseDouble(oav.getOpportunityAmount()) / 10000.0));
            }
            wallchartOpportunityVo.setOpportunityState(oav.getState());
            wallchartOpportunityVo.setCustomerId(oav.getCustomerId());
            wallchartOpportunityVo.setCustomerReferredName(oav.getCustomerReferredName());
            wallchartOpportunityVo.setChargePersonName(oav.getChargePersonName());
            wallchartOpportunityVo.setCreateTime(oav.getCreateTime().toLocalDate());
            wallchartOpportunityVo.setCreatePersonName(oav.getCreatePersonName());
            wallchartOpportunityVo.setEndTime(oav.getEndTime());
            wallchartOpportunityVo.setOwnDepartmentName(oav.getOwnDepartmentName());
            wallchartOpportunityVo.setSuccessDate(oav.getSuccessDate());
            wallchartOpportunityVo.setOpopportunityFrom(oav.getOpopportunityFrom());
            wallchartOpportunityVo.setOpopportunityType(oav.getOpopportunityType());
            if (oav.getTrackTime() != null) {
                wallchartOpportunityVo.setTrackTime(oav.getTrackTime().toLocalDate());
            }
            wallchartOpportunityVo.setCreateTime(oav.getCreateTime().toLocalDate());
            wallchartOpportunityVoList.add(wallchartOpportunityVo);
        }
        Page page = new Page();
        page.setCurrent(apiVoPage.getCurrent());
        page.setSize(apiVoPage.getSize());
        page.setTotal(apiVoPage.getTotal());
        page.setRecords(wallchartOpportunityVoList);
        return page;
    }
}

