/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.marketing.wallchart.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.dict.IDictBoService;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.api.contact.service.IContactAPIService;
import com.jxdinfo.crm.core.api.contact.vo.ContactAPIVo;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryNoPageDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.BackfillInfoVo;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.dto.EimPushMessage;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.CrmLabelUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.ReadExcel;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.marketing.wallchart.dao.WallchartCustomerFailMapper;
import com.jxdinfo.crm.marketing.wallchart.dao.WallchartCustomerImportMapper;
import com.jxdinfo.crm.marketing.wallchart.dao.WallchartCustomerMapper;
import com.jxdinfo.crm.marketing.wallchart.dao.WallchartMapper;
import com.jxdinfo.crm.marketing.wallchart.dao.WallchartRuleMapper;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartCustomerDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartCustomerEntityDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartCustomerFailDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartCustomerImportDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartCustomerUpdateDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartEntityDto;
import com.jxdinfo.crm.marketing.wallchart.job.WallchartCustomerJob;
import com.jxdinfo.crm.marketing.wallchart.model.Wallchart;
import com.jxdinfo.crm.marketing.wallchart.model.WallchartCustomer;
import com.jxdinfo.crm.marketing.wallchart.model.WallchartCustomerFail;
import com.jxdinfo.crm.marketing.wallchart.model.WallchartCustomerImport;
import com.jxdinfo.crm.marketing.wallchart.model.WallchartRule;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartCustomerService;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartService;
import com.jxdinfo.crm.marketing.wallchart.vo.WallchartCustomerFailVo;
import com.jxdinfo.crm.marketing.wallchart.vo.WallchartCustomerVo;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WallchartCustomerServiceImpl
extends ServiceImpl<WallchartCustomerMapper, WallchartCustomer>
implements WallchartCustomerService {
    @Resource
    private CommonService commonService;
    @Resource
    private IStruUserAPIService struUserBoService;
    @Resource
    private IDictBoService dictBoService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private WallchartMapper wallchartMapper;
    @Resource
    private WallchartRuleMapper wallchartRuleMapper;
    @Resource
    private WallchartCustomerFailMapper wallchartCustomerFailMapper;
    @Resource
    private WallchartCustomerImportMapper wallchartCustomerImportMapper;
    @Resource
    private ILabelService labelService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private FocusService focusService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private IContactAPIService contactAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IDataRightBoService dataRightBoService;
    @Resource
    private WallchartService wallchartService;
    protected static final Logger logger = LoggerFactory.getLogger(WallchartCustomerJob.class);

    @Override
    public Page<WallchartCustomer> queryList(WallchartCustomerDto dto) {
        List opportunityAPIVoList;
        List<WallchartCustomer> list;
        DateConvertVo dateConvertVo;
        Page page = dto.getPage();
        WallchartRule wallchartRule = (WallchartRule)this.wallchartRuleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(WallchartRule::getWallchartId, (Object)dto.getWallchartId()));
        if (ToolUtil.isEmpty((Object)wallchartRule) || ToolUtil.isEmpty((Object)wallchartRule.getCustomerPermission())) {
            this.addConditionByCustomerPermission(dto, "1");
        } else {
            this.addConditionByCustomerPermission(dto, wallchartRule.getCustomerPermission());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getConnectDateFlag()) && !"6".equals(dto.getConnectDateFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getConnectDateFlag())) != null) {
            dto.setConnectDateStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setConnectDateEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (CollectionUtil.isEmpty(list = ((WallchartCustomerMapper)this.baseMapper).queryList((Page<WallchartCustomer>)page, dto))) {
            return page;
        }
        Wallchart wallchart = (Wallchart)this.wallchartMapper.selectById(dto.getWallchartId());
        List customerIdList = list.stream().map(WallchartCustomer::getSysCustomerId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(customerIdList)) {
            OpportunityQueryNoPageDto queryDto = new OpportunityQueryNoPageDto();
            if (!"1".equals(wallchartRule.getStatisticsBeforeStart())) {
                queryDto.setCreateDateStart(wallchart.getWallchartStartDate());
            }
            queryDto.setCreateDateEnd(wallchart.getWallchartEndDate());
            if (HussarUtils.isNotEmpty((Object)wallchart.getProductIds())) {
                queryDto.setProductIdList(Arrays.stream(wallchart.getProductIds().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            }
            queryDto.setCustomerIdList(customerIdList);
            queryDto.setStageIdList(dto.getOpportunityStageList().stream().map(Long::parseLong).collect(Collectors.toList()));
            opportunityAPIVoList = this.opportunityAPIService.selectOpportunityForWallChart(null, queryDto);
        } else {
            opportunityAPIVoList = new ArrayList();
        }
        Map<Long, List<OpportunityAPIVo>> customerIdOpportunityMap = opportunityAPIVoList.stream().collect(Collectors.groupingBy(OpportunityAPIVo::getCustomerId));
        List opportunityStageSortList = this.sysDicRefService.getDictByType("salesProcess_StageList").stream().map(DicSingle::getLabel).collect(Collectors.toList());
        for (WallchartCustomer wc : list) {
            HashMap<String, String> stageNameIdMap = new HashMap<String, String>();
            if (customerIdOpportunityMap.containsKey(wc.getSysCustomerId())) {
                for (OpportunityAPIVo opportunityAPIVo : customerIdOpportunityMap.get(wc.getSysCustomerId())) {
                    String stageName = opportunityAPIVo.getCustomerStageName();
                    if (!stageNameIdMap.containsKey(stageName)) {
                        stageNameIdMap.put(stageName, String.valueOf(opportunityAPIVo.getCustomerStageId()));
                        continue;
                    }
                    stageNameIdMap.put(stageName, (String)stageNameIdMap.get(stageName) + "," + opportunityAPIVo.getCustomerStageId());
                }
            }
            StringBuilder stageNameAll = new StringBuilder();
            String stageIdAll = "";
            int opportunityCount = 0;
            if (CollectionUtil.isNotEmpty((Collection)customerIdOpportunityMap.get(wc.getSysCustomerId()))) {
                opportunityCount = customerIdOpportunityMap.get(wc.getSysCustomerId()).size();
            }
            for (String stageName : opportunityStageSortList) {
                if (!stageNameIdMap.containsKey(stageName)) continue;
                if (stageNameAll.length() == 0) {
                    stageNameAll.append(stageName);
                    stageIdAll = (String)stageNameIdMap.get(stageName);
                    continue;
                }
                stageNameAll.append("\u3001").append(stageName);
            }
            wc.setOpportunityStageName(stageNameAll.toString());
            wc.setOpportunityStageId(stageIdAll);
            wc.setNewOpportunityCount(opportunityCount);
        }
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.WALLCUSTOMER.getModuleId());
            List customerIds = list.stream().map(WallchartCustomer::getSysCustomerId).collect(Collectors.toList());
            customerIds.removeAll(Collections.singleton(null));
            Map opportunityAmountMap = this.opportunityAPIService.selectOpportunityAmountByCustomerId(customerIds);
            list.forEach(customer -> {
                customer.setLabelName(CrmLabelUtil.getLabelName((List)labelList, (String)customer.getLabelId()));
                if (ToolUtil.isNotEmpty((Object)customer.getSysCustomerId()) && ToolUtil.isNotEmpty(opportunityAmountMap.get(customer.getSysCustomerId()))) {
                    customer.setOpportunityCount((Integer)opportunityAmountMap.get(customer.getSysCustomerId()));
                }
            });
        }
        page.setRecords(list);
        return page;
    }

    @Override
    @Transactional
    public String importWallchartCustomer(MultipartFile file, Long wallchartId) {
        List<WallchartCustomer> list;
        StringBuilder importSuccessCustomer = new StringBuilder();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WallchartRule::getWallchartId, (Object)wallchartId)).eq(WallchartRule::getDelFlag, (Object)"0");
        WallchartRule wallchartRule = (WallchartRule)this.wallchartRuleMapper.selectOne((Wrapper)queryWrapper);
        String relationType = "";
        if (ToolUtil.isNotEmpty((Object)wallchartRule)) {
            relationType = wallchartRule.getRelationType();
        }
        if (CollectionUtil.isNotEmpty(list = this.readExcelDataToList(file, wallchartId, relationType))) {
            int successCount = 0;
            int failCount = 0;
            int totalCount = list.size();
            ArrayList<WallchartCustomerFail> failList = new ArrayList<WallchartCustomerFail>();
            Long importRecordId = Long.parseLong(CommonUtills.generateAssignId());
            List<String> wallCustomerNameList = list.stream().map(WallchartCustomer::getWallchartCustomerName).collect(Collectors.toList());
            List<String> existCustomerList = ((WallchartCustomerMapper)this.baseMapper).queryExistWallchartCustomer(wallchartId, wallCustomerNameList);
            List sysCustomerIdList = list.stream().map(WallchartCustomer::getSysCustomerId).collect(Collectors.toList());
            sysCustomerIdList.removeAll(Collections.singleton(null));
            Map permissionByCustomerIds = this.customerAPIService.queryPermissionByCustomerIds(sysCustomerIdList);
            ArrayList<WallchartCustomer> insertWallchartCustomerList = new ArrayList<WallchartCustomer>();
            for (WallchartCustomer wallchartCustomer : list) {
                block12: {
                    int permissionFlag;
                    if (ToolUtil.isNotEmpty((Object)wallchartCustomer.getSysCustomerId()) && ToolUtil.isNotEmpty(permissionByCustomerIds.get(wallchartCustomer.getSysCustomerId())) && CommonConstant.noPermission.equals(permissionFlag = ((Integer)permissionByCustomerIds.get(wallchartCustomer.getSysCustomerId())).intValue())) {
                        this.addWallchartCustomerToImportFail(failList, wallchartCustomer, importRecordId, "\u60a8\u6ca1\u6709\u8be5\u5ba2\u6237\u7684\u6570\u636e\u6743\u9650\uff0c\u5bfc\u5165\u5931\u8d25");
                        ++failCount;
                        continue;
                    }
                    if (existCustomerList.contains(wallchartCustomer.getWallchartCustomerName())) {
                        this.addWallchartCustomerToImportFail(failList, wallchartCustomer, importRecordId, "\u56fe\u5ba2\u6237\u5df2\u5b58\u5728\uff0c\u5bfc\u5165\u5931\u8d25");
                        ++failCount;
                        continue;
                    }
                    if (ToolUtil.isEmpty((Object)wallchartCustomer.getSysCustomerId())) {
                        String wallchartCustomerName = wallchartCustomer.getWallchartCustomerName();
                        try {
                            BackfillInfoVo backfillInfoVo = this.commonService.getBackfillInfoByName(wallchartCustomerName);
                            if (ToolUtil.isNotEmpty((Object)backfillInfoVo)) {
                                wallchartCustomer.setProvinceCode(backfillInfoVo.getProvinceId());
                                wallchartCustomer.setCityCode(backfillInfoVo.getCityId());
                                wallchartCustomer.setCountryCode(backfillInfoVo.getDistrictId());
                                wallchartCustomer.setAddressDetail(backfillInfoVo.getRegLocation());
                                break block12;
                            }
                            this.addWallchartCustomerToImportFail(failList, wallchartCustomer, importRecordId, "\u4f01\u67e5\u67e5\u672a\u8bc6\u522b\u5230\u7684\u5ba2\u6237\u540d\u79f0\uff0c\u5bfc\u5165\u5931\u8d25");
                            ++failCount;
                        }
                        catch (Exception e) {
                            this.addWallchartCustomerToImportFail(failList, wallchartCustomer, importRecordId, "\u4f01\u67e5\u67e5\u672a\u8bc6\u522b\u5230\u7684\u5ba2\u6237\u540d\u79f0\uff0c\u5bfc\u5165\u5931\u8d25");
                            ++failCount;
                        }
                        continue;
                    }
                }
                insertWallchartCustomerList.add(wallchartCustomer);
                ++successCount;
                importSuccessCustomer.append(wallchartCustomer.getWallchartCustomerName()).append(",");
            }
            if (CollectionUtil.isNotEmpty(insertWallchartCustomerList)) {
                this.saveBatch(insertWallchartCustomerList);
            }
            String importResult = String.format("\u5171%d\u6761\uff0c\u5bfc\u5165\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002", totalCount, successCount, failCount);
            this.saveWallchartCustomerImportRecord(wallchartId, importRecordId, importResult, failCount);
            if (failList.size() > 0) {
                this.wallchartCustomerFailMapper.saveBatch(failList);
            }
            if (successCount > 0) {
                Wallchart wallchart = (Wallchart)this.wallchartMapper.selectById(wallchartId);
                importSuccessCustomer = new StringBuilder(importSuccessCustomer.substring(0, importSuccessCustomer.length() - 1));
                this.saveTrackRecord(wallchartId, wallchart.getWallchartName(), RecordProductTypeEnum.PRODUCE_IMPORT.getId(), importSuccessCustomer.toString());
                this.updateCustomerStatusByWallchart(wallchart);
            }
            return importResult;
        }
        return "\u5bfc\u5165\u6210\u529f";
    }

    @Override
    @Transactional
    public Boolean saveWallchartCustomer(WallchartEntityDto dto) {
        Long wallchartId = dto.getWallchartId();
        List<WallchartCustomerEntityDto> wallchartCustomerEntityDtoList = dto.getWallchartCustomerList();
        if (CollectionUtil.isNotEmpty(wallchartCustomerEntityDtoList)) {
            WallchartCustomerEntityDto wallchartCustomerEntityDto = wallchartCustomerEntityDtoList.get(0);
            SecurityUser user = BaseSecurityUtil.getUser();
            LocalDateTime date = LocalDateTime.now();
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WallchartRule::getWallchartId, (Object)wallchartId)).eq(WallchartRule::getDelFlag, (Object)"0");
            WallchartRule wallchartRule = (WallchartRule)this.wallchartRuleMapper.selectOne((Wrapper)queryWrapper);
            List customerByNameVoList = this.customerAPIService.selectCustomerByNameNoPermission(Collections.singletonList(wallchartCustomerEntityDto.getWallchartCustomerName()), null, null);
            Map customerByNameVoMap = customerByNameVoList.stream().collect(Collectors.toMap(CustomerAPIVo::getCustomerName, Function.identity()));
            WallchartCustomer wallchartCustomer = new WallchartCustomer();
            BeanUtil.copy((Object)wallchartCustomerEntityDto, (Object)wallchartCustomer);
            wallchartCustomer.setWallchartId(wallchartId);
            if (ToolUtil.isNotEmpty((Object)wallchartRule)) {
                if ("1".equals(wallchartRule.getRelationType())) {
                    if (null != customerByNameVoMap.get(wallchartCustomer.getWallchartCustomerName())) {
                        CustomerAPIVo customerVo = (CustomerAPIVo)customerByNameVoMap.get(wallchartCustomer.getWallchartCustomerName());
                        BeanUtil.copyProperties((Object)customerVo, (Object)wallchartCustomer);
                        wallchartCustomer.setProvinceCode(Long.parseLong(customerVo.getProvince()));
                        wallchartCustomer.setCityCode(Long.parseLong(customerVo.getCity()));
                        wallchartCustomer.setCountryCode(Long.parseLong(customerVo.getCounty()));
                        wallchartCustomer.setSysCustomerId(customerVo.getCustomerId());
                        wallchartCustomer.setSysCustomerName(customerVo.getCustomerName());
                        wallchartCustomer.setSysCustomerChargeUser(customerVo.getChargePersonId());
                        wallchartCustomer.setSysCustomerChargeUserName(customerVo.getChargePersonName());
                    }
                } else if ("2".equals(wallchartRule.getRelationType())) {
                    System.out.println("\u5e73\u53f0\u6682\u4e0d\u652f\u6301\u6309\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u7cbe\u786e\u5339\u914d");
                }
            }
            if ("0".equals(dto.getSaveFlag())) {
                this.customerDefaultInfo(wallchartCustomer);
                this.save(wallchartCustomer);
                this.saveTrackRecord(wallchartId, wallchartCustomer.getWallchartCustomerName(), RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId(), null);
            } else if ("1".equals(dto.getSaveFlag())) {
                wallchartCustomer.setLastTime(date);
                wallchartCustomer.setLastEditor(user.getUserId());
                wallchartCustomer.setLastEditorName(user.getUserName());
                ((WallchartCustomerMapper)this.baseMapper).clearProvinceCityCountryAddress(wallchartCustomer.getWallchartCustomerId());
                this.updateById(wallchartCustomer);
            }
            if (HussarUtils.isNotEmpty((Object)wallchartCustomerEntityDto.getSaveLabelDto()) && HussarUtils.isNotEmpty((Object)wallchartCustomerEntityDto.getSaveLabelDto().getAddLabelIds())) {
                wallchartCustomerEntityDto.getSaveLabelDto().setBusinessId(wallchartCustomer.getWallchartCustomerId());
                wallchartCustomerEntityDto.getSaveLabelDto().setChooseBatch(Boolean.valueOf(false));
                wallchartCustomerEntityDto.getSaveLabelDto().setModuleId("wallCustomer");
                this.labelService.userSaveLabel(wallchartCustomerEntityDto.getSaveLabelDto());
            }
            Wallchart wallchart = (Wallchart)this.wallchartMapper.selectById(wallchartId);
            this.updateCustomerStatusByWallchart(wallchart);
        }
        return true;
    }

    @Override
    public Boolean progressInfoEditBatch(WallchartCustomerUpdateDto dto) {
        if (HussarUtils.isNotEmpty((Object)dto.getCloseReason())) {
            WallchartDto refreshDto = new WallchartDto();
            refreshDto.setWallchartId(dto.getWallchartId());
            this.wallchartService.refreshCustomerStatus(refreshDto);
            if (!this.checkCustomerStatus(dto.getWallchartCustomerList()).booleanValue()) {
                throw new BaseException("\u6240\u9009\u6570\u636e\u5305\u542b\u5df2\u7b7e\u7ea6 \u6216 \u5df2\u5173\u95ed\u6570\u636e\uff0c\u65e0\u6cd5\u5173\u95ed");
            }
        }
        Long wallchartId = dto.getWallchartId();
        List wallchartCustomerList = this.listByIds(dto.getWallchartCustomerList());
        if (ToolUtil.isNotEmpty((Object)wallchartCustomerList)) {
            SecurityUser user = BaseSecurityUtil.getUser();
            LocalDateTime date = LocalDateTime.now();
            ArrayList<WallchartCustomer> updateCustomerList = new ArrayList<WallchartCustomer>();
            for (WallchartCustomer wallchartCustomer : wallchartCustomerList) {
                if (ToolUtil.isNotEmpty((Object)dto.getCloseReason()) && !"3".equals(wallchartCustomer.getCustomerStatus()) && !"4".equals(wallchartCustomer.getCustomerStatus())) {
                    wallchartCustomer.setCloseReason(dto.getCloseReason());
                    wallchartCustomer.setCustomerStatus("4");
                }
                if (ToolUtil.isNotEmpty((Object)dto.getProgressInfo())) {
                    wallchartCustomer.setProgressInfo(dto.getProgressInfo());
                }
                wallchartCustomer.setLastTime(date);
                wallchartCustomer.setLastEditor(user.getUserId());
                wallchartCustomer.setLastEditorName(user.getUserName());
                updateCustomerList.add(wallchartCustomer);
            }
            this.updateBatchById(updateCustomerList);
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean introduceCustomer(WallchartEntityDto dto) {
        Long wallchartId = dto.getWallchartId();
        List<WallchartCustomerEntityDto> wallchartCustomerEntityDtoList = dto.getWallchartCustomerList();
        if (CollectionUtil.isNotEmpty(wallchartCustomerEntityDtoList)) {
            StringBuilder introduceCustomer = new StringBuilder();
            ArrayList<WallchartCustomer> insertWallchartCustomerList = new ArrayList<WallchartCustomer>();
            for (WallchartCustomerEntityDto wallchartCustomerEntityDto : wallchartCustomerEntityDtoList) {
                WallchartCustomer wallchartCustomer = new WallchartCustomer();
                BeanUtil.copy((Object)wallchartCustomerEntityDto, (Object)wallchartCustomer);
                wallchartCustomer.setWallchartId(wallchartId);
                this.customerDefaultInfo(wallchartCustomer);
                insertWallchartCustomerList.add(wallchartCustomer);
                introduceCustomer.append(wallchartCustomer.getWallchartCustomerName()).append("\uff0c");
            }
            if (CollectionUtil.isNotEmpty(insertWallchartCustomerList)) {
                this.saveBatch(insertWallchartCustomerList);
            }
            Wallchart wallchart = (Wallchart)this.wallchartMapper.selectById(wallchartId);
            this.updateCustomerStatusByWallchart(wallchart);
            introduceCustomer = new StringBuilder(introduceCustomer.substring(0, introduceCustomer.length() - 1));
            this.saveTrackRecord(wallchartId, wallchart.getWallchartName(), RecordProductTypeEnum.PRODUCE_INTRODUCE.getId(), introduceCustomer.toString());
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean customerAllocation(List<WallchartCustomerDto> dtos) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        LocalDateTime date = LocalDateTime.now();
        String newChargePersonId = CommonUtills.translateUserId((String)dtos.get(0).getNewChargePersonId());
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName((String)newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        ArrayList<WallchartCustomerDto> updateWallchartCustomerList = new ArrayList<WallchartCustomerDto>();
        ArrayList<EimPushMessage> eimPushMessageList = new ArrayList<EimPushMessage>();
        ArrayList<AddSysMessageType> addSysMessageTypeList = new ArrayList<AddSysMessageType>();
        StringBuilder allocationCustomer = new StringBuilder();
        for (WallchartCustomerDto dto : dtos) {
            Long wallchartCustomerId = dto.getWallchartCustomerId();
            String oldChargePersonId = dto.getOldChargePersonId();
            if (ToolUtil.isNotEmpty((Object)oldChargePersonId) && newChargePersonId.equals(oldChargePersonId)) continue;
            this.addUpdateWallchartCustomerToList(updateWallchartCustomerList, date, userId, userName, newChargePersonId, newChargePersonName, newOwnDepartment, newOwnDepartmentName, wallchartCustomerId);
            String wallchartCustomerName = dto.getWallchartCustomerName();
            allocationCustomer.append(wallchartCustomerName).append("\uff0c");
            ArrayList<String> userIdList = new ArrayList<String>();
            userIdList.add(dto.getNewChargePersonId());
            String title = user.getUserName() + "\u5c06\u56fe\u5ba2\u6237\u5206\u914d\u7ed9\u4f60";
            String content = "\u56fe\u5ba2\u6237\u540d\u79f0\u3010" + wallchartCustomerName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
            this.addToEimPushMessageList(eimPushMessageList, title, content, wallchartCustomerId, userIdList);
            String contentUnify = "\u3010\u5206\u914d\u56fe\u5ba2\u6237\u63d0\u9192\u3011" + user.getUserName() + "\u5c06\u56fe\u5ba2\u6237\u5206\u914d\u7ed9\u4f60\uff0c\u56fe\u5ba2\u6237\u540d\u79f0\u3010" + wallchartCustomerName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            this.addToSysMessageTypeList(addSysMessageTypeList, contentUnify, date, userIdList, user, wallchartCustomerId);
        }
        if (CollectionUtil.isNotEmpty(updateWallchartCustomerList)) {
            ((WallchartCustomerMapper)this.baseMapper).updateChargePersonBatch(updateWallchartCustomerList);
            allocationCustomer = new StringBuilder(allocationCustomer.substring(0, allocationCustomer.length() - 1));
            Long wallchartCustomerId = dtos.get(0).getWallchartCustomerId();
            Wallchart wallchart = this.wallchartMapper.getWallchartByWallchartCustomerId(wallchartCustomerId);
            OperateRecordAPIVo operateRecordDo = new OperateRecordAPIVo();
            operateRecordDo.setProduceType(RecordProductTypeEnum.PRODUCE_DISTRIBUTE.getId());
            operateRecordDo.setDelflag("0");
            operateRecordDo.setContactId(Long.valueOf(Long.parseLong(newChargePersonId)));
            operateRecordDo.setContactName(newChargePersonName);
            this.operateRecordAPIService.saveOperateLog(operateRecordDo, CrmBusinessTypeEnum.WALLCUSTOMER, wallchart.getWallchartId(), allocationCustomer.toString(), date, false, Collections.singletonList(wallchart.getWallchartId()));
        }
        if (CollectionUtil.isNotEmpty(eimPushMessageList)) {
            for (EimPushMessage message : eimPushMessageList) {
                EimPushUtil.pushJqxArticleMessage((String)message.getTitle(), (String)message.getContent(), (String)message.getUrl(), (String)message.getBid(), (List)message.getSendUsers());
            }
        }
        if (CollectionUtil.isNotEmpty(addSysMessageTypeList)) {
            for (AddSysMessageType messageType : addSysMessageTypeList) {
                UnifyUtil.sendMessage((AddSysMessageType)messageType);
            }
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean deleteWallchartCustomerByIds(List<String> wallchartCustomerIds) {
        if (ToolUtil.isEmpty(wallchartCustomerIds)) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((WallchartCustomerMapper)this.baseMapper).updateDelFlagByIds(wallchartCustomerIds, "1");
        return true;
    }

    @Override
    public WallchartCustomerVo wallchartCustomerDetail(Long wallchartCustomerId) {
        WallchartCustomer wallchartCustomer = (WallchartCustomer)((WallchartCustomerMapper)this.baseMapper).selectById(wallchartCustomerId);
        if (ToolUtil.isEmpty((Object)wallchartCustomer)) {
            throw new BaseException("\u672a\u627e\u5230\u6302\u56fe\u5ba2\u6237");
        }
        List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.WALLCUSTOMER.getModuleId());
        wallchartCustomer.setLabelName(CrmLabelUtil.getLabelName((List)labelList, (String)wallchartCustomer.getLabelId()));
        WallchartCustomerVo wallchartCustomerVo = (WallchartCustomerVo)BeanUtil.copyProperties((Object)wallchartCustomer, WallchartCustomerVo.class);
        Wallchart wallchart = (Wallchart)this.wallchartMapper.selectById(wallchartCustomer.getWallchartId());
        assert (wallchartCustomerVo != null);
        wallchartCustomerVo.setWallchartStatus(wallchart.getWallchartStatus());
        wallchartCustomerVo.setWallchartChargePersonId(wallchart.getChargePersonId());
        return wallchartCustomerVo;
    }

    @Override
    public Boolean checkRepeat(WallchartCustomerDto dto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WallchartCustomer::getWallchartId, (Object)dto.getWallchartId());
        wrapper.eq(WallchartCustomer::getWallchartCustomerName, (Object)dto.getWallchartCustomerName());
        if (ToolUtil.isNotEmpty((Object)dto.getWallchartCustomerId())) {
            wrapper.ne(WallchartCustomer::getWallchartCustomerId, (Object)dto.getWallchartCustomerId());
        }
        wrapper.eq(WallchartCustomer::getDelFlag, (Object)"0");
        Long count = ((WallchartCustomerMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        return count > 0L;
    }

    @Override
    @Transactional
    public Boolean updateCustomerStatusByWallchart(Wallchart wallchart) {
        LambdaQueryWrapper customerQueryWrapper = new LambdaQueryWrapper();
        customerQueryWrapper.eq(WallchartCustomer::getWallchartId, (Object)wallchart.getWallchartId());
        customerQueryWrapper.eq(WallchartCustomer::getDelFlag, (Object)"0");
        List wallchartCustomerList = this.list((Wrapper)customerQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)wallchartCustomerList)) {
            LambdaQueryWrapper ruleQueryWrapper = new LambdaQueryWrapper();
            ruleQueryWrapper.eq(WallchartRule::getWallchartId, (Object)wallchart.getWallchartId());
            ruleQueryWrapper.eq(WallchartRule::getDelFlag, (Object)"0");
            List wallchartRuleList = this.wallchartRuleMapper.selectList((Wrapper)ruleQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)wallchartRuleList)) {
                WallchartRule wallchartRule = (WallchartRule)wallchartRuleList.get(0);
                return this.updateWallchartCustomerStatus(wallchart, wallchartCustomerList, wallchartRule);
            }
        }
        return false;
    }

    @Override
    public List<String> getTeamMemberAndFocusUser(Long wallchartId) {
        ArrayList<String> userIdList = new ArrayList<String>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TeamMeberEntity::getBusinessId, (Object)wallchartId)).eq(TeamMeberEntity::getBusinessType, (Object)"14")).eq(TeamMeberEntity::getDelFlag, (Object)"0");
        List teamMemberList = this.teamMeberService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)teamMemberList)) {
            teamMemberList.forEach(item -> userIdList.add(String.valueOf(item.getPersonId())));
        }
        LambdaQueryWrapper queryFocusWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryFocusWrapper.eq(FocusEntity::getBusinessId, (Object)wallchartId)).eq(FocusEntity::getBusinessType, (Object)"14");
        List focusList = this.focusService.list((Wrapper)queryFocusWrapper);
        if (HussarUtils.isNotEmpty((Object)focusList)) {
            focusList.forEach(item -> userIdList.add(String.valueOf(item.getCreatePersion())));
        }
        return userIdList;
    }

    @Override
    public void importTemplate(HttpServletResponse response) {
        ArrayList list = new ArrayList();
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u56fe\u5ba2\u6237\u5bfc\u5165\u6a21\u677f", WallchartCustomerImportDto.class);
    }

    @Override
    public Page<WallchartCustomerImport> queryImportRecordList(WallchartCustomerImportDto dto) {
        Page page = dto.getPage();
        List<WallchartCustomerImport> list = this.wallchartCustomerImportMapper.queryImportRecordList((Page<WallchartCustomerImport>)page, dto);
        page.setRecords(list);
        return page;
    }

    @Override
    public void downloadFailCustomer(HttpServletResponse response, WallchartCustomerFailDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getImportRecordId())) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WallchartCustomerFail::getImportRecordId, (Object)dto.getImportRecordId());
        List list = this.wallchartCustomerFailMapper.selectList((Wrapper)queryWrapper);
        List staffNumList = this.dictBoService.getDicValue("staff_nums", null, null);
        Map<String, Object> staffNumMap = staffNumList.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (key, value) -> value));
        List lastRevenueList = this.dictBoService.getDicValue("last_revenue", null, null);
        Map<String, Object> lastRevenueMap = lastRevenueList.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (key, value) -> value));
        List informationImportanceList = this.dictBoService.getDicValue("info_importance", null, null);
        Map<String, Object> informationImportanceMap = informationImportanceList.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (key, value) -> value));
        for (WallchartCustomerFail importFailCustomer : list) {
            if (ToolUtil.isNotEmpty((Object)importFailCustomer.getStaffNums()) && null != staffNumMap.get(importFailCustomer.getStaffNums())) {
                importFailCustomer.setStaffNums(staffNumMap.get(importFailCustomer.getStaffNums()).toString());
            }
            if (ToolUtil.isNotEmpty((Object)importFailCustomer.getLastRevenue()) && null != lastRevenueMap.get(importFailCustomer.getLastRevenue())) {
                importFailCustomer.setLastRevenue(lastRevenueMap.get(importFailCustomer.getLastRevenue()).toString());
            }
            if (!ToolUtil.isNotEmpty((Object)importFailCustomer.getInformationImportance()) || null == informationImportanceMap.get(importFailCustomer.getInformationImportance())) continue;
            importFailCustomer.setInformationImportance(informationImportanceMap.get(importFailCustomer.getInformationImportance()).toString());
        }
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u56fe\u5ba2\u6237\u5bfc\u5165\u5931\u8d25\u8bb0\u5f55", WallchartCustomerFailVo.class);
    }

    @Override
    @Transactional
    public Boolean toFormal(WallchartCustomerDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getWallchartCustomerId()) || ToolUtil.isEmpty((Object)dto.getSysCustomerId())) {
            return false;
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        WallchartCustomer wallchartCustomer = (WallchartCustomer)((WallchartCustomerMapper)this.baseMapper).selectById(dto.getWallchartCustomerId());
        ArrayList<Long> sysCustomerIdList = new ArrayList<Long>();
        sysCustomerIdList.add(dto.getSysCustomerId());
        List customerByIdVoList = this.customerAPIService.selectCustomerByIdNoPermission(sysCustomerIdList);
        Map<Long, CustomerAPIVo> customerByIdMap = customerByIdVoList.stream().collect(Collectors.toMap(CustomerAPIVo::getCustomerId, item -> item, (key, value) -> value));
        if (ToolUtil.isNotEmpty((Object)customerByIdMap.get(dto.getSysCustomerId()))) {
            CustomerAPIVo customerEntity = customerByIdMap.get(dto.getSysCustomerId());
            wallchartCustomer.setSysCustomerId(customerEntity.getCustomerId());
            wallchartCustomer.setSysCustomerName(customerEntity.getCustomerName());
            wallchartCustomer.setSysCustomerChargeUser(customerEntity.getChargePersonId());
            wallchartCustomer.setSysCustomerChargeUserName(customerEntity.getChargePersonName());
            wallchartCustomer.setCustomerShortName(customerEntity.getCustomerReferredName());
            wallchartCustomer.setSysCustomerCreateTime(customerEntity.getCreateTime());
            if (ToolUtil.isNotEmpty((Object)customerEntity.getSuperiorCustomerId())) {
                wallchartCustomer.setSuperiorCustomerId(Long.parseLong(customerEntity.getSuperiorCustomerId()));
            }
            BeanUtil.copyProperties((Object)customerEntity, (Object)wallchartCustomer);
        }
        ((WallchartCustomerMapper)this.baseMapper).updateById(wallchartCustomer);
        Wallchart wallchart = (Wallchart)this.wallchartMapper.selectById(wallchartCustomer.getWallchartId());
        if (ToolUtil.isNotEmpty((Object)wallchart)) {
            ArrayList<EimPushMessage> eimPushMessageList = new ArrayList<EimPushMessage>();
            ArrayList<AddSysMessageType> addSysMessageTypeList = new ArrayList<AddSysMessageType>();
            List<String> userList = this.getTeamMemberAndFocusUser(wallchart.getWallchartId());
            userList.add(String.valueOf(wallchart.getChargePersonId()));
            List<String> userIdList = userList.stream().distinct().collect(Collectors.toList());
            String title = "\u6302\u56fe\u4f5c\u6218\u3010" + wallchart.getWallchartName() + "\u3011\u4e2d\u7684\u56fe\u5ba2\u6237\u5df2\u8f6c\u6b63\u5f0f\u5ba2\u6237";
            String content = "\u56fe\u5ba2\u6237\u540d\u79f0\u3010" + wallchartCustomer.getWallchartCustomerName() + "\u3011\uff0c\u8bf7\u4e86\u89e3";
            this.addToEimPushMessageList(eimPushMessageList, title, content, dto.getWallchartCustomerId(), userIdList);
            String contentUnify = "\u3010\u56fe\u5ba2\u6237\u8f6c\u6b63\u5f0f\u5ba2\u6237\u63d0\u9192\u3011\u6302\u56fe\u4f5c\u6218\u3010" + wallchart.getWallchartName() + "\u3011\u4e2d\u7684\u56fe\u5ba2\u6237\u3010" + wallchartCustomer.getWallchartCustomerName() + "\u3011\u5df2\u8f6c\u6b63\u5f0f\u5ba2\u6237\uff0c\u8bf7\u4e86\u89e3\u3002";
            this.addToSysMessageTypeList(addSysMessageTypeList, contentUnify, date, userIdList, user, dto.getWallchartCustomerId());
            if (CollectionUtil.isNotEmpty(eimPushMessageList)) {
                for (EimPushMessage message : eimPushMessageList) {
                    EimPushUtil.pushJqxArticleMessage((String)message.getTitle(), (String)message.getContent(), (String)message.getUrl(), (String)message.getBid(), (List)message.getSendUsers());
                }
            }
            if (CollectionUtil.isNotEmpty(addSysMessageTypeList)) {
                for (AddSysMessageType messageType : addSysMessageTypeList) {
                    UnifyUtil.sendMessage((AddSysMessageType)messageType);
                }
            }
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateWallchartCustomerStatusBySysCustomerId(Long sysCustomerId) {
        logger.info("###########\u7cfb\u7edf\u5ba2\u6237\u4fe1\u606f\u53d1\u751f\u53d8\u5316\uff0c\u66f4\u65b0\u76f8\u5173\u56fe\u5ba2\u6237\u72b6\u6001###" + sysCustomerId);
        List<Wallchart> wallchartList = this.wallchartMapper.getWallchartListBySysCustomerId(sysCustomerId);
        logger.info("###########\u67e5\u8be2\u5230\u7684\u76f8\u5173\u6302\u56fe\u4f5c\u6218\u4e3a\uff1a" + JSON.toJSONString(wallchartList));
        if (CollectionUtil.isNotEmpty(wallchartList) && wallchartList.size() > 0) {
            List wallchartIds = wallchartList.stream().map(Wallchart::getWallchartId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(WallchartRule::getWallchartId, wallchartIds);
            queryWrapper.eq(WallchartRule::getDelFlag, (Object)"0");
            List wallchartRuleList = this.wallchartRuleMapper.selectList((Wrapper)queryWrapper);
            Map wallchartRuleMap = wallchartRuleList.stream().collect(Collectors.toMap(WallchartRule::getWallchartId, Function.identity()));
            logger.info("###########\u67e5\u8be2\u5230\u7684\u76f8\u5173\u6302\u56fe\u89c4\u5219\u4e3a\uff1a" + JSON.toJSONString(wallchartRuleMap));
            LambdaQueryWrapper customerQueryWrapper = new LambdaQueryWrapper();
            customerQueryWrapper.eq(WallchartCustomer::getSysCustomerId, (Object)sysCustomerId);
            customerQueryWrapper.eq(WallchartCustomer::getDelFlag, (Object)"0");
            List wallchartCustomerList = ((WallchartCustomerMapper)this.baseMapper).selectList((Wrapper)customerQueryWrapper);
            Map<Long, List<WallchartCustomer>> wallchartCustomerMap = wallchartCustomerList.stream().collect(Collectors.groupingBy(WallchartCustomer::getWallchartId));
            logger.info("###########\u67e5\u8be2\u5230\u7684\u76f8\u5173\u6302\u56fe\u5ba2\u6237\u4e3a\uff1a" + JSON.toJSONString(wallchartCustomerMap));
            wallchartList.forEach(wallchart -> {
                if (ToolUtil.isNotEmpty(wallchartRuleMap.get(wallchart.getWallchartId())) && ToolUtil.isNotEmpty(wallchartCustomerMap.get(wallchart.getWallchartId()))) {
                    logger.info("###########\u5f00\u59cb\u66f4\u65b0\u6302\u56fe\u4f5c\u6218\u3010" + wallchart.getWallchartName() + "\u3011\u4e0b\u7684\u56fe\u5ba2\u6237\u72b6\u6001");
                    WallchartRule wallchartRule = (WallchartRule)wallchartRuleMap.get(wallchart.getWallchartId());
                    List wallchartCustomers = (List)wallchartCustomerMap.get(wallchart.getWallchartId());
                    this.updateWallchartCustomerStatus((Wallchart)wallchart, wallchartCustomers, wallchartRule);
                    logger.info("###########\u6302\u56fe\u4f5c\u6218\u3010" + wallchart.getWallchartName() + "\u3011\u4e0b\u7684\u56fe\u5ba2\u6237\u72b6\u6001\uff0c\u66f4\u65b0\u7ed3\u675f");
                }
            });
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateWallchartCustomerStatus(Wallchart wallchart, List<WallchartCustomer> wallchartCustomerList, WallchartRule rule) {
        if (ToolUtil.isEmpty((Object)wallchart)) {
            return false;
        }
        logger.info("###########\u56fe\u5ba2\u6237\u72b6\u6001\u5f00\u59cb\u66f4\u65b0\u5566\uff0c\u6302\u56fe\u4f5c\u6218\u540d\u79f0\u3010" + wallchart.getWallchartName() + "\u3011\uff0c\u6302\u56fe\u4f5c\u6218id\uff1a\u3010" + wallchart.getWallchartId() + "\u3011");
        long start = System.currentTimeMillis();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String startDate = "";
        if ("0".equals(rule.getStatisticsBeforeStart())) {
            startDate = wallchart.getWallchartStartDate().toString();
        }
        String endDate = wallchart.getWallchartEndDate().toString() + " 23:59:59";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime createTimeStart = null;
        if (ToolUtil.isNotEmpty((Object)startDate)) {
            createTimeStart = LocalDateTime.parse(startDate + " 00:00:00", formatter);
        }
        LocalDateTime createTimeEnd = LocalDateTime.parse(endDate, formatter);
        List<Long> sysCustomerIdList = wallchartCustomerList.stream().map(WallchartCustomer::getSysCustomerId).collect(Collectors.toList());
        sysCustomerIdList.removeAll(Collections.singleton(null));
        List wallchartCustomerNameList = wallchartCustomerList.stream().map(WallchartCustomer::getWallchartCustomerName).collect(Collectors.toList());
        logger.info("**********1\u3001\u83b7\u53d6\u67e5\u8be2\u65f6\u95f4\u3001\u5ba2\u6237ID\u96c6\u5408\u3001\u5ba2\u6237\u540d\u79f0\u96c6\u5408\u7b49\u53c2\u6570\uff0c\u7ed3\u675f\uff0c\u7528\u65f6" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        Map<Long, ContactAPIVo> contractVoMap = this.getFirstContractByCustomerVoMap(sysCustomerIdList, createTimeStart, createTimeEnd);
        logger.info("**********2\u3001\u67e5\u8be2\u6240\u6709\u5ba2\u6237\u7684\u7b2c\u4e00\u4e2a\u8054\u7cfb\u4eba\uff0c\u7ed3\u675f\uff0c\u7528\u65f6" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        Map<Long, TrackRecordAPIVo> trackRecordVoMap = this.getFirstRecordByCustomerVoMap(sysCustomerIdList, createTimeStart, createTimeEnd);
        logger.info("**********3\u3001\u67e5\u8be2\u6240\u6709\u5ba2\u6237\u7684\u7b2c\u4e00\u6761\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u7ed3\u675f\uff0c\u7528\u65f6" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        List customerByNameVoList = this.customerAPIService.selectCustomerByNameNoPermission(wallchartCustomerNameList, createTimeStart, createTimeEnd);
        Map<Long, CustomerAPIVo> customerByNameVoMap = customerByNameVoList.stream().collect(Collectors.toMap(CustomerAPIVo::getCustomerId, Function.identity()));
        logger.info("**********4\u3001\u67e5\u8be2\u6240\u6709\u56fe\u5ba2\u6237\u540d\u79f0\u80fd\u7cbe\u786e\u5339\u914d\u7684\u5ba2\u6237\uff0c\u7ed3\u675f\uff0c\u7528\u65f6" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        ArrayList<Long> productIdList = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)wallchart) && ToolUtil.isNotEmpty((Object)wallchart.getProductIds())) {
            String[] productIdArr;
            for (String productId : productIdArr = wallchart.getProductIds().split(",")) {
                productIdList.add(Long.valueOf(productId));
            }
        }
        Map<Long, OpportunityAPIVo> opportunityVoMap = this.getOpportunityVoMap(sysCustomerIdList, productIdList, rule.getOpportunityStage(), createTimeStart, createTimeEnd);
        logger.info("**********5\u3001\u67e5\u8be2\u6240\u6709\u5ba2\u6237\u5728\u6302\u56fe\u89c4\u5219\u6307\u5b9a\u9636\u6bb5\u53ca\u4ee5\u540e\u7684\u5546\u673a\u96c6\u5408(\u4e0d\u7edf\u8ba1\u5e9f\u5f03\u3001\u8f93\u5355\u3001\u53ea\u8f6c\u5ba2\u6237)\uff0c\u7ed3\u675f\uff0c\u7528\u65f6" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        Map<Long, OpportunityAPIVo> opportunityWinVoMap = this.getWinOpportunityVoMap(sysCustomerIdList, productIdList, createTimeStart, createTimeEnd);
        logger.info("**********6\u3001\u67e5\u8be2\u6240\u6709\u5ba2\u6237\u8d62\u5355\u7684\u5546\u673a\u96c6\u5408\uff0c\u7ed3\u675f\uff0c\u7528\u65f6" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        List<String> userList = this.getTeamMemberAndFocusUser(wallchart.getWallchartId());
        userList.add(String.valueOf(wallchart.getChargePersonId()));
        List<String> userIdList = userList.stream().distinct().collect(Collectors.toList());
        logger.info("**********7\u3001\u67e5\u8be2\u6d88\u606f\u63a5\u6536\u4eba\u5458\uff0c\u7ed3\u675f\uff0c\u7528\u65f6" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        ArrayList<WallchartCustomer> updateWallchartCustomerList = new ArrayList<WallchartCustomer>();
        ArrayList<EimPushMessage> eimPushMessageList = new ArrayList<EimPushMessage>();
        ArrayList<AddSysMessageType> addSysMessageTypeList = new ArrayList<AddSysMessageType>();
        logger.info("#######\u5f00\u59cb\u5faa\u73af\u5224\u65ad\u56fe\u5ba2\u6237\u5f53\u524d\u72b6\u6001#######");
        for (WallchartCustomer wallchartCustomer : wallchartCustomerList) {
            int signRule;
            String signContent;
            int followRule;
            String followContent;
            String oldCustomerStatus = wallchartCustomer.getCustomerStatus();
            if ("4".equals(oldCustomerStatus)) continue;
            wallchartCustomer.setCustomerStatus("0");
            wallchartCustomer.setConnectDate(null);
            String progressContent = "";
            int connectRule = Integer.parseInt(rule.getConnectRule());
            String relationType = rule.getRelationType();
            String connectedContent = this.checkAndSetConnected(wallchartCustomer, connectRule, relationType, customerByNameVoMap, contractVoMap, trackRecordVoMap);
            if (ToolUtil.isNotEmpty((Object)connectedContent)) {
                progressContent = connectedContent;
            }
            if (ToolUtil.isNotEmpty((Object)(followContent = this.checkAndSetFollow(wallchartCustomer, followRule = Integer.parseInt(rule.getFollowRule()), opportunityVoMap)))) {
                progressContent = followContent;
            }
            if (ToolUtil.isNotEmpty((Object)(signContent = this.checkAndSetSign(wallchartCustomer, signRule = Integer.parseInt(rule.getSignRule()), opportunityWinVoMap)))) {
                progressContent = signContent;
            }
            if (!oldCustomerStatus.equals(wallchartCustomer.getCustomerStatus())) {
                updateWallchartCustomerList.add(wallchartCustomer);
            }
            if (!ToolUtil.isNotEmpty((Object)progressContent) || oldCustomerStatus.equals(wallchartCustomer.getCustomerStatus())) continue;
            Long wallchartCustomerId = wallchartCustomer.getWallchartCustomerId();
            String title = "\u6302\u56fe\u4f5c\u6218\u3010" + wallchart.getWallchartName() + "\u3011\u56fe\u5ba2\u6237\u3010" + wallchartCustomer.getWallchartCustomerName() + "\u3011\u6709\u65b0\u7684\u8fdb\u5c55";
            this.addToEimPushMessageList(eimPushMessageList, title, progressContent, wallchartCustomerId, userIdList);
            String contentUnify = "\u3010\u56fe\u5ba2\u6237\u63a8\u8fdb\u72b6\u6001\u63d0\u9192\u3011\u6302\u56fe\u4f5c\u6218\u3010" + wallchart.getWallchartName() + "\u3011\u56fe\u5ba2\u6237\u3010" + wallchartCustomer.getWallchartCustomerName() + "\u3011\u6709\u65b0\u7684\u8fdb\u5c55\uff1a" + progressContent;
            this.addToSysMessageTypeList(addSysMessageTypeList, contentUnify, date, userIdList, user, wallchartCustomerId);
        }
        logger.info("**********8\u3001\u5faa\u73af\u5224\u65ad\u56fe\u5ba2\u6237\u5f53\u524d\u72b6\u6001\uff0c\u7ed3\u675f\uff0c\u7528\u65f6#######" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        if (CollectionUtil.isNotEmpty(updateWallchartCustomerList)) {
            logger.info("###########\u672c\u6b21\u66f4\u65b0\u7684\u56fe\u5ba2\u6237\u6709\uff1a" + JSON.toJSONString(updateWallchartCustomerList));
            ((WallchartCustomerMapper)this.baseMapper).updateWallchartCustomerStatusBatch(updateWallchartCustomerList);
        }
        logger.info("**********9\u3001\u6279\u91cf\u66f4\u65b0\u56fe\u5ba2\u6237\u72b6\u6001\uff0c\u7ed3\u675f\uff0c\u7528\u65f6#######" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        if (CollectionUtil.isNotEmpty(eimPushMessageList)) {
            for (EimPushMessage message : eimPushMessageList) {
                EimPushUtil.pushJqxArticleMessage((String)message.getTitle(), (String)message.getContent(), (String)message.getUrl(), (String)message.getBid(), (List)message.getSendUsers());
            }
        }
        logger.info("**********10\u3001\u6279\u91cf\u53d1\u9001\u91d1\u4f01\u4fe1\u6d88\u606f\u901a\u77e5\uff0c\u7ed3\u675f\uff0c\u7528\u65f6#######" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        start = System.currentTimeMillis();
        if (CollectionUtil.isNotEmpty(addSysMessageTypeList)) {
            for (AddSysMessageType messageType : addSysMessageTypeList) {
                UnifyUtil.sendMessage((AddSysMessageType)messageType);
            }
        }
        logger.info("**********11\u3001\u6279\u91cf\u53d1\u9001\u7ad9\u5185\u4fe1\u6d88\u606f\u901a\u77e5\uff0c\u7ed3\u675f\uff0c\u7528\u65f6#######" + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        logger.info("###########\u56fe\u5ba2\u6237\u72b6\u6001\u66f4\u65b0\u7ed3\u675f\u5566");
        return true;
    }

    private void saveTrackRecord(Long businessId, String businessName, String productType, String recordContent) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setBusinessType("15");
        operateRecordDO.setProduceType(productType);
        operateRecordDO.setRecordContent(recordContent);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(businessId);
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.WALLCUSTOMER, businessId, businessName, LocalDateTime.now(), false, businessIds);
    }

    public static void systemMessage(AddSysMessageType addSysMessageType, String messageContent, LocalDateTime date, String userId, String messageIssue, String businessAddress, String mobileBusinessAddress) {
        addSysMessageType.setMessageContent(messageContent);
        addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
        addSysMessageType.setUserId(userId);
        addSysMessageType.setMessageIssue(messageIssue);
        addSysMessageType.setCreator(CommonConstant.SUPER_ADMIN);
        addSysMessageType.setLastEditor(CommonConstant.SUPER_ADMIN);
        addSysMessageType.setBusinessAddress(businessAddress);
        addSysMessageType.setMobileBusinessAddress(mobileBusinessAddress);
        addSysMessageType.setOpenWay("1");
    }

    private List<WallchartCustomer> readExcelDataToList(MultipartFile file, Long wallchartId, String relationType) {
        ArrayList<WallchartCustomer> wallchartCustomerList = new ArrayList<WallchartCustomer>();
        try {
            List list = ReadExcel.readExcel((MultipartFile)file, WallchartCustomerImportDto.class);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                List staffNumList = this.dictBoService.getDicValue("staff_nums", null, null);
                Map<String, Object> staffNumMap = staffNumList.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (key, value) -> value));
                List lastRevenueList = this.dictBoService.getDicValue("last_revenue", null, null);
                Map<String, Object> lastRevenueMap = lastRevenueList.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (key, value) -> value));
                List informationImportanceList = this.dictBoService.getDicValue("info_importance", null, null);
                Map<String, Object> informationImportanceMap = informationImportanceList.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (key, value) -> value));
                LambdaQueryWrapper userWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysUsers::getAccountStatus, (Object)"2")).ne(SysUsers::getIsSys, (Object)"1");
                List userList = this.sysUsersMapper.selectList((Wrapper)userWrapper);
                Map userMap = userList.stream().collect(Collectors.toMap(SysUsers::getUserName, Function.identity(), (key, value) -> value));
                List struList = this.sysStruMapper.selectList((Wrapper)new LambdaQueryWrapper().ne(SysStru::getOrganAlias, (Object)"\u79bb\u804c\u4eba\u5458"));
                Map<Long, String> struMap = struList.stream().collect(Collectors.toMap(SysStru::getId, SysStru::getOrganAlias, (key, value) -> value));
                List wallchartCustomerNameList = list.stream().map(WallchartCustomerImportDto::getWallchartCustomerName).collect(Collectors.toList());
                List customerByNameVoList = this.customerAPIService.selectCustomerByNameNoPermission(wallchartCustomerNameList, null, null);
                Map customerByNameVoMap = customerByNameVoList.stream().collect(Collectors.toMap(CustomerAPIVo::getCustomerName, Function.identity()));
                list.forEach(wallchartCustomerImportDto -> {
                    String inforImport;
                    String lastRevenue;
                    String staffNums;
                    WallchartCustomer wallchartCustomer = new WallchartCustomer();
                    wallchartCustomer.setWallchartId(wallchartId);
                    wallchartCustomer.setWallchartCustomerName(wallchartCustomerImportDto.getWallchartCustomerName());
                    String chargePersonName = wallchartCustomerImportDto.getChargePersonName();
                    wallchartCustomer.setChargePersonName(chargePersonName);
                    if (ToolUtil.isNotEmpty(userMap.get(chargePersonName))) {
                        SysUsers userInfo = (SysUsers)userMap.get(chargePersonName);
                        wallchartCustomer.setChargePersonId(userInfo.getId());
                        if (ToolUtil.isNotEmpty(struMap.get(userInfo.getDepartmentId()))) {
                            wallchartCustomer.setOwnDepartment(userInfo.getDepartmentId());
                            wallchartCustomer.setOwnDepartmentName((String)struMap.get(userInfo.getDepartmentId()));
                        }
                    }
                    if (ToolUtil.isNotEmpty(staffNumMap.get(staffNums = wallchartCustomerImportDto.getStaffNums()))) {
                        wallchartCustomer.setStaffNums(staffNumMap.get(staffNums).toString());
                    }
                    if (ToolUtil.isNotEmpty(lastRevenueMap.get(lastRevenue = wallchartCustomerImportDto.getLastRevenue()))) {
                        wallchartCustomer.setLastRevenue(lastRevenueMap.get(lastRevenue).toString());
                    }
                    if (ToolUtil.isNotEmpty(informationImportanceMap.get(inforImport = wallchartCustomerImportDto.getInformationImportance()))) {
                        wallchartCustomer.setInformationImportance(informationImportanceMap.get(inforImport).toString());
                    }
                    if ("1".equals(relationType)) {
                        if (null != customerByNameVoMap.get(wallchartCustomer.getWallchartCustomerName())) {
                            CustomerAPIVo customerVo = (CustomerAPIVo)customerByNameVoMap.get(wallchartCustomer.getWallchartCustomerName());
                            BeanUtil.copyProperties((Object)customerVo, (Object)wallchartCustomer);
                        }
                    } else if ("2".equals(relationType)) {
                        System.out.println("\u5e73\u53f0\u6682\u4e0d\u652f\u6301\u6309\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u7cbe\u786e\u5339\u914d");
                    }
                    this.customerDefaultInfo(wallchartCustomer);
                    wallchartCustomerList.add(wallchartCustomer);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wallchartCustomerList;
    }

    private void customerDefaultInfo(WallchartCustomer wallchartCustomer) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        wallchartCustomer.setDelFlag("0");
        wallchartCustomer.setCustomerStatus("0");
        wallchartCustomer.setCreateTime(date);
        wallchartCustomer.setCreator(user.getUserId());
        wallchartCustomer.setCreatorName(user.getUserName());
        wallchartCustomer.setCreateDepartment(user.getDeptId());
        wallchartCustomer.setCreateDepartmentName(user.getDeptName());
        wallchartCustomer.setOwnUnit(user.getTenantId());
        wallchartCustomer.setOwnUnitName(user.getTenantName());
        wallchartCustomer.setLastTime(date);
        wallchartCustomer.setLastEditor(user.getUserId());
        wallchartCustomer.setLastEditorName(user.getUserName());
    }

    private void saveWallchartCustomerImportRecord(Long wallchartId, Long importRecordId, String importResult, int failCount) {
        WallchartCustomerImport importRecord = new WallchartCustomerImport();
        importRecord.setImportRecordId(importRecordId);
        importRecord.setWallchartId(wallchartId);
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        importRecord.setDelFlag("0");
        importRecord.setCreateTime(date);
        importRecord.setCreator(user.getUserId());
        importRecord.setCreatorName(user.getUserName());
        importRecord.setCreateDepartment(user.getDeptId());
        importRecord.setCreateDepartmentName(user.getDeptName());
        importRecord.setOwnUnit(user.getTenantId());
        importRecord.setOwnUnitName(user.getTenantName());
        importRecord.setImportResult(importResult);
        importRecord.setFailCount(failCount);
        this.wallchartCustomerImportMapper.insert(importRecord);
    }

    private void addWallchartCustomerToImportFail(List<WallchartCustomerFail> failList, WallchartCustomer wallchartCustomer, Long importRecordId, String failMsg) {
        WallchartCustomerFail wallchartCustomerFail = new WallchartCustomerFail();
        BeanUtil.copy((Object)wallchartCustomer, (Object)wallchartCustomerFail);
        wallchartCustomerFail.setImportRecordId(importRecordId);
        wallchartCustomerFail.setImportFailReason(failMsg);
        failList.add(wallchartCustomerFail);
    }

    private void addUpdateWallchartCustomerToList(List<WallchartCustomerDto> updateWallchartList, LocalDateTime date, String userId, String userName, String newChargePersonId, String newChargePersonName, Long newOwnDepartment, String newOwnDepartmentName, Long wallchartCustomerId) {
        WallchartCustomerDto dto = new WallchartCustomerDto();
        dto.setWallchartCustomerId(wallchartCustomerId);
        dto.setChangeTime(date);
        dto.setChangePerson(userId);
        dto.setChangePersonName(userName);
        dto.setOwnDepartment(newOwnDepartment);
        dto.setOwnDepartmentName(newOwnDepartmentName);
        dto.setNewChargePersonId(newChargePersonId);
        dto.setNewChargePersonName(newChargePersonName);
        updateWallchartList.add(dto);
    }

    private String checkAndSetSign(WallchartCustomer wallchartCustomer, int signRule, Map<Long, OpportunityAPIVo> opportunityWinVoMap) {
        String progressContent = "";
        switch (signRule) {
            case 1: {
                if (!ToolUtil.isNotEmpty((Object)wallchartCustomer.getSysCustomerId()) || !ToolUtil.isNotEmpty((Object)opportunityWinVoMap.get(wallchartCustomer.getSysCustomerId()))) break;
                OpportunityAPIVo opportunityWinVo = opportunityWinVoMap.get(wallchartCustomer.getSysCustomerId());
                wallchartCustomer.setCustomerStatus("3");
                wallchartCustomer.setSignDate(this.stringToLocalDateTime(opportunityWinVo.getSuccessDate()));
                progressContent = "\u5df2\u6210\u4ea4\uff0c\u6210\u4ea4\u5546\u673a\u3010" + opportunityWinVo.getOpportunityName() + "\u3011\u3002";
                break;
            }
            case 2: {
                break;
            }
        }
        return progressContent;
    }

    private String checkAndSetFollow(WallchartCustomer wallchartCustomer, int followRule, Map<Long, OpportunityAPIVo> opportunityVoMap) {
        String progressContent = "";
        switch (followRule) {
            case 1: {
                if (!ToolUtil.isNotEmpty((Object)wallchartCustomer.getSysCustomerId()) || !ToolUtil.isNotEmpty((Object)opportunityVoMap.get(wallchartCustomer.getSysCustomerId()))) break;
                OpportunityAPIVo opportunityVo = opportunityVoMap.get(wallchartCustomer.getSysCustomerId());
                wallchartCustomer.setCustomerStatus("2");
                wallchartCustomer.setFollowDate(opportunityVo.getCreateTime());
                progressContent = "\u8ddf\u8fdb\u4e2d\uff0c\u5173\u8054\u5546\u673a\u3010" + opportunityVo.getOpportunityName() + "\u3011\u3002";
                break;
            }
            case 2: {
                break;
            }
        }
        return progressContent;
    }

    private String checkAndSetConnected(WallchartCustomer wallchartCustomer, int connectRule, String relationType, Map<Long, CustomerAPIVo> customerByNameVoMap, Map<Long, ContactAPIVo> contractVoMap, Map<Long, TrackRecordAPIVo> trackRecordVoMap) {
        String progressContent = "";
        block0 : switch (connectRule) {
            case 1: {
                if (!ToolUtil.isNotEmpty((Object)wallchartCustomer.getSysCustomerId()) || !ToolUtil.isNotEmpty((Object)contractVoMap.get(wallchartCustomer.getSysCustomerId()))) break;
                ContactAPIVo contactVo = contractVoMap.get(wallchartCustomer.getSysCustomerId());
                wallchartCustomer.setConnectDate(contactVo.getCreateTime());
                wallchartCustomer.setCustomerStatus("1");
                progressContent = "\u5df2\u5efa\u8054\uff0c\u5efa\u8054\u65e5\u671f" + wallchartCustomer.getConnectDate() + "\uff0c\u5173\u8054\u5ba2\u6237\u3010" + wallchartCustomer.getSysCustomerName() + "\u3011\u3002";
                break;
            }
            case 2: {
                if (!ToolUtil.isNotEmpty((Object)wallchartCustomer.getSysCustomerId()) || !ToolUtil.isNotEmpty((Object)trackRecordVoMap.get(wallchartCustomer.getSysCustomerId()))) break;
                TrackRecordAPIVo trackRecordVo = trackRecordVoMap.get(wallchartCustomer.getSysCustomerId());
                wallchartCustomer.setCustomerStatus("1");
                wallchartCustomer.setConnectDate(trackRecordVo.getCreateTime());
                progressContent = "\u5df2\u5efa\u8054\uff0c\u5efa\u8054\u65e5\u671f" + wallchartCustomer.getConnectDate() + "\uff0c\u5173\u8054\u5ba2\u6237\u3010" + wallchartCustomer.getSysCustomerName() + "\u3011\u3002";
                break;
            }
            case 3: {
                if (ToolUtil.isEmpty((Object)wallchartCustomer.getSysCustomerId())) {
                    if ("1".equals(relationType)) {
                        for (Long key : customerByNameVoMap.keySet()) {
                            CustomerAPIVo customerVo = customerByNameVoMap.get(key);
                            if (!customerVo.getCustomerName().equals(wallchartCustomer.getWallchartCustomerName())) continue;
                            BeanUtil.copyProperties((Object)customerVo, (Object)wallchartCustomer);
                            wallchartCustomer.setSysCustomerId(customerVo.getCustomerId());
                            wallchartCustomer.setSysCustomerName(customerVo.getCustomerName());
                            wallchartCustomer.setSysCustomerChargeUser(customerVo.getChargePersonId());
                            wallchartCustomer.setSysCustomerChargeUserName(customerVo.getChargePersonName());
                            wallchartCustomer.setSysCustomerCreateTime(customerVo.getCreateTime());
                            wallchartCustomer.setCustomerStatus("1");
                            wallchartCustomer.setConnectDate(customerVo.getCreateTime());
                            progressContent = "\u5df2\u5efa\u8054\uff0c\u5efa\u8054\u65e5\u671f" + wallchartCustomer.getConnectDate() + "\uff0c\u5173\u8054\u5ba2\u6237\u3010" + wallchartCustomer.getSysCustomerName() + "\u3011\u3002";
                            break block0;
                        }
                        break;
                    }
                    if (!"2".equals(relationType)) break;
                    System.out.println("\u5e73\u53f0\u6682\u4e0d\u652f\u6301\u6309\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u7cbe\u786e\u5339\u914d");
                    break;
                }
                if ("1".equals(relationType)) {
                    if (!ToolUtil.isNotEmpty((Object)customerByNameVoMap.get(wallchartCustomer.getSysCustomerId()))) break;
                    CustomerAPIVo customerVo = customerByNameVoMap.get(wallchartCustomer.getSysCustomerId());
                    wallchartCustomer.setCustomerStatus("1");
                    wallchartCustomer.setConnectDate(customerVo.getCreateTime());
                    progressContent = "\u5df2\u5efa\u8054\uff0c\u5efa\u8054\u65e5\u671f" + wallchartCustomer.getConnectDate() + "\uff0c\u5173\u8054\u5ba2\u6237\u3010" + wallchartCustomer.getSysCustomerName() + "\u3011\u3002";
                    break;
                }
                if (!"2".equals(relationType)) break;
                System.out.println("\u5e73\u53f0\u6682\u4e0d\u652f\u6301\u6309\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u7cbe\u786e\u5339\u914d");
                break;
            }
        }
        return progressContent;
    }

    private Map<Long, ContactAPIVo> getFirstContractByCustomerVoMap(List<Long> sysCustomerIdList, LocalDateTime createTimeStart, LocalDateTime createTimeEnd) {
        List contactVoList = this.contactAPIService.selectFirstContactByCustomer(sysCustomerIdList, createTimeStart, createTimeEnd);
        HashMap<Long, ContactAPIVo> contractVoMap = new HashMap<Long, ContactAPIVo>();
        if (CollectionUtil.isNotEmpty((Collection)contactVoList)) {
            for (ContactAPIVo contactVo : contactVoList) {
                if (ToolUtil.isEmpty(contractVoMap.get(contactVo.getCustomerId()))) {
                    contractVoMap.put(contactVo.getCustomerId(), contactVo);
                    continue;
                }
                if (!contactVo.getCreateTime().isBefore(((ContactAPIVo)contractVoMap.get(contactVo.getCustomerId())).getCreateTime())) continue;
                contractVoMap.put(contactVo.getCustomerId(), contactVo);
            }
        }
        return contractVoMap;
    }

    private Map<Long, TrackRecordAPIVo> getFirstRecordByCustomerVoMap(List<Long> sysCustomerIdList, LocalDateTime createTimeStart, LocalDateTime createTimeEnd) {
        List trackRecordVoList = this.trackRecordAPIService.selectFirstRecordByCustomer(sysCustomerIdList, createTimeStart, createTimeEnd);
        HashMap<Long, TrackRecordAPIVo> trackRecordVoMap = new HashMap<Long, TrackRecordAPIVo>();
        if (CollectionUtil.isNotEmpty((Collection)trackRecordVoList)) {
            for (TrackRecordAPIVo trackRecordVo : trackRecordVoList) {
                if (ToolUtil.isEmpty(trackRecordVoMap.get(trackRecordVo.getTypeId()))) {
                    trackRecordVoMap.put(trackRecordVo.getTypeId(), trackRecordVo);
                    continue;
                }
                if (!trackRecordVo.getCreateTime().isBefore(((TrackRecordAPIVo)trackRecordVoMap.get(trackRecordVo.getTypeId())).getCreateTime())) continue;
                trackRecordVoMap.put(trackRecordVo.getTypeId(), trackRecordVo);
            }
        }
        return trackRecordVoMap;
    }

    private Map<Long, OpportunityAPIVo> getOpportunityVoMap(List<Long> sysCustomerIdList, List<Long> productIdList, String opportunityStage, LocalDateTime createTimeStart, LocalDateTime createTimeEnd) {
        List opportunityVoList = this.opportunityAPIService.selectByCustomerIdAndStageAndTime(sysCustomerIdList, productIdList, opportunityStage, createTimeStart, createTimeEnd);
        HashMap<Long, OpportunityAPIVo> opportunityVoMap = new HashMap<Long, OpportunityAPIVo>();
        if (CollectionUtil.isNotEmpty((Collection)opportunityVoList)) {
            for (OpportunityAPIVo opportunityVo : opportunityVoList) {
                if (ToolUtil.isEmpty(opportunityVoMap.get(opportunityVo.getCustomerId()))) {
                    opportunityVoMap.put(opportunityVo.getCustomerId(), opportunityVo);
                    continue;
                }
                if (!opportunityVo.getCreateTime().isBefore(((OpportunityAPIVo)opportunityVoMap.get(opportunityVo.getCustomerId())).getCreateTime())) continue;
                opportunityVoMap.put(opportunityVo.getCustomerId(), opportunityVo);
            }
        }
        return opportunityVoMap;
    }

    private Map<Long, OpportunityAPIVo> getWinOpportunityVoMap(List<Long> sysCustomerIdList, List<Long> productIdList, LocalDateTime createTimeStart, LocalDateTime createTimeEnd) {
        List opportunityWinVoList = this.opportunityAPIService.selectWinByCustomerIdAndTime(sysCustomerIdList, productIdList, createTimeStart, createTimeEnd);
        HashMap<Long, OpportunityAPIVo> opportunityWinVoMap = new HashMap<Long, OpportunityAPIVo>();
        if (CollectionUtil.isNotEmpty((Collection)opportunityWinVoList)) {
            for (OpportunityAPIVo opportunityVo : opportunityWinVoList) {
                if (ToolUtil.isEmpty(opportunityWinVoMap.get(opportunityVo.getCustomerId()))) {
                    opportunityWinVoMap.put(opportunityVo.getCustomerId(), opportunityVo);
                    continue;
                }
                if (!opportunityVo.getCreateTime().isBefore(((OpportunityAPIVo)opportunityWinVoMap.get(opportunityVo.getCustomerId())).getCreateTime())) continue;
                opportunityWinVoMap.put(opportunityVo.getCustomerId(), opportunityVo);
            }
        }
        return opportunityWinVoMap;
    }

    private void addToEimPushMessageList(List<EimPushMessage> eimPushMessageList, String title, String content, Long wallchartCustomerId, List<String> userIdList) {
        EimPushMessage eimPushMessage = new EimPushMessage(title, content, "/crm/gt/gtzz/xxzl", wallchartCustomerId.toString(), userIdList);
        eimPushMessageList.add(eimPushMessage);
    }

    private void addToSysMessageTypeList(List<AddSysMessageType> addSysMessageTypeList, String contentUnify, LocalDateTime date, List<String> userIdList, SecurityUser user, Long wallchartCustomerId) {
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/wallchart/wallCustomerDetails" + "?row=" + wallchartCustomerId;
        StringBuilder receiveUserIds = new StringBuilder();
        for (int i = 0; i < userIdList.size(); ++i) {
            String userId = userIdList.get(i);
            receiveUserIds.append(userId).append(",");
            if ((i + 1) % 50 != 0 && i + 1 != userIdList.size()) continue;
            receiveUserIds.deleteCharAt(receiveUserIds.length() - 1);
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            addSysMessageType.setBusinessAddress(unifyWebUrl);
            if (null == user) {
                WallchartCustomerServiceImpl.systemMessage(addSysMessageType, contentUnify, date, receiveUserIds.toString(), "\u8d85\u7ea7\u7ba1\u7406\u5458", unifyWebUrl, "");
            } else {
                UnifyUtil.defaultMessage((AddSysMessageType)addSysMessageType, (String)contentUnify, (LocalDateTime)date, (SecurityUser)user, (String)receiveUserIds.toString(), (String)user.getUserName(), (String)unifyWebUrl, (String)"");
            }
            addSysMessageTypeList.add(addSysMessageType);
            receiveUserIds.setLength(0);
        }
    }

    private LocalDateTime stringToLocalDateTime(String dateTimeStr) {
        if (ToolUtil.isEmpty((Object)dateTimeStr)) {
            return null;
        }
        if (dateTimeStr.length() == 10) {
            dateTimeStr = dateTimeStr + " 00:00:00";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        try {
            return LocalDateTime.parse(dateTimeStr, formatter);
        }
        catch (DateTimeParseException e) {
            System.err.println("\u65e0\u6cd5\u89e3\u6790\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32: " + dateTimeStr + ", \u5f02\u5e38: " + e.getMessage());
            return null;
        }
    }

    @Override
    public Boolean checkCustomerStatus(List<Long> wallchartCustomerIdList) {
        List customerList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(WallchartCustomer::getWallchartCustomerId, wallchartCustomerIdList)).eq(WallchartCustomer::getDelFlag, (Object)"0"));
        List tempList = customerList.stream().filter(a -> Arrays.asList("3", "4").contains(a.getCustomerStatus())).collect(Collectors.toList());
        return CollectionUtil.isEmpty(tempList);
    }

    @Override
    public void addConditionByCustomerPermission(WallchartCustomerDto dto, String customerPermission) {
        SecurityUser user = BaseSecurityUtil.getUser();
        switch (customerPermission) {
            case "2": {
                List deptList = this.dataRightBoService.getChargeDepartmentList();
                if (!CollectionUtil.isNotEmpty((Collection)deptList)) break;
                dto.setPermissionDeptList(deptList.stream().map(String::valueOf).collect(Collectors.toList()));
                break;
            }
            case "3": {
                dto.setChargePersonId(String.valueOf(user.getUserId()));
                break;
            }
        }
    }
}

