/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.marketing.wallchart.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.marketing.wallchart.model.Wallchart;
import com.jxdinfo.crm.marketing.wallchart.model.WallchartCustomer;
import com.jxdinfo.crm.marketing.wallchart.model.WallchartRule;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartCustomerService;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartRuleService;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WallchartCustomerJob
implements BasicProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(WallchartCustomerJob.class);
    WallchartService wallchartService = (WallchartService)SpringContextHolder.getBean(WallchartService.class);
    WallchartRuleService wallchartRuleService = (WallchartRuleService)SpringContextHolder.getBean(WallchartRuleService.class);
    WallchartCustomerService wallchartCustomerService = (WallchartCustomerService)SpringContextHolder.getBean(WallchartCustomerService.class);

    public ProcessResult process(TaskContext context) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Wallchart::getDelFlag, (Object)"0");
        queryWrapper.ne(Wallchart::getWallchartStatus, (Object)"3");
        List wallchartList = this.wallchartService.list((Wrapper)queryWrapper);
        if (wallchartList == null || wallchartList.size() == 0) {
            return new ProcessResult(true, "success");
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(() -> {
            logger.info("#################\u6302\u56fe\u5ba2\u6237\u72b6\u6001\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb###################" + new Date());
            List wallchartIds = wallchartList.stream().map(Wallchart::getWallchartId).collect(Collectors.toList());
            LambdaQueryWrapper ruleLambdaQueryWrapper = new LambdaQueryWrapper();
            ruleLambdaQueryWrapper.in(WallchartRule::getWallchartId, wallchartIds);
            ruleLambdaQueryWrapper.eq(WallchartRule::getDelFlag, (Object)"0");
            List wallchartRuleList = this.wallchartRuleService.list((Wrapper)ruleLambdaQueryWrapper);
            Map wallchartRuleMap = wallchartRuleList.stream().collect(Collectors.toMap(WallchartRule::getWallchartId, Function.identity()));
            LambdaQueryWrapper customerQueryWrapper = new LambdaQueryWrapper();
            customerQueryWrapper.in(WallchartCustomer::getWallchartId, wallchartIds);
            customerQueryWrapper.eq(WallchartCustomer::getDelFlag, (Object)"0");
            List wallchartCustomerList = this.wallchartCustomerService.list((Wrapper)customerQueryWrapper);
            Map<Long, List<WallchartCustomer>> wallchartCustomerMap = wallchartCustomerList.stream().collect(Collectors.groupingBy(WallchartCustomer::getWallchartId));
            wallchartList.forEach(wallchart -> {
                if (ToolUtil.isNotEmpty(wallchartRuleMap.get(wallchart.getWallchartId())) && ToolUtil.isNotEmpty(wallchartCustomerMap.get(wallchart.getWallchartId()))) {
                    WallchartRule wallchartRule = (WallchartRule)wallchartRuleMap.get(wallchart.getWallchartId());
                    List wallchartCustomers = (List)wallchartCustomerMap.get(wallchart.getWallchartId());
                    this.wallchartCustomerService.updateWallchartCustomerStatus((Wallchart)wallchart, wallchartCustomers, wallchartRule);
                }
            });
            logger.info("#################\u6302\u56fe\u5ba2\u6237\u72b6\u6001\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f###################" + new Date());
        });
        executorService.shutdown();
        return new ProcessResult(true, "success");
    }
}

