/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.marketing.wallchart.service.impl;

import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartAssociativeQueryDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartDto;
import com.jxdinfo.crm.marketing.wallchart.service.IWallchartAssociativeQueryService;
import com.jxdinfo.crm.marketing.wallchart.vo.WallchartAssociativeQueryEnum;
import com.jxdinfo.crm.product.api.service.IAssociateProductAPIService;
import com.jxdinfo.crm.product.api.vo.AssociateProductVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WallchartAssociativeQueryServiceImpl
implements IWallchartAssociativeQueryService {
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryAPIService;
    @Resource
    private IAssociateProductAPIService associateProductBoService;
    @Resource
    private IStruUserAPIService struUserBoService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        WallchartAssociativeQueryDto wallchartAssociativeQueryDto = null;
        if (associativeQueryDto instanceof WallchartAssociativeQueryDto) {
            wallchartAssociativeQueryDto = (WallchartAssociativeQueryDto)associativeQueryDto;
        }
        assert (wallchartAssociativeQueryDto != null);
        WallchartDto wallchartDto = wallchartAssociativeQueryDto.getDto();
        List<String> labelList = null;
        List<String> wallchartStatusList = null;
        List<Long> provinceCodesList = null;
        List<String> industryCodesList = null;
        List<String> productIdList = null;
        List<String> chargePersonIdList = null;
        List<String> ownDepartmentList = null;
        if (wallchartDto != null) {
            labelList = wallchartDto.getLabelIds();
            wallchartStatusList = wallchartDto.getWallchartStatus();
            provinceCodesList = wallchartDto.getProvinceCodes();
            industryCodesList = wallchartDto.getIndustryCodes();
            productIdList = wallchartDto.getProductIds();
            chargePersonIdList = wallchartDto.getChargePersonIds();
            ownDepartmentList = wallchartDto.getOwnDepartments();
        }
        String moduleId = LabelModuleEnum.WALLCHART.getModuleId();
        List selectedLabels = excludeInfoMap.get("selectedLabels");
        selectedLabels = this.associativeFiledQueryAPIService.getLabelAssociativeQuery(associativeQueryVoList, keyword, selectedLabels, labelList, moduleId);
        excludeInfoMap.put("selectedLabels", selectedLabels);
        List selectedWallchartStatus = excludeInfoMap.get("selectedWallchartStatus");
        selectedWallchartStatus = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedWallchartStatus, wallchartStatusList, this.getAssociateLabelVoByEnum(WallchartAssociativeQueryEnum.WALLCHART_STATUS));
        excludeInfoMap.put("selectedWallchartStatus", selectedWallchartStatus);
        List selectedProvinceCodes = excludeInfoMap.get("selectedProvinceCodes");
        selectedProvinceCodes = this.associativeFiledQueryAPIService.getProvinceAssociativeQuery(associativeQueryVoList, keyword, selectedProvinceCodes, provinceCodesList, this.getAssociateLabelVoByEnum(WallchartAssociativeQueryEnum.WALLCHART_PROVICE));
        excludeInfoMap.put("selectedProvinceCodes", selectedProvinceCodes);
        List selectedIndustryCodes = excludeInfoMap.get("selectedIndustryCodes");
        selectedIndustryCodes = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedIndustryCodes, industryCodesList, this.getAssociateLabelVoByEnum(WallchartAssociativeQueryEnum.CUSTOMER_INDUSTRY));
        excludeInfoMap.put("selectedIndustryCodes", selectedIndustryCodes);
        List<String> selectedProductIds = excludeInfoMap.get("selectedProductIds");
        selectedProductIds = this.getProductAssociativeQuery(associativeQueryVoList, keyword, selectedProductIds, productIdList, this.getAssociateLabelVoByEnum(WallchartAssociativeQueryEnum.CUSTOMER_PRODUCT_TYPES));
        excludeInfoMap.put("selectedProductIds", selectedProductIds);
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, this.getAssociateLabelVoByEnum(WallchartAssociativeQueryEnum.CUSTOMER_CHARGE_PERSON));
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryAPIService.getDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, this.getAssociateLabelVoByEnum(WallchartAssociativeQueryEnum.CUSTOMER_OWN_DEPARTMENTS));
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        for (AssociativeQueryVo associativeQueryVo : associativeQueryVoList) {
            if (associativeQueryVo.getLabelName().contains("\u6240\u5728\u7701\u4efd")) {
                associativeQueryVo.setLabelName(associativeQueryVo.getLabelName().replace("\u6240\u5728\u7701\u4efd\uff1a", "\u9762\u5411\u7701\u4efd\uff1a"));
                associativeQueryVo.setTips(associativeQueryVo.getTips().replace("\u6240\u5728\u7701\u4efd\uff1a", "\u9762\u5411\u7701\u4efd\uff1a"));
                continue;
            }
            if (associativeQueryVo.getLabelName().contains("\u5ba2\u6237\u884c\u4e1a")) {
                associativeQueryVo.setLabelName(associativeQueryVo.getLabelName().replace("\u5ba2\u6237\u884c\u4e1a\uff1a", "\u9762\u5411\u884c\u4e1a\uff1a"));
                associativeQueryVo.setTips(associativeQueryVo.getTips().replace("\u5ba2\u6237\u884c\u4e1a\uff1a", "\u9762\u5411\u884c\u4e1a\uff1a"));
                continue;
            }
            if (!associativeQueryVo.getLabelName().contains("\u5173\u8054\u4ea7\u54c1")) continue;
            associativeQueryVo.setLabelName(associativeQueryVo.getLabelName().replace("\u5173\u8054\u4ea7\u54c1\uff1a", "\u9762\u5411\u4ea7\u54c1\uff1a"));
            associativeQueryVo.setTips(associativeQueryVo.getTips().replace("\u5173\u8054\u4ea7\u54c1\uff1a", "\u9762\u5411\u4ea7\u54c1\uff1a"));
        }
        return associativeQueryVoList;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(WallchartAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }

    public List<String> getProductAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedProducts, List<String> productIds, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> products = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(productIds)) {
            products.addAll(productIds);
        }
        if (CollectionUtil.isEmpty(selectedProducts)) {
            selectedProducts = new ArrayList<String>();
        }
        products.addAll(selectedProducts);
        List productList = this.associateProductBoService.getProductList(keyword, products);
        if (ToolUtil.isNotEmpty((Object)productList)) {
            for (AssociateProductVo product : productList) {
                AssociativeQueryVo productAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associativeLabelVo, product.getProductName(), String.valueOf(product.getProductId()));
                associativeQueryVoList.add(productAssociative);
                selectedProducts.add(String.valueOf(product.getProductId()));
            }
        }
        return selectedProducts;
    }
}

