/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.marketing.wallchart.service.impl;

import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.core.associativeQuery.queryEnum.AssociativeModuleEnum;
import com.jxdinfo.crm.core.associativeQuery.queryEnum.AssociativeQueryEnum;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeFiledQueryService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartAssociativeQueryDto;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartDto;
import com.jxdinfo.crm.marketing.wallchart.service.IWallchartAssociativeQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WallchartAssociativeQueryServiceImpl
implements IWallchartAssociativeQueryService {
    @Resource
    private AssociativeFiledQueryService associativeFiledQueryService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        WallchartAssociativeQueryDto wallchartAssociativeQueryDto = null;
        if (associativeQueryDto instanceof WallchartAssociativeQueryDto) {
            wallchartAssociativeQueryDto = (WallchartAssociativeQueryDto)associativeQueryDto;
        }
        assert (wallchartAssociativeQueryDto != null);
        WallchartDto wallchartDto = wallchartAssociativeQueryDto.getDto();
        List<String> labelList = null;
        List<String> wallchartStatusList = null;
        List<Long> provinceCodesList = null;
        List<String> industryCodesList = null;
        List<String> productIdList = null;
        List<String> chargePersonIdList = null;
        List<String> ownDepartmentList = null;
        if (wallchartDto != null) {
            labelList = wallchartDto.getLabelIds();
            wallchartStatusList = wallchartDto.getWallchartStatus();
            provinceCodesList = wallchartDto.getProvinceCodes();
            industryCodesList = wallchartDto.getIndustryCodes();
            productIdList = wallchartDto.getProductIds();
            chargePersonIdList = wallchartDto.getChargePersonIds();
            ownDepartmentList = wallchartDto.getOwnDepartments();
        }
        String moduleId = AssociativeModuleEnum.WALLCHART.getModuleId();
        List selectedLabels = excludeInfoMap.get("selectedLabels");
        selectedLabels = this.associativeFiledQueryService.getLabelAssociativeQuery(associativeQueryVoList, keyword, selectedLabels, labelList, moduleId);
        excludeInfoMap.put("selectedLabels", selectedLabels);
        List selectedWallchartStatus = excludeInfoMap.get("selectedWallchartStatus");
        selectedWallchartStatus = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedWallchartStatus, wallchartStatusList, AssociativeQueryEnum.WALLCHART_STATUS);
        excludeInfoMap.put("selectedWallchartStatus", selectedWallchartStatus);
        List selectedProvinceCodes = excludeInfoMap.get("selectedProvinceCodes");
        selectedProvinceCodes = this.associativeFiledQueryService.getProvinceAssociativeQuery(associativeQueryVoList, keyword, selectedProvinceCodes, provinceCodesList);
        excludeInfoMap.put("selectedProvinceCodes", selectedProvinceCodes);
        List selectedIndustryCodes = excludeInfoMap.get("selectedIndustryCodes");
        selectedIndustryCodes = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedIndustryCodes, industryCodesList, AssociativeQueryEnum.CUSTOMER_INDUSTRY);
        excludeInfoMap.put("selectedIndustryCodes", selectedIndustryCodes);
        List selectedProductIds = excludeInfoMap.get("selectedProductIds");
        selectedProductIds = this.associativeFiledQueryService.getProductAssociativeQuery(associativeQueryVoList, keyword, selectedProductIds, productIdList, AssociativeQueryEnum.CUSTOMER_PRODUCT_TYPES);
        excludeInfoMap.put("selectedProductIds", selectedProductIds);
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryService.getChargePersonAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, AssociativeQueryEnum.CUSTOMER_CHARGE_PERSON);
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryService.getOwnDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, AssociativeQueryEnum.CUSTOMER_OWN_DEPARTMENTS);
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        for (AssociativeQueryVo associativeQueryVo : associativeQueryVoList) {
            if (associativeQueryVo.getLabelName().contains("\u6240\u5728\u7701\u4efd")) {
                associativeQueryVo.setLabelName(associativeQueryVo.getLabelName().replace("\u6240\u5728\u7701\u4efd\uff1a", "\u9762\u5411\u7701\u4efd\uff1a"));
                associativeQueryVo.setTips(associativeQueryVo.getTips().replace("\u6240\u5728\u7701\u4efd\uff1a", "\u9762\u5411\u7701\u4efd\uff1a"));
                continue;
            }
            if (associativeQueryVo.getLabelName().contains("\u5ba2\u6237\u884c\u4e1a")) {
                associativeQueryVo.setLabelName(associativeQueryVo.getLabelName().replace("\u5ba2\u6237\u884c\u4e1a\uff1a", "\u9762\u5411\u884c\u4e1a\uff1a"));
                associativeQueryVo.setTips(associativeQueryVo.getTips().replace("\u5ba2\u6237\u884c\u4e1a\uff1a", "\u9762\u5411\u884c\u4e1a\uff1a"));
                continue;
            }
            if (!associativeQueryVo.getLabelName().contains("\u5173\u8054\u4ea7\u54c1")) continue;
            associativeQueryVo.setLabelName(associativeQueryVo.getLabelName().replace("\u5173\u8054\u4ea7\u54c1\uff1a", "\u9762\u5411\u4ea7\u54c1\uff1a"));
            associativeQueryVo.setTips(associativeQueryVo.getTips().replace("\u5173\u8054\u4ea7\u54c1\uff1a", "\u9762\u5411\u4ea7\u54c1\uff1a"));
        }
        return associativeQueryVoList;
    }
}

