/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.controller;

import com.jxdinfo.crm.knowledge.knowledge.config.NoWrapApiResponse;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.dto.ComplexParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.dto.SearchIndexParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.response.ESResponse;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.service.SearchService;
import com.jxdinfo.crm.knowledge.knowledge.response.ResponseData;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search"})
public class SearchController {
    @Autowired
    private SearchService searchService;

    @ResponseBody
    @NoWrapApiResponse
    @RequestMapping(value={"/searchIndex"})
    public ResponseData searchIndex(@Validated @RequestBody SearchIndexParam searchIndexParam) {
        Map<String, Object> response = this.searchService.searchIndex(searchIndexParam.getSearchKeys(), searchIndexParam.getPage(), searchIndexParam.getPageSize(), searchIndexParam.getTypeMain());
        return ResponseData.success(response);
    }

    @ResponseBody
    @NoWrapApiResponse
    @RequestMapping(value={"/index"})
    public ResponseData search(@Validated @RequestBody ComplexParam complexParam) {
        ESResponse<Map<String, Object>> response = this.searchService.search(complexParam);
        return ResponseData.success(response);
    }

    @ResponseBody
    @NoWrapApiResponse
    @RequestMapping(value={"/getRecommend"})
    public ResponseData getRecommend(@Validated @RequestBody ComplexParam complexParam) {
        ESResponse<Map<String, Object>> response = this.searchService.getRecommend(complexParam);
        return ResponseData.success(response);
    }

    @ResponseBody
    @NoWrapApiResponse
    @RequestMapping(value={"/updateHot"})
    public ResponseData updateHot(String id, Long hot) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResponseData.error("\u6d4f\u89c8\u91cf\u66f4\u65b0\u5931\u8d25");
        }
        this.searchService.updateHot(id, hot);
        return ResponseData.success();
    }

    @ResponseBody
    @NoWrapApiResponse
    @RequestMapping(value={"/deletFile"})
    public ResponseData deletFile(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResponseData.error("\u5220\u9664\u5931\u8d25");
        }
        this.searchService.deletFile(id);
        return ResponseData.success();
    }
}

