/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HumpTransformUnderlineUtils {
    private static String compile = "[A-Z]";

    private HumpTransformUnderlineUtils() {
    }

    public static <T> Map<String, Object> transform(T object) {
        if (object == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = object.getClass().getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                String transformFieldName;
                String fieldName = fields[i].getName();
                if ("serialVersionUID".equals(fieldName) || "basicMetaId".equals(fieldName) || "customizeMeta".equals(fieldName) || (transformFieldName = HumpTransformUnderlineUtils.getTransformFieldName(fieldName)).contains("_id")) continue;
                Map<String, Object> FieldValue = null;
                String name = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                String type = fields[i].getGenericType().toString();
                Method m = object.getClass().getMethod("get" + name, new Class[0]);
                switch (type) {
                    case "class java.lang.String": 
                    case "class java.lang.Boolean": 
                    case "class java.util.Date": 
                    case "class java.lang.Integer": 
                    case "class java.lang.Long": {
                        FieldValue = m.invoke(object, new Object[0]);
                        break;
                    }
                    default: {
                        Object obj = m.invoke(object, new Object[0]);
                        FieldValue = HumpTransformUnderlineUtils.transform(obj);
                    }
                }
                map.put(transformFieldName, FieldValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private static String getTransformFieldName(String fieldName) {
        Pattern humpPattern = Pattern.compile(compile);
        Matcher matcher = humpPattern.matcher(fieldName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

