/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils;

import com.jxdinfo.crm.knowledge.knowledge.modular.common.parse.entity.ExcelCell;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class ExcelTransforUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelTransforUtil.class);

    public static ExcelCell getMergedRegionEntity(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            ExcelCell cell = new ExcelCell();
            cell.setMergedRegion(true);
            cell.setFirstColumn(firstColumn);
            cell.setLastColumn(lastColumn);
            cell.setFirstRow(firstRow);
            cell.setLastRow(lastRow);
            cell.setValue(ExcelTransforUtil.getCellValue(fCell));
            return cell;
        }
        return null;
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    public static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cellType == CellType.BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cellType == CellType.FORMULA) {
            return cell.getCellFormula();
        }
        if (cellType == CellType.NUMERIC) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return "";
    }

    public static Integer getCellRowIndex(String rowName) throws Exception {
        Integer A_charAt = 65;
        Integer Z_charAt = 90;
        Integer full = Z_charAt - A_charAt;
        char[] codeList = rowName.toUpperCase().toCharArray();
        Integer offset = A_charAt - 1;
        int num = 0;
        for (int i = 0; i < codeList.length; ++i) {
            char chr = codeList[i];
            Integer chr_charAt = chr;
            if (chr_charAt < A_charAt || chr_charAt > Z_charAt) {
                throw new Exception("\u975e\u6cd5\u7684\u5355\u5143\u683c\u4f4d\u7f6e\uff01");
            }
            num += chr_charAt - offset + full * i;
        }
        return num;
    }

    public static Map<String, String> splitSingleCellAddr(String cellAddr) {
        String x = new String(cellAddr);
        String y = new String(cellAddr);
        x = x.replaceAll("\\d+", "");
        y = y.replaceAll("[a-zA-Z]+", "");
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("x", x);
        res.put("y", y);
        return res;
    }

    public static void copyPicture(HSSFSheet source, XSSFSheet destination) {
        List<Map<String, Object>> mapList = ExcelTransforUtil.getPicturesFromHSSFSheet(source);
        if (!ObjectUtils.isEmpty(mapList)) {
            XSSFDrawing drawing = destination.createDrawingPatriarch();
            for (Map<String, Object> pictureMap : mapList) {
                HSSFClientAnchor hssfClientAnchor = (HSSFClientAnchor)pictureMap.get("pictureAnchor");
                HSSFRow startRow = source.getRow(hssfClientAnchor.getRow1());
                double startRowHeight = startRow == null ? (double)source.getDefaultRowHeightInPoints() : (double)startRow.getHeightInPoints();
                HSSFRow endRow = source.getRow(hssfClientAnchor.getRow1());
                double endRowHeight = endRow == null ? (double)source.getDefaultRowHeightInPoints() : (double)endRow.getHeightInPoints();
                XSSFClientAnchor xssfClientAnchor = drawing.createAnchor((int)((float)source.getColumnWidth((int)hssfClientAnchor.getCol1()) / 32.0f / 1024.0f * (float)hssfClientAnchor.getDx1() * 9525.0f), (int)(startRowHeight / 256.0 * (double)hssfClientAnchor.getDy1() * 12700.0), (int)((float)source.getColumnWidth((int)hssfClientAnchor.getCol2()) / 32.0f / 1024.0f * (float)hssfClientAnchor.getDx2() * 9525.0f), (int)(endRowHeight / 256.0 * (double)hssfClientAnchor.getDy2() * 12700.0), (int)hssfClientAnchor.getCol1(), hssfClientAnchor.getRow1(), (int)hssfClientAnchor.getCol2(), hssfClientAnchor.getRow2());
                xssfClientAnchor.setAnchorType(hssfClientAnchor.getAnchorType());
                drawing.createPicture(xssfClientAnchor, destination.getWorkbook().addPicture((byte[])pictureMap.get("pictureByteArray"), Integer.parseInt(pictureMap.get("pictureType").toString())));
            }
        }
    }

    public static List<Map<String, Object>> getPicturesFromHSSFSheet(HSSFSheet sheet) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        HSSFPatriarch hssfShapes = sheet.getDrawingPatriarch();
        if (ObjectUtils.isEmpty((Object)hssfShapes)) {
            return null;
        }
        List list = sheet.getDrawingPatriarch().getChildren();
        for (HSSFShape shape : list) {
            if (!(shape instanceof HSSFPicture)) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            HSSFPicture picture = (HSSFPicture)shape;
            HSSFClientAnchor cAnchor = picture.getClientAnchor();
            HSSFPictureData pdata = picture.getPictureData();
            map.put("pictureAnchor", cAnchor);
            map.put("pictureByteArray", pdata.getData());
            map.put("pictureType", pdata.getPictureType());
            map.put("pictureSize", picture.getImageDimension());
            mapList.add(map);
        }
        return mapList;
    }

    public static XSSFWorkbook xlsToxlsx(HSSFWorkbook xls) {
        int sheetNum = xls.getNumberOfSheets();
        XSSFWorkbook newXlsx = new XSSFWorkbook();
        for (int i = 0; i < sheetNum; ++i) {
            int[] oldColumnBreaks;
            PaneInformation paneInformation;
            HSSFSheet oldSheet = xls.getSheetAt(i);
            XSSFSheet newSheet = newXlsx.createSheet(oldSheet.getSheetName());
            oldSheet.getActiveCell();
            ExcelTransforUtil.copyPicture(oldSheet, newSheet);
            if (xls.isSheetHidden(i)) {
                newXlsx.setSheetHidden(i, true);
            }
            if (!Objects.isNull(paneInformation = oldSheet.getPaneInformation())) {
                newSheet.createFreezePane((int)paneInformation.getVerticalSplitPosition(), (int)paneInformation.getHorizontalSplitPosition(), (int)paneInformation.getVerticalSplitLeftColumn(), (int)paneInformation.getHorizontalSplitTopRow());
            }
            for (int j : oldColumnBreaks = oldSheet.getColumnBreaks()) {
                newSheet.setColumnBreak(j);
            }
            newSheet.setDefaultRowHeightInPoints(oldSheet.getDefaultRowHeightInPoints());
            newSheet.setDefaultRowHeight(oldSheet.getDefaultRowHeight());
            newSheet.setDefaultColumnWidth(oldSheet.getDefaultColumnWidth());
            List mergeRegins = oldSheet.getMergedRegions();
            for (int j = 0; j < mergeRegins.size(); ++j) {
                newSheet.addMergedRegion((CellRangeAddress)mergeRegins.get(j));
            }
            XSSFDataValidationHelper helper = new XSSFDataValidationHelper(newSheet);
            List validationList = oldSheet.getDataValidations();
            for (HSSFDataValidation item : validationList) {
                CellRangeAddressList cellRangeAddressList = item.getRegions();
                DataValidationConstraint dvConstraint = item.getValidationConstraint();
                XSSFDataValidationConstraint dv = ExcelTransforUtil.copyDataValidationConstraint(dvConstraint);
                DataValidation dataValidation = helper.createValidation((DataValidationConstraint)dv, cellRangeAddressList);
                newSheet.addValidationData(dataValidation);
            }
            for (int j = 0; j <= oldSheet.getLastRowNum(); ++j) {
                HSSFFont oldFont;
                HSSFRow row = oldSheet.getRow(j);
                if (row == null) continue;
                XSSFRow newRow = newSheet.getRow(j);
                if (Objects.isNull(newRow)) {
                    newRow = newSheet.createRow(j);
                }
                newRow.setHeight(row.getHeight());
                newRow.setHeightInPoints(row.getHeightInPoints());
                newRow.setZeroHeight(row.getZeroHeight());
                XSSFCellStyle newStyle = newXlsx.createCellStyle();
                if (!Objects.isNull(row.getRowStyle()) && !Objects.isNull(oldFont = row.getRowStyle().getFont((Workbook)xls))) {
                    XSSFFont newFont = newXlsx.createFont();
                    ExcelTransforUtil.transXSSFFont(oldFont, newFont);
                    newStyle.setFont((Font)newFont);
                }
                ExcelTransforUtil.transXSSFStyle(row.getRowStyle(), newStyle);
                newRow.setRowStyle((CellStyle)newStyle);
                for (int k = oldSheet.getRow(j).getFirstCellNum(); k < oldSheet.getRow(j).getLastCellNum(); ++k) {
                    HSSFFont oldFont2;
                    newSheet.setColumnWidth(k, oldSheet.getColumnWidth(k));
                    HSSFCell cell = row.getCell(k);
                    if (cell == null) continue;
                    XSSFCell newCell = newRow.getCell(k);
                    if (oldSheet.isColumnHidden(k)) {
                        newSheet.setColumnHidden(k, true);
                    }
                    if (Objects.isNull(newCell)) {
                        newCell = newRow.createCell(k);
                    }
                    XSSFCellStyle newCellStyle = newXlsx.createCellStyle();
                    ExcelTransforUtil.transXSSFStyle(cell.getCellStyle(), newCellStyle);
                    if (!Objects.isNull(cell.getCellStyle()) && !Objects.isNull(oldFont2 = cell.getCellStyle().getFont((Workbook)xls))) {
                        XSSFFont newFont = newXlsx.createFont();
                        ExcelTransforUtil.transXSSFFont(oldFont2, newFont);
                        newCellStyle.setFont((Font)newFont);
                    }
                    newCell.setCellStyle((CellStyle)newCellStyle);
                    XSSFComment newComment = ExcelTransforUtil.copyComment(cell, newSheet.createDrawingPatriarch());
                    newCell.setCellComment((Comment)newComment);
                    newCell.setHyperlink((Hyperlink)cell.getHyperlink());
                    newCell.setCellType(cell.getCellType());
                    switch (cell.getCellType()) {
                        default: 
                    }
                    newCell.setCellValue("");
                }
            }
        }
        return newXlsx;
    }

    private static void transXSSFFont(HSSFFont oldFont, XSSFFont newFont) {
        newFont.setBold(oldFont.getBold());
        newFont.setFontName(oldFont.getFontName());
        newFont.setColor(oldFont.getColor());
        newFont.setFontHeightInPoints(oldFont.getFontHeightInPoints());
        newFont.setItalic(oldFont.getItalic());
        newFont.setCharSet(oldFont.getCharSet());
        newFont.setFontHeight(oldFont.getFontHeight());
        newFont.setStrikeout(oldFont.getStrikeout());
        newFont.setTypeOffset(oldFont.getTypeOffset());
        newFont.setUnderline(oldFont.getUnderline());
    }

    private static XSSFComment copyComment(HSSFCell cell, XSSFDrawing newDrawing) {
        HSSFComment oldComment = cell.getCellComment();
        if (Objects.isNull(oldComment)) {
            return null;
        }
        XSSFClientAnchor anchor = new XSSFClientAnchor();
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(0);
        anchor.setDy2(0);
        anchor.setCol1(cell.getColumnIndex());
        anchor.setRow1(cell.getRowIndex());
        anchor.setCol2(cell.getColumnIndex() + 5);
        anchor.setRow2(cell.getRowIndex() + 6);
        XSSFComment comment = newDrawing.createCellComment((ClientAnchor)anchor);
        HSSFRichTextString str = oldComment.getString();
        XSSFRichTextString newStr = ExcelTransforUtil.copyRichTextString(str);
        comment.setString((RichTextString)newStr);
        return comment;
    }

    private static XSSFRichTextString copyRichTextString(HSSFRichTextString str) {
        XSSFRichTextString newStr = new XSSFRichTextString();
        newStr.setString(str.getString());
        return newStr;
    }

    private static XSSFDataValidationConstraint copyDataValidationConstraint(DataValidationConstraint dvConstraint) {
        XSSFDataValidationConstraint dv = new XSSFDataValidationConstraint(dvConstraint.getExplicitListValues());
        dv.setOperator(dvConstraint.getOperator());
        if (!Objects.isNull(dvConstraint.getFormula1())) {
            dv.setFormula1(dvConstraint.getFormula1());
        }
        if (!Objects.isNull(dvConstraint.getFormula2())) {
            dv.setFormula2(dvConstraint.getFormula2());
        }
        return dv;
    }

    public static void transXSSFStyle(HSSFCellStyle oldStyle, XSSFCellStyle newStyle) {
        if (Objects.isNull(oldStyle)) {
            return;
        }
        newStyle.setBottomBorderColor(oldStyle.getBottomBorderColor());
        newStyle.setTopBorderColor(oldStyle.getTopBorderColor());
        newStyle.setLeftBorderColor(oldStyle.getLeftBorderColor());
        newStyle.setRightBorderColor(oldStyle.getRightBorderColor());
        newStyle.setFillForegroundColor(oldStyle.getFillForegroundColor());
        newStyle.setWrapText(oldStyle.getWrapText());
        newStyle.setDataFormat(oldStyle.getDataFormat());
        newStyle.setFillBackgroundColor(oldStyle.getFillForegroundColor());
        newStyle.setHidden(oldStyle.getHidden());
        newStyle.setIndention(oldStyle.getIndention());
        newStyle.setLocked(oldStyle.getLocked());
        newStyle.setQuotePrefixed(oldStyle.getQuotePrefixed());
        newStyle.setRotation(oldStyle.getRotation());
        newStyle.setShrinkToFit(oldStyle.getShrinkToFit());
    }

    public static byte[] toXlsxByFile(byte[] fileBytes) {
        byte[] data = new byte[]{};
        try (ByteArrayInputStream in = new ByteArrayInputStream(fileBytes);
             ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();){
            XSSFWorkbook xssfWorkbook = ExcelTransforUtil.xlsToxlsx(new HSSFWorkbook((InputStream)in));
            xssfWorkbook.write((OutputStream)arrayOutputStream);
            data = arrayOutputStream.toByteArray();
        }
        catch (IOException ignored) {
            log.error("xls\u8f6c\u5316\u4e3axlsx\u51fa\u73b0\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38");
        }
        catch (Exception e) {
            log.error("xls\u8f6c\u5316xlsx\u5f02\u5e38", (Throwable)e);
        }
        return data;
    }
}

