/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.classification.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.crm.knowledge.knowledge.base.BaseController;
import com.jxdinfo.crm.knowledge.knowledge.config.NoWrapApiResponse;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.classification.entity.Classification;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.classification.model.params.ClassificationParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.classification.service.ClassificationService;
import com.jxdinfo.crm.knowledge.knowledge.pageInfo.LayuiPageInfo;
import com.jxdinfo.crm.knowledge.knowledge.response.ResponseData;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/classification"})
public class ClassificationController
extends BaseController {
    @Autowired
    private ClassificationService classificationService;

    @RequestMapping(value={"/isSerialExist"})
    @ResponseBody
    public ResponseData isSerialExist(String serial) {
        String r = this.classificationService.getSerialByone(serial);
        if ("1".equals(r)) {
            return ResponseData.error("\u8282\u70b9\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        return ResponseData.success();
    }

    @RequestMapping(value={"/addItem"})
    @ResponseBody
    @NoWrapApiResponse
    public ResponseData addItem(@RequestBody ClassificationParam classificationParam) {
        String order = this.classificationService.getShowOrder();
        classificationParam.setShowOrder(Integer.parseInt(order) + 1);
        String id = "";
        SecurityUser user = BaseSecurityUtil.getUser();
        Date date = new Date();
        classificationParam.setCreateTime(date);
        try {
            id = this.classificationService.add(classificationParam);
        }
        catch (Exception e) {
            return ResponseData.error("error");
        }
        return ResponseData.success(id);
    }

    @RequestMapping(value={"/editItem"})
    @ResponseBody
    @NoWrapApiResponse
    public ResponseData editItem(@RequestBody ClassificationParam classificationParam) {
        Date date = new Date();
        classificationParam.setUpdateTiime(date);
        try {
            this.classificationService.update(classificationParam);
        }
        catch (Exception e) {
            return ResponseData.error("error");
        }
        return ResponseData.success();
    }

    @NoWrapApiResponse
    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseData delete(String ids) {
        JSONArray list = JSONArray.parseArray((String)ids);
        String num = this.classificationService.getSonPoint((List)list);
        String knowNum = this.classificationService.getKnowNum((List)list);
        if ("0".equals(num)) {
            if ("0".equals(knowNum)) {
                try {
                    this.classificationService.delete((List)list);
                }
                catch (Exception e) {
                    return ResponseData.error("error");
                }
                return ResponseData.success();
            }
            return ResponseData.error("\u9009\u4e2d\u7684\u76ee\u5f55\u4e0b\u6709\u6587\u4ef6");
        }
        return ResponseData.error("\u9009\u4e2d\u7684\u76ee\u5f55\u5305\u542b\u5b50\u76ee\u5f55");
    }

    @NoWrapApiResponse
    @RequestMapping(value={"/detail"})
    @ResponseBody
    public ResponseData detail(ClassificationParam classificationParam) {
        Classification detail = (Classification)this.classificationService.getById((Serializable)((Object)classificationParam.getId()));
        return ResponseData.success(detail);
    }

    @ResponseBody
    @NoWrapApiResponse
    @RequestMapping(value={"/list"})
    public LayuiPageInfo list(ClassificationParam classificationParam, String id) {
        return this.classificationService.findPageBySpec(classificationParam, id);
    }

    @ResponseBody
    @RequestMapping(value={"/treeList"})
    public Object treeList(String id, String type) {
        List<Object> clazzList = new ArrayList();
        if ("0".equals(type) || StringUtils.isEmpty((Object)type)) {
            clazzList = this.classificationService.getTreeList(id);
        }
        if ("1".equals(type)) {
            clazzList = this.classificationService.getAllList(id);
        }
        HashMap<String, Map> clazzMap = new HashMap<String, Map>();
        for (Object item : clazzList) {
            Map map = (Map)JSON.parse((String)JSON.toJSONString((Object)item));
            map.put("title", item.get("classificationName"));
            map.put("children", new ArrayList());
            clazzMap.put(item.get("id").toString(), map);
        }
        ArrayList<Map> clazzTree = new ArrayList<Map>();
        for (Map map : clazzList) {
            Map row;
            if (clazzMap.containsKey(map.get("parentId"))) {
                row = (Map)clazzMap.get(map.get("id"));
                List children = (List)((Map)clazzMap.get(map.get("parentId"))).get("children");
                row.put("id", map.get("id"));
                children.add(row);
                continue;
            }
            row = (Map)clazzMap.get(map.get("id"));
            row.put("id", map.get("id"));
            clazzTree.add(row);
        }
        HashMap<String, Object> clazz = new HashMap<String, Object>();
        clazz.put("children", clazzTree);
        clazz.put("text", "\u5355\u4f4d\u4fe1\u606f");
        clazz.put("type", "isRoot");
        return clazzTree;
    }

    @ResponseBody
    @RequestMapping(value={"/ztreeList"})
    public Object ztreeList(String id, String type, String mutual) {
        List<Object> clazzList = new ArrayList();
        if (StringUtils.isEmpty((Object)mutual)) {
            if ("0".equals(type) || StringUtils.isEmpty((Object)type)) {
                clazzList = this.classificationService.getTreeList(id);
            }
            if ("1".equals(type)) {
                clazzList = this.classificationService.getAllList(id);
            }
        } else {
            clazzList = this.classificationService.getMutualAllList(id);
        }
        HashMap<String, Map> clazzMap = new HashMap<String, Map>();
        for (Map map : clazzList) {
            Map map2 = (Map)JSON.parse((String)JSON.toJSONString((Object)map));
            map2.put("name", map.get("classificationName"));
            map2.put("children", new ArrayList());
            clazzMap.put(map.get("id").toString(), map2);
        }
        ArrayList<Map> clazzTree = new ArrayList<Map>();
        for (Map map : clazzList) {
            Map row;
            if (clazzMap.containsKey(map.get("parentId"))) {
                row = (Map)clazzMap.get(map.get("id"));
                List children = (List)((Map)clazzMap.get(map.get("parentId"))).get("children");
                row.put("id", map.get("id"));
                children.add(row);
                continue;
            }
            row = (Map)clazzMap.get(map.get("id"));
            row.put("id", map.get("id"));
            clazzTree.add(row);
        }
        return clazzTree;
    }

    @ResponseBody
    @NoWrapApiResponse
    @RequestMapping(value={"/upDownType"})
    public ApiResponse upDownType(String id, String type) {
        return this.classificationService.upDownClass(id, type);
    }
}

