/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.idutils;

import com.jxdinfo.crm.knowledge.knowledge.modular.common.basicmata.entity.BasicMeta;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.constants.KnowledgeConstants;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.ToolUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IdUtil {
    @Autowired
    private ISysDicRefService dictService;

    @Transactional
    public String getId(BasicMeta basicMeta) {
        if (StringUtils.isBlank((CharSequence)basicMeta.getTypeMain()) || StringUtils.isBlank((CharSequence)basicMeta.getType()) || StringUtils.isBlank((CharSequence)basicMeta.getLevelType()) || basicMeta.getProcessDate() == null) {
            return null;
        }
        String id = "";
        String levelType = basicMeta.getLevelType();
        List levelTypes = this.dictService.getDictByType("level_type");
        for (DicSingle level : levelTypes) {
            if (!levelType.equals(level.getTypeName())) continue;
            id = id + level.getTypeName();
            break;
        }
        String type = basicMeta.getType();
        List typeIdentifiers = this.dictService.getDictByType("KNOWLEDGE_TYPE");
        for (DicSingle typeIdentifier : typeIdentifiers) {
            if (!typeIdentifier.getTypeName().equals(type)) continue;
            id = id + typeIdentifier.getTypeDesc();
            break;
        }
        Date createTime = basicMeta.getCreateTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String formatDate = simpleDateFormat.format(createTime);
        id = id + formatDate;
        SecurityUser user = BaseSecurityUtil.getUser();
        String deptSymbol = user.getDeptCode();
        if (deptSymbol.length() > KnowledgeConstants.DEPT_SYMBOL_LENGTH) {
            deptSymbol = deptSymbol.substring(deptSymbol.length() - 3);
        }
        id = id + deptSymbol;
        String uuid = UUID.randomUUID().toString().replace("-", "");
        id = id + uuid;
        return id.toLowerCase();
    }

    public String formatId(String id) {
        if (ToolUtil.isEmpty(id) || id.length() < 20) {
            return "";
        }
        String upperCaseId = id.toUpperCase();
        return upperCaseId.substring(0, 11) + "-" + upperCaseId.substring(11, 14) + "-" + upperCaseId.substring(14);
    }

    public String unFormatId(String id) {
        return id.toLowerCase().replace("-", "");
    }
}

