/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils;

import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.ToolUtil;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.idutils.entity.CommonsMultipartFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    public static MultipartFile fileToMultipartFile(File file) {
        FileItem fileItem = FileUtil.createFileItem(file);
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(fileItem);
        return multipartFile;
    }

    private static FileItem createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(file);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }

    public static File multipartFileToFile(MultipartFile file) throws Exception {
        File toFile = null;
        if (file == null || file.getSize() <= 0L) {
            return toFile;
        }
        InputStream ins = null;
        ins = file.getInputStream();
        toFile = new File(file.getOriginalFilename());
        FileUtil.inputStreamToFile(ins, toFile);
        ins.close();
        return toFile;
    }

    private static void inputStreamToFile(InputStream ins, File file) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            ins.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void delteTempFile(File file) {
        if (file != null) {
            File del = new File(file.toURI());
            del.delete();
        }
    }

    public static String getFileSize(Long len) {
        String fileSize = "";
        fileSize = len < 1024L ? len + "B" : (len < 0x100000L ? len / 1024L + "KB" : (len < 0x40000000L ? len / 0x100000L + "MB" : len / 0x40000000L + "GB"));
        return fileSize;
    }

    public static String getContentType(String suffix) {
        String contentType = null;
        if (suffix.equals(".doc") || suffix.equals(".docx") || suffix.equals(".dotx") || suffix.equals(".tif")) {
            contentType = "application/msword";
            return contentType;
        }
        if (suffix.equals(".ppt") || suffix.equals(".pptx") || suffix.equals(".ppsx")) {
            contentType = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            return contentType;
        }
        if (suffix.equals(".xls") || suffix.equals(".xlsx") || suffix.equals(".et")) {
            contentType = "spreadsheetml";
            return contentType;
        }
        if (suffix.equals(".png") || suffix.equals(".gif") || suffix.equals(".jpg") || suffix.equals(".bmp") || suffix.equals(".jpeg")) {
            contentType = "image";
            return contentType;
        }
        if (suffix.equals(".txt") || suffix.equals(".csv")) {
            contentType = "text/plain";
            return contentType;
        }
        if (suffix.equals(".pdf")) {
            contentType = "application/pdf";
            return contentType;
        }
        if (suffix.equals(".mp3")) {
            contentType = "audio/mp3";
            return contentType;
        }
        if (suffix.equals(".mov")) {
            contentType = "audio/mov";
            return contentType;
        }
        if (suffix.equals(".mp4")) {
            contentType = "video/mp4";
            return contentType;
        }
        if (suffix.equals(".wav")) {
            contentType = "audio/wav";
            return contentType;
        }
        if (suffix.equals(".wmv")) {
            contentType = "audio/wmv";
            return contentType;
        }
        if (suffix.equals(".mpg")) {
            contentType = "audio/mpg";
            return contentType;
        }
        if (suffix.equals(".avi")) {
            contentType = "video/avi";
            return contentType;
        }
        if (suffix.equals(".flv")) {
            contentType = "video/flv";
            return contentType;
        }
        if (suffix.equals(".ceb")) {
            contentType = "ceb";
            return contentType;
        }
        if (suffix.equals(".dwg") || suffix.equals(".dwf") || suffix.equals(".dxf")) {
            contentType = "cad";
            return contentType;
        }
        if (suffix.equals(".zip")) {
            contentType = "application/x-zip-compressed";
            return contentType;
        }
        if (suffix.equals(".sql")) {
            contentType = "text/x-sql";
            return contentType;
        }
        if (suffix.equals(".rar") || suffix.equals(".tif")) {
            contentType = "application/octet-stream";
            return contentType;
        }
        if (suffix.equals(".xml")) {
            contentType = "text/xml";
            return contentType;
        }
        if (suffix.equals(".wps")) {
            contentType = "application/vnd.ms-works";
            return contentType;
        }
        return null;
    }

    public static String hashKeyForDisk(String key) {
        String cacheKey;
        if (ToolUtil.isEmpty(key)) {
            return null;
        }
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = FileUtil.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String getFilecharset(File sourceFile) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                return charset;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                charset = "UTF-16BE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = "UTF-8";
                checked = true;
            }
            bis.reset();
            if (!checked) {
                int loc = 0;
                while ((read = bis.read()) != -1) {
                    ++loc;
                    if (read >= 240 || 128 <= read && read <= 191) break;
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    public static String readJsonFile(File jsonFile) {
        String jsonStr = "";
        try {
            if (!jsonFile.exists()) {
                return null;
            }
            FileReader fileReader = new FileReader(jsonFile);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
            int ch = 0;
            StringBuffer sb = new StringBuffer();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            fileReader.close();
            ((Reader)reader).close();
            jsonStr = sb.toString();
            return jsonStr;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File saveFile(String filePath, String fileName, byte[] data) throws Exception {
        File file = null;
        if (ToolUtil.isNotEmpty(filePath) && fileName != null && data != null) {
            File f = new File(filePath);
            if (!f.exists()) {
                f.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data, 0, data.length);
            fos.flush();
            fos.close();
        }
        return file;
    }

    public static boolean deleteDir(File dir) {
        if (!dir.exists()) {
            return false;
        }
        if (dir.isDirectory()) {
            String[] childrens;
            for (String child : childrens = dir.list()) {
                boolean success = FileUtil.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

