/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileStorageUtil {
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    private static FileStorageUtil fileStorageUtil;

    @PostConstruct
    public void init() {
        fileStorageUtil = this;
        FileStorageUtil.fileStorageUtil.attachmentManagerService = this.attachmentManagerService;
    }

    public static String uploadFile(MultipartFile file, String fileName) {
        try {
            return ((Long)FileStorageUtil.fileStorageUtil.attachmentManagerService.backgroundUpload(file).getData()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String uploadFile(File file) {
        try {
            MultipartFile multipartFile = FileStorageUtil.convert(file);
            return ((Long)FileStorageUtil.fileStorageUtil.attachmentManagerService.backgroundUpload(multipartFile).getData()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String uploadFile(File file, String fileName) {
        try {
            MultipartFile multipartFile = FileStorageUtil.convert(file);
            return ((Long)FileStorageUtil.fileStorageUtil.attachmentManagerService.backgroundUpload(multipartFile).getData()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String uploadFile(InputStream inputStream, String fileName, String contentType) {
        try {
            MockMultipartFile multipartFile;
            if ("docx".equals(fileName.substring(fileName.lastIndexOf(".") + 1))) {
                XWPFDocument docx = new XWPFDocument(inputStream);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                docx.write((OutputStream)outputStream);
                multipartFile = new MockMultipartFile(fileName, (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            } else {
                multipartFile = new MockMultipartFile(fileName, inputStream);
            }
            return ((Long)FileStorageUtil.fileStorageUtil.attachmentManagerService.backgroundUpload((MultipartFile)multipartFile).getData()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] downloadFile(String id) {
        try {
            if (ToolUtil.isEmpty((Object)id)) {
                return null;
            }
            Long fileId = Long.parseLong(id);
            Boolean isExist = (Boolean)FileStorageUtil.fileStorageUtil.attachmentManagerService.isExist(fileId).getData();
            if (!isExist.booleanValue()) {
                return null;
            }
            return (byte[])FileStorageUtil.fileStorageUtil.attachmentManagerService.backgroundDownload(fileId).getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File downloadFile(String id, String path) {
        if (ToolUtil.isEmpty((Object)id) || ToolUtil.isEmpty((Object)path)) {
            return null;
        }
        byte[] fileData = FileStorageUtil.downloadFile(id);
        File file = null;
        try {
            if (fileData != null && fileData.length > 0) {
                file = new File(path);
                if (file.exists()) {
                    file.delete();
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(fileData, 0, fileData.length);
                fos.flush();
                fos.close();
            }
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteFile(String id) {
        try {
            if (ToolUtil.isEmpty((Object)id)) {
                return;
            }
            Long fileId = Long.parseLong(id);
            Boolean isExist = (Boolean)FileStorageUtil.fileStorageUtil.attachmentManagerService.isExist(fileId).getData();
            if (!isExist.booleanValue()) {
                return;
            }
            FileStorageUtil.fileStorageUtil.attachmentManagerService.deleteFile(fileId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static File getFile(String id) {
        byte[] fileData = FileStorageUtil.downloadFile(id);
        File file = null;
        try {
            if (fileData != null && fileData.length > 0) {
                file.createNewFile();
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(fileData, 0, fileData.length);
                fos.flush();
                fos.close();
            }
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getFile(String id, String filePath, String suffix) {
        byte[] fileData = FileStorageUtil.downloadFile(id);
        File file = new File(filePath + UUID.randomUUID().toString().replaceAll("-", "") + suffix);
        try {
            if (fileData != null && fileData.length > 0) {
                file.createNewFile();
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(fileData, 0, fileData.length);
                fos.flush();
                fos.close();
            }
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return file;
        }
    }

    public static String dataUploadFile(File file, String fileName) {
        try {
            MultipartFile multipartFile = FileStorageUtil.convert(file);
            String id = ((Long)FileStorageUtil.fileStorageUtil.attachmentManagerService.backgroundUpload(multipartFile).getData()).toString();
            file.delete();
            return id;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MultipartFile convert(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        MockMultipartFile multipartFile = new MockMultipartFile("file", file.getName(), "text/plain", (InputStream)input);
        return multipartFile;
    }

    public static String replaceseparator(String path) {
        return path.replace("/", File.separator);
    }
}

