/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.file.service.impl;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.fileinfo.model.PreviewFileInfo;
import com.jxdinfo.crm.common.fileinfo.service.IPreviewFileInfoService;
import com.jxdinfo.crm.core.crm.datasourcefolder.sysfileinfo1.model.SysFileInfo1;
import com.jxdinfo.crm.core.crm.datasourcefolder.sysfileinfo1.service.SysFileInfo1Service;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.basicmata.entity.BasicMeta;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.basicmata.service.BasicMetaService;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.classification.service.ClassificationService;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.constants.KnowledgeConstants;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.entity.KnowledgeFileInfo;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.mapper.KnowledgeFileInfoMapper;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.model.params.FileInfoKnowledge;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.model.params.KnowledgeFileInfoParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.model.result.FileType;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.model.result.KnowledgeFileInfoResult;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.service.KnowledgeFileInfoService;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.FileStorageUtil;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.FileUtil;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.LibreOfficePDFConvertCur;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.MD5Util;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.SaveFileCallback;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.ThumbnailsUtil;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.TikaUtil;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.ToolUtil;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.resourcelog.model.params.ResourceLogParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.resourcelog.service.ResourceLogService;
import com.jxdinfo.crm.knowledge.knowledge.pageInfo.LayuiPageFactory;
import com.jxdinfo.crm.knowledge.knowledge.pageInfo.LayuiPageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class KnowledgeFileInfoServiceImpl
extends ServiceImpl<KnowledgeFileInfoMapper, KnowledgeFileInfo>
implements KnowledgeFileInfoService {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeFileInfoServiceImpl.class);
    @Autowired
    private GridFsTemplate gridFsTemplate;
    @Autowired
    private GridFSBucket gridFSBucket;
    @Lazy
    @Autowired
    private BasicMetaService basicMetaService;
    @Autowired
    private ClassificationService classificationService;
    @Autowired
    private ResourceLogService resourceLogService;
    @Autowired
    private SysFileInfo1Service sysFileInfo1Service;
    @Autowired
    private IPreviewFileInfoService previewFileInfoService;

    @Override
    public void add(KnowledgeFileInfoParam param) {
        KnowledgeFileInfo entity = this.getEntity(param);
        this.save(entity);
    }

    @Override
    public void delete(KnowledgeFileInfoParam param) {
        this.removeById(this.getKey(param));
    }

    @Override
    public void update(KnowledgeFileInfoParam param) {
        KnowledgeFileInfo oldEntity = this.getOldEntity(param);
        KnowledgeFileInfo newEntity = this.getEntity(param);
        ToolUtil.copyProperties(newEntity, oldEntity);
        this.updateById(newEntity);
    }

    @Override
    public KnowledgeFileInfoResult findBySpec(KnowledgeFileInfoParam param) {
        return null;
    }

    @Override
    public List<KnowledgeFileInfoResult> findListBySpec(KnowledgeFileInfoParam param) {
        return null;
    }

    @Override
    public LayuiPageInfo findPageBySpec(KnowledgeFileInfoParam param) {
        Page pageContext = this.getPageContext();
        Page<KnowledgeFileInfoResult> page = ((KnowledgeFileInfoMapper)this.baseMapper).customPageList(pageContext, param);
        return LayuiPageFactory.createPageInfo(page);
    }

    private Serializable getKey(KnowledgeFileInfoParam param) {
        return param.getId();
    }

    private Page getPageContext() {
        return LayuiPageFactory.defaultPage();
    }

    private KnowledgeFileInfo getOldEntity(KnowledgeFileInfoParam param) {
        return (KnowledgeFileInfo)this.getById(this.getKey(param));
    }

    private KnowledgeFileInfo getEntity(KnowledgeFileInfoParam param) {
        KnowledgeFileInfo entity = new KnowledgeFileInfo();
        ToolUtil.copyProperties(param, entity);
        return entity;
    }

    @Override
    public List<KnowledgeFileInfo> getInfoByMd5(String fileMd5) {
        if (ToolUtil.isEmpty(fileMd5)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(KnowledgeFileInfo::getMd5, (Object)fileMd5)).isNotNull(KnowledgeFileInfo::getMongoFileId)).list();
    }

    @Override
    public String uploadFileToMongo(MultipartFile file, String originalFilename) throws IOException {
        InputStream ins = file.getInputStream();
        String contentType = file.getContentType();
        ObjectId objectId = this.gridFsTemplate.store(ins, originalFilename, contentType);
        return objectId.toString();
    }

    @Override
    public void downloadFile(String fileId, HttpServletResponse response) {
        try {
            if (fileId == null) {
                return;
            }
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)fileId));
            GridFSFile gridFSFile = this.gridFsTemplate.findOne(query);
            if (gridFSFile == null) {
                return;
            }
            String fileName = gridFSFile.getFilename().replace(",", "");
            String contentType = gridFSFile.getMetadata().get((Object)"_contentType").toString();
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\"");
            GridFSDownloadStream gridFSDownloadStream = this.gridFSBucket.openDownloadStream(gridFSFile.getObjectId());
            GridFsResource resource = new GridFsResource(gridFSFile, (InputStream)gridFSDownloadStream);
            ServletOutputStream outputStream = response.getOutputStream();
            InputStream inputStream = resource.getInputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void toDeleteChunks(String fileId) {
        File breakFile = new File(KnowledgeConstants.FILEPATH_BREAK + File.separator + KnowledgeConstants.UPLOADFILE_MAP.get("fileId_" + fileId));
        if (breakFile.isDirectory() && breakFile.exists()) {
            File[] fileArray;
            for (File file : fileArray = breakFile.listFiles()) {
                file.delete();
            }
            breakFile.delete();
        }
    }

    @Override
    public boolean removeFile(String fileId) {
        KnowledgeFileInfo fileInfo = (KnowledgeFileInfo)((LambdaQueryChainWrapper)this.lambdaQuery().eq(KnowledgeFileInfo::getId, (Object)fileId)).one();
        if (fileInfo != null) {
            Query deleteFileQuery = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)fileInfo.getMongoFileId()));
            this.gridFsTemplate.delete(deleteFileQuery);
            String pdfFileId = fileInfo.getFilePdfId();
            if (ToolUtil.isNotEmpty(pdfFileId)) {
                deleteFileQuery = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)pdfFileId));
                this.gridFsTemplate.delete(deleteFileQuery);
            }
            this.removeById((Serializable)((Object)fileInfo.getId()));
        }
        return true;
    }

    @Override
    public Map<String, Object> fileUploadNew(FileInfoKnowledge fileInfoParam, SecurityUser user) {
        String fileName = fileInfoParam.getName();
        String fileId = fileInfoParam.getId();
        Long dataSize = fileInfoParam.getSize();
        String fileType = fileInfoParam.getType();
        HashMap<String, Object> result = new HashMap<String, Object>();
        SysFileInfo1 sysFileInfo = (SysFileInfo1)this.sysFileInfo1Service.getById((Serializable)((Object)fileId));
        if (sysFileInfo != null) {
            String filePath = sysFileInfo.getAttachmentDir() + sysFileInfo.getFileId() + "." + sysFileInfo.getAttachmentType();
            File outputFile = new File(filePath);
            result.put("outputFile", outputFile);
            Map<String, String> map = this.changeFileNew(outputFile, fileName);
            String changeFileId = null;
            String content = null;
            if (map != null) {
                changeFileId = map.get("changeFileId");
                content = map.get("content");
            }
            try {
                String mongoFileId = fileId;
                this.updateFileInfo(fileId, changeFileId, content, mongoFileId);
                result.put("code", "2");
            }
            catch (Exception e) {
                log.error(" IO Exception:" + e.getMessage());
                result.put("code", "0");
                result.put("msg", "\u4fdd\u5b58\u5408\u5e76\u6587\u4ef6\u62a5\u9519");
            }
        }
        return result;
    }

    private void updateFileInfo(String fileId, String changeFileId, String content, String mongoFileId) {
        KnowledgeFileInfo fileInfo = (KnowledgeFileInfo)((LambdaQueryChainWrapper)this.lambdaQuery().eq(KnowledgeFileInfo::getId, (Object)fileId)).one();
        if (fileInfo != null) {
            fileInfo.setMongoFileId(mongoFileId);
            fileInfo.setFileContext(content);
            String suffix = fileInfo.getFileSuffix();
            if (".pdf".equals(suffix) || ".xls".equals(suffix) || ".xlsx".equals(suffix)) {
                changeFileId = mongoFileId;
            }
            fileInfo.setFilePdfId(changeFileId);
            try {
                if (changeFileId != null) {
                    PreviewFileInfo previewFileInfo = new PreviewFileInfo();
                    previewFileInfo.setId(Long.parseLong(CommonUtills.generateAssignId()));
                    previewFileInfo.setFileId(Long.valueOf(fileId));
                    previewFileInfo.setPreviewFileId(Long.valueOf(changeFileId));
                    this.previewFileInfoService.save((Object)previewFileInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateById(fileInfo);
        }
    }

    @Override
    public void saveFile(String basicMetaId, Map<String, String> map, File outputFile, String fileName, String fileMd5, Long dataSize, String fileType, SecurityUser user) {
        try {
            String changeFileId = null;
            String content = null;
            if (map != null) {
                changeFileId = map.get("changeFileId");
                content = map.get("content");
            }
            MultipartFile file = FileUtil.fileToMultipartFile(outputFile);
            String mongoFileId = this.uploadFileToMongo(file, fileName);
            KnowledgeFileInfo fileInfo = new KnowledgeFileInfo();
            fileInfo.setBasicMetaId(basicMetaId);
            fileInfo.setMongoFileId(mongoFileId);
            fileInfo.setFileName(fileName);
            fileInfo.setFileHash(FileUtil.hashKeyForDisk(fileName));
            fileInfo.setFileSize(FileUtil.getFileSize(dataSize));
            String suffix = fileName.substring(fileName.lastIndexOf(".")).toLowerCase();
            fileInfo.setFileSuffix(suffix);
            fileInfo.setFileType(fileType);
            fileInfo.setMd5(fileMd5);
            if (".pdf".equals(suffix)) {
                changeFileId = mongoFileId;
            }
            fileInfo.setFilePdfId(changeFileId);
            fileInfo.setFileContext(content);
            fileInfo.setCreateTime(new Date());
            fileInfo.setDataSize(dataSize);
            this.save(fileInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> mergeChunks(FileInfoKnowledge fileInfoParam) {
        String fileName = fileInfoParam.getName();
        String fileId = fileInfoParam.getId();
        log.info("******************\u6587\u4ef6:" + fileName + "\u5f00\u59cb\u4e0a\u4f20******************");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "1");
        try {
            File f = new File(KnowledgeConstants.FILEPATH_BREAK + File.separator + KnowledgeConstants.UPLOADFILE_MAP.get("fileId_" + fileId));
            File[] fileArray = f.listFiles();
            File nullFile = new File(KnowledgeConstants.FILEPATH_BREAK + File.separator + KnowledgeConstants.UPLOADFILE_MAP.get("fileId_" + fileId) + File.separator + "null");
            if (fileArray.length > 1 && nullFile.exists()) {
                nullFile.delete();
            }
            ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(fileArray));
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    if (Integer.parseInt(o1.getName()) < Integer.parseInt(o2.getName())) {
                        return -1;
                    }
                    return 1;
                }
            });
            int pointIndex = fileName.lastIndexOf(".");
            String suffix = fileName.substring(pointIndex).toLowerCase();
            String random = UUID.randomUUID().toString().replace("-", "");
            File outputFile = new File(KnowledgeConstants.FILEPATH_TEMP + File.separator + KnowledgeConstants.UPLOADFILE_MAP.get("fileId_" + fileId) + File.separator + random + suffix);
            try {
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                outputFile.createNewFile();
            }
            catch (IOException e) {
                result.put("code", "0");
                result.put("msg", "\u751f\u6210\u5408\u5e76\u6587\u4ef6\u62a5\u9519");
                return result;
            }
            FileChannel outChannel = new FileOutputStream(outputFile).getChannel();
            FileInputStream fileInputStream = new FileInputStream(outputFile);
            for (File file : fileList) {
                FileChannel inChannel = new FileInputStream(file).getChannel();
                byte[] data = null;
                data = new byte[(int)inChannel.size()];
                fileInputStream.read(data);
                try {
                    inChannel.transferTo(0L, inChannel.size(), outChannel);
                }
                catch (Exception e) {
                    log.error(" Exception:" + e.getMessage());
                    result.put("code", "0");
                    result.put("msg", "\u751f\u6210\u5408\u5e76\u6587\u4ef6\u62a5\u9519");
                    HashMap<String, Object> hashMap = result;
                    return hashMap;
                }
                finally {
                    inChannel.close();
                }
                file.delete();
            }
            if (outChannel != null) {
                outChannel.close();
            }
            fileInputStream.close();
            File breakFile = new File(KnowledgeConstants.FILEPATH_BREAK + File.separator + KnowledgeConstants.UPLOADFILE_MAP.get("fileId_" + fileId));
            if (breakFile.isDirectory() && breakFile.exists()) {
                breakFile.delete();
            }
            if (ToolUtil.isNotEmpty(KnowledgeConstants.UPLOADFILE_MAP.get("fileId_" + fileId))) {
                KnowledgeConstants.UPLOADFILE_MAP.remove("fileId_" + fileId);
            }
            log.info("******************\u6587\u4ef6:" + fileName + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + outputFile.getPath() + ",\u5927\u5c0f\u4e3a" + outputFile.length() + "******************");
            result.put("code", "2");
            result.put("outputFile", outputFile);
            return result;
        }
        catch (Exception e) {
            log.error("file merge failure:" + e.getMessage());
            result.put("code", "0");
            result.put("msg", "\u751f\u6210\u5408\u5e76\u6587\u4ef6\u62a5\u9519");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readPdfFile(File pdfFile) {
        try (PDDocument document = PDDocument.load((File)pdfFile);){
            String text;
            PDFTextStripper stripper = new PDFTextStripper();
            String string = text = stripper.getText(document);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519: " + e.getMessage();
        }
    }

    @Override
    public Map<String, String> changeFile(File outputFile, String fileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (!outputFile.exists()) {
                return null;
            }
            String sourcePath = outputFile.getPath();
            File changeFile = null;
            String changeFileId = null;
            String content = null;
            String suffix = sourcePath.substring(sourcePath.lastIndexOf("."));
            String contentType = FileUtil.getContentType(suffix);
            if (contentType == null) {
                contentType = FileUtil.fileToMultipartFile(outputFile).getContentType();
            }
            if ("pdf".equals(suffix)) {
                Map<String, Object> metadata = TikaUtil.autoParse(sourcePath);
                content = metadata.get("content").toString().replaceAll("<", "<&nbsp;");
            } else {
                boolean toChangePdf = false;
                if (sourcePath.endsWith(".doc") || sourcePath.endsWith(".docx") || contentType.contains("powerpoint") || contentType.contains("presentationml")) {
                    toChangePdf = true;
                } else if (contentType.contains("excel") || contentType.contains("spreadsheetml")) {
                    toChangePdf = true;
                } else if ((contentType.contains("octet-stream") || contentType.contains("text/plain")) && sourcePath.endsWith(".txt")) {
                    String type = FileUtil.getFilecharset(outputFile);
                    if (type.equals("GBK") || type.equals("ANSI")) {
                        String str = FileUtils.readFileToString((File)outputFile, (String)"GBK");
                        FileUtils.writeStringToFile((File)outputFile, (String)str, (String)"UTF-8");
                    }
                    toChangePdf = true;
                }
                if (toChangePdf) {
                    String changeName = fileName.substring(0, fileName.lastIndexOf(".")) + ".pdf";
                    changeFile = LibreOfficePDFConvertCur.convertFile(outputFile);
                    if (!contentType.contains("excel")) {
                        changeFileId = this.uploadFileToMongo(FileUtil.fileToMultipartFile(changeFile), changeName);
                    }
                    Map<String, Object> metadata = TikaUtil.autoParse(changeFile.getPath());
                    content = metadata.get("content").toString().replaceAll("<", "<&nbsp;");
                }
            }
            map.put("changeFileId", changeFileId);
            map.put("content", content);
            if (changeFile != null && changeFile.exists()) {
                changeFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            map = null;
        }
        return map;
    }

    @Override
    public Map<String, String> changeFileNew(File outputFile, String fileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (!outputFile.exists()) {
                return null;
            }
            String sourcePath = outputFile.getPath();
            File changeFile = null;
            String changeFileId = null;
            String content = null;
            String suffix = sourcePath.substring(sourcePath.lastIndexOf("."));
            String contentType = FileUtil.getContentType(suffix);
            if (contentType == null) {
                contentType = FileUtil.fileToMultipartFile(outputFile).getContentType();
            }
            if ("pdf".equals(suffix)) {
                Map<String, Object> metadata = TikaUtil.autoParse(sourcePath);
                content = metadata.get("content").toString().replaceAll("<", "<&nbsp;");
            } else {
                boolean toChangePdf = false;
                if (sourcePath.endsWith(".doc") || sourcePath.endsWith(".docx") || contentType.contains("powerpoint") || contentType.contains("presentationml")) {
                    toChangePdf = true;
                } else if (contentType.contains("excel") || contentType.contains("spreadsheetml")) {
                    toChangePdf = true;
                } else if ((contentType.contains("octet-stream") || contentType.contains("text/plain")) && sourcePath.endsWith(".txt")) {
                    String type = FileUtil.getFilecharset(outputFile);
                    if (type.equals("GBK") || type.equals("ANSI")) {
                        String str = FileUtils.readFileToString((File)outputFile, (String)"GBK");
                        FileUtils.writeStringToFile((File)outputFile, (String)str, (String)"UTF-8");
                    }
                    toChangePdf = true;
                }
                if (toChangePdf) {
                    File f;
                    String text;
                    Map<String, Object> metadata;
                    String pdfPath = sourcePath.substring(0, sourcePath.lastIndexOf(".")) + ".pdf";
                    String changeName = fileName.substring(0, fileName.lastIndexOf(".")) + ".pdf";
                    changeFile = new File(pdfPath);
                    LibreOfficePDFConvertCur.doDocToFdpLibre(outputFile, changeFile);
                    if (!contentType.contains("excel")) {
                        changeFileId = FileStorageUtil.uploadFile(FileUtil.fileToMultipartFile(changeFile), changeName);
                    }
                    if ((content = (metadata = TikaUtil.autoParse(changeFile.getPath())).get("content").toString().replaceAll("<", "<&nbsp;")).equals("") && !(text = KnowledgeFileInfoServiceImpl.readPdfFile(f = new File(pdfPath))).equals("")) {
                        content = text;
                    }
                }
            }
            map.put("changeFileId", changeFileId);
            map.put("content", content);
            if (changeFile != null && changeFile.exists()) {
                changeFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            map = null;
        }
        return map;
    }

    @Override
    public Object saveFileInfoList(String basicMetaId, String fileInfo, SaveFileCallback callback) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (ToolUtil.isEmpty(basicMetaId)) {
            resultMap.put("code", "0");
            resultMap.put("msg", "\u57fa\u7840\u5143\u6570\u636eid\u4e3a\u7a7a");
            return resultMap;
        }
        List fileInfoList = JSONArray.parseArray((String)fileInfo, FileInfoKnowledge.class);
        if (fileInfoList == null || fileInfoList.size() == 0) {
            this.basicMetaService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BasicMeta::getId, (Object)basicMetaId)).set(BasicMeta::getFileHandleState, (Object)"2"));
            resultMap.put("code", "2");
            resultMap.put("msg", "\u6587\u4ef6\u4fdd\u5b58\u5b8c\u6210");
            return resultMap;
        }
        SecurityUser user = new SecurityUser();
        boolean success = this.insertFileInfoList(fileInfoList);
        if (success) {
            if (fileInfoList.size() > 0) {
                // empty if block
            }
        } else {
            this.basicMetaService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BasicMeta::getId, (Object)basicMetaId)).set(BasicMeta::getFileHandleState, (Object)"2"));
            resultMap.put("code", "2");
            resultMap.put("msg", "\u6587\u4ef6\u4fdd\u5b58\u5b8c\u6210");
        }
        return resultMap;
    }

    @Override
    public Object saveFileInfoListNoThread(List<FileInfoKnowledge> fileInfoList) {
        SecurityUser user = new SecurityUser();
        boolean success = this.insertFileInfoList(fileInfoList);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (success && fileInfoList.size() > 0) {
            if (ToolUtil.isEmpty(fileInfoList)) {
                resultMap.put("code", "\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25");
                resultMap.put("msg", "\u6587\u4ef6\u4fdd\u5b58\u4e3a\u7a7a");
            }
            Map<String, Object> map = this.fileUploadNew(fileInfoList.get(0), user);
        }
        return resultMap;
    }

    private boolean insertFileInfoList(List<FileInfoKnowledge> fileInfoList) {
        if (ToolUtil.isEmpty(fileInfoList)) {
            return false;
        }
        ArrayList<KnowledgeFileInfo> saveFileList = new ArrayList<KnowledgeFileInfo>();
        for (int i = fileInfoList.size() - 1; i >= 0; --i) {
            KnowledgeFileInfo fileInfo = new KnowledgeFileInfo();
            FileInfoKnowledge file = fileInfoList.get(i);
            String ifExist = file.getIfExist();
            String fileName = file.getName();
            if ("1".equals(ifExist)) continue;
            fileInfo.setFileHash(FileUtil.hashKeyForDisk(fileName));
            fileInfo.setFileSize(FileUtil.getFileSize(file.getSize()));
            String suffix = fileName.substring(fileName.lastIndexOf(".")).toLowerCase();
            fileInfo.setFileSuffix(suffix);
            fileInfo.setId(file.getId());
            fileInfo.setFileName(fileName);
            fileInfo.setCreateTime(new Date());
            fileInfo.setDataSize(file.getSize());
            saveFileList.add(fileInfo);
        }
        if (saveFileList.size() > 0) {
            return this.saveBatch(saveFileList);
        }
        return true;
    }

    @Override
    public Object createInfoByFile(FileInfoKnowledge fileInfoParam) {
        return null;
    }

    @Override
    public Map<String, Object> createInfo(String md5, String importId, List<JSONObject> list, File[] fileArray, boolean addEs) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getFileById(String fileId, String savePath, String saveName) {
        File file;
        InputStream inputStream;
        GridFSDownloadStream downloadStream;
        block14: {
            block15: {
                File file2;
                block12: {
                    block13: {
                        downloadStream = null;
                        inputStream = null;
                        try {
                            if (fileId == null) {
                                File file3 = null;
                                return file3;
                            }
                            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)fileId));
                            GridFSFile gridFSFile = this.gridFsTemplate.findOne(query);
                            if (gridFSFile == null) {
                                file2 = null;
                                if (inputStream == null) break block12;
                                break block13;
                            }
                            downloadStream = this.gridFSBucket.openDownloadStream(gridFSFile.getObjectId());
                            GridFsResource gridFsResource = new GridFsResource(gridFSFile, (InputStream)downloadStream);
                            inputStream = gridFsResource.getInputStream();
                            byte[] fileData = IoUtil.readBytes((InputStream)inputStream);
                            if (saveName == null) {
                                saveName = gridFSFile.getFilename();
                            }
                            file = FileUtil.saveFile(savePath, saveName, fileData);
                            if (inputStream == null) break block14;
                            break block15;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            File file4 = null;
                            return file4;
                        }
                    }
                    IoUtil.close(inputStream);
                }
                if (downloadStream == null) return file2;
                IoUtil.close((Closeable)downloadStream);
                return file2;
            }
            IoUtil.close((Closeable)inputStream);
        }
        if (downloadStream == null) return file;
        IoUtil.close((Closeable)downloadStream);
        return file;
        finally {
            if (inputStream != null) {
                IoUtil.close(inputStream);
            }
            if (downloadStream != null) {
                IoUtil.close(downloadStream);
            }
        }
    }

    @Override
    public void downloadFileByFileId(String fileId, HttpServletRequest request, HttpServletResponse response) {
        if (ToolUtil.isEmpty(fileId)) {
            return;
        }
        File inputFile = null;
        Object outFile = null;
        try {
            KnowledgeFileInfo fileInfo = (KnowledgeFileInfo)this.getById((Serializable)((Object)fileId));
            if (ToolUtil.isEmpty(fileInfo)) {
                return;
            }
            String zipPath = KnowledgeConstants.FILEPATH_ZIP + File.separator + fileId + System.currentTimeMillis();
            inputFile = new File(zipPath);
            String mongoFileId = fileInfo.getMongoFileId();
            String fileName = fileInfo.getFileName();
            if (ToolUtil.isNotEmpty(mongoFileId)) {
                File file = this.getFileById(mongoFileId, zipPath, fileInfo.getFileName());
                this.downloadFile(file, fileName, request, response);
            }
            ResourceLogParam resourceLogParam = new ResourceLogParam();
            resourceLogParam.setResourceId(fileId);
            resourceLogParam.setResourceType(0);
            resourceLogParam.setOperateType(4);
            SecurityUser user = new SecurityUser();
            this.resourceLogService.add(resourceLogParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downloadFile(File file, String fileName, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.reset();
            response.setContentType("application/octet-stream");
            String userAgent = request.getHeader("User-Agent");
            fileName = userAgent.contains("MSIE") || userAgent.contains("Trident") ? URLEncoder.encode(fileName, "UTF-8") : URLEncoder.encode(fileName, "UTF-8");
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", fileName));
            response.setCharacterEncoding("UTF-8");
            try (ServletOutputStream outputStream = response.getOutputStream();
                 FileInputStream inputStream = new FileInputStream(file);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                outputStream.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<KnowledgeFileInfo> getFileInfoListByBasicMetaId(String basicMetaId) {
        if (ToolUtil.isEmpty(basicMetaId)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(KnowledgeFileInfo::getBasicMetaId, (Object)basicMetaId)).list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> topicFileSave(MultipartFile file) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "2");
        File f = null;
        File changeFile = null;
        try {
            f = FileUtil.multipartFileToFile(file);
            if (!f.exists()) {
                f.createNewFile();
            }
            String fileName = file.getOriginalFilename();
            String mongoFileId = this.uploadFileToMongo(file, fileName);
            KnowledgeFileInfo fileInfo = new KnowledgeFileInfo();
            String uuid = UUID.randomUUID().toString().replace("-", "");
            fileInfo.setId(uuid);
            fileInfo.setMongoFileId(mongoFileId);
            fileInfo.setFileName(fileName);
            fileInfo.setFileHash(FileUtil.hashKeyForDisk(fileName));
            fileInfo.setFileSize(FileUtil.getFileSize(f.length()));
            String suffix = fileName.substring(fileName.lastIndexOf(".")).toLowerCase();
            fileInfo.setFileSuffix(suffix);
            String contentType = FileUtil.getContentType(suffix);
            String changeFileId = null;
            if ("image".equals(contentType)) {
                String imgPath = KnowledgeConstants.FILEPATH_TOPIC + uuid + ".png";
                changeFile = new File(imgPath);
                boolean success = ThumbnailsUtil.createThumbnails(f.getPath(), imgPath, 300.0, 500.0);
                changeFileId = success ? this.uploadFileToMongo(FileUtil.fileToMultipartFile(changeFile), fileName) : mongoFileId;
            }
            fileInfo.setFileType("topic");
            fileInfo.setMd5(MD5Util.getMD5(file.getInputStream()));
            fileInfo.setFilePdfId(changeFileId);
            fileInfo.setFileContext(null);
            SecurityUser user = BaseSecurityUtil.getUser();
            fileInfo.setCreateUserId(user.getAccount());
            fileInfo.setCreateUserName(user.getName());
            fileInfo.setCreateTime(new Date());
            fileInfo.setDataSize(f.length());
            this.save(fileInfo);
            result.put("fileId", uuid);
            result.put("fname", fileName);
        }
        catch (Exception e) {
            result.put("code", "0");
            result.put("msg", "\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25");
        }
        finally {
            if (f != null && !f.exists()) {
                f.delete();
            }
            if (changeFile != null && !changeFile.exists()) {
                changeFile.delete();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void preview(String pdfId, HttpServletResponse response, String errorPicture) {
        InputStream inputStream;
        GridFSDownloadStream downloadStream;
        block14: {
            block15: {
                block12: {
                    block13: {
                        downloadStream = null;
                        inputStream = null;
                        try {
                            if (pdfId == null) {
                                this.loadErrorPicture(errorPicture, response);
                                return;
                            }
                            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)pdfId));
                            GridFSFile gridFSFile = this.gridFsTemplate.findOne(query);
                            if (gridFSFile == null) {
                                this.loadErrorPicture(errorPicture, response);
                                if (inputStream == null) break block12;
                                break block13;
                            }
                            downloadStream = this.gridFSBucket.openDownloadStream(gridFSFile.getObjectId());
                            GridFsResource gridFsResource = new GridFsResource(gridFSFile, (InputStream)downloadStream);
                            inputStream = gridFsResource.getInputStream();
                            byte[] bytes = IoUtil.readBytes((InputStream)inputStream);
                            if (bytes.length < 512000) {
                                response.setDateHeader("expires", System.currentTimeMillis() + 604800000L);
                            }
                            MagicMatch match = Magic.getMagicMatch((byte[])bytes);
                            String mimeType = match.getMimeType();
                            response.setContentType(mimeType);
                            response.addHeader("cache-control", "no-cache");
                            response.getOutputStream().write(bytes);
                            if (inputStream == null) break block14;
                            break block15;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.loadErrorPicture(errorPicture, response);
                            return;
                        }
                    }
                    IoUtil.close(inputStream);
                }
                if (downloadStream == null) return;
                IoUtil.close((Closeable)downloadStream);
                return;
            }
            IoUtil.close((Closeable)inputStream);
        }
        if (downloadStream == null) return;
        IoUtil.close((Closeable)downloadStream);
        return;
        finally {
            if (inputStream != null) {
                IoUtil.close(inputStream);
            }
            if (downloadStream != null) {
                IoUtil.close(downloadStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] downExcel(String pdfId) {
        byte[] byArray;
        InputStream inputStream;
        GridFSDownloadStream downloadStream;
        block13: {
            block14: {
                byte[] byArray2;
                block11: {
                    block12: {
                        downloadStream = null;
                        inputStream = null;
                        try {
                            byte[] bytes;
                            if (pdfId == null) {
                                byte[] byArray3 = null;
                                return byArray3;
                            }
                            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)pdfId));
                            GridFSFile gridFSFile = this.gridFsTemplate.findOne(query);
                            if (gridFSFile == null) {
                                byArray2 = null;
                                if (inputStream == null) break block11;
                                break block12;
                            }
                            downloadStream = this.gridFSBucket.openDownloadStream(gridFSFile.getObjectId());
                            GridFsResource gridFsResource = new GridFsResource(gridFSFile, (InputStream)downloadStream);
                            inputStream = gridFsResource.getInputStream();
                            byArray = bytes = IoUtil.readBytes((InputStream)inputStream);
                            if (inputStream == null) break block13;
                            break block14;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    IoUtil.close(inputStream);
                }
                if (downloadStream == null) return byArray2;
                IoUtil.close((Closeable)downloadStream);
                return byArray2;
            }
            IoUtil.close((Closeable)inputStream);
        }
        if (downloadStream == null) return byArray;
        IoUtil.close((Closeable)downloadStream);
        return byArray;
        finally {
            if (inputStream != null) {
                IoUtil.close(inputStream);
            }
            if (downloadStream != null) {
                IoUtil.close(downloadStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void videoViewer(String id, HttpServletRequest request, HttpServletResponse response) {
        if (ToolUtil.isEmpty(id)) {
            this.loadErrorPicture("video", response);
            return;
        }
        KnowledgeFileInfo fileInfo = (KnowledgeFileInfo)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(KnowledgeFileInfo::getBasicMetaId, (Object)id)).eq(KnowledgeFileInfo::getFileType, (Object)"main_file")).one();
        if (ToolUtil.isEmpty(fileInfo)) {
            this.loadErrorPicture("video", response);
            return;
        }
        RandomAccessFile randomFile = null;
        ServletOutputStream out = null;
        File file = null;
        try {
            file = this.getFileById(fileInfo.getMongoFileId(), KnowledgeConstants.FILEPATH_VIDEO, fileInfo.getFileName());
            randomFile = new RandomAccessFile(file, "r");
            long contentLength = file.length();
            String range = request.getHeader("Range");
            int start = 0;
            int end = 0;
            if (range != null && range.startsWith("bytes=")) {
                String[] values = range.split("=")[1].split("-");
                start = Integer.parseInt(values[0]);
                if (values.length > 1) {
                    end = Integer.parseInt(values[1]);
                }
            }
            int requestSize = 0;
            requestSize = end != 0 && end > start ? end - start + 1 : Integer.MAX_VALUE;
            byte[] buffer = new byte[4096];
            response.setContentType("video/mp4");
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", file.getName());
            response.setHeader("Last-Modified", new Date().toString());
            if (range == null) {
                response.setHeader("Content-length", contentLength + "");
            } else {
                response.setStatus(206);
                long requestStart = 0L;
                long requestEnd = 0L;
                String[] ranges = range.split("=");
                if (ranges.length > 1) {
                    String[] rangeDatas = ranges[1].split("-");
                    requestStart = Integer.parseInt(rangeDatas[0]);
                    if (rangeDatas.length > 1) {
                        requestEnd = Integer.parseInt(rangeDatas[1]);
                    }
                }
                long length = 0L;
                if (requestEnd > 0L) {
                    length = requestEnd - requestStart + 1L;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + requestEnd + "/" + contentLength);
                } else {
                    length = contentLength - requestStart;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + (contentLength - 1L) + "/" + contentLength);
                }
            }
            out = response.getOutputStream();
            randomFile.seek(start);
            for (int needSize = requestSize; needSize > 0; needSize -= buffer.length) {
                int len = randomFile.read(buffer);
                if (needSize < buffer.length) {
                    out.write(buffer, 0, needSize);
                    continue;
                }
                out.write(buffer, 0, len);
                if (len >= buffer.length) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loadErrorPicture("video", response);
        }
        finally {
            if (randomFile != null) {
                try {
                    randomFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    @Override
    public Map<String, Object> getFileType(String code) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        if (ToolUtil.isEmpty(code)) {
            return result;
        }
        ArrayList<FileType> list = new ArrayList<FileType>();
        FileType mainFile = new FileType("\u4e3b\u6587\u4ef6", "main_file");
        list.add(mainFile);
        if ("text".equals(code)) {
            FileType mdFile = new FileType("\u539f\u6587\u4ef6", "md_file");
            list.add(mdFile);
            FileType packFile = new FileType("\u9644\u5c5e\u6587\u4ef6", "pack_file");
            list.add(packFile);
            FileType richFile = new FileType("\u5bcc\u6587\u672c\u6587\u4ef6", "rich_file");
            list.add(richFile);
        } else if ("video".equals(code)) {
            FileType subtitleFile = new FileType("\u5b57\u5e55\u6587\u4ef6", "subtitle_file");
            list.add(subtitleFile);
            FileType planFile = new FileType("\u6587\u6848\u6587\u4ef6", "plan_file");
            list.add(planFile);
        } else if ("database".equals(code)) {
            FileType dbFile = new FileType("\u6570\u636e\u5e93\u6587\u4ef6", "db_file");
            list.add(dbFile);
            FileType dbpFile = new FileType("\u6570\u636e\u5e93\u7a0b\u5e8f\u6587\u4ef6", "db_program_file");
            list.add(dbpFile);
        }
        result.put("success", true);
        result.put("data", list);
        return result;
    }

    @Override
    public KnowledgeFileInfoResult getTopicByMongoFileId(String mongoFileId) {
        return ((KnowledgeFileInfoMapper)this.baseMapper).getTopicByMongoFileId(mongoFileId);
    }

    @Override
    public void loadErrorPicture(String type, HttpServletResponse response) {
        try {
            String pictureName = null;
            if ("picture".equals(type)) {
                pictureName = "error-picture.png";
            } else if ("video".equals(type)) {
                pictureName = "error-video.png";
            } else if ("topic".equals(type)) {
                pictureName = "error-topic.png";
            }
            String filePath = "assets" + File.separator + "common" + File.separator + "img" + File.separator + pictureName;
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filePath);
            if (null == inputStream) {
                return;
            }
            byte[] bytes = IoUtil.readBytes((InputStream)inputStream);
            if (bytes.length < 512000) {
                response.setDateHeader("expires", System.currentTimeMillis() + 604800000L);
            }
            MagicMatch match = Magic.getMagicMatch((byte[])bytes);
            String mimeType = match.getMimeType();
            response.setContentType(mimeType);
            response.addHeader("cache-control", "no-cache");
            response.getOutputStream().write(bytes);
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object importFile(String uuid) {
        return null;
    }

    @Override
    public Map<String, Object> createKnowledgeByFile(File importFile, String md5, String uuid) {
        return null;
    }

    @Override
    public void insertIntoImportFileInfo(Map<String, Object> info, String name, String md5) {
    }
}

