/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jodconverter.OfficeDocumentConverter;
import org.jodconverter.office.DefaultOfficeManagerBuilder;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LibreOfficePDFConvertCur {
    private static final Logger logger = LoggerFactory.getLogger(LibreOfficePDFConvertCur.class);
    @Value(value="${office.url}")
    private String jodcUrl;
    private static String officeUrl;
    private static String officeHomeDir;

    @PostConstruct
    public void init() {
        officeUrl = this.jodcUrl;
    }

    public static synchronized String doDocToFdpLibre(File sourceFile, File tarPdfFile) throws OfficeException {
        File outputFile;
        block2: {
            File inputFile = sourceFile;
            String libreOfficePath = LibreOfficePDFConvertCur.getOfficeHome();
            DefaultOfficeManagerBuilder builder = new DefaultOfficeManagerBuilder();
            builder.setOfficeHome(new File(libreOfficePath));
            builder.setTaskExecutionTimeout(3000000L);
            builder.setTaskQueueTimeout(864000000L);
            OfficeManager officeManager = builder.build();
            outputFile = null;
            try {
                LibreOfficePDFConvertCur.startService(officeManager);
                OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
                outputFile = tarPdfFile;
                converter.convert(inputFile, outputFile);
                LibreOfficePDFConvertCur.stopService(officeManager);
            }
            catch (Exception e) {
                if (!officeManager.isRunning()) break block2;
                LibreOfficePDFConvertCur.stopService(officeManager);
            }
        }
        String pdfPath = outputFile.getPath();
        return pdfPath;
    }

    /*
     * Exception decompiling
     */
    public static synchronized File doDocToFdpLibre(File sourceFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized File convertFile(File inputFile) throws IOException {
        File outputFile;
        block49: {
            String outputFormat = "pdf";
            String apiUrl = officeUrl + "/lool/convert-to/" + outputFormat;
            outputFile = File.createTempFile("converted_", ".pdf");
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost post = new HttpPost(apiUrl);
                HttpEntity multipartEntity = MultipartEntityBuilder.create().addBinaryBody("data", inputFile, ContentType.DEFAULT_BINARY, inputFile.getName()).build();
                post.setEntity(multipartEntity);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                    HttpEntity responseEntity = response.getEntity();
                    if (responseEntity == null) break block49;
                    try (InputStream in = responseEntity.getContent();
                         FileOutputStream fos = new FileOutputStream(outputFile);){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = in.read(buffer)) != -1) {
                            fos.write(buffer, 0, length);
                        }
                    }
                    EntityUtils.consume((HttpEntity)responseEntity);
                }
            }
        }
        return outputFile;
    }

    private static String getOfficeHome() {
        if (null != officeHomeDir) {
            return officeHomeDir;
        }
        String osName = System.getProperty("os.name");
        if (Pattern.matches("Windows.*", osName)) {
            officeHomeDir = "D:\\Program Files\\LibreOffice";
            return officeHomeDir;
        }
        if (Pattern.matches("Linux.*", osName)) {
            officeHomeDir = "/opt/libreoffice7.0";
            return officeHomeDir;
        }
        if (Pattern.matches("Mac.*", osName)) {
            officeHomeDir = "/Application/openOfficeSoft";
            return officeHomeDir;
        }
        return null;
    }

    private static void stopService(OfficeManager officeManager) throws OfficeException {
        if (null != officeManager) {
            officeManager.stop();
        }
        logger.info("\u5173\u95edoffice\u8f6c\u6362\u6210\u529f!");
    }

    private static void startService(OfficeManager officeManager) {
        try {
            officeManager.start();
            logger.info("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u6210\u529f");
        }
        catch (Exception ce) {
            logger.error("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)ce);
        }
    }

    @Value(value="${office.home}")
    public void setOfficeHome(String officeHome) {
        officeHomeDir = officeHome;
    }

    static {
        officeHomeDir = null;
    }
}

