/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.base;

import com.jxdinfo.crm.knowledge.knowledge.base.wrapper.BaseControllerWrapper;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.HttpContext;
import com.jxdinfo.crm.knowledge.knowledge.response.SuccessResponseData;
import com.jxdinfo.crm.knowledge.knowledge.support.exception.ServiceException;
import com.jxdinfo.crm.knowledge.knowledge.support.exception.enums.CoreExceptionEnum;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class BaseController {
    protected final String REDIRECT = "redirect:";
    protected final String FORWARD = "forward:";
    protected static SuccessResponseData SUCCESS_TIP = new SuccessResponseData();

    protected HttpServletRequest getHttpServletRequest() {
        return HttpContext.getRequest();
    }

    protected HttpServletResponse getHttpServletResponse() {
        return HttpContext.getResponse();
    }

    protected HttpSession getSession() {
        return Objects.requireNonNull(HttpContext.getRequest()).getSession();
    }

    protected HttpSession getSession(Boolean flag) {
        return Objects.requireNonNull(HttpContext.getRequest()).getSession(flag.booleanValue());
    }

    protected String getPara(String name) {
        return Objects.requireNonNull(HttpContext.getRequest()).getParameter(name);
    }

    protected void setAttr(String name, Object value) {
        Objects.requireNonNull(HttpContext.getRequest()).setAttribute(name, value);
    }

    protected Object warpObject(BaseControllerWrapper warpper) {
        return warpper.wrap();
    }

    protected ResponseEntity<InputStreamResource> renderFile(String fileName, String filePath) {
        try {
            FileInputStream inputStream = new FileInputStream(filePath);
            return this.renderFile(fileName, inputStream);
        }
        catch (FileNotFoundException e) {
            throw new ServiceException(CoreExceptionEnum.FILE_READING_ERROR);
        }
    }

    protected ResponseEntity<InputStreamResource> renderFile(String fileName, byte[] fileBytes) {
        return this.renderFile(fileName, new ByteArrayInputStream(fileBytes));
    }

    protected ResponseEntity<InputStreamResource> renderFile(String fileName, InputStream inputStream) {
        InputStreamResource resource = new InputStreamResource(inputStream);
        String dfileName = null;
        try {
            dfileName = new String(fileName.getBytes("gb2312"), "iso8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentDispositionFormData("attachment", dfileName);
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

