/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import com.jxdinfo.crm.common.api.config.EaiProperties;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkRequestParams;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkTokenParams;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiClientAuthResponse;
import com.jxdinfo.hussar.eai.client.sdk.utils.EaiApiSdkUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpUnifyStatisticUtil {
    public static synchronized String getUnifyToken(boolean refreshFlag) throws Exception {
        String cacheToken;
        UnifyProperties unifyProperties = (UnifyProperties)SpringUtils.getBean(UnifyProperties.class);
        String server = unifyProperties.getServer();
        String clientId = unifyProperties.getClientId();
        String clientSecret = unifyProperties.getClientSecret();
        if (!refreshFlag && ToolUtil.isNotEmpty((Object)(cacheToken = (String)DefaultCacheUtil.get((Object)clientId)))) {
            return cacheToken;
        }
        EaiApiSdkTokenParams eaiApiSdkTokenParams = new EaiApiSdkTokenParams();
        EaiProperties eaiProperties = (EaiProperties)SpringUtils.getBean(EaiProperties.class);
        eaiApiSdkTokenParams.setServerUrl(server + eaiProperties.getClientTokenApi());
        eaiApiSdkTokenParams.setClientId(clientId);
        eaiApiSdkTokenParams.setClientSecret(clientSecret);
        EaiClientAuthResponse clientToken = EaiApiSdkUtil.getClientToken((EaiApiSdkTokenParams)eaiApiSdkTokenParams);
        Calendar calendar = Calendar.getInstance();
        String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(clientToken.getExpiresIn().toString()));
        DefaultCacheUtil.put((Object)clientId, (Object)clientToken.getClientToken(), (long)Long.parseLong(timeInMillis));
        return clientToken.getClientToken();
    }

    public static ApiResponse request(String uri, Map<String, Object> body, String clientToken, Boolean refreshFlag) {
        UnifyProperties unifyProperties = (UnifyProperties)SpringUtils.getBean(UnifyProperties.class);
        EaiApiSdkRequestParams eaiApiSdkRequestParams = new EaiApiSdkRequestParams();
        eaiApiSdkRequestParams.setServerUrl(unifyProperties.getServer());
        eaiApiSdkRequestParams.setClientId(unifyProperties.getClientId());
        HashMap<String, String> headerMap = new HashMap<String, String>(1);
        headerMap.put("Authorization", clientToken);
        headerMap.put("client-id", unifyProperties.getClientId());
        eaiApiSdkRequestParams.setHeader(headerMap);
        eaiApiSdkRequestParams.setUri(uri);
        eaiApiSdkRequestParams.setBody(body);
        ApiResponse request = null;
        try {
            request = EaiApiSdkUtil.request((EaiApiSdkRequestParams)eaiApiSdkRequestParams, (String)clientToken);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request.getCode() == 4100 && refreshFlag.booleanValue()) {
            String clientToken2 = null;
            try {
                clientToken2 = HttpUnifyStatisticUtil.getUnifyToken(true);
                request = HttpUnifyStatisticUtil.request(uri, body, clientToken2, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return request;
    }
}

