/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.message.config.WxMpProperty;
import com.jxdinfo.crm.core.message.service.CrmMpSendMsgService;
import com.jxdinfo.crm.core.partner.dto.SendOpportunityStageDTO;
import com.jxdinfo.crm.core.partner.dto.SendWinAnOrderDTO;
import com.jxdinfo.crm.core.partner.model.CrmProductPush;
import com.jxdinfo.crm.core.partner.service.CrmProductPushService;
import com.jxdinfo.crm.core.partner.service.WeChatMessageService;
import com.jxdinfo.hussar.msg.mp.dto.WxMpSendMsgReqDtoDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeChatMessageServiceImpl
implements WeChatMessageService {
    @Autowired
    private CustomerService customerService;
    @Autowired
    private CrmMpSendMsgService crmMpSendMsgService;
    @Autowired
    private CrmProductPushService crmProductPushService;
    @Resource
    private WxMpProperty wxMpProperty;

    @Override
    public boolean sendOpportunityStage(SendOpportunityStageDTO sendOpportunityStageDTO) {
        if (!this.wxMpProperty.isEnable()) {
            return false;
        }
        String partner = sendOpportunityStageDTO.getPartner();
        CustomerEntity customer = (CustomerEntity)this.customerService.getById((Serializable)((Object)partner));
        if (HussarUtils.isEmpty((Object)customer.getOpenId())) {
            return false;
        }
        ArrayList<WxMpTemplateData> dataList = new ArrayList<WxMpTemplateData>();
        dataList.add(new WxMpTemplateData("opportunityName", sendOpportunityStageDTO.getOpportunityName()));
        dataList.add(new WxMpTemplateData("opportunityStage", sendOpportunityStageDTO.getOpportunityStage()));
        dataList.add(new WxMpTemplateData("opportunityAmount", sendOpportunityStageDTO.getOpportunityAmount()));
        dataList.add(new WxMpTemplateData("successDate", sendOpportunityStageDTO.getSuccessDate()));
        WxMpSendMsgReqDtoDto wxMpSendMsgReqDtoDto = new WxMpSendMsgReqDtoDto();
        wxMpSendMsgReqDtoDto.setToUser(customer.getOpenId());
        wxMpSendMsgReqDtoDto.setTemplateId(this.wxMpProperty.getWxmpTemplate()[0]);
        wxMpSendMsgReqDtoDto.setAppId(this.wxMpProperty.getAppid());
        wxMpSendMsgReqDtoDto.setSecret(this.wxMpProperty.getSecret());
        wxMpSendMsgReqDtoDto.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=wxe7e2a867bbe4dcd2&redirect_uri=http%3A%2F%2Fcrmser.jxdinfo.com%2F%23%2Fsjlb&response_type=code&scope=snsapi_base&state=123#wechat_redirect");
        wxMpSendMsgReqDtoDto.setData(dataList);
        try {
            this.crmMpSendMsgService.sendTemplateMsg(wxMpSendMsgReqDtoDto);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean sendWinAnOrder(SendWinAnOrderDTO sendWinAnOrderDTO) {
        if (!this.wxMpProperty.isEnable()) {
            return false;
        }
        CustomerEntity customerToSend = new CustomerEntity();
        customerToSend.setOpenId("");
        if (HussarUtils.isNotEmpty((Object)sendWinAnOrderDTO.getPartner())) {
            customerToSend = (CustomerEntity)this.customerService.getById((Serializable)((Object)sendWinAnOrderDTO.getPartner()));
            ArrayList<WxMpTemplateData> dataList = new ArrayList<WxMpTemplateData>();
            if (HussarUtils.isNotEmpty(sendWinAnOrderDTO.getProductList())) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < sendWinAnOrderDTO.getProductList().size(); ++i) {
                    stringBuffer.append(sendWinAnOrderDTO.getProductList().get(i).getShortName());
                    if (i >= sendWinAnOrderDTO.getProductList().size() - 1) continue;
                    stringBuffer.append("\uff0c");
                }
                dataList.add(new WxMpTemplateData("productName", stringBuffer.toString()));
            } else {
                dataList.add(new WxMpTemplateData("productName", "-"));
            }
            dataList.add(new WxMpTemplateData("opportunityName", sendWinAnOrderDTO.getOpportunityName()));
            dataList.add(new WxMpTemplateData("customerName", sendWinAnOrderDTO.getCustomerName()));
            if (HussarUtils.isNotEmpty((Object)sendWinAnOrderDTO.getPartner())) {
                CustomerEntity customer1 = new CustomerEntity();
                customer1.setOpenId("");
                customer1 = (CustomerEntity)this.customerService.getById((Serializable)((Object)sendWinAnOrderDTO.getPartner()));
                if (HussarUtils.isNotEmpty((Object)customer1.getOpenId())) {
                    this.sendToPartner(sendWinAnOrderDTO, dataList, 1);
                }
            }
        }
        if (HussarUtils.isNotEmpty(sendWinAnOrderDTO.getProductList())) {
            List<String> openidList = this.customerService.getAllOpenid(customerToSend.getOpenId());
            openidList = openidList.stream().distinct().collect(Collectors.toList());
            for (int i = 0; i < sendWinAnOrderDTO.getProductList().size(); ++i) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(CrmProductPush::getProductId, (Object)sendWinAnOrderDTO.getProductList().get(i).getProductId());
                long num = this.crmProductPushService.count((Wrapper)queryWrapper);
                if (num == 0L) continue;
                WxMpSendMsgReqDtoDto wxMpSendMsgReqDtoDto = new WxMpSendMsgReqDtoDto();
                wxMpSendMsgReqDtoDto.setTemplateId(this.wxMpProperty.getWxmpTemplate()[1]);
                wxMpSendMsgReqDtoDto.setAppId(this.wxMpProperty.getAppid());
                wxMpSendMsgReqDtoDto.setSecret(this.wxMpProperty.getSecret());
                wxMpSendMsgReqDtoDto.setUrl("");
                ArrayList<WxMpTemplateData> dataList2 = new ArrayList<WxMpTemplateData>();
                dataList2.add(new WxMpTemplateData("opportunityName", sendWinAnOrderDTO.getProductList().get(i).getProductName()));
                dataList2.add(new WxMpTemplateData("customerName", sendWinAnOrderDTO.getCustomerName()));
                dataList2.add(new WxMpTemplateData("productName", sendWinAnOrderDTO.getProductList().get(i).getShortName()));
                wxMpSendMsgReqDtoDto.setData(dataList2);
                for (String s : openidList) {
                    wxMpSendMsgReqDtoDto.setToUser(s);
                    try {
                        this.crmMpSendMsgService.sendTemplateMsg(wxMpSendMsgReqDtoDto);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return true;
    }

    private boolean sendToPartner(SendWinAnOrderDTO sendWinAnOrderDTO, List<WxMpTemplateData> dataList, int Wxtemplate) {
        CustomerEntity customer = (CustomerEntity)this.customerService.getById((Serializable)((Object)sendWinAnOrderDTO.getPartner()));
        if (customer == null || HussarUtils.isEmpty((Object)customer.getOpenId())) {
            return false;
        }
        WxMpSendMsgReqDtoDto wxMpSendMsgReqDtoDto = new WxMpSendMsgReqDtoDto();
        wxMpSendMsgReqDtoDto.setUrl("");
        wxMpSendMsgReqDtoDto.setTemplateId(this.wxMpProperty.getWxmpTemplate()[Wxtemplate]);
        wxMpSendMsgReqDtoDto.setAppId(this.wxMpProperty.getAppid());
        wxMpSendMsgReqDtoDto.setSecret(this.wxMpProperty.getSecret());
        wxMpSendMsgReqDtoDto.setData(dataList);
        wxMpSendMsgReqDtoDto.setToUser(customer.getOpenId());
        try {
            this.crmMpSendMsgService.sendTemplateMsg(wxMpSendMsgReqDtoDto);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

