/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordViewAPIVo;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.common.api.util.entity.DateStartEndVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityDataRightModuleService;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryDto;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryNoPageDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityDataRightModuleService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.dto.DeptChangeBatchDto;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.competitoranalysis.model.CompetitorAnalysis;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.contactcharacter.model.ContactCharacterEntity;
import com.jxdinfo.crm.core.contactcharacter.service.ContactCharacterService;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmopportunityproduct1.model.CrmOpportunityProduct1;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmopportunityproduct1.service.CrmOpportunityProduct1Service;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.model.CrmOpportunity2;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.dao.OpportunityPoolOppoMapper;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.model.CustomerIncludePool;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerIncludePoolService;
import com.jxdinfo.crm.core.customer.vo.CheckRepeat;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.focus.dao.FocusMapper;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.opportunity.constant.OpportunityConstant;
import com.jxdinfo.crm.core.opportunity.constant.OpportunityEditConstant;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityStageMapper;
import com.jxdinfo.crm.core.opportunity.dao.RepeatOpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dto.ChangeOpportunityStageDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityAssociativeQueryDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityEntityDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunitySelectPermissionDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.StageContent;
import com.jxdinfo.crm.core.opportunity.model.StageRecord;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityAssociativeQueryService;
import com.jxdinfo.crm.core.opportunity.service.IStageRecordService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunity.util.OpportunityUtil;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityAttributeRepeatVo;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityEntityVo;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityProcessStateVo;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityRecordNecessaryInfo;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityRepeatVO;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityVo;
import com.jxdinfo.crm.core.opportunity.vo.StageFunnelVo;
import com.jxdinfo.crm.core.opportunity.vo.SuspectedOpportunityVo;
import com.jxdinfo.crm.core.opportunityproduct.dao.OpportunityProductMapper;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.opportunitystage.dao.StageProcessMapper;
import com.jxdinfo.crm.core.opportunitystage.model.StageCrossingEntity;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.model.StageTaskOpptyRelationEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageCrossingService;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.opportunitystage.service.IStageTaskOpptyRelationService;
import com.jxdinfo.crm.core.opportunitystage.vo.StageKeyTaskVo;
import com.jxdinfo.crm.core.opportunitystage.vo.StageProcessVo;
import com.jxdinfo.crm.core.opportunitystage.vo.StageTaskDetailVo;
import com.jxdinfo.crm.core.opportunitystage.vo.StageVo;
import com.jxdinfo.crm.core.partner.dto.SendOpportunityStageDTO;
import com.jxdinfo.crm.core.partner.dto.SendWinAnOrderDTO;
import com.jxdinfo.crm.core.partner.service.WeChatMessageService;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CrmLabelUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.ReadExcel;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.crm.transaction.api.service.IQuotationApiService;
import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.service.InstanceEngineApiService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OpportunityServiceImpl
extends ServiceImpl<OpportunityMapper, OpportunityEntity>
implements OpportunityService {
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private OpportunityProductMapper opportunityProductMapper;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private ContactCharacterService contactCharacterService;
    @Resource
    private CrmOpportunityProduct1Service crmOpportunityProduct1Service;
    @Resource
    private OpportunityProductService opportunityProductService2;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private CustomerService customerService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CommonService commonService;
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private FocusService focusService;
    @Resource
    private FocusMapper focusMapper;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private ProductService productService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private ContactService contactService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private WeChatMessageService weChatMessageService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private IOpportunityAssociativeQueryService opportunityAssociativeQueryService;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private ILabelService labelService;
    @Resource
    private InstanceEngineApiService instanceEngineApiService;
    @Resource
    private IStageRecordService stageRecordService;
    @Resource
    private IQuotationApiService quotationApiService;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private IStageTaskOpptyRelationService stageTaskOpptyRelationService;
    @Resource
    private OpportunityStageMapper opportunityStageMapper;
    @Resource
    private IStageCrossingService stageCrossingService;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private StageProcessMapper stageProcessMapper;
    @Resource
    private OpportunityPoolOppoMapper opportunityPoolOppoMapper;
    @Resource
    private RepeatOpportunityMapper repeatOpportunityMapper;
    @Resource
    private ICrmBaseConfigBoService iCrmBaseConfigBoService;
    @Resource
    private ICustomerIncludePoolService customerIncludePoolService;
    @Resource
    private IOpportunityDataRightModuleService opportunityDataRightModuleService;
    @Resource
    private IMarketingActivityDataRightModuleService marketingActivityDataRightModuleService;
    @Resource
    private IHussarBaseResourceAdapter hussarBaseResourceAdapter;
    @Resource
    private IUserBoService userBoService;
    @Resource
    private ITeamMemberApiService teamMemberApiService;
    @Resource
    private MarketingActivityService marketingActivityService;
    @Resource
    private IDataRightBoService dataRightBoService;

    @Override
    public Page<OpportunityEntity> selectCrmOpportunityList(OpportunityDto dto) {
        List<Long> pids;
        if (CollectionUtil.isNotEmpty(dto.getCategoryIds()) && CollectionUtil.isNotEmpty(pids = this.productService.selectAllProductIdByCategory(dto.getCategoryIds()))) {
            if (dto.getProducts() != null) {
                dto.getProducts().addAll(pids.stream().map(String::valueOf).collect(Collectors.toList()));
            } else {
                dto.setProducts(pids.stream().map(String::valueOf).collect(Collectors.toList()));
            }
        }
        OpportunitySelectPermissionDto opportunitySelectPermissionDto = this.opportunityOperate(dto);
        PermissionDto opportunityPermissionDto = opportunitySelectPermissionDto.getOpportunityPermissionDto();
        PermissionDto campaignPermissionDto = opportunitySelectPermissionDto.getCampaignPermissionDto();
        List<OpportunityDto> queryDtoList = this.getOpportUnityDtoList(dto);
        Page page = dto.getPage();
        if ("\u79bb\u804c".equals(dto.getOpportunityScreening())) {
            dto.setOpportunityScreening("");
            SysStru dimissionStru = this.commonMapper.getSysStruByOrganAlias("\u79bb\u804c");
            dto.setDimissionId(dimissionStru.getId());
        }
        List dicSingles = this.sysDicRefService.getDictByType("salesProcess_StageList");
        List<String> stageNames = dicSingles.stream().sorted(Comparator.comparingInt(DicSingle::getSort)).map(DicSingle::getLabel).collect(Collectors.toList());
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageStart(true);
        stageTypeDto.setStageEnd(true);
        stageTypeDto.setStageWin(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List<OpportunityEntity> list = this.opportunityMapper.selectCrmOpportunityListPermission(page, dto.getCurrentUserId(), queryDtoList, opportunityPermissionDto, campaignPermissionDto, dto.getTimeOrder(), stageNames, stageSelectDto);
        if (list.size() > 0) {
            String oppAmount = "0.00";
            if (page.getCurrent() == 1L) {
                oppAmount = this.opportunityMapper.selectCrmOpportunityListAmount(dto.getCurrentUserId(), queryDtoList, opportunityPermissionDto, campaignPermissionDto, stageSelectDto);
            }
            list.get(0).setOpportunityTotalAmount(oppAmount);
            page.setRecords(list);
        }
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.OPPORTUNITY.getModuleId());
            list.forEach(opportunity -> opportunity.setLabelName(CrmLabelUtil.getLabelName(labelList, opportunity.getLabelId())));
            List opportunityIdList = list.stream().map(OpportunityEntity::getOpportunityId).collect(Collectors.toList());
            List recordList = this.trackRecordAPIService.getLatestTrackRecordDetailsByTypeIdBatch(opportunityIdList);
            if (ToolUtil.isNotEmpty((Object)recordList)) {
                for (OpportunityEntity opportunityEntity : list) {
                    TrackRecordViewAPIVo recordViewAPIVoList = recordList.stream().filter(object -> object.getRelationTypeId().equals(opportunityEntity.getOpportunityId())).findFirst().orElse(null);
                    if (!ToolUtil.isNotEmpty((Object)recordViewAPIVoList)) continue;
                    opportunityEntity.setRecordType(recordViewAPIVoList.getRecordType());
                    if ("0".equals(dto.getOpportunityView())) continue;
                    opportunityEntity.setRecordContent(recordViewAPIVoList.getRecordContent());
                }
            }
        }
        return page;
    }

    @Override
    public List<AssociativeQueryVo> associativeQueryNew(OpportunityAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getOpportunityScreening();
        }
        IOpportunityAssociativeQueryService adapterService = this.opportunityAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("input_5Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    private List<OpportunityDto> getOpportUnityDtoList(OpportunityDto opportunityDto) {
        ArrayList<OpportunityDto> queryDtoList = new ArrayList<OpportunityDto>();
        String view = opportunityDto.getOpportunityView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long opportunityView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)opportunityView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"opportunity");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)((Object)crmSceneList.get(0))).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        OpportunityDto queryDto = (OpportunityDto)JSONObject.parseObject((String)queryValue, OpportunityDto.class);
                        queryDto.setOpportunityView(String.valueOf(opportunityView));
                        List<Object> opportunityStages = new ArrayList();
                        if (ToolUtil.isNotEmpty(queryDto.getStageProcessIds())) {
                            if (ToolUtil.isNotEmpty(queryDto.getCustomerStageIds())) {
                                opportunityStages = this.opportunityStageMapper.selectNameMergeListByStageId(queryDto.getStageProcessIds(), queryDto.getCustomerStageIds());
                            }
                        } else if (ToolUtil.isNotEmpty(queryDto.getCustomerStageIds())) {
                            opportunityStages = this.opportunityStageMapper.selectNameMergeListByStageId(null, queryDto.getCustomerStageIds());
                        }
                        if (ToolUtil.isNotEmpty(opportunityStages)) {
                            List<String> opportunityStagesStr = opportunityStages.stream().map(String::valueOf).collect(Collectors.toList());
                            queryDto.setCustomerStageIds(opportunityStagesStr);
                        }
                        queryDtoList.add(this.opportunityQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.opportunityQueryCondition(opportunityDto));
        return queryDtoList;
    }

    @Override
    public Page<OpportunityEntity> selectOpportunityAnalysisList(OpportunityDto dto) {
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo;
        if (ToolUtil.isEmpty((Object)dto.getCustomerStageId())) {
            return new Page();
        }
        Page page = dto.getPage();
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto opportunityPermissionDto = this.opportunityDataRightModuleService.getUserRolePermission(user);
        PermissionDto campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getEndTime())) != null) {
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        if (CollectionUtil.isNotEmpty(dto.getDeptIds())) {
            List deptIds = dto.getDeptIds().stream().map(Long::valueOf).collect(Collectors.toList());
            deptIds = this.organUserBoService.getOrganByParentIdContainsParent(deptIds);
            List<String> deptIdsToString = deptIds.stream().map(String::valueOf).collect(Collectors.toList());
            dto.setDeptIds(deptIdsToString);
        }
        dto.setDelFlag("0");
        List<OpportunityEntity> list = this.opportunityMapper.selectOpportunityAnalysisList(page, dto, opportunityPermissionDto, campaignPermissionDto);
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.OPPORTUNITY.getModuleId());
            for (OpportunityEntity opportunityEntity : list) {
                opportunityEntity.setProductAmount(this.opportunityProductMapper.getOpportunityAmount(opportunityEntity.getOpportunityId(), dto.getProducts()));
                opportunityEntity.setLabelName(CrmLabelUtil.getLabelName(labelList, opportunityEntity.getLabelId()));
            }
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public Object selectOpportunityAnalysisSum(OpportunityDto dto) {
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(OpportunityStage::getDelFlag, new Object[]{"0"});
        if (StringUtil.isNotBlank((CharSequence)dto.getCustomerStageId())) {
            List customerStageIds = Arrays.stream(dto.getCustomerStageId().split(",")).mapToLong(Long::parseLong).boxed().collect(Collectors.toList());
            queryWrapper.notIn(OpportunityStage::getCustomerStageId, customerStageIds);
        }
        if (ToolUtil.isNotEmpty((Object)dto.getStageProcessId())) {
            queryWrapper.eq(OpportunityStage::getStageProcessId, (Object)dto.getStageProcessId());
        }
        List hideOpportunityStageList = this.opportunityStageService.list((Wrapper)queryWrapper);
        List dicSingles = this.sysDicRefService.getDictByType("salesProcess_StageList");
        ArrayList<StageFunnelVo> hideStageFunnelVoList = new ArrayList<StageFunnelVo>();
        Map<String, List<OpportunityStage>> hideMap = hideOpportunityStageList.stream().collect(Collectors.groupingBy(OpportunityStage::getCustomerStageName));
        for (Map.Entry<String, List<OpportunityStage>> entry : hideMap.entrySet()) {
            StageFunnelVo stageFunnelVo = new StageFunnelVo();
            stageFunnelVo.setName(entry.getKey());
            stageFunnelVo.setAmount(0L);
            stageFunnelVo.setMoney(BigDecimal.ZERO);
            stageFunnelVo.setTenThousand(BigDecimal.ZERO);
            stageFunnelVo.setStageId(entry.getValue().stream().map(OpportunityStage::getCustomerStageId).map(String::valueOf).collect(Collectors.joining(",")));
            if (ToolUtil.isNotEmpty((Object)dto.getStageProcessId())) {
                stageFunnelVo.setOrderNumber(Integer.valueOf(entry.getValue().get(0).getOrderNumber()));
            } else {
                Optional<Integer> sortValue = dicSingles.stream().filter(dicSingle -> ((String)entry.getKey()).equals(dicSingle.getLabel())).map(DicSingle::getSort).findFirst();
                if (sortValue.isPresent()) {
                    stageFunnelVo.setOrderNumber(sortValue.get());
                }
            }
            hideStageFunnelVoList.add(stageFunnelVo);
        }
        JSONObject jsonObject = new JSONObject();
        if (StringUtil.isBlank((CharSequence)dto.getCustomerStageId())) {
            hideStageFunnelVoList.sort(Comparator.comparing(StageFunnelVo::getOrderNumber));
            jsonObject.put("notSignedMoney", (Object)"0");
            jsonObject.put("list", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(hideStageFunnelVoList)));
            jsonObject.put("totalProductAmount", (Object)"0");
            return jsonObject;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto opportunityPermissionDto = this.opportunityDataRightModuleService.getUserRolePermission(user);
        PermissionDto campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getEndTime())) != null) {
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        if (CollectionUtil.isNotEmpty(dto.getDeptIds())) {
            List deptIds = dto.getDeptIds().stream().map(Long::valueOf).collect(Collectors.toList());
            deptIds = this.organUserBoService.getOrganByParentIdContainsParent(deptIds);
            List<String> deptIdsToString = deptIds.stream().map(String::valueOf).collect(Collectors.toList());
            dto.setDeptIds(deptIdsToString);
        }
        dto.setDelFlag("0");
        double totalProductAmount = 0.0;
        if (HussarUtils.isNotEmpty((Object)dto.getCustomerStageId())) {
            totalProductAmount = this.opportunityMapper.selectTotalOpportunityProductAmount(dto, opportunityPermissionDto, campaignPermissionDto);
        }
        List<StageFunnelVo> stageFunnelVoList = this.opportunityMapper.selectOpportunityAnalysisSum(opportunityPermissionDto, campaignPermissionDto, dto);
        if (HussarUtils.isEmpty((Object)dto.getStageProcessId())) {
            ArrayList<StageFunnelVo> list = new ArrayList<StageFunnelVo>();
            Map<String, List<StageFunnelVo>> mapList = stageFunnelVoList.stream().collect(Collectors.groupingBy(StageFunnelVo::getName));
            for (Map.Entry<String, List<StageFunnelVo>> entry : mapList.entrySet()) {
                StageFunnelVo stageFunnelVo = new StageFunnelVo();
                stageFunnelVo.setName(entry.getKey());
                stageFunnelVo.setStageId(entry.getValue().stream().map(StageFunnelVo::getStageId).collect(Collectors.joining(",")));
                stageFunnelVo.setAmount(entry.getValue().stream().mapToLong(StageFunnelVo::getAmount).sum());
                stageFunnelVo.setTenThousand(BigDecimal.valueOf(entry.getValue().stream().mapToDouble(s -> s.getTenThousand().doubleValue()).sum()));
                stageFunnelVo.setMoney(BigDecimal.valueOf(entry.getValue().stream().mapToDouble(s -> s.getMoney().doubleValue()).sum()));
                Optional<Integer> sortValue = dicSingles.stream().filter(dicSingle -> ((String)entry.getKey()).equals(dicSingle.getLabel())).map(DicSingle::getSort).findFirst();
                if (sortValue.isPresent()) {
                    stageFunnelVo.setOrderNumber((Integer)sortValue.get());
                }
                list.add(stageFunnelVo);
            }
            stageFunnelVoList = list;
        }
        stageFunnelVoList.addAll(hideStageFunnelVoList);
        stageFunnelVoList.sort(Comparator.comparing(StageFunnelVo::getOrderNumber));
        if (stageFunnelVoList.isEmpty()) {
            return jsonObject;
        }
        double notSignedMoney = 0.0;
        long allAmount = 0L;
        String stageName = dicSingles.stream().map(DicSingle::getLabel).collect(Collectors.joining());
        for (StageFunnelVo vo : stageFunnelVoList) {
            if (vo == null) continue;
            if (stageName.contains(vo.getName())) {
                try {
                    BigDecimal money = vo.getMoney();
                    notSignedMoney += money.doubleValue();
                }
                catch (Exception e) {
                    notSignedMoney += 0.0;
                }
            }
            try {
                long Amount = vo.getAmount();
                allAmount += Amount;
            }
            catch (Exception exception) {}
        }
        DecimalFormat df = new DecimalFormat("0");
        String notSignedMoneys = df.format(notSignedMoney);
        jsonObject.put("notSignedMoney", (Object)notSignedMoneys);
        jsonObject.put("list", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(stageFunnelVoList)));
        jsonObject.put("totalProductAmount", (Object)df.format(totalProductAmount));
        return jsonObject;
    }

    public List<String> selectOpportunityTissueTreeUserId(String orgId, List<String> ids) {
        List<Map<String, Object>> organIds = this.opportunityMapper.opportunityTissueTreeFunnel(orgId);
        if (ToolUtil.isNotEmpty(organIds) && organIds.size() > 0) {
            for (Map<String, Object> organId : organIds) {
                String id = organId.get("id").toString();
                ids.add(id);
            }
        }
        return ids;
    }

    @Override
    public Object opportunityTissueTree(String sParentId) {
        return this.selectOpportunityTissueTree(sParentId);
    }

    public List<Map<String, Object>> selectOpportunityTissueTree(String orgId) {
        List<Map<String, Object>> dtoList = this.opportunityMapper.opportunityTissueTree(orgId);
        if (ToolUtil.isNotEmpty(dtoList) && dtoList.size() > 0) {
            for (int i = 0; i < dtoList.size(); ++i) {
                String id = dtoList.get(i).get("id").toString();
                List<Map<String, Object>> dtoTwoList = this.selectOpportunityTissueTree(id);
                dtoList.get(i).put("children", dtoTwoList);
            }
        }
        return dtoList;
    }

    @Override
    @Transactional
    public Long addOpportunity(OpportunityEntityDto opportunityEntityDto) {
        Object stageProcess;
        OpportunityEntity opportunityEntity = (OpportunityEntity)BeanUtil.copy((Object)opportunityEntityDto, OpportunityEntity.class);
        SecurityUser user = BaseSecurityUtil.getUser();
        String userName = user.getUserName();
        LocalDateTime date = LocalDateTime.now();
        assert (opportunityEntity != null);
        Long opportunityId = opportunityEntity.getOpportunityId();
        if (opportunityEntity.getOpportunityId() == null) {
            opportunityId = Long.parseLong(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId());
            opportunityEntity.setOpportunityId(opportunityId);
            opportunityEntity.setDelFlag("0");
            opportunityEntity.setCreateTime(date);
            opportunityEntity.setCreatePerson(user.getUserId());
            opportunityEntity.setCreatePersonName(userName);
            opportunityEntity.setCreateDepartment(user.getDeptId());
            opportunityEntity.setCreateDepartmentName(user.getDeptName());
            opportunityEntity.setOwnDepartment(user.getDeptId());
            opportunityEntity.setOwnDepartmentName(user.getDeptName());
            opportunityEntity.setOwnUnit(user.getTenantId());
            opportunityEntity.setOwnUnitName(user.getTenantName());
        }
        opportunityEntity.setChangeTime(date);
        opportunityEntity.setChangePerson(user.getUserId());
        opportunityEntity.setChangePersonName(userName);
        opportunityEntity.setState("1");
        opportunityEntity.setChargePersonId(user.getUserId());
        opportunityEntity.setChargePersonName(userName);
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)opportunityEntity.getProvince())) {
            opportunityEntity.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(opportunityEntity.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)opportunityEntity.getCity())) {
            opportunityEntity.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(opportunityEntity.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)opportunityEntity.getCounty())) {
            opportunityEntity.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(opportunityEntity.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        opportunityEntity.setRegionLabel(sb.toString());
        OpportunityUtil.singleOpportunityNo(opportunityEntity);
        if (ToolUtil.isNotEmpty((Object)opportunityEntity.getName()) && ToolUtil.isNotEmpty((Object)opportunityEntity.getMobilePhone()) && ToolUtil.isNotEmpty((Object)opportunityEntity.getCustomerId())) {
            opportunityEntity.setMobilePhone(opportunityEntity.getMobilePhone().replace(" ", ""));
            List contactList = this.contactService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getDelFlag, (Object)"0")).eq(ContactEntity::getCustomerId, (Object)opportunityEntity.getCustomerId())).eq(ContactEntity::getMobilePhone, (Object)opportunityEntity.getMobilePhone()));
            if (CollectionUtil.isEmpty((Collection)contactList)) {
                ContactEntity contact = new ContactEntity();
                contact.setContactName(opportunityEntity.getName());
                contact.setDepartment(opportunityEntity.getContactDepartment());
                contact.setPosition(opportunityEntity.getPosition());
                contact.setMobilePhone(opportunityEntity.getMobilePhone());
                contact.setSex(opportunityEntity.getSex());
                contact.setTelephone(opportunityEntity.getTelephone());
                contact.setEmail(opportunityEntity.getEmail());
                contact.setCustomerId(opportunityEntity.getCustomerId());
                contact.setCustomerName(opportunityEntity.getCustomerName());
                this.contactService.saveCrmContact(contact);
            }
        }
        this.saveOrUpdate(opportunityEntity);
        ArrayList<Long> typeIdList = new ArrayList<Long>(Collections.singletonList(opportunityId));
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.OPPORTUNITY, opportunityId, opportunityEntity.getOpportunityName(), date, false, typeIdList);
        if (opportunityEntity.getStageProcessId() != null && ((stageProcess = (StageProcessEntity)this.stageProcessService.getById(opportunityEntity.getStageProcessId())) == null || Objects.equals(((StageProcessEntity)stageProcess).getDelFlag(), "1"))) {
            throw new HussarException("\u6240\u9009\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        if (HussarUtils.isNotEmpty((Object)opportunityEntityDto.getSaveLabelDto()) && HussarUtils.isNotEmpty((Object)opportunityEntityDto.getSaveLabelDto().getAddLabelIds())) {
            opportunityEntityDto.getSaveLabelDto().setBusinessId(opportunityEntity.getOpportunityId());
            opportunityEntityDto.getSaveLabelDto().setChooseBatch(Boolean.valueOf(false));
            opportunityEntityDto.getSaveLabelDto().setModuleId("opportunity");
            this.labelService.userSaveLabel(opportunityEntityDto.getSaveLabelDto());
        }
        if (CollectionUtil.isNotEmpty(opportunityEntityDto.getProductList())) {
            for (OpportunityProduct product : opportunityEntityDto.getProductList()) {
                product.setOpportunityId(opportunityId);
                product.setOpportunityName(opportunityEntity.getOpportunityName());
            }
            this.opportunityProductService2.saveOpportunityProduct(opportunityEntityDto.getProductList(), false, false);
            List<Map<String, Object>> productManagers = this.opportunityMapper.opportunityProductAndManagerList(opportunityId, "0", null);
            ArrayList<String> list = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(productManagers)) {
                String managerId = String.valueOf(productManagers.get(0).get("managerId"));
                StringBuilder productName = new StringBuilder();
                HashMap<String, String> managerAndProductMap = new HashMap<String, String>();
                for (Map<String, Object> map : productManagers) {
                    if (managerId.equals(map.get("managerId").toString())) {
                        productName.append("\u3010").append(map.get("shortName")).append("\u3011\u3001");
                        continue;
                    }
                    productName.deleteCharAt(productName.length() - 1);
                    managerAndProductMap.put(managerId, productName.toString());
                    managerId = new String(String.valueOf(map.get("managerId")));
                    productName = new StringBuilder("\u3010" + map.get("shortName") + "\u3011\u3001");
                }
                productName.deleteCharAt(productName.length() - 1);
                managerAndProductMap.put(managerId, productName.toString());
                for (int i = 0; i < productManagers.size(); ++i) {
                    if (list.contains(String.valueOf(productManagers.get(i).get("managerId")))) continue;
                    list.add(String.valueOf(productManagers.get(i).get("managerId")));
                    String title = "\u3010" + productManagers.get(i).get("shortName") + "\u3011\u5546\u673a\u63d0\u9192";
                    String content = user.getDeptName() + "-" + userName + "\u521b\u5efa\u4e86\u5546\u673a\u3010" + opportunityEntity.getOpportunityName() + "\u3011\uff0c\u5e76\u5173\u8054\u4e86\u60a8\u7ba1\u7406\u7684\u4ea7\u54c1";
                    EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(opportunityId), Arrays.asList(String.valueOf(productManagers.get(i).get("managerId"))));
                    AddSysMessageType addSysMessageType = new AddSysMessageType();
                    String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunityId + "\"";
                    String contentUnify = "\u3010\u4ea7\u54c1\u52a8\u6001\u3011" + userName + " \u65b0\u5efa\u4e86 \u5546\u673a\u3010" + opportunityEntity.getOpportunityName() + "\u3011\uff0c\u5e76\u5173\u8054\u4e86\u60a8\u7ba1\u7406\u7684\u4ea7\u54c1" + (String)managerAndProductMap.get(productManagers.get(i).get("managerId").toString());
                    UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, String.valueOf(productManagers.get(i).get("managerId")), userName, unifyWebUrl, "");
                    UnifyUtil.sendMessage(addSysMessageType);
                }
            }
        }
        this.teamMeberService.insertTeamMember(opportunityEntity.getChargePersonName(), opportunityEntity.getChargePersonId(), opportunityId, "1", "1", date, "2");
        if (opportunityEntity.getCustomerId() != null) {
            typeIdList.add(opportunityEntity.getCustomerId());
        }
        return opportunityId;
    }

    @Override
    @Transactional
    public boolean updateDelFlagByIds(List<String> ids) {
        List opportunityList = this.listByIds(ids);
        List states = opportunityList.stream().map(OpportunityEntity::getState).map(Long::parseLong).collect(Collectors.toList());
        if (!states.contains(Long.valueOf("5"))) {
            throw new BaseException("\u5546\u673a\u5df2\u5206\u914d\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.opportunityMapper.updateDelFlagByIds(ids, "1");
        this.teamMeberMapper.updateDelFlagByIds(null, "1", ids);
        this.opportunityProductMapper.deleteOpportunityProduct(ids, "1");
        List trackRecordList = this.trackRecordAPIService.list(ids, null, Collections.singletonList(RecordProductTypeEnum.PRODUCE_SYSTEM.getId()), "0");
        List<Object> recordIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)trackRecordList)) {
            recordIds = trackRecordList.stream().map(TrackRecordAPIVo::getRecordId).collect(Collectors.toList());
        }
        this.trackRecordAPIService.deleteBatchByIds(ids, CrmBusinessTypeEnum.OPPORTUNITY.getId(), "1");
        List<Long> lids = ids.stream().map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(recordIds)) {
            lids.addAll(recordIds);
        }
        this.fileInfoMapper.deleteFileInfoByIds(null, lids, "1");
        return true;
    }

    @Override
    public Page<OpportunityEntity> selectOpportunityByContact(OpportunityDto dto) {
        Page page = dto.getPage();
        List<OpportunityEntity> list = this.opportunityMapper.selectOpportunityByContact(dto, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<Map<String, Object>> selectStageInfo(OpportunityDto dto) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        List<OpportunityStage> list = this.opportunityMapper.selectStageByGroupId(String.valueOf(dto.getCustomerGroupId()), "0");
        for (OpportunityStage stage : list) {
            if (!ToolUtil.isNotEmpty((Object)stage)) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("stage", stage);
            List<StageContent> filedList = this.opportunityMapper.selectContentByStageId(String.valueOf(stage.getCustomerStageId()), "0");
            map.put("filedList", filedList);
            listMap.add(map);
        }
        return listMap;
    }

    @Override
    public List<OpportunityStage> selectStageByGroupId(OpportunityDto dto) {
        String customerGroupId = String.valueOf(dto.getCustomerGroupId());
        List<OpportunityStage> list = this.opportunityMapper.selectStageByGroupId(customerGroupId, "0");
        return list;
    }

    @Override
    public String opportunityExport(HttpServletResponse response, OpportunityDto dto) {
        OpportunitySelectPermissionDto opportunitySelectPermissionDto = this.opportunityOperate(dto);
        PermissionDto opportunityPermissionDto = opportunitySelectPermissionDto.getOpportunityPermissionDto();
        PermissionDto campaignPermissionDto = opportunitySelectPermissionDto.getCampaignPermissionDto();
        List<OpportunityDto> queryDtoList = this.getOpportUnityDtoList(dto);
        List dicSingles = this.sysDicRefService.getDictByType("salesProcess_StageList");
        List<String> stageNames = dicSingles.stream().sorted(Comparator.comparingInt(DicSingle::getSort)).map(DicSingle::getLabel).collect(Collectors.toList());
        List<OpportunityEntity> list = this.opportunityMapper.selectCrmOpportunityListPermission(null, dto.getCurrentUserId(), queryDtoList, opportunityPermissionDto, campaignPermissionDto, dto.getTimeOrder(), stageNames, null);
        List<OpportunityEntity> opportunityEntityList = this.dictionaryTranslate(list);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, opportunityEntityList, "\u5546\u673a\u5217\u8868", OpportunityEntity.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    @Override
    public String opportunityExportTemplate(HttpServletResponse response) {
        ArrayList list = new ArrayList();
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u5546\u673a\u6a21\u677f", OpportunityEntity.class);
        return "\u5bfc\u51fa\u6a21\u677f\u6210\u529f";
    }

    @Override
    public int opportunityImport(MultipartFile file) {
        int flag = 0;
        ReadExcel readExcel = new ReadExcel();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        try {
            List<OpportunityEntity> list = ReadExcel.readExcel(file, OpportunityEntity.class);
            for (OpportunityEntity opportunityEntity : list) {
                opportunityEntity.setOpportunityId(Long.parseLong(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId()));
                opportunityEntity.setCreatePerson(Long.parseLong(userId));
                opportunityEntity.setCreatePersonName(userName);
                opportunityEntity.setCreateTime(date);
                opportunityEntity.setChangePerson(Long.parseLong(userId));
                opportunityEntity.setChangePersonName(userName);
                opportunityEntity.setChangeTime(date);
                opportunityEntity.setDelFlag("0");
                int i = this.opportunityMapper.insert(opportunityEntity);
                if (i <= 0) continue;
                ++flag;
            }
            return flag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public OpportunityEntityVo getOpportunityDetail(Long opportunityId) {
        List recordList;
        List YesNoDic;
        Object customer;
        List customerEntityList;
        if (!this.opportunityOperate(opportunityId).getViewOperate().booleanValue()) {
            return null;
        }
        OpportunityEntity entity = (OpportunityEntity)this.getById(opportunityId);
        if (entity == null || "1".equals(entity.getDelFlag())) {
            return null;
        }
        OpportunityEntityVo entityVo = (OpportunityEntityVo)BeanUtil.copy((Object)entity, OpportunityEntityVo.class);
        assert (entityVo != null);
        if (entityVo.getCustomerId() != null) {
            CustomerIncludePool customerEntity = this.customerMapper.selectDetail(entityVo.getCustomerId());
            if (customerEntity != null) {
                entityVo.setCustomerName(customerEntity.getCustomerName());
                entityVo.setCustomerReferredName(customerEntity.getCustomerReferredName());
                entityVo.setDisableRepeat(customerEntity.getDisableRepeat());
            }
        } else if (StringUtil.isNotBlank((CharSequence)entityVo.getCustomerName()) && CollectionUtil.isNotEmpty((Collection)(customerEntityList = this.customerService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerName, (Object)entityVo.getCustomerName())).eq(CustomerEntity::getDelFlag, (Object)"0")).eq(CustomerEntity::getDisableRepeat, (Object)"1")).orderByAsc(CustomerEntity::getCreateTime))))) {
            customer = (CustomerEntity)customerEntityList.get(0);
            entityVo.setDisableRepeat(((CustomerEntity)customer).getDisableRepeat());
        }
        if (HussarUtils.isNotEmpty((Object)entityVo.getAgentId())) {
            String agentName = this.opportunityMapper.selectAgentNameByOpportunityId(opportunityId);
            if (agentName == null && (customer = (CustomerEntity)this.customerService.getById(entityVo.getAgentId())) != null) {
                agentName = ((CustomerEntity)customer).getCustomerName();
            }
            entityVo.setAgentName(agentName);
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getCustomerStageId())) {
            OpportunityStage opportunityStage = (OpportunityStage)this.opportunityStageService.getById((Serializable)((Object)entityVo.getCustomerStageId()));
            entityVo.setCustomerStageName(opportunityStage.getCustomerStageName());
            entityVo.setStageType(opportunityStage.getStageType());
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getOpopportunityType())) {
            entityVo.setOpopportunityType(this.sysDicRefService.getDictLabel("oppport_type", entityVo.getOpopportunityType()));
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getOpopportunityFrom())) {
            entityVo.setOpopportunityFrom(this.sysDicRefService.getDictLabel("opportunity_from", entityVo.getOpopportunityFrom()));
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getImportance())) {
            entityVo.setImportance(this.sysDicRefService.getDictLabel("importance_oppty", entityVo.getImportance()));
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getPurchaseMethod())) {
            entityVo.setPurchaseMethodLabel(this.sysDicRefService.getDictLabel("purchase_method", entityVo.getPurchaseMethod()));
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getConsultationMethods())) {
            entityVo.setConsultationMethods(this.sysDicRefService.getDictLabel("consultation_methods", entityVo.getConsultationMethods()));
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getAbandonedReason())) {
            entityVo.setAbandonedReason(this.sysDicRefService.getDictLabel("abandon_reason", entityVo.getAbandonedReason()));
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getBidEvaluationForm())) {
            entityVo.setBidEvaluationForm(this.sysDicRefService.getDictLabel("bid_evaluation_form", entityVo.getBidEvaluationForm()));
        }
        if ((YesNoDic = this.sysDicRefService.getDicListByType("yes_no")) != null) {
            for (DicVo dicVo : YesNoDic) {
                if (StringUtil.isNotBlank((CharSequence)entityVo.getIsConfirmBudget()) && dicVo.getValue().equals(entityVo.getIsConfirmBudget())) {
                    entityVo.setIsConfirmBudgetLabel(dicVo.getLabel());
                }
                if (StringUtil.isNotBlank((CharSequence)entityVo.getIsConfirmPerson()) && dicVo.getValue().equals(entityVo.getIsConfirmPerson())) {
                    entityVo.setIsConfirmPersonLabel(dicVo.getLabel());
                }
                if (StringUtil.isNotBlank((CharSequence)entityVo.getIsConfirmBusiness()) && dicVo.getValue().equals(entityVo.getIsConfirmBusiness())) {
                    entityVo.setIsConfirmBusinessLabel(dicVo.getLabel());
                }
                if (StringUtil.isNotBlank((CharSequence)entityVo.getIsConfirmTime()) && dicVo.getValue().equals(entityVo.getIsConfirmTime())) {
                    entityVo.setIsConfirmTimeLabel(dicVo.getLabel());
                }
                if (StringUtil.isNotBlank((CharSequence)entityVo.getIsConfirmScheme()) && dicVo.getValue().equals(entityVo.getIsConfirmScheme())) {
                    entityVo.setIsConfirmSchemeLabel(dicVo.getLabel());
                }
                if (StringUtil.isNotBlank((CharSequence)entityVo.getIsNeedTender()) && dicVo.getValue().equals(entityVo.getIsNeedTender())) {
                    entityVo.setIsNeedTenderLabel(dicVo.getLabel());
                }
                if (!StringUtil.isNotBlank((CharSequence)entityVo.getIsProjectApproval()) || !dicVo.getValue().equals(entityVo.getIsProjectApproval())) continue;
                entityVo.setIsProjectApprovalLabel(dicVo.getLabel());
            }
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getWinningElements())) {
            String[] winingElementList = entityVo.getWinningElements().split(",");
            List winDic = this.sysDicRefService.getDictByType("winning_elements");
            ArrayList<String> winE = new ArrayList<String>();
            block1: for (String winingElement : winingElementList) {
                for (DicSingle dicSingle : winDic) {
                    if (!dicSingle.getValue().equals(winingElement)) continue;
                    winE.add(dicSingle.getLabel());
                    continue block1;
                }
            }
            entityVo.setWinningElements(String.join((CharSequence)",", winE));
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getLoseReason())) {
            String[] loseReasons = entityVo.getLoseReason().split(",");
            List loseDic = this.sysDicRefService.getDictByType("lost_type");
            ArrayList<String> loseList = new ArrayList<String>();
            block3: for (String loseReason : loseReasons) {
                Iterator iterator = loseDic.iterator();
                while (iterator.hasNext()) {
                    DicSingle dicSingle;
                    dicSingle = (DicSingle)iterator.next();
                    if (!dicSingle.getValue().equals(loseReason)) continue;
                    loseList.add(dicSingle.getLabel());
                    continue block3;
                }
            }
            entityVo.setLoseReasonLabel(String.join((CharSequence)",", loseList));
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getSalesCommitment())) {
            List salesCommimentDic = this.sysDicRefService.getDictByType("sales_commitment");
            for (DicSingle dicSingle : salesCommimentDic) {
                if (!dicSingle.getValue().equals(entityVo.getSalesCommitment())) continue;
                entityVo.setSalesCommitmentLabel(dicSingle.getLabel());
                break;
            }
        }
        entityVo.setContactCount(this.contactCharacterService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactCharacterEntity::getOpportunityId, (Object)entityVo.getOpportunityId())).ne(ContactCharacterEntity::getDelFlag, (Object)"1")));
        entityVo.setProductCount(this.crmOpportunityProduct1Service.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmOpportunityProduct1::getOpportunityId, (Object)entityVo.getOpportunityId())).ne(CrmOpportunityProduct1::getDelFlag, (Object)"1")));
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(entityVo.getOpportunityId());
        List fileRecordIds = this.trackRecordAPIService.selectRelationRecordIds(opportunityId);
        if (CollectionUtil.isNotEmpty((Collection)fileRecordIds)) {
            businessIds.addAll(fileRecordIds);
        }
        LambdaQueryWrapper fileInfoQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1");
        Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
        if (HussarUtils.isNotEmpty((Object)userSecurityLevel)) {
            fileInfoQueryWrapper.le(FileInfo::getSecurityLevel, (Object)userSecurityLevel);
        }
        entityVo.setFileCount(this.fileInfoService.count((Wrapper)fileInfoQueryWrapper));
        entityVo.setMemberCount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)entityVo.getOpportunityId())).eq(TeamMeberEntity::getBusinessType, (Object)"2")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        SecurityUser user = BaseSecurityUtil.getUser();
        long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)entityVo.getOpportunityId())).eq(FocusEntity::getBusinessType, (Object)Character.valueOf('2'))).eq(FocusEntity::getCreatePersion, (Object)user.getUserId()));
        entityVo.setFocus(focusCount > 0L);
        entityVo.setTaskAmount(this.taskAPIService.selectTaskCount("2", opportunityId));
        entityVo.setCompetitorAnalysisAmount(this.competitorAnalysisService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getDelFlag, (Object)"0")).eq(CompetitorAnalysis::getOpportunityId, (Object)opportunityId)));
        if (StringUtil.isNotBlank((CharSequence)entityVo.getProductId())) {
            String[] products = entityVo.getProductId().split(",");
            List productList = this.productService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Product::getProductId, Product::getProductName}).in(Product::getProductId, Arrays.stream(products).toArray())).orderByAsc(Product::getCreateTime));
            String productName = "";
            for (Product product : productList) {
                productName = productName + "\uff0c" + product.getProductName();
            }
            if (productName.length() > 0) {
                productName = productName.substring(1);
            }
            entityVo.setProductName(productName);
            entityVo.setIntentionalProductList(productList);
        }
        List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.OPPORTUNITY.getModuleId());
        entityVo.setLabelName(CrmLabelUtil.getLabelName(labelList, entityVo.getLabelId()));
        List operateRecordList = this.operateRecordAPIService.getLastStageRecord(opportunityId);
        long day = 0L;
        if (CollectionUtil.isNotEmpty((Collection)operateRecordList) && operateRecordList.get(0) != null) {
            long seconds = DateUtil.now().getTime() / 1000L - ((OperateRecordAPIVo)operateRecordList.get(0)).getCreateTime().toEpochSecond(ZoneOffset.of("+8"));
            if (seconds > 0L) {
                day = seconds / 86400L;
            }
            if (day >= 10L) {
                entityVo.setStageStopDays(StringUtil.toString((Object)day));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(recordList = this.trackRecordAPIService.getLatestTrackRecordDetailsByTypeIdBatch(Collections.singletonList(opportunityId)))) && recordList.get(0) != null) {
            entityVo.setRecordContent(((TrackRecordViewAPIVo)recordList.get(0)).getRecordContent());
        }
        Long quotationNumber = this.quotationApiService.queryQuotationNumbersByOpportunityId(opportunityId);
        entityVo.setQuotationNumber(Math.toIntExact(quotationNumber));
        if (StringUtil.isNotBlank((CharSequence)entityVo.getOpportunityWinRate())) {
            entityVo.setOpportunityWinRateLabel(this.sysDicRefService.getDictLabel("opportunity_win_rate", entityVo.getOpportunityWinRate()));
        }
        if (ToolUtil.isNotEmpty((Object)entityVo.getStageProcessId())) {
            entityVo.setProcessName(((StageProcessEntity)this.stageProcessService.getById(entityVo.getStageProcessId())).getProcessName());
        }
        if (ToolUtil.isNotEmpty((Object)entityVo.getSecurityLevel())) {
            entityVo.setSecurityLevelLabel(this.sysDicRefService.getDictLabel("security_level", String.valueOf(entityVo.getSecurityLevel())));
        }
        return entityVo;
    }

    @Override
    public Integer editOperate(SecurityUser user, Long businessId, String resourcePath) {
        List<Long> productTeamMemberIdList = this.teamMeberMapper.selectProductTeamMemberIdByOpportunityId(businessId);
        if (productTeamMemberIdList.contains(user.getUserId())) {
            return 1;
        }
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)businessId)).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"2"));
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                if ("1".equals(teamMeberEntity.getModifyPower())) {
                    return 1;
                }
                if (!"0".equals(teamMeberEntity.getModifyPower())) continue;
                return -1;
            }
        }
        try {
            List elementResourceVos = this.hussarBaseResourceAdapter.elementResources("/crm/sj/shangjiguanli", user.getRolesList());
            List<Object> resourceList = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)elementResourceVos) && ((ElementResourceVo)elementResourceVos.get(0)).getPermission() != null) {
                resourceList = Arrays.asList(((ElementResourceVo)elementResourceVos.get(0)).getPermission().split(","));
            }
            if (resourceList.contains(resourcePath)) {
                return 1;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public OperateVo opportunityOperate(Long businessId) {
        List<Long> productTeamMemberIdList;
        OperateVo operateVo = new OperateVo();
        if (businessId == null) {
            return operateVo;
        }
        OpportunityEntity opportunityEntity = (OpportunityEntity)this.getById(businessId);
        if (opportunityEntity == null || "1".equals(opportunityEntity.getDelFlag())) {
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)user.getSecurityLevel()) && user.getSecurityLevel() < opportunityEntity.getSecurityLevel()) {
            return operateVo;
        }
        if ("0".equals(opportunityEntity.getProcessState()) && user.getUserId().equals(opportunityEntity.getCreatePerson())) {
            operateVo.setViewOperate(Boolean.valueOf(true));
            operateVo.setEditOperate(Integer.valueOf(1));
            return operateVo;
        }
        Long userId = user.getUserId();
        if (Objects.equals(opportunityEntity.getChargePersonId(), userId)) {
            operateVo.setViewOperate(Boolean.valueOf(true));
            operateVo.setEditOperate(Integer.valueOf(1));
            return operateVo;
        }
        this.teamMemberApiService.teamMemberOperate(opportunityEntity.getOpportunityId(), user, operateVo, "2");
        if (!operateVo.getViewOperate().booleanValue() && (productTeamMemberIdList = this.teamMeberMapper.selectProductTeamMemberIdByOpportunityId(businessId)).contains(userId)) {
            operateVo.setViewOperate(Boolean.valueOf(true));
        }
        if (!operateVo.getViewOperate().booleanValue()) {
            PermissionDto opportunityPermissionDto = this.opportunityDataRightModuleService.getUserRolePermission(user);
            if (CollectionUtil.isEmpty((Collection)opportunityPermissionDto.getPermissionDeptIds()) || opportunityPermissionDto.getPermissionDeptIds().contains(opportunityEntity.getOwnDepartment())) {
                operateVo.setViewOperate(Boolean.valueOf(true));
            } else if (opportunityEntity.getCampaignId() != null) {
                List campaignTeamMemberIdList = this.teamMeberService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TeamMeberEntity::getPersonId}).eq(TeamMeberEntity::getBusinessId, (Object)opportunityEntity.getCampaignId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"5"), id -> (Long)id);
                if (CollectionUtil.isNotEmpty((Collection)campaignTeamMemberIdList)) {
                    operateVo.setViewOperate(Boolean.valueOf(true));
                } else {
                    PermissionDto campaignPermissionDto;
                    MarketingActivityEntity marketingActivityEntity = (MarketingActivityEntity)this.marketingActivityService.getById(opportunityEntity.getCampaignId());
                    if (marketingActivityEntity != null && (CollectionUtil.isEmpty((Collection)(campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user)).getPermissionDeptIds()) || campaignPermissionDto.getPermissionDeptIds().contains(marketingActivityEntity.getOwnDepartment()))) {
                        operateVo.setViewOperate(Boolean.valueOf(true));
                    }
                }
            }
        }
        return operateVo;
    }

    @Override
    public List<OpportunityRepeatVO> selectOpportunityRepeatList(OpportunityDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getOpportunityName())) {
            return null;
        }
        String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
        List<OpportunityRepeatVO> list = this.repeatOpportunityMapper.suspectedOpportunityListByOpportunityName(dto.getOpportunityName(), openPool);
        Collections.sort(list, (a, b) -> {
            if (dto.getOpportunityName().equals(a.getOpportunityName()) && !dto.getOpportunityName().equals(b.getOpportunityName())) {
                return -1;
            }
            if (!dto.getOpportunityName().equals(a.getOpportunityName()) && dto.getOpportunityName().equals(b.getOpportunityName())) {
                return 1;
            }
            return a.getOpportunityName().compareTo(b.getOpportunityName());
        });
        return list;
    }

    @Override
    public CheckRepeat opportunityCheckRepeat(OpportunityDto dto) {
        List<String> likePoolNameList;
        long count;
        List<String> poolNameList;
        long companyCount;
        long departmentCount;
        if (ToolUtil.isEmpty((Object)dto.getOpportunityName())) {
            return new CheckRepeat(){
                {
                    this.setToastMsg("");
                    this.setAllowSaving(true);
                }
            };
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        Long parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId());
        List<Object> deptIds = new ArrayList();
        deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId);
        if (CollectionUtil.isEmpty(deptIds)) {
            deptIds.add(user.getDeptId().toString());
        }
        if ((departmentCount = ToolUtil.isEmpty((Object)dto.getOpportunityId()) ? this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getOpportunityName, (Object)dto.getOpportunityName())).eq(OpportunityEntity::getDelFlag, (Object)"0")).in(OpportunityEntity::getOwnDepartment, deptIds)) : this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getOpportunityName, (Object)dto.getOpportunityName())).eq(OpportunityEntity::getDelFlag, (Object)"0")).ne(OpportunityEntity::getOpportunityId, (Object)dto.getOpportunityId())).in(OpportunityEntity::getOwnDepartment, deptIds))) > 0L) {
            return new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u5546\u673a\u5728\u90e8\u95e8\u5185\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d");
                    this.setAllowSaving(false);
                }
            };
        }
        LambdaQueryWrapper getOpportunityList = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)getOpportunityList.eq(OpportunityEntity::getOpportunityName, (Object)dto.getOpportunityName())).eq(OpportunityEntity::getDelFlag, (Object)"0");
        if (ToolUtil.isNotEmpty((Object)dto.getOpportunityId())) {
            getOpportunityList.ne(OpportunityEntity::getOpportunityId, (Object)dto.getOpportunityId());
        }
        if ((companyCount = this.count((Wrapper)getOpportunityList)) > 0L) {
            return new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u5546\u673a\u5728\u516c\u53f8\u5185\u5b58\u5728");
                    this.setAllowSaving(true);
                }
            };
        }
        String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
        if ("1".equals(openPool) && HussarUtils.isNotEmpty(poolNameList = this.opportunityPoolOppoMapper.repeatOpportunityPoolByOpportunityName(dto.getOpportunityName(), null)) && poolNameList.size() > 0) {
            return this.poolCheckRepeatMsg(poolNameList, "1");
        }
        LambdaQueryWrapper getOpportunityLikeList = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)getOpportunityLikeList.like(OpportunityEntity::getOpportunityName, (Object)dto.getOpportunityName())).eq(OpportunityEntity::getDelFlag, (Object)"0");
        if (ToolUtil.isNotEmpty((Object)dto.getOpportunityId())) {
            getOpportunityLikeList.ne(OpportunityEntity::getOpportunityId, (Object)dto.getOpportunityId());
        }
        if ((count = this.count((Wrapper)getOpportunityLikeList)) > 0L) {
            return new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u5546\u673a\u5728\u516c\u53f8\u5185\u7591\u4f3c\u5b58\u5728");
                    this.setAllowSaving(true);
                }
            };
        }
        if ("1".equals(openPool) && HussarUtils.isNotEmpty(likePoolNameList = this.opportunityPoolOppoMapper.repeatOpportunityPoolByOpportunityName(null, dto.getOpportunityName())) && likePoolNameList.size() > 0) {
            return this.poolCheckRepeatMsg(likePoolNameList, "2");
        }
        return new CheckRepeat(){
            {
                this.setToastMsg("");
                this.setAllowSaving(true);
            }
        };
    }

    public CheckRepeat poolCheckRepeatMsg(List<String> poolNameList, String repeatType) {
        StringBuffer poolName = new StringBuffer();
        for (String s : poolNameList) {
            if (HussarUtils.isNotEmpty((Object)poolName)) {
                poolName = poolName.append("\u3001").append(s);
                continue;
            }
            poolName = poolName.append(s);
        }
        String name = poolName.toString();
        if (name.length() > 20) {
            String startName = name.substring(0, 8);
            String endName = name.substring(name.length() - 8, name.length());
            name = startName + "..." + endName;
        }
        final String finalName = name;
        if ("1".equals(repeatType)) {
            return new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u5546\u673a\u5728\u3010" + finalName + "\u3011\u516c\u6d77\u6c60\u4e2d\u5b58\u5728");
                    this.setRepeatResult(true);
                    this.setAllowSaving(true);
                }
            };
        }
        return new CheckRepeat(){
            {
                this.setToastMsg("\u8be5\u5546\u673a\u5728\u3010" + finalName + "\u3011\u516c\u6d77\u6c60\u4e2d\u7591\u4f3c\u5b58\u5728");
                this.setRepeatResult(true);
                this.setAllowSaving(true);
            }
        };
    }

    @Override
    public List<OpportunityEntity> selectRepeatOpportunityList(OpportunityDto opportunityDto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto permissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        opportunityDto.setDelFlag("0");
        List<OpportunityEntity> opportunityEntityList = this.opportunityMapper.selectRepeatOpportunityList(opportunityDto);
        if (CollectionUtil.isEmpty((Collection)permissionDto.getPermissionDeptIds())) {
            permissionDto.setPermissionDeptIds(Collections.EMPTY_LIST);
        }
        if (CollectionUtil.isEmpty(opportunityEntityList)) {
            return null;
        }
        for (OpportunityEntity opportunity : opportunityEntityList) {
            Long parentId;
            List teamMemberList = this.teamMeberService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TeamMeberEntity::getPersonId}).eq(TeamMeberEntity::getBusinessId, (Object)opportunity.getOpportunityId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getBusinessType, (Object)"2"), s -> Long.parseLong(s.toString()));
            if (opportunity.getChargePersonId().equals(user.getUserId())) {
                opportunity.setRepeat("1");
                continue;
            }
            if (permissionDto.getPermissionDeptIds().contains(opportunity.getOwnDepartment())) {
                opportunity.setRepeat("2");
                continue;
            }
            if (teamMemberList.size() > 0 && teamMemberList.contains(user.getUserId())) {
                opportunity.setRepeat("2");
                continue;
            }
            List<Map<String, Long>> struList = DataPermission.getStruCache();
            List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId()));
            List deptLongIds = deptIds.stream().map(Long::valueOf).collect(Collectors.toList());
            if (deptLongIds.contains(opportunity.getOwnDepartment())) {
                opportunity.setRepeat("3");
                continue;
            }
            opportunity.setRepeat("4");
        }
        return opportunityEntityList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OpportunityEntity> dictionaryTranslate(List<OpportunityEntity> list) {
        List<Map<String, Object>> getAllSecordStru = this.commonService.getAllSecondStru();
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        List opportunityFroms = this.sysDicRefService.getDicListByType("opportunity_from");
        List states = this.sysDicRefService.getDicListByType("leads_state");
        List winningElementList = this.sysDicRefService.getDicListByType("winning_elements");
        List abandonedReasons = this.sysDicRefService.getDicListByType("abandon_reason");
        List loseReasonList = this.sysDicRefService.getDicListByType("lost_type");
        List opportunityStageList = this.opportunityStageService.list();
        List trades = this.sysDicRefService.getDicListByType("industry");
        List opportunityTypes = this.sysDicRefService.getDicListByType("oppport_type");
        List consultationMethods = this.sysDicRefService.getDicListByType("consultation_methods");
        List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.OPPORTUNITY.getModuleId());
        List opportunityWinRates = this.sysDicRefService.getDicListByType("opportunity_win_rate");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageLose(true);
        stageTypeDto.setStageAbandon(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List stageWin = stageSelectDto.getStageWin().stream().map(String::valueOf).collect(Collectors.toList());
        List stageLose = stageSelectDto.getStageLose().stream().map(String::valueOf).collect(Collectors.toList());
        List stageAbandon = stageSelectDto.getStageAbandon().stream().map(String::valueOf).collect(Collectors.toList());
        block0: for (OpportunityEntity opportunity : list) {
            TrackRecordAPIVo trackRecord;
            String label;
            Object value;
            int n;
            List<Map<String, Object>> productMap;
            opportunity.setOpportunityAmountDouble(Double.parseDouble(opportunity.getOpportunityAmount()));
            opportunity.setCreateDate(opportunity.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
            if (ToolUtil.isNotEmpty((Object)opportunity.getFindTime())) {
                opportunity.setFindDate(opportunity.getFindTime().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
            }
            if (CollectionUtil.isNotEmpty(productMap = this.opportunityProductMapper.selectOpportunityProductNamePriceByOpportunityId(opportunity.getOpportunityId()))) {
                Iterator productName = new StringBuilder();
                StringBuilder stringBuilder = new StringBuilder();
                for (Map<String, Object> map : productMap) {
                    if (map == null) continue;
                    ((StringBuilder)((Object)productName)).append(map.get("PRODUCT_NAME")).append(",");
                    stringBuilder.append(map.get("SELL_PRICE")).append(",");
                }
                if (((StringBuilder)((Object)productName)).length() > 0) {
                    ((StringBuilder)((Object)productName)).deleteCharAt(((StringBuilder)((Object)productName)).length() - 1);
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                opportunity.setOpportunityProducName(((StringBuilder)((Object)productName)).toString());
                opportunity.setProductAmount(stringBuilder.toString());
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getOpopportunityFrom())) {
                for (DicVo dicVo : opportunityFroms) {
                    if (!opportunity.getOpopportunityFrom().equals(dicVo.getValue())) continue;
                    opportunity.setOpopportunityFrom(dicVo.getLabel());
                    break;
                }
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getState())) {
                for (DicVo dicVo : states) {
                    if (!opportunity.getState().equals(dicVo.getValue())) continue;
                    opportunity.setState(dicVo.getLabel());
                    break;
                }
            }
            if (stageWin.contains(opportunity.getCustomerStageId())) {
                opportunity.setWinningAmount(Double.parseDouble(opportunity.getOpportunityAmount()));
                if (ToolUtil.isNotEmpty((Object)opportunity.getEndTime())) {
                    opportunity.setSuccessDate(opportunity.getEndTime());
                }
                if (ToolUtil.isNotEmpty((Object)opportunity.getWinningElements())) {
                    void var24_30;
                    String[] winningArr = opportunity.getWinningElements().split(",");
                    StringBuilder stringBuilder = new StringBuilder();
                    if (winningArr.length > 0) {
                        String[] stringArray = winningArr;
                        int n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            value = stringArray[n];
                            label = "";
                            for (DicVo dicVo : winningElementList) {
                                if (!((String)value).equals(dicVo.getValue())) continue;
                                label = dicVo.getLabel();
                            }
                            if (!ToolUtil.isNotEmpty((Object)label)) continue;
                            stringBuilder.append(",").append(label);
                        }
                        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.length() > 0 ? stringBuilder.substring(1) : stringBuilder);
                    }
                    opportunity.setWinningElements(var24_30.toString());
                    opportunity.setLoseReason(null);
                    opportunity.setLoseReasonDetail(null);
                    opportunity.setAbandonedReason(null);
                    opportunity.setAbandonedDescribe(null);
                }
            } else if (stageAbandon.contains(opportunity.getCustomerStageId())) {
                if (ToolUtil.isNotEmpty((Object)opportunity.getAbandonedReason())) {
                    for (DicVo dicVo : abandonedReasons) {
                        if (!opportunity.getAbandonedReason().equals(dicVo.getValue())) continue;
                        opportunity.setAbandonedReason(dicVo.getLabel());
                        break;
                    }
                }
                opportunity.setSuccessDate(null);
                opportunity.setWinningAmount(null);
                opportunity.setWinningElements(null);
                opportunity.setLoseReason(null);
                opportunity.setLoseReasonDetail(null);
            } else if (stageLose.contains(opportunity.getCustomerStageId())) {
                if (ToolUtil.isNotEmpty((Object)opportunity.getLoseReason())) {
                    void var24_34;
                    String[] loseArr = opportunity.getLoseReason().split(",");
                    StringBuilder stringBuilder = new StringBuilder();
                    if (loseArr.length > 0) {
                        String[] stringArray = loseArr;
                        int n3 = stringArray.length;
                        for (n = 0; n < n3; ++n) {
                            value = stringArray[n];
                            label = "";
                            for (DicVo dicVo : loseReasonList) {
                                if (!((String)value).equals(dicVo.getValue())) continue;
                                label = dicVo.getLabel();
                            }
                            if (!ToolUtil.isNotEmpty((Object)label)) continue;
                            stringBuilder.append(",").append(label);
                        }
                        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder.length() > 0 ? stringBuilder.substring(1) : stringBuilder);
                    }
                    opportunity.setLoseReason(var24_34.toString());
                }
                opportunity.setSuccessDate(null);
                opportunity.setWinningAmount(null);
                opportunity.setWinningElements(null);
                opportunity.setAbandonedReason(null);
                opportunity.setAbandonedDescribe(null);
            } else {
                opportunity.setSuccessDate(null);
                opportunity.setWinningAmount(null);
                opportunity.setWinningElements(null);
                opportunity.setAbandonedReason(null);
                opportunity.setAbandonedDescribe(null);
                opportunity.setLoseReason(null);
                opportunity.setLoseReasonDetail(null);
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getCustomerStageId())) {
                for (OpportunityStage opportunityStage : opportunityStageList) {
                    if (!opportunity.getCustomerStageId().equals(String.valueOf(opportunityStage.getCustomerStageId()))) continue;
                    opportunity.setCustomerStageId(opportunityStage.getCustomerStageName());
                    break;
                }
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getTrade())) {
                for (DicVo dicVo : trades) {
                    if (!opportunity.getTrade().equals(dicVo.getValue())) continue;
                    opportunity.setTrade(dicVo.getLabel());
                    break;
                }
            }
            block11: for (Map map : struList) {
                if (!ToolUtil.isNotEmpty((Object)opportunity.getOwnDepartment()) || !opportunity.getOwnDepartment().equals(map.get("struId"))) continue;
                String string = String.valueOf(map.get("parentId"));
                for (Map<String, Object> secordStru : getAllSecordStru) {
                    if (!string.equals(String.valueOf(secordStru.get("struId")))) continue;
                    opportunity.setParentDepartmentName(String.valueOf(secordStru.get("struName")));
                    continue block11;
                }
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getTrackTime())) {
                opportunity.setTrackDate(opportunity.getTrackTime().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
            }
            if (ToolUtil.isNotEmpty((Object)(trackRecord = this.trackRecordAPIService.selectTrackRecordContentByTypeId(opportunity.getOpportunityId())))) {
                String string = trackRecord.getRecordContent();
                opportunity.setRecordContent(string);
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getOpopportunityType())) {
                for (DicVo dicVo : opportunityTypes) {
                    if (!opportunity.getOpopportunityType().equals(dicVo.getValue())) continue;
                    opportunity.setOpopportunityType(dicVo.getLabel());
                    break;
                }
            }
            opportunity.setLabelName(CrmLabelUtil.getLabelName(labelList, opportunity.getLabelId()));
            if (ToolUtil.isNotEmpty((Object)opportunity.getConsultationMethods())) {
                for (DicVo dicVo : consultationMethods) {
                    if (!opportunity.getConsultationMethods().equals(dicVo.getValue())) continue;
                    opportunity.setConsultationMethods(dicVo.getLabel());
                    break;
                }
            }
            if (!ToolUtil.isNotEmpty((Object)opportunity.getOpportunityWinRate())) continue;
            for (DicVo dicVo : opportunityWinRates) {
                if (!opportunity.getOpportunityWinRate().equals(dicVo.getValue())) continue;
                opportunity.setOpportunityWinRate(dicVo.getLabel());
                continue block0;
            }
        }
        return list;
    }

    private OpportunityDto opportunityQueryCondition(OpportunityDto dto) {
        DateStartEndVo dateStartEndVo;
        DateConvertVo dateConvertVo;
        String opportunityView;
        SecurityUser user;
        if (StringUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("1");
        }
        if (ToolUtil.isNotEmpty((Object)dto.getOpportunityScreening())) {
            dto.setOpportunityScreening(CommonUtills.escapeLike((String)dto.getOpportunityScreening()));
        }
        if ((user = BaseSecurityUtil.getUser()) == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (String string : dto.getChargePersonIds()) {
                userIds.add(com.jxdinfo.crm.core.utills.CommonUtills.translateUserId(string));
            }
            dto.setTransChargePersonIds(userIds);
        }
        ArrayList<String> createPersonIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getCreatePersonIds()) && dto.getCreatePersonIds().size() > 0) {
            for (String string : dto.getCreatePersonIds()) {
                createPersonIds.add(com.jxdinfo.crm.core.utills.CommonUtills.translateUserId(string));
            }
            dto.setTransCreatePersonIds(createPersonIds);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getTeamMemberIds()) && dto.getTeamMemberIds().size() > 0) {
            for (String teamMemberId : dto.getTeamMemberIds()) {
                arrayList.add(com.jxdinfo.crm.core.utills.CommonUtills.translateUserId(teamMemberId));
            }
            dto.setTransTeamMemberIds(arrayList);
        }
        List<String> list = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(list) && list.size() > 0) {
            for (String odpId : list) {
                ArrayList<String> Ids;
                String odpIsTemp = com.jxdinfo.crm.core.utills.CommonUtills.translateDepId(odpId);
                List<String> idsTemp = com.jxdinfo.crm.core.utills.CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        List<String> createDepartments = dto.getCreateDepartments();
        ArrayList<String> cdpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(createDepartments) && createDepartments.size() > 0) {
            for (String cdpId : createDepartments) {
                ArrayList<String> Ids;
                String cdpIsTemp = com.jxdinfo.crm.core.utills.CommonUtills.translateDepId(cdpId);
                List<String> idsTemp = com.jxdinfo.crm.core.utills.CommonUtills.selectOpportunityTissueTreeUserId(cdpIsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    cdpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransCreateDepartmentIds(cdpIds);
        }
        if ("2".equals(opportunityView = dto.getOpportunityView()) || "2".equals(dto.getCompetence())) {
            dto.setOpportunityView("myself");
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if ("6".equals(opportunityView)) {
            dto.setCreatePerson(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"3".equals(dto.getEndTime()) && !"6".equals(dto.getEndTime())) {
            dateConvertVo = IndexUtil.getCurrentTime(dto.getEndTime());
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        } else if ("6".equals(dto.getEndTime()) && StringUtil.isEmpty((Object)dto.getStartDate()) && StringUtil.isEmpty((Object)dto.getEndDate())) {
            dto.setEndTime(null);
        }
        dto.setDelFlag("0");
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getClaimTimeFlag()) && !"6".equals(dto.getClaimTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getClaimTimeFlag())) != null) {
            dto.setClaimTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setClaimTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getAllocateTimeFlag()) && !"6".equals(dto.getAllocateTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getAllocateTimeFlag())) != null) {
            dto.setAllocateTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setAllocateTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getRecycleTimeFlag()) && !"6".equals(dto.getRecycleTimeFlag()) && (dateStartEndVo = CrmDateUtils.inviteSevenFifteenThirtyTime((String)dto.getRecycleTimeFlag())) != null) {
            dto.setRecycleTimeStart(dateStartEndVo.getStartDate());
            dto.setRecycleTimeEnd(dateStartEndVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getSuccessTimeRange()) && !"6".equals(dto.getSuccessTimeRange()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSuccessTimeRange())) != null) {
            dto.setSuccessStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setSuccessEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getTrackTimeFlag()) && !"6".equals(dto.getTrackTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getTrackTimeFlag())) != null) {
            dto.setTrackTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setTrackTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty(dto.getCustomerStageIds())) {
            ArrayList<String> customerStageIdSplit = new ArrayList<String>();
            for (String stageId : dto.getCustomerStageIds()) {
                if (!ToolUtil.isNotEmpty((Object)stageId)) continue;
                customerStageIdSplit.addAll(Arrays.asList(stageId.split(",")));
            }
            dto.setCustomerStageIds(customerStageIdSplit);
        }
        dto.setCurrentUserId(user.getUserId());
        LocalDate now = LocalDate.now();
        LocalDate sevenDaysLater = now.minus(Period.ofDays(7));
        LocalDate fifteenDaysLater = now.minus(Period.ofDays(15));
        LocalDate thirtyDaysLater = now.minus(Period.ofDays(30));
        dto.setSevenDaysLater(sevenDaysLater);
        dto.setFifteenDaysLater(fifteenDaysLater);
        dto.setThirtyDaysLater(thirtyDaysLater);
        dto.setSearchKeyCustomerProfile(CommonUtills.escapeLike((String)dto.getSearchKeyCustomerProfile()));
        return dto;
    }

    private OpportunitySelectPermissionDto opportunityOperate(OpportunityDto dto) {
        PermissionDto opportunityPermissionDto = new PermissionDto();
        PermissionDto campaignPermissionDto = new PermissionDto();
        String opportunityView = dto.getOpportunityView();
        if (StringUtil.isNotEmpty((Object)opportunityView) && !"2".equals(opportunityView) && !"0".equals(opportunityView) && !"10".equals(opportunityView)) {
            if (dto != null && dto.getCurrentUserId() != null) {
                opportunityPermissionDto = this.opportunityDataRightModuleService.getUserRolePermissionsByUserId(dto.getCurrentUserId());
                campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermissionsByUserId(dto.getCurrentUserId());
            } else {
                opportunityPermissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
                campaignPermissionDto = this.marketingActivityDataRightModuleService.getCurrentUserRolePermissions();
            }
            if ("6".equals(opportunityView)) {
                opportunityPermissionDto.setPermissionDeptIds(null);
                opportunityPermissionDto.setPermissionUserId(null);
                campaignPermissionDto.setPermissionDeptIds(null);
                campaignPermissionDto.setPermissionUserId(null);
            }
        }
        OpportunitySelectPermissionDto opportunitySelectPermissionDto = new OpportunitySelectPermissionDto();
        opportunitySelectPermissionDto.setOpportunityPermissionDto(opportunityPermissionDto);
        opportunitySelectPermissionDto.setCampaignPermissionDto(campaignPermissionDto);
        return opportunitySelectPermissionDto;
    }

    @Override
    public CheckRepeat selectSuspectedOpportunityByCustomerName(String customerName) {
        List<String> poolNameList;
        long customerCount = this.customerIncludePoolService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(CustomerEntity::getCustomerName, (Object)customerName)).eq(CustomerEntity::getDelFlag, (Object)"0"));
        if (customerCount > 0L) {
            return new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u5ba2\u6237\u5728\u516c\u53f8\u5185\u7591\u4f3c\u5b58\u5728");
                    this.setRepeatResult(true);
                    this.setAllowSaving(true);
                }
            };
        }
        long opportunityCount = this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(OpportunityEntity::getCustomerName, (Object)customerName)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
        if (opportunityCount > 0L) {
            return new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u5ba2\u6237\u5728\u516c\u53f8\u5185\u7591\u4f3c\u5b58\u5728");
                    this.setRepeatResult(true);
                    this.setAllowSaving(true);
                }
            };
        }
        String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
        if ("1".equals(openPool) && HussarUtils.isNotEmpty(poolNameList = this.opportunityPoolOppoMapper.repeatOpportunityPoolByCustomerName(customerName)) && poolNameList.size() > 0) {
            StringBuffer poolName = new StringBuffer();
            for (String s : poolNameList) {
                if (HussarUtils.isNotEmpty((Object)poolName)) {
                    poolName = poolName.append("\u3001").append(s);
                    continue;
                }
                poolName = poolName.append(s);
            }
            if (HussarUtils.isNotEmpty((Object)poolName)) {
                String name = poolName.toString();
                if (name.length() > 20) {
                    String startName = name.substring(0, 8);
                    String endName = name.substring(name.length() - 8, name.length());
                    name = startName + "..." + endName;
                }
                final String finalName = name;
                return new CheckRepeat(){
                    {
                        this.setToastMsg("\u8be5\u5ba2\u6237\u5728\u3010" + finalName + "\u3011\u516c\u6d77\u6c60\u4e2d\u7591\u4f3c\u5b58\u5728");
                        this.setRepeatResult(true);
                        this.setAllowSaving(true);
                    }
                };
            }
        }
        return new CheckRepeat(){
            {
                this.setToastMsg("");
                this.setRepeatResult(false);
                this.setAllowSaving(true);
            }
        };
    }

    @Override
    public CheckRepeat selectSuspectedOpportunityByMobilePhone(String mobilePhone) {
        List<String> poolNameList;
        long contactCount = this.contactService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getMobilePhone, (Object)mobilePhone)).eq(ContactEntity::getDelFlag, (Object)"0"));
        if (contactCount > 0L) {
            return new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u624b\u673a\u53f7\u5728\u516c\u53f8\u5185\u7591\u4f3c\u5b58\u5728");
                    this.setRepeatResult(true);
                    this.setAllowSaving(true);
                }
            };
        }
        long opportunityCount = this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getMobilePhone, (Object)mobilePhone)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
        if (opportunityCount > 0L) {
            return new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u624b\u673a\u53f7\u5728\u516c\u53f8\u5185\u7591\u4f3c\u5b58\u5728");
                    this.setRepeatResult(true);
                    this.setAllowSaving(true);
                }
            };
        }
        String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
        if ("1".equals(openPool) && HussarUtils.isNotEmpty(poolNameList = this.opportunityPoolOppoMapper.repeatOpportunityPoolByMobile(mobilePhone)) && poolNameList.size() > 0) {
            StringBuffer poolName = new StringBuffer();
            for (String s : poolNameList) {
                if (HussarUtils.isNotEmpty((Object)poolName)) {
                    poolName = poolName.append("\u3001").append(s);
                    continue;
                }
                poolName = poolName.append(s);
            }
            if (HussarUtils.isNotEmpty((Object)poolName)) {
                String name = poolName.toString();
                if (name.length() > 20) {
                    String startName = name.substring(0, 8);
                    String endName = name.substring(name.length() - 8, name.length());
                    name = startName + "..." + endName;
                }
                final String finalName = name;
                return new CheckRepeat(){
                    {
                        this.setToastMsg("\u8be5\u624b\u673a\u53f7\u5728\u3010" + finalName + "\u3011\u516c\u6d77\u6c60\u4e2d\u7591\u4f3c\u5b58\u5728");
                        this.setRepeatResult(true);
                        this.setAllowSaving(true);
                    }
                };
            }
        }
        return new CheckRepeat(){
            {
                this.setToastMsg("");
                this.setRepeatResult(false);
                this.setAllowSaving(true);
            }
        };
    }

    @Override
    public Page<OpportunityRepeatVO> suspectedOpportunityListByName(PageInfo pageInfo, String customerName) {
        if (ToolUtil.isEmpty((Object)customerName)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
        List<OpportunityRepeatVO> list = this.repeatOpportunityMapper.suspectedOpportunityListByName((Page<OpportunityRepeatVO>)page, customerName, openPool);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<OpportunityRepeatVO> suspectedOpportunityListByPhone(PageInfo pageInfo, String mobilePhone) {
        if (ToolUtil.isEmpty((Object)mobilePhone)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
        List<OpportunityRepeatVO> list = this.repeatOpportunityMapper.suspectedOpportunityListByPhone((Page<OpportunityRepeatVO>)page, mobilePhone, openPool);
        page.setRecords(list);
        return page;
    }

    @Override
    public Long selectFollowCount(Long chargePersonId) {
        ArrayList<String> states = new ArrayList<String>();
        states.add("1");
        states.add("2");
        Long followCount = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getDelFlag, (Object)"0")).eq(OpportunityEntity::getChargePersonId, (Object)chargePersonId)).in(OpportunityEntity::getState, states));
        return followCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File exportExcelPaper(List<SuspectedOpportunityVo> list) {
        int i;
        String[] title = new String[]{"\u5bfc\u5165\u5546\u673a\u540d\u79f0", "\u5bfc\u5165\u5ba2\u6237\u540d\u79f0", "\u7591\u4f3c\u5546\u673a\u7f16\u53f7", "\u7591\u4f3c\u5546\u673a\u540d\u79f0", "\u7591\u4f3c\u5ba2\u6237\u540d\u79f0", "\u8d1f\u8d23\u4eba"};
        String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
        if ("1".equals(openPool)) {
            title = new String[]{"\u5bfc\u5165\u5546\u673a\u540d\u79f0", "\u5bfc\u5165\u5ba2\u6237\u540d\u79f0", "\u7591\u4f3c\u5546\u673a\u7f16\u53f7", "\u7591\u4f3c\u5546\u673a\u540d\u79f0", "\u7591\u4f3c\u5ba2\u6237\u540d\u79f0", "\u8d1f\u8d23\u4eba", "\u516c\u6d77\u6c60"};
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        OpportunityServiceImpl.setColumnWidth(sheet, 8);
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = null;
        for (i = 0; i < title.length; ++i) {
            cell = row.createCell(i);
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            XSSFFont font = workbook.createFont();
            font.setFontName("\u5b8b\u4f53");
            font.setFontHeightInPoints((short)13);
            cellStyle.setFont((Font)font);
            cell.setCellStyle((CellStyle)cellStyle);
            cell.setCellValue(title[i]);
        }
        System.out.println(list);
        for (i = 1; i < list.size() + 1; ++i) {
            XSSFRow nextRow = sheet.createRow(i);
            for (int j = 0; j < title.length; ++j) {
                SuspectedOpportunityVo opportunityVo = list.get(i - 1);
                XSSFCell cell2 = nextRow.createCell(j);
                if (j == 0) {
                    cell2.setCellValue(opportunityVo.getImportOpportunityName());
                }
                if (j == 1) {
                    cell2.setCellValue(opportunityVo.getImportCustomerName());
                }
                if (j == 2) {
                    cell2.setCellValue(opportunityVo.getSuspectedOpportunityNo());
                }
                if (j == 3) {
                    cell2.setCellValue(opportunityVo.getSuspectedOpportunityName());
                }
                if (j == 4) {
                    cell2.setCellValue(opportunityVo.getSuspectedCustomerName());
                }
                if (j == 5) {
                    cell2.setCellValue(opportunityVo.getChargePersonName());
                }
                if (j != 6) continue;
                cell2.setCellValue(opportunityVo.getOppoPoolName());
            }
        }
        File file = new File("\u7591\u4f3c\u5546\u673a.xlsx");
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            workbook.write((OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return file;
    }

    @Override
    public List<OpportunityVo> selectOpportunityByPartnerId(Long customerId, String opportunityName) {
        List<OpportunityVo> opportunityVoList;
        if (ToolUtil.isNotEmpty((Object)opportunityName)) {
            opportunityName = opportunityName.replaceAll("%", "/%").replaceAll("_", "/_");
        }
        if (CollectionUtil.isNotEmpty(opportunityVoList = this.opportunityMapper.selectOpportunityByPartnerId(customerId, opportunityName))) {
            List opportunityStageList = this.opportunityStageService.list();
            for (OpportunityVo opportunityVo : opportunityVoList) {
                if (!ToolUtil.isNotEmpty((Object)opportunityVo.getCustomerStageId())) continue;
                for (OpportunityStage opportunityStage : opportunityStageList) {
                    if (!String.valueOf(opportunityStage.getCustomerStageId()).equals(opportunityVo.getCustomerStageId())) continue;
                    opportunityVo.setCustomerStageName(opportunityStage.getCustomerStageName());
                }
            }
        }
        return opportunityVoList;
    }

    private static void setColumnWidth(XSSFSheet sheet, int colNum) {
        for (int i = 0; i < colNum; ++i) {
            int v = 0;
            v = Math.round(Float.parseFloat("15.0") * 37.0f);
            v = Math.round(Float.parseFloat("20.0") * 267.5f);
            sheet.setColumnWidth(i, v);
        }
    }

    @Override
    public Boolean updateChangeTime(String opportunityId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        this.opportunityService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(OpportunityEntity::getOpportunityId, (Object)opportunityId)).eq(OpportunityEntity::getDelFlag, (Object)"0")).set(OpportunityEntity::getChangeTime, (Object)date)).set(OpportunityEntity::getChangePerson, (Object)user.getUserId())).set(OpportunityEntity::getChangePersonName, (Object)user.getUserName()));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public TransferBatchResultVo opportunityTransferBatch(List<OpportunityDto> dtos) {
        ArrayList<String> msgList;
        LocalDateTime date;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int dtoSize = dtos.size();
        int undistributedNum = 0;
        int noPermissionForOpportunityNum = 0;
        int noPermissionForCustomerNum = 0;
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = com.jxdinfo.crm.core.utills.CommonUtills.translateUserId(dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = com.jxdinfo.crm.core.utills.CommonUtills.selectDepIdName(newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        SecurityUser newChargePeron = this.commonMapper.selectSecurityByUserId(Long.valueOf(newChargePersonId));
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        ArrayList<Long> excludeOpportunityIdList = new ArrayList<Long>();
        List<Long> opportunityIdList = dtos.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList());
        List<OpportunityEntity> opportunityEntityList = this.listByIds(opportunityIdList);
        for (OpportunityDto opportunityDto : dtos) {
            for (OpportunityEntity opportunityEntity : opportunityEntityList) {
                if (!opportunityEntity.getOpportunityId().equals(opportunityDto.getOpportunityId())) continue;
                opportunityDto.setCustomerId(opportunityEntity.getCustomerId() != null ? String.valueOf(opportunityEntity.getCustomerId()) : null);
            }
        }
        for (OpportunityDto opportunityDto : dtos) {
            OpportunityEntity opportunityEntity = opportunityEntityList.stream().filter(object -> Objects.equals(object.getOpportunityId(), dto.getOpportunityId())).findFirst().get();
            if (!ToolUtil.isEmpty((Object)opportunityEntity.getChargePersonId())) continue;
            excludeOpportunityIdList.add(opportunityDto.getOpportunityId());
            ++undistributedNum;
        }
        for (Long l : excludeOpportunityIdList) {
            dtos = dtos.stream().filter(opportunity -> !opportunity.getOpportunityId().equals(l)).collect(Collectors.toList());
        }
        opportunityIdList = dtos.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList());
        excludeOpportunityIdList.clear();
        Map<Object, Object> operateFlagMap = new HashMap();
        if (ToolUtil.isNotEmpty(opportunityIdList)) {
            operateFlagMap = this.transferOperateByBatch(user, opportunityIdList, "opportunity_edit");
        }
        for (Map.Entry entry : operateFlagMap.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            excludeOpportunityIdList.add((Long)entry.getKey());
            ++noPermissionForOpportunityNum;
        }
        for (Long l : excludeOpportunityIdList) {
            dtos = dtos.stream().filter(opportunity -> !opportunity.getOpportunityId().equals(l)).collect(Collectors.toList());
        }
        opportunityIdList = dtos.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList());
        opportunityEntityList = ToolUtil.isNotEmpty(opportunityIdList) ? this.listByIds(opportunityIdList) : new ArrayList<OpportunityEntity>();
        ArrayList arrayList = new ArrayList();
        if (ToolUtil.isNotEmpty(opportunityEntityList)) {
            List<CustomerEntity> list = this.customerMapper.selectCustomerEntityList(opportunityEntityList);
        }
        excludeOpportunityIdList.clear();
        for (OpportunityEntity opportunity3 : opportunityEntityList) {
            Object customer2;
            Boolean customerOperate;
            void var21_30;
            Optional<CustomerEntity> optionalCustomer = var21_30.stream().filter(customer -> customer.getCustomerId().equals(opportunity3.getCustomerId())).findFirst();
            if (!optionalCustomer.isPresent() || (customerOperate = this.customerService.editCustomerOperate((CustomerEntity)(customer2 = optionalCustomer.get()), newChargePeron, "customer_edit")).booleanValue()) continue;
            excludeOpportunityIdList.add(opportunity3.getOpportunityId());
            ++noPermissionForCustomerNum;
        }
        for (Long excludeOpportunityId : excludeOpportunityIdList) {
            dtos = dtos.stream().filter(opportunity -> !opportunity.getOpportunityId().equals(excludeOpportunityId)).collect(Collectors.toList());
        }
        opportunityIdList = dtos.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList());
        opportunityEntityList = ToolUtil.isNotEmpty(opportunityIdList) ? this.listByIds(opportunityIdList) : new ArrayList();
        ArrayList<OpportunityDto> arrayList2 = new ArrayList<OpportunityDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        int alreadyChargePersonNum = 0;
        for (OpportunityDto dto : dtos) {
            Iterator opportunity4 = opportunityEntityList.stream().filter(object -> Objects.equals(object.getOpportunityId(), dto.getOpportunityId())).findFirst().get();
            String string = dto.getOldChargePersonName();
            String string2 = dto.getOldChargePersonId();
            String string3 = dto.getKeepFlag();
            if (newChargePersonId.equals(string2)) {
                ++alreadyChargePersonNum;
                continue;
            }
            String opportunityName = ((OpportunityEntity)((Object)opportunity4)).getOpportunityName();
            Long l = dto.getOpportunityId();
            date = LocalDateTime.now();
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setNewChargePersonId(newChargePersonId);
            dto.setOpportunityName(opportunityName);
            arrayList2.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(l);
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (arrayList2.size() + alreadyChargePersonNum == dtoSize) {
            resultVo.setTransferResult(true);
            msgList = new ArrayList<String>();
            msgList.add("\u8f6c\u79fb\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(false);
            if (dtoSize == 1) {
                msgList = new ArrayList();
                if (undistributedNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u5546\u673a\u672a\u5206\u914d");
                } else if (noPermissionForOpportunityNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u5546\u673a\u65e0\u6743\u9650");
                } else if (noPermissionForCustomerNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u63a5\u6536\u4eba\u65e0\u5ba2\u6237\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                String msg = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", arrayList2.size() + alreadyChargePersonNum, dtoSize - arrayList2.size() - alreadyChargePersonNum);
                if (noPermissionForOpportunityNum != 0) {
                    msg = msg + "\u5546\u673a\u65e0\u6743\u9650" + "\uff08" + noPermissionForOpportunityNum + "\u6761\uff09\uff1b";
                }
                if (noPermissionForCustomerNum != 0) {
                    msg = msg + "\u63a5\u6536\u4eba\u65e0\u5ba2\u6237\u6743\u9650" + "\uff08" + noPermissionForCustomerNum + "\u6761\uff09\uff1b";
                }
                if (undistributedNum != 0) {
                    msg = msg + "\u5546\u673a\u672a\u5206\u914d" + "\uff08" + undistributedNum + "\u6761\uff09\uff1b";
                }
                msg = msg.substring(0, msg.length() - 1);
                ArrayList<String> msgList2 = new ArrayList<String>();
                msgList2.add(msg);
                resultVo.setMsgList(msgList2);
            }
        }
        if (arrayList2.isEmpty()) {
            return resultVo;
        }
        this.opportunityMapper.updateChargePersonByBatch(arrayList2);
        if (ToolUtil.isNotEmpty(arrayList2)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList;
            String keepFlag = ((OpportunityDto)arrayList2.get(0)).getKeepFlag();
            if ("0".equals(keepFlag)) {
                teamMeberEntityList = new ArrayList<TeamMeberEntity>();
                for (OpportunityDto opportunityDto : arrayList2) {
                    TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                    teamMeberEntity.setBusinessId(opportunityDto.getOpportunityId());
                    teamMeberEntity.setDelFlag("1");
                    teamMeberEntity.setPersonId(Long.valueOf(opportunityDto.getOldChargePersonId()));
                    teamMeberEntityList.add(teamMeberEntity);
                }
                this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
            } else if ("1".equals(keepFlag)) {
                teamMeberEntityList = new ArrayList();
                for (OpportunityDto opportunityDto : arrayList2) {
                    TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                    teamMeberEntity.setBusinessId(opportunityDto.getOpportunityId());
                    teamMeberEntity.setPersonId(Long.valueOf(opportunityDto.getOldChargePersonId()));
                    teamMeberEntity.setIsCharge("0");
                    teamMeberEntity.setMemberRole("6");
                    teamMeberEntity.setModifyPower(null);
                    teamMeberEntityList.add(teamMeberEntity);
                }
                this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
            }
        }
        List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<OpportunityDto> insertMemberDtoList = new ArrayList<OpportunityDto>();
        ArrayList<OpportunityDto> updateChargeDtoList = new ArrayList<OpportunityDto>();
        for (OpportunityDto opportunityDto : arrayList2) {
            boolean bl = true;
            for (Map map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(opportunityDto.getOpportunityId())) continue;
                updateChargeDtoList.add(opportunityDto);
                bl = false;
                break;
            }
            if (!bl) continue;
            insertMemberDtoList.add(opportunityDto);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> arrayList3 = new ArrayList<TeamMeberEntity>();
            for (OpportunityDto opportunityDto : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(opportunityDto.getOpportunityId());
                teamMeberEntity.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity.setIsCharge("1");
                teamMeberEntity.setMemberRole(null);
                teamMeberEntity.setModifyPower("1");
                arrayList3.add(teamMeberEntity);
            }
            this.teamMeberMapper.updateIsChargeBatch(arrayList3);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.parseLong(newChargePersonId), insertMemberDtoList.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList()), "1", "1", ((OpportunityDto)insertMemberDtoList.get(0)).getChangeTime(), "2");
        }
        ArrayList<Long> arrayList4 = new ArrayList<Long>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        for (OpportunityDto dto : arrayList2) {
            arrayList4.add(Long.parseLong(dto.getOldChargePersonId()));
            arrayList5.add(dto.getOldChargePersonName());
        }
        this.addTrackRecordBatch(arrayList2, arrayList4, arrayList5, newChargePersonId, newChargePersonName);
        for (OpportunityDto dto : arrayList2) {
            Long l = dto.getOpportunityId();
            date = dto.getChangeTime();
            String opportunityName = dto.getOpportunityName();
            String oldChargePersonId = dto.getOldChargePersonId();
            String title = userName + "\u5c06\u5546\u673a\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8";
            String content = "\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", l.toString(), Arrays.asList(newChargePersonId));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + l + "\"";
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u5546\u673a\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8\uff0c\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, newChargePersonId, userName, unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
            String oldTitle = userName + "\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u5546\u673a";
            String oldContent = "\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushUtil.pushJqxArticleMessage(oldTitle, oldContent, "/crm/sj/sjxq/xxzl", l.toString(), Arrays.asList(oldChargePersonId));
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            String oldContentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + "\u5c06\u60a8\u8d1f\u8d23\u7684\u5546\u673a\u3010" + opportunityName + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage(oldAddSysMessageType, oldContentUnify, date, user, oldChargePersonId, userName, unifyWebUrl, "");
            UnifyUtil.sendMessage(oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("2");
            crmTeamAdminInfoDto.setBusinessId(l);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(dto.getOldChargePersonId());
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return resultVo;
    }

    private Map<Long, Boolean> transferOperateByBatch(SecurityUser user, List<Long> opportunityIdList, String opportunityEdit) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        List opportunityEntityList = this.listByIds(opportunityIdList);
        for (OpportunityEntity opportunity : opportunityEntityList) {
            if (!"5".equals(opportunity.getState())) continue;
            resultMap.put(opportunity.getOpportunityId(), false);
        }
        opportunityEntityList.removeIf(o -> resultMap.containsKey(o.getOpportunityId()));
        if (CollectionUtil.isNotEmpty((Collection)opportunityEntityList)) {
            Map<Long, Boolean> resultMap2 = this.editOperateByBatch(user, opportunityEntityList, opportunityEdit);
            resultMap.putAll(resultMap2);
        }
        return resultMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TransferBatchResultVo opportunityDistributeBatch(List<OpportunityDto> dtos) {
        ArrayList<String> msgList;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int alreadyDistributeNum = 0;
        int noCustomerPermissionNum = 0;
        int dtoSize = dtos.size();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getId();
        String userName = user.getUserName();
        String newChargePersonId = com.jxdinfo.crm.core.utills.CommonUtills.translateUserId(dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = com.jxdinfo.crm.core.utills.CommonUtills.selectDepIdName(newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        SecurityUser newChargePerson = this.commonMapper.selectSecurityByUserId(Long.valueOf(newChargePersonId));
        ArrayList<Long> excludeOpportunityIdList = new ArrayList<Long>();
        List opportunityIdList = dtos.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList());
        List<OpportunityEntity> opportunityEntityList = this.listByIds(opportunityIdList);
        for (OpportunityDto opportunityDto : dtos) {
            OpportunityEntity opportunityEntity = null;
            for (OpportunityEntity opportunity2 : opportunityEntityList) {
                if (!opportunity2.getOpportunityId().equals(opportunityDto.getOpportunityId())) continue;
                opportunityEntity = opportunity2;
                break;
            }
            if (!ToolUtil.isNotEmpty((Object)opportunityEntity.getChargePersonId())) continue;
            excludeOpportunityIdList.add(opportunityDto.getOpportunityId());
            ++alreadyDistributeNum;
        }
        for (Long l : excludeOpportunityIdList) {
            dtos = dtos.stream().filter(opportunity -> !opportunity.getOpportunityId().equals(l)).collect(Collectors.toList());
        }
        opportunityIdList = dtos.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList());
        excludeOpportunityIdList.clear();
        opportunityEntityList = ToolUtil.isNotEmpty(opportunityIdList) ? this.listByIds(opportunityIdList) : new ArrayList<OpportunityEntity>();
        List<Object> customerList = new ArrayList();
        if (ToolUtil.isNotEmpty(opportunityEntityList)) {
            customerList = this.customerMapper.selectCustomerEntityList(opportunityEntityList);
        }
        for (OpportunityEntity opportunity3 : opportunityEntityList) {
            CustomerEntity customer2;
            Boolean customerOperate;
            Optional<CustomerEntity> optionalCustomer = customerList.stream().filter(customer -> customer.getCustomerName().equals(opportunity3.getCustomerName())).findFirst();
            if (!optionalCustomer.isPresent() || (customerOperate = this.customerService.editCustomerOperate(customer2 = optionalCustomer.get(), newChargePerson, "customer_edit")).booleanValue()) continue;
            excludeOpportunityIdList.add(opportunity3.getOpportunityId());
            ++noCustomerPermissionNum;
        }
        for (Long excludeOpportunityId : excludeOpportunityIdList) {
            dtos = dtos.stream().filter(opportunity -> !opportunity.getOpportunityId().equals(excludeOpportunityId)).collect(Collectors.toList());
        }
        opportunityIdList = dtos.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList());
        excludeOpportunityIdList.clear();
        opportunityEntityList = ToolUtil.isNotEmpty(opportunityIdList) ? this.listByIds(opportunityIdList) : new ArrayList();
        ArrayList<OpportunityDto> arrayList = new ArrayList<OpportunityDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (OpportunityDto dto : dtos) {
            OpportunityEntity opportunity4 = opportunityEntityList.stream().filter(object -> Objects.equals(object.getOpportunityId(), dto.getOpportunityId())).findFirst().get();
            String keepFlag = dto.getKeepFlag();
            String opportunityName = opportunity4.getOpportunityName();
            Long opportunityId = opportunity4.getOpportunityId();
            dto.setChangeTime(date);
            dto.setChangePerson(userId.toString());
            dto.setChangePersonName(userName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setState("1");
            dto.setNewChargePersonId(newChargePersonId);
            dto.setAllocateTime(date);
            dto.setAllocatePerson(userId);
            dto.setAllocatePersonName(userName);
            arrayList.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(opportunityId);
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (arrayList.size() == dtoSize) {
            resultVo.setTransferResult(true);
            msgList = new ArrayList<String>();
            msgList.add("\u5206\u914d\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(false);
            if (dtoSize == 1) {
                msgList = new ArrayList();
                if (alreadyDistributeNum != 0) {
                    msgList.add("\u5206\u914d\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u5546\u673a\u5df2\u5206\u914d");
                } else if (noCustomerPermissionNum != 0) {
                    msgList.add("\u5206\u914d\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u63a5\u6536\u4eba\u65e0\u5ba2\u6237\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                String msg = String.format("\u5206\u914d\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", arrayList.size(), dtoSize - arrayList.size());
                if (alreadyDistributeNum != 0) {
                    msg = msg + "\u5546\u673a\u5df2\u5206\u914d" + "\uff08" + alreadyDistributeNum + "\u6761\uff09\uff1b";
                }
                if (noCustomerPermissionNum != 0) {
                    msg = msg + "\u63a5\u6536\u4eba\u65e0\u5ba2\u6237\u6743\u9650" + "\uff08" + noCustomerPermissionNum + "\u6761\uff09\uff1b";
                }
                msg = msg.substring(0, msg.length() - 1);
                ArrayList<String> msgList2 = new ArrayList<String>();
                msgList2.add(msg);
                resultVo.setMsgList(msgList2);
            }
        }
        if (arrayList.isEmpty()) {
            return resultVo;
        }
        this.opportunityMapper.updateOpportunityBatch(arrayList);
        List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<OpportunityDto> insertMemberDtoList = new ArrayList<OpportunityDto>();
        ArrayList<OpportunityDto> updateChargeDtoList = new ArrayList<OpportunityDto>();
        for (OpportunityDto dto : arrayList) {
            boolean flag = true;
            for (Map<String, Object> map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(dto.getOpportunityId())) continue;
                updateChargeDtoList.add(dto);
                flag = false;
                break;
            }
            if (!flag) continue;
            insertMemberDtoList.add(dto);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (OpportunityDto dto : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(dto.getOpportunityId());
                teamMeberEntity.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity.setIsCharge("1");
                teamMeberEntity.setMemberRole(null);
                teamMeberEntity.setModifyPower("1");
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.parseLong(newChargePersonId), insertMemberDtoList.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList()), "1", "1", ((OpportunityDto)insertMemberDtoList.get(0)).getChangeTime(), "2");
        }
        date = LocalDateTime.now();
        ArrayList<OperateRecordAPIVo> operateRecordDOS = new ArrayList<OperateRecordAPIVo>();
        for (OpportunityDto dto : arrayList) {
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(Long.valueOf(newChargePersonId));
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setDelflag("0");
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_DISTRIBUTE.getId());
            operateRecordDO.setRecordId(Long.valueOf(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
            operateRecordDO.setTypeId(dto.getOpportunityId());
            operateRecordDO.setBusinessName(dto.getOpportunityName());
            operateRecordDO.setCreatePerson(user.getUserId());
            operateRecordDO.setCreatePersonName(user.getUserName());
            operateRecordDO.setCreateTime(date);
            operateRecordDO.setChangePerson(user.getUserId());
            operateRecordDO.setChangeTime(date);
            operateRecordDO.setChangePersonName(user.getUserName());
            operateRecordDOS.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOS);
        opportunityIdList = arrayList.stream().map(OpportunityDto::getOpportunityId).collect(Collectors.toList());
        opportunityEntityList = ToolUtil.isNotEmpty(opportunityIdList) ? this.listByIds(opportunityIdList) : new ArrayList();
        for (OpportunityDto opportunityDto : arrayList) {
            OpportunityEntity opportunity5 = opportunityEntityList.stream().filter(object -> Objects.equals(object.getOpportunityId(), opportunityDto.getOpportunityId())).findFirst().get();
            Long opportunityId = opportunity5.getOpportunityId();
            String opportunityName = opportunity5.getOpportunityName();
            String title1 = userName + "\u5c06\u5546\u673a\u5206\u914d\u7ed9\u4f60";
            String content1 = opportunity5.getOpportunityName() + "\u3010" + opportunity5.getCustomerName() + "\u3011,\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
            EimPushUtil.pushJqxArticleMessage(title1, content1, "/crm/sj/sjxq/xxzl", opportunityId.toString(), Arrays.asList(newChargePersonId));
            AddSysMessageType addSysMessageType1 = new AddSysMessageType();
            String unifyWebUrl1 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity5.getOpportunityId() + "\"";
            String contentUnify = "\u3010\u5206\u914d\u63d0\u9192\u3011" + userName + " \u5c06\u5546\u673a/\u7ebf\u7d22\u5206\u914d\u7ed9\u4f60\uff0c\u5546\u673a/\u7ebf\u7d22\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage(addSysMessageType1, contentUnify, date, user, newChargePersonId, userName, unifyWebUrl1, "");
            UnifyUtil.sendMessage(addSysMessageType1);
            List<String> createRole = this.commonService.getRoleNameByUser_Id(opportunity5.getCreatePerson());
            String title2 = userName + "\u5c06\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u5206\u914d";
            String content2 = "\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u3010" + opportunity5.getOpportunityName() + "\u3011\u5df2\u5206\u914d\u81f3" + newOwnDepartmentName + "\u7684" + opportunityDto.getNewChargePersonName() + "\u8fdb\u884c\u8ddf\u8fdb";
            EimPushUtil.pushJqxArticleMessage(title2, content2, "/crm/sj/sjxq/xxzl", opportunityId.toString(), Arrays.asList(String.valueOf(opportunity5.getCreatePerson())));
            AddSysMessageType addSysMessageType2 = new AddSysMessageType();
            String unifyWebUrl2 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity5.getOpportunityId() + "\"";
            UnifyUtil.defaultMessage(addSysMessageType2, content2, date, user, String.valueOf(opportunity5.getCreatePerson()), userName, unifyWebUrl2, "");
            UnifyUtil.sendMessage(addSysMessageType2);
        }
        return resultVo;
    }

    @Override
    public Map<Long, Boolean> editOperateByBatch(SecurityUser user, List<OpportunityEntity> opportunityEntityList, String resourcePath) {
        List<Long> opportunityIdList = opportunityEntityList.stream().map(OpportunityEntity::getOpportunityId).collect(Collectors.toList());
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        PermissionDto opportunityPermissionDto = this.opportunityDataRightModuleService.getUserRolePermission(user);
        PermissionDto campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        List<Long> operateOpportunityIdList = this.opportunityMapper.selectOpportunityIdOperate(opportunityPermissionDto, campaignPermissionDto, opportunityIdList);
        opportunityIdList.forEach(id -> resultMap.put((Long)id, false));
        opportunityIdList.retainAll(operateOpportunityIdList);
        if (CollectionUtil.isEmpty(opportunityIdList)) {
            return resultMap;
        }
        List<Long> opportunityIdTempList = this.teamMeberMapper.selectProductTeamMemberIdByOpportunityIdList(opportunityIdList, user.getUserId());
        HashSet<Long> opportunityIdTempSet = new HashSet<Long>(opportunityIdTempList);
        opportunityIdList.removeIf(opportunityId -> {
            if (opportunityIdTempSet.contains(opportunityId)) {
                resultMap.put((Long)opportunityId, true);
                return true;
            }
            return false;
        });
        if (CollectionUtil.isEmpty(opportunityIdList)) {
            return resultMap;
        }
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getBusinessId, opportunityIdList)).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"2"));
        HashSet existingOpportunityIds = new HashSet();
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            teamList.forEach(team -> {
                existingOpportunityIds.add(team.getBusinessId());
                resultMap.put(team.getBusinessId(), "1".equals(team.getModifyPower()));
            });
            opportunityIdList.removeAll(existingOpportunityIds);
        }
        if (!opportunityIdList.isEmpty()) {
            List elementResourceVos = this.hussarBaseResourceAdapter.elementResources("/crm/sj/shangjiguanli", user.getRolesList());
            Set<Object> resourceSet = new HashSet();
            if (CollectionUtil.isNotEmpty((Collection)elementResourceVos) && ((ElementResourceVo)elementResourceVos.get(0)).getPermission() != null) {
                resourceSet = Arrays.stream(((ElementResourceVo)elementResourceVos.get(0)).getPermission().split(",")).collect(Collectors.toSet());
            }
            for (Long opportunityId2 : opportunityIdList) {
                try {
                    if (resourceSet.contains(resourcePath)) {
                        resultMap.put(opportunityId2, true);
                        continue;
                    }
                    resultMap.put(opportunityId2, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    resultMap.put(opportunityId2, false);
                }
            }
        }
        return resultMap;
    }

    @Override
    public void addTrackRecordBatch(List<OpportunityDto> dtoList, List<Long> oldContactPersonIdList, List<String> oldContactPersonNameList, String newChargePersonId, String newChargePersonName) {
        ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (int i = 0; i < dtoList.size(); ++i) {
            OpportunityDto dto = dtoList.get(i);
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(Long.valueOf(Long.parseLong(newChargePersonId)));
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            if (HussarUtils.isNotEmpty((Object)oldContactPersonIdList.get(i))) {
                operateRecordDO.setOldContactId(oldContactPersonIdList.get(i));
            }
            operateRecordDO.setOldContactName(oldContactPersonNameList.get(i));
            operateRecordDO.setRecordId(Long.valueOf(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
            operateRecordDO.setTypeId(dto.getOpportunityId());
            operateRecordDO.setBusinessName(dto.getOpportunityName());
            operateRecordDO.setCreatePerson(user.getUserId());
            operateRecordDO.setCreatePersonName(user.getUserName());
            operateRecordDO.setCreateTime(date);
            operateRecordDO.setChangePerson(user.getUserId());
            operateRecordDO.setChangeTime(date);
            operateRecordDO.setChangePersonName(user.getUserName());
            operateRecordDO.setDelflag("0");
            if (operateRecordDO.getProduceType() == null) {
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            operateRecordDOList.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
    }

    @Override
    public ApiResponse<String> opportunityChangeDeptBatch(DeptChangeBatchDto dto) {
        if (HussarUtils.isNotEmpty((Object)dto.getOwnDepartment()) && CollectionUtil.isNotEmpty(dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List opportunityEntityList = this.list((Wrapper)new LambdaQueryWrapper().in(OpportunityEntity::getOpportunityId, dto.getObjectIdList()));
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            String newOwnDeptName = dto.getOwnDepartmentName();
            Long newOwnDeptId = dto.getOwnDepartment();
            boolean changeFlag = false;
            for (OpportunityEntity opportunityEntity : opportunityEntityList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                ArrayList changeField = new ArrayList();
                if (dto.getOwnDepartmentName().equals(opportunityEntity.getOwnDepartmentName())) continue;
                String oldOwnDeptName = opportunityEntity.getOwnDepartmentName();
                Long oldOwnDeptId = opportunityEntity.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = opportunityEntity.getOpportunityName();
                typeEnum = CrmBusinessTypeEnum.OPPORTUNITY;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                operateRecordDO.setChangeBefore(oldJson);
                operateRecordDO.setChangeAfter(newJson);
                operateRecordDO.setChangeField(changeFieldStr);
                operateRecordDO.setRecordId(Long.valueOf(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(opportunityEntity.getOpportunityId());
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                operateRecordDOList.add(operateRecordDO);
            }
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(OpportunityEntity::getOpportunityId, dto.getObjectIdList())).set(OpportunityEntity::getOwnDepartment, (Object)dto.getOwnDepartment())).set(OpportunityEntity::getOwnDepartmentName, (Object)dto.getOwnDepartmentName())).set(OpportunityEntity::getChangeTime, (Object)date)).set(OpportunityEntity::getChangePerson, (Object)user.getUserId())).set(OpportunityEntity::getChangePersonName, (Object)user.getUserName()));
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }

    @Override
    public ApiResponse<Page<OpportunityEntity>> selectOpportunityListByAgentId(OpportunityDto dto) {
        Object page = dto.getPage();
        page = this.opportunityMapper.selectOpportunityListByAgentId((Page<OpportunityEntity>)page, dto);
        return ApiResponse.success(page);
    }

    @Override
    public ApiResponse<Map<String, Object>> checkRecordContact(OpportunityDto dto) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (HussarUtils.isEmpty((Object)dto.getContactId())) {
            return null;
        }
        long count = this.contactCharacterService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactCharacterEntity::getContactId, (Object)dto.getContactId())).eq(ContactCharacterEntity::getOpportunityId, (Object)dto.getOpportunityId())).eq(ContactCharacterEntity::getDelFlag, (Object)"0"));
        if (count == 0L) {
            resultMap.put("result", true);
        } else {
            resultMap.put("result", false);
            ContactEntity contactEntity = (ContactEntity)this.contactService.getById((Serializable)((Object)dto.getContactId()));
            resultMap.put("contact", contactEntity);
        }
        return ApiResponse.success(resultMap);
    }

    public Boolean isOpportunityUnaudited(String opportunityId) {
        OpportunityProcessStateVo opportunityProcessStateVo = this.opportunityMapper.selectOpportunityProcessNode(opportunityId);
        return ToolUtil.isNotEmpty((Object)opportunityProcessStateVo) && opportunityProcessStateVo.getProcessNodeKey().equals("hussar_2");
    }

    @Override
    public Map<String, Object> isOperateProcessState(Long opportunityId) {
        List todoList;
        OpportunityEntity opportunityEntity = (OpportunityEntity)this.getById(opportunityId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ProcessDto dto = new ProcessDto();
        dto.setBusinessId(opportunityId.toString());
        BpmResponseResult result = this.instanceEngineApiService.queryProcessInstance(dto);
        for (int i = 0; i < result.getResult().size(); ++i) {
            map = new HashMap();
            JSONObject jsonObject = result.getResult().getJSONObject(i);
            for (String key : jsonObject.keySet()) {
                map.put(key, jsonObject.get((Object)key));
            }
            if ("opportunity_reporting".equals((String)map.get("processKey"))) break;
        }
        if (ToolUtil.isNotEmpty((Object)(todoList = (List)map.get("todo")))) {
            Map map1 = (Map)todoList.get(0);
            resultMap.put("taskId", map1.get("taskId"));
            resultMap.put("taskDefinitionKey", map1.get("taskDefinitionKey"));
        }
        resultMap.put("permission", CommonConstant.PROCESS_NO_PERMISSION);
        if (ToolUtil.isEmpty((Object)opportunityEntity.getProcessState()) || "1".equals(opportunityEntity.getProcessState())) {
            resultMap.put("permission", CommonConstant.PROCESS_PERMISSION);
        } else if ("0".equals(opportunityEntity.getProcessState())) {
            SecurityUser user = BaseSecurityUtil.getUser();
            if (this.isOpportunityUnaudited(opportunityId.toString()).booleanValue() && user.getUserId().toString().equals(opportunityEntity.getCreatePerson() == null ? "" : opportunityEntity.getCreatePerson().toString())) {
                resultMap.put("permission", CommonConstant.PROCESS_PERMISSION);
            } else {
                resultMap.put("permission", CommonConstant.PROCESS_NO_PERMISSION);
            }
        }
        return resultMap;
    }

    @Override
    public String updateLastTrackPerson() {
        List trackRecordList = this.trackRecordAPIService.getTrackRecordDetailsBatch(null, CrmBusinessTypeEnum.OPPORTUNITY.getId());
        if (CollectionUtil.isNotEmpty((Collection)trackRecordList)) {
            Map<Long, List<TrackRecordAPIVo>> tranckRecordListMap = trackRecordList.stream().collect(Collectors.groupingBy(TrackRecordAPIVo::getTypeId));
            ArrayList<OpportunityEntity> opportunityEntityList = new ArrayList<OpportunityEntity>();
            for (Long opportunityId : tranckRecordListMap.keySet()) {
                List<TrackRecordAPIVo> trackRecords = tranckRecordListMap.get(opportunityId);
                if (!CollectionUtil.isNotEmpty(trackRecords)) continue;
                OpportunityEntity opportunityEntity = new OpportunityEntity();
                opportunityEntity.setOpportunityId(opportunityId);
                trackRecords.sort(Comparator.comparing(TrackRecordAPIVo::getCreateTime).reversed());
                opportunityEntity.setTrackPerson(trackRecords.get(0).getCreatePerson());
                opportunityEntity.setTrackPersonName(trackRecords.get(0).getCreatePersonName());
                opportunityEntityList.add(opportunityEntity);
            }
            this.updateBatchById(opportunityEntityList);
        }
        return "\u66f4\u65b0\u5b8c\u6210";
    }

    @Override
    public Page<OpportunityAPIVo> selectList(OpportunityQueryDto opportunityQueryDto) {
        Page opportunityEntityPage = new Page();
        opportunityEntityPage.setPages(opportunityQueryDto.getPages());
        opportunityQueryDto.setSearchKey(CommonUtills.escapeLike((String)opportunityQueryDto.getSearchKey()));
        List<OpportunityEntity> opportunityEntityList = this.opportunityMapper.selectOpportunityForStageAnalysis((Page<OpportunityEntity>)opportunityEntityPage, opportunityQueryDto);
        Page page = new Page();
        ArrayList<OpportunityAPIVo> opportunityAPIVoList = new ArrayList<OpportunityAPIVo>();
        if (CollectionUtil.isNotEmpty(opportunityEntityList)) {
            for (OpportunityEntity opportunityEntity : opportunityEntityList) {
                OpportunityAPIVo opportunityAPIVo = new OpportunityAPIVo();
                BeanUtil.copyProperties((Object)opportunityEntity, (Object)opportunityAPIVo);
                opportunityAPIVo.setOpportunityAmount(CommonUtills.transferAmount((String)opportunityAPIVo.getOpportunityAmount()));
                opportunityAPIVoList.add(opportunityAPIVo);
            }
        }
        page.setRecords(opportunityAPIVoList);
        page.setTotal(opportunityQueryDto.getTotal());
        return page;
    }

    @Override
    public ApiResponse<String> opportunityChangeDeptByChargePersonBatch(DeptChangeBatchDto dto) {
        if (CollectionUtil.isNotEmpty(dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List opportunityEntityList = this.list((Wrapper)new LambdaQueryWrapper().in(OpportunityEntity::getOpportunityId, dto.getObjectIdList()));
            for (OpportunityEntity opportunityEntity : opportunityEntityList) {
                if (!ToolUtil.isEmpty((Object)opportunityEntity.getChargePersonId())) continue;
                throw new HussarException("\u5546\u673a\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff01");
            }
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            List<Map<String, Object>> userInfoList = this.commonMapper.getDeptInfosByUserIdList(opportunityEntityList.stream().map(OpportunityEntity::getChargePersonId).collect(Collectors.toList()));
            boolean changeFlag = false;
            for (OpportunityEntity opportunityEntity : opportunityEntityList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                ArrayList changeField = new ArrayList();
                Map userMap = (Map)userInfoList.stream().filter(map -> map.get("USER_ID").equals(opportunityEntity.getChargePersonId())).collect(Collectors.toList()).get(0);
                Long newOwnDeptId = (Long)userMap.get("DEPARTMENT_ID");
                String newOwnDeptName = (String)userMap.get("ORGAN_ALIAS");
                if (newOwnDeptName.equals(opportunityEntity.getOwnDepartmentName())) continue;
                String oldOwnDeptName = opportunityEntity.getOwnDepartmentName();
                Long oldOwnDeptId = opportunityEntity.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = opportunityEntity.getOpportunityName();
                typeEnum = CrmBusinessTypeEnum.OPPORTUNITY;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                operateRecordDO.setChangeBefore(oldJson);
                operateRecordDO.setChangeAfter(newJson);
                operateRecordDO.setChangeField(changeFieldStr);
                operateRecordDO.setRecordId(Long.valueOf(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(opportunityEntity.getOpportunityId());
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                operateRecordDOList.add(operateRecordDO);
                opportunityEntity.setOwnDepartment(newOwnDeptId);
                opportunityEntity.setOwnDepartmentName(newOwnDeptName);
                opportunityEntity.setChangeTime(date);
                opportunityEntity.setChangePerson(user.getUserId());
                opportunityEntity.setChangePersonName(user.getUserName());
            }
            this.updateBatchById(opportunityEntityList);
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }

    @Override
    @Transactional
    public String opportunityPend(OpportunityDto dto) {
        List collect;
        List<String> ids = dto.getOpportunityIds();
        String pendReason = dto.getPendReason();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty(ids)) {
            return "\u8bf7\u9009\u62e9\u8981\u6302\u8d77\u7684\u5546\u673a";
        }
        List opportunityEntityList = this.listByIds(ids);
        CrmBaseConfigVo opportunityPend = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey("opportunity_pend");
        StringBuilder sb = new StringBuilder();
        List<String> splitStates = Arrays.asList(opportunityPend.getConfigValue().split(","));
        if (!new HashSet<String>(splitStates).containsAll(collect = opportunityEntityList.stream().map(OpportunityEntity::getState).collect(Collectors.toList()))) {
            for (String state : splitStates) {
                sb.append(this.sysDicRefService.getDictLabel("leads_state", state));
                if (state.equals(splitStates.get(splitStates.size() - 1))) continue;
                sb.append("\u3001");
            }
            return String.format("\u6302\u8d77\u5931\u8d25\uff1b\u5931\u8d25\u539f\u56e0\uff1a\u53ea\u6709%s\u72b6\u6001\u53ef\u4ee5\u6302\u8d77", sb);
        }
        opportunityEntityList.forEach(opportunityEntity -> {
            opportunityEntity.setPendReason(pendReason);
            opportunityEntity.setState("14");
        });
        if (this.saveOrUpdateBatch(opportunityEntityList)) {
            ArrayList<OperateRecordAPIVo> operateRecordAPIVoList = new ArrayList<OperateRecordAPIVo>();
            CrmBusinessTypeEnum typeEnum = CrmBusinessTypeEnum.OPPORTUNITY;
            for (OpportunityEntity opportunityEntity2 : opportunityEntityList) {
                OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
                operateRecordAPIVo.setRecordContent(dto.getPendReason());
                operateRecordAPIVo.setProduceType(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_PENDING.getId());
                operateRecordAPIVo.setRecordId(Long.valueOf(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId()));
                operateRecordAPIVo.setBusinessType(typeEnum.getId());
                operateRecordAPIVo.setTypeId(opportunityEntity2.getOpportunityId());
                operateRecordAPIVo.setBusinessName(opportunityEntity2.getOpportunityName());
                operateRecordAPIVo.setCreatePerson(user.getUserId());
                operateRecordAPIVo.setCreatePersonName(user.getUserName());
                operateRecordAPIVo.setCreateTime(date);
                operateRecordAPIVo.setChangePerson(user.getUserId());
                operateRecordAPIVo.setChangeTime(date);
                operateRecordAPIVo.setChangePersonName(user.getUserName());
                operateRecordAPIVo.setDelflag("0");
                if (opportunityEntityList.size() > 1) {
                    operateRecordAPIVo.setChangeBatch(1);
                } else {
                    operateRecordAPIVo.setChangeBatch(0);
                }
                operateRecordAPIVoList.add(operateRecordAPIVo);
            }
            this.operateRecordAPIService.saveOperateLogBatch(operateRecordAPIVoList);
            return "\u6302\u8d77\u6210\u529f";
        }
        return "\u6302\u8d77\u5931\u8d25";
    }

    @Override
    @Transactional
    public String opportunityActivate(OpportunityDto dto) {
        List<String> ids = dto.getOpportunityIds();
        String pendReason = dto.getPendReason();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty(ids)) {
            return "\u8bf7\u9009\u62e9\u8981\u6fc0\u6d3b\u7684\u5546\u673a";
        }
        List opportunityEntityList = this.listByIds(ids);
        if (opportunityEntityList.stream().anyMatch(opportunityEntity -> !"14".equals(opportunityEntity.getState()))) {
            return "\u8bf7\u6fc0\u6d3b\u5df2\u6302\u8d77\u7684\u5546\u673a";
        }
        List stageOppoyIds = this.stageRecordService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"OPPORTUNITY_ID", ids)).eq((Object)"DEL_FLAG", (Object)"0")).stream().map(StageRecord::getOpportunityId).distinct().collect(Collectors.toList());
        List longIds = ids.stream().map(Long::parseLong).collect(Collectors.toList());
        List trackRecordIds = this.trackRecordAPIService.getTrackRecordDetailsBatch(longIds, CrmBusinessTypeEnum.OPPORTUNITY.getId()).stream().map(TrackRecordAPIVo::getTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageLose(true);
        stageTypeDto.setStageAbandon(true);
        stageTypeDto.setStageConvert(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List stageWin = stageSelectDto.getStageWin().stream().map(String::valueOf).collect(Collectors.toList());
        List stageLose = stageSelectDto.getStageLose().stream().map(String::valueOf).collect(Collectors.toList());
        List stageAbandon = stageSelectDto.getStageAbandon().stream().map(String::valueOf).collect(Collectors.toList());
        List stageConvert = stageSelectDto.getStageConvert().stream().map(String::valueOf).collect(Collectors.toList());
        for (OpportunityEntity opportunityEntity2 : opportunityEntityList) {
            if (stageWin.contains(opportunityEntity2.getCustomerStageId())) {
                opportunityEntity2.setState("8");
                continue;
            }
            if (stageLose.contains(opportunityEntity2.getCustomerStageId())) {
                opportunityEntity2.setState("9");
                continue;
            }
            if (stageAbandon.contains(opportunityEntity2.getCustomerStageId())) {
                opportunityEntity2.setState("6");
                continue;
            }
            if (stageConvert.contains(opportunityEntity2.getCustomerStageId())) {
                opportunityEntity2.setState("7");
                continue;
            }
            if (stageOppoyIds.contains(opportunityEntity2.getOpportunityId()) || trackRecordIds.contains(opportunityEntity2.getOpportunityId())) {
                opportunityEntity2.setState("2");
                continue;
            }
            opportunityEntity2.setState("1");
        }
        if (this.saveOrUpdateBatch(opportunityEntityList)) {
            ArrayList<OperateRecordAPIVo> operateRecordAPIVoList = new ArrayList<OperateRecordAPIVo>();
            CrmBusinessTypeEnum typeEnum = CrmBusinessTypeEnum.OPPORTUNITY;
            for (OpportunityEntity opportunityEntity3 : opportunityEntityList) {
                OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
                operateRecordAPIVo.setRecordContent(dto.getPendReason());
                operateRecordAPIVo.setProduceType(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_ACTIVATE.getId());
                operateRecordAPIVo.setRecordId(Long.valueOf(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId()));
                operateRecordAPIVo.setBusinessType(typeEnum.getId());
                operateRecordAPIVo.setTypeId(opportunityEntity3.getOpportunityId());
                operateRecordAPIVo.setBusinessName(opportunityEntity3.getOpportunityName());
                operateRecordAPIVo.setCreatePerson(user.getUserId());
                operateRecordAPIVo.setCreatePersonName(user.getUserName());
                operateRecordAPIVo.setCreateTime(date);
                operateRecordAPIVo.setChangePerson(user.getUserId());
                operateRecordAPIVo.setChangeTime(date);
                operateRecordAPIVo.setChangePersonName(user.getUserName());
                operateRecordAPIVo.setDelflag("0");
                if (opportunityEntityList.size() > 1) {
                    operateRecordAPIVo.setChangeBatch(1);
                } else {
                    operateRecordAPIVo.setChangeBatch(0);
                }
                operateRecordAPIVoList.add(operateRecordAPIVo);
            }
            this.operateRecordAPIService.saveOperateLogBatch(operateRecordAPIVoList);
            return "\u6fc0\u6d3b\u6210\u529f";
        }
        return "\u6fc0\u6d3b\u5931\u8d25";
    }

    @Override
    public String changeOpportunityStageCheck(OpportunityEntity opportunity, Long stageId) {
        boolean noAnalysisCheck;
        StageVo afterStage = null;
        Long processId = opportunity.getStageProcessId();
        StageVo beforeStage = null;
        StageProcessVo stageProcess = this.stageProcessMapper.selectStageProcessDetail(processId);
        List<StageVo> stageVos = stageProcess.getStageList();
        for (StageVo vo : stageVos) {
            if (vo.getCustomerStageId().equals(stageId)) {
                afterStage = vo;
            }
            if (!vo.getCustomerStageId().equals(Long.valueOf(opportunity.getCustomerStageId()))) continue;
            beforeStage = vo;
        }
        if (afterStage == null || beforeStage == null) {
            return "\u9636\u6bb5\u9009\u62e9\u9519\u8bef";
        }
        if (afterStage.getCustomerStageId().equals(beforeStage.getCustomerStageId())) {
            return "\u8be5\u5546\u673a\u5df2\u5904\u4e8e\u3010" + afterStage.getCustomerStageName() + "\u3011\u9636\u6bb5";
        }
        ArrayList<Long> checkFieldIds = new ArrayList<Long>();
        HashSet<String> checkDataList = new HashSet<String>();
        ArrayList<Long> otherTaskId = new ArrayList<Long>();
        ArrayList<StageVo> stagePassed = new ArrayList<StageVo>();
        boolean noProductCheck = "2".equals(opportunity.getOpopportunityType()) || "3".equals(opportunity.getOpopportunityType());
        boolean bl = noAnalysisCheck = "2".equals(opportunity.getOpopportunityType()) || "3".equals(opportunity.getOpopportunityType());
        if (afterStage.getStageType().charAt(0) == '2') {
            String result = "\u8be5\u9636\u6bb5\u65e0\u6cd5\u63a8\u8fdb\u5230\u7ed3\u675f\u9636\u6bb5";
            List crossingList = this.stageCrossingService.list((Wrapper)new LambdaQueryWrapper().eq(StageCrossingEntity::getStageId, (Object)beforeStage.getCustomerStageId()));
            if (CollectionUtil.isEmpty((Collection)crossingList)) {
                return result;
            }
            String mustComplete = "";
            for (StageCrossingEntity entity : crossingList) {
                if (!afterStage.getStageType().equals(entity.getStageType())) continue;
                result = "0";
                mustComplete = entity.getMustComplete();
                break;
            }
            if (!"0".equals(result)) {
                return result;
            }
            if ("1".equals(mustComplete)) {
                for (StageKeyTaskVo taskVo : beforeStage.getTaskList()) {
                    if ("0".equals(taskVo.getTaskType()) && "0".equals(taskVo.getCheckTime())) {
                        for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                            if (!"1".equals(detail.getRequired())) continue;
                            checkFieldIds.add(detail.getFieldId());
                        }
                    }
                    if ("1".equals(taskVo.getTaskType()) && "0".equals(taskVo.getCheckTime())) {
                        for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                            if (noProductCheck && detail.getFieldId() == 4L || noAnalysisCheck && detail.getFieldId() == 5L || !"1".equals(detail.getRequired())) continue;
                            checkDataList.add(detail.getFieldId().toString());
                        }
                    }
                    if (!"2".equals(taskVo.getTaskType()) || !"0".equals(taskVo.getCheckTime())) continue;
                    for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                        if (!"1".equals(detail.getRequired())) continue;
                        otherTaskId.add(detail.getTaskDetailId());
                    }
                }
            }
            for (StageKeyTaskVo taskVo : afterStage.getTaskList()) {
                if ("0".equals(taskVo.getTaskType()) && "1".equals(taskVo.getCheckTime())) {
                    for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                        if (!"1".equals(detail.getRequired())) continue;
                        checkFieldIds.add(detail.getFieldId());
                    }
                }
                if ("1".equals(taskVo.getTaskType()) && "1".equals(taskVo.getCheckTime())) {
                    for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                        if (noProductCheck && detail.getFieldId() == 4L || noAnalysisCheck && detail.getFieldId() == 5L || !"1".equals(detail.getRequired())) continue;
                        checkDataList.add(detail.getFieldId().toString());
                    }
                }
                if (!"2".equals(taskVo.getTaskType()) || !"1".equals(taskVo.getCheckTime())) continue;
                for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                    if (!"1".equals(detail.getRequired())) continue;
                    otherTaskId.add(detail.getTaskDetailId());
                }
            }
            String checkResult = this.stageProcessService.checkField(CrmBusinessTypeEnum.OPPORTUNITY.getId(), opportunity, checkFieldIds);
            if (!"0".equals(checkResult)) {
                return checkResult;
            }
            String checkDataResult = this.stageProcessService.checkOpportunityData(opportunity, new ArrayList<String>(checkDataList));
            if (!"0".equals(checkDataResult)) {
                return checkDataResult;
            }
            String checkOtherTaskResult = this.stageProcessService.checkOpportunityOtherTask(opportunity.getOpportunityId(), otherTaskId);
            if (!"0".equals(checkOtherTaskResult)) {
                return checkOtherTaskResult;
            }
            return "0";
        }
        if (Integer.parseInt(afterStage.getOrderNumber()) > Integer.parseInt(beforeStage.getOrderNumber())) {
            for (StageVo vo : stageVos) {
                if (Long.parseLong(vo.getOrderNumber()) < Long.parseLong(beforeStage.getOrderNumber()) || Long.parseLong(vo.getOrderNumber()) >= Long.parseLong(afterStage.getOrderNumber()) || vo.getStageType().charAt(0) == '2' && Long.parseLong(vo.getOrderNumber()) != Long.parseLong(afterStage.getOrderNumber())) continue;
                stagePassed.add(vo);
            }
        } else {
            if ("1".equals(beforeStage.getBackable())) {
                return "0";
            }
            List roleList = this.sysRoleResourceService.getResourceRoles(OpportunityConstant.STAGE_BACK_RESOURCE);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (CollectionUtil.isNotEmpty((Collection)user.getRolesList())) {
                for (SysRoleResource roleResource : roleList) {
                    for (Long role : user.getRolesList()) {
                        if (!roleResource.getRoleId().equals(role)) continue;
                        return "0";
                    }
                }
            }
            return "\u8be5\u9636\u6bb5\u65e0\u6cd5\u56de\u9000";
        }
        for (StageKeyTaskVo taskVo : afterStage.getTaskList()) {
            if ("0".equals(taskVo.getTaskType()) && "1".equals(taskVo.getCheckTime())) {
                for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                    if (!"1".equals(detail.getRequired())) continue;
                    checkFieldIds.add(detail.getFieldId());
                }
            }
            if ("1".equals(taskVo.getTaskType()) && "1".equals(taskVo.getCheckTime())) {
                for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                    if (noProductCheck && detail.getFieldId() == 4L || noAnalysisCheck && detail.getFieldId() == 5L || !"1".equals(detail.getRequired())) continue;
                    checkDataList.add(detail.getFieldId().toString());
                }
            }
            if (!"2".equals(taskVo.getTaskType()) || !"1".equals(taskVo.getCheckTime())) continue;
            for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                if (!"1".equals(detail.getRequired())) continue;
                otherTaskId.add(detail.getTaskDetailId());
            }
        }
        for (StageVo stageVo : stagePassed) {
            for (StageKeyTaskVo taskVo : stageVo.getTaskList()) {
                if ("0".equals(taskVo.getTaskType()) && "0".equals(taskVo.getCheckTime())) {
                    for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                        if (!"1".equals(detail.getRequired())) continue;
                        checkFieldIds.add(detail.getFieldId());
                    }
                }
                if ("1".equals(taskVo.getTaskType()) && "0".equals(taskVo.getCheckTime())) {
                    for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                        if (noProductCheck && detail.getFieldId() == 4L || noAnalysisCheck && detail.getFieldId() == 5L || !"1".equals(detail.getRequired())) continue;
                        checkDataList.add(detail.getFieldId().toString());
                    }
                }
                if (!"2".equals(taskVo.getTaskType()) || !"0".equals(taskVo.getCheckTime())) continue;
                for (StageTaskDetailVo detail : taskVo.getTaskDetailList()) {
                    if (!"1".equals(detail.getRequired())) continue;
                    otherTaskId.add(detail.getTaskDetailId());
                }
            }
        }
        String checkResult = this.stageProcessService.checkField(CrmBusinessTypeEnum.OPPORTUNITY.getId(), opportunity, checkFieldIds);
        if (!"0".equals(checkResult)) {
            return checkResult;
        }
        String checkDataResult = this.stageProcessService.checkOpportunityData(opportunity, new ArrayList<String>(checkDataList));
        if (!"0".equals(checkDataResult)) {
            return checkDataResult;
        }
        String checkOtherTaskResult = this.stageProcessService.checkOpportunityOtherTask(opportunity.getOpportunityId(), otherTaskId);
        if (!"0".equals(checkOtherTaskResult)) {
            return checkOtherTaskResult;
        }
        return "0";
    }

    @Override
    @Transactional
    public ApiResponse<String> changeOpportunityStage(ChangeOpportunityStageDto dto) {
        String contentUnify;
        Object unifyWebUrl;
        if (CollectionUtil.isNotEmpty(dto.getParamMap())) {
            this.editOpportunity(dto.getParamMap());
        }
        Long opportunityId = dto.getOpportunityId();
        Long stageId = dto.getStageId();
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById(opportunityId);
        String checkRes = this.changeOpportunityStageCheck(opportunity, stageId);
        if (!"0".equals(checkRes)) {
            throw new HussarException(checkRes);
        }
        opportunity.setCustomerStageId(String.valueOf(stageId));
        OpportunityUtil.handleDateField(opportunity);
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        String deptName = user.getDeptName();
        Object launchDate = null;
        opportunity.setChangePerson(userId);
        opportunity.setChangePersonName(userName);
        opportunity.setChangeTime(date);
        OpportunityEntity oldOpportunity = (OpportunityEntity)this.getById(opportunity.getOpportunityId());
        String oldStageId = oldOpportunity.getCustomerStageId();
        String newStageId = opportunity.getCustomerStageId();
        List oldNewStage = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getCustomerStageId, (Object)oldStageId)).or()).eq(OpportunityStage::getCustomerStageId, (Object)newStageId));
        OpportunityStage oldOpportunityStage = new OpportunityStage();
        OpportunityStage newOpportunityStage = new OpportunityStage();
        for (OpportunityStage opportunityStage : oldNewStage) {
            if (Long.valueOf(oldStageId).equals(opportunityStage.getCustomerStageId())) {
                oldOpportunityStage = opportunityStage;
            }
            if (!Long.valueOf(newStageId).equals(opportunityStage.getCustomerStageId())) continue;
            newOpportunityStage = opportunityStage;
        }
        opportunity.setState("2");
        opportunity.setSuccessDate(null);
        opportunity.setLoseDate(null);
        if ("22".equals(newOpportunityStage.getStageType())) {
            opportunity.setState("6");
        } else if ("23".equals(newOpportunityStage.getStageType())) {
            opportunity.setState("7");
        }
        String oldStageName = oldOpportunityStage.getCustomerStageName();
        String newStageName = newOpportunityStage.getCustomerStageName();
        if (newOpportunityStage.getStageType().charAt(0) == '2') {
            opportunity.setStageFinishTime(date);
        } else {
            opportunity.setStageFinishTime(null);
        }
        DecimalFormat df = new DecimalFormat("#,##0.00");
        df.setRoundingMode(RoundingMode.HALF_UP);
        if (ToolUtil.isEmpty((Object)opportunity.getOpportunityAmount())) {
            opportunity.setOpportunityAmount("0");
        }
        if (ToolUtil.isEmpty((Object)oldOpportunity.getOpportunityAmount())) {
            oldOpportunity.setOpportunityAmount("0.00");
        }
        Double oldOpportunityAmount = Double.parseDouble(oldOpportunity.getOpportunityAmount()) / 10000.0;
        String oldPushAmount = df.format(oldOpportunityAmount);
        Double newOpportunityAmount = Double.parseDouble(opportunity.getOpportunityAmount()) / 10000.0;
        String newPushAmount = df.format(newOpportunityAmount);
        LinkedList<String> pushPersonIds = new LinkedList<String>();
        List<String> productManagerIds = this.opportunityMapper.opportunityProductManagerList(opportunity.getOpportunityId(), "0", null);
        List<String> focusIds = this.focusMapper.selectCreateId("2", opportunity.getOpportunityId());
        String creatorId = String.valueOf(oldOpportunity.getCreatePerson());
        if ("22".equals(newOpportunityStage.getStageType())) {
            String title = user.getUserName() + "\u5c06\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u5e9f\u5f03";
            String content = "\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5df2\u7531" + user.getDeptName() + "\u7684" + user.getUserName() + "\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", opportunity.getOpportunityId().toString(), Collections.singletonList(creatorId));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
            contentUnify = "\u3010\u5546\u673a\u9636\u6bb5\u53d8\u66f4\u3011" + user.getUserName() + "\u5c06\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, creatorId, user.getUserName(), (String)unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
        List<Map<String, Object>> productManagers = this.opportunityMapper.opportunityProductAndManagerList(opportunity.getOpportunityId(), "0", null);
        String endTime = "\u7a7a";
        if (StringUtil.isNotBlank((CharSequence)opportunity.getEndTime())) {
            endTime = opportunity.getEndTime().substring(0, 10);
        }
        if (CollectionUtil.isNotEmpty(productManagers)) {
            LinkedList<String> list = new LinkedList<String>();
            for (Map<String, Object> productManager : productManagers) {
                String contentUnify2;
                String unifyWebUrl2;
                String content;
                String title;
                if (list.contains(String.valueOf(productManager.get("managerId")))) continue;
                list.add(String.valueOf(productManager.get("managerId")));
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String productManagerId = String.valueOf(productManager.get("managerId"));
                if ("22".equals(newOpportunityStage.getStageType())) {
                    if (creatorId.equals(productManagerId)) continue;
                    title = user.getUserName() + "\u5c06\u5546\u673a\u5e9f\u5f03";
                    content = "\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5df2\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
                    unifyWebUrl2 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
                    contentUnify2 = "\u3010\u5546\u673a\u9636\u6bb5\u53d8\u66f4\u3011" + user.getUserName() + "\u5c06\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
                } else {
                    title = "\u3010" + productManager.get("shortName") + "\u3011\u5546\u673a\u52a8\u6001";
                    content = deptName + "-" + userName + "\u5c06\u5546\u673a\u3010" + oldOpportunity.getOpportunityName() + "\u3011\u7531" + oldStageName + "\u53d8\u66f4\u4e3a" + newStageName + "\uff0c\u9884\u8ba1\u6210\u4ea4\u65e5\u671f" + endTime + "\uff0c\u5546\u673a\u91d1\u989d" + newPushAmount + "\u4e07\u5143";
                    unifyWebUrl2 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
                    contentUnify2 = "\u3010\u5546\u673a\u9636\u6bb5\u53d8\u66f4\u3011" + deptName + "-" + userName + " \u5c06\u5546\u673a\u3010" + oldOpportunity.getOpportunityName() + "\u3011\u7531" + oldStageName + "\u53d8\u66f4\u4e3a" + newStageName + "\uff0c\u9884\u8ba1\u6210\u4ea4\u65e5\u671f\uff1a" + endTime + "\uff0c\u5546\u673a\u91d1\u989d" + newPushAmount + "\u4e07\u5143\u3002";
                }
                EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(opportunity.getOpportunityId()), Collections.singletonList(productManagerId));
                UnifyUtil.defaultMessage(addSysMessageType, contentUnify2, date, user, productManagerId, userName, unifyWebUrl2, "");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        if (CollectionUtil.isNotEmpty(focusIds)) {
            for (int i = 0; i < focusIds.size(); ++i) {
                if (productManagerIds.contains(focusIds.get(i))) continue;
                pushPersonIds.add(focusIds.get(i));
            }
        }
        if (CollectionUtil.isNotEmpty(pushPersonIds)) {
            String content;
            String title;
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            if ("22".equals(newOpportunityStage.getStageType())) {
                pushPersonIds.remove(creatorId);
                title = user.getUserName() + "\u5c06\u5546\u673a\u5e9f\u5f03";
                content = "\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5df2\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
                contentUnify = "\u3010\u5546\u673a\u9636\u6bb5\u53d8\u66f4\u3011" + user.getUserName() + "\u5c06\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
            } else {
                title = "\u3010" + oldOpportunity.getOpportunityName() + "\u3011\u5546\u673a\u52a8\u6001";
                content = deptName + "-" + userName + "\u5c06\u5546\u673a\u3010" + oldOpportunity.getOpportunityName() + "\u3011\u7531" + oldStageName + "\u53d8\u66f4\u4e3a" + newStageName + "\uff0c\u9884\u8ba1\u6210\u4ea4\u65e5\u671f" + endTime + "\uff0c\u5546\u673a\u91d1\u989d" + newPushAmount + "\u4e07\u5143";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
                contentUnify = "\u3010\u5546\u673a\u9636\u6bb5\u53d8\u66f4\u3011" + deptName + "-" + userName + " \u5c06\u5546\u673a\u3010" + oldOpportunity.getOpportunityName() + "\u3011\u7531 " + oldStageName + "\u53d8\u66f4\u4e3a" + newStageName + "\uff0c\u9884\u8ba1\u6210\u4ea4\u65e5\u671f\uff1a" + endTime + "\uff0c\u5546\u673a\u91d1\u989d" + newPushAmount + "\u4e07\u5143\u3002";
            }
            String userIdToString = StringUtil.join(pushPersonIds, (String)",");
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(opportunity.getOpportunityId()), pushPersonIds);
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, userName, (String)unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
        if (!"22".equals(newOpportunityStage.getStageType()) && ToolUtil.isNotEmpty((Object)oldOpportunity.getPartner())) {
            String content = "\u5546\u673a\u9636\u6bb5\u7531" + oldStageName + "\u53d8\u66f4\u4e3a" + newStageName;
            SendOpportunityStageDTO sendOpportunityStageDTO = new SendOpportunityStageDTO();
            sendOpportunityStageDTO.setOpportunityName(oldOpportunity.getOpportunityName());
            sendOpportunityStageDTO.setOpportunityStage(content);
            sendOpportunityStageDTO.setOpportunityAmount(newPushAmount + "\u4e07\u5143");
            sendOpportunityStageDTO.setSuccessDate(opportunity.getEndTime());
            sendOpportunityStageDTO.setPartner(oldOpportunity.getPartner());
            this.weChatMessageService.sendOpportunityStage(sendOpportunityStageDTO);
        }
        if (oldOpportunity.getStageFinishTime() != null && opportunity.getStageFinishTime() == null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.eq(OpportunityEntity::getOpportunityId, (Object)opportunity.getOpportunityId())).set(OpportunityEntity::getStageFinishTime, null);
            this.saveOrUpdate(opportunity, (Wrapper)updateWrapper);
        } else {
            this.saveOrUpdate(opportunity);
        }
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_STAGE.getId());
        operateRecordDO.setContactName(oldStageName);
        operateRecordDO.setRecordContent(newStageName);
        operateRecordDO.setSourceType("6");
        Long customerId = oldOpportunity.getCustomerId();
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunity.getOpportunityId(), opportunity.getOpportunityName(), date, false, Arrays.asList(opportunity.getOpportunityId(), customerId));
        StageRecord oppoStagePromote = new StageRecord();
        oppoStagePromote.setOpportunityId(oldOpportunity.getOpportunityId());
        oppoStagePromote.setBeforeStageName(oldStageName);
        oppoStagePromote.setBeforeStageId(oldOpportunityStage.getCustomerStageId());
        oppoStagePromote.setAfterStageName(newStageName);
        oppoStagePromote.setAfterStageId(newOpportunityStage.getCustomerStageId());
        oppoStagePromote.setEntryTime(LocalDateTime.now());
        oppoStagePromote.setDelFlag("0");
        this.stageRecordService.insertRecordAndUpdateLeaveTime(oppoStagePromote);
        return ApiResponse.success((String)"\u9636\u6bb5\u53d8\u66f4\u6210\u529f");
    }

    @Override
    @Transactional
    public ApiResponse<String> changeOpportunityStageWin(ChangeOpportunityStageDto dto) {
        CustomerEntity customer;
        List productIdList;
        String unifyWebUrl;
        AddSysMessageType addSysMessageType;
        String content;
        String title;
        List teamMemberIdList;
        List<String> marketingManager;
        if (CollectionUtil.isNotEmpty(dto.getParamMap())) {
            this.editOpportunity(dto.getParamMap());
        }
        Long opportunityId = dto.getOpportunityId();
        Long stageId = dto.getStageId();
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById(opportunityId);
        String checkRes = this.changeOpportunityStageCheck(opportunity, stageId);
        if (!"0".equals(checkRes)) {
            throw new HussarException(checkRes);
        }
        OpportunityStage os = (OpportunityStage)this.opportunityStageService.getById(stageId);
        OpportunityStage oldOs = (OpportunityStage)this.opportunityStageService.getById((Serializable)((Object)opportunity.getCustomerStageId()));
        opportunity.setCustomerStageId(String.valueOf(stageId));
        opportunity.setCustomerStageName(os.getCustomerStageName());
        OpportunityUtil.handleDateField(opportunity);
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        String deptName = user.getDeptName();
        String launchDate = null;
        if (ToolUtil.isNotEmpty((Object)opportunity.getLaunchDatePlan())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            launchDate = sdf.format(opportunity.getLaunchDatePlan());
        }
        opportunity.setChangePerson(userId);
        opportunity.setChangePersonName(userName);
        opportunity.setChangeTime(date);
        opportunity.setStageFinishTime(date);
        OpportunityEntity oldOpportunity = (OpportunityEntity)this.getById(opportunity.getOpportunityId());
        DecimalFormat df = new DecimalFormat("#,##0.00");
        df.setRoundingMode(RoundingMode.HALF_UP);
        if (ToolUtil.isEmpty((Object)opportunity.getOpportunityAmount())) {
            opportunity.setOpportunityAmount("0");
        }
        Double newOpportunityAmount = Double.parseDouble(opportunity.getOpportunityAmount()) / 10000.0;
        String newPushAmount = df.format(newOpportunityAmount);
        opportunity.setEndTime(opportunity.getSuccessDate());
        opportunity.setState("8");
        opportunity.setLoseDate(null);
        List<Object> pushPersonIds = new LinkedList<String>();
        List<String> productManagerIds = this.opportunityMapper.opportunityProductManagerList(opportunity.getOpportunityId(), "0", null);
        List<String> focusIds = this.focusMapper.selectCreateId("2", opportunity.getOpportunityId());
        List deptChargerIds = this.dataRightBoService.getUserIdByDeptChargerDeptIds(Collections.singletonList(oldOpportunity.getOwnDepartment())).stream().map(String::valueOf).collect(Collectors.toList());
        if (!userId.equals(oldOpportunity.getChargePersonId())) {
            pushPersonIds.add(String.valueOf(oldOpportunity.getChargePersonId()));
        }
        if (CollectionUtil.isNotEmpty(pushPersonIds = Stream.of(productManagerIds, deptChargerIds, focusIds, pushPersonIds, marketingManager = this.commonMapper.getUserByRoleId(Long.valueOf(this.crmProperties.getRoles().getMarketingManager())), teamMemberIdList = this.teamMeberService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TeamMeberEntity::getPersonId}).eq(TeamMeberEntity::getBusinessType, (Object)"2")).eq(TeamMeberEntity::getBusinessId, (Object)oldOpportunity.getOpportunityId())).eq(TeamMeberEntity::getDelFlag, (Object)"0"), String::valueOf)).flatMap(Collection::stream).collect(Collectors.toList()))) {
            title = "\u3010\u8d62\u5355\u559c\u62a5\u3011" + oldOpportunity.getOwnDepartmentName() + "-" + oldOpportunity.getChargePersonName() + "\uff0c\u8d62\u5355\u91d1\u989d" + newPushAmount + "\u4e07\u5143";
            content = "\u5546\u673a\u540d\u79f0\uff1a" + oldOpportunity.getOpportunityName();
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(opportunity.getOpportunityId()), pushPersonIds);
            addSysMessageType = new AddSysMessageType();
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
            String userIdToString = StringUtil.join(pushPersonIds, (String)",");
            String contentUnify = "\u3010\u8d62\u5355\u559c\u62a5\u3011" + oldOpportunity.getOwnDepartmentName() + "-" + oldOpportunity.getChargePersonName() + "\uff0c\u8d62\u5355\u91d1\u989d" + newPushAmount + "\u4e07\u5143\uff0c\u8d62\u5355\u5546\u673a\uff1a" + oldOpportunity.getOpportunityName() + "\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, userName, unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
        if (!pushPersonIds.contains(String.valueOf(oldOpportunity.getCreatePerson())) && !userId.equals(oldOpportunity.getCreatePerson())) {
            title = "\u3010\u8d62\u5355\u559c\u62a5\u3011";
            content = "\u611f\u8c22\u60a8\u63d0\u4f9b\u7684\u5546\u673a\u3010" + oldOpportunity.getOpportunityName() + "\u3011,\u5df2\u6210\u529f\u8d62\u5355,\u8bf7\u77e5\u6653";
            EimPushUtil.pushJqxTextMessage(content, Collections.singletonList(String.valueOf(oldOpportunity.getCreatePerson())));
            addSysMessageType = new AddSysMessageType();
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + oldOpportunity.getOpportunityId() + "\"";
            String contentUnify = "\u611f\u8c22\u60a8\u63d0\u4f9b\u7684\u5546\u673a\u3010" + oldOpportunity.getOpportunityName() + "\u3011\uff0c\u5df2\u6210\u529f\u8d62\u5355\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, String.valueOf(oldOpportunity.getCreatePerson()), userName, unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
        if (CollectionUtil.isNotEmpty((Collection)(productIdList = this.opportunityProductService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityProduct::getProductId}).eq(OpportunityProduct::getOpportunityId, (Object)opportunity.getOpportunityId())).eq(OpportunityProduct::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()))))) {
            customer = (CustomerEntity)this.customerService.getById(oldOpportunity.getCustomerId());
            List productList = this.productService.listByIds(productIdList);
            SendWinAnOrderDTO sendWinAnOrderDTO = new SendWinAnOrderDTO();
            sendWinAnOrderDTO.setProductList(productList);
            sendWinAnOrderDTO.setPartner(oldOpportunity.getPartner());
            sendWinAnOrderDTO.setOpportunityName(oldOpportunity.getOpportunityName());
            sendWinAnOrderDTO.setCustomerName(customer.getCustomerName());
            this.weChatMessageService.sendWinAnOrder(sendWinAnOrderDTO);
        } else if (ToolUtil.isNotEmpty((Object)oldOpportunity.getPartner())) {
            customer = (CustomerEntity)this.customerService.getById(oldOpportunity.getCustomerId());
            SendWinAnOrderDTO winAnOrderDTO = new SendWinAnOrderDTO();
            winAnOrderDTO.setOpportunityName(oldOpportunity.getOpportunityName());
            winAnOrderDTO.setCustomerName(customer.getCustomerName());
            winAnOrderDTO.setPartner(oldOpportunity.getPartner());
            this.weChatMessageService.sendWinAnOrder(winAnOrderDTO);
        }
        this.saveOrUpdate(opportunity);
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_STAGE.getId());
        operateRecordDO.setContactName(oldOs.getCustomerStageName());
        operateRecordDO.setRecordContent(os.getCustomerStageName());
        operateRecordDO.setNewDate(opportunity.getSuccessDate());
        operateRecordDO.setSourceType("6");
        Long customerId = oldOpportunity.getCustomerId();
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunity.getOpportunityId(), opportunity.getOpportunityName(), date, false, Arrays.asList(opportunity.getOpportunityId(), customerId));
        StageRecord oppoStagePromote = new StageRecord();
        oppoStagePromote.setOpportunityId(oldOpportunity.getOpportunityId());
        oppoStagePromote.setBeforeStageName(oldOs.getCustomerStageName());
        oppoStagePromote.setBeforeStageId(Long.valueOf(oldOpportunity.getCustomerStageId()));
        oppoStagePromote.setAfterStageName(os.getCustomerStageName());
        oppoStagePromote.setAfterStageId(os.getCustomerStageId());
        oppoStagePromote.setEntryTime(LocalDateTime.now());
        oppoStagePromote.setDelFlag("0");
        this.stageRecordService.insertRecordAndUpdateLeaveTime(oppoStagePromote);
        if (!Objects.equals(oldOpportunity.getEndTime(), opportunity.getEndTime())) {
            String oldDate = null;
            String newDate = null;
            if (StringUtil.isNotBlank((CharSequence)oldOpportunity.getEndTime())) {
                oldDate = oldOpportunity.getEndTime().substring(0, 10);
            }
            if (StringUtil.isNotBlank((CharSequence)opportunity.getEndTime())) {
                newDate = opportunity.getEndTime().substring(0, 10);
            }
            OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
            operateRecordAPIVo.setOldDate(oldDate);
            operateRecordAPIVo.setNewDate(newDate);
            this.operateRecordAPIService.saveOperateLog(operateRecordAPIVo, CrmBusinessTypeEnum.OPPORTUNITY, opportunityId, opportunity.getOpportunityName(), RecordProductTypeEnum.PRODUCE_OPPORTUNITY_DATE.getId(), date, Boolean.valueOf(true), user);
        }
        return ApiResponse.success((String)"\u9636\u6bb5\u53d8\u66f4\u6210\u529f");
    }

    @Override
    @Transactional
    public ApiResponse<String> changeOpportunityStageLose(ChangeOpportunityStageDto dto) {
        if (CollectionUtil.isNotEmpty(dto.getParamMap())) {
            this.editOpportunity(dto.getParamMap());
        }
        Long opportunityId = dto.getOpportunityId();
        Long stageId = dto.getStageId();
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById(opportunityId);
        String checkRes = this.changeOpportunityStageCheck(opportunity, stageId);
        if (!"0".equals(checkRes)) {
            throw new HussarException(checkRes);
        }
        OpportunityStage os = (OpportunityStage)this.opportunityStageService.getById(stageId);
        OpportunityStage oldOs = (OpportunityStage)this.opportunityStageService.getById((Serializable)((Object)opportunity.getCustomerStageId()));
        opportunity.setCustomerStageName(os.getCustomerStageName());
        opportunity.setCustomerStageId(String.valueOf(stageId));
        OpportunityUtil.handleDateField(opportunity);
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        opportunity.setChangePerson(userId);
        opportunity.setChangePersonName(userName);
        opportunity.setChangeTime(date);
        opportunity.setStageFinishTime(date);
        OpportunityEntity oldOpportunity = (OpportunityEntity)this.getById(opportunity.getOpportunityId());
        DecimalFormat df = new DecimalFormat("#,##0.00");
        df.setRoundingMode(RoundingMode.HALF_UP);
        if (ToolUtil.isEmpty((Object)opportunity.getOpportunityAmount())) {
            opportunity.setOpportunityAmount("0");
        }
        Double newOpportunityAmount = Double.parseDouble(opportunity.getOpportunityAmount()) / 10000.0;
        String newPushAmount = df.format(newOpportunityAmount);
        opportunity.setState("9");
        opportunity.setSuccessDate(null);
        LinkedList<String> pushPersonIds = new LinkedList<String>();
        List<String> productManagerIds = this.opportunityMapper.opportunityProductManagerList(opportunity.getOpportunityId(), "0", null);
        List<String> focusIds = this.focusMapper.selectCreateId("2", opportunity.getOpportunityId());
        List deptChargerIds = this.dataRightBoService.getUserIdByDeptChargerDeptIds(Collections.singletonList(oldOpportunity.getOwnDepartment())).stream().map(String::valueOf).collect(Collectors.toList());
        if (!userId.equals(oldOpportunity.getChargePersonId())) {
            pushPersonIds.add(String.valueOf(oldOpportunity.getChargePersonId()));
        }
        List<String> marketingManager = this.commonMapper.getUserByRoleId(Long.valueOf(this.crmProperties.getRoles().getMarketingManager()));
        List teamMemberIdList = this.teamMeberService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TeamMeberEntity::getPersonId}).eq(TeamMeberEntity::getBusinessType, (Object)"2")).eq(TeamMeberEntity::getBusinessId, (Object)oldOpportunity.getOpportunityId())).eq(TeamMeberEntity::getDelFlag, (Object)"0"), String::valueOf);
        pushPersonIds = Stream.of(productManagerIds, deptChargerIds, focusIds, pushPersonIds, marketingManager, teamMemberIdList).flatMap(Collection::stream).collect(Collectors.toList());
        StringBuilder loseReasonValue = new StringBuilder("\u7a7a");
        if (opportunity.getLoseReason() != null) {
            String[] loseArr = opportunity.getLoseReason().split(",");
            loseReasonValue = new StringBuilder();
            if (loseArr.length > 0) {
                for (String value : loseArr) {
                    String label = this.sysDicRefService.getDictLabel("lost_type", value);
                    if (!ToolUtil.isNotEmpty((Object)label)) continue;
                    loseReasonValue.append(",").append(label);
                }
                loseReasonValue = new StringBuilder(loseReasonValue.length() > 0 ? loseReasonValue.substring(1) : loseReasonValue);
            }
        }
        String title = "\u5546\u673a\u3010" + oldOpportunity.getOpportunityName() + "\u3011\u8f93\u5355";
        String content = "\u8d1f\u8d23\u4eba\uff1a" + oldOpportunity.getOwnDepartmentName() + "-" + oldOpportunity.getChargePersonName() + "\uff0c\u8f93\u5355\u7c7b\u578b\uff1a" + loseReasonValue + "\uff0c\u8f93\u5355\u539f\u56e0\uff1a" + opportunity.getLoseReasonDetail();
        EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(opportunity.getOpportunityId()), pushPersonIds);
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
        String userIdToString = StringUtil.join(pushPersonIds, (String)",");
        String contentUnify = "\u3010\u8f93\u5355\u63d0\u9192\u3011" + oldOpportunity.getOwnDepartmentName() + "-" + oldOpportunity.getChargePersonName() + "\uff0c\u5c06\u5546\u673a\u3010" + oldOpportunity.getOpportunityName() + "\u3011\u53d8\u66f4\u4e3a\u8f93\u5355\uff0c\u8f93\u5355\u7c7b\u578b\uff1a" + loseReasonValue + "\uff0c\u8f93\u5355\u539f\u56e0\uff1a" + opportunity.getLoseReasonDetail() + "\u3002";
        UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, userName, unifyWebUrl, "");
        UnifyUtil.sendMessage(addSysMessageType);
        this.saveOrUpdate(opportunity);
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_STAGE.getId());
        operateRecordDO.setContactName(oldOs.getCustomerStageName());
        operateRecordDO.setRecordContent(os.getCustomerStageName());
        operateRecordDO.setSourceType("6");
        Long customerId = oldOpportunity.getCustomerId();
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunity.getOpportunityId(), opportunity.getOpportunityName(), date, false, Arrays.asList(opportunity.getOpportunityId(), customerId));
        StageRecord oppoStagePromote = new StageRecord();
        oppoStagePromote.setOpportunityId(oldOpportunity.getOpportunityId());
        oppoStagePromote.setBeforeStageName(oldOs.getCustomerStageName());
        oppoStagePromote.setBeforeStageId(Long.valueOf(oldOpportunity.getCustomerStageId()));
        oppoStagePromote.setAfterStageName(os.getCustomerStageName());
        oppoStagePromote.setAfterStageId(os.getCustomerStageId());
        oppoStagePromote.setEntryTime(LocalDateTime.now());
        oppoStagePromote.setDelFlag("0");
        this.stageRecordService.insertRecordAndUpdateLeaveTime(oppoStagePromote);
        return ApiResponse.success((String)"\u9636\u6bb5\u53d8\u66f4\u6210\u529f");
    }

    @Override
    public ApiResponse<Object> editOpportunity(Map<String, Object> map) {
        Long opportunityId = map.get("opportunityId").getClass() == Long.class ? (Long)map.get("opportunityId") : Long.valueOf(Long.parseLong((String)map.get("opportunityId")));
        List list = BeanUtil.copy((Collection)((List)map.get("otherTaskList")), StageTaskOpptyRelationEntity.class);
        CrmOpportunity2 opportunity = (CrmOpportunity2)this.crmOpportunity2Service.getById(opportunityId);
        map.remove("opportunityId");
        map.remove("otherTaskList");
        if (CollectionUtil.isNotEmpty(map)) {
            this.mapToEntity(map, opportunity);
        }
        this.crmOpportunity2Service.insertOrUpdate(opportunity);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (StageTaskOpptyRelationEntity entity : list) {
                if (entity.getOpportunityId() != null) continue;
                entity.setOpportunityId(opportunityId);
            }
            this.stageTaskOpptyRelationService.saveOrUpdateBatch(list);
        }
        return ApiResponse.success((Object)true);
    }

    @Override
    public void mapToEntity(Map<String, Object> map, Object entity) {
        Class<?> clazz = entity.getClass();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                Field field = clazz.getDeclaredField(entry.getKey());
                field.setAccessible(true);
                Object value = entry.getValue();
                Class<?> fieldType = field.getType();
                if (value instanceof String) {
                    if (fieldType != String.class && "".equals(value)) {
                        value = null;
                    } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                        value = Double.parseDouble((String)value);
                    } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                        value = Integer.parseInt((String)value);
                    } else if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
                        value = Boolean.parseBoolean((String)value);
                    } else if (fieldType == LocalDateTime.class) {
                        value = ((String)value).length() <= 10 ? LocalDate.parse((String)value, DateTimeFormatter.ofPattern("yyyy-MM-dd")).atStartOfDay() : LocalDateTime.parse((String)value, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    } else if (fieldType == LocalDate.class) {
                        value = ((String)value).length() <= 10 ? LocalDate.parse((String)value, DateTimeFormatter.ofPattern("yyyy-MM-dd")) : LocalDateTime.parse((String)value, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toLocalDate();
                    }
                }
                field.set(entity, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<OpportunityAPIVo> selectOpportunityForWallChart(Page<OpportunityAPIVo> page, OpportunityQueryNoPageDto queryDto) {
        List<OpportunityAPIVo> list = page == null ? this.opportunityMapper.selectOpportunityForWallChart(queryDto) : this.opportunityMapper.selectOpportunityForWallChart(page, queryDto);
        return list;
    }

    @Override
    public Integer selectOpportunityCountForWallChart(OpportunityQueryNoPageDto queryDto) {
        return this.opportunityMapper.selectOpportunityCountForWallChart(queryDto);
    }

    @Override
    public List<OpportunityAttributeRepeatVo> opportunityAttributeRepeat(OpportunityDto dto) {
        dto.setDelFlag("0");
        List<OpportunityAttributeRepeatVo> opportunityAttributeRepeatVoList = this.opportunityMapper.opportunityAttributeRepeatVoList(dto);
        return opportunityAttributeRepeatVoList;
    }

    @Override
    public OpportunityRecordNecessaryInfo getRecordNecessaryInfo(Long opportunityId) {
        OpportunityEntity opportunity = (OpportunityEntity)this.getById(opportunityId);
        OpportunityRecordNecessaryInfo vo = new OpportunityRecordNecessaryInfo();
        vo.setTenderDate(opportunity.getTenderDate());
        vo.setEndTime(opportunity.getEndTime());
        vo.setCustomerBudget(opportunity.getCustomerBudget());
        vo.setOpportunityAmount(opportunity.getOpportunityAmount());
        vo.setIsProjectApproval(opportunity.getIsProjectApproval());
        vo.setOpportunityWinRate(opportunity.getOpportunityWinRate());
        vo.setPurchaseMethod(opportunity.getPurchaseMethod());
        List competitorAnalysisList = this.competitorAnalysisService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getOpportunityId, (Object)opportunityId)).eq(CompetitorAnalysis::getDelFlag, (Object)"0"));
        if (CollectionUtil.isNotEmpty((Collection)competitorAnalysisList)) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (CompetitorAnalysis ca : competitorAnalysisList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("value", ca.getCompetitorId());
                map.put("label", ca.getCompetitorName());
                list.add(map);
            }
            vo.setCompetitorList(list);
        }
        return vo;
    }
}

