/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordRelationAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordRelationAPIVo;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.contactcharacter.model.ContactCharacterEntity;
import com.jxdinfo.crm.core.contactcharacter.service.ContactCharacterService;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmopportunityproduct1.service.CrmOpportunityProduct1Service;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.leads.service.LeadsService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dto.ImproveCreateContactDto;
import com.jxdinfo.crm.core.opportunity.dto.ImproveCreateCustomerDto;
import com.jxdinfo.crm.core.opportunity.dto.ImproveOpportunityDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityEntityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.ImproveOpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImproveOpportunityServiceImpl
extends ServiceImpl<OpportunityMapper, OpportunityEntity>
implements ImproveOpportunityService {
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ContactCharacterService contactCharacterService;
    @Resource
    private CrmOpportunityProduct1Service crmOpportunityProduct1Service;
    @Resource
    private OpportunityProductService opportunityProductService2;
    @Resource
    private CustomerService customerService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CommonService commonService;
    @Resource
    private LeadsService leadsService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private ContactService contactService;
    @Resource
    private ITrackRecordRelationAPIService trackRecordRelationAPIService;
    @Resource
    private IOrganUserBoService organUserBoService;

    @Override
    @Transactional
    public Boolean improveOpportunity(ImproveOpportunityDto dto) {
        OpportunityEntity opportunityOld = (OpportunityEntity)this.opportunityMapper.selectById(dto.getOpportunityEntityDto().getOpportunityId());
        OpportunityEntityDto opportunityEntityDto = dto.getOpportunityEntityDto();
        CustomerEntity customer = dto.getCustomer();
        ContactCharacterEntity contactCharacter = dto.getContactCharacter();
        opportunityEntityDto.setCustomerId(customer.getCustomerId());
        opportunityEntityDto.setCustomerName(customer.getCustomerName());
        OpportunityEntity opportunityNew = (OpportunityEntity)BeanUtil.copy((Object)opportunityEntityDto, OpportunityEntity.class);
        assert (opportunityNew != null);
        if (CollectionUtil.isNotEmpty(opportunityEntityDto.getProductList())) {
            for (OpportunityProduct product : opportunityEntityDto.getProductList()) {
                product.setOpportunityId(opportunityOld.getOpportunityId());
                product.setOpportunityName(opportunityOld.getOpportunityName());
                if (!ToolUtil.isEmpty((Object)product.getStandardPrice()) || !ToolUtil.isNotEmpty((Object)product.getProductPrice())) continue;
                product.setStandardPrice(product.getProductPrice());
            }
            this.opportunityProductService2.saveOpportunityProduct(opportunityEntityDto.getProductList(), false, true);
        }
        contactCharacter.setOpportunityId(String.valueOf(opportunityEntityDto.getOpportunityId()));
        contactCharacter.setOpportunityName(opportunityNew.getOpportunityName());
        contactCharacter.setId(Long.valueOf(CommonUtills.generateAssignId()));
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        opportunityNew.setChangeTime(date);
        opportunityNew.setChangePerson(user.getUserId());
        opportunityNew.setChangePersonName(user.getUserName());
        this.contactCharacterService.addContactCharacter(contactCharacter);
        this.opportunityService.saveOrUpdate(opportunityNew);
        if (ToolUtil.isNotEmpty((Object)opportunityOld.getName()) && ToolUtil.isNotEmpty((Object)opportunityOld.getMobilePhone()) && ToolUtil.isNotEmpty((Object)opportunityNew.getCustomerId())) {
            opportunityOld.setMobilePhone(opportunityOld.getMobilePhone().replace(" ", ""));
            List contactList = this.contactService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getDelFlag, (Object)"0")).eq(ContactEntity::getCustomerId, (Object)opportunityNew.getCustomerId())).eq(ContactEntity::getMobilePhone, (Object)opportunityOld.getMobilePhone()));
            if (CollectionUtil.isEmpty((Collection)contactList)) {
                ContactEntity contact = new ContactEntity();
                contact.setContactName(opportunityOld.getName());
                contact.setDepartment(opportunityOld.getContactDepartment());
                contact.setPosition(opportunityOld.getPosition());
                contact.setMobilePhone(opportunityOld.getMobilePhone());
                contact.setSex(opportunityOld.getSex());
                contact.setTelephone(opportunityOld.getTelephone());
                contact.setEmail(opportunityOld.getEmail());
                contact.setCustomerId(opportunityNew.getCustomerId());
                contact.setCustomerName(opportunityNew.getCustomerName());
                this.contactService.saveCrmContact(contact);
            }
        }
        this.improveOppRecord(opportunityNew.getOpportunityId(), opportunityNew.getOpportunityName(), customer.getCustomerId(), Long.valueOf(contactCharacter.getContactId()), date);
        List<TrackRecordRelationAPIVo> recordRelationList = this.getRelationRecord(opportunityOld.getOpportunityId(), customer.getCustomerId());
        this.trackRecordRelationAPIService.saveBatch(recordRelationList);
        return true;
    }

    private void improveOppRecord(Long opportunityId, String opportunityName, Long customerId, Long contactId, LocalDateTime date) {
        ArrayList<Long> typeIds = new ArrayList<Long>();
        typeIds.add(opportunityId);
        typeIds.add(customerId);
        if (HussarUtils.isNotEmpty((Object)contactId)) {
            typeIds.add(contactId);
        }
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setConvertCustomerId(customerId);
        if (HussarUtils.isNotEmpty((Object)contactId)) {
            operateRecordDO.setConvertContactId(contactId);
        }
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFORMATION.getId());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunityId, opportunityName, date, false, typeIds);
    }

    private List<TrackRecordRelationAPIVo> getRelationRecord(Long opportunityId, Long customerId) {
        ArrayList<TrackRecordRelationAPIVo> relationList = new ArrayList<TrackRecordRelationAPIVo>();
        List recordList = this.trackRecordAPIService.list(Collections.singletonList(String.valueOf(opportunityId)), null, Collections.singletonList(RecordProductTypeEnum.PRODUCE_SYSTEM.getId()), "0");
        for (TrackRecordAPIVo list : recordList) {
            TrackRecordRelationAPIVo trackRecordRelation = new TrackRecordRelationAPIVo();
            trackRecordRelation.setRecordId(list.getRecordId());
            trackRecordRelation.setTypeId(customerId);
            relationList.add(trackRecordRelation);
        }
        return relationList;
    }

    @Override
    @Transactional
    public CustomerEntity improveCustomerContact(ImproveCreateCustomerDto dto) {
        List personIds;
        Long businessId;
        if (HussarUtils.isNotEmpty((Object)dto.getLeadsId())) {
            Leads leads = (Leads)this.leadsService.getById(dto.getLeadsId());
            if (leads == null || "1".equals(leads.getDelFlag())) {
                throw new BaseException("\u5f53\u524d\u7ebf\u7d22\u4e0d\u5b58\u5728");
            }
            if ("6".equals(leads.getState())) {
                throw new BaseException("\u5f53\u524d\u7ebf\u7d22\u5df2\u5e9f\u5f03");
            }
            businessId = dto.getLeadsId();
        } else {
            OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById(dto.getOpportunityId());
            if (opportunity == null || "1".equals(opportunity.getDelFlag())) {
                throw new BaseException("\u5f53\u524d\u5546\u673a\u4e0d\u5b58\u5728");
            }
            if ("6".equals(opportunity.getState())) {
                throw new BaseException("\u5f53\u524d\u5546\u673a\u5df2\u5e9f\u5f03");
            }
            businessId = dto.getOpportunityId();
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long customerId = null;
        Long contactId = null;
        Long chargePersonId = user.getUserId();
        String chargePersonName = user.getUserName();
        customerId = Long.valueOf(CommonUtills.generateAssignId());
        CustomerEntity customerEntity = dto.getCustomer();
        customerEntity.setCustomerId(customerId);
        Long customerChargePersonId = customerEntity.getChargePersonId();
        String customerChargePersonName = customerEntity.getChargePersonName();
        if (customerChargePersonId == null || customerChargePersonName == null) {
            this.leadsService.defaultCustomer(customerEntity, date, user);
        } else {
            SecurityUser customerChargeUser = new SecurityUser();
            customerChargeUser.setUserId(customerChargePersonId);
            customerChargeUser.setUserName(customerChargePersonName);
            customerChargeUser.setDeptId(customerEntity.getOwnDepartment());
            customerChargeUser.setDeptName(customerEntity.getOwnDepartmentName());
            this.leadsService.defaultCustomer(customerEntity, date, customerChargeUser);
        }
        this.customerService.save(customerEntity);
        this.customerService.checkProvinceDept(user, customerEntity, date);
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CUSTOMER, customerId, customerEntity.getCustomerName(), date, false, Arrays.asList(customerId));
        ContactEntity contact = this.improveCreateContact(dto.getContact(), customerId, date, user);
        contactId = contact.getContactId();
        boolean isNewTeamMember = false;
        List teamMeberEntityList = new ArrayList();
        if (dto.getTeamMember().booleanValue() && !(personIds = (teamMeberEntityList = this.teamMeberMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)businessId)).eq(TeamMeberEntity::getDelFlag, (Object)"0"))).stream().map(TeamMeberEntity::getPersonId).collect(Collectors.toList())).contains(user.getUserId())) {
            isNewTeamMember = true;
        }
        if (!teamMeberEntityList.isEmpty()) {
            for (TeamMeberEntity list : teamMeberEntityList) {
                this.leadsService.addTeamMember(list, customerId, "1", date);
            }
            this.teamMeberService.saveBatch(teamMeberEntityList);
        }
        if (isNewTeamMember || !dto.getTeamMember().booleanValue()) {
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), customerId, "1", "0", date, "1");
        }
        if (!teamMeberEntityList.isEmpty()) {
            for (TeamMeberEntity list : teamMeberEntityList) {
                this.leadsService.addTeamMember(list, contactId, "3", date);
            }
            this.teamMeberService.saveBatch(teamMeberEntityList);
        }
        if (isNewTeamMember || !dto.getTeamMember().booleanValue()) {
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), contactId, "1", "0", date, "3");
        }
        return customerEntity;
    }

    @Transactional
    public ContactEntity improveCreateContact(ContactEntity contact, Long customerId, LocalDateTime date, SecurityUser user) {
        Long contactId = Long.valueOf(CommonUtills.generateAssignId());
        contact.setContactId(contactId);
        contact.setCustomerId(customerId);
        Long contactChargePersonId = contact.getChargePersonId();
        String contactChargePersonName = contact.getChargePersonName();
        if (contactChargePersonId == null || contactChargePersonName == null) {
            this.leadsService.defaultContact(contact, date, user);
        } else {
            SecurityUser contactChargeUser = new SecurityUser();
            contactChargeUser.setUserId(contactChargePersonId);
            contactChargeUser.setUserName(contactChargePersonName);
            contactChargeUser.setDeptId(contact.getOwnDepartment());
            contactChargeUser.setDeptName(contact.getOwnDepartmentName());
            this.leadsService.defaultContact(contact, date, contactChargeUser);
        }
        this.contactService.save(contact);
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CONTACT, contactId, contact.getContactName(), date, false, Arrays.asList(contactId, contact.getCustomerId()));
        return contact;
    }

    @Override
    @Transactional
    public ContactEntity createContact(ImproveCreateContactDto dto) {
        List personIds;
        Long businessId = null;
        ContactEntity contact = null;
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)dto.getOpportunityId())) {
            CustomerEntity customer = (CustomerEntity)this.customerService.getById(dto.getCustomerId());
            if (HussarUtils.isEmpty((Object)customer) || "1".equals(customer.getDelFlag())) {
                throw new BaseException("\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
            }
            contact = this.improveCreateContact(dto.getContact(), dto.getCustomerId(), date, user);
            businessId = customer.getCustomerId();
        } else {
            OpportunityEntity opportunity = (OpportunityEntity)this.opportunityMapper.selectById(dto.getOpportunityId());
            if (HussarUtils.isEmpty((Object)opportunity) || "1".equals(opportunity.getDelFlag())) {
                throw new BaseException("\u5f53\u524d\u5546\u673a\u4e0d\u5b58\u5728");
            }
            contact = this.improveCreateContact(dto.getContact(), dto.getCustomerId(), date, user);
            businessId = opportunity.getOpportunityId();
        }
        boolean isNewTeamMember = false;
        List teamMeberEntityList = new ArrayList();
        if (dto.getTeamMember().booleanValue() && !(personIds = (teamMeberEntityList = this.teamMeberMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)businessId)).eq(TeamMeberEntity::getDelFlag, (Object)"0"))).stream().map(TeamMeberEntity::getPersonId).collect(Collectors.toList())).contains(user.getUserId())) {
            isNewTeamMember = true;
        }
        if (!teamMeberEntityList.isEmpty()) {
            for (TeamMeberEntity list : teamMeberEntityList) {
                this.leadsService.addTeamMember(list, contact.getContactId(), "3", date);
            }
            this.teamMeberService.saveBatch(teamMeberEntityList);
        }
        if (isNewTeamMember) {
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), contact.getContactId(), "1", "0", date, "3");
        }
        if (!dto.getTeamMember().booleanValue()) {
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), contact.getContactId(), "1", "1", date, "3");
        }
        return contact;
    }
}

