/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.leads.constant.LeadsEditConstant;
import com.jxdinfo.crm.core.leads.dao.LeadsMergeMapper;
import com.jxdinfo.crm.core.leads.dto.CheckedPropertyLeadsInfo;
import com.jxdinfo.crm.core.leads.dto.LeadsMergeDto;
import com.jxdinfo.crm.core.leads.dto.PrimaryLeadsDto;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.leads.model.LeadsMergeInfo;
import com.jxdinfo.crm.core.leads.model.LeadsMergeRecord;
import com.jxdinfo.crm.core.leads.service.ILeadsMergeInfoService;
import com.jxdinfo.crm.core.leads.service.ILeadsMergeRecordService;
import com.jxdinfo.crm.core.leads.service.ILeadsMergeService;
import com.jxdinfo.crm.core.leads.service.impl.LeadsServiceImpl;
import com.jxdinfo.crm.core.leads.vo.LeadsMergeVo;
import com.jxdinfo.crm.core.leads.vo.LeadsRelationInfoVo;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.PushMessageEnum;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarCoreException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LeadsMergeServiceImpl
implements ILeadsMergeService {
    @Resource
    private LeadsServiceImpl leadsService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ILabelService labelService;
    @Resource
    private CustomerService customerService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ILeadsMergeRecordService leadsMergeRecordService;
    @Resource
    private LeadsMergeMapper leadsMergeMapper;
    @Resource
    private ILeadsMergeInfoService leadsMergeInfoService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private TaskService taskService;

    @Override
    public List<LeadsMergeVo> getList(String leadsIds) {
        if (StringUtil.isBlank((CharSequence)leadsIds)) {
            throw new HussarCoreException("\u53c2\u6570\u7f3a\u5931");
        }
        List leadsIdList = Arrays.asList(leadsIds.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        List leadsList = this.leadsService.listByIds(leadsIdList);
        if (CollectionUtil.isEmpty((Collection)leadsList)) {
            throw new HussarCoreException("\u6ca1\u6709\u5bf9\u5e94\u7684\u7ebf\u7d22\u4fe1\u606f");
        }
        return this.toMergeVo(leadsList);
    }

    private List<LeadsMergeVo> toMergeVo(List<Leads> leadsList) {
        List labelVoList;
        LinkedHashMap leadsOriginDictMap = this.sysDicRefService.getDictMapByType("leads_source");
        LinkedHashMap leadsLevelDictMap = this.sysDicRefService.getDictMapByType("leads_level");
        LinkedHashMap tradeDictMap = this.sysDicRefService.getDictMapByType("industry");
        LinkedHashMap leadsStateDictMap = this.sysDicRefService.getDictMapByType("leads_state_private");
        LinkedHashMap sexDictMap = this.sysDicRefService.getDictMapByType("sex");
        ArrayList<Long> leadsIdList = new ArrayList<Long>();
        ArrayList labelIdList = new ArrayList();
        for (Leads leads : leadsList) {
            String labelId = leads.getLabelId();
            if (StringUtil.isNotBlank((CharSequence)labelId)) {
                List labelIds = Arrays.asList(labelId.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
                labelIdList.addAll(labelIds);
            }
            leadsIdList.add(leads.getLeadsId());
        }
        List teamMeberEntityList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getBusinessId, leadsIdList)).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
        Map<Object, Object> labelInfoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(labelIdList) && CollectionUtil.isNotEmpty((Collection)(labelVoList = this.labelService.listByIds(labelIdList)))) {
            labelInfoMap = labelVoList.stream().collect(Collectors.toMap(LabelVo::getLabelId, LabelVo::getLabelName));
        }
        ArrayList<LeadsMergeVo> leadsMergeVoList = new ArrayList<LeadsMergeVo>();
        for (Leads leads : leadsList) {
            Long transformationCustomerId;
            CustomerEntity customerEntity;
            Object sex;
            Object state;
            Object trade;
            Object leadsLevel;
            LeadsMergeVo leadsMergeVo = new LeadsMergeVo();
            BeanUtil.copyProperties((Object)leads, (Object)leadsMergeVo);
            String labelId = leads.getLabelId();
            ArrayList<Map<String, Object>> labelList = new ArrayList<Map<String, Object>>();
            if (StringUtil.isNotBlank((CharSequence)labelId)) {
                String[] labelIdArray = labelId.split(",");
                for (String labelIdStr : labelIdArray) {
                    Long labelIdLong = Long.valueOf(labelIdStr);
                    Object label = labelInfoMap.get(labelIdLong);
                    if (!ToolUtil.isNotEmpty((Object)label)) continue;
                    HashMap<String, Object> labelMap = new HashMap<String, Object>();
                    labelMap.put("label", label);
                    labelMap.put("value", labelIdStr);
                    labelList.add(labelMap);
                }
            }
            leadsMergeVo.setLabelList(labelList);
            ArrayList<Map<String, Object>> teamMemberList = new ArrayList<Map<String, Object>>();
            for (TeamMeberEntity teamMeberEntity : teamMeberEntityList) {
                if (!teamMeberEntity.getBusinessId().equals(leads.getLeadsId())) continue;
                HashMap<String, Object> teamMeberMap = new HashMap<String, Object>();
                teamMeberMap.put("value", teamMeberEntity.getTeamMeberId());
                teamMeberMap.put("label", teamMeberEntity.getTeamMeberName());
                teamMeberMap.put("departmentId", teamMeberEntity.getOwnDepartment());
                teamMeberMap.put("departmentName", teamMeberEntity.getOwnDepartmentName());
                teamMeberMap.put("modifyPower", teamMeberEntity.getModifyPower());
                teamMeberMap.put("isCharge", teamMeberEntity.getIsCharge());
                teamMeberMap.put("personId", teamMeberEntity.getPersonId());
                teamMemberList.add(teamMeberMap);
            }
            leadsMergeVo.setTeamNumberList(teamMemberList);
            Object leadsOrigin = leadsOriginDictMap.get(leads.getLeadsOrigin());
            if (leadsOrigin != null) {
                leadsMergeVo.setLeadsOriginLabel(leadsOrigin.toString());
            }
            if ((leadsLevel = leadsLevelDictMap.get(leads.getLevelNew())) != null) {
                leadsMergeVo.setLevelNewLabel(leadsLevel.toString());
            }
            if ((trade = tradeDictMap.get(leads.getTrade())) != null) {
                leadsMergeVo.setTradeLabel(trade.toString());
            }
            if ((state = leadsStateDictMap.get(leads.getState())) != null) {
                leadsMergeVo.setStateLabel(state.toString());
            }
            if ((sex = sexDictMap.get(leads.getSex())) != null) {
                leadsMergeVo.setSexLabel(sex.toString());
            }
            if (ToolUtil.isNotEmpty((Object)(customerEntity = (CustomerEntity)this.customerService.getById(transformationCustomerId = leads.getTransformationCustomerId())))) {
                leadsMergeVo.setTransformationCustomerName(customerEntity.getCustomerName());
            } else {
                leadsMergeVo.setTransformationCustomerName(null);
                leadsMergeVo.setTransformationCustomerId(null);
            }
            Long transformationOpportunityId = leads.getTransformationOpportunityId();
            OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById(transformationOpportunityId);
            if (ToolUtil.isNotEmpty((Object)opportunity)) {
                leadsMergeVo.setTransformationOpportunityName(opportunity.getOpportunityName());
            } else {
                leadsMergeVo.setTransformationOpportunityName(null);
                leadsMergeVo.setTransformationOpportunityId(null);
            }
            if (StringUtil.isNotBlank((CharSequence)leads.getProvince())) {
                StringBuilder sb = new StringBuilder();
                sb.append(leads.getProvince());
                if (StringUtil.isNotBlank((CharSequence)leads.getCity())) {
                    sb.append("/").append(leads.getCity());
                    if (StringUtil.isNotBlank((CharSequence)leads.getCounty())) {
                        sb.append("/").append(leads.getCounty());
                    }
                }
                leadsMergeVo.setRegion(sb.toString());
            }
            leadsMergeVoList.add(leadsMergeVo);
        }
        return leadsMergeVoList;
    }

    @Override
    @Transactional
    public Boolean merge(LeadsMergeDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getPrimaryLeads())) {
            throw new HussarCoreException("\u53c2\u6570\u7f3a\u5931");
        }
        if (dto.getLeadsList().size() <= 1) {
            return true;
        }
        PrimaryLeadsDto primaryDto = dto.getPrimaryLeads();
        Long primaryLeadsId = primaryDto.getPrimaryLeadsId();
        String primaryLeadsName = primaryDto.getPrimaryLeadsName();
        LeadsMergeRecord leadsMergeRecord = new LeadsMergeRecord();
        leadsMergeRecord.setLeadsId(primaryLeadsId);
        leadsMergeRecord.setLeadsName(primaryLeadsName);
        this.leadsMergeRecordService.save((Object)leadsMergeRecord);
        List<LeadsMergeVo> leadsMergeVoList = dto.getLeadsList();
        HashMap<String, Object> leadsMap = new HashMap<String, Object>();
        List<CheckedPropertyLeadsInfo> checkedPropertyLeadsInfoList = primaryDto.getCheckedPropertyLeadsInfoList();
        this.putCheckedPropertyLeadsInfo(primaryLeadsId, checkedPropertyLeadsInfoList, dto.getLeadsList());
        Map<String, Map<String, String>> checkPropertyMap = this.checkedPropertyToMap(checkedPropertyLeadsInfoList, leadsMap);
        List<Long> mergeLeadsId = leadsMergeVoList.stream().map(LeadsMergeVo::getLeadsId).collect(Collectors.toList());
        HashMap<String, List<LeadsRelationInfoVo>> relationRecordMap = new HashMap();
        HashMap<String, List<LeadsRelationInfoVo>> relationFileMap = new HashMap();
        HashMap<String, List<LeadsRelationInfoVo>> relationOperationMap = new HashMap();
        HashMap<String, List<LeadsRelationInfoVo>> relationTasKMap = new HashMap();
        if (CollectionUtil.isNotEmpty(mergeLeadsId)) {
            List<LeadsRelationInfoVo> relationRecordList = this.leadsMergeMapper.selectRelationRecord(mergeLeadsId);
            relationRecordMap = relationRecordList.stream().collect(Collectors.groupingBy(LeadsRelationInfoVo::getLeadsId));
            List<LeadsRelationInfoVo> relationFileList = this.leadsMergeMapper.selectRelationFile(mergeLeadsId);
            relationFileMap = relationFileList.stream().collect(Collectors.groupingBy(LeadsRelationInfoVo::getLeadsId));
            List<LeadsRelationInfoVo> relationOperationList = this.leadsMergeMapper.selectRelationOperation(mergeLeadsId);
            relationOperationMap = relationOperationList.stream().collect(Collectors.groupingBy(LeadsRelationInfoVo::getLeadsId));
            List<LeadsRelationInfoVo> relationTaskList = this.leadsMergeMapper.selectRelationTask(mergeLeadsId);
            relationTasKMap = relationTaskList.stream().collect(Collectors.groupingBy(LeadsRelationInfoVo::getLeadsId));
        }
        ArrayList<Long> deleteLeadsIdList = new ArrayList<Long>();
        ArrayList<LeadsMergeInfo> leadsMergeInfoList = new ArrayList<LeadsMergeInfo>();
        ArrayList<Map<String, Object>> checkedTeamMember = new ArrayList<Map<String, Object>>();
        HashSet<String> users = new HashSet<String>();
        Long leadsMergeRecordId = null;
        for (LeadsMergeVo leadsMergeVo : leadsMergeVoList) {
            Long leadsId = leadsMergeVo.getLeadsId();
            if (!leadsId.equals(primaryDto.getPrimaryLeadsId())) {
                deleteLeadsIdList.add(leadsId);
            }
            users.add(String.valueOf(leadsMergeVo.getChargePersonId()));
            users.addAll(leadsMergeVo.getTeamNumberList().stream().map(teamNumber -> teamNumber.get("personId").toString()).collect(Collectors.toList()));
            LeadsMergeInfo leadsMergeInfo = new LeadsMergeInfo();
            leadsMergeInfo.setLeadsId(leadsId);
            leadsMergeInfo.setOldRecordIds(this.getRelationIds(relationRecordMap, leadsId));
            leadsMergeInfo.setOldFileInfoIds(this.getRelationIds(relationFileMap, leadsId));
            leadsMergeInfo.setOldOperationIds(this.getRelationIds(relationOperationMap, leadsId));
            leadsMergeInfo.setOldTaskIds(this.getRelationIds(relationTasKMap, leadsId));
            leadsMergeInfo.setTeamMember(this.getRelationIds(relationTasKMap, leadsId));
            Map<String, String> checkedProperyByLeadsMap = checkPropertyMap.get(String.valueOf(leadsId));
            if (CollectionUtil.isEmpty(checkedProperyByLeadsMap)) continue;
            try {
                leadsMergeRecordId = leadsMergeRecord.getMergeRecordId();
                this.makeLeadsMergeInfo(leadsMergeVo, checkedProperyByLeadsMap, leadsMergeInfo, checkedTeamMember);
                leadsMergeInfo.setMergeRecordId(leadsMergeRecordId);
                leadsMergeInfoList.add(leadsMergeInfo);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.leadsMergeInfoService.saveBatch(leadsMergeInfoList);
        Leads leads = (Leads)JSONObject.parseObject((String)JSONObject.toJSONString(leadsMap), Leads.class);
        leads.setLeadsId(primaryLeadsId);
        this.leadsService.updateById(leads);
        String primaryChargePersonId = leads.getChargePersonId().toString();
        String primaryChargePerson = leads.getOwnDepartmentName() + "-" + leads.getChargePersonName();
        this.updateTeamMemberInfo(checkedTeamMember, primaryLeadsId, primaryChargePersonId, deleteLeadsIdList);
        this.leadsService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(Leads::getLeadsId, deleteLeadsIdList)).set(Leads::getDelFlag, (Object)"1"));
        this.trackRecordAPIService.mergeTrackRecord(deleteLeadsIdList, primaryLeadsId);
        this.fileInfoService.mergeFileInfo(deleteLeadsIdList, primaryLeadsId);
        this.operateRecordAPIService.mergeOperateRecord(deleteLeadsIdList, primaryLeadsId);
        this.taskService.mergeTask(deleteLeadsIdList, primaryLeadsId);
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_MERGE.getId());
        operateRecordDO.setRecordContent(null);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(primaryLeadsId);
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS, primaryLeadsId, primaryLeadsName, LocalDateTime.now(), false, businessIds);
        if (CollectionUtil.isEmpty(users)) {
            return true;
        }
        String teamMemberInfo = null;
        Map<String, List<Map>> checkedTeamMemberMap = checkedTeamMember.stream().collect(Collectors.groupingBy(teamMember -> teamMember.get("departmentName").toString()));
        if (CollectionUtil.isNotEmpty(checkedTeamMember)) {
            for (String departmentName : checkedTeamMemberMap.keySet()) {
                HashSet<String> teamMemberNameSet = new HashSet<String>();
                String teamMemberInfoByDepartment = null;
                List<Map> checkedTeamMemberList = checkedTeamMemberMap.get(departmentName);
                for (Map checkedTeamMemberInfo : checkedTeamMemberList) {
                    String teamMemberName = checkedTeamMemberInfo.get("label").toString();
                    if (!StringUtil.isNotEmpty((Object)teamMemberName) || !teamMemberNameSet.add(teamMemberName)) continue;
                    if (StringUtil.isNotEmpty((Object)teamMemberInfoByDepartment)) {
                        teamMemberInfoByDepartment = teamMemberInfoByDepartment + "\u3001" + checkedTeamMemberInfo.get("label");
                        continue;
                    }
                    teamMemberInfoByDepartment = departmentName + "-" + checkedTeamMemberInfo.get("label");
                }
                if (StringUtil.isNotEmpty(teamMemberInfo)) {
                    teamMemberInfo = teamMemberInfo + ";" + teamMemberInfoByDepartment;
                    continue;
                }
                teamMemberInfo = teamMemberInfoByDepartment;
            }
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String title = "\u3010CRM\u3011\u7ebf\u7d22\u5408\u5e76\u63d0\u9192";
        String content = user.getDeptName() + "-" + user.getUserName() + "\u5bf9\u3010" + primaryLeadsName + "\u3011\u8fdb\u884c\u4e86\u5408\u5e76\u5904\u7406\uff0c\u5408\u5e76\u540e\u7ebf\u7d22\u8d1f\u8d23\u4eba\u4e3a\uff1a" + primaryChargePerson + "\uff0c\u56e2\u961f\u6210\u5458\u5305\u542b\uff1a" + teamMemberInfo;
        String userIds = null;
        ArrayList<String> userList = new ArrayList<String>(users);
        for (String userId : userList) {
            if (StringUtil.isNotEmpty(userIds)) {
                userIds = userIds + "," + userId;
                continue;
            }
            userIds = userId;
        }
        String businessId = String.valueOf(primaryLeadsId);
        EimPushUtil.pushJqxArticleMessage(title, content, PushMessageEnum.LEADS.getMobile(), businessId, userList);
        String contentUnify = "\u3010\u7ebf\u7d22\u5408\u5e76\u3011" + content;
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + PushMessageEnum.LEADS.getUnify() + "\"" + businessId + "\"";
        addSysMessageType.setBusinessAddress(unifyWebUrl);
        LocalDateTime date = LocalDateTime.now();
        UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIds, user.getUserName(), unifyWebUrl, "");
        UnifyUtil.sendMessage(addSysMessageType);
        return true;
    }

    private void putCheckedPropertyLeadsInfo(Long primaryLeadsId, List<CheckedPropertyLeadsInfo> checkedPropertyLeadsInfoList, List<LeadsMergeVo> leadsMergeVoList) {
        Leads primaryLeads = (Leads)this.leadsService.getById(primaryLeadsId);
        Map<String, List<CheckedPropertyLeadsInfo>> checkedPropertyLeadsInfoMap = checkedPropertyLeadsInfoList.stream().collect(Collectors.groupingBy(CheckedPropertyLeadsInfo::getValue));
        List leadsId = leadsMergeVoList.stream().map(LeadsMergeVo::getLeadsId).collect(Collectors.toList());
        long trackRecordCount = this.trackRecordAPIService.countTrackRecordByTypeIds(leadsId);
        CheckedPropertyLeadsInfo stateInfo = new CheckedPropertyLeadsInfo();
        stateInfo.setLabel("stateLabel");
        stateInfo.setValue("state");
        stateInfo.setLeadsId(primaryLeadsId);
        List<CheckedPropertyLeadsInfo> transCustomerList = checkedPropertyLeadsInfoMap.get("transformationCustomerId");
        List<CheckedPropertyLeadsInfo> transOpportunityList = checkedPropertyLeadsInfoMap.get("transformationOpportunityId");
        if (ToolUtil.isNotEmpty((Object)transCustomerList.get(0).getResultValue()) && CollectionUtil.isNotEmpty((Object)transOpportunityList.get(0).getResultValue())) {
            stateInfo.setResultValue(LeadsEditConstant.LEADS_STATE_CHANGE.getField());
            stateInfo.setResultLabel(LeadsEditConstant.LEADS_STATE_CHANGE.getName());
        } else if (CollectionUtil.isNotEmpty((Object)transCustomerList.get(0).getResultValue())) {
            stateInfo.setResultValue(LeadsEditConstant.LEADS_STATE_CLOSE.getField());
            stateInfo.setResultLabel(LeadsEditConstant.LEADS_STATE_CLOSE.getName());
        } else if (LeadsEditConstant.LEADS_STATE_ABANDON.getField().equals(primaryLeads.getState())) {
            stateInfo.setResultValue(LeadsEditConstant.LEADS_STATE_ABANDON.getField());
            stateInfo.setResultLabel(LeadsEditConstant.LEADS_STATE_ABANDON.getName());
        } else if (trackRecordCount > 0L) {
            stateInfo.setResultValue(LeadsEditConstant.LEADS_STATE_FOLLOWING.getField());
            stateInfo.setResultLabel(LeadsEditConstant.LEADS_STATE_FOLLOWING.getName());
        } else {
            stateInfo.setResultValue(LeadsEditConstant.LEADS_STATE_UNPROCESSED.getField());
            stateInfo.setResultLabel(LeadsEditConstant.LEADS_STATE_UNPROCESSED.getName());
        }
        checkedPropertyLeadsInfoList.add(stateInfo);
        CheckedPropertyLeadsInfo partner = new CheckedPropertyLeadsInfo();
        partner.setLabel("partner");
        partner.setValue("partnerName");
        partner.setLeadsId(primaryLeadsId);
        partner.setResultLabel(primaryLeads.getPartnerName());
        String partnerId = null;
        if (ToolUtil.isNotEmpty(partnerId)) {
            partnerId = String.valueOf(primaryLeads.getPartner());
        }
        partner.setResultValue(partnerId);
        checkedPropertyLeadsInfoList.add(partner);
        CheckedPropertyLeadsInfo createPersonInfo = checkedPropertyLeadsInfoMap.get("createPerson").get(0);
        Leads createtLeads = primaryLeads;
        if (primaryLeadsId.equals(createPersonInfo.getLeadsId())) {
            createtLeads = (Leads)this.leadsService.getById(createPersonInfo.getLeadsId());
        }
        CheckedPropertyLeadsInfo createUnit = new CheckedPropertyLeadsInfo();
        createUnit.setLabel("createUnitName");
        createUnit.setValue("createUnit");
        createUnit.setLeadsId(createtLeads.getLeadsId());
        createUnit.setResultLabel(createtLeads.getCreateUnitName());
        createUnit.setResultValue(String.valueOf(createtLeads.getCreateUnit()));
        checkedPropertyLeadsInfoList.add(createUnit);
        CheckedPropertyLeadsInfo chargePersonInfo = checkedPropertyLeadsInfoMap.get("chargePersonId").get(0);
        Leads chargeLeads = primaryLeads;
        if (primaryLeadsId.equals(chargePersonInfo.getLeadsId())) {
            chargeLeads = (Leads)this.leadsService.getById(chargePersonInfo.getLeadsId());
        }
        CheckedPropertyLeadsInfo ownUnit = new CheckedPropertyLeadsInfo();
        ownUnit.setLabel("ownUnitName");
        ownUnit.setValue("ownUnit");
        ownUnit.setLeadsId(chargeLeads.getLeadsId());
        ownUnit.setResultLabel(chargeLeads.getOwnUnitName());
        ownUnit.setResultValue(String.valueOf(chargeLeads.getOwnUnit()));
        checkedPropertyLeadsInfoList.add(ownUnit);
        CheckedPropertyLeadsInfo abandonedReason = new CheckedPropertyLeadsInfo();
        abandonedReason.setLabel("abandonedReasonLabel");
        abandonedReason.setValue("abandonedReason");
        abandonedReason.setLeadsId(primaryLeadsId);
        String abandonedReasonLabel = null;
        if (StringUtil.isNotBlank((CharSequence)primaryLeads.getAbandonedPeason())) {
            abandonedReasonLabel = this.sysDicRefService.getDictLabel("abandon_reason", primaryLeads.getAbandonedPeason());
        }
        abandonedReason.setResultLabel(abandonedReasonLabel);
        abandonedReason.setResultValue(primaryLeads.getAbandonedPeason());
        checkedPropertyLeadsInfoList.add(abandonedReason);
        CheckedPropertyLeadsInfo abandonedDescribe = new CheckedPropertyLeadsInfo();
        abandonedDescribe.setLabel("abandonedDescribe");
        abandonedDescribe.setValue("abandonedDescribe");
        abandonedDescribe.setLeadsId(primaryLeadsId);
        abandonedReason.setResultLabel(primaryLeads.getAbandonedDescribe());
        abandonedReason.setResultValue(primaryLeads.getAbandonedDescribe());
        checkedPropertyLeadsInfoList.add(abandonedDescribe);
        CheckedPropertyLeadsInfo originLeads = new CheckedPropertyLeadsInfo();
        originLeads.setLabel("originLeads");
        originLeads.setValue("originLeads");
        originLeads.setLeadsId(primaryLeadsId);
        originLeads.setResultLabel(String.valueOf(primaryLeads.getOriginLeads()));
        originLeads.setResultValue(String.valueOf(primaryLeads.getOriginLeads()));
        checkedPropertyLeadsInfoList.add(originLeads);
        CheckedPropertyLeadsInfo claimType = new CheckedPropertyLeadsInfo();
        claimType.setLabel("claimType");
        claimType.setValue("claimType");
        claimType.setLeadsId(primaryLeadsId);
        claimType.setResultLabel(primaryLeads.getClaimType());
        claimType.setResultValue(primaryLeads.getClaimType());
        checkedPropertyLeadsInfoList.add(claimType);
        CheckedPropertyLeadsInfo claimPerson = new CheckedPropertyLeadsInfo();
        claimPerson.setLabel("claimPersonName");
        claimPerson.setValue("claimPerson");
        claimPerson.setLeadsId(primaryLeadsId);
        claimPerson.setResultLabel(primaryLeads.getClaimPersonName());
        claimPerson.setResultValue(String.valueOf(primaryLeads.getClaimPerson()));
        checkedPropertyLeadsInfoList.add(claimPerson);
        CheckedPropertyLeadsInfo claimTimeInfo = new CheckedPropertyLeadsInfo();
        claimTimeInfo.setLabel("claimTime");
        claimTimeInfo.setValue("claimTime");
        claimTimeInfo.setLeadsId(primaryLeadsId);
        String claimTimeToString = null;
        LocalDateTime claimTime = primaryLeads.getClaimTime();
        if (ToolUtil.isNotEmpty((Object)claimTime)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            claimTimeToString = claimTime.format(formatter);
        }
        claimTimeInfo.setResultLabel(claimTimeToString);
        claimTimeInfo.setResultValue(claimTimeToString);
        checkedPropertyLeadsInfoList.add(claimTimeInfo);
        CheckedPropertyLeadsInfo highSeas = new CheckedPropertyLeadsInfo();
        highSeas.setLabel("highSeasId");
        highSeas.setValue("highSeasId");
        highSeas.setLeadsId(primaryLeadsId);
        highSeas.setResultLabel(primaryLeads.getHighSeasId());
        highSeas.setResultValue(primaryLeads.getHighSeasId());
        checkedPropertyLeadsInfoList.add(highSeas);
        CheckedPropertyLeadsInfo putSeasReasons = new CheckedPropertyLeadsInfo();
        putSeasReasons.setLabel("putSeasReasons");
        putSeasReasons.setValue("putSeasReasons");
        putSeasReasons.setLeadsId(primaryLeadsId);
        putSeasReasons.setResultLabel(primaryLeads.getPutSeasReasons());
        putSeasReasons.setResultValue(primaryLeads.getPutSeasReasons());
        checkedPropertyLeadsInfoList.add(putSeasReasons);
        CheckedPropertyLeadsInfo putSeasReasonsDetails = new CheckedPropertyLeadsInfo();
        putSeasReasonsDetails.setLabel("putSeasReasonsDetails");
        putSeasReasonsDetails.setValue("putSeasReasonsDetails");
        putSeasReasonsDetails.setLeadsId(primaryLeadsId);
        putSeasReasonsDetails.setResultLabel(primaryLeads.getPutSeasReasonsDetails());
        putSeasReasonsDetails.setResultValue(primaryLeads.getPutSeasReasonsDetails());
        checkedPropertyLeadsInfoList.add(putSeasReasonsDetails);
        CheckedPropertyLeadsInfo customerIdInfo = new CheckedPropertyLeadsInfo();
        customerIdInfo.setLabel("customerId");
        customerIdInfo.setValue("customerId");
        customerIdInfo.setLeadsId(primaryLeadsId);
        customerIdInfo.setResultLabel(String.valueOf(primaryLeads.getCustomerId()));
        customerIdInfo.setResultValue(String.valueOf(primaryLeads.getCustomerId()));
        checkedPropertyLeadsInfoList.add(customerIdInfo);
        CheckedPropertyLeadsInfo orderNumberInfo = new CheckedPropertyLeadsInfo();
        orderNumberInfo.setLabel("orderNumber");
        orderNumberInfo.setValue("orderNumber");
        orderNumberInfo.setLeadsId(primaryLeadsId);
        orderNumberInfo.setResultLabel(String.valueOf(primaryLeads.getOrderNumber()));
        orderNumberInfo.setResultValue(String.valueOf(primaryLeads.getOrderNumber()));
        checkedPropertyLeadsInfoList.add(orderNumberInfo);
    }

    private Map<String, Map<String, String>> checkedPropertyToMap(List<CheckedPropertyLeadsInfo> checkedPropertyLeadsInfoList, Map<String, Object> leadsMap) {
        HashMap<String, Map<String, String>> checkedPropertyMap = new HashMap<String, Map<String, String>>();
        for (CheckedPropertyLeadsInfo checkedPropertyLeadsInfo : checkedPropertyLeadsInfoList) {
            String value = checkedPropertyLeadsInfo.getValue();
            if ("labelList".equals(value) || "teamNumberList".equals(value)) {
                List<Map<String, Object>> resultList = checkedPropertyLeadsInfo.getResult();
                for (Map<String, Object> result : resultList) {
                    String leadsId = result.get("leadsId").toString();
                    String valueList = result.get("value").toString();
                    HashMap<String, String> checkedPropertyLeadsMap = (HashMap<String, String>)checkedPropertyMap.get(leadsId);
                    if (CollectionUtil.isEmpty((Map)checkedPropertyLeadsMap)) {
                        checkedPropertyLeadsMap = new HashMap<String, String>();
                    }
                    checkedPropertyLeadsMap.put(value, valueList);
                    if ("labelList".equals(value)) {
                        Object labelIdValue = leadsMap.get("labelId");
                        if (ToolUtil.isNotEmpty((Object)labelIdValue)) {
                            valueList = labelIdValue + "," + valueList;
                        }
                        leadsMap.put("labelId", valueList);
                        checkedPropertyLeadsMap.put("labelId", valueList);
                    }
                    if ("teamNumberList".equals(value)) {
                        checkedPropertyLeadsMap.put("teamMember", valueList);
                    }
                    checkedPropertyMap.put(leadsId, checkedPropertyLeadsMap);
                }
                continue;
            }
            String leadsId = checkedPropertyLeadsInfo.getLeadsId().toString();
            HashMap<String, String> checkedPropertyByLeadsMap = (HashMap<String, String>)checkedPropertyMap.get(leadsId);
            if (CollectionUtil.isEmpty((Map)checkedPropertyByLeadsMap)) {
                checkedPropertyByLeadsMap = new HashMap<String, String>();
            }
            String label = checkedPropertyLeadsInfo.getLabel();
            String resultValue = checkedPropertyLeadsInfo.getResultValue();
            String resultLabel = checkedPropertyLeadsInfo.getResultLabel();
            if (StringUtil.isNotEmpty((Object)value)) {
                checkedPropertyByLeadsMap.put(value, resultValue);
                if ("checkedPersonId".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    leadsMap.put(value, Long.valueOf(resultValue));
                } else if ("campaignId".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    leadsMap.put(value, Long.valueOf(resultValue));
                } else if ("ownDepartment".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    leadsMap.put(value, Long.valueOf(resultValue));
                } else if ("region".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    String[] region = resultValue.split("/");
                    if (region.length > 0) {
                        leadsMap.put("province", region[0]);
                        if (region.length > 1) {
                            leadsMap.put("city", region[1]);
                            if (region.length > 2) {
                                leadsMap.put("county", region[2]);
                            }
                        }
                    }
                } else {
                    leadsMap.put(value, resultValue);
                }
            }
            if (StringUtil.isNotEmpty((Object)label)) {
                checkedPropertyByLeadsMap.put(label, resultLabel);
                leadsMap.put(label, resultLabel);
            }
            checkedPropertyMap.put(leadsId, checkedPropertyByLeadsMap);
        }
        Object labelIds = leadsMap.get("labelId");
        if (ToolUtil.isNotEmpty((Object)labelIds)) {
            List labelIdList = Arrays.stream(String.valueOf(labelIds).split(",")).distinct().collect(Collectors.toList());
            String labelIdToString = StringUtil.join(labelIdList, (String)",");
            leadsMap.put("labelId", labelIdToString);
        }
        return checkedPropertyMap;
    }

    private String getRelationIds(Map<String, List<LeadsRelationInfoVo>> relationMap, long leadsId) {
        List<LeadsRelationInfoVo> relationList = relationMap.get(leadsId + "");
        if (CollectionUtil.isNotEmpty(relationList)) {
            List relationIdList = relationList.stream().map(LeadsRelationInfoVo::getRelationId).collect(Collectors.toList());
            return JSONObject.toJSONString(relationIdList);
        }
        return null;
    }

    private void makeLeadsMergeInfo(LeadsMergeVo leadsMergeVo, Map<String, String> checkedProperyByLeadsMap, LeadsMergeInfo leadsMergeInfo, List<Map<String, Object>> checkedTeamMember) throws IllegalAccessException {
        Field[] fields;
        Long ownDepartment;
        Long campaignId;
        BeanUtil.copyProperties((Object)leadsMergeVo, (Object)leadsMergeInfo);
        Long chargePersonId = leadsMergeVo.getChargePersonId();
        if (chargePersonId != null && chargePersonId > 0L) {
            leadsMergeInfo.setChargePersonId(String.valueOf(chargePersonId));
        }
        if ((campaignId = leadsMergeVo.getCampaignId()) != null && campaignId > 0L) {
            leadsMergeInfo.setCampaignId(String.valueOf(campaignId));
        }
        if ((ownDepartment = leadsMergeVo.getOwnDepartment()) != null && ownDepartment > 0L) {
            leadsMergeInfo.setOwnDepartment(String.valueOf(ownDepartment));
        }
        Class<?> clazz = leadsMergeInfo.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            String value = checkedProperyByLeadsMap.get(fieldName);
            if ("mergeInfoId".equals(fieldName) || "mergeRecordId".equals(fieldName) || "leadsId".equals(fieldName)) continue;
            if ("labelId".equals(fieldName)) {
                List<Map<String, Object>> labelList = leadsMergeVo.getLabelList();
                String labelValue = this.getMultipleChoiceValue(labelList, value, null);
                field.set(leadsMergeInfo, labelValue);
                continue;
            }
            if ("teamMember".equals(fieldName)) {
                List<Map<String, Object>> teamNumberList = leadsMergeVo.getTeamNumberList();
                String teamMemberValue = this.getMultipleChoiceValue(teamNumberList, value, checkedTeamMember);
                field.set(leadsMergeInfo, teamMemberValue);
                continue;
            }
            HashMap<String, String> properyMap = new HashMap<String, String>();
            switch (fieldName) {
                case "trade": {
                    properyMap.put("label", leadsMergeVo.getTradeLabel());
                    break;
                }
                case "sex": {
                    properyMap.put("label", leadsMergeVo.getSexLabel());
                    break;
                }
                case "levelNew": {
                    properyMap.put("label", leadsMergeVo.getLevelNewLabel());
                    break;
                }
                case "leadsOrigin": {
                    properyMap.put("label", leadsMergeVo.getLeadsOriginLabel());
                }
            }
            if (checkedProperyByLeadsMap.containsKey(fieldName)) {
                properyMap.put("value", value);
                properyMap.put("checked", "1");
            } else {
                if (fieldName.startsWith("old")) continue;
                properyMap.put("checked", "0");
                properyMap.put("value", field.get(leadsMergeInfo) == null ? null : field.get(leadsMergeInfo).toString());
            }
            properyMap.put("isRadio", "1");
            String propertyValue = JSONObject.toJSONString(properyMap);
            field.set(leadsMergeInfo, propertyValue);
        }
    }

    private String getMultipleChoiceValue(List<Map<String, Object>> multipleChoiceList, String value, List<Map<String, Object>> checkedTeamMember) {
        List checkedList = null;
        if (StringUtil.isNotEmpty((Object)value)) {
            checkedList = Arrays.stream(value.split(",")).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(multipleChoiceList)) {
            for (Map<String, Object> labelMap : multipleChoiceList) {
                String multipleChoiceValue = labelMap.get("value").toString();
                if (checkedList != null && CollectionUtil.isNotEmpty(checkedList) && checkedList.contains(multipleChoiceValue)) {
                    if (checkedTeamMember != null) {
                        checkedTeamMember.add(labelMap);
                    }
                    labelMap.put("checked", "1");
                } else {
                    labelMap.put("checked", "0");
                }
                labelMap.put("isRadio", "0");
            }
        }
        return JSONObject.toJSONString(multipleChoiceList);
    }

    private void updateTeamMemberInfo(List<Map<String, Object>> checkedTeamMember, Long primaryLeadsId, String primaryChargePersonId, List<Long> deleteLeadsIdList) {
        Map<String, List<Map>> checkedTeamMemberMap = checkedTeamMember.stream().collect(Collectors.groupingBy(teamMember -> teamMember.get("personId").toString()));
        ArrayList<Long> teamMemberIdList = new ArrayList<Long>();
        ArrayList<TeamMeberEntity> teamMemberEntityList = new ArrayList<TeamMeberEntity>();
        for (String personId : checkedTeamMemberMap.keySet()) {
            String modifyPower;
            TeamMeberEntity teamMeberEntity;
            List<Map> checkedTeamMemberList = checkedTeamMemberMap.get(personId);
            if (personId.equals(primaryChargePersonId)) {
                teamMeberEntity = new TeamMeberEntity();
                if (CollectionUtil.isEmpty(checkedTeamMemberList)) {
                    throw new HussarCoreException("\u56e2\u961f\u6210\u5458\u4e2d\u5e94\u8be5\u5305\u542b\u8d1f\u8d23\u4eba\u4fe1\u606f");
                }
                Map chargePersonTeamMember = checkedTeamMemberList.get(0);
                if (checkedTeamMemberList.size() > 1) {
                    for (Map teamMemberMap : checkedTeamMemberList) {
                        if (!"1".equals(teamMemberMap.get("isCharge").toString())) continue;
                        chargePersonTeamMember = teamMemberMap;
                        break;
                    }
                }
                Long teamMemberId = Long.parseLong(chargePersonTeamMember.get("value").toString());
                teamMeberEntity.setTeamMeberId(teamMemberId);
                teamMeberEntity.setBusinessId(primaryLeadsId);
                teamMemberEntityList.add(teamMeberEntity);
                teamMemberIdList.add(teamMemberId);
                continue;
            }
            teamMeberEntity = new TeamMeberEntity();
            Map teamMember2 = checkedTeamMemberList.get(0);
            try {
                modifyPower = teamMember2.get("modifyPower").toString();
            }
            catch (Exception e) {
                modifyPower = "0";
            }
            if (CollectionUtil.isNotEmpty(checkedTeamMemberList)) {
                for (Map teamMemberMap : checkedTeamMemberList) {
                    String thisModifyPower;
                    if ("1".equals(teamMemberMap.get("isCharge").toString())) {
                        teamMember2 = teamMemberMap;
                        teamMeberEntity.setModifyPower("1");
                        teamMeberEntity.setIsCharge("0");
                        teamMeberEntity.setMemberRole("6");
                        break;
                    }
                    try {
                        thisModifyPower = teamMemberMap.get("modifyPower").toString();
                    }
                    catch (Exception e) {
                        thisModifyPower = "0";
                    }
                    if (thisModifyPower.equals(modifyPower) || !"1".equals(thisModifyPower)) continue;
                    teamMember2 = teamMemberMap;
                }
            }
            Long teamMemberId = Long.parseLong(teamMember2.get("value").toString());
            teamMeberEntity.setTeamMeberId(teamMemberId);
            teamMeberEntity.setBusinessId(primaryLeadsId);
            teamMemberEntityList.add(teamMeberEntity);
            teamMemberIdList.add(teamMemberId);
        }
        this.leadsMergeMapper.updateTeamMemberRelationId(deleteLeadsIdList, primaryLeadsId);
        this.teamMeberService.updateBatchById(teamMemberEntityList);
        if (CollectionUtil.isNotEmpty(teamMemberIdList)) {
            this.leadsMergeMapper.deleteNoCheckedTeamMember(teamMemberIdList, primaryLeadsId);
        }
    }
}

