/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.index.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.trackrecord.dto.TrackRecordAPIDto;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.service.CrmIndexService;
import com.jxdinfo.crm.core.index.vo.AllTypesVo;
import com.jxdinfo.crm.core.index.vo.MobileResourceModuleVo;
import com.jxdinfo.crm.core.index.vo.RecordCountVo;
import com.jxdinfo.crm.core.index.vo.SalesBigCustomerCountVo;
import com.jxdinfo.crm.core.index.vo.SalesFunnelVo;
import com.jxdinfo.crm.core.index.vo.SalesIncreaseVo;
import com.jxdinfo.crm.core.index.vo.SalesProductVo;
import com.jxdinfo.crm.core.index.vo.SalesRecordCountVo;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityEntityVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/crm/index"})
@Api(tags={"\u9996\u9875"})
public class CrmIndexController {
    @Resource
    private CrmIndexService indexService;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    @GetMapping(value={"menu"})
    @ApiOperation(value="\u79fb\u52a8\u7aef\u83dc\u5355", notes="\u79fb\u52a8\u7aef\u83dc\u5355")
    public ApiResponse<List<MobileResourceModuleVo>> menu() {
        return ApiResponse.success(this.indexService.getMobileMenu());
    }

    @PostMapping(value={"selectTodayList"})
    public ApiResponse<Page<TrackRecordAPIVo>> selectTodayList(@RequestBody TrackRecordAPIDto recordDto) {
        if (recordDto.getNextTime() == null) {
            return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
        }
        return ApiResponse.success(this.indexService.selectTodayList(recordDto));
    }

    @PostMapping(value={"selectRecordAndTaskCountList"})
    public ApiResponse<List<RecordCountVo>> selectRecordAndTaskCountList(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.selectRecordAndTaskCountList(dto));
    }

    @PostMapping(value={"increase"})
    public ApiResponse<SalesIncreaseVo> increaseCount(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success((Object)this.indexService.increaseCount(dto));
    }

    @PostMapping(value={"increase/customer"})
    public ApiResponse<Page<CustomerEntity>> increaseCustomer(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.increaseCustomer(dto));
    }

    @PostMapping(value={"increase/contact"})
    public ApiResponse<Page<ContactEntity>> increaseContact(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.increaseContact(dto));
    }

    @PostMapping(value={"increase/leads"})
    public ApiResponse<Page<Leads>> increaseLeads(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.increaseLeads(dto));
    }

    @PostMapping(value={"increase/converLeads"})
    public ApiResponse<Page<Leads>> increaseConverLeads(@RequestBody SalesStatisticsDto dto) {
        dto.setLeadsState("4");
        return ApiResponse.success(this.indexService.increaseLeads(dto));
    }

    @PostMapping(value={"increase/opportunity"})
    public ApiResponse<Page<OpportunityEntity>> increaseOpportunity(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.increaseOpportunity(dto));
    }

    @PostMapping(value={"increase/winOpportunity"})
    public ApiResponse<Page<OpportunityEntity>> increaseWinOpportunity(@RequestBody SalesStatisticsDto dto) {
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        dto.setWinStateIds(this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin());
        return ApiResponse.success(this.indexService.increaseOpportunity(dto));
    }

    @PostMapping(value={"increase/record"})
    public ApiResponse<Page<TrackRecordAPIVo>> increaseRecord(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.increaseRecord(dto));
    }

    @PostMapping(value={"increase/record/count"})
    public ApiResponse<List<SalesRecordCountVo>> recordCount(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.recordCount(dto));
    }

    @PostMapping(value={"increase/opportunityProduct"})
    public ApiResponse<Page<OpportunityEntityVo>> increaseOpportunityProduct(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.increaseOpportunityProduct(dto));
    }

    @PostMapping(value={"funnel"})
    public ApiResponse<List<SalesFunnelVo>> funnelCount(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.funnelCount(dto));
    }

    @PostMapping(value={"bigCustomer"})
    public ApiResponse<SalesBigCustomerCountVo> bigCustomerCount(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success((Object)this.indexService.bigCustomerCount(dto));
    }

    @PostMapping(value={"product"})
    public ApiResponse<List<SalesProductVo>> productCount(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.productCount(dto));
    }

    @PostMapping(value={"record/visiting"})
    public ApiResponse<Page<TrackRecordAPIVo>> recordList(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.indexService.recordList(dto));
    }

    @PostMapping(value={"/selectAllTypes"})
    public ApiResponse<AllTypesVo> selectAllTypes(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success((Object)this.indexService.selectAllTypes(dto));
    }
}

