/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.agent.api.service.IAgentDataRightModuleService;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.customer.dto.CustomerAPIDto;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.service.ICustomerDataRightModuleService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityDataRightModuleService;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryDto;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.dao.CustomerPermissionMapper;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.dto.YyzcCustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.model.CustomerIncludePool;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerIncludePoolService;
import com.jxdinfo.crm.core.customer.service.ICustomerPermissionService;
import com.jxdinfo.crm.core.customer.vo.YyzcCustomerVo;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.model.PoolCustomerEntity;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.service.IPoolCustomerService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerAPIServiceImpl
implements ICustomerAPIService {
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private CustomerService customerService;
    @Resource
    private ICustomerIncludePoolService customerIncludePoolService;
    @Resource
    private IUserBoService userBoService;
    @Resource
    private ICustomerPermissionService customerPermissionService;
    @Resource
    private CustomerPermissionMapper customerPermissionMapper;
    @Resource
    private IPoolCustomerService poolCustomerService;
    @Resource
    private ICustomerDataRightModuleService customerDataRightModuleService;
    @Resource
    private IMarketingActivityDataRightModuleService marketingActivityDataRightModuleService;
    @Resource
    private IAgentDataRightModuleService agentDataRightModuleService;

    public Page<CustomerAPIVo> getCustomerPageList(CustomerAPIDto dto) {
        CustomerDto customerDto = new CustomerDto();
        customerDto.setCurrent(dto.getCurrent());
        customerDto.setSize(dto.getSize());
        customerDto.setCustomerScreening(dto.getCustomerScreening());
        Page<CustomerEntity> customerEntityPage = this.customerService.selectCustomerList(customerDto);
        return (Page)BeanUtil.copy(customerEntityPage, Page.class);
    }

    public List<CustomerAPIVo> getCustomerList(CustomerAPIDto dto) {
        CustomerDto customerDto = new CustomerDto();
        customerDto.setCurrent(dto.getCurrent());
        customerDto.setSize(dto.getSize());
        customerDto.setCustomerScreening(dto.getCustomerScreening());
        List<CustomerEntity> customerEntityList = this.customerService.selectCustomerListNoPage(customerDto);
        ArrayList<CustomerAPIVo> customerAPIVoList = new ArrayList<CustomerAPIVo>();
        for (CustomerEntity customerEntity : customerEntityList) {
            CustomerAPIVo customerAPIVo = new CustomerAPIVo();
            BeanUtil.copyProperties((Object)customerEntity, (Object)customerAPIVo);
            customerAPIVoList.add(customerAPIVo);
        }
        return customerAPIVoList;
    }

    public List<CustomerAPIVo> getCustomerListByIds(List<Long> idList) {
        return BeanUtil.copy((Collection)this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CustomerEntity::getCustomerId, idList)).eq(CustomerEntity::getDelFlag, (Object)"0")), CustomerAPIVo.class);
    }

    public ApiResponse<Object> selectCustomerListByPermission(Map<String, Object> body) {
        Long userId = null;
        if (!HussarUtils.isNotEmpty((Object)body.get("userId"))) {
            return null;
        }
        userId = HussarUtils.toLong((Object)body.get("userId"));
        SecurityUser user = this.userBoService.selectSecurityByUserId(userId);
        if (user == null) {
            return null;
        }
        long current = HussarUtils.toLong((Object)body.get("current"));
        long size = HussarUtils.toLong((Object)body.get("size"));
        PermissionDto customerPermissionDto = this.customerDataRightModuleService.getUserRolePermission(user);
        PermissionDto campaignPermissionDto = this.customerDataRightModuleService.getUserRolePermission(user);
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        String name = HussarUtils.toStr((Object)body.get("name"));
        name = name.replaceAll("%", "/%").replaceAll("_", "/_");
        Page<CustomerAPIVo> customerAPIVoList = this.customerMapper.selectIdAndNameByPermission((Page<CustomerAPIVo>)page, customerPermissionDto, campaignPermissionDto, name);
        return ApiResponse.success(customerAPIVoList);
    }

    public CustomerAPIVo selectOne(Long id) {
        CustomerEntity customer = (CustomerEntity)this.customerMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerId, (Object)id)).eq(CustomerEntity::getDelFlag, (Object)"0"));
        return (CustomerAPIVo)BeanUtil.copy((Object)customer, CustomerAPIVo.class);
    }

    public List<CustomerAPIVo> selectList(Long convertId) {
        List customerList = this.customerMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerId, (Object)convertId)).eq(CustomerEntity::getDelFlag, (Object)"0"));
        return BeanUtil.copy((Collection)customerList, CustomerAPIVo.class);
    }

    public CustomerAPIVo selectById(Long typeId) {
        return (CustomerAPIVo)BeanUtil.copy((Object)this.customerMapper.selectById(typeId), CustomerAPIVo.class);
    }

    public void updateById(CustomerAPIVo customerEntity) {
        CustomerEntity customer = (CustomerEntity)this.customerService.getById(customerEntity.getCustomerId());
        if (customer != null) {
            this.customerService.updateById(BeanUtil.copy((Object)customerEntity, CustomerEntity.class));
        } else {
            PoolCustomerEntity poolCustomer = (PoolCustomerEntity)this.poolCustomerService.getById(customerEntity.getCustomerId());
            if (poolCustomer != null) {
                this.poolCustomerService.updateById(BeanUtil.copy((Object)customerEntity, PoolCustomerEntity.class));
            }
        }
    }

    public List<CustomerAPIVo> selectCustomerByNameNoPermission(List<String> customerNameList, LocalDateTime createTimeStart, LocalDateTime createTimeEnd) {
        if (CollectionUtil.isEmpty(customerNameList)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getDelFlag, (Object)"0")).in(CustomerEntity::getCustomerName, customerNameList)).orderByAsc(CustomerEntity::getCreateTime);
        if (createTimeEnd != null) {
            queryWrapper.lt(CustomerEntity::getCreateTime, (Object)createTimeEnd);
        }
        if (createTimeStart != null) {
            queryWrapper.gt(CustomerEntity::getCreateTime, (Object)createTimeStart);
        }
        List list = this.customerIncludePoolService.list((Wrapper)queryWrapper);
        HashMap<String, CustomerIncludePool> map = new HashMap<String, CustomerIncludePool>();
        for (CustomerIncludePool entity : list) {
            map.putIfAbsent(entity.getCustomerName(), entity);
        }
        return BeanUtil.copy((Collection)CollectionUtil.toList(map.values()), CustomerAPIVo.class);
    }

    public List<CustomerAPIVo> selectCustomerByIdNoPermission(List<Long> customerIdList) {
        if (CollectionUtil.isEmpty(customerIdList)) {
            return null;
        }
        List list = this.customerIncludePoolService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getDelFlag, (Object)"0")).in(CustomerEntity::getCustomerId, customerIdList));
        return BeanUtil.copy((Collection)list, CustomerAPIVo.class);
    }

    public Map<Long, Boolean> queryPermissionByCustomerIds(List<Long> customerIdList) {
        if (CollectionUtil.isEmpty(customerIdList)) {
            return null;
        }
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        List customerEntityList = this.customerIncludePoolService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getDelFlag, (Object)"0")).in(CustomerEntity::getCustomerId, customerIdList));
        for (CustomerIncludePool entity : customerEntityList) {
            map.put(entity.getCustomerId(), this.customerService.isOperate(entity.getCustomerId()).getViewOperate());
        }
        return map;
    }

    public List<CustomerAPIVo> selectCustomerByNameAndTel(String customerName, String telephoneNumber) {
        return this.customerService.selectCustomerByNameAndTel(customerName, telephoneNumber);
    }

    public List<Long> getCustomerIdList(Long userId) {
        return this.customerPermissionService.getCustomerIdListByPermission(userId);
    }

    public List<Long> getCustomerIdList() {
        return this.customerPermissionService.getCustomerIdListByPermission(null);
    }

    public void updateAiTags(List<Map<String, Object>> aiTagMapList) {
        this.customerService.updateAiTags(aiTagMapList);
    }

    public List<Long> selectCustomerByOpportunity(OpportunityQueryDto dto) {
        return this.customerService.selectCustomerByOpportunity(dto);
    }

    public List<Long> getAllCustomerList() {
        return this.customerPermissionMapper.getCustomerIdList(null, null);
    }

    public List<CustomerAPIVo> selectCustomerTradeList() {
        return this.customerMapper.selectCustomerTradeList();
    }

    public ApiResponse<Object> selectCustomerAndAgentListByPermission(Map<String, Object> body) {
        YyzcCustomerDto dto = (YyzcCustomerDto)BeanUtil.copy(body, YyzcCustomerDto.class);
        if (!ToolUtil.isNotEmpty((Object)dto.getUserId())) {
            throw new BaseException("\u65e0\u6743\u9650");
        }
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        SecurityUser user2 = commonMapper.selectSecurityByUserId(Long.valueOf(dto.getUserId()));
        PermissionDto customerPermissionDto = this.customerDataRightModuleService.getUserRolePermission(user2);
        PermissionDto campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user2);
        PermissionDto agentPermissionDto = this.agentDataRightModuleService.getUserRolePermission(user2);
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        page.setMaxLimit(Long.valueOf(-1L));
        List<YyzcCustomerVo> list = this.customerMapper.selectCustomerAndAgentListForNoCode(dto, (Page<YyzcCustomerVo>)page, customerPermissionDto, campaignPermissionDto, agentPermissionDto);
        page.setRecords(list);
        return ApiResponse.success((Object)page);
    }
}

