/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.contact.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.contact.dto.ContactAPIDto;
import com.jxdinfo.crm.core.api.contact.service.IContactAPIService;
import com.jxdinfo.crm.core.api.contact.service.IContactDataRightModuleService;
import com.jxdinfo.crm.core.api.contact.vo.ContactAPIVo;
import com.jxdinfo.crm.core.contact.dao.ContactMapper;
import com.jxdinfo.crm.core.contact.dto.ContactDto;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.contact.service.IContactPermissionService;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ContactApiServiceImpl
implements IContactAPIService {
    @Resource
    private ContactMapper contactMapper;
    @Resource
    private ContactService contactService;
    @Resource
    private IContactPermissionService contactPermissionService;
    @Resource
    private IContactDataRightModuleService contactDataRightModuleService;
    @Resource
    private CustomerService customerService;
    @Resource
    private IAgentApiService agentApiService;

    public ApiResponse<Object> selectContactListByPermission(Map<String, Object> body) {
        Long userId = null;
        if (!HussarUtils.isNotEmpty((Object)body.get("userId"))) {
            return null;
        }
        userId = HussarUtils.toLong((Object)body.get("userId"));
        IUserBoService userBoService = (IUserBoService)SpringUtils.getBean(IUserBoService.class);
        SecurityUser user = userBoService.selectSecurityByUserId(userId);
        if (user == null) {
            return null;
        }
        long current = HussarUtils.toLong((Object)body.get("current"));
        long size = HussarUtils.toLong((Object)body.get("size"));
        PermissionDto permissionDto = this.contactOperate(user);
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        String name = HussarUtils.toStr((Object)body.get("name"));
        name = name.replaceAll("%", "/%").replaceAll("_", "/_");
        Page<ContactAPIVo> contactAPIVoList = this.contactMapper.selectIdAndNameByPermission((Page<ContactAPIVo>)page, permissionDto, name, null);
        return ApiResponse.success(contactAPIVoList);
    }

    public ContactAPIVo selectOne(Long id) {
        ContactEntity contact = (ContactEntity)this.contactMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getContactId, (Object)id)).eq(ContactEntity::getDelFlag, (Object)"0"));
        return (ContactAPIVo)BeanUtil.copy((Object)contact, ContactAPIVo.class);
    }

    public List<ContactAPIVo> selectList(List<Long> ids) {
        List contactList = this.contactMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactEntity::getContactId, ids)).eq(ContactEntity::getDelFlag, (Object)"0"));
        return BeanUtil.copy((Collection)contactList, ContactAPIVo.class);
    }

    public ContactAPIVo getById(Long typeId) {
        return (ContactAPIVo)BeanUtil.copy((Object)this.contactService.getById(typeId), ContactAPIVo.class);
    }

    public void updateById(ContactAPIVo contactEntity) {
        this.contactService.updateById(BeanUtil.copy((Object)contactEntity, ContactEntity.class));
    }

    private PermissionDto contactOperate(SecurityUser user) {
        return this.contactDataRightModuleService.getUserRolePermission(user);
    }

    public List<ContactAPIVo> selectFirstContactByCustomer(List<Long> customerIdList, LocalDateTime createTimeStart, LocalDateTime createTimeEnd) {
        if (CollectionUtil.isEmpty(customerIdList)) {
            return null;
        }
        List<ContactEntity> list = this.contactMapper.selectContactByCustomer(customerIdList, createTimeStart, createTimeEnd);
        HashMap<Long, ContactEntity> map = new HashMap<Long, ContactEntity>();
        for (ContactEntity entity : list) {
            map.putIfAbsent(entity.getCustomerId(), entity);
        }
        return BeanUtil.copy((Collection)CollectionUtil.toList(map.values()), ContactAPIVo.class);
    }

    public List<Long> getContactIdList(Long userId) {
        return this.contactPermissionService.getContactIdListByPermission(userId);
    }

    public List<Long> getContactIdList() {
        return this.contactPermissionService.getContactIdListByPermission(null);
    }

    public List<ContactAPIVo> selectCrmContactCustomer(ContactAPIDto dto) {
        ContactDto contactDto = new ContactDto();
        BeanUtil.copyProperties((Object)dto, (Object)contactDto);
        List<ContactEntity> contactEntityList = this.contactService.selectCrmContactCustomer(contactDto);
        if (CollectionUtil.isEmpty(contactEntityList)) {
            return null;
        }
        return BeanUtil.copyProperties(contactEntityList, ContactAPIVo.class);
    }

    public ApiResponse<Object> selectCustomerAgentContact(Map<String, Object> body) {
        Page<ContactAPIVo> contactAPIVoList;
        Long userId = null;
        if (!HussarUtils.isNotEmpty((Object)body.get("userId"))) {
            return null;
        }
        userId = HussarUtils.toLong((Object)body.get("userId"));
        IUserBoService userBoService = (IUserBoService)SpringUtils.getBean(IUserBoService.class);
        SecurityUser user = userBoService.selectSecurityByUserId(userId);
        if (user == null) {
            return null;
        }
        long current = HussarUtils.toLong((Object)body.get("current"));
        long size = HussarUtils.toLong((Object)body.get("size"));
        long customerId = HussarUtils.toLong((Object)body.get("customerId"));
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        CustomerEntity customer = (CustomerEntity)this.customerService.getById(Long.valueOf(customerId));
        if (customer != null) {
            PermissionDto customerContactPermissionDto = this.contactDataRightModuleService.getUserRolePermission(user);
            contactAPIVoList = this.contactMapper.selectIdAndNameByPermission((Page<ContactAPIVo>)page, customerContactPermissionDto, null, customerId);
        } else {
            AgentApiVo agentApiVo = this.agentApiService.getById((Serializable)Long.valueOf(customerId));
            if (agentApiVo == null) {
                return null;
            }
            PermissionDto agentContactPermissionDto = this.contactDataRightModuleService.getUserRolePermission(user);
            contactAPIVoList = this.contactMapper.selectAgentContactIdAndNameByPermission((Page<ContactAPIVo>)page, agentContactPermissionDto, customerId);
        }
        return ApiResponse.success(contactAPIVoList);
    }
}

