/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.bid.controller;

import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.core.api.bid.vo.BidVo;
import com.jxdinfo.crm.core.bid.dto.BidAssociativeQueryDto;
import com.jxdinfo.crm.core.bid.dto.BidDataDto;
import com.jxdinfo.crm.core.bid.dto.BidDto;
import com.jxdinfo.crm.core.bid.dto.BidTransDto;
import com.jxdinfo.crm.core.bid.service.BidService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6295\u6807"})
@RequestMapping(value={"/bid"})
public class BidController {
    private static final Logger log = LoggerFactory.getLogger(BidController.class);
    @Resource
    private BidService bidService;

    @PostMapping(value={"/associativeQuery"})
    @ApiOperation(value="\u6295\u6807\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", notes="\u6295\u6807\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AssociativeQueryVo>> associativeQuery(@RequestBody @ApiParam(value="\u6295\u6807dto") BidAssociativeQueryDto dto) {
        return ApiResponse.success(this.bidService.associativeQueryNew(dto));
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u6295\u6807\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u6295\u6807\u4fe1\u606f\u5217\u8868")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<?> bidList(@RequestBody BidDto bidDto) {
        return this.bidService.bidList(bidDto);
    }

    @PostMapping(value={"/deleteBidByIds"})
    @ApiOperation(value="\u5220\u9664\u6295\u6807\u4fe1\u606f", notes="\u5220\u9664\u6295\u6807\u4fe1\u606f")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse deleteBidByIds(@RequestBody @ApiParam(value="\u6295\u6807dto") BidDto dto) {
        return this.bidService.deleteBidByIds(dto);
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u67e5\u8be2\u6295\u6807\u4fe1\u606f\u8be6\u60c5")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<BidVo> getBidDetail(@RequestParam(value="id") @ApiParam(value="\u6295\u6807id") Long id) {
        return ApiResponse.success((Object)this.bidService.getBidDetail(id));
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u6295\u6807\u4fe1\u606f", notes="\u65b0\u589e\u6295\u6807\u4fe1\u606f")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse addBid(@RequestBody @ApiParam(value="\u6295\u6807\u4fe1\u606f") BidDataDto bid) {
        return this.bidService.addBid(bid);
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u6295\u6807\u4fe1\u606f\u4fdd\u5b58", notes="\u6295\u6807\u4fe1\u606f\u4fdd\u5b58")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse editBid(@RequestBody @ApiParam(value="\u6295\u6807\u4fe1\u606f") BidDataDto bid) {
        return this.bidService.editBid(bid);
    }

    @PostMapping(value={"/transfer"})
    @ApiOperation(value="\u6295\u6807\u8f6c\u79fb-crm", notes="\u6295\u6807\u8f6c\u79fb")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse transfer(@RequestBody @ApiParam(value="\u6295\u6807dto\u96c6\u5408") List<BidTransDto> dto) {
        return this.bidService.transfer(dto);
    }

    @PostMapping(value={"/transferChargePerson"})
    @ApiOperation(value="\u8f6c\u79fb\u8d1f\u8d23\u4eba", notes="\u8f6c\u79fb\u8d1f\u8d23\u4eba")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse transferChargePerson(@RequestBody @ApiParam(value="\u6295\u6807dto\u96c6\u5408") BidDto dto) {
        return this.bidService.transferChargePerson(dto);
    }

    @PostMapping(value={"/changeDept"})
    @ApiOperation(value="\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8", notes="\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse changeDept(@RequestBody @ApiParam(value="\u6295\u6807dto\u96c6\u5408") BidDto dto) {
        return this.bidService.changeDept(dto);
    }

    @PostMapping(value={"/changeStage"})
    @ApiOperation(value="\u6295\u6807\u9636\u6bb5\u63a8\u8fdb", notes="\u6295\u6807\u9636\u6bb5\u63a8\u8fdb")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse changeStage(@RequestBody @ApiParam(value="\u6295\u6807dto\u96c6\u5408") BidDto dto) {
        return this.bidService.changeStage(dto);
    }

    @PostMapping(value={"/changeResult"})
    @ApiOperation(value="\u7ed3\u679c\u6570\u636e\u4fee\u6539", notes="\u7ed3\u679c\u6570\u636e\u4fee\u6539")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse changeResult(@RequestBody @ApiParam(value="\u6295\u6807dto\u96c6\u5408") BidDto dto) {
        return this.bidService.changeResult(dto);
    }

    @PostMapping(value={"/getQuoteList"})
    @ApiOperation(value="\u62a5\u4ef7\u5355\u67e5\u8be2", notes="\u62a5\u4ef7\u5355\u67e5\u8be2")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse getQuoteList(@RequestBody BidDto bidDto) {
        return this.bidService.getQuoteList(bidDto);
    }

    @PostMapping(value={"/updateStage"})
    @ApiOperation(value="\u7f16\u8f91\u9636\u6bb5\u4fe1\u606f", notes="\u7f16\u8f91\u9636\u6bb5\u4fe1\u606f")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse updateStage(@RequestBody BidDto bidDto) {
        return this.bidService.updateStage(bidDto);
    }

    @PostMapping(value={"/deleteQuoteIdList"})
    @ApiOperation(value="\u5220\u9664\u62a5\u4ef7\u5355ids", notes="\u5220\u9664\u62a5\u4ef7\u5355ids")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse deleteQuoteIdList(@RequestBody BidDto bidDto) {
        return this.bidService.deleteQuoteIdList(bidDto);
    }

    @PostMapping(value={"/selectStage"})
    @ApiOperation(value="\u67e5\u8be2\u9636\u6bb5\u4fe1\u606f", notes="\u67e5\u8be2\u9636\u6bb5\u4fe1\u606f")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse selectStage(@RequestBody BidDto bidDto) {
        return this.bidService.selectStage(bidDto);
    }

    @GetMapping(value={"operate"})
    @ApiOperation(value="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650", notes="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650")
    @AuditLog(moduleName="\u6295\u6807\u7ba1\u7406", eventDesc="\u6295\u6807\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<OperateVo> isOperate(@RequestParam(value="bidId") @ApiParam(value="\u6295\u6807id") Long bidId) {
        return ApiResponse.success((Object)this.bidService.isOperate(bidId));
    }
}

