/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.teammeber.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.afterservice.api.service.ICrmWorkOrderAPIService;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.service.IAgentContactApiService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.agent.api.vo.AgentContactApiVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.competitor.dao.CompetitorMapper;
import com.jxdinfo.crm.core.competitor.model.Competitor;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.contact.dao.ContactMapper;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.model.CrmCompetitorContact;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.service.CrmCompetitorContactService;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.jxdIM.dto.BusinessTypeAndIds;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.marketingactivity.dao.MarketingActivityMapper;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.product.dao.ProductMapper;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.marketing.api.wallchart.service.IWallchartAPIService;
import com.jxdinfo.crm.marketing.api.wallchart.vo.WallchartAPIVo;
import com.jxdinfo.crm.transaction.api.service.IPriceListApiService;
import com.jxdinfo.crm.transaction.api.service.IQuotationApiService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class TeamMeberServiceImpl
extends ServiceImpl<TeamMeberMapper, TeamMeberEntity>
implements TeamMeberService {
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private ContactMapper contactMapper;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private ContactService contactService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private MarketingActivityMapper marketingActivityMapper;
    @Resource
    private CompetitorMapper competitorMapper;
    @Resource
    private ProductMapper productMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private IWallchartAPIService wallchartAPIService;
    @Resource
    private IAgentApiService agentApiService;
    @Resource
    private IAgentContactApiService agentContactApiService;
    @Resource
    private CrmCompetitorContactService crmCompetitorContactService;
    @Resource
    private IPriceListApiService priceListApiService;
    @Resource
    private IQuotationApiService quotationApiService;
    @Resource
    private ICrmWorkOrderAPIService crmWorkOrderAPIService;

    @Override
    public Page<TeamMeberEntity> selectTeamMeberList(TeamMeberDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<TeamMeberEntity> list = this.teamMeberMapper.selectTeamMeberList(page, dto);
        PersonWithDepInfo dep = null;
        for (TeamMeberEntity lists : list) {
            String userId = lists.getPersonId().toString();
            dep = CommonUtills.selectDepIdName(userId);
            if (!ToolUtil.isNotEmpty((Object)dep)) continue;
            if (dep.getParentId() != null && dep.getParentId() != 100001L) {
                lists.setSplicingDepartment(dep.getDepartmentName() + "-" + dep.getParentName());
                continue;
            }
            lists.setSplicingDepartment(dep.getDepartmentName());
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public TeamMeberEntity selectTeamMeberDetails(TeamMeberDto dto) {
        dto.setDelFlag("0");
        TeamMeberEntity list = this.teamMeberMapper.selectTeamMeberDetails(dto);
        String userId = list.getPersonId().toString();
        PersonWithDepInfo dep = CommonUtills.selectDepIdName(userId);
        if (ToolUtil.isNotEmpty((Object)dep)) {
            list.setSplicingDepartment(dep.getParentName());
        }
        return list;
    }

    @Override
    @Transactional
    public Boolean updateDelFlagByIds(List<Long> ids) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        this.imGroupMemberService.removeGroupMembers(ids);
        this.teamMeberMapper.updateDelFlagByIds(ids, "1", null);
        ArrayList<String> personIdsTemp = new ArrayList<String>();
        ArrayList<String> personNamesTemp = new ArrayList<String>();
        ArrayList<CrmBusinessTypeEnum> businessTypeTemp = new ArrayList<CrmBusinessTypeEnum>();
        ArrayList<Long> businessIdTemp = new ArrayList<Long>();
        ArrayList<String> businessNamesTemp = new ArrayList<String>();
        for (int i = 0; i < ids.size(); ++i) {
            Long id = Long.valueOf(ids.get(i).toString());
            TeamMeberEntity teamMeberEntity = (TeamMeberEntity)((Object)this.getById(id));
            if (teamMeberEntity == null) continue;
            ArrayList<Long> relationIds = new ArrayList<Long>();
            relationIds.add(teamMeberEntity.getBusinessId());
            personIdsTemp.add(String.valueOf(teamMeberEntity.getPersonId()));
            personNamesTemp.add(teamMeberEntity.getTeamMeberName());
            businessIdTemp.add(teamMeberEntity.getBusinessId());
            CrmBusinessTypeEnum typeEnum = null;
            String businessName = "";
            String url = "/crm/sy/yddsy";
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index";
            String title = "";
            String content = "";
            String contentUnify = "";
            String userName = user.getUserName();
            List<String> receiveIds = Collections.singletonList(String.valueOf(teamMeberEntity.getPersonId()));
            if ("1".equals(teamMeberEntity.getBusinessType())) {
                CustomerEntity customerEntity = (CustomerEntity)this.customerMapper.selectById(teamMeberEntity.getBusinessId());
                typeEnum = CrmBusinessTypeEnum.CUSTOMER;
                businessTypeTemp.add(typeEnum);
                businessName = customerEntity.getCustomerName();
                businessNamesTemp.add(businessName);
                title = userName + "\u5c06\u4f60\u4ece\u5ba2\u6237\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u5ba2\u6237\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u5ba2\u6237\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u5ba2\u6237\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/kh/khxq";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("3".equals(teamMeberEntity.getBusinessType())) {
                ContactEntity contactEntity = (ContactEntity)this.contactMapper.selectById(teamMeberEntity.getBusinessId());
                typeEnum = CrmBusinessTypeEnum.CONTACT;
                businessTypeTemp.add(typeEnum);
                businessName = contactEntity.getContactName();
                businessNamesTemp.add(businessName);
                relationIds.add(contactEntity.getCustomerId());
                title = userName + "\u5c06\u4f60\u4ece\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/lxr/lxrxq";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contactDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("2".equals(teamMeberEntity.getBusinessType())) {
                OpportunityEntity opportunityEntity = (OpportunityEntity)this.opportunityMapper.selectById(teamMeberEntity.getBusinessId());
                opportunityEntity.setChangeTime(date);
                opportunityEntity.setChangePerson(user.getUserId());
                opportunityEntity.setChangePersonName(user.getUserName());
                this.opportunityService.updateById(opportunityEntity);
                typeEnum = CrmBusinessTypeEnum.OPPORTUNITY;
                businessTypeTemp.add(typeEnum);
                businessName = opportunityEntity.getOpportunityName();
                businessNamesTemp.add(businessName);
                relationIds.add(opportunityEntity.getCustomerId());
                title = userName + "\u5c06\u4f60\u4ece\u5546\u673a\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u5546\u673a\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u5546\u673a\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u5546\u673a\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/sj/sjxq/xxzl";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("4".equals(teamMeberEntity.getBusinessType())) {
                Leads leads = (Leads)this.leadsMapper.selectById(teamMeberEntity.getBusinessId());
                typeEnum = CrmBusinessTypeEnum.LEADS;
                businessTypeTemp.add(typeEnum);
                businessName = leads.getLeadsName();
                businessNamesTemp.add(businessName);
                title = userName + "\u5c06\u4f60\u4ece\u7ebf\u7d22\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u7ebf\u7d22\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u7ebf\u7d22\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u7ebf\u7d22\u540d\u79f0\uff1a" + businessName + "\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/schd/xsxq";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clueDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("5".equals(teamMeberEntity.getBusinessType())) {
                MarketingActivityEntity marketingActivityEntity = (MarketingActivityEntity)this.marketingActivityMapper.selectById(teamMeberEntity.getBusinessId());
                typeEnum = CrmBusinessTypeEnum.CAMPAIGN;
                businessTypeTemp.add(typeEnum);
                businessName = marketingActivityEntity.getCampaignName();
                businessNamesTemp.add(businessName);
                title = userName + "\u5c06\u4f60\u4ece\u5e02\u573a\u6d3b\u52a8\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u6d3b\u52a8\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u5e02\u573a\u6d3b\u52a8\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u6d3b\u52a8\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/schd/schdxq";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/activityDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("12".equals(teamMeberEntity.getBusinessType())) {
                Competitor competitor = (Competitor)this.competitorMapper.selectById(teamMeberEntity.getBusinessId());
                typeEnum = CrmBusinessTypeEnum.COMPETITOR;
                businessTypeTemp.add(typeEnum);
                businessName = competitor.getCompetitorName();
                businessNamesTemp.add(businessName);
                title = userName + "\u5c06\u4f60\u4ece\u7ade\u4e89\u5bf9\u624b\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u7ade\u4e89\u5bf9\u624b\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u7ade\u4e89\u5bf9\u624b\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u7ade\u4e89\u5bf9\u624b\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/sy/yddsy";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("10".equals(teamMeberEntity.getBusinessType())) {
                Product product = (Product)this.productMapper.selectById(teamMeberEntity.getBusinessId());
                typeEnum = CrmBusinessTypeEnum.PRODUCT;
                businessTypeTemp.add(typeEnum);
                businessName = product.getProductName();
                businessNamesTemp.add(businessName);
                title = userName + "\u5c06\u4f60\u4ece\u4ea7\u54c1\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u4ea7\u54c1\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u4ea7\u54c1\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u4ea7\u54c1\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/chanpinguanli/01pageFolder/chanpin/cpxq";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/productDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("14".equals(teamMeberEntity.getBusinessType())) {
                typeEnum = CrmBusinessTypeEnum.WALLCHART;
                businessTypeTemp.add(typeEnum);
                businessNamesTemp.add(businessName);
                WallchartAPIVo wallchartAPIVo = this.wallchartAPIService.selectWallchartById(teamMeberEntity.getBusinessId());
                if (HussarUtils.isNotEmpty((Object)wallchartAPIVo)) {
                    businessName = wallchartAPIVo.getWallchartName();
                    title = userName + "\u5c06\u4f60\u4ece\u6302\u56fe\u4f5c\u6218\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                    content = "\u6302\u56fe\u4f5c\u6218\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                    contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u6302\u56fe\u4f5c\u6218\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u6302\u56fe\u4f5c\u6218\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                    url = "/crm";
                    unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/wallchart/wallDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
                }
            } else if ("17".equals(teamMeberEntity.getBusinessType())) {
                AgentApiVo agent = this.agentApiService.getById((Serializable)teamMeberEntity.getBusinessId());
                businessName = agent.getAgentName();
                businessNamesTemp.add(businessName);
                typeEnum = CrmBusinessTypeEnum.AGENT;
                businessTypeTemp.add(typeEnum);
                title = userName + "\u5c06\u4f60\u4ece\u4ee3\u7406\u5546\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u4ee3\u7406\u5546\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u4ee3\u7406\u5546\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u4ee3\u7406\u5546\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/sy/yddsy";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/agentDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("18".equals(teamMeberEntity.getBusinessType())) {
                AgentContactApiVo agentContact = this.agentContactApiService.getById((Serializable)teamMeberEntity.getBusinessId());
                businessName = agentContact.getAgentContactName();
                businessNamesTemp.add(businessName);
                typeEnum = CrmBusinessTypeEnum.AGENT_CONTACT;
                businessTypeTemp.add(typeEnum);
                title = userName + "\u5c06\u4f60\u4ece\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/sy/yddsy";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contactAgentDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("21".equals(teamMeberEntity.getBusinessType())) {
                CrmCompetitorContact competitorContact = (CrmCompetitorContact)this.crmCompetitorContactService.getById(teamMeberEntity.getBusinessId());
                businessName = competitorContact.getCompetitorContactName();
                businessNamesTemp.add(businessName);
                typeEnum = CrmBusinessTypeEnum.COMPETITOR_CONTACT;
                businessTypeTemp.add(typeEnum);
                title = userName + "\u5c06\u4f60\u4ece\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/sy/yddsy";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("23".equals(teamMeberEntity.getBusinessType())) {
                businessName = this.crmWorkOrderAPIService.getById((Serializable)teamMeberEntity.getBusinessId()).getServiceTopic();
                businessNamesTemp.add(businessName);
                typeEnum = CrmBusinessTypeEnum.AFTER_SERVICE;
                businessTypeTemp.add(typeEnum);
                title = userName + "\u5c06\u4f60\u4ece\u5ba2\u6237\u670d\u52a1\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u5ba2\u6237\u670d\u52a1\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u5ba2\u6237\u670d\u52a1\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u5ba2\u6237\u670d\u52a1\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/sy/yddsy";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/workListDetail?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("19".equals(teamMeberEntity.getBusinessType())) {
                businessName = this.priceListApiService.getById((Serializable)teamMeberEntity.getBusinessId()).getPriceListName();
                businessNamesTemp.add(businessName);
                typeEnum = CrmBusinessTypeEnum.PRICE_LIST;
                businessTypeTemp.add(typeEnum);
                title = userName + "\u5c06\u4f60\u4ece\u4ef7\u683c\u8868\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u4ef7\u683c\u8868\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u4ef7\u683c\u8868\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u4ef7\u683c\u8868\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/sy/yddsy";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/quote/pricelist/priceListDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            } else if ("20".equals(teamMeberEntity.getBusinessType())) {
                businessName = this.quotationApiService.getById((Serializable)teamMeberEntity.getBusinessId()).getQuoteName();
                businessNamesTemp.add(businessName);
                typeEnum = CrmBusinessTypeEnum.QUOTATION;
                businessTypeTemp.add(typeEnum);
                title = userName + "\u5c06\u4f60\u4ece\u62a5\u4ef7\u5355\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664";
                content = "\u62a5\u4ef7\u5355\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u4f60\u4ece\u62a5\u4ef7\u5355\u56e2\u961f\u6210\u5458\u4e2d\u79fb\u9664\uff0c\u62a5\u4ef7\u5355\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                url = "/crm/sy/yddsy";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/quote/quotation/quotationDetails?row=" + "\"" + teamMeberEntity.getBusinessId() + "\"";
            }
            EimPushUtil.pushJqxArticleMessage(title, content, url, String.valueOf(teamMeberEntity.getBusinessId()), receiveIds);
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            addSysMessageType.setBusinessAddress(unifyWebUrl);
            String userIdToString = StringUtil.join(receiveIds, (String)",");
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, userName, unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
        if (ToolUtil.isNotEmpty(personIdsTemp) && ToolUtil.isNotEmpty(personNamesTemp)) {
            String personIds = StringUtil.join(personIdsTemp, (String)",");
            String personNames = StringUtil.join(personNamesTemp, (String)"\u3001");
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TEAM_MEMBER_DELETE.getId());
            operateRecordDO.setTeamMemberId(personIds);
            operateRecordDO.setTeamMemberName(personNames);
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, (CrmBusinessTypeEnum)businessTypeTemp.get(0), (Long)businessIdTemp.get(0), (String)businessNamesTemp.get(0), date, false, null);
        }
        return true;
    }

    @Override
    public Boolean addCrmTeamMemberAndGroup(Map<String, Object> map) {
        ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
        ArrayList<BusinessTypeAndIds> businessTypeAndIdsList = new ArrayList<BusinessTypeAndIds>();
        Boolean success = this.addCrmTeamMeber(map, teamMeberEntityList, businessTypeAndIdsList);
        this.imGroupMemberService.addGroupMembersBatch(businessTypeAndIdsList, teamMeberEntityList);
        return success;
    }

    @Override
    @Transactional
    public Boolean addCrmTeamMeber(Map<String, Object> map, List<TeamMeberEntity> teamMeberEntityList, List<BusinessTypeAndIds> businessTypeAndIdsList) {
        List<TeamMeberEntity> teamMeberList;
        TeamMeberDto dto;
        ArrayList<String> teamMemberNames;
        ArrayList teamMemberIds;
        String businessId = map.get("businessId").toString();
        String businessType = null;
        if (ToolUtil.isNotEmpty((Object)map.get("businessType").toString())) {
            businessType = map.get("businessType").toString();
        }
        String personIds = map.get("personIds").toString();
        String teamMeberNames = map.get("teamMeberNames").toString();
        String modifyPower = map.get("modifyPower").toString();
        String isCharge = map.get("isCharge").toString();
        String associatedOthers = map.get("associatedOthers").toString();
        String memberRole = map.get("memberRole").toString();
        if (StringUtil.isEmpty((Object)personIds)) {
            throw new BaseException("\u672a\u9009\u62e9\u4eba\u5458");
        }
        String[] personIdArr = personIds.split(",");
        ArrayList<String> userIds = new ArrayList<String>();
        for (String userId : personIdArr) {
            userIds.add(CommonUtills.translateUserId(userId));
        }
        if (userIds.size() == 0) {
            throw new BaseException("\u6240\u9009\u4eba\u5458\u65e0\u6548");
        }
        String[] teamMeberNameArr = teamMeberNames.split(",");
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        List<ContactEntity> contactList = null;
        List<OpportunityEntity> opportunityList = null;
        if (associatedOthers.equals("1")) {
            contactList = this.contactMapper.selectCrmContactCustomer(Long.valueOf(businessId), "0");
        }
        if (associatedOthers.equals("2")) {
            opportunityList = this.opportunityMapper.selectCrmOppByCustomer(Long.valueOf(businessId), "0");
        }
        if (associatedOthers.equals("3")) {
            contactList = this.contactMapper.selectCrmContactCustomer(Long.valueOf(businessId), "0");
            opportunityList = this.opportunityMapper.selectCrmOppByCustomer(Long.valueOf(businessId), "0");
        }
        String businessName = "";
        ArrayList<Long> typeIds = new ArrayList<Long>();
        typeIds.add(Long.valueOf(businessId));
        CrmBusinessTypeEnum typeEnum = null;
        Long customerId = null;
        if ("3".equals(businessType)) {
            ContactEntity contactEntity = (ContactEntity)this.contactMapper.selectById(Long.valueOf(businessId));
            typeIds.add(contactEntity.getCustomerId());
            businessName = contactEntity.getContactName();
            typeEnum = CrmBusinessTypeEnum.CONTACT;
            customerId = contactEntity.getCustomerId();
        } else if ("2".equals(businessType)) {
            OpportunityEntity opportunityEntity = (OpportunityEntity)this.opportunityMapper.selectById(Long.valueOf(businessId));
            if (!"0".equals(opportunityEntity.getCustomerStageId())) {
                typeIds.add(opportunityEntity.getCustomerId());
                customerId = opportunityEntity.getCustomerId();
            }
            businessName = opportunityEntity.getOpportunityName();
            typeEnum = CrmBusinessTypeEnum.OPPORTUNITY;
        } else if ("1".equals(businessType)) {
            CustomerEntity customerEntity = (CustomerEntity)this.customerMapper.selectById(Long.valueOf(businessId));
            businessName = customerEntity.getCustomerName();
            typeEnum = CrmBusinessTypeEnum.CUSTOMER;
        } else if ("4".equals(businessType)) {
            Leads leads = (Leads)this.leadsMapper.selectById(Long.valueOf(businessId));
            businessName = leads.getLeadsName();
            typeEnum = CrmBusinessTypeEnum.LEADS;
        } else if ("5".equals(businessType)) {
            MarketingActivityEntity marketingActivityEntity = (MarketingActivityEntity)this.marketingActivityMapper.selectById(Long.valueOf(businessId));
            businessName = marketingActivityEntity.getCampaignName();
            typeEnum = CrmBusinessTypeEnum.CAMPAIGN;
        } else if ("12".equals(businessType)) {
            Competitor competitor = (Competitor)this.competitorMapper.selectById(Long.valueOf(businessId));
            businessName = competitor.getCompetitorName();
            typeEnum = CrmBusinessTypeEnum.COMPETITOR;
        } else if ("10".equals(businessType)) {
            Product product = (Product)this.productMapper.selectById(Long.valueOf(businessId));
            businessName = product.getShortName();
            typeEnum = CrmBusinessTypeEnum.PRODUCT;
        } else if ("14".equals(businessType)) {
            WallchartAPIVo wallchartAPIVo = this.wallchartAPIService.selectWallchartById(Long.valueOf(businessId));
            if (HussarUtils.isNotEmpty((Object)wallchartAPIVo)) {
                businessName = wallchartAPIVo.getWallchartName();
            }
            typeEnum = CrmBusinessTypeEnum.WALLCHART;
        } else if ("17".equals(businessType)) {
            AgentApiVo agent = this.agentApiService.getById((Serializable)Long.valueOf(businessId));
            businessName = agent.getAgentName();
            typeEnum = CrmBusinessTypeEnum.AGENT;
        } else if ("18".equals(businessType)) {
            AgentContactApiVo agentContact = this.agentContactApiService.getById((Serializable)Long.valueOf(businessId));
            businessName = agentContact.getAgentContactName();
            typeEnum = CrmBusinessTypeEnum.AGENT_CONTACT;
        } else if ("21".equals(businessType)) {
            CrmCompetitorContact competitorContact = (CrmCompetitorContact)this.crmCompetitorContactService.getById(Long.valueOf(businessId));
            businessName = competitorContact.getCompetitorContactName();
            typeEnum = CrmBusinessTypeEnum.COMPETITOR_CONTACT;
        } else if ("23".equals(businessType)) {
            businessName = this.crmWorkOrderAPIService.getById((Serializable)Long.valueOf(businessId)).getServiceTopic();
            typeEnum = CrmBusinessTypeEnum.AFTER_SERVICE;
        } else if ("19".equals(businessType)) {
            businessName = this.priceListApiService.getById((Serializable)Long.valueOf(businessId)).getPriceListName();
            typeEnum = CrmBusinessTypeEnum.PRICE_LIST;
        } else if ("20".equals(businessType)) {
            businessName = this.quotationApiService.getById((Serializable)Long.valueOf(businessId)).getQuoteName();
            typeEnum = CrmBusinessTypeEnum.QUOTATION;
        }
        ArrayList<String> receiverIds = new ArrayList<String>();
        ArrayList<String> operateTeamMemberNames = new ArrayList<String>();
        ArrayList<TeamMeberEntity> list = new ArrayList<TeamMeberEntity>();
        if (contactList != null && !contactList.isEmpty()) {
            Map<Long, Boolean> editOperateMap = this.contactService.editOperateBatch(user, contactList, "contact_edit");
            for (ContactEntity contactEntity : contactList) {
                if (!editOperateMap.get(contactEntity.getContactId()).booleanValue()) continue;
                teamMemberIds = new ArrayList();
                teamMemberNames = new ArrayList<String>();
                for (int i = 0; i < userIds.size(); ++i) {
                    dto = new TeamMeberDto();
                    dto.setBusinessId(contactEntity.getContactId());
                    dto.setPersonId(Long.valueOf((String)userIds.get(i)));
                    dto.setDelFlag("0");
                    teamMeberList = this.teamMeberMapper.selectTeamMeberList(null, dto);
                    if (!teamMeberList.isEmpty()) continue;
                    teamMemberIds.add(userIds.get(i));
                    teamMemberNames.add(teamMeberNameArr[i]);
                }
                if (!ToolUtil.isNotEmpty(teamMemberIds)) continue;
                OperateRecordAPIVo contactOperateRecordDO = new OperateRecordAPIVo();
                contactOperateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TEAM_MEMBER.getId());
                contactOperateRecordDO.setTeamMemberId(StringUtil.join(teamMemberIds, (String)","));
                contactOperateRecordDO.setTeamMemberName(StringUtil.join(teamMemberNames, (String)"\u3001"));
                ArrayList<Long> contactIds = new ArrayList<Long>();
                contactIds.addAll(typeIds);
                contactIds.add(contactEntity.getContactId());
                this.operateRecordAPIService.saveOperateLog(contactOperateRecordDO, CrmBusinessTypeEnum.CONTACT, contactEntity.getContactId(), contactEntity.getContactName(), date, false, contactIds);
            }
        }
        if (opportunityList != null && !opportunityList.isEmpty()) {
            Map<Long, Boolean> operateMap = this.opportunityService.editOperateByBatch(user, opportunityList, "opportunity_edit");
            for (OpportunityEntity opportunityEntity : opportunityList) {
                if (!operateMap.get(opportunityEntity.getOpportunityId()).booleanValue()) continue;
                teamMemberIds = new ArrayList();
                teamMemberNames = new ArrayList();
                for (int i = 0; i < userIds.size(); ++i) {
                    dto = new TeamMeberDto();
                    dto.setBusinessId(opportunityEntity.getOpportunityId());
                    dto.setPersonId(Long.valueOf((String)userIds.get(i)));
                    dto.setDelFlag("0");
                    teamMeberList = this.teamMeberMapper.selectTeamMeberList(null, dto);
                    if (!teamMeberList.isEmpty()) continue;
                    teamMemberIds.add(userIds.get(i));
                    teamMemberNames.add(teamMeberNameArr[i]);
                }
                if (!ToolUtil.isNotEmpty(teamMemberIds)) continue;
                OperateRecordAPIVo oPPOperateRecordDO = new OperateRecordAPIVo();
                oPPOperateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TEAM_MEMBER.getId());
                oPPOperateRecordDO.setTeamMemberId(StringUtil.join(teamMemberIds, (String)","));
                oPPOperateRecordDO.setTeamMemberName(StringUtil.join(teamMemberNames, (String)"\u3001"));
                ArrayList<Long> opportunityIds = new ArrayList<Long>();
                opportunityIds.addAll(typeIds);
                opportunityIds.add(opportunityEntity.getOpportunityId());
                this.operateRecordAPIService.saveOperateLog(oPPOperateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunityEntity.getOpportunityId(), opportunityEntity.getOpportunityName(), date, false, opportunityIds);
            }
        }
        for (int i = 0; i < userIds.size(); ++i) {
            List<TeamMeberEntity> teamMeberList2;
            TeamMeberDto dto2;
            long count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getPersonId, userIds.get(i))).eq(TeamMeberEntity::getBusinessId, (Object)businessId)).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getBusinessType, (Object)businessType));
            if (count > 0L) continue;
            receiverIds.add((String)userIds.get(i));
            operateTeamMemberNames.add(teamMeberNameArr[i]);
            TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
            teamMeberEntity.setTeamMeberName(teamMeberNameArr[i]);
            teamMeberEntity.setPersonId(Long.valueOf((String)userIds.get(i)));
            PersonWithDepInfo dep = CommonUtills.selectDepIdName((String)userIds.get(i));
            if (ToolUtil.isNotEmpty((Object)dep)) {
                teamMeberEntity.setOwnDepartment(dep.getDepartmentId());
                teamMeberEntity.setOwnDepartmentName(dep.getDepartmentName());
            }
            teamMeberEntity.setAssociatedOthers(associatedOthers);
            teamMeberEntity.setMemberRole(memberRole);
            teamMeberEntity.setBusinessId(Long.valueOf(businessId));
            teamMeberEntity.setBusinessType(businessType);
            teamMeberEntity.setModifyPower(modifyPower);
            teamMeberEntity.setIsCharge(isCharge);
            teamMeberEntity.setCreatePerson(user.getUserId());
            teamMeberEntity.setCreatePersonName(user.getUserName());
            teamMeberEntity.setCreateTime(date);
            teamMeberEntity.setUpdatePerson(user.getUserId());
            teamMeberEntity.setUpdatePersonName(user.getUserName());
            teamMeberEntity.setUpdateTime(date);
            teamMeberEntity.setTrackTime(date);
            list.add(teamMeberEntity);
            if (contactList != null && !contactList.isEmpty()) {
                Map<Long, Boolean> editOperateMap = this.contactService.editOperateBatch(user, contactList, "contact_edit");
                for (ContactEntity contactEntity : contactList) {
                    if (!editOperateMap.get(contactEntity.getContactId()).booleanValue()) continue;
                    dto2 = new TeamMeberDto();
                    dto2.setBusinessId(contactEntity.getContactId());
                    dto2.setPersonId(Long.valueOf((String)userIds.get(i)));
                    dto2.setDelFlag("0");
                    teamMeberList2 = this.teamMeberMapper.selectTeamMeberList(null, dto2);
                    if (!teamMeberList2.isEmpty()) continue;
                    TeamMeberEntity contactTeamMeber = (TeamMeberEntity)((Object)BeanUtil.copy((Object)((Object)teamMeberEntity), TeamMeberEntity.class));
                    assert (contactTeamMeber != null);
                    contactTeamMeber.setBusinessId(contactEntity.getContactId());
                    contactTeamMeber.setBusinessType("3");
                    list.add(contactTeamMeber);
                }
            }
            if (opportunityList == null || opportunityList.size() <= 0) continue;
            Map<Long, Boolean> operateMap = this.opportunityService.editOperateByBatch(user, opportunityList, "opportunity_edit");
            for (OpportunityEntity opportunityEntity : opportunityList) {
                if (!operateMap.get(opportunityEntity.getOpportunityId()).booleanValue()) continue;
                dto2 = new TeamMeberDto();
                dto2.setBusinessId(opportunityEntity.getOpportunityId());
                dto2.setPersonId(Long.valueOf((String)userIds.get(i)));
                dto2.setDelFlag("0");
                teamMeberList2 = this.teamMeberMapper.selectTeamMeberList(null, dto2);
                if (teamMeberList2.size() > 0) continue;
                TeamMeberEntity opportunityTeamMeber = (TeamMeberEntity)((Object)BeanUtil.copy((Object)((Object)teamMeberEntity), TeamMeberEntity.class));
                assert (opportunityTeamMeber != null);
                opportunityTeamMeber.setBusinessId(opportunityEntity.getOpportunityId());
                opportunityTeamMeber.setBusinessType("2");
                list.add(opportunityTeamMeber);
            }
        }
        if (list.size() == 0) {
            throw new BaseException("\u6240\u9009\u4eba\u5458\u5df2\u5b58\u5728");
        }
        this.saveBatch(list);
        teamMeberEntityList.addAll(list);
        if (ToolUtil.isNotEmpty(receiverIds)) {
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TEAM_MEMBER.getId());
            operateRecordDO.setTeamMemberId(StringUtil.join(receiverIds, (String)","));
            operateRecordDO.setTeamMemberName(StringUtil.join(operateTeamMemberNames, (String)"\u3001"));
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, typeEnum, Long.valueOf(businessId), businessName, date, false, typeIds);
        }
        BusinessTypeAndIds businessTypeAndIds = new BusinessTypeAndIds();
        businessTypeAndIds.setBusinessType(businessType);
        businessTypeAndIds.setBusinessIdList(CollectionUtil.toList((Object[])new Long[]{Long.valueOf(businessId)}));
        businessTypeAndIdsList.add(businessTypeAndIds);
        if ((associatedOthers.equals("1") || associatedOthers.equals("3")) && CollectionUtil.isNotEmpty(contactList)) {
            businessTypeAndIds = new BusinessTypeAndIds();
            businessTypeAndIds.setBusinessType("3");
            businessTypeAndIds.setBusinessIdList(contactList.stream().map(ContactEntity::getContactId).collect(Collectors.toList()));
            businessTypeAndIdsList.add(businessTypeAndIds);
        }
        if ((associatedOthers.equals("2") || associatedOthers.equals("3")) && CollectionUtil.isNotEmpty(opportunityList)) {
            businessTypeAndIds = new BusinessTypeAndIds();
            businessTypeAndIds.setBusinessType("2");
            businessTypeAndIds.setBusinessIdList(opportunityList.stream().map(OpportunityEntity::getOpportunityId).collect(Collectors.toList()));
            businessTypeAndIdsList.add(businessTypeAndIds);
        }
        if ("2".equals(businessType)) {
            this.opportunityService.updateChangeTime(businessId);
        }
        if (receiverIds.size() > 0) {
            this.sendMsg(user, receiverIds, businessType, Long.valueOf(businessId), businessName, customerId, date);
            if (contactList != null && contactList.size() > 0) {
                for (ContactEntity contactEntity : contactList) {
                    this.sendMsg(user, receiverIds, "3", contactEntity.getContactId(), contactEntity.getContactName(), contactEntity.getCustomerId(), date);
                }
            }
            if (opportunityList != null && opportunityList.size() > 0) {
                for (OpportunityEntity opportunityEntity : opportunityList) {
                    this.sendMsg(user, receiverIds, "2", opportunityEntity.getOpportunityId(), opportunityEntity.getOpportunityName(), opportunityEntity.getCustomerId(), date);
                }
            }
        }
        return true;
    }

    @Override
    @Transactional
    public ApiResponse<TransferBatchResultVo> addOpportunityTeamMebers(Map<String, Object> map) {
        String opportunityIds = map.get("opportunityIds").toString();
        List opids = Arrays.stream(opportunityIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        ArrayList<Long> businessIds = new ArrayList<Long>();
        ArrayList<TeamMeberEntity> teamMemberList = new ArrayList<TeamMeberEntity>();
        List<String> personIdList = Arrays.asList(map.get("personIds").toString().split(","));
        List<String> personNameList = Arrays.asList(map.get("teamMeberNames").toString().split(","));
        for (int i = 0; i < personIdList.size(); ++i) {
            TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
            teamMeberEntity.setPersonId(Long.parseLong(personIdList.get(i)));
            teamMeberEntity.setTeamMeberName(personNameList.get(i));
            PersonWithDepInfo dep = CommonUtills.selectDepIdName(personIdList.get(i));
            if (ToolUtil.isNotEmpty((Object)dep)) {
                teamMeberEntity.setOwnDepartment(dep.getDepartmentId());
                teamMeberEntity.setOwnDepartmentName(dep.getDepartmentName());
            }
            teamMemberList.add(teamMeberEntity);
        }
        int failNum = 0;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (!opids.isEmpty()) {
            List opportunityEntityList = this.opportunityService.listByIds(opids);
            Map<Long, Boolean> operateMap = this.opportunityService.editOperateByBatch(user, opportunityEntityList, "opportunity_edit");
            for (Long opid : opids) {
                if (!operateMap.get(opid).booleanValue()) {
                    ++failNum;
                    continue;
                }
                businessIds.add(opid);
            }
        }
        if (CollectionUtil.isNotEmpty(businessIds)) {
            this.opportunityAddTeamMeberBatch(map, teamMemberList, businessIds);
            try {
                BusinessTypeAndIds businessTypeAndIds = new BusinessTypeAndIds();
                businessTypeAndIds.setBusinessType("2");
                businessTypeAndIds.setBusinessIdList(businessIds);
                this.imGroupMemberService.addGroupMembersBatch(CollectionUtil.toList((Object[])new BusinessTypeAndIds[]{businessTypeAndIds}), teamMemberList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TransferBatchResultVo vo = new TransferBatchResultVo();
        int successNum = opids.size();
        if (successNum == 1) {
            if (failNum > 0) {
                vo.setTransferResult(false);
                vo.setMsgList(Collections.singletonList("\u6dfb\u52a0\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650"));
            } else {
                vo.setTransferResult(true);
                vo.setMsgList(Collections.singletonList("\u6dfb\u52a0\u6210\u529f\u3002"));
            }
        } else if (successNum > 1) {
            if (failNum > 0 && failNum < successNum) {
                vo.setTransferResult(false);
                vo.setMsgList(Collections.singletonList("\u6dfb\u52a0\u6210\u529f" + (successNum -= failNum) + "\u6761\uff0c\u5931\u8d25" + failNum + "\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650"));
            } else if (failNum == successNum) {
                vo.setTransferResult(false);
                vo.setMsgList(Collections.singletonList("\u6dfb\u52a0\u6210\u529f" + (successNum -= failNum) + "\u6761\uff0c\u5931\u8d25" + failNum + "\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650"));
            } else {
                vo.setTransferResult(true);
                vo.setMsgList(Collections.singletonList("\u6dfb\u52a0\u6210\u529f"));
            }
        }
        return ApiResponse.success((Object)vo);
    }

    @Override
    @Transactional
    public void opportunityAddTeamMeberBatch(Map<String, Object> map, List<TeamMeberEntity> teamMebers, List<Long> businessIds) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String modifyPower = map.get("modifyPower").toString();
        String memberRole = map.get("memberRole").toString();
        LocalDateTime date = LocalDateTime.now();
        List personIds = teamMebers.stream().map(TeamMeberEntity::getPersonId).collect(Collectors.toList());
        ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
        List teamMeberEntities = this.teamMeberMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getBusinessId, businessIds)).in(TeamMeberEntity::getPersonId, personIds)).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
        List opportunityEntityList = this.opportunityMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getDelFlag, (Object)"0")).in(OpportunityEntity::getOpportunityId, businessIds));
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        ArrayList sendMsgList = new ArrayList();
        for (OpportunityEntity opportunityEntity : opportunityEntityList) {
            Long opportunityId = opportunityEntity.getOpportunityId();
            ArrayList<String> receiverIds = new ArrayList<String>();
            for (TeamMeberEntity teamMeber : teamMebers) {
                boolean repetitiveTeamMeber = false;
                for (TeamMeberEntity te : teamMeberEntities) {
                    if (!te.getBusinessId().equals(opportunityId) || !te.getPersonId().equals(teamMeber.getPersonId())) continue;
                    repetitiveTeamMeber = true;
                    break;
                }
                if (repetitiveTeamMeber) continue;
                TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setTeamMeberId(Long.valueOf(CommonUtills.generateAssignId()));
                teamMeberEntity.setTeamMeberName(teamMeber.getTeamMeberName());
                teamMeberEntity.setPersonId(teamMeber.getPersonId());
                teamMeberEntity.setBusinessId(opportunityId);
                teamMeberEntity.setBusinessType("2");
                teamMeberEntity.setModifyPower(modifyPower);
                teamMeberEntity.setMemberRole(memberRole);
                teamMeberEntity.setIsCharge("0");
                teamMeberEntity.setAssociatedOthers("0");
                teamMeberEntity.setCreatePerson(user.getUserId());
                teamMeberEntity.setCreatePersonName(user.getUserName());
                teamMeberEntity.setCreateTime(date);
                teamMeberEntity.setUpdatePerson(user.getUserId());
                teamMeberEntity.setUpdateTime(date);
                teamMeberEntity.setUpdatePersonName(user.getUserName());
                teamMeberEntity.setDelFlag("0");
                teamMeberEntity.setOwnDepartment(teamMeber.getOwnDepartment());
                teamMeberEntity.setOwnDepartmentName(teamMeber.getOwnDepartmentName());
                teamMeberEntityList.add(teamMeberEntity);
                receiverIds.add(String.valueOf(teamMeberEntity.getPersonId()));
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = opportunityEntity.getOpportunityName();
                typeEnum = CrmBusinessTypeEnum.OPPORTUNITY;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TEAM_MEMBER.getId());
                operateRecordDO.setTeamMemberId(String.valueOf(teamMeber.getTeamMeberId()));
                operateRecordDO.setTeamMemberName(teamMeber.getTeamMeberName());
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(opportunityId);
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                if (operateRecordDO.getProduceType() == null) {
                    operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
                }
                trackRecordList.add(operateRecordDO);
            }
            if (receiverIds.isEmpty()) continue;
            HashMap<String, Object> msgMap = new HashMap<String, Object>();
            msgMap.put("opportunity", opportunityEntity);
            msgMap.put("receiverIds", receiverIds);
            sendMsgList.add(msgMap);
        }
        this.saveBatch(teamMeberEntityList);
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
        for (Map map2 : sendMsgList) {
            List receiverIds = (List)map2.get("receiverIds");
            OpportunityEntity opportunity = (OpportunityEntity)map2.get("opportunity");
            this.sendMsg(user, receiverIds, "2", opportunity.getOpportunityId(), opportunity.getOpportunityName(), opportunity.getCustomerId(), date);
        }
    }

    @Override
    @Transactional
    public Boolean updateModifyPowerById(TeamMeberEntity dto) {
        if (StringUtils.isEmpty((Object)dto.getTeamMeberId())) {
            return false;
        }
        TeamMeberEntity teamMeberEntity = (TeamMeberEntity)((Object)this.getById(dto.getTeamMeberId()));
        if (teamMeberEntity == null) {
            return false;
        }
        teamMeberEntity.setTeamMeberId(dto.getTeamMeberId());
        teamMeberEntity.setModifyPower(dto.getModifyPower());
        teamMeberEntity.setMemberRole(dto.getMemberRole());
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        teamMeberEntity.setUpdateTime(date);
        teamMeberEntity.setUpdatePerson(user.getId());
        teamMeberEntity.setUpdatePersonName(user.getName());
        if ("2".equals(dto.getBusinessType())) {
            this.opportunityService.updateChangeTime(HussarUtils.toStr((Object)dto.getBusinessId()));
        }
        return this.saveOrUpdate((Object)teamMeberEntity);
    }

    @Override
    @Transactional
    public Boolean saveCrmTeamMeber(TeamMeberEntity teamMeberEntity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (StringUtils.isEmpty((Object)teamMeberEntity.getTeamMeberId())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        teamMeberEntity.setUpdatePerson(user.getId());
        teamMeberEntity.setUpdatePersonName(user.getName());
        teamMeberEntity.setUpdateTime(date);
        return this.updateById((Object)teamMeberEntity);
    }

    @Override
    public boolean insertTeamMember(String memberName, Long personId, Long businessId, String modifyPower, String isCharge, LocalDateTime date, String businessType) {
        PersonWithDepInfo dep;
        long count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getPersonId, (Object)personId)).eq(TeamMeberEntity::getBusinessId, (Object)businessId)).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getBusinessType, (Object)businessType));
        if (count > 0L) {
            return true;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
        teamMeberEntity.setTeamMeberId(Long.valueOf(CommonUtills.generateAssignId()));
        teamMeberEntity.setTeamMeberName(memberName);
        teamMeberEntity.setPersonId(personId);
        teamMeberEntity.setBusinessId(businessId);
        teamMeberEntity.setBusinessType(businessType);
        teamMeberEntity.setModifyPower(modifyPower);
        teamMeberEntity.setIsCharge(isCharge);
        teamMeberEntity.setCreatePerson(user.getUserId());
        teamMeberEntity.setCreatePersonName(user.getUserName());
        teamMeberEntity.setCreateTime(date);
        if ("0".equals(teamMeberEntity.getIsCharge())) {
            if ("4".equals(teamMeberEntity.getBusinessType())) {
                teamMeberEntity.setMemberRole("7");
                teamMeberEntity.setBusinessType("2");
            } else {
                teamMeberEntity.setMemberRole("6");
            }
        }
        if (ToolUtil.isNotEmpty((Object)(dep = CommonUtills.selectDepIdName(personId.toString())))) {
            teamMeberEntity.setOwnDepartment(dep.getDepartmentId());
            teamMeberEntity.setOwnDepartmentName(dep.getDepartmentName());
        }
        teamMeberEntity.setUpdatePerson(user.getUserId());
        teamMeberEntity.setUpdateTime(date);
        teamMeberEntity.setUpdatePersonName(user.getUserName());
        teamMeberEntity.setDelFlag("0");
        return this.save((Object)teamMeberEntity);
    }

    private void sendMsg(SecurityUser user, List<String> users, String businessType, Long businessId, String businessName, Long customerId, LocalDateTime date) {
        String url = "/crm/sy/yddsy";
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index";
        String title = "";
        String content = "";
        String contentUnify = "";
        String userName = user.getUserName();
        if ("1".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u5ba2\u6237\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u5ba2\u6237\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u3002";
            contentUnify = userName + " \u5c06\u60a8\u52a0\u5165\u5230\u5ba2\u6237\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u5ba2\u6237\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/kh/khxq";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + businessId + "\"";
        } else if ("3".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d";
            CustomerEntity customerEntity = (CustomerEntity)this.customerMapper.selectById(customerId);
            content = "\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + customerEntity.getCustomerName() + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u3002";
            contentUnify = userName + " \u5c06\u60a8\u52a0\u5165\u5230\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u8054\u7cfb\u4eba\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/lxr/lxrxq";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contactDetails?row=" + "\"" + businessId + "\"";
        } else if ("2".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u5546\u673a\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u5546\u673a\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u3002";
            contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011" + userName + " \u5c06\u60a8\u52a0\u5165\u5230\u5546\u673a\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u5546\u673a\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/sj/sjxq/xxzl";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + businessId + "\"";
        } else if ("4".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u7ebf\u7d22\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u60a8\u52a0\u5165\u7ebf\u7d22\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u7ebf\u7d22\u540d\u79f0\uff1a" + businessName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/schd/xsxq";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clueDetails?row=" + "\"" + businessId + "\"";
        } else if ("5".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u5e02\u573a\u6d3b\u52a8\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u5e02\u573a\u6d3b\u52a8\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u6d3b\u52a8\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/schd/schdxq";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/activityDetails?row=" + "\"" + businessId + "\"";
        } else if ("10".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u4ea7\u54c1\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u4ea7\u54c1\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u4ea7\u54c1\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/chanpinguanli/01pageFolder/chanpin/cpxq";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/productDetails?row=" + "\"" + businessId + "\"";
        } else if ("14".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u6302\u56fe\u4f5c\u6218\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u6302\u56fe\u4f5c\u6218\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u6302\u56fe\u4f5c\u6218\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/wallchart/wallDetails?row=" + "\"" + businessId + "\"";
        } else if ("17".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u4ee3\u7406\u5546\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u4ee3\u7406\u5546\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u4ee3\u7406\u5546\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/sy/yddsy";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/agentDetails?row=" + "\"" + businessId + "\"";
        } else if ("18".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/sy/yddsy";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contactAgentDetails?row=" + "\"" + businessId + "\"";
        } else if ("12".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u7ade\u4e89\u5bf9\u624b\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u7ade\u4e89\u5bf9\u624b\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u7ade\u4e89\u5bf9\u624b\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/sy/yddsy";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index" + "\"" + businessId + "\"";
        } else if ("21".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/sy/yddsy";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index" + "\"" + businessId + "\"";
        } else if ("23".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u5ba2\u6237\u670d\u52a1\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u5ba2\u6237\u670d\u52a1\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u5ba2\u6237\u670d\u52a1\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/sy/yddsy";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/workListDetail?row=" + "\"" + businessId + "\"";
        } else if ("19".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u4ef7\u683c\u8868\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u4ef7\u683c\u8868\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u4ef7\u683c\u8868\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/sy/yddsy";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/quote/pricelist/priceListDetails?row=" + "\"" + businessId + "\"";
        } else if ("20".equals(businessType)) {
            title = userName + "\u5c06\u60a8\u52a0\u5165\u5230\u62a5\u4ef7\u5355\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + businessName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = userName + " \u5c06\u4f60\u52a0\u5165\u5230\u62a5\u4ef7\u5355\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u62a5\u4ef7\u5355\u540d\u79f0\u3010" + businessName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            url = "/crm/sy/yddsy";
            unifyWebUrl = this.unifyProperties.getCrmUrl() + "/quote/quotation/quotationDetails?row=" + "\"" + businessId + "\"";
        }
        EimPushUtil.pushJqxArticleMessage(title, content, url, businessId.toString(), users);
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        addSysMessageType.setBusinessAddress(unifyWebUrl);
        String userIdToString = StringUtil.join(users, (String)",");
        UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, userName, unifyWebUrl, "");
        UnifyUtil.sendMessage(addSysMessageType);
    }

    @Override
    public boolean insertTeamMemberBatch(String memberName, Long personId, List<Long> businessIdList, String modifyPower, String isCharge, LocalDateTime date, String businessType) {
        SecurityUser user = BaseSecurityUtil.getUser();
        PersonWithDepInfo dep = CommonUtills.selectDepIdName(personId.toString());
        ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
        for (Long businessId : businessIdList) {
            TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
            teamMeberEntity.setTeamMeberId(Long.valueOf(CommonUtills.generateAssignId()));
            teamMeberEntity.setTeamMeberName(memberName);
            teamMeberEntity.setPersonId(personId);
            teamMeberEntity.setBusinessId(businessId);
            teamMeberEntity.setBusinessType(businessType);
            teamMeberEntity.setModifyPower(modifyPower);
            teamMeberEntity.setIsCharge(isCharge);
            teamMeberEntity.setCreatePerson(user.getUserId());
            teamMeberEntity.setCreatePersonName(user.getUserName());
            teamMeberEntity.setCreateTime(date);
            teamMeberEntity.setUpdatePerson(user.getUserId());
            teamMeberEntity.setUpdateTime(date);
            teamMeberEntity.setUpdatePersonName(user.getUserName());
            teamMeberEntity.setDelFlag("0");
            if (ToolUtil.isNotEmpty((Object)dep)) {
                teamMeberEntity.setOwnDepartment(dep.getDepartmentId());
                teamMeberEntity.setOwnDepartmentName(dep.getDepartmentName());
            }
            teamMeberEntityList.add(teamMeberEntity);
        }
        return this.saveBatch(teamMeberEntityList);
    }
}

