/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leadshighseas.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.dto.LeadsDto;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.leads.service.LeadsService;
import com.jxdinfo.crm.core.leadshighseas.dao.HighSeasPermissionMapper;
import com.jxdinfo.crm.core.leadshighseas.dao.LeadsHighSeasMapper;
import com.jxdinfo.crm.core.leadshighseas.dto.LeadsHighSeasDto;
import com.jxdinfo.crm.core.leadshighseas.model.CrmHighSeasPermission;
import com.jxdinfo.crm.core.leadshighseas.model.LeadsHighSeasModel;
import com.jxdinfo.crm.core.leadshighseas.model.LeadsHighSeasRelation;
import com.jxdinfo.crm.core.leadshighseas.service.HighSeasPermissionService;
import com.jxdinfo.crm.core.leadshighseas.service.LeadsHighSeasRelationService;
import com.jxdinfo.crm.core.leadshighseas.service.LeadsHighSeasService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.product.dao.ProductManagerMapper;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LeadsHighSeasServiceImpl
extends ServiceImpl<LeadsHighSeasMapper, LeadsHighSeasModel>
implements LeadsHighSeasService {
    @Resource
    private LeadsHighSeasMapper leadsHighSeasMapper;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private LeadsHighSeasRelationService leadsHighSeasRelationService;
    @Resource
    private LeadsService leadsService;
    @Resource
    private CommonService commonService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private ProductManagerMapper productManagerMapper;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private CustomerService customerService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private HighSeasPermissionService highSeasPermissionService;
    @Resource
    private HighSeasPermissionMapper highSeasPermissionMapper;

    @Override
    public Page<LeadsHighSeasModel> selectCrmLeadsHighSeasList(LeadsHighSeasDto dto) {
        Page page = dto.getPage();
        PermissionDto permissionDto = new PermissionDto();
        SecurityUser user = BaseSecurityUtil.getUser();
        permissionDto.setPermissionUserId(user.getUserId());
        SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)user.getDeptId());
        ArrayList<String> struList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)sysStru.getStruFid())) {
            String struPidStr = sysStru.getStruFid();
            if (struPidStr.startsWith("/")) {
                struPidStr = struPidStr.replaceFirst("/", "");
            }
            if (struPidStr.endsWith("/")) {
                struPidStr = struPidStr.substring(0, struPidStr.length() - 1);
            }
            String[] struPidArr = struPidStr.split("/");
            List<String> asList = Arrays.asList(struPidArr);
            struList.addAll(asList);
        } else {
            struList.add("100001");
        }
        List struLongList = struList.stream().map(Long::parseLong).collect(Collectors.toList());
        permissionDto.setPermissionDeptIds(struLongList);
        if (ToolUtil.isNotEmpty((Object)dto.getSeasScreening())) {
            dto.setSeasScreening(dto.getSeasScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        dto.setDelFlag("1");
        List<LeadsHighSeasModel> list = this.leadsHighSeasMapper.selectCrmLeadsHighSeasList(dto, page, permissionDto);
        page.setRecords(list);
        return page;
    }

    @Override
    public Boolean updateDelFlagByHighSeasIds(List<String> ids) {
        this.leadsHighSeasMapper.updateDelFlagByHighSeasIds(ids, "1");
        return true;
    }

    @Override
    public List<Map<String, Object>> selectCrmLeadsHighSeasSum(LeadsHighSeasDto dto) {
        List<Map<String, Object>> highSeasList = this.leadsHighSeasMapper.selectCrmLeadsHighSeasSum(dto, null);
        return highSeasList;
    }

    @Override
    @HussarTransactional
    public Boolean insertHighSeas(LeadsHighSeasModel dto) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        dto.setChangeTime(date);
        dto.setChangePerson(user.getUserId());
        dto.setChangePersonName(user.getUserName());
        if (ToolUtil.isNotEmpty((Object)dto.getHighSeasId())) {
            this.updateById(dto);
        } else {
            dto.setCreateTime(date);
            dto.setCreatePerson(user.getUserId());
            dto.setCreatePersonName(user.getUserName());
            dto.setOwnDepartment(user.getDeptId());
            dto.setOwnDepartmentName(user.getDeptName());
            this.save(dto);
            if (ToolUtil.isEmpty(dto.getManagerList())) {
                CrmHighSeasPermission permission = new CrmHighSeasPermission();
                permission.setStruType("9");
                permission.setStruId(user.getUserId());
                dto.setManagerList(Arrays.asList(permission));
            }
        }
        this.highSeasPermissionService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmHighSeasPermission::getBusinessType, (Object)"0")).eq(CrmHighSeasPermission::getBusinessId, (Object)dto.getHighSeasId()));
        if (!"1".equals(dto.getVisibleRange()) && ToolUtil.isNotEmpty(dto.getVisibleList())) {
            for (CrmHighSeasPermission permission : dto.getVisibleList()) {
                permission.setBusinessId(dto.getHighSeasId());
                permission.setBusinessType("0");
            }
            this.highSeasPermissionService.saveBatch(dto.getVisibleList());
        }
        if (ToolUtil.isNotEmpty(dto.getManagerList())) {
            for (CrmHighSeasPermission permission : dto.getManagerList()) {
                permission.setBusinessId(dto.getHighSeasId());
                permission.setBusinessType("1");
            }
            this.highSeasPermissionService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmHighSeasPermission::getBusinessType, (Object)"1")).eq(CrmHighSeasPermission::getBusinessId, (Object)dto.getHighSeasId()));
            this.highSeasPermissionService.saveBatch(dto.getManagerList());
        }
        return true;
    }

    @Override
    public LeadsHighSeasModel selHighSeasDetail(LeadsHighSeasModel dto) {
        List<CrmHighSeasPermission> permissions;
        LeadsHighSeasModel leadsHighSeasModel = this.leadsHighSeasMapper.selHighSeasDetail(dto);
        if ("1".equals(dto.getVisibleRange())) {
            leadsHighSeasModel.setVisibleNames("\u5168\u90e8");
        } else {
            leadsHighSeasModel.setVisibleNames(this.getPermissionName(dto.getHighSeasId(), "0"));
            permissions = this.highSeasPermissionMapper.selectPermissionVo(dto.getHighSeasId(), "0");
            leadsHighSeasModel.setVisibleList(permissions);
        }
        leadsHighSeasModel.setManagerNames(this.getPermissionName(dto.getHighSeasId(), "1").replace("\u4eba\u5458\uff1a", ""));
        permissions = this.highSeasPermissionMapper.selectPermissionVo(dto.getHighSeasId(), "1");
        leadsHighSeasModel.setManagerList(permissions);
        return leadsHighSeasModel;
    }

    @Override
    @Transactional
    public Long insertLeads(Leads dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long leadId = dto.getLeadsId();
        Object relation = null;
        if (dto.getLeadsId() == null) {
            leadId = Long.valueOf(CommonUtills.generateAssignId());
            dto.setLeadsId(leadId);
            dto.setMobilePhone(dto.getMobilePhone().replace(" ", ""));
            dto.setTelephone(dto.getTelephone().replace(" ", ""));
            dto.setDelFlag("0");
            dto.setCreatePerson(user.getUserId());
            dto.setCreatePersonName(user.getUserName());
            dto.setCreateTime(date);
            dto.setCreateDepartment(user.getDeptId());
            dto.setCreateDepartmentName(user.getDeptName());
            dto.setState("1");
            dto.setChargePersonId(user.getUserId());
            dto.setChargePersonName(user.getUserName());
            dto.setOwnDepartment(user.getDeptId());
            dto.setOwnDepartmentName(user.getDeptName());
            dto.setOwnDepartment(user.getDeptId());
            dto.setOwnDepartmentName(user.getDeptName());
        }
        dto.setChangePerson(user.getUserId());
        dto.setChangePersonName(user.getUserName());
        dto.setChangeTime(date);
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)dto.getProvince())) {
            dto.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)dto.getCity())) {
            dto.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)dto.getCounty())) {
            dto.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        dto.setRegionLabel(sb.toString());
        this.leadsHighSeasMapper.insertLeads(dto);
        if (ToolUtil.isNotEmpty((Object)dto.getProductId())) {
            List<String> productIds = Arrays.asList(dto.getProductId().split(","));
            List<Long> businessIds = productIds.stream().map(Long::valueOf).collect(Collectors.toList());
            List<Map<String, Object>> productManagers = this.teamMeberMapper.selectProductTeamMemberByBusinessId(businessIds, "0");
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < productManagers.size(); ++i) {
                if (list.contains(String.valueOf(productManagers.get(i).get("personId")))) continue;
                list.add(String.valueOf(productManagers.get(i).get("personId")));
                String title = "\u3010" + productManagers.get(i).get("shortName") + "\u3011\u7ebf\u7d22\u63d0\u9192";
                String content = user.getDeptName() + "-" + user.getUserName() + "\u5c06\u4ea7\u54c1\u3010" + productManagers.get(i).get("shortName") + "\u3011\u5173\u8054\u5230\u7ebf\u7d22\u3010" + dto.getLeadsName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title, content, "/crm/schd/xsxq", String.valueOf(dto.getLeadsId()), Arrays.asList(String.valueOf(productManagers.get(i).get("managerId"))));
            }
        }
        this.teamMeberService.insertTeamMember(dto.getChargePersonName(), dto.getChargePersonId(), leadId, "1", "1", date, "4");
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.LEADS, leadId, dto.getLeadsName(), date, false, Arrays.asList(leadId));
        return leadId;
    }

    @Override
    public Boolean leadDistribute(List<OpportunityDto> dtos) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId(dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        SecurityUser newChargePerson = this.commonMapper.selectSecurityByUserId(Long.valueOf(newChargePersonId));
        for (OpportunityDto dto : dtos) {
            CustomerEntity customer;
            Boolean customerOperate;
            List customerEntityList;
            OpportunityEntity opportunity = (OpportunityEntity)this.opportunityMapper.selectById(dto.getOpportunityId());
            if (ToolUtil.isNotEmpty((Object)opportunity.getChargePersonId())) {
                throw new BaseException("\u8be5\u5546\u673a\u5df2\u5206\u914d");
            }
            if (StringUtil.isNotBlank((CharSequence)opportunity.getCustomerName()) && CollectionUtil.isNotEmpty((Collection)(customerEntityList = this.customerService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerName, (Object)opportunity.getCustomerName())).eq(CustomerEntity::getDelFlag, (Object)"0")).eq(CustomerEntity::getDisableRepeat, (Object)"1")).orderByAsc(CustomerEntity::getCreateTime)))) && !(customerOperate = this.customerService.editCustomerOperate(customer = (CustomerEntity)customerEntityList.get(0), newChargePerson, "customer_edit")).booleanValue()) {
                throw new BaseException("\u8be5\u5546\u673a\u4e3a\u4f8b\u5916\u5ba2\u6237\u4e0b\u7684\u5546\u673a\uff0c\u8bf7\u9009\u62e9\u6709\u6743\u9650\u7684\u4eba\u5458");
            }
            String keepFlag = dto.getKeepFlag();
            String opportunityName = dto.getOpportunityName();
            Long opportunityId = dto.getOpportunityId();
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setState("1");
            dto.setNewChargePersonId(newChargePersonId);
            this.opportunityMapper.updateOpportunity(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(opportunityId);
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            List<TeamMeberEntity> list = this.teamMeberMapper.selectTeamMeberList(null, teamMeberDto);
            if (list.size() == 0) {
                this.teamMeberService.insertTeamMember(newChargePersonName, Long.parseLong(newChargePersonId), opportunityId, "1", "1", date, "2");
            } else {
                this.teamMeberMapper.updateIsCharge(newChargePersonId, opportunityId, "1", null, "1");
            }
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(Long.valueOf(newChargePersonId));
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setDelflag("0");
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_DISTRIBUTE.getId());
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunityId, opportunityName, LocalDateTime.now(), false, Arrays.asList(opportunityId));
            String title1 = userName + "\u5c06\u5546\u673a\u5206\u914d\u7ed9\u4f60";
            String content1 = opportunity.getOpportunityName() + "\u3010" + opportunity.getCustomerName() + "\u3011,\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
            EimPushUtil.pushJqxArticleMessage(title1, content1, "/crm/sj/sjxq/xxzl", opportunityId.toString(), Arrays.asList(newChargePersonId));
            AddSysMessageType addSysMessageType1 = new AddSysMessageType();
            String unifyWebUrl1 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
            String contentUnify = "\u3010\u5206\u914d\u63d0\u9192\u3011" + userName + " \u5c06\u5546\u673a/\u7ebf\u7d22\u5206\u914d\u7ed9\u4f60\uff0c\u5546\u673a/\u7ebf\u7d22\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage(addSysMessageType1, contentUnify, date, user, newChargePersonId, userName, unifyWebUrl1, "");
            UnifyUtil.sendMessage(addSysMessageType1);
            List<String> createRole = this.commonService.getRoleNameByUser_Id(opportunity.getCreatePerson());
            String title2 = userName + "\u5c06\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u5206\u914d";
            String content2 = "\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5df2\u5206\u914d\u81f3" + newOwnDepartmentName + "\u7684" + dto.getNewChargePersonName() + "\u8fdb\u884c\u8ddf\u8fdb";
            EimPushUtil.pushJqxArticleMessage(title2, content2, "/crm/sj/sjxq/xxzl", opportunityId.toString(), Arrays.asList(String.valueOf(opportunity.getCreatePerson())));
            AddSysMessageType addSysMessageType2 = new AddSysMessageType();
            String unifyWebUrl2 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
            UnifyUtil.defaultMessage(addSysMessageType2, content2, date, user, String.valueOf(opportunity.getCreatePerson()), userName, unifyWebUrl2, "");
            UnifyUtil.sendMessage(addSysMessageType2);
        }
        return true;
    }

    @Override
    public Integer delLeads(Leads dto) {
        Integer returnNum = 0;
        LeadsDto newLeads = new LeadsDto();
        newLeads.setLeadsId(dto.getLeadsId());
        Leads leads = this.leadsMapper.selLeadsDetail(newLeads);
        Integer num = this.leadsHighSeasMapper.delLeads(dto);
        boolean isTrue = false;
        if (num > 0) {
            String highSeasId = dto.getHighSeasId();
            String newHighSeasId = leads.getHighSeasId();
            if (ToolUtil.isNotEmpty((Object)highSeasId)) {
                String[] high = newHighSeasId.split(",");
                for (int i = 0; i < high.length; ++i) {
                    LeadsHighSeasModel leadsHighSeasModel = new LeadsHighSeasModel();
                    leadsHighSeasModel.setHighSeasId(Long.valueOf(high[i]));
                    LeadsHighSeasModel leadsHighSeasModel2 = this.leadsHighSeasMapper.selHighSeasDetail(leadsHighSeasModel);
                    String leadsNumber = leadsHighSeasModel2.getLeadsNumber();
                    String leadsUnassigned = leadsHighSeasModel2.getLeadsUnassigned();
                    leadsNumber = ToolUtil.isNotEmpty((Object)leadsNumber) ? String.valueOf(Integer.parseInt(leadsNumber) - 1) : "0";
                    leadsUnassigned = ToolUtil.isNotEmpty((Object)leadsUnassigned) ? String.valueOf(Integer.parseInt(leadsUnassigned) - 1) : "0";
                    leadsHighSeasModel.setLeadsNumber(leadsNumber);
                    leadsHighSeasModel.setLeadsUnassigned(leadsUnassigned);
                    Integer num2 = this.leadsHighSeasMapper.updateHighSeas(leadsHighSeasModel);
                    isTrue = true;
                }
            }
        }
        if (isTrue) {
            returnNum = 1;
        }
        return returnNum;
    }

    @Override
    public Integer removeLeads(LeadsDto dto) {
        String highSeasId = dto.getHighSeasId();
        Integer num = 0;
        for (String leadsId : dto.getLeadsIds()) {
            num = this.leadsHighSeasMapper.removeLeads(leadsId, highSeasId);
        }
        return num;
    }

    public String remove(String[] arr, String lead) {
        String result = "";
        for (int i = 0; i < arr.length; ++i) {
            if (lead.equals(arr[i])) continue;
            result = result + arr[i] + ",";
        }
        if (ToolUtil.isNotEmpty((Object)result)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private LeadsHighSeasRelation getLeadsHighSeasRelation(Long leadId, Leads dto, Integer sales) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LeadsHighSeasRelation relation = new LeadsHighSeasRelation();
        relation.setLeadId(leadId);
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        Long parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId());
        List highSeas = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LeadsHighSeasModel::getOwnDepartment, (Object)parentId)).eq(LeadsHighSeasModel::getDelFlag, (Object)"2"));
        if (CollectionUtil.isNotEmpty((Collection)highSeas)) {
            relation.setHighSeasId(((LeadsHighSeasModel)highSeas.get(0)).getHighSeasId());
        } else {
            relation.setHighSeasId(CommonConstant.DEFAULT_HIGN_SEAS);
        }
        dto.setOwnDepartment(user.getDeptId());
        dto.setOwnDepartmentName(user.getDeptName());
        return relation;
    }

    private String getPermissionName(Long seasId, String businessType) {
        String permissionName = "";
        List permissionList = this.highSeasPermissionService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmHighSeasPermission::getBusinessId, (Object)seasId)).eq(CrmHighSeasPermission::getBusinessType, (Object)businessType));
        if (ToolUtil.isNotEmpty((Object)permissionList)) {
            StringBuilder deptName = new StringBuilder();
            List deptPermissionList = permissionList.stream().filter(permission -> permission.getStruType().equals("2") || permission.getStruType().equals("1")).map(CrmHighSeasPermission::getStruId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(deptPermissionList)) {
                List sysStruList = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, deptPermissionList)).in(SysStru::getStruType, Arrays.asList(1, 2))).orderByAsc(SysStru::getStruOrder));
                for (SysStru sysStru : sysStruList) {
                    deptName.append("\u3001").append(sysStru.getOrganAlias());
                }
            }
            StringBuilder userName = new StringBuilder();
            List userPermissionList = permissionList.stream().filter(permission -> permission.getStruType().equals("9")).map(CrmHighSeasPermission::getStruId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(userPermissionList)) {
                List sysUsersList = this.sysUsersService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUsers::getId, userPermissionList)).orderByAsc(SysUsers::getUserOrder));
                for (SysUsers sysUsers1 : sysUsersList) {
                    userName.append("\u3001").append(sysUsers1.getUserName());
                }
            }
            if (deptName.length() > 0) {
                permissionName = deptName.substring(1);
            }
            if (userName.length() > 0) {
                if (permissionName.length() > 0) {
                    permissionName = permissionName + "\uff1b";
                }
                permissionName = permissionName + userName.substring(1);
            }
        }
        return permissionName;
    }
}

