/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.jxdIM.controller;

import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamIMGroupDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupService;
import com.jxdinfo.crm.core.jxdIM.vo.ImGroupVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bf9\u63a5IM\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/im/group"})
public class ImGroupController {
    @Resource
    private ImGroupService imGroupService;
    @Resource
    private ImGroupMemberService imGroupMemberService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u521b\u5efa\u7fa4\u804a", notes="\u521b\u5efa\u7fa4\u804a")
    @AuditLog(moduleName="\u7fa4\u804a\u7ba1\u7406", eventDesc="\u521b\u5efa\u7fa4\u804a", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<ImGroupVo> createGroup(@RequestBody CrmTeamIMGroupDto dto) {
        return this.imGroupService.createGroup(dto);
    }

    @GetMapping(value={"/info"})
    @ApiOperation(value="\u83b7\u53d6\u7fa4\u804a\u8be6\u60c5", notes="\u83b7\u53d6\u7fa4\u804a\u8be6\u60c5")
    @AuditLog(moduleName="\u7fa4\u804a\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7fa4\u804a\u8be6\u60c5", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ImGroupVo> getGroupInfo(@RequestParam(value="businessId") String businessId, @RequestParam(value="businessType") String businessType) {
        return this.imGroupService.getGroupInfo(businessId, businessType);
    }

    @PostMapping(value={"/member/add"})
    @ApiOperation(value="\u52a0\u5165\u7fa4\u804a", notes="\u52a0\u5165\u7fa4\u804a")
    @AuditLog(moduleName="\u7fa4\u804a\u7ba1\u7406", eventDesc="\u52a0\u5165\u7fa4\u804a", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse addMember(@RequestParam(value="imGroupId") String imGroupId) {
        int isSuccess = this.imGroupMemberService.addToGroup(imGroupId);
        if (isSuccess > 0) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u52a0\u5165\u7fa4\u804a\u5931\u8d25");
    }

    @GetMapping(value={"/getUnreadMsgNum"})
    @ApiOperation(value="\u67e5\u8be2\u672a\u8bfb\u6570", notes="\u67e5\u8be2\u672a\u8bfb\u6570")
    @AuditLog(moduleName="\u7fa4\u804a\u7ba1\u7406", eventDesc="\u67e5\u8be2\u672a\u8bfb\u6570", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse getUnreadMsgNum() {
        int num = this.imGroupMemberService.getUnreadMsgNum();
        return ApiResponse.success((Object)num);
    }
}

