/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.service.IAgentDataRightModuleService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.DateStartEndVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.contact.vo.ContactAPIVo;
import com.jxdinfo.crm.core.api.customer.service.ICustomerDataRightModuleService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityDataRightModuleService;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryDto;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.dto.DeptChangeBatchDto;
import com.jxdinfo.crm.core.common.dto.TianYanChaDto;
import com.jxdinfo.crm.core.common.model.Stru;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.CompanyBaseInfo;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.contact.dto.ContactDto;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmcustomer1.model.CrmCustomer1;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmcustomer1.service.CrmCustomer1Service;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.customer.constant.CustomerEditConstant;
import com.jxdinfo.crm.core.customer.constant.CustomerPoolEditConstant;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.dto.CheckDuplicateCustomerDto;
import com.jxdinfo.crm.core.customer.dto.CustomerAssociativeQueryDto;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.dto.CustomerSelectPermissionDto;
import com.jxdinfo.crm.core.customer.dto.ReleaseCustomerDto;
import com.jxdinfo.crm.core.customer.dto.YyzcCustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.model.CustomerIncludePool;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerAssociativeQueryService;
import com.jxdinfo.crm.core.customer.service.ICustomerIncludePoolService;
import com.jxdinfo.crm.core.customer.vo.CheckRepeat;
import com.jxdinfo.crm.core.customer.vo.CustomerEntityVo;
import com.jxdinfo.crm.core.customer.vo.CustomerRepeatStatistics;
import com.jxdinfo.crm.core.customer.vo.ExceptionCustomerVo;
import com.jxdinfo.crm.core.customer.vo.YyzcCustomerVo;
import com.jxdinfo.crm.core.customerpool.customerpool.model.CustomerPoolEntity;
import com.jxdinfo.crm.core.customerpool.customerpool.service.ICustomerPoolMemberService;
import com.jxdinfo.crm.core.customerpool.customerpool.service.ICustomerPoolService;
import com.jxdinfo.crm.core.customerpool.customerpool.vo.CustomerPoolVo;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.model.PoolCustomerEntity;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.service.IPoolCustomerService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.financialinfo.entity.FinancialInfoEntity;
import com.jxdinfo.crm.core.financialinfo.service.IFinancialInfoService;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.opportunity.constant.OpportunityEditConstant;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityStageMapper;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.GlobalOpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.task.model.TaskEntity;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.dto.EimPushMessage;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.CrmLabelUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.ReadExcel;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.vehicleapplication.dao.VehicleApplicationMapper;
import com.jxdinfo.crm.core.vehicleapplication.model.User;
import com.jxdinfo.crm.core.vehicleapplication.model.VehicleApplication;
import com.jxdinfo.crm.transaction.api.service.IQuotationApiService;
import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionBoService;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CustomerServiceImpl
extends ServiceImpl<CustomerMapper, CustomerEntity>
implements CustomerService {
    @Resource
    private ILabelService labelService;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private GlobalOpportunityService globalOpportunityService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ContactService contactService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private ISysStruService struService;
    @Resource
    private FocusService focusService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private VehicleApplicationMapper vehicleApplicationMapper;
    @Resource
    private ICustomerAssociativeQueryService customerAssociativeQueryService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private IAgentApiService agentApiService;
    @Resource
    private IQuotationApiService quotationApiService;
    @Resource
    private OpportunityStageMapper opportunityStageMapper;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private IFinancialInfoService financialInfoService;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private CrmCustomer1Service crmCustomer1Service;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private CommonService commonService;
    @Resource
    private IHussarBaseRegionBoService hussarBaseRegionBoService;
    @Resource
    private ICustomerPoolService customerPoolService;
    @Resource
    private IPoolCustomerService poolCustomerService;
    @Resource
    private TaskService taskService;
    @Resource
    private ICustomerIncludePoolService customerIncludePoolService;
    @Resource
    private ICustomerPoolMemberService customerPoolMemberService;
    @Resource
    private ICustomerDataRightModuleService customerDataRightModuleService;
    @Resource
    private IMarketingActivityDataRightModuleService marketingActivityDataRightModuleService;
    @Resource
    private IAgentDataRightModuleService agentDataRightModuleService;
    @Resource
    private IHussarBaseResourceAdapter hussarBaseResourceAdapter;
    @Resource
    private ITeamMemberApiService teamMemberApiService;
    @Resource
    private ProductService productService;
    @Resource
    private MarketingActivityService marketingActivityService;
    @Resource
    private IUserBoService userBoService;

    @Override
    public Page<CustomerEntity> selectCustomerList(CustomerDto dto) {
        Page page;
        List<Long> pids;
        if (CollectionUtil.isNotEmpty(dto.getCategoryIds()) && CollectionUtil.isNotEmpty(pids = this.productService.selectAllProductIdByCategory(dto.getCategoryIds()))) {
            if (dto.getProducts() != null) {
                dto.getProducts().addAll(pids);
            } else {
                dto.setProducts(pids);
            }
        }
        if (StringUtil.isEmpty((Object)dto.getCustomerView())) {
            dto.setCustomerView("1");
        }
        CustomerSelectPermissionDto customerSelectPermissionDto = this.customerOperate(dto);
        PermissionDto campaignPermissionDto = customerSelectPermissionDto.getCampaignPermissionDto();
        PermissionDto customerPermissionDto = customerSelectPermissionDto.getCustomerPermissionDto();
        List<CustomerDto> customerDtoList = this.getCustomerDtoList(dto);
        List<CustomerEntity> list = this.customerMapper.selectCustomerListCountOpportunity(customerDtoList, page = dto.getPage(), dto.getTimeOrder(), dto.getCurrentUserId(), customerPermissionDto, campaignPermissionDto);
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
            list.forEach(customer -> {
                customer.setLabelName(CrmLabelUtil.getLabelName(labelList, customer.getLabelId()));
                customer.setAiTagName(CrmLabelUtil.getLabelName(labelList, customer.getAiTags()));
            });
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<CustomerEntity> selectCustomerListForCustomerProfileAnalysis(CustomerDto dto) {
        List<CustomerEntity> list;
        if (StringUtil.isEmpty((Object)dto.getCustomerView())) {
            dto.setCustomerView("1");
        }
        CustomerSelectPermissionDto customerSelectPermissionDto = this.customerOperate(dto);
        PermissionDto campaignPermissionDto = customerSelectPermissionDto.getCampaignPermissionDto();
        PermissionDto customerPermissionDto = customerSelectPermissionDto.getCustomerPermissionDto();
        List<CustomerDto> customerDtoList = this.getCustomerDtoList(dto);
        Page page = dto.getPage();
        if (ToolUtil.isNotEmpty((Object)dto.getStageType())) {
            if ("20".equals(dto.getStageType())) {
                List customerStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).eq(OpportunityStage::getStageType, (Object)dto.getStageType())).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> s.toString());
                if (CollectionUtil.isEmpty((Collection)customerStageIds)) {
                    return null;
                }
                dto.setCustomerStageIds(customerStageIds);
            } else {
                CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
                String configValue = crmBaseConfigVo.getConfigValue();
                List<String> ongoingStageIds = Arrays.asList(configValue.split(","));
                dto.setCustomerStageIds(ongoingStageIds);
            }
        }
        if (CollectionUtil.isNotEmpty(list = this.customerMapper.selectCustomerListCountOpportunityForProfile(customerDtoList, page, dto.getTimeOrder(), dto.getCurrentUserId(), customerPermissionDto, campaignPermissionDto))) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
            list.forEach(customer -> {
                customer.setLabelName(CrmLabelUtil.getLabelName(labelList, customer.getLabelId()));
                customer.setAiTagName(CrmLabelUtil.getLabelName(labelList, customer.getAiTags()));
            });
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public List<CustomerEntity> selectCustomerListNoPage(CustomerDto dto) {
        if (StringUtil.isEmpty((Object)dto.getCustomerView())) {
            dto.setCustomerView("1");
        }
        CustomerSelectPermissionDto customerSelectPermissionDto = this.customerOperate(dto);
        PermissionDto campaignPermissionDto = customerSelectPermissionDto.getCampaignPermissionDto();
        PermissionDto customerPermissionDto = customerSelectPermissionDto.getCustomerPermissionDto();
        List<CustomerDto> customerDtoList = this.getCustomerDtoList(dto);
        Page page = dto.getPage();
        List<CustomerEntity> list = this.customerMapper.selectCustomerListCountOpportunity(customerDtoList, dto.getTimeOrder(), dto.getCurrentUserId(), customerPermissionDto, campaignPermissionDto);
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
            list.forEach(customer -> {
                customer.setLabelName(CrmLabelUtil.getLabelName(labelList, customer.getLabelId()));
                customer.setAiTagName(CrmLabelUtil.getLabelName(labelList, customer.getAiTags()));
            });
        }
        return list;
    }

    @Override
    public Page<CustomerEntity> selectCustomerListNoPermission(CustomerDto dto) {
        Page page;
        if (StringUtil.isEmpty((Object)dto.getCustomerView())) {
            dto.setCustomerView("1");
        }
        CustomerSelectPermissionDto customerSelectPermissionDto = this.customerOperate(dto);
        PermissionDto campaignPermissionDto = customerSelectPermissionDto.getCampaignPermissionDto();
        PermissionDto customerPermissionDto = customerSelectPermissionDto.getCustomerPermissionDto();
        List<CustomerDto> customerDtoList = this.getCustomerDtoList(dto);
        List<CustomerEntity> list = this.customerMapper.selectCustomerListCountOpportunity(customerDtoList, page = dto.getPage(), dto.getTimeOrder(), dto.getCurrentUserId(), customerPermissionDto, campaignPermissionDto);
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
            list.forEach(customer -> {
                customer.setLabelName(CrmLabelUtil.getLabelName(labelList, customer.getLabelId()));
                customer.setAiTagName(CrmLabelUtil.getLabelName(labelList, customer.getAiTags()));
            });
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(CustomerAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getCustomerScreening();
        }
        ICustomerAssociativeQueryService adapterService = this.customerAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("jxd_29Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    public int selectCustomerListCount(CustomerDto dto) {
        CustomerSelectPermissionDto customerSelectPermissionDto = this.customerOperate(dto);
        PermissionDto customerPermissionDto = customerSelectPermissionDto.getCustomerPermissionDto();
        PermissionDto campaignPermissionDto = customerSelectPermissionDto.getCampaignPermissionDto();
        CustomerDto customerDto = this.customerQueryCondition(dto);
        int customerCount = this.customerMapper.selectCustomerListCount(customerDto, customerPermissionDto, campaignPermissionDto);
        return customerCount;
    }

    @Override
    public Page<CustomerEntity> selectPartnerCustomerList(CustomerDto dto) {
        Page page = dto.getPage();
        String customerView = dto.getCustomerView();
        DateConvertVo dateConvertVo = null;
        if ("1".equals(customerView)) {
            dateConvertVo = CrmDateUtils.getWeekDate();
        }
        if ("2".equals(customerView)) {
            dateConvertVo = CrmDateUtils.getMonthDay();
        }
        if ("3".equals(customerView)) {
            dateConvertVo = CrmDateUtils.getYearDay();
        }
        if (dateConvertVo != null) {
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        if ("2".equals(customerView)) {
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if ("5".equals(customerView)) {
            dto.setCustomerType("1");
        }
        if ("6".equals(customerView)) {
            dto.setCustomerType("2");
        }
        dto.setDelFlag("0");
        List<CustomerEntity> list = this.customerMapper.selectPartnerCustomerList(dto, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public boolean deleteCrmCustomerByCustomerIds(List<String> customerIds) {
        Long optCount = this.opportunityService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getCustomerId, customerIds)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
        Long conCount = this.contactService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactEntity::getCustomerId, customerIds)).eq(ContactEntity::getDelFlag, (Object)"0"));
        if (optCount > 0L || conCount > 0L) {
            throw new BaseException("\u5ba2\u6237\u5df2\u4ea7\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        Long changeCount = this.trackRecordAPIService.countConvertCustomer(customerIds, "0");
        if (changeCount > 0L) {
            throw new BaseException("\u8f6c\u6362\u751f\u6210\u7684\u5ba2\u6237\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.customerMapper.deleteCrmCustomerByCustomerIds(customerIds, "1");
        this.teamMeberMapper.updateDelFlagByIds(null, "1", customerIds);
        List trackRecordList = this.trackRecordAPIService.list(customerIds, null, Collections.singletonList(RecordProductTypeEnum.PRODUCE_SYSTEM.getId()), "0");
        List<Object> recordIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)trackRecordList)) {
            recordIds = trackRecordList.stream().map(TrackRecordAPIVo::getRecordId).collect(Collectors.toList());
        }
        this.trackRecordAPIService.deleteBatchByIds(customerIds, CrmBusinessTypeEnum.CUSTOMER.getId(), "1");
        List<Long> lids = customerIds.stream().map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(recordIds)) {
            lids.addAll(recordIds);
        }
        this.fileInfoMapper.deleteFileInfoByIds(null, lids, "1");
        return true;
    }

    @Override
    @Transactional
    public Long saveCrmCustomer(CustomerDto customerDto) {
        String dataSource = customerDto.getDataSource();
        CustomerEntity customerEntity = new CustomerEntity();
        BeanUtils.copyProperties((Object)customerDto, (Object)customerEntity);
        customerEntity.setCustomerAttribute(customerDto.getCustomerAttribute() == null ? null : customerDto.getCustomerAttribute().toString());
        customerEntity.setCampaignId(HussarUtils.isEmpty((Object)customerDto.getCampaignId()) ? null : Long.valueOf(Long.parseLong(customerDto.getCampaignId())));
        customerEntity.setOwnDepartment(HussarUtils.isEmpty((Object)customerDto.getOwnDepartment()) ? null : Long.valueOf(Long.parseLong(customerDto.getOwnDepartment())));
        customerEntity.setChargePersonId(HussarUtils.isEmpty((Object)customerDto.getChargePersonId()) ? null : Long.valueOf(Long.parseLong(customerDto.getChargePersonId())));
        if (DataPermission.customerNameExists(customerEntity.getCustomerName().replace(" ", ""))) {
            throw new BaseException("\u5ba2\u6237\u540d\u79f0\u5df2\u5b58\u5728");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long customerId = customerEntity.getCustomerId();
        if (StringUtils.isEmpty((Object)customerId)) {
            customerId = Long.valueOf(CommonUtills.generateAssignId());
            customerEntity.setCustomerId(customerId);
            customerEntity.setCreateDepartment(user.getDeptId());
            customerEntity.setCreateDepartmentName(user.getDeptName());
            customerEntity.setTelephone(customerEntity.getTelephone().replaceAll(" ", ""));
            customerEntity.setCreatePerson(user.getUserId());
            customerEntity.setCreatePersonName(user.getUserName());
            customerEntity.setCreateTime(date);
            customerEntity.setDelFlag("0");
            customerEntity.setDisableRepeat("0");
            if (!LabelModuleEnum.WALLCHART.getModuleId().equals(dataSource) || customerEntity.getChargePersonId() == null) {
                customerEntity.setChargePersonId(user.getUserId());
                customerEntity.setChargePersonName(user.getUserName());
            }
            if (!LabelModuleEnum.WALLCHART.getModuleId().equals(dataSource) || customerEntity.getOwnDepartment() == null) {
                customerEntity.setOwnDepartment(user.getDeptId());
                customerEntity.setOwnDepartmentName(user.getDeptName());
            }
        } else {
            customerEntity.setOwnDepartment(user.getDeptId());
            customerEntity.setOwnDepartmentName(user.getDeptName());
            customerEntity.setChangePerson(user.getUserId());
            customerEntity.setChangePersonName(user.getUserName());
        }
        customerEntity.setChangeTime(date);
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)customerEntity.getProvince())) {
            customerEntity.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerEntity.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)customerEntity.getCity())) {
            customerEntity.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerEntity.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)customerEntity.getCounty())) {
            customerEntity.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerEntity.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        customerEntity.setRegionLabel(sb.toString());
        this.saveOrUpdate(customerEntity);
        this.checkProvinceDept(user, customerEntity, date);
        if (HussarUtils.isNotEmpty((Object)customerEntity.getSaveLabelDto()) && HussarUtils.isNotEmpty((Object)customerEntity.getSaveLabelDto().getAddLabelIds())) {
            customerEntity.getSaveLabelDto().setBusinessId(customerEntity.getCustomerId());
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(customerEntity.getCustomerId());
            customerEntity.getSaveLabelDto().setBusinessIds(list);
            customerEntity.getSaveLabelDto().setChooseBatch(Boolean.valueOf(false));
            customerEntity.getSaveLabelDto().setModuleId("customer");
            this.labelService.userSaveLabel(customerEntity.getSaveLabelDto());
        }
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CUSTOMER, customerId, customerEntity.getCustomerName(), date, false, Arrays.asList(customerId));
        this.teamMeberService.insertTeamMember(customerEntity.getChargePersonName(), customerEntity.getChargePersonId(), customerId, "1", "1", date, "1");
        FinancialInfoEntity financialInfoEntity = new FinancialInfoEntity();
        financialInfoEntity.setBusinessType("1");
        financialInfoEntity.setBusinessId(customerId);
        financialInfoEntity.setFinancialInfoId(Long.parseLong(CommonUtills.generateAssignId()));
        this.financialInfoService.save(financialInfoEntity);
        return customerId;
    }

    @Override
    public void checkProvinceDept(SecurityUser user, CustomerEntity customerEntity, LocalDateTime date) {
        List provinceDept = this.organUserBoService.selectProviceDeptIds();
        if (provinceDept.contains(user.getDeptId())) {
            TianYanChaDto tianYanChaDto = new TianYanChaDto();
            tianYanChaDto.setSearchKey(customerEntity.getCustomerName());
            CompanyBaseInfo companyBaseInfo = this.commonService.getBaseInfoByTianyancha(tianYanChaDto);
            String provinceId = companyBaseInfo == null || HussarUtils.isEmpty((Object)companyBaseInfo.getProvinceId()) ? customerEntity.getProvince() : String.valueOf(companyBaseInfo.getProvinceId());
            if (HussarUtils.isEmpty((Object)provinceId)) {
                return;
            }
            List regionVos = this.hussarBaseRegionBoService.getRegionInfoByIds(Collections.singletonList(Long.valueOf(provinceId)));
            String provinceName = CollectionUtil.isEmpty((Collection)regionVos) || regionVos.get(0) == null || ((RegionVo)regionVos.get(0)).getName() == null ? "\u672a\u77e5\u7701\u4efd" : ((RegionVo)regionVos.get(0)).getName();
            List struIdList = this.organUserBoService.getStruIdByProvinceCode(Long.valueOf(provinceId));
            if (CollectionUtil.isNotEmpty((Collection)struIdList) && !struIdList.contains(user.getDeptId())) {
                List userVoList = this.organUserBoService.getUserByRoleAndDept(this.crmProperties.getRoles().getSalesGM(), struIdList);
                Set provinceUserIdSet = userVoList.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toSet());
                String configValue = this.crmBaseConfigBoService.getCrmBaseConfigByKey("customer_province_warning_msg").getConfigValue();
                if (HussarUtils.isNotEmpty((Object)configValue)) {
                    provinceUserIdSet.addAll(Arrays.stream(configValue.split(",")).collect(Collectors.toSet()));
                }
                if (CollectionUtil.isNotEmpty(provinceUserIdSet)) {
                    String title = user.getDeptName() + "-" + user.getUserName() + "\u521b\u5efa\u4e86" + provinceName + "\u7684\u5ba2\u6237";
                    String content = "\u5ba2\u6237\u540d\u79f0\u3010" + customerEntity.getCustomerName() + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                    EimPushUtil.pushJqxArticleMessage(title, content, "/crm/kh/khxq", customerEntity.getCustomerId().toString(), new ArrayList<String>(provinceUserIdSet));
                    AddSysMessageType addSysMessageType = new AddSysMessageType();
                    String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + customerEntity.getCustomerId() + "\"";
                    String contentUnify = "\u3010\u5ba2\u6237\u63d0\u9192\u3011" + user.getDeptName() + "-" + user.getUserName() + "\u521b\u5efa\u4e86" + companyBaseInfo.getProvince() + "\u7684\u5ba2\u6237\uff0c\u5ba2\u6237\u540d\u79f0\u3010" + customerEntity.getCustomerName() + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                    UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, String.join((CharSequence)",", provinceUserIdSet), user.getUserName(), unifyWebUrl, "");
                    UnifyUtil.sendMessage(addSysMessageType);
                }
            }
        }
    }

    @Override
    public Integer selectRepeatNumber(CustomerDto dto) {
        int i = this.customerMapper.selectRepeatNumber(dto);
        return i;
    }

    @Override
    public String customerExport(HttpServletResponse response, CustomerDto dto) {
        CustomerSelectPermissionDto customerSelectPermissionDto = this.customerOperate(dto);
        PermissionDto campaignPermissionDto = customerSelectPermissionDto.getCampaignPermissionDto();
        PermissionDto customerPermissionDto = customerSelectPermissionDto.getCustomerPermissionDto();
        List<CustomerDto> dtoList = this.getCustomerDtoList(dto);
        List<CustomerEntity> list = this.customerMapper.selectCustomerListCountOpportunity(dtoList, null, dto.getTimeOrder(), dto.getCurrentUserId(), customerPermissionDto, campaignPermissionDto);
        List<CustomerEntity> customerEntityList = this.dictionaryTranslate(list);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, customerEntityList, "\u5ba2\u6237", CustomerEntity.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    @Override
    public String customerExportTemplate(HttpServletResponse response) {
        ArrayList list = new ArrayList();
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u5ba2\u6237\u6a21\u677f", CustomerEntity.class);
        return "\u5bfc\u51fa\u6a21\u677f\u6210\u529f";
    }

    @Override
    public String customerImport(MultipartFile file) {
        int flag = 0;
        ReadExcel readExcel = new ReadExcel();
        LocalDateTime date = LocalDateTime.now();
        try {
            List<CustomerEntity> list = ReadExcel.readExcel(file, CustomerEntity.class);
            for (CustomerEntity customer : list) {
                if (ToolUtil.isNotEmpty((Object)customer.getChargePersonName())) {
                    // empty if block
                }
                if (ToolUtil.isNotEmpty((Object)customer.getCustomerOrigin())) {
                    // empty if block
                }
                if (ToolUtil.isNotEmpty((Object)customer.getCustLevel())) {
                    // empty if block
                }
                SecurityUser user = BaseSecurityUtil.getUser();
                customer.setCustomerId(Long.valueOf(CommonUtills.generateAssignId()));
                customer.setCreatePerson(user.getUserId());
                customer.setCreatePersonName(user.getUserName());
                customer.setCreateTime(date);
                customer.setChangePerson(user.getUserId());
                customer.setChangePersonName(user.getUserName());
                customer.setChangeTime(date);
                customer.setDelFlag("0");
                int i = this.customerMapper.insertCrmCustomer(customer);
                if (i <= 0) continue;
                ++flag;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u5bfc\u5165\u5931\u8d25";
        }
        return "\u5171\u5bfc\u5165" + flag + "\u6761\u6570\u636e";
    }

    @Override
    @Transactional
    public TransferBatchResultVo customerTransfer(List<CustomerDto> dtos) {
        List contactCustomerList;
        List opportunityCustomerList;
        TransferBatchResultVo customerResultVo = new TransferBatchResultVo();
        customerResultVo.setTransferResult(true);
        List<String> msgList = new ArrayList<String>();
        if (CollectionUtil.isEmpty(dtos)) {
            customerResultVo.setTransferResult(false);
            customerResultVo.setMsgList(Collections.singletonList("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u7f3a\u5c11\u53c2\u6570"));
            return customerResultVo;
        }
        int total = dtos.size();
        int nums = 0;
        List<CustomerDto> transferList = this.getTransferList(dtos);
        if (CollectionUtil.isEmpty(transferList)) {
            String msg2 = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", nums, total);
            customerResultVo.setTransferResult(false);
            customerResultVo.setMsgList(Collections.singletonList(msg2 + "\u65e0\u6743\u9650"));
            return customerResultVo;
        }
        nums = transferList.size();
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        String newChargePersonId = CommonUtills.translateUserId(dtos.get(0).getNewChargePersonId());
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        ArrayList<CustomerDto> updateCustomerList = new ArrayList<CustomerDto>();
        ArrayList<TeamMeberEntity> deleteTeamMemberList = new ArrayList<TeamMeberEntity>();
        ArrayList<TeamMeberEntity> updateTeamMemberList = new ArrayList<TeamMeberEntity>();
        ArrayList<TeamMeberEntity> insertTeamMemberList = new ArrayList<TeamMeberEntity>();
        ArrayList insertTrackRecordList = new ArrayList();
        ArrayList<EimPushMessage> eimPushMessageList = new ArrayList<EimPushMessage>();
        ArrayList<AddSysMessageType> addSysMessageTypeList = new ArrayList<AddSysMessageType>();
        for (CustomerDto dto : transferList) {
            String keepFlag = dto.getKeepFlag();
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            String userId = user.getId().toString();
            String userName = user.getUserName();
            String oldChargePersonName = dto.getOldChargePersonName();
            String oldChargePersonId = dto.getOldChargePersonId();
            if (newChargePersonId.equals(oldChargePersonId) && newChargePersonName.equals(oldChargePersonName)) {
                if (dtos.size() != 1) continue;
                customerResultVo.setTransferResult(false);
                customerResultVo.setMsgList(Collections.singletonList("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65b0\u65e7\u8d1f\u8d23\u4eba\u4e00\u81f4"));
                return customerResultVo;
            }
            String customerName = dto.getCustomerName();
            Long customerId = dto.getCustomerId();
            this.addUpdateCustomer2List(updateCustomerList, date, userId, userName, newChargePersonId, newChargePersonName, newOwnDepartment.toString(), newOwnDepartmentName, customerId);
            Long oldPersonId = Long.parseLong(oldChargePersonId);
            Long newPersonId = Long.parseLong(newChargePersonId);
            if ("0".equals(keepFlag)) {
                this.addDeleteTeamMember2List(deleteTeamMemberList, oldPersonId, customerId);
            } else if ("1".equals(keepFlag)) {
                this.addUpdateTeamMember2List(updateTeamMemberList, oldPersonId, customerId, "0", "6", null);
            }
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setPersonId(newPersonId);
            teamMeberDto.setBusinessId(customerId);
            teamMeberDto.setDelFlag("0");
            teamMeberDto.setBusinessType("1");
            List<TeamMeberEntity> list = this.teamMeberMapper.selectTeamMeberList(null, teamMeberDto);
            if (CollectionUtil.isEmpty(list)) {
                this.addInsertTeamMember2List(insertTeamMemberList, newChargePersonName, Long.parseLong(newChargePersonId), customerId, "1", "1", date, "1", mapDepartment);
            } else {
                this.addUpdateTeamMember2List(updateTeamMemberList, newPersonId, customerId, "1", null, "1");
            }
            Long recordId = Long.valueOf(CommonUtills.generateAssignId());
            String productType = RecordProductTypeEnum.PRODUCE_TRANSFER.getId();
            this.operateRecordAPIService.addInsertOperateLogList(insertTrackRecordList, CrmBusinessTypeEnum.CUSTOMER, productType, newPersonId, newChargePersonName, oldPersonId, oldChargePersonName, recordId, customerId, customerName, date);
            String contractFlag = dto.getContractFlag();
            if ("0".equals(contractFlag) || "1".equals(contractFlag)) {
                // empty if block
            }
            String title = user.getUserName() + "\u5c06\u5ba2\u6237\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8";
            String content = "\u5ba2\u6237\u540d\u79f0\u3010" + customerName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            EimPushMessage eimPushMessage = new EimPushMessage(title, content, "/crm/kh/khxq", dto.getCustomerId().toString(), Arrays.asList(dto.getNewChargePersonId()));
            eimPushMessageList.add(eimPushMessage);
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + dto.getCustomerId() + "\"";
            addSysMessageType.setBusinessAddress(unifyWebUrl);
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u5ba2\u6237\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8\uff0c\u5ba2\u6237\u540d\u79f0\u3010" + customerName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, dto.getNewChargePersonId(), user.getUserName(), unifyWebUrl, "");
            addSysMessageTypeList.add(addSysMessageType);
            String oldTitle = userName + "\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u5ba2\u6237";
            String oldContent = "\u5ba2\u6237\u540d\u79f0\u3010" + customerName + "\u3011\uff0c\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushMessage oldEimPushMessage = new EimPushMessage(oldTitle, oldContent, "/crm/kh/khxq", dto.getCustomerId().toString(), Arrays.asList(oldChargePersonId));
            eimPushMessageList.add(oldEimPushMessage);
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            oldAddSysMessageType.setBusinessAddress(unifyWebUrl);
            String oldContentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + "\u5c06\u60a8\u8d1f\u8d23\u7684\u5ba2\u6237\u3010" + customerName + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage(oldAddSysMessageType, oldContentUnify, date, user, dto.getOldChargePersonId(), user.getUserName(), unifyWebUrl, "");
            addSysMessageTypeList.add(oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("1");
            crmTeamAdminInfoDto.setBusinessId(customerId);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(oldChargePersonId);
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        if (CollectionUtil.isNotEmpty(updateCustomerList)) {
            this.customerMapper.updateChargePersonNameBatch(updateCustomerList);
        }
        if (CollectionUtil.isNotEmpty(deleteTeamMemberList)) {
            this.teamMeberMapper.deleteChargePersonBatch(deleteTeamMemberList);
        }
        if (CollectionUtil.isNotEmpty(updateTeamMemberList)) {
            this.teamMeberMapper.updateIsChargeBatch(updateTeamMemberList);
        }
        if (CollectionUtil.isNotEmpty(insertTeamMemberList)) {
            this.teamMeberService.saveBatch(insertTeamMemberList);
        }
        if (CollectionUtil.isNotEmpty(insertTrackRecordList)) {
            this.operateRecordAPIService.saveOperateLogBatch(insertTrackRecordList);
        }
        if (nums != dtos.size()) {
            customerResultVo.setTransferResult(false);
            int failCount = total - nums;
            String msg3 = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", nums, failCount);
            msg3 = "\u5ba2\u6237\uff1a" + msg3 + "\u65e0\u6743\u9650" + "\u3002";
            msgList.add(msg3);
        } else {
            String msg4 = "\u5ba2\u6237\uff1a\u8f6c\u79fb\u6210\u529f\u3002";
            msgList.add(msg4);
        }
        String opportunityFlag = dtos.get(0).getOpportunityFlag();
        String keepOpportunityFlag = dtos.get(0).getKeepOpportunityFlag();
        List customerIdList = dtos.stream().map(CustomerDto::getCustomerId).collect(Collectors.toList());
        if ("1".equals(opportunityFlag) && CollectionUtil.isNotEmpty((Collection)(opportunityCustomerList = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getCustomerId, customerIdList)).eq(OpportunityEntity::getDelFlag, (Object)"0"))))) {
            List<OpportunityDto> transferOpportunityList = opportunityCustomerList.stream().map(opportunityEntitity -> {
                OpportunityDto opportunityDto = new OpportunityDto();
                BeanUtils.copyProperties((Object)opportunityEntitity, (Object)opportunityDto);
                Long opportunityId = opportunityEntitity.getOpportunityId();
                opportunityDto.setOpportunityId(opportunityId);
                opportunityDto.setOldChargePersonId(opportunityEntitity.getChargePersonId() == null ? null : opportunityEntitity.getChargePersonId().toString());
                opportunityDto.setOldChargePersonName(opportunityEntitity.getChargePersonName());
                opportunityDto.setKeepFlag(keepOpportunityFlag);
                opportunityDto.setNewChargePersonId(newChargePersonId);
                opportunityDto.setNewChargePersonName(newChargePersonName);
                return opportunityDto;
            }).collect(Collectors.toList());
            TransferBatchResultVo opportunityResultVo = this.opportunityService.opportunityTransferBatch(transferOpportunityList);
            if (opportunityResultVo != null && !opportunityResultVo.getTransferResult().booleanValue()) {
                customerResultVo.setTransferResult(false);
                if (CollectionUtil.isNotEmpty(opportunityResultVo.getMsgList())) {
                    msgList.addAll(opportunityResultVo.getMsgList().stream().map(msg -> {
                        msg = "\u5546\u673a\uff1a" + msg;
                        return msg;
                    }).collect(Collectors.toList()));
                }
            } else {
                String msg5 = "\u5546\u673a\uff1a\u8f6c\u79fb\u6210\u529f";
                msgList.add(msg5);
            }
        }
        String contactFlag = dtos.get(0).getContactFlag();
        String keepContactFlag = dtos.get(0).getKeepContactFlag();
        if ("1".equals(contactFlag) && CollectionUtil.isNotEmpty((Collection)(contactCustomerList = this.contactService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactEntity::getCustomerId, customerIdList)).eq(ContactEntity::getDelFlag, (Object)"0"))))) {
            ArrayList<ContactDto> transferContactList = new ArrayList<ContactDto>();
            for (ContactEntity contactEntity : contactCustomerList) {
                Long contactId = contactEntity.getContactId();
                ContactDto contactDto1 = new ContactDto();
                contactDto1.setContactId(contactId);
                contactDto1.setContactName(contactEntity.getContactName());
                contactDto1.setOldChargePersonId(contactEntity.getChargePersonId() == null ? null : contactEntity.getChargePersonId().toString());
                contactDto1.setOldChargePersonName(contactEntity.getChargePersonName());
                contactDto1.setNewChargePersonId(newChargePersonId);
                contactDto1.setNewChargePersonName(newChargePersonName);
                contactDto1.setKeepFlag(keepContactFlag);
                transferContactList.add(contactDto1);
            }
            if (CollectionUtil.isNotEmpty(transferContactList)) {
                TransferBatchResultVo contactResultVo = this.contactService.contactTransferBatch(transferContactList);
                if (contactResultVo != null && !contactResultVo.getTransferResult().booleanValue()) {
                    customerResultVo.setTransferResult(false);
                    if (CollectionUtil.isNotEmpty(contactResultVo.getMsgList())) {
                        msgList.addAll(contactResultVo.getMsgList().stream().map(msg -> {
                            msg = "\u8054\u7cfb\u4eba\uff1a" + msg;
                            return msg;
                        }).collect(Collectors.toList()));
                    }
                } else {
                    String msg6 = "\u8054\u7cfb\u4eba\uff1a\u8f6c\u79fb\u6210\u529f";
                    msgList.add(msg6);
                }
            }
        }
        if (customerResultVo.getTransferResult().booleanValue()) {
            msgList = Collections.singletonList("\u8f6c\u79fb\u6210\u529f");
        }
        customerResultVo.setMsgList(msgList);
        if (CollectionUtil.isNotEmpty(eimPushMessageList)) {
            for (EimPushMessage message : eimPushMessageList) {
                EimPushUtil.pushJqxArticleMessage(message.getTitle(), message.getContent(), message.getUrl(), message.getBid(), message.getSendUsers());
            }
        }
        if (CollectionUtil.isNotEmpty(addSysMessageTypeList)) {
            for (AddSysMessageType messageType : addSysMessageTypeList) {
                UnifyUtil.sendMessage(messageType);
            }
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return customerResultVo;
    }

    private void addDeleteTeamMember2List(List<TeamMeberEntity> deleteTeamMemberList, Long personId, Long customerId) {
        TeamMeberEntity deleteTeamMember = new TeamMeberEntity();
        deleteTeamMember.setPersonId(personId);
        deleteTeamMember.setBusinessId(customerId);
        deleteTeamMemberList.add(deleteTeamMember);
    }

    private void addUpdateTeamMember2List(List<TeamMeberEntity> updateTeamMemberList, Long personId, Long customerId, String isCharge, String memberRole, String modifyPower) {
        TeamMeberEntity updateTeamMember = new TeamMeberEntity();
        updateTeamMember.setPersonId(personId);
        updateTeamMember.setBusinessId(customerId);
        updateTeamMember.setIsCharge(isCharge);
        updateTeamMember.setMemberRole(memberRole);
        updateTeamMember.setModifyPower(modifyPower);
        updateTeamMemberList.add(updateTeamMember);
    }

    private void addUpdateCustomer2List(List<CustomerDto> updateCustomerList, LocalDateTime date, String userId, String userName, String newChargePersonId, String newChargePersonName, String newOwnDepartment, String newOwnDepartmentName, Long customerId) {
        CustomerDto updateCustomerDto = new CustomerDto();
        updateCustomerDto.setChangeTime(date);
        updateCustomerDto.setChangePerson(userId);
        updateCustomerDto.setChangePersonName(userName);
        updateCustomerDto.setNewChargePersonId(newChargePersonId);
        updateCustomerDto.setNewChargePersonName(newChargePersonName);
        updateCustomerDto.setOwnDepartment(newOwnDepartment);
        updateCustomerDto.setOwnDepartmentName(newOwnDepartmentName);
        updateCustomerDto.setCustomerId(customerId);
        updateCustomerList.add(updateCustomerDto);
    }

    private void addInsertTeamMember2List(List<TeamMeberEntity> insertTeamMemberList, String memberName, Long personId, Long businessId, String modifyPower, String isCharge, LocalDateTime date, String businessType, PersonWithDepInfo dep) {
        SecurityUser user = BaseSecurityUtil.getUser();
        TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
        teamMeberEntity.setTeamMeberId(Long.valueOf(CommonUtills.generateAssignId()));
        teamMeberEntity.setTeamMeberName(memberName);
        teamMeberEntity.setPersonId(personId);
        teamMeberEntity.setBusinessId(businessId);
        teamMeberEntity.setBusinessType(businessType);
        teamMeberEntity.setModifyPower(modifyPower);
        teamMeberEntity.setIsCharge(isCharge);
        teamMeberEntity.setCreatePerson(user.getUserId());
        teamMeberEntity.setCreatePersonName(user.getUserName());
        teamMeberEntity.setCreateTime(date);
        if ("0".equals(teamMeberEntity.getIsCharge())) {
            teamMeberEntity.setMemberRole("6");
        }
        if (ToolUtil.isNotEmpty((Object)dep)) {
            teamMeberEntity.setOwnDepartment(dep.getDepartmentId());
            teamMeberEntity.setOwnDepartmentName(dep.getDepartmentName());
        }
        teamMeberEntity.setUpdatePerson(user.getUserId());
        teamMeberEntity.setUpdateTime(date);
        teamMeberEntity.setUpdatePersonName(user.getUserName());
        teamMeberEntity.setDelFlag("0");
        insertTeamMemberList.add(teamMeberEntity);
    }

    @Override
    public CustomerEntityVo customerDetails(Long customerId) {
        List fileRecordIds;
        String poolOperate;
        CustomerIncludePool customerIncludePool = (CustomerIncludePool)this.customerIncludePoolService.getById(customerId);
        if (customerIncludePool == null || "1".equals(customerIncludePool.getDelFlag())) {
            return null;
        }
        if (customerIncludePool.getCustomerPoolId() != null ? !"isNormal".equals(poolOperate = this.poolCustomerService.operate(customerIncludePool.getCustomerPoolId(), customerId)) && !"isManage".equals(poolOperate) : this.isOperate(customerId).getViewOperate() == false) {
            return null;
        }
        if (customerId == null) {
            throw new BaseException("\u5ba2\u6237id\u4e3a\u7a7a");
        }
        CustomerEntityVo customerEntityVo = (CustomerEntityVo)BeanUtil.copyProperties((Object)customerIncludePool, CustomerEntityVo.class);
        if (customerEntityVo == null || customerEntityVo.getCustomerId() == null) {
            return null;
        }
        if (HussarUtils.isNotEmpty((Object)customerEntityVo.getCustomerPoolId())) {
            CustomerPoolEntity customerPool = (CustomerPoolEntity)this.customerPoolService.getById(customerEntityVo.getCustomerPoolId());
            customerEntityVo.setCustomerPoolName(customerPool.getCustomerPoolName());
        }
        if (HussarUtils.isNotEmpty((Object)customerEntityVo.getAgentId())) {
            AgentApiVo agentApiVo = this.agentApiService.getById((Serializable)customerEntityVo.getAgentId());
            if (!"1".equals(agentApiVo.getDelFlag())) {
                customerEntityVo.setAgentName(agentApiVo.getAgentName());
            } else {
                customerEntityVo.setAgentName("");
            }
        }
        assert (customerEntityVo != null);
        this.setCustomerDic(customerEntityVo);
        Long count = this.contactService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getCustomerId, (Object)customerEntityVo.getCustomerId())).eq(ContactEntity::getDelFlag, (Object)"0"));
        customerEntityVo.setContactAmount(count);
        OpportunityDto opportunityDto = new OpportunityDto();
        opportunityDto.setCustomerId(customerEntityVo.getCustomerId().toString());
        opportunityDto.setDelFlag("0");
        Page opportunityPage = new Page();
        opportunityPage.setSize(1L);
        opportunityPage.setCurrent(1L);
        SecurityUser user = BaseSecurityUtil.getUser();
        opportunityDto.setCurrentUserId(user.getUserId());
        long total = this.globalOpportunityService.selectCrmOpportunityCount(opportunityDto, false);
        customerEntityVo.setOpportunityTotalAmount(total);
        List recordList = this.trackRecordAPIService.list(Collections.singletonList(customerEntityVo.getCustomerId().toString()), null, null, "0");
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(customerEntityVo.getCustomerId());
        if (CollectionUtil.isNotEmpty((Collection)recordList)) {
            for (TrackRecordAPIVo record : recordList) {
                businessIds.add(record.getRecordId());
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(fileRecordIds = this.trackRecordAPIService.selectRelationRecordIds(customerId)))) {
            businessIds.addAll(fileRecordIds);
        }
        customerEntityVo.setFileInfoAmount(this.fileInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1")));
        customerEntityVo.setTeamMemberAmount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)customerEntityVo.getCustomerId())).eq(TeamMeberEntity::getBusinessType, (Object)"1")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        customerEntityVo.setCharacterAmount(this.taskAPIService.selectTaskCount("1", customerId));
        customerEntityVo.setScheduleAmount(0L);
        long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)customerEntityVo.getCustomerId())).eq(FocusEntity::getBusinessType, (Object)Character.valueOf('1'))).eq(FocusEntity::getCreatePersion, (Object)user.getUserId()));
        customerEntityVo.setFocus(focusCount > 0L);
        List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
        customerEntityVo.setLabelName(CrmLabelUtil.getLabelName(labelList, customerEntityVo.getLabelId()));
        customerEntityVo.setAiTagName(CrmLabelUtil.getLabelName(labelList, customerEntityVo.getAiTags()));
        Long quotationNumber = this.quotationApiService.queryQuotationNumbersByCustomerId(customerId);
        customerEntityVo.setQuotationNumber(Math.toIntExact(quotationNumber));
        FinancialInfoEntity financialInfoEntity = (FinancialInfoEntity)this.financialInfoService.getOne((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(FinancialInfoEntity::getBusinessId, (Object)customerId)).eq(FinancialInfoEntity::getBusinessType, (Object)"1"));
        customerEntityVo.setFinancialInfoEntity(financialInfoEntity);
        return customerEntityVo;
    }

    private void setCustomerDic(CustomerEntityVo customerEntityVo) {
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getCustLevel())) {
            customerEntityVo.setCustLevel(this.sysDicRefService.getDictLabel("customer_level", customerEntityVo.getCustLevel()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getLastRevenue())) {
            customerEntityVo.setLastRevenue(this.sysDicRefService.getDictLabel("last_revenue", customerEntityVo.getLastRevenue()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getCustomerOrigin())) {
            customerEntityVo.setCustomerOrigin(this.sysDicRefService.getDictLabel("customer_source", customerEntityVo.getCustomerOrigin()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getTrade())) {
            customerEntityVo.setTrade(this.sysDicRefService.getDictLabel("industry", customerEntityVo.getTrade()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getCustomerAttribute())) {
            customerEntityVo.setCustomerAttribute(this.sysDicRefService.getDictLabel("customer_type", customerEntityVo.getCustomerAttribute()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getStaffNumber())) {
            customerEntityVo.setStaffNumber(this.sysDicRefService.getDictLabel("staff_nums", customerEntityVo.getStaffNumber()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getCustomerStage())) {
            customerEntityVo.setCustomerStage(this.sysDicRefService.getDictLabel("customer_stage", customerEntityVo.getCustomerStage()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getCorporateScale())) {
            customerEntityVo.setCorporateScale(this.sysDicRefService.getDictLabel("corporate_scale", customerEntityVo.getCorporateScale()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getListingStatus())) {
            customerEntityVo.setListingStatus(this.sysDicRefService.getDictLabel("listing_status", customerEntityVo.getListingStatus()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getCustomerRelation())) {
            customerEntityVo.setCustomerRelation(this.sysDicRefService.getDictLabel("customer_relation", customerEntityVo.getCustomerRelation()));
        }
        if (StringUtil.isNotBlank((CharSequence)customerEntityVo.getCustomerRisk())) {
            customerEntityVo.setCustomerRisk(this.sysDicRefService.getDictLabel("customer_risk", customerEntityVo.getCustomerRisk()));
        }
    }

    @Override
    public String customerMarge(CustomerEntity customerEntity) {
        if (customerEntity.getCustomerId() == null) {
            throw new BaseException("\u5ba2\u6237id\u4e3a\u7a7a");
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        customerEntity.setChangePerson(user.getUserId());
        customerEntity.setChangePersonName(user.getUserName());
        customerEntity.setChangeTime(date);
        this.saveOrUpdate(customerEntity);
        if (customerEntity.getCustomerMargeIds().size() > 0) {
            this.customerMapper.margeContact(customerEntity.getCustomerMargeIds(), customerEntity.getCustomerId(), customerEntity.getCustomerName());
            this.customerMapper.margeOpportunity(customerEntity.getCustomerMargeIds(), customerEntity.getCustomerId(), customerEntity.getCustomerName());
            this.customerMapper.margeTrackRecord(customerEntity.getCustomerMargeIds(), customerEntity.getCustomerId());
            this.customerMapper.deleteCrmCustomerByCustomerIds(customerEntity.getCustomerMargeIds(), "1");
        }
        return "\u5408\u5e76\u5b8c\u6210";
    }

    @Override
    public OperateVo isOperate(Long customerId) {
        OperateVo operateVo = new OperateVo();
        if (customerId == null) {
            return operateVo;
        }
        CustomerEntity customerEntity = (CustomerEntity)this.getById(customerId);
        if (customerEntity == null || "1".equals(customerEntity.getDelFlag())) {
            PoolCustomerEntity poolCustomerEntity = (PoolCustomerEntity)this.poolCustomerService.getById(customerId);
            if (poolCustomerEntity != null && "0".equals(poolCustomerEntity.getDelFlag())) {
                String poolOperate = this.poolCustomerService.operate(poolCustomerEntity.getCustomerPoolId(), customerId);
                if (!"isNormal".equals(poolOperate) && !"isManage".equals(poolOperate)) {
                    return operateVo;
                }
                operateVo.setEditOperate(Integer.valueOf(1));
                operateVo.setViewOperate(Boolean.valueOf(true));
                return operateVo;
            }
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (Objects.equals(customerEntity.getChargePersonId(), user.getUserId())) {
            operateVo.setViewOperate(Boolean.valueOf(true));
            operateVo.setEditOperate(Integer.valueOf(1));
            return operateVo;
        }
        this.teamMemberApiService.teamMemberOperate(customerId, user, operateVo, "1");
        if (!operateVo.getViewOperate().booleanValue()) {
            Integer count = this.customerMapper.getProductManagerByCustomerId(customerEntity.getCustomerId(), "0", user.getUserId());
            if (count > 0) {
                operateVo.setViewOperate(Boolean.valueOf(true));
            } else {
                PermissionDto customerPermissionDto = this.customerDataRightModuleService.getCurrentUserRolePermissions();
                if (customerPermissionDto.getPermissionDeptIds() == null || customerPermissionDto.getPermissionDeptIds().contains(customerEntity.getOwnDepartment())) {
                    operateVo.setViewOperate(Boolean.valueOf(true));
                }
                if (!operateVo.getViewOperate().booleanValue() && customerEntity.getCampaignId() != null) {
                    List campaignTeamMemberIdList = this.teamMeberService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TeamMeberEntity::getPersonId}).eq(TeamMeberEntity::getBusinessId, (Object)customerEntity.getCampaignId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"5"), s -> (Long)s);
                    if (CollectionUtil.isNotEmpty((Collection)campaignTeamMemberIdList)) {
                        operateVo.setViewOperate(Boolean.valueOf(true));
                    } else {
                        PermissionDto campaignPermissionDto;
                        MarketingActivityEntity marketingActivityEntity = (MarketingActivityEntity)this.marketingActivityService.getById(customerEntity.getCampaignId());
                        if (marketingActivityEntity != null && (CollectionUtil.isEmpty((Collection)(campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user)).getPermissionDeptIds()) || campaignPermissionDto.getPermissionDeptIds().contains(marketingActivityEntity.getOwnDepartment()))) {
                            operateVo.setViewOperate(Boolean.valueOf(true));
                        }
                    }
                }
            }
        }
        return operateVo;
    }

    public List<CustomerDto> getTransferList(List<CustomerDto> dtoList) {
        if (CollectionUtil.isEmpty(dtoList)) {
            return null;
        }
        List customerIdList = dtoList.stream().map(CustomerDto::getCustomerId).collect(Collectors.toList());
        List customerEntityList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getDelFlag, (Object)"0")).in(CustomerEntity::getCustomerId, customerIdList));
        if (CollectionUtil.isEmpty((Collection)customerEntityList)) {
            return null;
        }
        Map<Long, CustomerDto> dtoMap = dtoList.stream().collect(Collectors.toMap(CustomerDto::getCustomerId, customerDto -> customerDto));
        for (CustomerEntity customerEntity : customerEntityList) {
            Long customerId = customerEntity.getCustomerId();
            CustomerDto customerDto2 = dtoMap.get(customerId);
            if (customerDto2 == null) continue;
            customerDto2.setCustomerName(customerEntity.getCustomerName());
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Boolean transferPermission = false;
        HashSet<CustomerDto> transferCustomerSet = new HashSet<CustomerDto>();
        for (CustomerEntity customerEntity : customerEntityList) {
            transferPermission = this.editCustomerOperate(customerEntity, user, "customer_edit");
            if (!transferPermission.booleanValue()) continue;
            transferCustomerSet.add(dtoMap.get(customerEntity.getCustomerId()));
        }
        return new ArrayList<CustomerDto>(transferCustomerSet);
    }

    @Override
    public Page<CustomerRepeatStatistics> repeatCustomerStatistics(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        List<CustomerRepeatStatistics> list = this.customerMapper.repeatCustomerStatistics(dto, (Page<CustomerRepeatStatistics>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<CustomerEntity> repeatCustomerList(SalesStatisticsDto dto) {
        if (StringUtil.isEmpty((Object)dto.getSearchKey())) {
            throw new BaseException("\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        List<CustomerEntity> list = this.customerMapper.repeatCustomerList(dto, (Page<CustomerEntity>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<VehicleApplication> selectVehicleApplicationByCustomerId(CustomerDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        List<VehicleApplication> list = this.customerMapper.selectVehicleApplicationByCustomerId(dto, (Page<VehicleApplication>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<CustomerEntityVo> customerSynthesisAnalysis(SalesStatisticsDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto customerPermissionDto = this.customerDataRightModuleService.getUserRolePermission(user);
        PermissionDto campaignPermissionDto = new PermissionDto();
        campaignPermissionDto.setPermissionUserId(Long.valueOf(-1L));
        campaignPermissionDto.setPermissionDeptIds(Collections.singletonList(-1L));
        campaignPermissionDto.setPermissionProductIds(Collections.singletonList(-1L));
        campaignPermissionDto.setCurrentUserId(Long.valueOf(-1L));
        dto.setDelFlag("0");
        List stageProcessIds = new ArrayList<Long>();
        if (ToolUtil.isEmpty((Object)dto.getStageProcessId())) {
            stageProcessIds = this.stageProcessService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{StageProcessEntity::getStageProcessId}).eq(StageProcessEntity::getDelFlag, (Object)"0")).eq(StageProcessEntity::getPublishStatus, (Object)"1"), s -> Long.valueOf(s.toString()));
            stageProcessIds.addAll(stageProcessIds);
        } else {
            stageProcessIds.add(dto.getStageProcessId());
        }
        List successStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).in(OpportunityStage::getStageProcessId, stageProcessIds)).eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
        dto.setSuccessStageIds(successStageIds);
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && StringUtil.isNotBlank((CharSequence)dto.getDeptIds().get(0).toString()) && !"100001".equals(dto.getDeptIds().get(0).toString())) {
            SysStru sysStru = (SysStru)this.struService.getById((Serializable)((Object)dto.getDeptIds().get(0).toString()));
            if ("2".equals(sysStru.getStruType())) {
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(dto.getDeptIds().get(0).toString());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                List<Long> newDeptIds = deptIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                dto.setDeptIds(newDeptIds);
            }
        } else if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && "1".equals(dto.getDeptIds().get(0).toString())) {
            dto.setDeptIds(null);
        }
        List<Long> customerPoolIdList = this.customerPoolMemberService.getCustomerPoolIdByUser(user);
        if (HussarUtils.isEmpty(customerPoolIdList)) {
            customerPoolIdList = new ArrayList<Long>();
            customerPoolIdList.add(-1L);
        }
        List<CustomerEntityVo> list = this.customerMapper.customerSynthesisAnalysis(dto, (Page<CustomerEntityVo>)page, customerPoolIdList, customerPermissionDto, campaignPermissionDto);
        page.setRecords(list);
        return page;
    }

    @Override
    public ApiResponse<CheckRepeat> selectCustomerRepeate(CheckDuplicateCustomerDto dto) {
        long countFuzzy;
        if (HussarUtils.isEmpty((Object)dto.getCustomerName())) {
            return ApiResponse.success((Object)new CheckRepeat(){
                {
                    this.setToastMsg("");
                    this.setAllowSaving(true);
                }
            });
        }
        long countAccurate = HussarUtils.isNotEmpty((Object)dto.getCustomerId()) ? this.customerIncludePoolService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerName, (Object)dto.getCustomerName())).eq(CustomerEntity::getDelFlag, (Object)"0")).ne(CustomerEntity::getCustomerId, (Object)dto.getCustomerId())) : this.customerIncludePoolService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerName, (Object)dto.getCustomerName())).eq(CustomerEntity::getDelFlag, (Object)"0"));
        if (countAccurate > 0L) {
            return ApiResponse.success((Object)new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u5ba2\u6237\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5f55\u5165");
                    this.setAllowSaving(false);
                }
            });
        }
        if (dto.getManualInput() != null && dto.getManualInput().booleanValue() && (countFuzzy = HussarUtils.isNotEmpty((Object)dto.getCustomerId()) ? this.customerIncludePoolService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(CustomerEntity::getCustomerName, (Object)dto.getCustomerName())).eq(CustomerEntity::getDelFlag, (Object)"0")).ne(CustomerEntity::getCustomerId, (Object)dto.getCustomerId())) : this.customerIncludePoolService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(CustomerEntity::getCustomerName, (Object)dto.getCustomerName())).eq(CustomerEntity::getDelFlag, (Object)"0"))) > 0L) {
            return ApiResponse.success((Object)new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u5ba2\u6237\u7591\u4f3c\u5b58\u5728");
                    this.setAllowSaving(true);
                }
            });
        }
        return ApiResponse.success((Object)new CheckRepeat(){
            {
                this.setToastMsg("");
                this.setAllowSaving(true);
            }
        });
    }

    @Override
    public List<CustomerEntity> selectRepeatCustomerList(CustomerDto customerDto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto dto = this.customerDataRightModuleService.getCurrentUserRolePermissions();
        if (CollectionUtil.isEmpty((Collection)dto.getPermissionDeptIds())) {
            dto.setPermissionDeptIds(Collections.EMPTY_LIST);
        }
        customerDto.setDelFlag("0");
        List<CustomerEntity> customerEntityList = this.customerMapper.selectRepeatCustomerList(customerDto);
        if (CollectionUtil.isEmpty(customerEntityList)) {
            return null;
        }
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        Long parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId());
        List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId);
        List deptLongIds = deptIds.stream().map(Long::valueOf).collect(Collectors.toList());
        for (CustomerEntity customer : customerEntityList) {
            List teamMemberList = this.teamMeberService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TeamMeberEntity::getPersonId}).eq(TeamMeberEntity::getBusinessId, (Object)customer.getCustomerId())).eq(TeamMeberEntity::getModifyPower, (Object)"1")).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getBusinessType, (Object)"1"), s -> Long.parseLong(s.toString()));
            if (customer.getChargePersonId().equals(dto.getCurrentUserId())) {
                customer.setRepeat("1");
                continue;
            }
            if (dto.getPermissionDeptIds().contains(customer.getOwnDepartment())) {
                customer.setRepeat("2");
                continue;
            }
            if (teamMemberList.size() > 0 && teamMemberList.contains(user.getUserId())) {
                if (!deptLongIds.contains(customer.getOwnDepartment()) && ToolUtil.isNotEmpty((Object)customer.getDisableRepeat()) && "1".equals(customer.getDisableRepeat())) {
                    customer.setRepeat("5");
                    continue;
                }
                customer.setRepeat("1");
                continue;
            }
            if (deptLongIds.contains(customer.getOwnDepartment())) {
                customer.setRepeat("3");
                continue;
            }
            if (ToolUtil.isNotEmpty((Object)customer.getDisableRepeat()) && "1".equals(customer.getDisableRepeat())) {
                customer.setRepeat("5");
                continue;
            }
            customer.setRepeat("4");
        }
        return customerEntityList;
    }

    @Override
    public Boolean updateDisableRepeatById(CustomerDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getCustomerId())) {
            throw new BaseException("\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)dto.getDisableRepeat())) {
            throw new BaseException("\u5ba2\u6237\u4f8b\u5916\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerEntity customerEntity = new CustomerEntity();
        customerEntity.setCustomerId(dto.getCustomerId());
        customerEntity.setDisableRepeat(dto.getDisableRepeat());
        return this.updateById(customerEntity);
    }

    @Override
    public ExceptionCustomerVo selectExceptionCustomer(String customerName) {
        SecurityUser user;
        ExceptionCustomerVo exceptionCustomerVo = new ExceptionCustomerVo();
        List customerEntityList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerName, (Object)customerName)).eq(CustomerEntity::getDisableRepeat, (Object)"1")).eq(CustomerEntity::getDelFlag, (Object)"0")).orderByAsc(CustomerEntity::getCreateTime));
        if (CollectionUtil.isEmpty((Collection)customerEntityList)) {
            exceptionCustomerVo.setAuthority(-3);
            return exceptionCustomerVo;
        }
        CustomerEntity customer = (CustomerEntity)customerEntityList.get(0);
        Stru stru = this.commonMapper.selectStru(customer.getOwnDepartment());
        String bgDepartmentName = "";
        if (ToolUtil.isNotEmpty((Object)stru)) {
            bgDepartmentName = "100001".equals(stru.getParentId()) ? stru.getOrganAlias() : this.commonMapper.selectStru(Long.valueOf(stru.getParentId())).getOrganAlias();
        }
        if (StringUtil.isNotBlank((CharSequence)bgDepartmentName)) {
            String markedWords = "\u8be5\u5ba2\u6237\u662f" + bgDepartmentName + "\u4e0b\u7684\u90e8\u7fa4\u5ba2\u6237";
            exceptionCustomerVo.setMarkedWords(markedWords);
        }
        if ((user = BaseSecurityUtil.getUser()).getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getMarketingManager()))) {
            exceptionCustomerVo.setAuthority(CommonConstant.companyLeader);
        } else if (this.editCustomerOperate(customer, user, "customer_edit").booleanValue()) {
            exceptionCustomerVo.setAuthority(1);
        } else {
            exceptionCustomerVo.setAuthority(-1);
        }
        return exceptionCustomerVo;
    }

    @Override
    public Boolean editCustomerOperate(CustomerEntity customerEntity, SecurityUser user, String resourcePath) {
        OperateVo operateVo = this.isOperate(customerEntity.getCustomerId());
        if (!operateVo.getViewOperate().booleanValue()) {
            return false;
        }
        if (operateVo.getEditOperate() == 1) {
            return true;
        }
        if (operateVo.getEditOperate() == -1) {
            return false;
        }
        List elementResourceVos = this.hussarBaseResourceAdapter.elementResources("/crm/kh/kehuguanli1", user.getRolesList());
        if (CollectionUtil.isNotEmpty((Collection)elementResourceVos) && ((ElementResourceVo)elementResourceVos.get(0)).getPermission() != null) {
            Set resourceSet = Arrays.stream(((ElementResourceVo)elementResourceVos.get(0)).getPermission().split(",")).collect(Collectors.toSet());
            return resourceSet.contains(resourcePath);
        }
        return false;
    }

    private CustomerSelectPermissionDto customerOperate(CustomerDto dto) {
        String customerView;
        CustomerSelectPermissionDto customerSelectPermissionDto = new CustomerSelectPermissionDto();
        PermissionDto campaignPermissionDto = new PermissionDto();
        PermissionDto customerPermissionDto = new PermissionDto();
        if (dto != null && StringUtil.isNotEmpty((Object)(customerView = dto.getCustomerView())) && !"2".equals(customerView) && !"4".equals(customerView) && !"0".equals(customerView)) {
            customerPermissionDto = this.customerDataRightModuleService.getCurrentUserRolePermissions();
            campaignPermissionDto = this.marketingActivityDataRightModuleService.getCurrentUserRolePermissions();
        }
        customerSelectPermissionDto.setCustomerPermissionDto(customerPermissionDto);
        customerSelectPermissionDto.setCampaignPermissionDto(campaignPermissionDto);
        return customerSelectPermissionDto;
    }

    private List<CustomerDto> getCustomerDtoList(CustomerDto dto) {
        ArrayList<CustomerDto> queryDtoList = new ArrayList<CustomerDto>();
        String view = dto.getCustomerView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long customerView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)customerView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"customer");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)((Object)crmSceneList.get(0))).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        CustomerDto queryDto = (CustomerDto)JSONObject.parseObject((String)queryValue, CustomerDto.class);
                        queryDto.setCustomerView(String.valueOf(customerView));
                        List<Object> opportunityStages = new ArrayList();
                        if (ToolUtil.isNotEmpty(queryDto.getStageProcessIds())) {
                            if (ToolUtil.isNotEmpty(queryDto.getCustomerStageIds())) {
                                opportunityStages = this.opportunityStageMapper.selectNameMergeListByStageId(queryDto.getStageProcessIds(), queryDto.getCustomerStageIds());
                            }
                        } else if (ToolUtil.isNotEmpty(queryDto.getCustomerStageIds())) {
                            opportunityStages = this.opportunityStageMapper.selectNameMergeListByStageId(null, queryDto.getCustomerStageIds());
                        }
                        if (ToolUtil.isNotEmpty(opportunityStages)) {
                            List<String> opportunityStagesStr = opportunityStages.stream().map(String::valueOf).collect(Collectors.toList());
                            queryDto.setCustomerStageIds(opportunityStagesStr);
                        }
                        queryDtoList.add(this.customerQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.customerQueryCondition(dto));
        return queryDtoList;
    }

    private CustomerDto customerQueryCondition(CustomerDto dto) {
        DateStartEndVo dateStartEndVo;
        DateConvertVo dateConvertVo;
        if (StringUtil.isEmpty((Object)dto.getCustomerView())) {
            dto.setCustomerView("1");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)dto.getCustomerScreening())) {
            dto.setCustomerScreening(dto.getCustomerScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        String customerView = dto.getCustomerView();
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (String string : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId(string));
            }
            dto.setTransChargePersonIds(userIds);
        }
        ArrayList<String> teamMemberIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getTeamMemberIds()) && dto.getTeamMemberIds().size() > 0) {
            for (String teamMemberId : dto.getTeamMemberIds()) {
                teamMemberIds.add(CommonUtills.translateUserId(teamMemberId));
            }
            dto.setTransTeamMemberIds(teamMemberIds);
        }
        List<String> list = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(list) && list.size() > 0) {
            for (String odpId : list) {
                ArrayList<String> ids;
                String odpIsTemp = CommonUtills.translateDepId(odpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        if ("2".equals(customerView)) {
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getTrackTimeFlag()) && !"6".equals(dto.getTrackTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getTrackTimeFlag())) != null) {
            dto.setTrackTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setTrackTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getClaimTimeFlag()) && !"6".equals(dto.getClaimTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getClaimTimeFlag())) != null) {
            dto.setClaimTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setClaimTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getAllocateTimeFlag()) && !"6".equals(dto.getAllocateTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getAllocateTimeFlag())) != null) {
            dto.setAllocateTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setAllocateTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getRecycleTimeFlag()) && !"6".equals(dto.getRecycleTimeFlag()) && (dateStartEndVo = CrmDateUtils.inviteSevenFifteenThirtyTime((String)dto.getRecycleTimeFlag())) != null) {
            dto.setRecycleTimeStart(dateStartEndVo.getStartDate());
            dto.setRecycleTimeEnd(dateStartEndVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty(dto.getCustomerStageIds())) {
            ArrayList<String> customerStageIdSplit = new ArrayList<String>();
            for (String stageId : dto.getCustomerStageIds()) {
                if (!ToolUtil.isNotEmpty((Object)stageId)) continue;
                customerStageIdSplit.addAll(Arrays.asList(stageId.split(",")));
            }
            dto.setCustomerStageIds(customerStageIdSplit);
        }
        return dto;
    }

    @Override
    public List<CustomerEntity> dictionaryTranslate(List<CustomerEntity> customerEntityList) {
        List customerTypes = this.sysDicRefService.getDicListByType("customerType");
        List customerOrigins = this.sysDicRefService.getDicListByType("customer_source");
        List trades = this.sysDicRefService.getDicListByType("industry");
        List customerStages = this.sysDicRefService.getDicListByType("customer_stage");
        List corporateScales = this.sysDicRefService.getDicListByType("corporate_scale");
        List corporateImpacts = this.sysDicRefService.getDicListByType("corporate_impact");
        List listingStatuses = this.sysDicRefService.getDicListByType("listing_status");
        List customerRelations = this.sysDicRefService.getDicListByType("customer_relation");
        List customerRisks = this.sysDicRefService.getDicListByType("customer_risk");
        List customerRiskPoints = this.sysDicRefService.getDicListByType("customer_risk_point");
        List customerLevels = this.sysDicRefService.getDicListByType("customer_level");
        for (CustomerEntity customer : customerEntityList) {
            LinkedList<String> translateTypes;
            List<String> typeList;
            Object typeArray;
            DicVo dicVo5;
            TrackRecordAPIVo trackRecord;
            Object dicVo22;
            if (ToolUtil.isNotEmpty((Object)customer.getCustomerType())) {
                String[] typeArray2 = customer.getCustomerType().split(",");
                List<String> typeList2 = Arrays.asList(typeArray2);
                LinkedList<String> translateTypes2 = new LinkedList<String>();
                for (Object dicVo3 : customerTypes) {
                    if (!typeList2.contains(dicVo3.getValue())) continue;
                    translateTypes2.add(dicVo3.getLabel());
                }
                String customerType = StringUtil.join(translateTypes2, (String)",");
                customer.setCustomerType(customerType);
            }
            if (ToolUtil.isNotEmpty((Object)customer.getOpptyAmount())) {
                if ("0".equals(customer.getOpptyAmount())) {
                    customer.setOpptyAmount("\u5426");
                } else {
                    customer.setOpptyAmount("\u662f");
                }
            }
            if (ToolUtil.isNotEmpty((Object)customer.getCustomerOrigin())) {
                for (Object dicVo22 : customerOrigins) {
                    if (!customer.getCustomerOrigin().equals(dicVo22.getValue())) continue;
                    customer.setCustomerOrigin(dicVo22.getLabel());
                }
            }
            if (ToolUtil.isNotEmpty((Object)customer.getCreateTime())) {
                customer.setCreateDate(customer.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
            }
            if (ToolUtil.isNotEmpty((Object)customer.getTrade())) {
                for (Object dicVo22 : trades) {
                    if (!customer.getTrade().equals(dicVo22.getValue())) continue;
                    customer.setTrade(dicVo22.getLabel());
                }
            }
            if (ToolUtil.isNotEmpty((Object)(trackRecord = this.trackRecordAPIService.selectTrackRecordContentByTypeId(customer.getCustomerId())))) {
                customer.setLastTrackTime(trackRecord.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
                customer.setLastTrackRecord(trackRecord.getRecordContent());
            }
            if (ToolUtil.isNotEmpty((Object)customer.getCustomerStage())) {
                dicVo22 = customerStages.iterator();
                while (dicVo22.hasNext()) {
                    dicVo5 = (DicVo)dicVo22.next();
                    if (!customer.getCustomerStage().equals(dicVo5.getValue())) continue;
                    customer.setCustomerStage(dicVo5.getLabel());
                }
            }
            if (ToolUtil.isNotEmpty((Object)customer.getCorporateScale())) {
                dicVo22 = corporateScales.iterator();
                while (dicVo22.hasNext()) {
                    dicVo5 = (DicVo)dicVo22.next();
                    if (!customer.getCorporateScale().equals(dicVo5.getValue())) continue;
                    customer.setCorporateScale(dicVo5.getLabel());
                }
            }
            if (ToolUtil.isNotEmpty((Object)customer.getCorporateImpact())) {
                Object dicVo3;
                typeArray = customer.getCorporateImpact().split(",");
                typeList = Arrays.asList(typeArray);
                translateTypes = new LinkedList<String>();
                dicVo3 = corporateImpacts.iterator();
                while (dicVo3.hasNext()) {
                    DicVo dicVo4 = (DicVo)dicVo3.next();
                    if (!typeList.contains(dicVo4.getValue())) continue;
                    translateTypes.add(dicVo4.getLabel());
                }
                String corporateImpact = StringUtil.join(translateTypes, (String)",");
                customer.setCorporateImpact(corporateImpact);
            }
            if (ToolUtil.isNotEmpty((Object)customer.getListingStatus())) {
                for (DicVo dicVo5 : listingStatuses) {
                    if (!customer.getListingStatus().equals(dicVo5.getValue())) continue;
                    customer.setListingStatus(dicVo5.getLabel());
                }
            }
            if (ToolUtil.isNotEmpty((Object)customer.getCustomerRelation())) {
                for (DicVo dicVo5 : customerRelations) {
                    if (!customer.getCustomerRelation().equals(dicVo5.getValue())) continue;
                    customer.setCustomerRelation(dicVo5.getLabel());
                }
            }
            if (ToolUtil.isNotEmpty((Object)customer.getCustomerRisk())) {
                for (DicVo dicVo5 : customerRisks) {
                    if (!customer.getCustomerRisk().equals(dicVo5.getValue())) continue;
                    customer.setCustomerRisk(dicVo5.getLabel());
                }
            }
            if (ToolUtil.isNotEmpty((Object)customer.getCustomerRiskPoint())) {
                typeArray = customer.getCustomerRiskPoint().split(",");
                typeList = Arrays.asList(typeArray);
                translateTypes = new LinkedList();
                for (DicVo dicVo4 : customerRiskPoints) {
                    if (!typeList.contains(dicVo4.getValue())) continue;
                    translateTypes.add(dicVo4.getLabel());
                }
                String customerRiskPoint = StringUtil.join(translateTypes, (String)",");
                customer.setCustomerRiskPoint(customerRiskPoint);
            }
            if (!ToolUtil.isNotEmpty((Object)customer.getCustLevel())) continue;
            for (DicVo dicVo5 : customerLevels) {
                if (!customer.getCustLevel().equals(dicVo5.getValue())) continue;
                customer.setCustLevel(dicVo5.getLabel());
            }
        }
        return customerEntityList;
    }

    @Override
    public ApiResponse<Page<CustomerEntity>> selectCustomerListByAgentId(CustomerDto dto) {
        Object page = dto.getPage();
        page = this.customerMapper.selectCustomerListByAgentId((Page<CustomerEntity>)page, dto, new PermissionDto(), new PermissionDto());
        return ApiResponse.success(page);
    }

    @Override
    public ApiResponse<Page<CustomerEntity>> selectCustomerListByAgentIdAndPermission(CustomerDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        CustomerSelectPermissionDto customerSelectPermissionDto = this.customerOperate(dto);
        PermissionDto campaignPermissionDto = customerSelectPermissionDto.getCampaignPermissionDto();
        PermissionDto customerPermissionDto = customerSelectPermissionDto.getCustomerPermissionDto();
        Object page = dto.getPage();
        page = this.customerMapper.selectCustomerListByAgentId((Page<CustomerEntity>)page, dto, customerPermissionDto, campaignPermissionDto);
        return ApiResponse.success(page);
    }

    @Override
    public int getNumByTelphone(String telphone) {
        return this.customerMapper.selectByTelephone(telphone);
    }

    @Override
    public List<String> getAllOpenid(String openId) {
        return this.commonMapper.selectAllOpenid(openId);
    }

    @Override
    public Page<YyzcCustomerVo> selectCustomerListYyzc(YyzcCustomerDto dto) {
        User user;
        if (ToolUtil.isNotEmpty((Object)dto.getUserId())) {
            user = this.vehicleApplicationMapper.selectUserByChar1(dto.getUserId());
            if (ToolUtil.isEmpty((Object)user)) {
                throw new BaseException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
            }
        } else {
            throw new BaseException("\u65e0\u6743\u9650");
        }
        SecurityUser user2 = this.userBoService.selectSecurityByUserId(user.getUserId());
        PermissionDto customerPermissionDto = this.customerDataRightModuleService.getUserRolePermission(user2);
        PermissionDto campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user2);
        PermissionDto agentPermissionDto = this.agentDataRightModuleService.getUserRolePermission(user2);
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        page.setMaxLimit(Long.valueOf(-1L));
        List<YyzcCustomerVo> list = this.customerMapper.selectCustomerListYyzc(dto, (Page<YyzcCustomerVo>)page, customerPermissionDto, campaignPermissionDto, agentPermissionDto);
        page.setRecords(list);
        return page;
    }

    @Override
    @Nullable
    public StringBuilder getFullAddress(Long provinceId, Long cityId, Long countyId, Map<Long, String> regionIdNameMap, String address) {
        String province = null;
        String city = null;
        String county = null;
        if (HussarUtils.isNotEmpty((Object)provinceId)) {
            province = regionIdNameMap.get(provinceId);
        }
        if (HussarUtils.isNotEmpty((Object)cityId)) {
            city = regionIdNameMap.get(cityId);
        }
        if (HussarUtils.isNotEmpty((Object)countyId)) {
            county = regionIdNameMap.get(countyId);
        }
        if (province == null && city == null && county == null) {
            return null;
        }
        StringBuilder addressHead = new StringBuilder();
        if (province == null || !address.contains(province)) {
            if (province != null) {
                addressHead.append(province);
            }
            if (city == null || !address.contains(city)) {
                if (city != null) {
                    addressHead.append(city);
                }
                if (!(county != null && address.contains(county) || county == null)) {
                    addressHead.append(county);
                }
            }
        }
        return addressHead;
    }

    @Override
    public ApiResponse<String> customerChangeDeptBatch(DeptChangeBatchDto dto) {
        if (HussarUtils.isNotEmpty((Object)dto.getOwnDepartment()) && CollectionUtil.isNotEmpty(dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List customerEntityList = this.list((Wrapper)new LambdaQueryWrapper().in(CustomerEntity::getCustomerId, dto.getObjectIdList()));
            ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
            ArrayList changeField = new ArrayList();
            String newOwnDeptName = dto.getOwnDepartmentName();
            Long newOwnDeptId = dto.getOwnDepartment();
            boolean changeFlag = false;
            for (CustomerEntity customerEntity : customerEntityList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                if (dto.getOwnDepartmentName().equals(customerEntity.getOwnDepartmentName())) continue;
                String oldOwnDeptName = customerEntity.getOwnDepartmentName();
                Long oldOwnDeptId = customerEntity.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", CustomerEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", CustomerEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(CustomerEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(CustomerEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(CustomerEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(CustomerEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = customerEntity.getCustomerName();
                typeEnum = CrmBusinessTypeEnum.CUSTOMER;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                operateRecordDO.setChangeBefore(oldJson);
                operateRecordDO.setChangeAfter(newJson);
                operateRecordDO.setChangeField(changeFieldStr);
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(customerEntity.getCustomerId());
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                trackRecordList.add(operateRecordDO);
            }
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(CustomerEntity::getCustomerId, dto.getObjectIdList())).set(CustomerEntity::getOwnDepartment, (Object)dto.getOwnDepartment())).set(CustomerEntity::getOwnDepartmentName, (Object)dto.getOwnDepartmentName())).set(CustomerEntity::getChangeTime, (Object)date)).set(CustomerEntity::getChangePerson, (Object)user.getUserId())).set(CustomerEntity::getChangePersonName, (Object)user.getUserName()));
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }

    @Override
    public ApiResponse<Page<CustomerEntity>> selectAllCustomerList(CustomerDto dto) {
        dto.setCustomerView("0");
        CustomerSelectPermissionDto customerSelectPermissionDto = this.customerOperate(dto);
        PermissionDto campaignPermissionDto = customerSelectPermissionDto.getCampaignPermissionDto();
        PermissionDto customerPermissionDto = customerSelectPermissionDto.getCustomerPermissionDto();
        List<CustomerDto> customerDtoList = this.getCustomerDtoList(dto);
        Page page = dto.getPage();
        List<CustomerEntity> list = this.customerMapper.selectCustomerListCountOpportunity(customerDtoList, page, dto.getTimeOrder(), dto.getCurrentUserId(), customerPermissionDto, campaignPermissionDto);
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
            list.forEach(customer -> {
                customer.setLabelName(CrmLabelUtil.getLabelName(labelList, customer.getLabelId()));
                customer.setAiTagName(CrmLabelUtil.getLabelName(labelList, customer.getAiTags()));
            });
        }
        page.setRecords(list);
        return ApiResponse.success(page);
    }

    @Override
    public List<CustomerAPIVo> selectCustomerByNameAndTel(String customerName, String telephoneNumber) {
        List customerEntityList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerName, (Object)customerName)).eq(CustomerEntity::getDelFlag, (Object)"0"));
        if (ToolUtil.isNotEmpty((Object)customerEntityList)) {
            ArrayList<CustomerAPIVo> customerAPIVoList = new ArrayList<CustomerAPIVo>();
            for (CustomerEntity customer : customerEntityList) {
                List contactEntities = this.contactService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getCustomerId, (Object)customer.getCustomerId())).isNotNull(ContactEntity::getMobilePhone)).ne(ContactEntity::getMobilePhone, (Object)"")).eq(ContactEntity::getMobilePhone, (Object)telephoneNumber)).eq(ContactEntity::getDelFlag, (Object)"0"));
                if (!ToolUtil.isNotEmpty((Object)contactEntities)) continue;
                CustomerAPIVo customerAPIVo = (CustomerAPIVo)BeanUtil.copy((Object)customer, CustomerAPIVo.class);
                assert (customerAPIVo != null);
                customerAPIVo.setContactAPIVoList(BeanUtil.copy((Collection)contactEntities, ContactAPIVo.class));
                customerAPIVoList.add(customerAPIVo);
            }
            return customerAPIVoList;
        }
        return null;
    }

    @Override
    public ApiResponse<String> customerChangeDeptByChargePersonBatch(DeptChangeBatchDto dto) {
        if (CollectionUtil.isNotEmpty(dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List customerEntityList = this.list((Wrapper)new LambdaQueryWrapper().in(CustomerEntity::getCustomerId, dto.getObjectIdList()));
            for (CustomerEntity customerEntity : customerEntityList) {
                if (!ToolUtil.isEmpty((Object)customerEntity.getChargePersonId())) continue;
                throw new HussarException("\u5ba2\u6237\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff01");
            }
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            List<Map<String, Object>> userInfoList = this.commonMapper.getDeptInfosByUserIdList(customerEntityList.stream().map(CustomerEntity::getChargePersonId).collect(Collectors.toList()));
            boolean changeFlag = false;
            for (CustomerEntity customerEntity : customerEntityList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                ArrayList changeField = new ArrayList();
                Map userMap = (Map)userInfoList.stream().filter(map -> map.get("USER_ID").equals(customerEntity.getChargePersonId())).collect(Collectors.toList()).get(0);
                Long newOwnDeptId = (Long)userMap.get("DEPARTMENT_ID");
                String newOwnDeptName = (String)userMap.get("ORGAN_ALIAS");
                if (newOwnDeptName.equals(customerEntity.getOwnDepartmentName())) continue;
                String oldOwnDeptName = customerEntity.getOwnDepartmentName();
                Long oldOwnDeptId = customerEntity.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = customerEntity.getCustomerName();
                typeEnum = CrmBusinessTypeEnum.CUSTOMER;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                operateRecordDO.setChangeBefore(oldJson);
                operateRecordDO.setChangeAfter(newJson);
                operateRecordDO.setChangeField(changeFieldStr);
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(customerEntity.getCustomerId());
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                operateRecordDOList.add(operateRecordDO);
                customerEntity.setOwnDepartment(newOwnDeptId);
                customerEntity.setOwnDepartmentName(newOwnDeptName);
                customerEntity.setChangeTime(date);
                customerEntity.setChangePerson(user.getUserId());
                customerEntity.setChangePersonName(user.getUserName());
            }
            this.updateBatchById(customerEntityList);
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }

    @Override
    public List<Long> selectCustomerByOpportunity(OpportunityQueryDto dto) {
        return this.customerMapper.selectCustomerByOpportunity(dto);
    }

    @Override
    public void updateAiTags(List<Map<String, Object>> aiTagMapList) {
        this.customerMapper.updateAiTags(aiTagMapList);
    }

    @Override
    @Transactional
    public ApiResponse<String> updateCustomerFinancialInfo(CustomerDto dto) {
        FinancialInfoEntity oldFinancialInfo = (FinancialInfoEntity)this.financialInfoService.getOne((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(FinancialInfoEntity::getBusinessId, (Object)dto.getCustomerId())).eq(FinancialInfoEntity::getBusinessType, (Object)"1"));
        CrmCustomer1 oldCustomer = (CrmCustomer1)this.crmCustomer1Service.getById(dto.getCustomerId());
        FinancialInfoEntity newFinancialInfo = new FinancialInfoEntity();
        if (oldFinancialInfo == null) {
            oldFinancialInfo = new FinancialInfoEntity();
            newFinancialInfo.setFinancialInfoId(Long.parseLong(CommonUtills.generateAssignId()));
        } else {
            newFinancialInfo.setFinancialInfoId(oldFinancialInfo.getFinancialInfoId());
        }
        newFinancialInfo.setBusinessType("1");
        newFinancialInfo.setBusinessId(dto.getCustomerId());
        newFinancialInfo.setTin(dto.getTin());
        newFinancialInfo.setBankName(dto.getBankName());
        newFinancialInfo.setBankAccount(dto.getBankAccount());
        newFinancialInfo.setBillingAddress(dto.getBillingAddress());
        LocalDateTime date = LocalDateTime.now();
        boolean customerChangeFlag = false;
        boolean financialInfoChangeFlag = false;
        ArrayList changeField = new ArrayList();
        HashMap<String, String> before = new HashMap<String, String>();
        HashMap<String, String> after = new HashMap<String, String>();
        String oldTelephone = oldCustomer.getTelephone();
        String newTelephone = dto.getTelephone();
        if (!(ToolUtil.isEmpty((Object)oldTelephone) && ToolUtil.isEmpty((Object)newTelephone) || !ToolUtil.isEmpty((Object)oldTelephone) && oldTelephone.equals(newTelephone))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", CustomerEditConstant.TELEPHONE.getField());
            field.put("fieldName", CustomerEditConstant.TELEPHONE.getName());
            changeField.add(field);
            before.put(CustomerEditConstant.TELEPHONE.getField(), oldTelephone);
            after.put(CustomerEditConstant.TELEPHONE.getField(), newTelephone);
            customerChangeFlag = true;
        }
        String oldBillingAddress = oldFinancialInfo.getBillingAddress();
        String newBillingAddress = newFinancialInfo.getBillingAddress();
        if (!(ToolUtil.isEmpty((Object)oldBillingAddress) && ToolUtil.isEmpty((Object)newBillingAddress) || !ToolUtil.isEmpty((Object)oldBillingAddress) && oldBillingAddress.equals(newBillingAddress))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", CustomerEditConstant.CUSTOMER_BILLING_ADDRESS.getField());
            field.put("fieldName", CustomerEditConstant.CUSTOMER_BILLING_ADDRESS.getName());
            changeField.add(field);
            before.put(CustomerEditConstant.CUSTOMER_BILLING_ADDRESS.getField(), oldBillingAddress);
            after.put(CustomerEditConstant.CUSTOMER_BILLING_ADDRESS.getField(), newBillingAddress);
            financialInfoChangeFlag = true;
        }
        String oldTIN = oldFinancialInfo.getTin();
        String newTIN = newFinancialInfo.getTin();
        if (!(ToolUtil.isEmpty((Object)oldTIN) && ToolUtil.isEmpty((Object)newTIN) || !ToolUtil.isEmpty((Object)oldTIN) && oldTIN.equals(newTIN))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", CustomerEditConstant.CUSTOMER_TIN.getField());
            field.put("fieldName", CustomerEditConstant.CUSTOMER_TIN.getName());
            changeField.add(field);
            before.put(CustomerEditConstant.CUSTOMER_TIN.getField(), oldTIN);
            after.put(CustomerEditConstant.CUSTOMER_TIN.getField(), newTIN);
            financialInfoChangeFlag = true;
        }
        String oldBank = oldFinancialInfo.getBankName();
        String newBank = newFinancialInfo.getBankName();
        if (!(ToolUtil.isEmpty((Object)oldBank) && ToolUtil.isEmpty((Object)newBank) || !ToolUtil.isEmpty((Object)oldBank) && oldBank.equals(newBank))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", CustomerEditConstant.CUSTOMER_BANK.getField());
            field.put("fieldName", CustomerEditConstant.CUSTOMER_BANK.getName());
            changeField.add(field);
            before.put(CustomerEditConstant.CUSTOMER_BANK.getField(), oldBank);
            after.put(CustomerEditConstant.CUSTOMER_BANK.getField(), newBank);
            financialInfoChangeFlag = true;
        }
        String oldBankAccount = oldFinancialInfo.getBankAccount();
        String newBankAccount = newFinancialInfo.getBankAccount();
        if (!(ToolUtil.isEmpty((Object)oldBankAccount) && ToolUtil.isEmpty((Object)newBankAccount) || !ToolUtil.isEmpty((Object)oldBankAccount) && oldBankAccount.equals(newBankAccount))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", CustomerEditConstant.CUSTOMER_BANK_ACCOUNT.getField());
            field.put("fieldName", CustomerEditConstant.CUSTOMER_BANK_ACCOUNT.getName());
            changeField.add(field);
            before.put(CustomerEditConstant.CUSTOMER_BANK_ACCOUNT.getField(), oldBankAccount);
            after.put(CustomerEditConstant.CUSTOMER_BANK_ACCOUNT.getField(), newBankAccount);
            financialInfoChangeFlag = true;
        }
        if (customerChangeFlag || financialInfoChangeFlag) {
            if (customerChangeFlag) {
                oldCustomer.setTelephone(dto.getTelephone());
                this.crmCustomer1Service.updateById(oldCustomer);
            }
            if (financialInfoChangeFlag) {
                this.financialInfoService.saveOrUpdate(newFinancialInfo);
            }
            String oldJson = JSON.toJSONString(before);
            String newJson = JSON.toJSONString(after);
            String changeFieldStr = JSON.toJSONString(changeField);
            OperateRecordAPIVo operateRecordDO = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldJson, newJson, changeFieldStr);
            operateRecordDO.setChangeBatch(1);
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.CUSTOMER, dto.getCustomerId(), oldCustomer.getCustomerName(), date, false, Collections.singletonList(dto.getCustomerId()));
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @Transactional
    public ApiResponse<String> release(ReleaseCustomerDto dto) {
        CustomerPoolEntity customerPool = (CustomerPoolEntity)this.customerPoolService.getById(dto.getCustomerPoolId());
        if (customerPool == null || "1".equals(customerPool.getDelFlag())) {
            throw new HussarException("\u6240\u9009\u516c\u6d77\u6c60\u4e0d\u5b58\u5728");
        }
        List list = (List)this.customerPoolService.selectableReleaseList().getData();
        if (CollectionUtil.isEmpty((Collection)list) || !list.stream().map(CustomerPoolVo::getCustomerPoolId).collect(Collectors.toList()).contains(dto.getCustomerPoolId())) {
            throw new HussarException("\u65e0\u6240\u9009\u516c\u6d77\u6c60\u6743\u9650");
        }
        List<Long> customerIds = dto.getCustomerIdList();
        List customerEntityList = this.listByIds(customerIds);
        ArrayList<PoolCustomerEntity> poolCustomerEntityList = new ArrayList<PoolCustomerEntity>();
        LocalDateTime dateTime = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String joinReason = dto.getReason();
        Long customerPoolId = dto.getCustomerPoolId();
        String userName = user.getUserName();
        Long userId = user.getUserId();
        this.teamMeberService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TeamMeberEntity::getBusinessType, (Object)"1")).in(TeamMeberEntity::getBusinessId, customerIds)).set(TeamMeberEntity::getDelFlag, (Object)"1"));
        this.taskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskEntity::getBusinessType, (Object)"1")).in(TaskEntity::getBusinessId, customerIds)).ne(TaskEntity::getState, (Object)"2")).set(TaskEntity::getState, (Object)"3")).set(TaskEntity::getLastTime, (Object)dateTime));
        for (CustomerEntity customerEntity2 : customerEntityList) {
            PoolCustomerEntity poolCustomerEntity = (PoolCustomerEntity)BeanUtil.copy((Object)customerEntity2, PoolCustomerEntity.class);
            poolCustomerEntity.setCustomerPoolId(customerPoolId);
            poolCustomerEntity.setOldChargePerson(customerEntity2.getChargePersonId());
            poolCustomerEntity.setOldChargePersonName(customerEntity2.getChargePersonName());
            poolCustomerEntity.setLastJoinTime(dateTime);
            poolCustomerEntity.setLastJoinType("2");
            poolCustomerEntity.setLastJoinUser(userId);
            poolCustomerEntity.setLastJoinUserName(userName);
            poolCustomerEntity.setLastJoinReason(joinReason);
            poolCustomerEntity.setOldOwnDepartment(customerEntity2.getOwnDepartment());
            poolCustomerEntity.setOldOwnDepartmentName(customerEntity2.getOwnDepartmentName());
            poolCustomerEntity.setChangeTime(dateTime);
            poolCustomerEntity.setChangePerson(userId);
            poolCustomerEntity.setChangePersonName(userName);
            poolCustomerEntity.setOwnDepartment(null);
            poolCustomerEntity.setOwnDepartmentName(null);
            poolCustomerEntity.setChargePersonId(null);
            poolCustomerEntity.setChargePersonName(null);
            poolCustomerEntity.setClaimApproval("0");
            poolCustomerEntity.setLastClaimTime(customerEntity2.getClaimTime());
            poolCustomerEntityList.add(poolCustomerEntity);
        }
        this.poolCustomerService.saveBatch(poolCustomerEntityList);
        this.removeByIds(dto.getCustomerIdList());
        List recordList = customerEntityList.stream().map(customerEntity -> {
            HashMap<String, String> field = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
            HashMap<String, Object> before = new HashMap<String, Object>();
            HashMap<String, Object> after = new HashMap<String, Object>();
            before.put(CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), customerEntity.getChargePersonId());
            after.put(CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), customerPoolId);
            before.put(CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), customerEntity.getChargePersonName());
            after.put(CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), customerPool.getCustomerPoolName());
            field.put("field", CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField());
            field.put("fieldName", CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getName());
            changeField.add(field);
            return this.getTrackRecord(customerEntity.getCustomerId(), customerEntity.getCustomerName(), CrmBusinessTypeEnum.CUSTOMER.getId(), dateTime, userId, userName, JSON.toJSONString(before), JSON.toJSONString(after), JSON.toJSONString(changeField), RecordProductTypeEnum.PRODUCE_POOL_MANUAL_RELEASE.getId(), joinReason);
        }).collect(Collectors.toList());
        this.operateRecordAPIService.saveOperateLogBatch(recordList);
        poolCustomerEntityList.removeIf(customerEntity -> Objects.equals(userId, customerEntity.getOldChargePerson()));
        for (PoolCustomerEntity customerEntity3 : poolCustomerEntityList) {
            String title = user.getUserName() + "\u91ca\u653e\u5ba2\u6237\u81f3\u516c\u6d77\u6c60\u4e2d";
            String content = "\u5ba2\u6237\u540d\u79f0\u3010" + customerEntity3.getCustomerName() + "\u3011\uff0c\u516c\u6d77\u6c60\u540d\u79f0\u3010" + customerPool.getCustomerPoolName() + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/kh/khxq", customerEntity3.getCustomerId().toString(), Collections.singletonList(String.valueOf(customerEntity3.getOldChargePerson())));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + customerEntity3.getCustomerId() + "\"";
            String contentUnify = "\u3010\u91ca\u653e\u63d0\u9192\u3011" + user.getUserName() + "\u5c06\u60a8\u8d1f\u8d23\u7684\u5ba2\u6237\u3010" + customerEntity3.getCustomerName() + "\u3011\u91ca\u653e\u5230\u3010" + customerPool.getCustomerPoolName() + "\u3011\u516c\u6d77\u6c60\u4e2d\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, dateTime, user, String.valueOf(customerEntity3.getOldChargePerson()), user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
        return ApiResponse.success((String)"\u91ca\u653e\u6210\u529f");
    }

    @Override
    @NotNull
    public OperateRecordAPIVo getTrackRecord(Long typeId, String businessName, String businessType, LocalDateTime date, Long userId, String userName, String before, String after, String changeField, String produceId, String content) {
        OperateRecordAPIVo record = new OperateRecordAPIVo();
        record.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        record.setProduceType(produceId);
        record.setBusinessType(businessType);
        record.setTypeId(typeId);
        record.setBusinessName(businessName);
        record.setChangeBefore(before);
        record.setChangeAfter(after);
        record.setChangeField(changeField);
        record.setCreateTime(date);
        record.setChangeTime(date);
        record.setCreatePerson(userId);
        record.setChangePerson(userId);
        record.setCreatePersonName(userName);
        record.setChangePersonName(userName);
        record.setChangePerson(userId);
        record.setChangePersonName(userName);
        record.setRecordContent(content);
        record.setChangeBatch(1);
        record.setDelflag("0");
        return record;
    }
}

