/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.core.common.dto.DeptChangeBatchDto;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.customer.dto.CheckDuplicateCustomerDto;
import com.jxdinfo.crm.core.customer.dto.CustomerAssociativeQueryDto;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.dto.ReleaseCustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.model.CustomerIncludePool;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.vo.CheckRepeat;
import com.jxdinfo.crm.core.customer.vo.CustomerEntityVo;
import com.jxdinfo.crm.core.customer.vo.CustomerRepeatStatistics;
import com.jxdinfo.crm.core.customer.vo.ExceptionCustomerVo;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.vehicleapplication.model.VehicleApplication;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5ba2\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"Customer"})
public class CustomerController {
    @Resource
    private CustomerService customerService;

    @PostMapping(value={"/selectCustomerList"})
    @ApiOperation(value="\u67e5\u770b\u5ba2\u6237\u5217\u8868", notes="\u67e5\u770b\u5ba2\u6237\u5217\u8868")
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomerEntity>> selectCustomerList(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto dto) {
        Page<CustomerEntity> page = this.customerService.selectCustomerList(dto);
        return ApiResponse.success(page);
    }

    @PostMapping(value={"/associativeQuery"})
    @ApiOperation(value="\u5ba2\u6237\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", notes="\u5ba2\u6237\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AssociativeQueryVo>> associativeQuery(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerAssociativeQueryDto dto) {
        return ApiResponse.success(this.customerService.associativeQuery(dto));
    }

    @PostMapping(value={"/selectPartnerCustomerList"})
    @ApiOperation(value="\u67e5\u8be2\u4f19\u4f34\u5ba2\u6237\u5217\u8868", notes="\u67e5\u8be2\u4f19\u4f34\u5ba2\u6237\u5217\u8868")
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomerEntity>> selectPartnerCustomerList(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto dto) {
        Page<CustomerEntity> page = this.customerService.selectPartnerCustomerList(dto);
        return ApiResponse.success(page);
    }

    @PostMapping(value={"/saveCrmCustomer"})
    @ApiOperation(value="\u4fdd\u5b58\u5ba2\u6237", notes="\u4fdd\u5b58\u5ba2\u6237")
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> saveCrmCustomer(@RequestBody @ApiParam(value="\u5ba2\u6237\u5b9e\u4f53") CustomerDto customerDto) {
        return ApiResponse.success((Object)this.customerService.saveCrmCustomer(customerDto));
    }

    @PostMapping(value={"/selectCustomerRepeat"})
    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u540d\u79f0\u67e5\u91cd", notes="\u6839\u636e\u5ba2\u6237\u540d\u79f0\u67e5\u91cd")
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CheckRepeat> selectCustomerRepeate(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CheckDuplicateCustomerDto dto) {
        return this.customerService.selectCustomerRepeate(dto);
    }

    @PostMapping(value={"/selectCustomerRechecking"})
    @ApiOperation(value="\u7ebf\u7d22\u8f6c\u6362\u65f6\u5ba2\u6237\u67e5\u91cd", notes="\u7ebf\u7d22\u8f6c\u6362\u65f6\u5ba2\u6237\u67e5\u91cd")
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CustomerIncludePool>> selectCustomerRechecking(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto dto) {
        return ApiResponse.success(DataPermission.customerNameCheck(dto.getCustomerName()));
    }

    @PostMapping(value={"/recheckExcept"})
    public ApiResponse selectRepeatNumber(@RequestBody CustomerDto dto) {
        int i = this.customerService.selectRepeatNumber(dto);
        if (i > 0) {
            return ApiResponse.fail((String)"\u5f53\u524d\u5ba2\u6237\u5df2\u5b58\u5728");
        }
        return ApiResponse.success((String)"");
    }

    @ApiOperation(value="\u5ba2\u6237\u6279\u91cf\u5220\u9664\uff08\u903b\u8f91\u5220\u9664\uff09", notes="\u5ba2\u6237\u6279\u91cf\u5220\u9664\uff08\u903b\u8f91\u5220\u9664\uff09")
    @PostMapping(value={"/deleteCrmCustomerByCustomerIds"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> deleteCrmCustomerByCustomerIds(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto dto) {
        return ApiResponse.success((Object)this.customerService.deleteCrmCustomerByCustomerIds(dto.getCustomerIds()));
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u5ba2\u6237", notes="\u5ba2\u6237\u5bfc\u51fa")
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public String customerExport(HttpServletResponse response, @RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto dto) {
        return this.customerService.customerExport(response, dto);
    }

    @RequestMapping(value={"/exportTemplate"})
    public String customerExportTemplate(HttpServletResponse response) {
        String msg = this.customerService.customerExportTemplate(response);
        return msg;
    }

    @PostMapping(value={"/import"})
    public ApiResponse<Page> customerImport(@RequestBody MultipartFile file) {
        String msg = this.customerService.customerImport(file);
        return ApiResponse.success((String)msg);
    }

    @ApiOperation(value="\u5ba2\u6237\u8f6c\u79fb", notes="\u5ba2\u6237\u8f6c\u79fb")
    @PostMapping(value={"/customerTransfer"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<TransferBatchResultVo> customerTransfer(@RequestBody @ApiParam(value="\u5ba2\u6237dto\u96c6\u5408") List<CustomerDto> dto) {
        return ApiResponse.success((Object)this.customerService.customerTransfer(dto));
    }

    @ApiOperation(value="\u83b7\u53d6\u5ba2\u6237\u8be6\u60c5", notes="\u83b7\u53d6\u5ba2\u6237\u8be6\u60c5(\u5305\u542b\u516c\u6d77\u6c60\u5ba2\u6237)")
    @GetMapping(value={"/customerDetails"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CustomerEntityVo> selectCustomerDetails(@RequestParam(value="customerId") @ApiParam(value="\u5ba2\u6237id") Long customerId) {
        return ApiResponse.success((Object)this.customerService.customerDetails(customerId));
    }

    @ApiOperation(value="\u5ba2\u6237\u5408\u5e76", notes="\u5ba2\u6237\u5408\u5e76")
    @PostMapping(value={"/customerMerge"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> customerMerge(@RequestBody @ApiParam(value="\u5ba2\u6237\u5b9e\u4f53") CustomerEntity customerEntity) {
        return ApiResponse.success((String)this.customerService.customerMarge(customerEntity));
    }

    @ApiOperation(value="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650", notes="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650")
    @GetMapping(value={"operate"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<OperateVo> isOperate(@RequestParam(value="customerId") @ApiParam(value="\u5ba2\u6237id") Long customerId) {
        return ApiResponse.success((Object)this.customerService.isOperate(customerId));
    }

    @ApiOperation(value="\u91cd\u590d\u5ba2\u6237\u5206\u6790", notes="\u91cd\u590d\u5ba2\u6237\u5206\u6790")
    @PostMapping(value={"repeat"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomerRepeatStatistics>> repeatCustomerStatistics(@RequestBody @ApiParam(value="\u6743\u9650dto") SalesStatisticsDto dto) {
        return ApiResponse.success(this.customerService.repeatCustomerStatistics(dto));
    }

    @ApiOperation(value="\u83b7\u53d6\u5ba2\u6237\u91cd\u590d\u5217\u8868", notes="\u83b7\u53d6\u5ba2\u6237\u91cd\u590d\u5217\u8868")
    @PostMapping(value={"repeat/list"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomerEntity>> repeatCustomerList(@RequestBody @ApiParam(value="\u6743\u9650dto") SalesStatisticsDto dto) {
        return ApiResponse.success(this.customerService.repeatCustomerList(dto));
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u7528\u8f66\u7533\u8bf7\u8bb0\u5f55", notes="\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u7528\u8f66\u7533\u8bf7\u8bb0\u5f55")
    @PostMapping(value={"/selectByCustomerId"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<VehicleApplication>> selectVehicleApplicationByCustomerId(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto customerDto) {
        return ApiResponse.success(this.customerService.selectVehicleApplicationByCustomerId(customerDto));
    }

    @ApiOperation(value="\u5ba2\u6237\u7efc\u5408\u5206\u6790", notes="\u5ba2\u6237\u7efc\u5408\u5206\u6790")
    @PostMapping(value={"/customerSynthesisAnalysis"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomerEntityVo>> customerSynthesisAnalysis(@RequestBody @ApiParam(value="\u6743\u9650dto") SalesStatisticsDto dto) {
        return ApiResponse.success(this.customerService.customerSynthesisAnalysis(dto));
    }

    @ApiOperation(value="\u7ebf\u7d22\u8f6c\u6362\u65f6\uff0c\u5ba2\u6237\u67e5\u91cd", notes="\u7ebf\u7d22\u8f6c\u6362\u65f6\uff0c\u5ba2\u6237\u67e5\u91cd")
    @PostMapping(value={"/selectRepeatCustomerList"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CustomerEntity>> selectRepeatCustomerList(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto dto) {
        return ApiResponse.success(this.customerService.selectRepeatCustomerList(dto));
    }

    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237\u7981\u6b62\u91cd\u590d\u72b6\u6001", notes="\u66f4\u65b0\u5ba2\u6237\u7981\u6b62\u91cd\u590d\u72b6\u6001")
    @PostMapping(value={"/updateDisableRepeatById"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateDisableRepeatById(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto dto) {
        return ApiResponse.success((Object)this.customerService.updateDisableRepeatById(dto));
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u540d\u79f0\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u5728\u4f8b\u5916\u5ba2\u6237\u4e0b\u65b0\u5efa\u5546\u673a", notes="\u6839\u636e\u5ba2\u6237\u540d\u79f0\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u5728\u4f8b\u5916\u5ba2\u6237\u4e0b\u65b0\u5efa\u5546\u673a")
    @GetMapping(value={"/selectExceptionCustomer"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ExceptionCustomerVo> selectExceptionCustomer(@RequestParam(value="customerName") @ApiParam(value="\u5ba2\u6237\u540d\u79f0") String customerName) {
        return ApiResponse.success((Object)this.customerService.selectExceptionCustomer(customerName));
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5ba2\u6237\u6240\u5c5e\u90e8\u95e8", notes="\u6279\u91cf\u4fee\u6539\u5ba2\u6237\u6240\u5c5e\u90e8\u95e8")
    @PostMapping(value={"/customerChangeDeptBatch"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> customerChangeDeptBatch(@RequestBody DeptChangeBatchDto dto) {
        return this.customerService.customerChangeDeptBatch(dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u5173\u8054\u4e86\u6307\u5b9a\u4ee3\u7406\u5546\u7684\u5546\u673a\u5217\u8868\uff08\u65e0\u6743\u9650\u9650\u5236\uff09", notes="\u67e5\u8be2\u5173\u8054\u4e86\u6307\u5b9a\u4ee3\u7406\u5546\u7684\u5546\u673a\u5217\u8868\uff08\u65e0\u6743\u9650\u9650\u5236\uff09")
    @PostMapping(value={"/selectCustomerListByAgentId"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomerEntity>> selectCustomerListByAgentId(@RequestBody CustomerDto dto) {
        return this.customerService.selectCustomerListByAgentId(dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u5173\u8054\u4e86\u6307\u5b9a\u4ee3\u7406\u5546\u7684\u5546\u673a\u5217\u8868\uff08\u6743\u9650\u9650\u5236\uff09", notes="\u67e5\u8be2\u5173\u8054\u4e86\u6307\u5b9a\u4ee3\u7406\u5546\u7684\u5546\u673a\u5217\u8868\uff08\u6743\u9650\u9650\u5236\uff09")
    @PostMapping(value={"/selectCustomerListByAgentIdAndPermission"})
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomerEntity>> selectCustomerListByAgentIdAndPermission(@RequestBody CustomerDto dto) {
        return this.customerService.selectCustomerListByAgentIdAndPermission(dto);
    }

    @PostMapping(value={"/selectAllCustomerList"})
    @ApiOperation(value="\u67e5\u770b\u5168\u90e8\u5ba2\u6237\u5217\u8868\uff08\u65e0\u6743\u9650\u9650\u5236\uff09", notes="\u67e5\u770b\u5168\u90e8\u5ba2\u6237\u5217\u8868\uff08\u65e0\u6743\u9650\u9650\u5236\uff09")
    @AuditLog(moduleName="\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5ba2\u6237\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomerEntity>> selectAllCustomerList(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto dto) {
        return this.customerService.selectAllCustomerList(dto);
    }

    @PostMapping(value={"/customerChangeDeptByChargePersonBatch"})
    @ApiOperation(value="\u5ba2\u6237\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8\u4e3a\u8d1f\u8d23\u4eba\u6240\u5c5e\u90e8\u95e8", notes="\u5ba2\u6237\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8\u4e3a\u8d1f\u8d23\u4eba\u6240\u5c5e\u90e8\u95e8")
    public ApiResponse<String> customerChangeDeptByChargePersonBatch(@RequestBody DeptChangeBatchDto dto) {
        return this.customerService.customerChangeDeptByChargePersonBatch(dto);
    }

    @PostMapping(value={"/updateCustomerFinancialInfo"})
    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237\u8d22\u52a1\u4fe1\u606f", notes="\u66f4\u65b0\u5ba2\u6237\u8d22\u52a1\u4fe1\u606f")
    public ApiResponse<String> updateCustomerFinancialInfo(@RequestBody CustomerDto dto) {
        return this.customerService.updateCustomerFinancialInfo(dto);
    }

    @PostMapping(value={"/release"})
    @ApiOperation(value="\u91ca\u653e\u5ba2\u6237\u5230\u516c\u6d77", notes="\u91ca\u653e\u5ba2\u6237\u5230\u516c\u6d77")
    public ApiResponse<String> release(@RequestBody ReleaseCustomerDto dto) {
        return this.customerService.release(dto);
    }
}

