/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.impl;

import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dao.OpportunityPoolMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dao.OpportunityPoolMemberMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.OpportunityPoolMember;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IOpportunityPoolMemberService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OpportunityPoolMemberVO;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityPoolMemberServiceImpl
extends HussarServiceImpl<OpportunityPoolMemberMapper, OpportunityPoolMember>
implements IOpportunityPoolMemberService {
    @Resource
    OpportunityPoolMapper opportunityPoolMapper;
    @Resource
    IOrganUserBoService organUserBoService;

    @Override
    public List<String> getPoolListByPermission(SecurityUser user) {
        List<Long> poolIdList;
        ArrayList<Long> deptIds = new ArrayList();
        if (user.getDeptId() != null) {
            deptIds = this.organUserBoService.getParentOrganIncludeOneself(Collections.singletonList(user.getDeptId()));
        }
        if (CollectionUtil.isEmpty(poolIdList = ((OpportunityPoolMemberMapper)this.baseMapper).getPoolListByPermission(user.getUserId(), user.getRolesList(), deptIds))) {
            return Collections.singletonList("-1");
        }
        return poolIdList.stream().distinct().map(String::valueOf).collect(Collectors.toList());
    }

    @Override
    public String getUserOpportunityPermission(SecurityUser user, Long opportunityId) {
        List<OpportunityPoolMemberVO> opportunityPoolMemberVOList;
        ArrayList<Long> deptIds = new ArrayList();
        if (user.getDeptId() != null) {
            deptIds = this.organUserBoService.getParentOrganIncludeOneself(Collections.singletonList(user.getDeptId()));
        }
        if (CollectionUtil.isEmpty(opportunityPoolMemberVOList = ((OpportunityPoolMemberMapper)this.baseMapper).getUserOpportunityPermission(user.getUserId(), user.getRolesList(), deptIds, Collections.singletonList(opportunityId), null))) {
            return OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NO;
        }
        String rememberRole = OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NO;
        for (OpportunityPoolMemberVO opportunityPoolMemberVO : opportunityPoolMemberVOList) {
            String memberRole = opportunityPoolMemberVO.getMemberRole();
            if (OpportunityPoolConstant.POOL_MEMBER_ROLE_NORMAL.equals(memberRole)) {
                rememberRole = OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NORMAL;
            }
            if (!OpportunityPoolConstant.POOL_MEMBER_ROLE_MANAGER.equals(memberRole)) continue;
            return OpportunityPoolConstant.POOL_MEMBER_PERMISSION_MANAGE;
        }
        return rememberRole;
    }

    @Override
    public String getUserOpportunityPoolPermission(SecurityUser user, Long publicPoolId) {
        List<OpportunityPoolMemberVO> opportunityPoolMemberVOList;
        ArrayList<Long> deptIds = new ArrayList();
        if (user.getDeptId() != null) {
            deptIds = this.organUserBoService.getParentOrganIncludeOneself(Collections.singletonList(user.getDeptId()));
        }
        if (CollectionUtil.isEmpty(opportunityPoolMemberVOList = ((OpportunityPoolMemberMapper)this.baseMapper).getUserOpportunityPermission(user.getUserId(), user.getRolesList(), deptIds, null, Collections.singletonList(publicPoolId)))) {
            return OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NO;
        }
        String rememberRole = OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NO;
        for (OpportunityPoolMemberVO opportunityPoolMemberVO : opportunityPoolMemberVOList) {
            String memberRole = opportunityPoolMemberVO.getMemberRole();
            if (OpportunityPoolConstant.POOL_MEMBER_ROLE_NORMAL.equals(memberRole)) {
                rememberRole = OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NORMAL;
            }
            if (!OpportunityPoolConstant.POOL_MEMBER_ROLE_MANAGER.equals(memberRole)) continue;
            return OpportunityPoolConstant.POOL_MEMBER_PERMISSION_MANAGE;
        }
        return rememberRole;
    }

    @Override
    public String getUserOpportunityPermission(SecurityUser user, List<Long> opportunityIds) {
        List<OpportunityPoolMemberVO> opportunityPoolMemberVOList;
        ArrayList<Long> deptIds = new ArrayList();
        if (user.getDeptId() != null) {
            deptIds = this.organUserBoService.getParentOrganIncludeOneself(Collections.singletonList(user.getDeptId()));
        }
        if (CollectionUtil.isEmpty(opportunityPoolMemberVOList = ((OpportunityPoolMemberMapper)this.baseMapper).getUserOpportunityPermission(user.getUserId(), user.getRolesList(), deptIds, opportunityIds, null))) {
            return OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NO;
        }
        Map<Long, List<OpportunityPoolMemberVO>> opportunityPoolMemberVOListMap = opportunityPoolMemberVOList.stream().collect(Collectors.groupingBy(OpportunityPoolMemberVO::getOpportunityId));
        String returnMemberRole = null;
        for (Long opportunityId : opportunityIds) {
            List<OpportunityPoolMemberVO> thisOpportunityPoolMemberVoList = opportunityPoolMemberVOListMap.get(opportunityId);
            if (CollectionUtil.isEmpty(thisOpportunityPoolMemberVoList)) {
                return OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NO;
            }
            String opportunityMemberRole = null;
            for (OpportunityPoolMemberVO memberVO : thisOpportunityPoolMemberVoList) {
                String memberRole = memberVO.getMemberRole();
                if (OpportunityPoolConstant.POOL_MEMBER_ROLE_NORMAL.equals(memberRole)) {
                    opportunityMemberRole = OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NORMAL;
                }
                if (!OpportunityPoolConstant.POOL_MEMBER_ROLE_MANAGER.equals(memberRole)) continue;
                opportunityMemberRole = OpportunityPoolConstant.POOL_MEMBER_PERMISSION_MANAGE;
                break;
            }
            if (!OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NORMAL.equals(opportunityMemberRole)) continue;
            returnMemberRole = OpportunityPoolConstant.POOL_MEMBER_PERMISSION_NORMAL;
        }
        if (StringUtil.isEmpty(returnMemberRole)) {
            return OpportunityPoolConstant.POOL_MEMBER_PERMISSION_MANAGE;
        }
        return returnMemberRole;
    }
}

