/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.competitorcontact.service.ICompetitorContactDataRightModuleService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.jzds.basearea1.model.BaseArea1;
import com.jxdinfo.crm.core.crm.jzds.basearea1.service.BaseArea1Service;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.dao.CompetitorContactMapper;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.dao.CrmCompetitorContactMapper;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.dto.CompetitorContactDto;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.model.CrmCompetitorContact;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.service.ICompetitorContactService;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.vo.CompetitorContactVo;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class CompetitorContactServiceImpl
extends HussarServiceImpl<CrmCompetitorContactMapper, CrmCompetitorContact>
implements ICompetitorContactService {
    @Autowired
    private ITrackRecordAPIService trackRecordAPIService;
    @Autowired
    private IOperateRecordAPIService operateRecordAPIService;
    @Autowired
    private TeamMeberMapper teamMeberMapper;
    @Autowired
    private TeamMeberService teamMeberService;
    @Autowired
    private FileInfoMapper fileInfoMapper;
    @Autowired
    private UnifyProperties unifyProperties;
    @Autowired
    private ImGroupMemberService imGroupMemberService;
    @Autowired
    private ISysDicRefService sysDicRefService;
    @Autowired
    private BaseArea1Service area1Service;
    @Autowired
    private FileInfoService fileInfoService;
    @Autowired
    private FocusService focusService;
    @Autowired
    private ITaskAPIService taskAPIService;
    @Autowired
    private CompetitorContactMapper competitorContactMapper;
    @Resource
    private ICompetitorContactDataRightModuleService competitorContactDataRightModuleService;
    @Resource
    private ITeamMemberApiService teamMemberApiService;
    @Resource
    private IHussarBaseResourceAdapter hussarBaseResourceAdapter;

    @Override
    public Boolean deleteCompetitorContact(CompetitorContactDto dto) {
        Long competitorContactId = dto.getCompetitorContactId();
        Long recCount = this.trackRecordAPIService.countContact(Collections.singletonList(String.valueOf(competitorContactId)), "0");
        if (recCount > 0L) {
            throw new BaseException("\u5df2\u4ea7\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.competitorContactMapper.deleteCompetitorContactByCompetitorContactId(competitorContactId, "1");
        ArrayList<String> competitorContactIds = new ArrayList<String>();
        competitorContactIds.add(String.valueOf(competitorContactId));
        this.teamMeberMapper.updateDelFlagByIds(null, "1", competitorContactIds);
        List trackRecordList = this.trackRecordAPIService.list(competitorContactIds, null, Collections.singletonList(RecordProductTypeEnum.PRODUCE_SYSTEM.getId()), "0");
        List<Object> recordIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)trackRecordList)) {
            recordIds = trackRecordList.stream().map(TrackRecordAPIVo::getRecordId).collect(Collectors.toList());
        }
        this.trackRecordAPIService.deleteBatchByIds(competitorContactIds, CrmBusinessTypeEnum.COMPETITOR_CONTACT.getId(), "1");
        List<Long> lids = competitorContactIds.stream().map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(recordIds)) {
            lids.addAll(recordIds);
        }
        this.fileInfoMapper.deleteFileInfoByIds(null, lids, "1");
        return true;
    }

    @Override
    public OperateVo isOperate(Long competitorContactId) {
        PermissionDto permissionDto;
        OperateVo operateVo = new OperateVo();
        if (competitorContactId == null) {
            return operateVo;
        }
        CrmCompetitorContact competitorContactEntity = (CrmCompetitorContact)this.getById(competitorContactId);
        if (competitorContactEntity == null || "1".equals(competitorContactEntity.getDelFlag())) {
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (Objects.equals(competitorContactEntity.getChargePersonId(), user.getUserId())) {
            operateVo.setViewOperate(Boolean.valueOf(true));
            operateVo.setEditOperate(Integer.valueOf(1));
            return operateVo;
        }
        this.teamMemberApiService.teamMemberOperate(competitorContactEntity.getCompetitorContactId(), user, operateVo, "21");
        if (!operateVo.getViewOperate().booleanValue() && ((permissionDto = this.competitorContactDataRightModuleService.getUserRolePermission(user)).getPermissionDeptIds() == null || permissionDto.getPermissionDeptIds().contains(competitorContactEntity.getOwnDepartment()))) {
            operateVo.setViewOperate(Boolean.valueOf(true));
        }
        return operateVo;
    }

    public void addTrackRecordBatch(List<CompetitorContactDto> dtoList, List<Long> oldContactPersonIdList, List<String> oldContactPersonNameList, String newChargePersonId, String newChargePersonName) {
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (int i = 0; i < dtoList.size(); ++i) {
            CompetitorContactDto dto = dtoList.get(i);
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(Long.valueOf(newChargePersonId));
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            if (HussarUtils.isNotEmpty((Object)oldContactPersonIdList.get(i))) {
                operateRecordDO.setOldContactId(oldContactPersonIdList.get(i));
            }
            operateRecordDO.setOldContactName(oldContactPersonNameList.get(i));
            operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType(CrmBusinessTypeEnum.COMPETITOR_CONTACT.getId());
            operateRecordDO.setTypeId(dto.getCompetitorContactId());
            operateRecordDO.setBusinessName(dto.getCompetitorContactName());
            operateRecordDO.setCreatePerson(user.getUserId());
            operateRecordDO.setCreatePersonName(user.getUserName());
            operateRecordDO.setCreateTime(date);
            operateRecordDO.setChangePerson(user.getUserId());
            operateRecordDO.setChangeTime(date);
            operateRecordDO.setChangePersonName(user.getUserName());
            operateRecordDO.setDelflag("0");
            if (operateRecordDO.getProduceType() == null) {
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            trackRecordList.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
    }

    @Override
    public TransferBatchResultVo competitorContactTransferBatch(List<CompetitorContactDto> dtos) {
        Object teamMeberEntity;
        ArrayList<TeamMeberEntity> teamMeberEntityList;
        ArrayList<String> msgList;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int dtoSize = dtos.size();
        int noPermissionNum = 0;
        int alreadyChargePersonNum = 0;
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        String keepFlag = dtos.get(0).getKeepFlag();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId(dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(newChargePersonId);
        String newOwnDepartment = mapDepartment.getDepartmentId().toString();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        List competitorContactIdList = dtos.stream().map(CompetitorContactDto::getCompetitorContactId).collect(Collectors.toList());
        List competitorContactEntityList = this.listByIds(competitorContactIdList);
        ArrayList<Long> excludeContactIdList = new ArrayList<Long>();
        List elementResourceVos = this.hussarBaseResourceAdapter.elementResources("/crm/jzds/competitorManagement", user.getRolesList());
        Set<Object> resourceSet = new HashSet();
        if (CollectionUtil.isNotEmpty((Collection)elementResourceVos) && ((ElementResourceVo)elementResourceVos.get(0)).getPermission() != null) {
            resourceSet = Arrays.stream(((ElementResourceVo)elementResourceVos.get(0)).getPermission().split(",")).collect(Collectors.toSet());
        }
        for (Long contactId : competitorContactIdList) {
            OperateVo operateVo = this.isOperate(contactId);
            if (operateVo.getEditOperate() == -1) {
                excludeContactIdList.add(contactId);
                ++noPermissionNum;
                continue;
            }
            if (operateVo.getEditOperate() != 0 || resourceSet.contains("competitor_contact_edit")) continue;
            excludeContactIdList.add(contactId);
            ++noPermissionNum;
        }
        for (Long excludeContactId : excludeContactIdList) {
            dtos = dtos.stream().filter(competitorContactDto -> !competitorContactDto.getCompetitorContactId().equals(excludeContactId)).collect(Collectors.toList());
        }
        competitorContactIdList = dtos.stream().map(CompetitorContactDto::getCompetitorContactId).collect(Collectors.toList());
        competitorContactEntityList = ToolUtil.isNotEmpty(competitorContactIdList) ? this.listByIds(competitorContactIdList) : new ArrayList();
        ArrayList<CompetitorContactDto> dtoList = new ArrayList<CompetitorContactDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (CompetitorContactDto dto : dtos) {
            CrmCompetitorContact competitorContactEntity = competitorContactEntityList.stream().filter(object -> Objects.equals(object.getCompetitorContactId(), dto.getCompetitorContactId())).findFirst().get();
            String oldChargePersonName = dto.getOldChargePersonName();
            String string = dto.getOldChargePersonId();
            if (newChargePersonId.equals(string) && newChargePersonName.equals(oldChargePersonName)) {
                ++alreadyChargePersonNum;
                continue;
            }
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setNewChargePersonId(newChargePersonId);
            dto.setNewChargePersonName(newChargePersonName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setCompetitorContactName(competitorContactEntity.getCompetitorContactName());
            dtoList.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(dto.getCompetitorContactId());
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (dtoList.size() + alreadyChargePersonNum == dtoSize) {
            resultVo.setTransferResult(true);
            msgList = new ArrayList<String>();
            msgList.add("\u8f6c\u79fb\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(false);
            msgList = new ArrayList();
            if (dtoSize == 1) {
                if (noPermissionNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                Object msg = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", dtoList.size() + alreadyChargePersonNum, dtoSize - dtoList.size() - alreadyChargePersonNum);
                if (noPermissionNum != 0) {
                    msg = msg + "\u65e0\u6743\u9650";
                }
                msgList.add((String)msg);
                resultVo.setMsgList(msgList);
            }
        }
        if (dtoList.isEmpty()) {
            return resultVo;
        }
        this.competitorContactMapper.updateChargePersonBatch(dtoList);
        if ("0".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (CompetitorContactDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                ((TeamMeberEntity)((Object)teamMeberEntity)).setBusinessId(dto.getCompetitorContactId());
                ((TeamMeberEntity)((Object)teamMeberEntity)).setDelFlag("1");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntityList.add((TeamMeberEntity)((Object)teamMeberEntity));
            }
            this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
        } else if ("1".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList();
            for (CompetitorContactDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                ((TeamMeberEntity)((Object)teamMeberEntity)).setBusinessId(dto.getCompetitorContactId());
                ((TeamMeberEntity)((Object)teamMeberEntity)).setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                ((TeamMeberEntity)((Object)teamMeberEntity)).setIsCharge("0");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setMemberRole("6");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setModifyPower(null);
                teamMeberEntityList.add((TeamMeberEntity)((Object)teamMeberEntity));
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<CompetitorContactDto> insertMemberDtoList = new ArrayList<CompetitorContactDto>();
        ArrayList<CompetitorContactDto> updateChargeDtoList = new ArrayList<CompetitorContactDto>();
        for (CompetitorContactDto competitorContactDto2 : dtoList) {
            boolean bl = true;
            for (Map<String, Object> map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(competitorContactDto2.getCompetitorContactId())) continue;
                updateChargeDtoList.add(competitorContactDto2);
                bl = false;
                break;
            }
            if (!bl) continue;
            insertMemberDtoList.add(competitorContactDto2);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList2 = new ArrayList<TeamMeberEntity>();
            for (CompetitorContactDto competitorContactDto3 : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity2 = new TeamMeberEntity();
                teamMeberEntity2.setBusinessId(competitorContactDto3.getCompetitorContactId());
                teamMeberEntity2.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity2.setIsCharge("1");
                teamMeberEntity2.setMemberRole(null);
                teamMeberEntity2.setModifyPower("1");
                teamMeberEntityList2.add(teamMeberEntity2);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList2);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.parseLong(newChargePersonId), insertMemberDtoList.stream().map(CompetitorContactDto::getCompetitorContactId).collect(Collectors.toList()), "1", "1", ((CompetitorContactDto)insertMemberDtoList.get(0)).getChangeTime(), "21");
        }
        ArrayList<Long> longOldChargePersonIdList = new ArrayList<Long>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompetitorContactDto dto : dtoList) {
            longOldChargePersonIdList.add(Long.parseLong(dto.getOldChargePersonId()));
            arrayList.add(dto.getOldChargePersonName());
        }
        this.addTrackRecordBatch(dtoList, longOldChargePersonIdList, arrayList, newChargePersonId, newChargePersonName);
        for (CompetitorContactDto dto : dtoList) {
            String competitorName = dto.getCompetitorName();
            String competitorContactName = dto.getCompetitorContactName();
            Long competitorContactId = dto.getCompetitorContactId();
            String oldChargePersonId = dto.getOldChargePersonId();
            String title = user.getUserName() + "\u5c06\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60";
            String content = "\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + competitorContactName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sy/yddsy", dto.getCompetitorContactId().toString(), Arrays.asList(dto.getNewChargePersonId()));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index" + "\"" + dto.getCompetitorContactId() + "\"";
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60\uff0c\u8054\u7cfb\u4eba\u3010" + competitorContactName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, dto.getNewChargePersonId(), user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("21");
            crmTeamAdminInfoDto.setBusinessId(competitorContactId);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(oldChargePersonId);
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return resultVo;
    }

    @Override
    public CompetitorContactVo getCompetitorContactDetailById(Long competitorContactId) {
        List areaLabelList;
        if (!this.isOperate(competitorContactId).getViewOperate().booleanValue()) {
            return null;
        }
        CrmCompetitorContact competitorContactEntity = (CrmCompetitorContact)this.getById(competitorContactId);
        if (competitorContactEntity == null || "1".equals(competitorContactEntity.getDelFlag())) {
            return null;
        }
        CompetitorContactVo competitorContactVo = (CompetitorContactVo)BeanUtil.copy((Object)competitorContactEntity, CompetitorContactVo.class);
        assert (competitorContactVo != null);
        if (StringUtil.isNotBlank((CharSequence)competitorContactVo.getSex())) {
            competitorContactVo.setSex(this.sysDicRefService.getDictLabel("sex", competitorContactVo.getSex()));
        }
        ArrayList<String> areaList = new ArrayList<String>();
        if (StringUtil.isNotBlank((CharSequence)competitorContactVo.getProvince())) {
            areaList.add(competitorContactVo.getProvince());
        }
        if (StringUtil.isNotBlank((CharSequence)competitorContactVo.getCity())) {
            areaList.add(competitorContactVo.getCity());
        }
        if (StringUtil.isNotBlank((CharSequence)competitorContactVo.getCounty())) {
            areaList.add(competitorContactVo.getCounty());
        }
        if (areaList.size() > 0 && (areaLabelList = this.area1Service.list((Wrapper)new LambdaQueryWrapper().in(BaseArea1::getBaseAreaid, areaList))) != null) {
            for (BaseArea1 area : areaLabelList) {
                if (StringUtil.isNotBlank((CharSequence)competitorContactVo.getProvince()) && String.valueOf(area.getBaseAreaid()).equals(competitorContactVo.getProvince())) {
                    competitorContactVo.setProvince(area.getName());
                }
                if (StringUtil.isNotBlank((CharSequence)competitorContactVo.getCity()) && String.valueOf(area.getBaseAreaid()).equals(competitorContactVo.getCity())) {
                    competitorContactVo.setCity(area.getName());
                }
                if (!StringUtil.isNotBlank((CharSequence)competitorContactVo.getCounty()) || !String.valueOf(area.getBaseAreaid()).equals(competitorContactVo.getCounty())) continue;
                competitorContactVo.setCounty(area.getName());
            }
        }
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(competitorContactVo.getCompetitorContactId());
        List fileRecordIds = this.trackRecordAPIService.selectRelationRecordIds(competitorContactId);
        if (CollectionUtil.isNotEmpty((Collection)fileRecordIds)) {
            businessIds.addAll(fileRecordIds);
        }
        competitorContactVo.setFileCount(this.fileInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1")));
        competitorContactVo.setMemberCount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)competitorContactVo.getCompetitorContactId())).eq(TeamMeberEntity::getBusinessType, (Object)"21")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        SecurityUser user = BaseSecurityUtil.getUser();
        long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)competitorContactVo.getCompetitorContactId())).eq(FocusEntity::getBusinessType, (Object)"21")).eq(FocusEntity::getCreatePersion, (Object)user.getUserId()));
        competitorContactVo.setFocus(focusCount > 0L);
        competitorContactVo.setTaskAmount(this.taskAPIService.selectTaskCount("21", competitorContactId));
        return competitorContactVo;
    }

    @Override
    public void concatMobilePhone(CrmCompetitorContact competitorContactEntity) {
        if (ToolUtil.isNotEmpty((Object)competitorContactEntity.getMobilePhone()) && competitorContactEntity.getMobilePhone().trim().length() >= 4) {
            competitorContactEntity.setMobilePhone(competitorContactEntity.getMobilePhone().trim().substring(0, 3) + "****" + competitorContactEntity.getMobilePhone().trim().substring(competitorContactEntity.getMobilePhone().trim().length() - 4));
        } else {
            competitorContactEntity.setMobilePhone("");
        }
    }
}

