/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.vo.CityVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.ProvinceVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.dao.CompanyBusinessInfoMapper;
import com.jxdinfo.crm.core.common.dto.TianYanChaDto;
import com.jxdinfo.crm.core.common.model.CompanyBusinessInfo;
import com.jxdinfo.crm.core.common.model.Stru;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.BackfillInfoVo;
import com.jxdinfo.crm.core.common.vo.CompanyBaseInfo;
import com.jxdinfo.crm.core.common.vo.CompanyBusinessInfoVo;
import com.jxdinfo.crm.core.common.vo.CompanySelectResponse;
import com.jxdinfo.crm.core.common.vo.CrmStruVo;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.SearchCustomersVo;
import com.jxdinfo.crm.core.common.vo.StruVo;
import com.jxdinfo.crm.core.common.vo.TianYanChaInfoVo;
import com.jxdinfo.crm.core.common.vo.TianYanChaReponse;
import com.jxdinfo.crm.core.common.vo.TianYanChaResult;
import com.jxdinfo.crm.core.common.vo.TianYanChaVo;
import com.jxdinfo.crm.core.common.vo.UserInfoVo;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl
implements CommonService {
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private CompanyBusinessInfoMapper companyBusinessInfoMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    public static final String BASE_INFO_URL = "/services/open/ic/baseinfo/normal?keyword=";
    public static final String SEARCH_URL = "/services/open/search/2.0";

    @Override
    public String selectUserUnit() {
        HashMap map = new HashMap();
        SecurityUser user = BaseSecurityUtil.getUser();
        String struId = user.getDeptId().toString();
        Stru stru = new Stru();
        while (null != (stru = this.commonMapper.selectUserUnit(Long.valueOf(struId)))) {
            struId = stru.getStruId();
            if (!"1".equals(stru.getOrganType())) continue;
        }
        return struId;
    }

    @Override
    public List<StruVo> selectStruByParentId(String struId) {
        List<StruVo> list = this.commonMapper.selectStruByParentId(Long.valueOf(struId));
        return list;
    }

    @Override
    public List<String> selectAllSonsId(String struId, String struType) {
        String[] temp;
        ArrayList<String> ids = new ArrayList<String>();
        String sonsId = this.commonMapper.selectAllStruId(struId, struType);
        for (String s : temp = sonsId.split(",")) {
            if ("".equals(s)) continue;
            ids.add(s);
        }
        return ids;
    }

    @Override
    public boolean getUserRoleIsManage() {
        boolean flag = false;
        SecurityUser user = BaseSecurityUtil.getUser();
        List roleList = user.getRolesList();
        int roleNum = this.commonMapper.getUserRoleIsManage(roleList);
        if (roleNum > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public List<Map<String, Object>> getAllSecondStru() {
        return this.commonMapper.getAllSecondStru();
    }

    @Override
    public UserInfoVo getUserInfo(Long userId) {
        return this.commonMapper.getUserInfo(userId);
    }

    @Override
    public List<UserInfoVo> getUserInfoList(String searchKey) {
        return this.commonMapper.getUserInfoList(searchKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page<TianYanChaVo> getCompanyByTianyancha(TianYanChaDto tianYanChaDto) {
        Page page;
        block8: {
            page = null;
            if (StringUtil.isEmpty((Object)tianYanChaDto.getSearchKey())) {
                throw new BaseException("\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String url = this.crmProperties.getTianyancha().getUrl() + SEARCH_URL + "?pageSize=" + tianYanChaDto.getSize() + "&pageNum=" + tianYanChaDto.getCurrent() + "&word=" + tianYanChaDto.getSearchKey();
            HttpGet request = new HttpGet(url);
            request.setHeader("Authorization", this.crmProperties.getTianyancha().getToken());
            request.setConfig(RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).setConnectionRequestTimeout(60000).build());
            DefaultHttpClient httpClient = new DefaultHttpClient();
            try {
                HttpResponse response = httpClient.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() != 200) break block8;
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                TianYanChaReponse dataResponse = (TianYanChaReponse)JsonUtil.parse((String)result, TianYanChaReponse.class);
                if (dataResponse.getError_code() == 0) {
                    page = this.toTransferBean(dataResponse.getResult());
                    page.setCurrent((long)tianYanChaDto.getCurrent().intValue());
                    page.setSize((long)tianYanChaDto.getSize().intValue());
                    break block8;
                }
                if (dataResponse.getError_code() == 300000) {
                    page = new Page();
                    page.setRecords(new ArrayList());
                    page.setTotal(0L);
                    page.setCurrent((long)tianYanChaDto.getCurrent().intValue());
                    page.setSize((long)tianYanChaDto.getSize().intValue());
                    break block8;
                }
                throw new HussarException(dataResponse.getReason());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                httpClient.getConnectionManager().shutdown();
            }
        }
        return page;
    }

    @Override
    public BackfillInfoVo getBackfillInfoByName(String name) {
        BackfillInfoVo backfillInfoVo = new BackfillInfoVo();
        CompanyBusinessInfoVo companyBusinessInfoVo = this.getCompanyBusinessInfo(name);
        if (HussarUtils.isEmpty((Object)((Object)companyBusinessInfoVo))) {
            return null;
        }
        BeanUtil.copyProperties((Object)((Object)companyBusinessInfoVo), (Object)backfillInfoVo);
        Map<String, Object> RegionalInformation = this.commonMapper.getProvinceByCity(companyBusinessInfoVo.getCity(), companyBusinessInfoVo.getDistrict());
        if (HussarUtils.isNotEmpty(RegionalInformation)) {
            backfillInfoVo.setProvince((String)RegionalInformation.get("province"));
            backfillInfoVo.setProvinceId((Long)RegionalInformation.get("provinceId"));
            backfillInfoVo.setCity((String)RegionalInformation.get("city"));
            backfillInfoVo.setCityId((Long)RegionalInformation.get("cityId"));
            backfillInfoVo.setDistrict((String)RegionalInformation.get("district"));
            backfillInfoVo.setDistrictId((Long)RegionalInformation.get("districtId"));
            backfillInfoVo.setIndustry(companyBusinessInfoVo.getIndustry());
        }
        List listingStatusDic = this.sysDicRefService.getDicListByType("listing_status");
        List staffNumDic = this.sysDicRefService.getDicListByType("staff_nums");
        List industryDic = this.sysDicRefService.getDicListByType("industry");
        for (DicVo dicVo : listingStatusDic) {
            if (HussarUtils.isEmpty((Object)companyBusinessInfoVo.getBondType())) {
                backfillInfoVo.setListingStatus("1");
                break;
            }
            if (!dicVo.getLabel().equals(companyBusinessInfoVo.getBondType())) continue;
            backfillInfoVo.setListingStatus(dicVo.getValue());
            break;
        }
        for (DicVo dicVo : staffNumDic) {
            if (HussarUtils.isEmpty((Object)companyBusinessInfoVo.getStaffNumRange())) {
                backfillInfoVo.setStaffNumber("");
                break;
            }
            if (!dicVo.getLabel().equals(companyBusinessInfoVo.getStaffNumRange())) continue;
            backfillInfoVo.setStaffNumber(dicVo.getValue());
            break;
        }
        for (DicVo dicVo : industryDic) {
            if (HussarUtils.isEmpty((Object)companyBusinessInfoVo.getDistrict())) {
                backfillInfoVo.setIndustry("");
                break;
            }
            if (!dicVo.getLabel().equals(companyBusinessInfoVo.getDistrict())) continue;
            backfillInfoVo.setIndustry(dicVo.getValue());
            break;
        }
        if (HussarUtils.isEmpty((Object)backfillInfoVo.getAlias())) {
            backfillInfoVo.setAlias(this.companySimplify(backfillInfoVo.getName()));
        }
        return backfillInfoVo;
    }

    @Override
    public String companySimplify(String name) {
        block0: {
            if (!StringUtil.isNotEmpty((Object)name) || name.length() <= 4) break block0;
            name = name.substring(0, 4);
        }
        return name;
    }

    @Override
    public List<String> getRoleNameByUser_Id(Long userId) {
        return this.commonMapper.getRoleNameByUserId(userId);
    }

    @Override
    public Map<String, Object> getChargePersonDetailed(String userId, String userName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String chargePersonId = CommonUtills.translateUserId(userId);
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(chargePersonId);
        String ownDepartment = mapDepartment.getDepartmentId().toString();
        String ownDepartmentName = mapDepartment.getDepartmentName();
        map.put("chargePersonId", chargePersonId);
        map.put("chargePersonName", userName);
        map.put("ownDepartment", ownDepartment);
        map.put("ownDepartmentName", ownDepartmentName);
        return map;
    }

    @Override
    public void getUserHead(String userId, HttpServletResponse response) throws IOException {
        List list = this.sysUsersService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getId, (Object)userId)).or()).eq(SysUsers::getChar1, (Object)userId));
        if (list != null && list.size() > 0) {
            String url = this.crmProperties.getEfs();
            response.sendRedirect(url + "/" + ((SysUsers)list.get(0)).getChar1() + "/100x100");
        } else {
            response.sendError(404);
        }
    }

    @Override
    public List<CrmStruVo> getOrganList(String organId, String searchKey) {
        List<CrmStruVo> struList = null;
        if (StringUtil.isNotBlank((CharSequence)searchKey)) {
            struList = this.commonMapper.getUserListNew(searchKey, organId);
        } else {
            SysStru sysStru;
            if (StringUtil.isEmpty((Object)organId)) {
                organId = "100001";
            }
            struList = "N".equals((sysStru = (SysStru)this.sysStruService.getById((Serializable)((Object)organId))).getIsLeaf()) ? this.commonMapper.getOrganList(searchKey, organId, null) : this.commonMapper.getUserListNew(searchKey, organId);
        }
        return struList;
    }

    @Override
    public List<ProvinceVo> getProvinceList() {
        List<ProvinceVo> provinceVoList = this.commonMapper.selectProvinceList();
        return provinceVoList;
    }

    @Override
    public List<OpportunityStage> getOpportunityStageList(String stageName, List<String> excludeIds, List<String> stageProcessIds) {
        return this.commonMapper.getOpportunityStageList(stageName, excludeIds, stageProcessIds);
    }

    @Override
    public List<StageProcessEntity> getStageProcessAssociateQuery(String stageProcessName, List<String> excludeIds) {
        return this.commonMapper.getStageProcessAssociateQuery(stageProcessName, excludeIds);
    }

    @Override
    public SysUsers getUserIdByYyzcStrId(String userIdStr) {
        SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getChar1, (Object)userIdStr));
        return sysUsers;
    }

    private Page<TianYanChaVo> toTransferBean(TianYanChaResult result) {
        Page page = new Page();
        page.setTotal(result.getTotal());
        if (result.getItems() != null && result.getItems().size() > 0) {
            ArrayList<TianYanChaVo> list = new ArrayList<TianYanChaVo>();
            for (TianYanChaInfoVo infoVo : result.getItems()) {
                TianYanChaVo tianYanChaVo = (TianYanChaVo)BeanUtil.copy((Object)infoVo, TianYanChaVo.class);
                tianYanChaVo.setExists(DataPermission.customerNameExists(tianYanChaVo.getName()));
                list.add(tianYanChaVo);
            }
            page.setRecords(list);
        }
        return page;
    }

    @Override
    public List<DicVo> getDicValue(String typeName, String labelName, List<String> excludeValues) {
        return this.commonMapper.getDicValue(typeName, labelName, excludeValues);
    }

    @Override
    public CompanyBaseInfo getBaseInfoByTianyancha(TianYanChaDto tianYanChaDto) {
        if (StringUtil.isEmpty((Object)tianYanChaDto.getSearchKey())) {
            throw new BaseException("\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyBaseInfo companyBaseInfo = new CompanyBaseInfo();
        CompanyBusinessInfoVo businessInfoVo = this.getCompanyBusinessInfo(tianYanChaDto.getSearchKey());
        if (HussarUtils.isEmpty((Object)((Object)businessInfoVo))) {
            return null;
        }
        BeanUtil.copyProperties((Object)((Object)businessInfoVo), (Object)companyBaseInfo);
        Map<String, Object> RegionalInformation = this.commonMapper.getProvinceByCity(companyBaseInfo.getCity(), companyBaseInfo.getDistrict());
        if (HussarUtils.isNotEmpty(RegionalInformation)) {
            companyBaseInfo.setProvince(String.valueOf(RegionalInformation.get("province")));
            companyBaseInfo.setProvinceId((Long)RegionalInformation.get("provinceId"));
            companyBaseInfo.setCity((String)RegionalInformation.get("city"));
            companyBaseInfo.setCityId((Long)RegionalInformation.get("cityId"));
            companyBaseInfo.setDistrict((String)RegionalInformation.get("district"));
            companyBaseInfo.setDistrictId((Long)RegionalInformation.get("districtId"));
        }
        return companyBaseInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompanyBusinessInfoVo getCompanyBusinessInfo(String name) {
        CompanyBusinessInfoVo businessInfoVo = null;
        CompanyBusinessInfo companyBusinessInfo = (CompanyBusinessInfo)((Object)this.companyBusinessInfoMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(CompanyBusinessInfo::getCompanyName, (Object)name)));
        if (HussarUtils.isEmpty((Object)((Object)companyBusinessInfo))) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setSocketTimeout(1000).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            try {
                HttpGet get = new HttpGet(this.crmProperties.getTianyancha().getUrl() + BASE_INFO_URL + name);
                get.setHeader("Authorization", this.crmProperties.getTianyancha().getToken());
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
                HttpEntity entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                Map map = (Map)JsonUtil.parse((String)result, Map.class);
                if (HussarUtils.isNotEmpty(map.get("result"))) {
                    String result1 = JSONObject.toJSONString(map.get("result"));
                    businessInfoVo = (CompanyBusinessInfoVo)((Object)JsonUtil.parse((String)result1, CompanyBusinessInfoVo.class));
                    CompanyBusinessInfo companyBusiness = new CompanyBusinessInfo();
                    companyBusiness.setBusinessInfo(result);
                    companyBusiness.setCompanyId(businessInfoVo.getId());
                    companyBusiness.setCompanyName(businessInfoVo.getName());
                    this.companyBusinessInfoMapper.insert((Object)companyBusiness);
                }
                CompanyBusinessInfoVo companyBusinessInfoVo = null;
                return companyBusinessInfoVo;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            businessInfoVo = (CompanyBusinessInfoVo)((Object)JSON.parseObject((String)HussarUtils.toStr((Object)JSONObject.parseObject((String)companyBusinessInfo.getBusinessInfo()).get((Object)"result")), CompanyBusinessInfoVo.class));
        }
        return businessInfoVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchCustomersVo searchCustomers(String word, int pageNum, int pageSize, String region, Integer regCapital_min, Integer regCapital_max) {
        CompanySelectResponse dataResponse = new CompanySelectResponse();
        SearchCustomersVo searchCustomersVo = new SearchCustomersVo();
        if (this.crmProperties.getAi().isAiEnable()) {
            if (StringUtil.isEmpty((Object)word)) {
                throw new BaseException("\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            StringBuilder url = new StringBuilder(this.crmProperties.getAi().getCompanySelectUrl() + "?size=" + pageSize + "&page=" + pageNum + "&key_word=" + word);
            if (HussarUtils.isNotEmpty((Object)regCapital_min)) {
                url.append("&regCapital_min=" + regCapital_min);
            }
            if (HussarUtils.isNotEmpty((Object)regCapital_max)) {
                url.append("&regCapital_max=" + regCapital_max);
            }
            if (HussarUtils.isNotEmpty((Object)region)) {
                url.append("&region=" + region);
            }
            HttpGet request = new HttpGet(String.valueOf(url));
            request.setConfig(RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).setConnectionRequestTimeout(60000).build());
            DefaultHttpClient httpClient = new DefaultHttpClient();
            try {
                HttpResponse response = httpClient.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                    dataResponse = (CompanySelectResponse)JsonUtil.parse((String)result, CompanySelectResponse.class);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                httpClient.getConnectionManager().shutdown();
            }
            searchCustomersVo.setCount(dataResponse.getData().getCount());
            searchCustomersVo.setData(Arrays.asList(dataResponse.getData().getData().toArray()));
        }
        return searchCustomersVo;
    }

    @Override
    public SysStru getLoginUserUnit(Long loginUserDeptId) {
        SysStru stru = (SysStru)this.sysStruService.getById((Serializable)loginUserDeptId);
        if ("1".equals(stru.getStruType())) {
            return stru;
        }
        Long parentId = stru.getParentId();
        if (parentId != null && !CommonConstant.STRU_INSIDE.equals(parentId) && !CommonConstant.STRU_OUTSIDE.equals(parentId)) {
            return this.getLoginUserUnit(stru.getParentId());
        }
        return null;
    }

    @Override
    public List<SysUsers> getUserExcuteNameList(String userName, List<String> excludeUsers) {
        return this.commonMapper.getUserExcuteNameList(userName, excludeUsers);
    }

    @Override
    public String getNameByStruId(Long struId) {
        return this.commonMapper.getNameByStruId(struId);
    }

    @Override
    public List<DicSingle> selectDicByTypeNames(List<String> typeNameList) {
        return this.commonMapper.selectDicByTypeNames(typeNameList);
    }

    @Override
    public boolean isTaskFinished(String taskId, String businessId) {
        int taskFinished = this.commonMapper.isTaskFinished(taskId, businessId);
        return taskFinished == 0;
    }

    @Override
    public String getSortField(String field) {
        StringBuffer buffer = new StringBuffer();
        for (char c : field.toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                buffer.append("_" + c);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString().toLowerCase();
    }

    @Override
    public List<CityVo> selectCityCode(String province) {
        String[] provinceList = new String[]{};
        if (StringUtil.isNotBlank((CharSequence)province)) {
            provinceList = province.split(",");
        }
        List<CityVo> cityVoList = this.commonMapper.selectCityListByProvince(provinceList);
        return cityVoList;
    }
}

