/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.oppotunityrequirement.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jxdinfo.crm.common.api.fileInfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.common.api.fileInfo.vo.FileInfoAPIVo;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.vo.CustomerEntityVo;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.oppotunityrequirement.constant.OpportunityReqConstant;
import com.jxdinfo.crm.core.oppotunityrequirement.dao.OpportunityRequirementMapper;
import com.jxdinfo.crm.core.oppotunityrequirement.dao.RequirementRecordMapper;
import com.jxdinfo.crm.core.oppotunityrequirement.dto.OpportunityRequirementDto;
import com.jxdinfo.crm.core.oppotunityrequirement.dto.ReqFieldDetailDto;
import com.jxdinfo.crm.core.oppotunityrequirement.dto.ReqFormQueryDto;
import com.jxdinfo.crm.core.oppotunityrequirement.dto.ReqRecordDto;
import com.jxdinfo.crm.core.oppotunityrequirement.dto.SaveOpportunityReqDto;
import com.jxdinfo.crm.core.oppotunityrequirement.model.OpportunityRequirementEntity;
import com.jxdinfo.crm.core.oppotunityrequirement.model.RequirementDetailEntity;
import com.jxdinfo.crm.core.oppotunityrequirement.model.RequirementRecordEntity;
import com.jxdinfo.crm.core.oppotunityrequirement.service.IOpportunityRequirementService;
import com.jxdinfo.crm.core.oppotunityrequirement.service.IRequirementDetailService;
import com.jxdinfo.crm.core.oppotunityrequirement.service.IRequirementRecordService;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.CanAddReqVo;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.ExportFieldVo;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.ExportFileVo;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.ExportGroupVo;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.ExportReqVo;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.ExportSheetVo;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.OpportunityProductReqListVo;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.ReqFormQueryFieldVo;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.ReqFormQueryGroupVo;
import com.jxdinfo.crm.core.oppotunityrequirement.vo.RequirementListVo;
import com.jxdinfo.crm.core.tabletemplate.dao.TableTemplateMapper;
import com.jxdinfo.crm.core.tabletemplate.model.TableFieldGroupEntity;
import com.jxdinfo.crm.core.tabletemplate.model.TableTemplateEntity;
import com.jxdinfo.crm.core.tabletemplate.model.TableTemplateFieldEntity;
import com.jxdinfo.crm.core.tabletemplate.service.ITableFieldGroupService;
import com.jxdinfo.crm.core.tabletemplate.service.ITableTemplateFieldService;
import com.jxdinfo.crm.core.tabletemplate.service.ITableTemplateService;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DictVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpportunityRequirementServiceImpl
extends ServiceImpl<OpportunityRequirementMapper, OpportunityRequirementEntity>
implements IOpportunityRequirementService {
    @Resource
    private OpportunityRequirementMapper opportunityRequirementMapper;
    @Resource
    private ITableTemplateService tableTemplateService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private TableTemplateMapper tableTemplateMapper;
    @Resource
    private IRequirementDetailService requirementDetailService;
    @Resource
    private ITableTemplateFieldService tableTemplateFieldService;
    @Resource
    private ITableFieldGroupService tableFieldGroupService;
    @Resource
    private IOpportunityRequirementService opportunityRequirementService;
    @Resource
    private IRequirementRecordService requirementRecordService;
    @Resource
    private RequirementRecordMapper requirementRecordMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IFileInfoAPIService fileInfoService;
    @Resource
    private ISysCodeRuleRefService sysCodeRuleRefService;
    @Resource
    private CustomerService customerService;

    @Override
    public ApiResponse<List<RequirementListVo>> requirementList(Long opportunityId) {
        List<RequirementListVo> list = this.opportunityRequirementMapper.requirementList(opportunityId);
        return ApiResponse.success(list);
    }

    @Override
    public ApiResponse<List<OpportunityProductReqListVo>> selectOpportunityProductReqList(Long opportunityId) {
        List opportunityProductList = this.opportunityProductService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityId)).eq(OpportunityProduct::getDelFlag, (Object)"0"));
        if (CollectionUtil.isEmpty((Collection)opportunityProductList)) {
            return ApiResponse.success(new ArrayList());
        }
        HashSet<Long> productIdSet = new HashSet<Long>();
        for (int i = opportunityProductList.size() - 1; i >= 0; --i) {
            if (!productIdSet.contains(((OpportunityProduct)opportunityProductList.get(i)).getProductId())) {
                productIdSet.add(((OpportunityProduct)opportunityProductList.get(i)).getProductId());
                continue;
            }
            opportunityProductList.remove(i);
        }
        List<String> productIdList = productIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        List existProductIds = this.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityRequirementEntity::getProductId}).eq(OpportunityRequirementEntity::getOpportunityId, (Object)opportunityId), String::valueOf);
        if (CollectionUtil.isNotEmpty((Collection)existProductIds)) {
            productIdList.removeAll(existProductIds);
            opportunityProductList.removeIf(opportunityProduct -> existProductIds.contains(String.valueOf(opportunityProduct.getProductId())));
            if (productIdList.isEmpty()) {
                return ApiResponse.success(new ArrayList());
            }
        }
        Map<Long, String> productNameMap = opportunityProductList.stream().collect(Collectors.toMap(OpportunityProduct::getProductId, OpportunityProduct::getProductName));
        List<TableTemplateEntity> tableTemplateEntityList = this.tableTemplateMapper.selectByProductIds(productIdList);
        ArrayList<OpportunityProductReqListVo> resultList = new ArrayList<OpportunityProductReqListVo>();
        for (TableTemplateEntity tableTemplateEntity : tableTemplateEntityList) {
            String productIds = tableTemplateEntity.getProductId();
            for (String productId : productIdList) {
                if (!productIds.contains(productId)) continue;
                resultList.add(new OpportunityProductReqListVo(tableTemplateEntity.getTemplateId(), tableTemplateEntity.getTemplateName(), Long.valueOf(productId), productNameMap.get(Long.valueOf(productId))));
            }
        }
        return ApiResponse.success(resultList);
    }

    @Override
    public ApiResponse<List<ReqFormQueryGroupVo>> selectReqTemplatAdd(ReqFormQueryDto dto) {
        Long templateId = dto.getTemplateId();
        List<ReqFormQueryGroupVo> resultList = this.getReqFormQueryGroupVos(templateId);
        return ApiResponse.success(resultList);
    }

    @NotNull
    private List<ReqFormQueryGroupVo> getReqFormQueryGroupVos(Long templateId) {
        List fieldEntityList = this.tableTemplateFieldService.list((Wrapper)new LambdaQueryWrapper().eq(TableTemplateFieldEntity::getTemplateId, (Object)templateId));
        List fieldGroupList = this.tableFieldGroupService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TableFieldGroupEntity::getTemplateId, (Object)templateId)).orderByAsc(TableFieldGroupEntity::getOrderNum));
        Map<Long, List> fieldMap = fieldEntityList.stream().collect(Collectors.groupingBy(TableTemplateFieldEntity::getFieldGroupId, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(TableTemplateFieldEntity::getOrderNum)).collect(Collectors.toList()))));
        ArrayList<ReqFormQueryGroupVo> resultList = new ArrayList<ReqFormQueryGroupVo>();
        for (TableFieldGroupEntity groupEntity : fieldGroupList) {
            ReqFormQueryGroupVo vo = new ReqFormQueryGroupVo();
            vo.setGroupName(groupEntity.getFieldGroupName());
            List fieldVos = BeanUtil.copyToList((Collection)fieldMap.get(groupEntity.getFieldGroupId()), ReqFormQueryFieldVo.class);
            vo.setFieldList(fieldVos);
            resultList.add(vo);
        }
        return resultList;
    }

    @Override
    public ApiResponse<List<ReqFormQueryGroupVo>> selectReqTemplatEdit(ReqFormQueryDto dto) {
        Long requirementId = dto.getRequirementId();
        Long templateId = dto.getTemplateId();
        List<ReqFormQueryGroupVo> resultList = this.getReqFormQueryGroupVos(templateId);
        List reqDetailList = this.requirementDetailService.list((Wrapper)new LambdaQueryWrapper().eq(RequirementDetailEntity::getRequirementId, (Object)requirementId));
        Map<Long, RequirementDetailEntity> fieldIdMap = reqDetailList.stream().collect(Collectors.toMap(RequirementDetailEntity::getFieldId, e -> e));
        for (ReqFormQueryGroupVo groupVo : resultList) {
            for (ReqFormQueryFieldVo fieldVo : groupVo.getFieldList()) {
                RequirementDetailEntity detail = fieldIdMap.get(fieldVo.getFieldId());
                if (detail == null) continue;
                fieldVo.setFieldValue(detail.getFieldValue());
                fieldVo.setDetailFieldId(detail.getDetailFieldId());
                if (HussarUtils.isNotEmpty((Object)fieldVo.getFieldValue()) && ("10".equals(fieldVo.getFieldType()) || "9".equals(fieldVo.getFieldType()))) {
                    String[] fileIds = fieldVo.getFieldValue().split(",");
                    List fileInfoList = this.fileInfoService.listNotDelByIds(Arrays.asList(fileIds));
                    List mapList = fileInfoList.stream().map(BeanUtil::beanToMap).collect(Collectors.toList());
                    for (Map objectMap : mapList) {
                        for (Map.Entry entry : objectMap.entrySet()) {
                            if (!(entry.getValue() instanceof Long)) continue;
                            objectMap.put(entry.getKey(), String.valueOf(entry.getValue()));
                        }
                    }
                    fieldVo.setFieldDetail(JsonUtil.toJson(mapList));
                } else {
                    fieldVo.setFieldDetail(detail.getValueDetail());
                }
                fieldVo.setExtendedCol1(detail.getExtendedCol1());
            }
        }
        return ApiResponse.success(resultList);
    }

    @Override
    public ApiResponse<Boolean> saveOrUpdateOpportunityReq(SaveOpportunityReqDto dto) {
        if (dto.getRequirementId() == null) {
            return ApiResponse.success((Object)this.saveOpportunityReq(dto));
        }
        return ApiResponse.success((Object)this.updateOpportunityReq(dto));
    }

    @Transactional
    private Boolean saveOpportunityReq(SaveOpportunityReqDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        LocalDateTime dateTimeNow = LocalDateTime.now();
        Long templateId = dto.getTemplateId();
        Long opportunityId = dto.getOpportunityId();
        List<ReqFieldDetailDto> fieldList = dto.getFieldList();
        List existList = dto.getProductId() == null ? this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityRequirementEntity::getOpportunityId, (Object)opportunityId)).eq(OpportunityRequirementEntity::getTemplateId, (Object)templateId)) : this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityRequirementEntity::getOpportunityId, (Object)opportunityId)).eq(OpportunityRequirementEntity::getTemplateId, (Object)templateId)).eq(OpportunityRequirementEntity::getProductId, (Object)dto.getProductId()));
        if (!existList.isEmpty()) {
            dto.setRequirementId(((OpportunityRequirementEntity)existList.get(0)).getRequirementId());
            return this.updateOpportunityReq(dto);
        }
        OpportunityRequirementEntity reqEntity = new OpportunityRequirementEntity();
        String operationType = dto.getProductId() != null ? "3" : "1";
        Long requirementId = Long.valueOf(CommonUtills.generateAssignId());
        reqEntity.setRequirementId(requirementId);
        reqEntity.setOpportunityId(opportunityId);
        reqEntity.setTemplateId(templateId);
        CodePlusDto codePlusDto1 = new CodePlusDto();
        codePlusDto1.setRuleCode("OPPORTUNITY_REQUIREMENT_CODE");
        String reqCode = this.sysCodeRuleRefService.getCurrentCodeByCache(codePlusDto1);
        reqEntity.setReqRecordCode(reqCode);
        reqEntity.setProductId(dto.getProductId());
        reqEntity.setProductName(dto.getProductName());
        int filledFieldCount = (int)fieldList.stream().filter(obj -> StringUtils.isNotBlank((String)obj.getFieldValue())).count();
        reqEntity.setFilledFieldCount(filledFieldCount);
        reqEntity.setCreator(userId);
        reqEntity.setCreatorName(userName);
        reqEntity.setCreateTime(dateTimeNow);
        reqEntity.setLastEditorId(userId);
        reqEntity.setLastEditorName(userName);
        reqEntity.setLastTime(dateTimeNow);
        List fieldEntityList = this.tableTemplateFieldService.list((Wrapper)new LambdaQueryWrapper().eq(TableTemplateFieldEntity::getTemplateId, (Object)templateId));
        List reqDetailList = BeanUtil.copyToList((Collection)fieldEntityList, RequirementDetailEntity.class);
        reqDetailList.forEach(e -> {
            e.setRequirementId(requirementId);
            e.setCreator(userId);
            e.setCreatorName(userName);
            e.setCreateTime(dateTimeNow);
            e.setLastEditorId(userId);
            e.setLastEditorName(userName);
            e.setLastTime(dateTimeNow);
        });
        block0: for (RequirementDetailEntity reqDetail : reqDetailList) {
            reqDetail.setDetailFieldId(Long.valueOf(CommonUtills.generateAssignId()));
            for (ReqFieldDetailDto fieldDetailDto : fieldList) {
                if (!fieldDetailDto.getFieldId().equals(reqDetail.getFieldId())) continue;
                if (StringUtils.isBlank((String)fieldDetailDto.getFieldValue())) {
                    reqDetail.setFieldValue(null);
                } else {
                    reqDetail.setFieldValue(fieldDetailDto.getFieldValue());
                }
                if (StringUtils.isBlank((String)fieldDetailDto.getFieldValue())) {
                    reqDetail.setValueDetail(null);
                } else {
                    reqDetail.setValueDetail(fieldDetailDto.getFieldDetail());
                }
                if (StringUtils.isBlank((String)fieldDetailDto.getExtendedCol1())) {
                    reqDetail.setExtendedCol1(null);
                } else {
                    reqDetail.setExtendedCol1(fieldDetailDto.getExtendedCol1());
                }
                fieldList.remove(fieldDetailDto);
                continue block0;
            }
        }
        this.save(reqEntity);
        this.requirementDetailService.saveBatch(reqDetailList);
        RequirementRecordEntity recordEntity = new RequirementRecordEntity();
        recordEntity.setOpportunityId(opportunityId);
        recordEntity.setRequirementCode(reqEntity.getReqRecordCode());
        recordEntity.setProductName(reqEntity.getProductName());
        recordEntity.setOperationType(operationType);
        recordEntity.setRequirementId(requirementId);
        recordEntity.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        recordEntity.setCreator(userId);
        recordEntity.setCreatorName(userName);
        recordEntity.setCreateTime(dateTimeNow);
        this.requirementRecordService.save(recordEntity);
        return true;
    }

    @Transactional
    private Boolean updateOpportunityReq(SaveOpportunityReqDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        LocalDateTime dateTimeNow = LocalDateTime.now();
        Long templateId = dto.getTemplateId();
        Long opportunityId = dto.getOpportunityId();
        Long requirementId = dto.getRequirementId();
        OpportunityRequirementEntity reqEntity = (OpportunityRequirementEntity)this.opportunityRequirementService.getById(requirementId);
        String operationType = reqEntity.getProductId() != null ? "4" : "2";
        List tableTemplateFieldEntityList = this.tableTemplateFieldService.list((Wrapper)new LambdaQueryWrapper().eq(TableTemplateFieldEntity::getTemplateId, (Object)dto.getTemplateId()));
        Map<Long, String> fieldIdLabelMap = tableTemplateFieldEntityList.stream().collect(Collectors.toMap(TableTemplateFieldEntity::getFieldId, TableTemplateFieldEntity::getLabelName));
        Map<Long, String> fieldTypeMap = tableTemplateFieldEntityList.stream().collect(Collectors.toMap(TableTemplateFieldEntity::getFieldId, TableTemplateFieldEntity::getFieldType));
        List reqDetailList = this.requirementDetailService.list((Wrapper)new LambdaQueryWrapper().eq(RequirementDetailEntity::getRequirementId, (Object)requirementId));
        List<ReqFieldDetailDto> fieldList = dto.getFieldList();
        HashMap<Long, String> fieldIdDictTypeMap = new HashMap<Long, String>();
        ArrayList<Long> fileFieldList = new ArrayList<Long>();
        HashSet fileIds = new HashSet();
        for (TableTemplateFieldEntity tableTemplateField : tableTemplateFieldEntityList) {
            if (OpportunityReqConstant.FIELD_TYPE_DICT.contains(tableTemplateField.getFieldType())) {
                fieldIdDictTypeMap.put(tableTemplateField.getFieldId(), tableTemplateField.getDictTypeName());
            }
            if (!OpportunityReqConstant.FIELD_TYPE_FILE.contains(tableTemplateField.getFieldType())) continue;
            fileFieldList.add(tableTemplateField.getFieldId());
            for (RequirementDetailEntity reqDetail : reqDetailList) {
                if (!reqDetail.getFieldId().equals(tableTemplateField.getFieldId()) || !StringUtils.isNotBlank((String)reqDetail.getFieldValue())) continue;
                fileIds.addAll(Arrays.stream(reqDetail.getFieldValue().split(",")).map(Long::parseLong).collect(Collectors.toSet()));
            }
        }
        fileIds.addAll(fieldList.stream().filter(reqFieldDetailDto -> fileFieldList.contains(reqFieldDetailDto.getFieldId())).map(ReqFieldDetailDto::getFieldValue).filter(StringUtils::isNotBlank).flatMap(s -> Arrays.stream(s.split(","))).map(Long::parseLong).collect(Collectors.toList()));
        List dictVoList = this.sysDicRefService.getDictVosByTypeNames(CollectionUtil.toList(fieldIdDictTypeMap.values()));
        Map<String, Map> dictMap = dictVoList.stream().collect(Collectors.toMap(DictVo::getTypeName, e -> e.getSingleList().stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel)), (oldValue, newValue) -> newValue));
        Map<Long, ReqFieldDetailDto> fieldDetailDtoMap = fieldList.stream().collect(Collectors.toMap(ReqFieldDetailDto::getFieldId, e -> e));
        Map<Long, RequirementDetailEntity> reqDetailMap = reqDetailList.stream().collect(Collectors.toMap(RequirementDetailEntity::getFieldId, e -> e));
        HashMap<String, String> before = new HashMap<String, String>();
        HashMap<String, String> after = new HashMap<String, String>();
        ArrayList changeField = new ArrayList();
        ArrayList contentList = new ArrayList();
        boolean changeFlag = false;
        int filledFieldCount = 0;
        Map<Object, Object> fileNameMap = new HashMap();
        if (CollectionUtil.isNotEmpty(fileIds)) {
            List fileInfoList = this.fileInfoService.listByIds(fileIds);
            fileNameMap = fileInfoList.stream().collect(Collectors.toMap(FileInfoAPIVo::getId, FileInfoAPIVo::getFileName));
        }
        ArrayList<RequirementDetailEntity> updateList = new ArrayList<RequirementDetailEntity>();
        for (ReqFieldDetailDto detailDto : fieldList) {
            boolean updateFlag = false;
            RequirementDetailEntity detail = reqDetailMap.get(detailDto.getFieldId());
            if (detailDto.getDetailFieldId() == null) {
                detailDto.setDetailFieldId(Long.valueOf(CommonUtills.generateAssignId()));
            }
            if (detail == null) {
                detail = new RequirementDetailEntity();
                detail.setDetailFieldId(detailDto.getDetailFieldId());
                detail.setRequirementId(requirementId);
                detail.setFieldId(detailDto.getFieldId());
                detail.setCreator(userId);
                detail.setCreatorName(userName);
                detail.setCreateTime(dateTimeNow);
                detail.setLastTime(dateTimeNow);
                detail.setLastEditorName(userName);
                detail.setLastEditorId(userId);
            }
            Long fieldId = detail.getFieldId();
            if (StringUtils.isBlank((String)detailDto.getFieldValue())) {
                detailDto.setFieldValue(null);
            }
            if (StringUtils.isBlank((String)detailDto.getFieldDetail())) {
                detailDto.setFieldDetail(null);
            }
            if (StringUtils.isNotBlank((String)detailDto.getFieldValue())) {
                ++filledFieldCount;
            }
            if (fileFieldList.contains(fieldId)) {
                HashMap<String, String> map2;
                String[] values;
                ArrayList fileBefore = new ArrayList();
                ArrayList fileAfter = new ArrayList();
                if (StringUtils.isNotBlank((String)detailDto.getFieldValue())) {
                    values = detailDto.getFieldValue().split(",");
                    fileAfter.addAll(Arrays.stream(values).map(Long::parseLong).collect(Collectors.toSet()));
                }
                if (StringUtils.isNotBlank((String)detail.getFieldValue())) {
                    values = detail.getFieldValue().split(",");
                    fileBefore.addAll(Arrays.stream(values).map(Long::parseLong).collect(Collectors.toSet()));
                }
                List newFile = fileAfter.stream().filter(element -> !fileBefore.contains(element)).collect(Collectors.toList());
                List delFile = fileBefore.stream().filter(element -> !fileAfter.contains(element)).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(newFile)) {
                    map2 = new HashMap<String, String>();
                    map2.put("label", "\u65b0\u589e" + fieldIdLabelMap.get(fieldId));
                    map2.put("value", newFile.stream().map(fileNameMap::get).collect(Collectors.joining("\u3001")));
                    contentList.add(map2);
                    changeFlag = true;
                    updateFlag = true;
                }
                if (CollectionUtil.isNotEmpty((Collection)delFile)) {
                    map2 = new HashMap();
                    map2.put("label", "\u5220\u9664" + fieldIdLabelMap.get(fieldId));
                    map2.put("value", delFile.stream().map(fileNameMap::get).collect(Collectors.joining("\u3001")));
                    contentList.add(map2);
                    changeFlag = true;
                    updateFlag = true;
                }
                detail.setFieldValue(detailDto.getFieldValue());
            } else {
                HashMap<String, Object> field;
                if (!Objects.equals(detail.getFieldValue(), detailDto.getFieldValue())) {
                    if (fieldIdDictTypeMap.containsKey(fieldId)) {
                        ArrayList valueNames;
                        String[] values;
                        Map dicSingleMap;
                        if (StringUtils.isNotBlank((String)detailDto.getFieldValue())) {
                            dicSingleMap = dictMap.get(fieldIdDictTypeMap.get(fieldId));
                            values = detailDto.getFieldValue().split(",");
                            valueNames = new ArrayList();
                            for (String value : values) {
                                valueNames.add(dicSingleMap.get(value));
                            }
                            after.put(String.valueOf(fieldId), String.join((CharSequence)"\u3001", valueNames));
                        }
                        if (StringUtils.isNotBlank((String)detail.getFieldValue())) {
                            dicSingleMap = dictMap.get(fieldIdDictTypeMap.get(fieldId));
                            values = detail.getFieldValue().split(",");
                            valueNames = new ArrayList();
                            for (String value : values) {
                                valueNames.add(dicSingleMap.get(value));
                            }
                            before.put(String.valueOf(fieldId), String.join((CharSequence)"\u3001", valueNames));
                        }
                    } else {
                        before.put(String.valueOf(fieldId), detail.getFieldValue());
                        after.put(String.valueOf(fieldId), detailDto.getFieldValue());
                    }
                    field = new HashMap<String, Object>();
                    field.put("field", fieldId);
                    field.put("fieldName", fieldIdLabelMap.get(fieldId));
                    changeField.add(field);
                    detail.setFieldValue(detailDto.getFieldValue());
                    changeFlag = true;
                    updateFlag = true;
                }
                if ("12".equals(fieldTypeMap.get(detail.getFieldId())) && !Objects.equals(detail.getExtendedCol1(), detailDto.getExtendedCol1())) {
                    String caseNames;
                    List mapList;
                    Gson gson = new Gson();
                    Type type = new TypeToken<List<Map<String, Object>>>(){}.getType();
                    if (StringUtils.isNotBlank((String)detail.getExtendedCol1())) {
                        mapList = (List)gson.fromJson(detail.getExtendedCol1(), type);
                        caseNames = mapList.stream().map(map -> map.get("label").toString()).collect(Collectors.joining("\u3001"));
                        before.put(fieldId + "choose", caseNames);
                    }
                    if (StringUtils.isNotBlank((String)detailDto.getExtendedCol1())) {
                        mapList = (List)gson.fromJson(detailDto.getExtendedCol1(), type);
                        caseNames = mapList.stream().map(map -> map.get("label").toString()).collect(Collectors.joining("\u3001"));
                        after.put(fieldId + "choose", caseNames);
                    }
                    HashMap<String, String> field2 = new HashMap<String, String>();
                    field2.put("field", fieldId + "choose");
                    field2.put("fieldName", "\u9009\u62e9" + fieldIdLabelMap.get(fieldId));
                    changeField.add(field2);
                    detail.setExtendedCol1(detailDto.getExtendedCol1());
                    changeFlag = true;
                    updateFlag = true;
                }
                if (!Objects.equals(detail.getValueDetail(), detailDto.getFieldDetail()) && "1".equals(detail.getFieldValue())) {
                    field = new HashMap();
                    field.put("field", fieldId + "*");
                    field.put("fieldName", fieldIdLabelMap.get(fieldId) + "\u7b80\u8ff0");
                    changeField.add(field);
                    before.put(fieldId + "*", detail.getValueDetail());
                    after.put(fieldId + "*", detailDto.getFieldDetail());
                    detail.setValueDetail(detailDto.getFieldDetail());
                    changeFlag = true;
                    updateFlag = true;
                }
            }
            if (!updateFlag) continue;
            updateList.add(detail);
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(OpportunityRequirementEntity::getRequirementId, (Object)requirementId)).set(OpportunityRequirementEntity::getFilledFieldCount, (Object)filledFieldCount)).set(OpportunityRequirementEntity::getLastTime, (Object)dateTimeNow)).set(OpportunityRequirementEntity::getLastEditorId, (Object)userId)).set(OpportunityRequirementEntity::getLastEditorName, (Object)userName));
        updateList.forEach(requirementDetailEntity -> {
            requirementDetailEntity.setLastTime(dateTimeNow);
            requirementDetailEntity.setLastEditorName(userName);
            requirementDetailEntity.setLastEditorId(userId);
        });
        this.requirementDetailService.saveOrUpdateBatch(updateList);
        if (changeFlag) {
            String changeFieldStr = JSON.toJSONString(changeField);
            String oldJson = JSON.toJSONString(before);
            String newJson = JSON.toJSONString(after);
            RequirementRecordEntity recordEntity = new RequirementRecordEntity();
            recordEntity.setOpportunityId(opportunityId);
            recordEntity.setRequirementCode(reqEntity.getReqRecordCode());
            recordEntity.setProductName(reqEntity.getProductName());
            recordEntity.setOperationType(operationType);
            recordEntity.setChangeBefore(oldJson);
            recordEntity.setChangeAfter(newJson);
            recordEntity.setChangeField(changeFieldStr);
            recordEntity.setRequirementId(requirementId);
            recordEntity.setAdditionalContent(JSON.toJSONString(contentList));
            recordEntity.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            recordEntity.setCreator(userId);
            recordEntity.setCreatorName(userName);
            recordEntity.setCreateTime(dateTimeNow);
            this.requirementRecordService.save(recordEntity);
        }
        return true;
    }

    @Override
    public ApiResponse<CanAddReqVo> canAddReq(Long opportunityId) {
        boolean canAddComReq = true;
        boolean canAddProductReq = false;
        List reqEntityList = this.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityRequirementEntity::getOpportunityId, (Object)opportunityId));
        List opportunityProductList = this.opportunityProductService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityId)).eq(OpportunityProduct::getDelFlag, (Object)"0"));
        List productIdList = opportunityProductList.stream().map(OpportunityProduct::getProductId).collect(Collectors.toList());
        if (!reqEntityList.isEmpty()) {
            for (OpportunityRequirementEntity entity : reqEntityList) {
                if (entity.getProductId() != null) continue;
                canAddComReq = false;
            }
            Set existProductSet = reqEntityList.stream().map(OpportunityRequirementEntity::getProductId).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!existProductSet.isEmpty()) {
                productIdList.removeAll(existProductSet);
            }
        }
        if (!productIdList.isEmpty()) {
            List allReqProductIdList = this.tableTemplateService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{TableTemplateEntity::getProductId}).isNotNull(TableTemplateEntity::getProductId), s -> (String)s);
            List productIds = allReqProductIdList.stream().flatMap(str -> Arrays.stream(str.split(","))).map(String::trim).filter(s -> !s.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
            for (Long productId : productIdList) {
                if (!productIds.contains(productId)) continue;
                canAddProductReq = true;
                break;
            }
        }
        CanAddReqVo canAddReqVo = new CanAddReqVo(canAddComReq, canAddProductReq);
        return ApiResponse.success((Object)canAddReqVo);
    }

    @Override
    public ApiResponse<Page<RequirementRecordEntity>> selectReqRecord(ReqRecordDto dto) {
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        Page list = (Page)this.requirementRecordMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RequirementRecordEntity::getOpportunityId, (Object)dto.getOpportunityId())).orderByDesc(RequirementRecordEntity::getCreateTime));
        return ApiResponse.success((Object)list);
    }

    @Override
    public String export(HttpServletResponse response, OpportunityRequirementDto dto) {
        Long opportunityId = dto.getOpportunityId();
        List reqList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityRequirementEntity::getOpportunityId, (Object)opportunityId)).orderByAsc(OpportunityRequirementEntity::getProductId)).orderByAsc(OpportunityRequirementEntity::getCreateTime));
        if (CollectionUtil.isEmpty((Collection)reqList)) {
            return null;
        }
        List fieldGroupList = this.tableFieldGroupService.list((Wrapper)new LambdaQueryWrapper().in(TableFieldGroupEntity::getTemplateId, (Collection)reqList.stream().map(OpportunityRequirementEntity::getTemplateId).collect(Collectors.toList())));
        Map<Long, String> fieldGroupIdNameMap = fieldGroupList.stream().collect(Collectors.toMap(TableFieldGroupEntity::getFieldGroupId, TableFieldGroupEntity::getFieldGroupName));
        Map<Long, String> reqProductNameMap = reqList.stream().filter(e -> StringUtils.isNotBlank((String)e.getProductName())).collect(Collectors.toMap(OpportunityRequirementEntity::getRequirementId, OpportunityRequirementEntity::getProductName));
        List<Long> reqIdList = reqList.stream().map(OpportunityRequirementEntity::getRequirementId).collect(Collectors.toList());
        List<ExportReqVo> voList = this.opportunityRequirementMapper.selectFieldExportList(reqIdList);
        ArrayList<ExportFileVo> filePathList = new ArrayList();
        ArrayList<Long> fileIds = new ArrayList<Long>();
        for (ExportReqVo exportReqVo2 : voList) {
            if ("9".equals(exportReqVo2.getFieldType()) && StringUtils.isNotBlank((String)exportReqVo2.getFieldValue())) {
                fileIds.addAll(Arrays.stream(exportReqVo2.getFieldValue().split(",")).map(Long::parseLong).collect(Collectors.toList()));
                continue;
            }
            if (!"10".equals(exportReqVo2.getFieldType()) || !StringUtils.isNotBlank((String)exportReqVo2.getFieldValue())) continue;
            fileIds.add(Long.parseLong(exportReqVo2.getFieldValue()));
        }
        Map<Object, Object> fileIdNameMap = new HashMap();
        if (CollectionUtil.isNotEmpty(fileIds)) {
            List fileInfoList = this.fileInfoService.listNotDelByIds(fileIds);
            filePathList = fileInfoList.stream().map(fileInfo -> new ExportFileVo(fileInfo.getFileName(), fileInfo.getFilePath())).collect(Collectors.toList());
            fileIdNameMap = fileInfoList.stream().collect(Collectors.toMap(FileInfoAPIVo::getId, FileInfoAPIVo::getFileName));
        }
        List dictTypeNames = voList.stream().map(ExportReqVo::getDictTypeName).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List dictVoList = this.sysDicRefService.getDictVosByTypeNames(dictTypeNames);
        Map<String, Map> dictMap = dictVoList.stream().collect(Collectors.toMap(DictVo::getTypeName, e -> e.getSingleList().stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel)), (oldValue, newValue) -> newValue));
        for (ExportReqVo exportReqVo3 : voList) {
            if (OpportunityReqConstant.FIELD_TYPE_DICT.contains(exportReqVo3.getFieldType()) && StringUtils.isNotBlank((String)exportReqVo3.getFieldValue())) {
                Map dicSingleMap = dictMap.get(exportReqVo3.getDictTypeName());
                String[] values = exportReqVo3.getFieldValue().split(",");
                ArrayList valueNames = new ArrayList();
                for (String value : values) {
                    valueNames.add(dicSingleMap.get(value));
                }
                exportReqVo3.setFieldValue(String.join((CharSequence)"\u3001", valueNames));
            } else if ("10".equals(exportReqVo3.getFieldType()) && HussarUtils.isNotEmpty((Object)exportReqVo3.getFieldValue())) {
                exportReqVo3.setFieldValue((String)fileIdNameMap.get(Long.parseLong(exportReqVo3.getFieldValue())));
            } else if ("9".equals(exportReqVo3.getFieldType()) && HussarUtils.isNotEmpty((Object)exportReqVo3.getFieldValue())) {
                List ids = Arrays.stream(exportReqVo3.getFieldValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
                ArrayList<Object> names = new ArrayList<Object>();
                for (Long id : ids) {
                    names.add(fileIdNameMap.get(id));
                }
                exportReqVo3.setFieldValue(StringUtils.join(names, (String)","));
            }
            if (!"12".equals(exportReqVo3.getFieldType()) || !HussarUtils.isNotEmpty((Object)exportReqVo3.getExtendedCol1())) continue;
            Gson gson = new Gson();
            Type type = new TypeToken<List<Map<String, Object>>>(){}.getType();
            List mapList = (List)gson.fromJson(exportReqVo3.getExtendedCol1(), type);
            String caseNames = mapList.stream().map(map -> map.get("label").toString()).collect(Collectors.joining("\u3001"));
            exportReqVo3.setExtendedCol1(caseNames);
        }
        Map<Long, List<ExportReqVo>> reqIdVoListMap = voList.stream().collect(Collectors.groupingBy(ExportReqVo::getRequirementId));
        ArrayList<ExportSheetVo> sheetVoList = new ArrayList<ExportSheetVo>();
        for (OpportunityRequirementEntity req : reqList) {
            String sheetName;
            List<ExportReqVo> exportReqVoList = reqIdVoListMap.get(req.getRequirementId());
            ExportSheetVo sheetVo = new ExportSheetVo();
            Long requirementId = req.getRequirementId();
            String productName = reqProductNameMap.get(requirementId);
            ArrayList<ExportGroupVo> groupVoList = new ArrayList<ExportGroupVo>();
            if (StringUtils.isBlank((String)productName)) {
                sheetName = "\u901a\u7528\u9700\u6c42";
                ExportGroupVo exportGroupVo = new ExportGroupVo();
                exportGroupVo.setGroupName("\u57fa\u7840\u4fe1\u606f");
                ArrayList<ExportFieldVo> fieldVos = new ArrayList<ExportFieldVo>();
                OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById(opportunityId);
                CustomerEntityVo customerEntityVo = this.customerService.customerDetails(opportunity.getCustomerId());
                if (customerEntityVo != null) {
                    fieldVos.add(new ExportFieldVo("\u5ba2\u6237\u540d\u79f0", customerEntityVo.getCustomerName()));
                    fieldVos.add(new ExportFieldVo("\u4f01\u4e1a\u6027\u8d28", customerEntityVo.getCustomerAttribute()));
                    fieldVos.add(new ExportFieldVo("\u6240\u5c5e\u884c\u4e1a", customerEntityVo.getTrade()));
                    fieldVos.add(new ExportFieldVo("\u5ba2\u6237\u5730\u5740", customerEntityVo.getAddressDetail()));
                    fieldVos.add(new ExportFieldVo("\u5546\u673a\u91d1\u989d", opportunity.getOpportunityAmount() + "\u5143"));
                    exportGroupVo.setReqVoList(fieldVos);
                }
                groupVoList.add(exportGroupVo);
            } else {
                sheetName = "\u4ea7\u54c1\u9700\u6c42\uff08" + productName + "\uff09";
            }
            sheetVo.setSheetName(sheetName);
            Map<Long, List<ExportReqVo>> reqVoMap = exportReqVoList.stream().filter(exportReqVo -> exportReqVo.getGroupId() != null).collect(Collectors.groupingBy(ExportReqVo::getGroupId));
            for (Map.Entry<Long, List<ExportReqVo>> entry1 : reqVoMap.entrySet()) {
                ExportGroupVo groupVo = new ExportGroupVo();
                boolean tyflag = false;
                if (CollectionUtil.isNotEmpty(groupVoList) && Objects.equals(((ExportGroupVo)groupVoList.get(groupVoList.size() - 1)).getGroupName(), fieldGroupIdNameMap.get(entry1.getKey()))) {
                    groupVo = (ExportGroupVo)groupVoList.get(groupVoList.size() - 1);
                    tyflag = true;
                }
                groupVo.setGroupName(fieldGroupIdNameMap.get(entry1.getKey()));
                ArrayList<ExportFieldVo> list = new ArrayList<ExportFieldVo>();
                for (ExportReqVo exportReqVo4 : entry1.getValue()) {
                    list.add(new ExportFieldVo(exportReqVo4.getFieldName(), exportReqVo4.getFieldValue()));
                    if ("8".equals(exportReqVo4.getFieldType())) {
                        list.add(new ExportFieldVo(exportReqVo4.getFieldName() + "\u7b80\u8ff0", exportReqVo4.getFieldDetail()));
                    }
                    if (!"12".equals(exportReqVo4.getFieldType())) continue;
                    list.add(new ExportFieldVo("\u9009\u62e9" + exportReqVo4.getFieldName(), exportReqVo4.getExtendedCol1()));
                    list.add(new ExportFieldVo(exportReqVo4.getFieldName() + "\u7b80\u8ff0", exportReqVo4.getFieldDetail()));
                }
                if (tyflag) {
                    groupVo.getReqVoList().addAll(list);
                    continue;
                }
                groupVo.setReqVoList(list);
                groupVoList.add(groupVo);
            }
            sheetVo.setGroupVoList(groupVoList);
            sheetVoList.add(sheetVo);
        }
        try {
            this.generateExcelAndZipToResponse(sheetVoList, filePathList, response, "\u5546\u673a\u9700\u6c42\u53ca\u9644\u4ef6");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new HussarException("\u5bfc\u51fa\u5931\u8d25");
        }
        return "\u5bfc\u51fa\u6210\u529f";
    }

    public byte[] generateExcel(List<ExportSheetVo> sheetDataList) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Map<String, CellStyle> styles = this.createStyles((Workbook)workbook);
            for (ExportSheetVo sheetData : sheetDataList) {
                Sheet sheet = workbook.createSheet(sheetData.getSheetName());
                int currentRow = 0;
                for (ExportGroupVo group : sheetData.getGroupVoList()) {
                    Row groupHeaderRow = sheet.createRow(currentRow++);
                    Cell groupHeaderCell = groupHeaderRow.createCell(0);
                    Cell groupHeaderCell2 = groupHeaderRow.createCell(1);
                    groupHeaderCell.setCellValue(group.getGroupName());
                    CellRangeAddress cellAddresses = new CellRangeAddress(currentRow - 1, currentRow - 1, 0, 1);
                    sheet.addMergedRegion(cellAddresses);
                    groupHeaderCell.setCellStyle(styles.get("groupHeader"));
                    groupHeaderCell2.setCellStyle(styles.get("groupHeader"));
                    for (ExportFieldVo requirement : group.getReqVoList()) {
                        Row dataRow = sheet.createRow(currentRow++);
                        Cell fieldNameCell = dataRow.createCell(0);
                        fieldNameCell.setCellValue(requirement.getFieldName());
                        fieldNameCell.setCellStyle(styles.get("fieldName"));
                        Cell fieldValueCell = dataRow.createCell(1);
                        fieldValueCell.setCellValue(requirement.getFieldValue());
                        fieldValueCell.setCellStyle(styles.get("fieldValue"));
                    }
                }
                sheet.setColumnWidth(0, 12800);
                sheet.setColumnWidth(1, 25600);
            }
            workbook.write((OutputStream)outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toByteArray();
    }

    public void generateExcelAndZipToResponse(List<ExportSheetVo> sheetDataList, List<ExportFileVo> otherFilePaths, HttpServletResponse response, String zipFileName) throws IOException {
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=" + zipFileName);
        response.setCharacterEncoding("UTF-8");
        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
            HashSet<String> addFileName = new HashSet<String>();
            addFileName.add("\u5546\u673a\u9700\u6c42.xlsx");
            byte[] excelData = this.generateExcel(sheetDataList);
            this.addFileToZip(zipOut, excelData, "\u5546\u673a\u9700\u6c42.xlsx");
            for (ExportFileVo exportFieldVo : otherFilePaths) {
                this.addExternalFileToZip(zipOut, exportFieldVo, addFileName);
            }
            zipOut.finish();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new IOException("\u751f\u6210ZIP\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    private Map<String, CellStyle> createStyles(Workbook workbook) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        XSSFCellStyle groupHeaderStyle = (XSSFCellStyle)workbook.createCellStyle();
        groupHeaderStyle.setFillForegroundColor(new XSSFColor(new Color(234, 240, 251)));
        groupHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        groupHeaderStyle.setAlignment(HorizontalAlignment.LEFT);
        groupHeaderStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        groupHeaderStyle.setBorderBottom(BorderStyle.THIN);
        groupHeaderStyle.setBorderTop(BorderStyle.THIN);
        groupHeaderStyle.setBorderLeft(BorderStyle.THIN);
        groupHeaderStyle.setBorderRight(BorderStyle.THIN);
        Font groupHeaderFont = workbook.createFont();
        groupHeaderFont.setBold(true);
        groupHeaderFont.setFontHeightInPoints((short)12);
        groupHeaderStyle.setFont(groupHeaderFont);
        styles.put("groupHeader", (CellStyle)groupHeaderStyle);
        XSSFCellStyle fieldNameStyle = (XSSFCellStyle)workbook.createCellStyle();
        fieldNameStyle.setAlignment(HorizontalAlignment.LEFT);
        fieldNameStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        fieldNameStyle.setBorderBottom(BorderStyle.THIN);
        fieldNameStyle.setBorderTop(BorderStyle.THIN);
        fieldNameStyle.setBorderLeft(BorderStyle.THIN);
        fieldNameStyle.setBorderRight(BorderStyle.THIN);
        Font fieldNameFont = workbook.createFont();
        fieldNameStyle.setFont(fieldNameFont);
        styles.put("fieldName", (CellStyle)fieldNameStyle);
        XSSFCellStyle fieldValueStyle = (XSSFCellStyle)workbook.createCellStyle();
        fieldValueStyle.setAlignment(HorizontalAlignment.LEFT);
        fieldValueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        fieldValueStyle.setBorderBottom(BorderStyle.THIN);
        fieldValueStyle.setBorderTop(BorderStyle.THIN);
        fieldValueStyle.setBorderLeft(BorderStyle.THIN);
        fieldValueStyle.setBorderRight(BorderStyle.THIN);
        fieldValueStyle.setWrapText(true);
        styles.put("fieldValue", (CellStyle)fieldValueStyle);
        return styles;
    }

    private void addFileToZip(ZipOutputStream zipOut, byte[] fileData, String fileName) throws IOException {
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        zipOut.write(fileData);
        zipOut.closeEntry();
    }

    private void addExternalFileToZip(ZipOutputStream zipOut, ExportFileVo fileVo, Set<String> addFileName) throws IOException {
        int lastDotIndex;
        File file = new File(fileVo.getFilePath());
        if (!file.exists() || !file.isFile()) {
            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u6587\u4ef6: " + fileVo.getFilePath());
        }
        String fileName = fileVo.getFileName();
        if (addFileName.contains(fileName) && (lastDotIndex = fileName.lastIndexOf(46)) != -1) {
            fileName = fileName.substring(0, lastDotIndex) + "_" + fileName.substring(lastDotIndex);
        }
        addFileName.add(fileName);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            int length;
            int bufferSize = file.length() > 0xA00000L ? 8192 : (file.length() > 0x100000L ? 4096 : 1024);
            byte[] buffer = new byte[bufferSize];
            while ((length = bis.read(buffer)) > 0) {
                zipOut.write(buffer, 0, length);
            }
        }
        zipOut.closeEntry();
    }
}

