/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.message.service.IMessagePushService;
import com.jxdinfo.crm.common.api.message.service.IMessageTemplateService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.sysCalendar.dto.DayTypeDto;
import com.jxdinfo.crm.common.api.sysCalendar.dto.RecycleReasonDate;
import com.jxdinfo.crm.common.api.sysCalendar.service.ISysCalendarBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolEditConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dao.OpportunityPoolRuleMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.OpportunityPool;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.OpportunityPoolMember;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.RulePoolTrans;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.RuleRecycle;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.ScheduledMsgTemp;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.WhiteListMember;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IOpportunityPoolMemberService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IScheduledMsgTempService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.OpportunityPoolService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OppoRecycleMessageVo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OppoRuleVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OpportunityPoolMemberVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.ReRecycleVo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.RuleRecycleVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.model.OpportunityPoolOppo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.service.OpportunityPoolOppoService;
import com.jxdinfo.crm.core.job.model.OpportunityRecycleReason;
import com.jxdinfo.crm.core.job.service.OpportunityRecycleService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.task.model.TaskEntity;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpportunityRecycleServiceImpl
implements OpportunityRecycleService {
    @Resource
    private ICrmBaseConfigBoService baseConfigBoService;
    @Resource
    private OpportunityPoolRuleMapper opportunityPoolRuleMapper;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ISysCalendarBoService calendarBoService;
    @Resource
    private OpportunityPoolOppoService opportunityPoolOppoService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private IMessagePushService messagePushService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private TaskService taskService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IMessageTemplateService messageTemplateService;
    @Resource
    private IScheduledMsgTempService scheduledMsgTempService;
    @Resource
    private OpportunityPoolService opportunityPoolService;
    @Resource
    private IOpportunityPoolMemberService opportunityPoolMemberService;

    @Override
    @Transactional
    public ProcessResult opportunityRecycle() {
        int i;
        LocalDate dateNow = LocalDate.now();
        LocalDateTime dateTimeNow = LocalDateTime.now();
        HashMap<Long, RuleRecycleVO> ruleVoMap = new HashMap<Long, RuleRecycleVO>();
        HashMap opportunityRecycleReasonMap = new HashMap();
        CrmBaseConfigVo configVo = this.baseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OLD_POOL_FIRST);
        boolean oldPoolFirst = "1".equals(configVo.getConfigValue());
        List<OppoRuleVO> ruleList = this.opportunityPoolRuleMapper.selectAllRecyclePoolRule();
        Map<Object, Object> poolIdRuleMap = new HashMap();
        poolIdRuleMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, oppoRuleVO -> oppoRuleVO));
        ruleList.forEach(oppoRuleVO -> oppoRuleVO.setRuleRecycle((RuleRecycle)JSON.parseObject((String)oppoRuleVO.getPublicPoolRuleRecycle(), RuleRecycle.class)));
        ruleList.removeIf(oppoRuleVO -> oppoRuleVO.getRuleRecycle().getCondition().isEmpty());
        HashMap<Long, Object> poolIdOpportunityListMap = new HashMap<Long, Object>();
        List noTrackDtoList = ruleList.stream().map(oppoRuleVO -> {
            DayTypeDto dto = new DayTypeDto();
            if (oppoRuleVO.getRuleRecycle().getNoTrackDay() != null) {
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoTrackDay())));
            }
            dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
            if (oppoRuleVO.getRuleRecycle().getCondition() == null || !oppoRuleVO.getRuleRecycle().getCondition().contains(OpportunityPoolConstant.AUTO_RECYCLE_RULE_1)) {
                dto.setSwitchFlag("-1");
            } else {
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
            }
            return dto;
        }).collect(Collectors.toList());
        List noTrackDateList = this.calendarBoService.getStartDate(noTrackDtoList, dateNow);
        List noWinDtoList = ruleList.stream().map(oppoRuleVO -> {
            DayTypeDto dto = new DayTypeDto();
            if (oppoRuleVO.getRuleRecycle().getNoWinDay() != null) {
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoWinDay())));
            }
            dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
            if (oppoRuleVO.getRuleRecycle().getCondition() == null || !oppoRuleVO.getRuleRecycle().getCondition().contains(OpportunityPoolConstant.AUTO_RECYCLE_RULE_2)) {
                dto.setSwitchFlag("-1");
            } else {
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
            }
            return dto;
        }).collect(Collectors.toList());
        List noWinDateList = this.calendarBoService.getStartDate(noWinDtoList, dateNow);
        Map<String, List<OpportunityStage>> stageNameMap = this.opportunityStageService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityStage::getDelFlag, (Object)"0")).stream().collect(Collectors.groupingBy(OpportunityStage::getStageNameValue));
        ArrayList<Long> exceptOpportunityIds = new ArrayList<Long>();
        for (i = 0; i < ruleList.size(); ++i) {
            RuleRecycle ruleRecycle = ruleList.get(i).getRuleRecycle();
            LambdaQueryWrapper<OpportunityEntity> lambdaQueryWrapper = this.getOpportunityEntityLambdaQueryWrapper(ruleList, i, stageNameMap);
            if (lambdaQueryWrapper == null || !"1".equals(ruleList.get(i).getPublicPoolRuleRecycleSwitch()) || ruleRecycle.getCondition() == null) continue;
            ReRecycleVo reRecycleVo = new ReRecycleVo();
            reRecycleVo.setDateType(ruleRecycle.getTime());
            reRecycleVo.setPoolId(ruleList.get(i).getOppoPoolId());
            reRecycleVo.setPoolName(ruleList.get(i).getOppoPoolName());
            boolean addFlag = false;
            if (ruleRecycle.getCondition().contains(OpportunityPoolConstant.AUTO_RE_RECYCLE_RULE_1)) {
                reRecycleVo.setReRuleParam1(ruleList.get(i).getRuleRecycle().getReRuleParam1());
                addFlag = true;
            }
            if (ruleRecycle.getCondition().contains(OpportunityPoolConstant.AUTO_RE_RECYCLE_RULE_2)) {
                reRecycleVo.setReRuleParam2(ruleList.get(i).getRuleRecycle().getReRuleParam2());
                reRecycleVo.setReRuleParam3(ruleList.get(i).getRuleRecycle().getReRuleParam3());
                addFlag = true;
            }
            if (!addFlag) continue;
            try {
                exceptOpportunityIds.addAll(this.reRecycle(reRecycleVo, lambdaQueryWrapper));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        for (i = 0; i < ruleList.size(); ++i) {
            LambdaQueryWrapper<OpportunityEntity> queryWrapper = this.getOpportunityEntityLambdaQueryWrapper(ruleList, i, stageNameMap);
            if (queryWrapper == null) continue;
            if (CollectionUtil.isNotEmpty(exceptOpportunityIds)) {
                queryWrapper.notIn(OpportunityEntity::getOpportunityId, exceptOpportunityIds);
            }
            List list = this.opportunityService.list((Wrapper)queryWrapper);
            List oppoReason = list.stream().map(opportunityEntity -> {
                OpportunityRecycleReason opportunityRecycleReason = new OpportunityRecycleReason();
                opportunityRecycleReason.setOpportunityId(opportunityEntity.getOpportunityId());
                opportunityRecycleReason.setResourcePoolId(opportunityEntity.getResourcePoolId());
                if (HussarUtils.isNotEmpty((Object)opportunityEntity.getClaimTime())) {
                    opportunityRecycleReason.setNoWinDate(opportunityEntity.getClaimTime());
                } else if (HussarUtils.isNotEmpty((Object)opportunityEntity.getAllocateTime())) {
                    opportunityRecycleReason.setNoWinDate(opportunityEntity.getAllocateTime());
                } else {
                    opportunityRecycleReason.setNoWinDate(opportunityEntity.getCreateTime());
                }
                if (HussarUtils.isNotEmpty((Object)opportunityEntity.getTrackTime())) {
                    if (opportunityEntity.getTrackTime().isAfter(opportunityRecycleReason.getNoWinDate())) {
                        opportunityRecycleReason.setNoTrackDate(opportunityEntity.getTrackTime());
                    } else {
                        opportunityRecycleReason.setNoTrackDate(opportunityRecycleReason.getNoWinDate());
                    }
                } else {
                    opportunityRecycleReason.setNoTrackDate(opportunityRecycleReason.getNoWinDate());
                }
                opportunityRecycleReasonMap.put(opportunityEntity.getOpportunityId(), opportunityRecycleReason);
                return opportunityRecycleReason;
            }).collect(Collectors.toList());
            poolIdOpportunityListMap.put(ruleList.get(i).getOppoPoolId(), oppoReason);
            RuleRecycleVO ruleRecycleVO2 = new RuleRecycleVO();
            ruleRecycleVO2.setOppoPoolId(ruleList.get(i).getOppoPoolId());
            ruleRecycleVO2.setNoWinDate((LocalDate)noWinDateList.get(i));
            ruleRecycleVO2.setNoTrackDate((LocalDate)noTrackDateList.get(i));
            ruleRecycleVO2.setOppoPoolOrder(ruleList.get(i).getOppoPoolOrder());
            if (HussarUtils.isNotEmpty((Object)((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoTrackDay())) {
                ruleRecycleVO2.setNoTrackNum(Integer.valueOf(((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoTrackDay()));
            }
            if (HussarUtils.isNotEmpty((Object)((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoWinDay())) {
                ruleRecycleVO2.setNoWinNum(Integer.valueOf(((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoWinDay()));
            }
            ruleVoMap.put(ruleRecycleVO2.getOppoPoolId(), ruleRecycleVO2);
        }
        HashMap oppoIdAndPoolRuleMap = new HashMap();
        for (Map.Entry entry : poolIdOpportunityListMap.entrySet()) {
            for (OpportunityRecycleReason oppo : (List)entry.getValue()) {
                if (HussarUtils.isEmpty(oppoIdAndPoolRuleMap.get(oppo.getOpportunityId()))) {
                    ArrayList poolRule = new ArrayList();
                    poolRule.add(ruleVoMap.get(entry.getKey()));
                    oppoIdAndPoolRuleMap.put(oppo.getOpportunityId(), poolRule);
                    continue;
                }
                ((List)oppoIdAndPoolRuleMap.get(oppo.getOpportunityId())).add(ruleVoMap.get(entry.getKey()));
            }
        }
        ArrayList opportunityIdList = new ArrayList(oppoIdAndPoolRuleMap.keySet());
        if (opportunityIdList.isEmpty()) {
            return new ProcessResult(true);
        }
        Map<Long, OpportunityEntity> map = this.opportunityService.list((Wrapper)new LambdaQueryWrapper().in(OpportunityEntity::getOpportunityId, opportunityIdList)).stream().collect(Collectors.toMap(OpportunityEntity::getOpportunityId, opportunityEntity -> opportunityEntity));
        ArrayList<Long> delOpportunityIdList = new ArrayList<Long>();
        ArrayList<OpportunityPoolOppo> addPoolOppoList = new ArrayList<OpportunityPoolOppo>();
        HashMap dateNoWinMap = new HashMap();
        Map<Long, OppoRuleVO> poolIdRuleVOMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, oppoRuleVO -> oppoRuleVO));
        ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
        HashMap<String, OppoRecycleMessageVo> oppoRecycleMessageVoMap = new HashMap<String, OppoRecycleMessageVo>();
        for (Map.Entry listEntry : oppoIdAndPoolRuleMap.entrySet()) {
            OpportunityPoolOppo oppo;
            boolean oldPoolExist;
            List recycleVOList = (List)listEntry.getValue();
            recycleVOList.sort(Comparator.comparing(RuleRecycleVO::getOppoPoolOrder));
            OpportunityRecycleReason reason = (OpportunityRecycleReason)opportunityRecycleReasonMap.get(listEntry.getKey());
            String reasonStr = "";
            StringBuilder reasonStrTemp = new StringBuilder();
            boolean oldPoolRuleMatched = false;
            Long poolId = null;
            boolean bl = oldPoolExist = oldPoolFirst && recycleVOList.stream().map(RuleRecycleVO::getOppoPoolId).collect(Collectors.toList()).contains(((OpportunityRecycleReason)opportunityRecycleReasonMap.get(listEntry.getKey())).getResourcePoolId());
            if (oldPoolExist) {
                RuleRecycleVO vo = (RuleRecycleVO)recycleVOList.stream().filter(ruleRecycleVO -> ruleRecycleVO.getOppoPoolId().equals(((OpportunityRecycleReason)opportunityRecycleReasonMap.get(listEntry.getKey())).getResourcePoolId())).collect(Collectors.toList()).get(0);
                if (vo.getNoTrackDate() != null && !vo.getNoTrackDate().isBefore(LocalDate.from(reason.getNoTrackDate()))) {
                    reasonStrTemp.append("\u8d85").append(vo.getNoTrackNum()).append("\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
                }
                if (vo.getNoWinDate() != null && !vo.getNoWinDate().isBefore(LocalDate.from(reason.getNoWinDate())) && reasonStrTemp.length() == 0) {
                    reasonStrTemp.append("\u8d85").append(vo.getNoWinNum()).append("\u5929\u672a\u8d62\u5355");
                }
                if (reasonStrTemp.length() > 0) {
                    reasonStr = reasonStrTemp.toString();
                    poolId = vo.getOppoPoolId();
                    oldPoolRuleMatched = true;
                }
            }
            if (!oldPoolRuleMatched) {
                for (RuleRecycleVO ruleRecycleVO3 : recycleVOList) {
                    reasonStrTemp = new StringBuilder();
                    if (ruleRecycleVO3.getNoTrackDate() != null && !ruleRecycleVO3.getNoTrackDate().isBefore(LocalDate.from(reason.getNoTrackDate()))) {
                        reasonStrTemp.append("\u8d85").append(ruleRecycleVO3.getNoTrackNum()).append("\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
                    }
                    if (reasonStrTemp.length() == 0 && ruleRecycleVO3.getNoWinDate() != null && !ruleRecycleVO3.getNoWinDate().isBefore(LocalDate.from(reason.getNoWinDate()))) {
                        reasonStrTemp.append("\u8d85").append(ruleRecycleVO3.getNoWinNum()).append("\u5929\u672a\u8d62\u5355");
                    }
                    if (reasonStrTemp.length() <= 0 || oldPoolExist) continue;
                    reasonStr = reasonStrTemp.toString();
                    poolId = ruleRecycleVO3.getOppoPoolId();
                    break;
                }
            }
            if ((oppo = (OpportunityPoolOppo)BeanUtil.copy((Object)map.get(listEntry.getKey()), OpportunityPoolOppo.class)) == null || reasonStr.isEmpty()) continue;
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            OpportunityRecycleServiceImpl.setPoolOppoAndRecord(oppo, poolId, poolIdRuleVOMap.get(poolId).getOppoPoolName(), operateRecordDO, reasonStr, operateRecordDOList, dateTimeNow, "0");
            delOpportunityIdList.add((Long)listEntry.getKey());
            addPoolOppoList.add(oppo);
            String personPoolId = oppo.getOldChargerPerson() + "," + poolIdRuleVOMap.get(oppo.getOppoPoolId()).getOppoPoolName();
            if (!oppoRecycleMessageVoMap.containsKey(personPoolId)) {
                OppoRecycleMessageVo vo = new OppoRecycleMessageVo();
                if (oppo.getLastJoinReason().contains("\u8ddf\u8fdb")) {
                    vo.setCountNoTrack(vo.getCountNoTrack() + 1);
                    vo.setNoTrackDayNum(Integer.parseInt(((OppoRuleVO)poolIdRuleMap.get(oppo.getOppoPoolId())).getRuleRecycle().getNoTrackDay()));
                } else if (oppo.getLastJoinReason().contains("\u8d62\u5355")) {
                    vo.setCountNoWin(vo.getCountNoWin() + 1);
                    vo.setNoWinDayNum(Integer.parseInt(((OppoRuleVO)poolIdRuleMap.get(oppo.getOppoPoolId())).getRuleRecycle().getNoWinDay()));
                }
                oppoRecycleMessageVoMap.put(personPoolId, vo);
                continue;
            }
            if (oppo.getLastJoinReason().contains("\u8ddf\u8fdb")) {
                int count = ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).getCountNoTrack();
                ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).setCountNoTrack(count + 1);
                ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).setNoTrackDayNum(Integer.parseInt(((OppoRuleVO)poolIdRuleMap.get(oppo.getOppoPoolId())).getRuleRecycle().getNoTrackDay()));
                continue;
            }
            if (!oppo.getLastJoinReason().contains("\u8d62\u5355")) continue;
            int count = ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).getCountNoWin();
            ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).setCountNoWin(count + 1);
            ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).setNoWinDayNum(Integer.parseInt(((OppoRuleVO)poolIdRuleMap.get(oppo.getOppoPoolId())).getRuleRecycle().getNoWinDay()));
        }
        this.delAndSaveOpportunity(delOpportunityIdList, dateTimeNow, addPoolOppoList);
        if (CollectionUtil.isNotEmpty(operateRecordDOList)) {
            this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
        }
        if (CollectionUtil.isNotEmpty(oppoRecycleMessageVoMap)) {
            ScheduledMsgTemp scheduledMsgTemp = new ScheduledMsgTemp();
            scheduledMsgTemp.setCreateTime(dateTimeNow);
            scheduledMsgTemp.setMsgJson(JsonUtil.toJson(oppoRecycleMessageVoMap));
            scheduledMsgTemp.setStatus("0");
            scheduledMsgTemp.setType("1");
            this.scheduledMsgTempService.save(scheduledMsgTemp);
        }
        return new ProcessResult(true);
    }

    @Nullable
    private LambdaQueryWrapper<OpportunityEntity> getOpportunityEntityLambdaQueryWrapper(List<OppoRuleVO> ruleList, int i, Map<String, List<OpportunityStage>> stageNameMap) {
        List memberList = ruleList.get(i).getMemberVOList().stream().filter(o -> OpportunityPoolConstant.POOL_MEMBER_ROLE_NORMAL.equals(o.getMemberRole())).collect(Collectors.toList());
        List<Long> personIdList = new ArrayList<Long>();
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        RuleRecycle ruleRecycle = ruleList.get(i).getRuleRecycle();
        for (OpportunityPoolMemberVO memberVO : memberList) {
            if (OpportunityPoolConstant.POOL_MEMBER_TYPE_USER.equals(memberVO.getMemberType())) {
                personIdList.add(memberVO.getMemberId());
                continue;
            }
            if (OpportunityPoolConstant.POOL_MEMBER_TYPE_ROLE.equals(memberVO.getMemberType())) {
                List<String> userIds = this.commonMapper.getUserByRoleId(memberVO.getMemberId());
                personIdList.addAll(userIds.stream().map(userId -> Long.parseLong(userId)).collect(Collectors.toList()));
                continue;
            }
            if (!OpportunityPoolConstant.POOL_MEMBER_TYPE_STRU.equals(memberVO.getMemberType())) continue;
            deptIdList.add(memberVO.getMemberId());
        }
        List userVos = this.organUserBoService.getUserListByDepartmentId(deptIdList);
        personIdList.addAll(userVos.stream().map(UserVo::getId).collect(Collectors.toList()));
        personIdList = personIdList.stream().distinct().collect(Collectors.toList());
        List<WhiteListMember> whiteList = ruleRecycle.getWhite();
        List whitePersonId = whiteList.stream().map(whiteListMember -> Long.parseLong(whiteListMember.getValue())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(personIdList)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List<String> stageNameValue = ruleRecycle.getRange();
        ArrayList stageIds = new ArrayList();
        for (String value : stageNameValue) {
            if (stageNameMap.get(value) == null) continue;
            stageIds.addAll(stageNameMap.get(value).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList()));
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(OpportunityEntity::getChargePersonId, personIdList)).eq(OpportunityEntity::getDelFlag, (Object)"0")).in(OpportunityEntity::getCustomerStageId, stageIds);
        if (CollectionUtil.isNotEmpty(whitePersonId)) {
            queryWrapper.notIn(OpportunityEntity::getChargePersonId, whitePersonId);
        }
        return queryWrapper;
    }

    @Override
    @Transactional
    public ProcessResult poolOpportunityTrans() {
        try {
            LocalDate dateNow = LocalDate.now();
            LocalDateTime dateTimeNow = LocalDateTime.now();
            List<OppoRuleVO> ruleList = this.opportunityPoolRuleMapper.selectAllTransRule();
            ruleList.forEach(oppoRuleVO -> oppoRuleVO.setRulePoolTrans((RulePoolTrans)JSON.parseObject((String)oppoRuleVO.getPublicPoolRuleTrans(), RulePoolTrans.class)));
            ruleList.removeIf(oppoRuleVO -> CollectionUtil.isNotEmpty(oppoRuleVO.getRulePoolTrans().getCondition()) && oppoRuleVO.getRulePoolTrans().getCondition().contains("1"));
            ArrayList dayTypeDtoList = new ArrayList();
            ruleList.forEach(ruleVO -> {
                RulePoolTrans rulePoolTrans = ruleVO.getRulePoolTrans();
                if (rulePoolTrans.getTransDay() != null) {
                    dayTypeDtoList.add(new DayTypeDto(rulePoolTrans.getTransDay(), rulePoolTrans.getTime(), "1"));
                } else {
                    dayTypeDtoList.add(new DayTypeDto(null, null, "0"));
                }
            });
            Map<Long, String> poolNameMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, OppoRuleVO::getOppoPoolName));
            Map<Long, RulePoolTrans> ruleTransMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, OppoRuleVO::getRulePoolTrans));
            List reRecycleTimeList = this.calendarBoService.getStartDate(dayTypeDtoList, dateNow);
            HashMap transRuleDateMap = new HashMap();
            for (int i = 0; i < ruleList.size(); ++i) {
                transRuleDateMap.put(ruleList.get(i).getOppoPoolId(), reRecycleTimeList.get(i));
            }
            if (transRuleDateMap.isEmpty()) {
                return new ProcessResult(true);
            }
            List oppoList = this.opportunityPoolOppoService.list((Wrapper)new LambdaQueryWrapper().in(OpportunityPoolOppo::getOppoPoolId, transRuleDateMap.keySet()));
            Map<Long, List<OpportunityPoolOppo>> oppoListMap = oppoList.stream().collect(Collectors.groupingBy(OpportunityPoolOppo::getOppoPoolId));
            ArrayList<OpportunityPoolOppo> opportunityUpdateList = new ArrayList<OpportunityPoolOppo>();
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            ArrayList<String> msgTempList = new ArrayList<String>();
            for (Map.Entry entry : transRuleDateMap.entrySet()) {
                RulePoolTrans rulePoolTrans = ruleTransMap.get(entry.getKey());
                OpportunityPool targetPool = (OpportunityPool)this.opportunityPoolService.getById(rulePoolTrans.getTargetPool());
                List<OpportunityPoolOppo> opportunityList = oppoListMap.get(entry.getKey());
                if (CollectionUtil.isEmpty(opportunityList)) continue;
                LocalDateTime transDateTime = ((LocalDate)entry.getValue()).atStartOfDay();
                int transCount = 0;
                Long oldPoolId = opportunityList.get(0).getOppoPoolId();
                String oldPoolName = poolNameMap.get(oldPoolId);
                String transReason = "\u6700\u65b0\u5212\u5165\u516c\u6d77\u6c60\u8d85\u8fc7" + rulePoolTrans.getTransDay() + "\u5929\uff0c\u672a\u8ba4\u9886\u6216\u672a\u5206\u914d\uff0c\u81ea\u52a8\u8f6c\u79fb";
                for (OpportunityPoolOppo oppo : opportunityList) {
                    if (!oppo.getLastJoinTime().isBefore(transDateTime)) continue;
                    OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                    HashMap<String, String> field = new HashMap<String, String>();
                    ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
                    HashMap<String, Object> before = new HashMap<String, Object>();
                    HashMap<String, Object> after = new HashMap<String, Object>();
                    before.put(OpportunityPoolEditConstant.OPPORTUNITY_POOL_ID.getField(), oldPoolId);
                    after.put(OpportunityPoolEditConstant.OPPORTUNITY_POOL_ID.getField(), targetPool.getOppoPoolId());
                    before.put(OpportunityPoolEditConstant.OPPORTUNITY_POOL_NAME.getField(), oldPoolName);
                    after.put(OpportunityPoolEditConstant.OPPORTUNITY_POOL_NAME.getField(), targetPool.getOppoPoolName());
                    field.put("field", OpportunityPoolEditConstant.OPPORTUNITY_POOL_NAME.getField());
                    field.put("fieldName", OpportunityPoolEditConstant.OPPORTUNITY_POOL_NAME.getName());
                    changeField.add(field);
                    operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                    operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_POOL_OPPO_AUTO_TRANS.getId());
                    operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
                    operateRecordDO.setTypeId(oppo.getOpportunityId());
                    operateRecordDO.setBusinessName(oppo.getOpportunityName());
                    operateRecordDO.setChangeBefore(JSON.toJSONString(before));
                    operateRecordDO.setChangeAfter(JSON.toJSONString(after));
                    operateRecordDO.setChangeField(JSON.toJSONString(changeField));
                    operateRecordDO.setCreateTime(dateTimeNow);
                    operateRecordDO.setChangeTime(dateTimeNow);
                    operateRecordDO.setRecordContent(transReason);
                    operateRecordDO.setDelflag("0");
                    operateRecordDO.setCreatePersonName("\u7cfb\u7edf");
                    operateRecordDOList.add(operateRecordDO);
                    oppo.setLastJoinTime(dateTimeNow);
                    oppo.setLastJoinUserName("\u7cfb\u7edf");
                    oppo.setLastJoinUser(null);
                    oppo.setOppoPoolId(targetPool.getOppoPoolId());
                    oppo.setOppoPoolName(targetPool.getOppoPoolName());
                    oppo.setLastJoinType(OpportunityPoolConstant.JOIN_TYPE_TRANS);
                    oppo.setLastJoinReason(transReason);
                    opportunityUpdateList.add(oppo);
                    ++transCount;
                }
                if (!CollectionUtil.isNotEmpty(opportunityList) || transCount <= 0) continue;
                String msgContent = "\u3010\u8f6c\u79fb\u516c\u6d77\u6c60\u63d0\u9192\u3011\u516c\u6d77\u6c60\u540d\u79f0\uff1a" + oldPoolName + "\uff0c\u6709" + transCount + "\u6761\u6570\u636e\uff0c\u56e0\u89e6\u53d1\uff1a" + transReason + "\uff0c\u88ab\u7cfb\u7edf\u8f6c\u79fb\u81f3\u3010" + targetPool.getOppoPoolName() + "\u3011\u4e2d\uff0c\u8bf7\u77e5\u6089\u3002";
                String mobileContent = "\u516c\u6d77\u6c60\u540d\u79f0\uff1a" + oldPoolName + "\uff0c\u6709" + transCount + "\u6761\u6570\u636e\uff0c\u56e0\u89e6\u53d1\uff1a" + transReason + "\uff0c\u88ab\u7cfb\u7edf\u8f6c\u79fb\u81f3\u3010" + targetPool + "\u3011\u4e2d\uff0c\u8bf7\u77e5\u6089\u3002";
                String title = "\u8f6c\u79fb\u516c\u6d77\u6c60\u63d0\u9192";
                List pushToUserId = this.opportunityPoolMemberService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityPoolMember::getMemberId}).eq(OpportunityPoolMember::getOppoPoolId, (Object)oldPoolId)).eq(OpportunityPoolMember::getMemberRole, (Object)"2"), String::valueOf);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("msgContent", msgContent);
                map.put("mobileContent", mobileContent);
                map.put("title", title);
                map.put("pushToUserId", pushToUserId);
                msgTempList.add(JsonUtil.toJson(map));
            }
            if (!msgTempList.isEmpty()) {
                String jsonMsgTempList = JsonUtil.toJson(msgTempList);
                ScheduledMsgTemp scheduledMsgTemp = new ScheduledMsgTemp();
                scheduledMsgTemp.setCreateTime(dateTimeNow);
                scheduledMsgTemp.setMsgJson(jsonMsgTempList);
                scheduledMsgTemp.setStatus("0");
                scheduledMsgTemp.setType("2");
                this.scheduledMsgTempService.save(scheduledMsgTemp);
            }
            if (CollectionUtil.isNotEmpty(operateRecordDOList)) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            if (CollectionUtil.isNotEmpty(opportunityUpdateList)) {
                this.opportunityPoolOppoService.updateBatchById(opportunityUpdateList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ProcessResult(true);
    }

    private void delAndSaveOpportunity(List<Long> delOpportunityIdList, LocalDateTime dateTimeNow, List<OpportunityPoolOppo> addPoolOppoList) {
        if (CollectionUtil.isNotEmpty(delOpportunityIdList)) {
            this.teamMeberService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TeamMeberEntity::getBusinessType, (Object)"2")).in(TeamMeberEntity::getBusinessId, delOpportunityIdList)).set(TeamMeberEntity::getDelFlag, (Object)"1"));
            this.opportunityService.removeByIds(delOpportunityIdList);
            this.taskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskEntity::getBusinessType, (Object)"2")).in(TaskEntity::getBusinessId, delOpportunityIdList)).ne(TaskEntity::getState, (Object)"2")).set(TaskEntity::getState, (Object)"3")).set(TaskEntity::getLastTime, (Object)dateTimeNow));
            this.opportunityPoolOppoService.saveBatch(addPoolOppoList);
        }
    }

    private List<Long> reRecycle(ReRecycleVo reRecycleVo, LambdaQueryWrapper<OpportunityEntity> queryWrapper) {
        Long opportunityId;
        Long poolId = reRecycleVo.getPoolId();
        queryWrapper.eq(OpportunityEntity::getResourcePoolId, (Object)poolId);
        List opportunityFromPool = this.opportunityService.list((Wrapper)queryWrapper);
        List<Long> oppoIds = opportunityFromPool.stream().map(OpportunityEntity::getOpportunityId).collect(Collectors.toList());
        if (oppoIds.isEmpty()) {
            return oppoIds;
        }
        List<Long> trackTwiceOpportunityIds = this.opportunityMapper.selectTrackTwiceOpportunityIds(oppoIds);
        opportunityFromPool.removeIf(opportunityEntity -> trackTwiceOpportunityIds.contains(opportunityEntity.getOpportunityId()));
        if (CollectionUtil.isEmpty((Collection)opportunityFromPool)) {
            return oppoIds;
        }
        ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
        ArrayList<Long> delOpportunityIdList = new ArrayList<Long>();
        ArrayList<OpportunityPoolOppo> addPoolOppoList = new ArrayList<OpportunityPoolOppo>();
        String poolName = reRecycleVo.getPoolName();
        HashMap<String, OppoRecycleMessageVo> oppoRecycleMessageVoMap = new HashMap<String, OppoRecycleMessageVo>();
        LocalDateTime dateTimeNow = LocalDateTime.now();
        LocalDate dateNow = LocalDate.now();
        ArrayList<DayTypeDto> reRecycleRuleList = new ArrayList<DayTypeDto>();
        HashMap<Long, List<DayTypeDto>> dtoListMap = new HashMap<Long, List<DayTypeDto>>();
        HashMap<Long, LocalDate> dateMap = new HashMap<Long, LocalDate>();
        if (reRecycleVo.getReRuleParam1() != null) {
            reRecycleRuleList.add(new DayTypeDto(reRecycleVo.getReRuleParam1(), reRecycleVo.getDateType(), "1"));
        } else {
            reRecycleRuleList.add(new DayTypeDto(reRecycleVo.getReRuleParam1(), reRecycleVo.getDateType(), "0"));
        }
        List reRecycleTimeList = this.calendarBoService.getStartDate(reRecycleRuleList, dateNow);
        reRecycleVo.setDate1((LocalDate)reRecycleTimeList.get(0));
        Map day2Map = new HashMap();
        Map day3Map = new HashMap();
        if (reRecycleVo.getReRuleParam2() != null) {
            DayTypeDto dayTypeDto;
            for (OpportunityEntity opportunity : opportunityFromPool) {
                opportunityId = opportunity.getOpportunityId();
                LocalDateTime claimAllocateTime = opportunity.getClaimTime() != null ? opportunity.getClaimTime() : opportunity.getAllocateTime();
                dateMap.put(opportunityId, claimAllocateTime.toLocalDate());
                dayTypeDto = new DayTypeDto();
                dayTypeDto.setSwitchFlag("1");
                dayTypeDto.setDateType(reRecycleVo.getDateType());
                dayTypeDto.setDay(reRecycleVo.getReRuleParam2());
                dtoListMap.put(opportunityId, Collections.singletonList(dayTypeDto));
            }
            day2Map = this.calendarBoService.getRecycleTime(dtoListMap, dateMap);
            for (OpportunityEntity opportunity : opportunityFromPool) {
                if (opportunity.getTrackTime() == null) continue;
                opportunityId = opportunity.getOpportunityId();
                LocalDate trackDate = LocalDate.from(opportunity.getTrackTime());
                dateMap.put(opportunityId, trackDate);
                dayTypeDto = new DayTypeDto();
                dayTypeDto.setSwitchFlag("1");
                dayTypeDto.setDateType(reRecycleVo.getDateType());
                dayTypeDto.setDay(reRecycleVo.getReRuleParam3());
                dtoListMap.put(opportunityId, Collections.singletonList(dayTypeDto));
            }
            day3Map = this.calendarBoService.getRecycleTime(dtoListMap, dateMap);
        }
        for (OpportunityEntity opportunity : opportunityFromPool) {
            LocalDateTime claimAllocateTime;
            opportunityId = opportunity.getOpportunityId();
            String reason = "";
            LocalDateTime localDateTime = claimAllocateTime = opportunity.getClaimTime() != null ? opportunity.getClaimTime() : opportunity.getAllocateTime();
            if (claimAllocateTime == null) continue;
            LocalDateTime trackTime = opportunity.getTrackTime();
            boolean recycleFlag = false;
            if (reRecycleVo.getDate1() != null && (trackTime == null && claimAllocateTime.isBefore(reRecycleVo.getDate1().atStartOfDay()) || trackTime != null && (trackTime.isAfter(reRecycleVo.getDate1().atStartOfDay()) || trackTime.isBefore(claimAllocateTime) && claimAllocateTime.isBefore(reRecycleVo.getDate1().atStartOfDay())))) {
                reason = "\u8ba4\u9886/\u5206\u914d\u540e\uff0c\u8d85\u8fc7" + reRecycleVo.getReRuleParam1() + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u81ea\u52a8\u5212\u5165\u81f3\u539f\u516c\u6d77\u3002";
                recycleFlag = true;
            }
            if (!recycleFlag && day2Map.containsKey(opportunityId) && day3Map.containsKey(opportunityId)) {
                LocalDate date2 = ((RecycleReasonDate)day2Map.get(opportunityId)).getDate();
                LocalDate date3 = ((RecycleReasonDate)day3Map.get(opportunityId)).getDate();
                if (date2 != null && date3 != null && trackTime != null && trackTime.isBefore(date2.atStartOfDay()) && dateNow.isAfter(date3)) {
                    reason = "\u8ba4\u9886/\u5206\u914d\u540e\uff0c" + reRecycleVo.getReRuleParam2() + "\u5929\u5185\u8ddf\u8fdb\u8fc7\uff1b\u53c8\u8d85\u8fc7" + reRecycleVo.getReRuleParam3() + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u81ea\u52a8\u5212\u5165\u81f3\u539f\u516c\u6d77\u3002";
                    recycleFlag = true;
                }
            }
            if (!recycleFlag) continue;
            OpportunityPoolOppo oppo = (OpportunityPoolOppo)BeanUtil.copy((Object)opportunity, OpportunityPoolOppo.class);
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            OpportunityRecycleServiceImpl.setPoolOppoAndRecord(oppo, poolId, poolName, operateRecordDO, reason, operateRecordDOList, dateTimeNow, "1");
            delOpportunityIdList.add(oppo.getOpportunityId());
            addPoolOppoList.add(oppo);
            String personPoolId = oppo.getOldChargerPerson() + "," + poolName;
            if (!oppoRecycleMessageVoMap.containsKey(personPoolId)) {
                OppoRecycleMessageVo vo = new OppoRecycleMessageVo();
                if (oppo.getLastJoinReason().contains("\u53c8")) {
                    vo.setReRecycleNoTwiceTrack(vo.getReRecycleNoTwiceTrack() + 1);
                    vo.setReRecycleNoTwiceTrackNum1(reRecycleVo.getReRuleParam2());
                    vo.setReRecycleNoTwiceTrackNum2(reRecycleVo.getReRuleParam3());
                } else {
                    vo.setReRecycleNoTrack(vo.getReRecycleNoTrack() + 1);
                    vo.setReRecycleNoTrackNum(reRecycleVo.getReRuleParam1());
                }
                oppoRecycleMessageVoMap.put(personPoolId, vo);
                continue;
            }
            if (oppo.getLastJoinReason().contains("\u53c8")) {
                int count = ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).getReRecycleNoTwiceTrack();
                ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).setReRecycleNoTwiceTrack(count + 1);
                continue;
            }
            int count = ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).getReRecycleNoTrack();
            ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).setReRecycleNoTrack(count + 1);
        }
        if (!addPoolOppoList.isEmpty()) {
            ScheduledMsgTemp scheduledMsgTemp = new ScheduledMsgTemp();
            scheduledMsgTemp.setCreateTime(dateTimeNow);
            scheduledMsgTemp.setMsgJson(JsonUtil.toJson(oppoRecycleMessageVoMap));
            scheduledMsgTemp.setStatus("0");
            scheduledMsgTemp.setType("1");
            this.scheduledMsgTempService.save(scheduledMsgTemp);
            this.delAndSaveOpportunity(delOpportunityIdList, dateTimeNow, addPoolOppoList);
            if (CollectionUtil.isNotEmpty(operateRecordDOList)) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
        }
        return oppoIds;
    }

    private static void setPoolOppoAndRecord(OpportunityPoolOppo oppo, Long poolId, String poolName, OperateRecordAPIVo operateRecordDO, String reason, List<OperateRecordAPIVo> operateRecordDOList, LocalDateTime dateTimeNow, String reRecycleFlag) {
        HashMap<String, String> field = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
        HashMap<String, Object> before = new HashMap<String, Object>();
        HashMap<String, Object> after = new HashMap<String, Object>();
        before.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), oppo.getChargePersonId());
        after.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), poolId);
        before.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), oppo.getChargePersonName());
        after.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), poolName);
        field.put("field", OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField());
        field.put("fieldName", OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getName());
        changeField.add(field);
        operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        if ("0".equals(reRecycleFlag)) {
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_POOL_AUTO_RECYCLE.getId());
        } else if ("1".equals(reRecycleFlag)) {
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_POOL_RE_RECYCLE.getId());
        }
        operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
        operateRecordDO.setTypeId(oppo.getOpportunityId());
        operateRecordDO.setBusinessName(oppo.getOpportunityName());
        operateRecordDO.setChangeBefore(JSON.toJSONString(before));
        operateRecordDO.setChangeAfter(JSON.toJSONString(after));
        operateRecordDO.setChangeField(JSON.toJSONString(changeField));
        operateRecordDO.setCreateTime(dateTimeNow);
        operateRecordDO.setChangeTime(dateTimeNow);
        operateRecordDO.setRecordContent(reason);
        operateRecordDO.setDelflag("0");
        operateRecordDO.setCreatePersonName("\u7cfb\u7edf");
        operateRecordDOList.add(operateRecordDO);
        oppo.setOppoPoolId(poolId);
        oppo.setOldChargerPerson(oppo.getChargePersonId());
        oppo.setOldChargerPersonName(oppo.getChargePersonName());
        oppo.setLastJoinTime(dateTimeNow);
        oppo.setLastJoinReason(reason);
        oppo.setLastJoinType(OpportunityPoolConstant.JOIN_TYPE_AUTO);
        oppo.setChangeTime(dateTimeNow);
        oppo.setChangePerson(null);
        oppo.setChangePersonName("\u7cfb\u7edf");
        oppo.setLastJoinUser(null);
        oppo.setLastJoinUserName("\u7cfb\u7edf");
        oppo.setChargePersonId(null);
        oppo.setChargePersonName(null);
        oppo.setOwnDepartment(null);
        oppo.setOwnDepartmentName(null);
    }
}

