/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.common.api.fileInfo.dto.FileImportAPIDto;
import com.jxdinfo.crm.common.api.fileInfo.service.IFileImportAPIService;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.CompanyBusinessInfoVo;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerImportService;
import com.jxdinfo.crm.core.customer.service.ICustomerIncludePoolService;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.ReadCustomerExcelUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ResourceUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CustomerImportServiceImpl
implements ICustomerImportService {
    @Resource
    private ICustomerIncludePoolService customerIncludePoolService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ISysDicRefService dicRefService;
    @Resource
    private IFileImportAPIService fileImportAPIService;
    @Resource
    private MarketingActivityService marketingActivityService;
    @Resource
    private CustomerService customerService;
    @Resource
    private IAgentApiService agentApiService;
    @Resource
    private CommonService commonService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private TeamMeberService teamMeberService;

    @Override
    public void customerExportTemplate(HttpServletResponse response) {
        File rootFile = null;
        try {
            int len;
            String newTemplatePath;
            rootFile = new File(ResourceUtils.getURL((String)"classpath:").getPath());
            File templateFile = new File(rootFile, "/templates/customerImportTemplate.xlsx");
            String templatePath = templateFile.getPath();
            System.out.println(templateFile);
            String fileName = "\u5ba2\u6237\u5bfc\u51fa\u6a21\u677f.xlsx";
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8").replace("+", "%20");
            if (templatePath.contains("!")) {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("windows")) {
                    templatePath = templatePath.replaceFirst("file:\\\\", "");
                } else if (os.contains("linux")) {
                    templatePath = templatePath.replaceFirst("file:", "");
                }
                rootFile = Paths.get(templatePath.split("!")[0], new String[0]).getRoot().toFile();
            } else {
                rootFile = Paths.get(templatePath, new String[0]).getRoot().toFile();
            }
            File saveFile = new File(rootFile, "/templates");
            String saveDir = saveFile.getPath();
            if (!saveFile.exists()) {
                saveFile.mkdirs();
            }
            if (!new File(newTemplatePath = saveDir + File.separator + "customerImportTemplate.xlsx").exists()) {
                String classpathResource = "templates/customerImportTemplate.xlsx";
                ClassPathResource resource = new ClassPathResource(classpathResource);
                InputStream templateInputStream = resource.getInputStream();
                Files.copy(templateInputStream, Paths.get(newTemplatePath, new String[0]), new CopyOption[0]);
            }
            rootFile = new File(ResourceUtils.getURL((String)"classpath:").getPath());
            ClassPathResource resource = new ClassPathResource("templates/customerImportTemplate.xlsx");
            InputStream inputStream = resource.getInputStream();
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-Disposition", "attachment; filename=" + encodedFileName);
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
            outputStream.flush();
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional
    public String customerImport(MultipartFile file) {
        List<Object> failCustomerList;
        List<Object> addCustomerList;
        Long fileImportId;
        AttachmentManagerModelVo suspectedAttachment;
        AttachmentManagerModelVo attachment;
        String userName;
        Long userId;
        LocalDateTime date;
        int flag;
        block86: {
            void var41_59;
            List agentNames;
            Set campaignNames;
            flag = 0;
            if (file == null) {
                flag = -1;
            }
            if (!file.getOriginalFilename().endsWith("xlsx")) {
                flag = -2;
            }
            date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            userId = user.getUserId();
            userName = user.getUserName();
            Long deptId = user.getDeptId();
            String deptName = user.getDeptName();
            attachment = null;
            suspectedAttachment = null;
            fileImportId = Long.valueOf(CommonUtills.generateAssignId());
            addCustomerList = new ArrayList();
            HashSet<Object> failCustomerIdSet = new HashSet<Object>();
            boolean importCount = false;
            boolean failCount = false;
            HashMap<Long, String> errorMsgMap = new HashMap<Long, String>();
            failCustomerList = new ArrayList();
            HashMap emptyFieldMap = new HashMap();
            HashMap matchFailMap = new HashMap();
            List<CustomerEntity> customerEntityList = ReadCustomerExcelUtil.getExcelInfoCustomer(file);
            if (CollectionUtil.isEmpty(customerEntityList)) {
                throw new HussarException("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
            }
            customerEntityList.removeIf(customerEntity -> HussarUtils.isEmpty((Object)customerEntity.getCustomerName()));
            customerEntityList.forEach(customerEntity -> customerEntity.setCustomerId(Long.valueOf(CommonUtills.generateAssignId())));
            List nameList = customerEntityList.stream().map(CustomerEntity::getCustomerName).collect(Collectors.toList());
            List duplicateCustomerList = this.customerIncludePoolService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{CustomerEntity::getCustomerName}).in(CustomerEntity::getCustomerName, nameList)).eq(CustomerEntity::getDelFlag, (Object)"0"), s -> (String)s);
            HashSet<String> nameSet = new HashSet<String>();
            for (CustomerEntity customer : customerEntityList) {
                String customerName = customer.getCustomerName();
                Long customerId = customer.getCustomerId();
                if (duplicateCustomerList.contains(customerName)) {
                    failCustomerIdSet.add(customerId);
                    this.addErrorMsg(errorMsgMap, customerId, "\u7cfb\u7edf\u5185\u5b58\u5728\u540c\u540d\u5ba2\u6237");
                    continue;
                }
                if (nameSet.contains(customerName)) {
                    failCustomerIdSet.add(customerId);
                    this.addErrorMsg(errorMsgMap, customerId, "\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u540c\u540d\u5ba2\u6237");
                    continue;
                }
                nameSet.add(customerName);
            }
            for (CustomerEntity customer : customerEntityList) {
                Long customerId = customer.getCustomerId();
                boolean fail = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (HussarUtils.isEmpty((Object)customer.getCustomerReferredName())) {
                    fail = true;
                    arrayList.add("\u5ba2\u6237\u7b80\u79f0");
                }
                if (HussarUtils.isEmpty((Object)customer.getTrade())) {
                    fail = true;
                    arrayList.add("\u5ba2\u6237\u884c\u4e1a");
                }
                if (HussarUtils.isEmpty((Object)customer.getCustomerAttribute())) {
                    fail = true;
                    arrayList.add("\u5ba2\u6237\u6027\u8d28");
                }
                if (HussarUtils.isEmpty((Object)customer.getCustomerStage())) {
                    fail = true;
                    arrayList.add("\u5ba2\u6237\u9636\u6bb5");
                }
                if (HussarUtils.isEmpty((Object)customer.getCustomerOrigin())) {
                    fail = true;
                    arrayList.add("\u5ba2\u6237\u6765\u6e90");
                }
                if (HussarUtils.isEmpty((Object)customer.getCorporateScale())) {
                    fail = true;
                    arrayList.add("\u4f01\u4e1a\u89c4\u6a21");
                }
                if (HussarUtils.isEmpty((Object)customer.getCorporateImpact())) {
                    fail = true;
                    arrayList.add("\u4f01\u4e1a\u5f71\u54cd\u529b");
                }
                if (HussarUtils.isEmpty((Object)customer.getListingStatus())) {
                    fail = true;
                    arrayList.add("\u4e0a\u5e02\u72b6\u6001");
                }
                if (HussarUtils.isEmpty((Object)customer.getCustomerRelation())) {
                    fail = true;
                    arrayList.add("\u5ba2\u60c5\u5173\u7cfb");
                }
                if (!fail) continue;
                emptyFieldMap.put(customerId, arrayList);
                failCustomerIdSet.add(customerId);
            }
            List customerNames = customerEntityList.stream().map(CustomerEntity::getSuperiorCustomerName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(customerNames)) {
                List customerIncludePoolList = this.customerIncludePoolService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CustomerEntity::getCustomerName, customerNames)).eq(CustomerEntity::getDelFlag, (Object)"0"));
                for (CustomerEntity customer : customerEntityList) {
                    String string = customer.getSuperiorCustomerName();
                    if (!HussarUtils.isNotEmpty((Object)string)) continue;
                    for (Object customerIncludePool : customerIncludePoolList) {
                        if (!((CustomerEntity)customerIncludePool).getCustomerName().equals(string)) continue;
                        customer.setSuperiorCustomerId(String.valueOf(((CustomerEntity)customerIncludePool).getCustomerId()));
                        break;
                    }
                    if (customer.getSuperiorCustomerId() != null) continue;
                    customer.setSuperiorCustomerName(null);
                }
            }
            if (CollectionUtil.isNotEmpty(campaignNames = customerEntityList.stream().map(CustomerEntity::getCampaignName).filter(Objects::nonNull).collect(Collectors.toSet()))) {
                List campaignList = this.marketingActivityService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(MarketingActivityEntity::getCampaignName, campaignNames)).eq(MarketingActivityEntity::getDelFlag, (Object)"0"));
                for (CustomerEntity customerEntity2 : customerEntityList) {
                    String campaignName = customerEntity2.getCampaignName();
                    if (!HussarUtils.isNotEmpty((Object)campaignName)) continue;
                    for (Object campaign : campaignList) {
                        if (!((MarketingActivityEntity)campaign).getCampaignName().equals(campaignName)) continue;
                        customerEntity2.setCampaignId(((MarketingActivityEntity)campaign).getCampaignId());
                        break;
                    }
                    if (customerEntity2.getCampaignId() != null) continue;
                    customerEntity2.setCampaignName(null);
                }
            }
            if (CollectionUtil.isNotEmpty(agentNames = customerEntityList.stream().map(CustomerEntity::getAgentName).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                List agentApiVos = this.agentApiService.selectAgentListByNames(agentNames);
                for (CustomerEntity customer : customerEntityList) {
                    String agentName = customer.getAgentName();
                    if (!HussarUtils.isNotEmpty((Object)agentName)) continue;
                    for (AgentApiVo agentApiVo : agentApiVos) {
                        if (!agentApiVo.getAgentName().equals(agentName)) continue;
                        customer.setAgentId(agentApiVo.getAgentId());
                        break;
                    }
                    if (customer.getAgentId() != null) continue;
                    customer.setAgentName(null);
                }
            }
            Map<String, String> customerTypeDicMap = this.dicRefService.getDicListByType("customerType").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            Map<String, String> map = this.dicRefService.getDicListByType("customer_level").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            Map<String, String> customerTradeDicMap = this.dicRefService.getDicListByType("industry").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            Map<String, String> customerAttributeDicMap = this.dicRefService.getDicListByType("customer_type").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            Map<String, String> customerStageDicMap = this.dicRefService.getDicListByType("customer_stage").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            Map<String, String> customerOriginDicMap = this.dicRefService.getDicListByType("customer_source").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            Map<String, String> corporateScaleDicMap = this.dicRefService.getDicListByType("corporate_scale").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            Map<String, String> corporateImpactDicMap = this.dicRefService.getDicListByType("corporate_impact").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            Map<String, String> listingStatusDicMap = this.dicRefService.getDicListByType("listing_status").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            Map<String, String> customerRelationDicMap = this.dicRefService.getDicListByType("customer_relation").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
            for (CustomerEntity customer : customerEntityList) {
                Long customerId = customer.getCustomerId();
                boolean fail = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (ToolUtil.isNotEmpty((Object)customer.getCustomerType())) {
                    String[] customerTypeNameList = customer.getCustomerType().split(",");
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (String typeName : customerTypeNameList) {
                        if (!customerTypeDicMap.containsKey(typeName)) {
                            fail = true;
                            arrayList.add("\u5ba2\u6237\u7c7b\u578b");
                            break;
                        }
                        arrayList2.add(customerTypeDicMap.get(typeName));
                    }
                    customer.setCustomerType(String.join((CharSequence)",", arrayList2));
                } else {
                    customer.setCustomerType("1");
                }
                if (ToolUtil.isNotEmpty((Object)customer.getCustLevel())) {
                    if (!map.containsKey(customer.getCustLevel())) {
                        fail = true;
                        arrayList.add("\u5ba2\u6237\u7ea7\u522b");
                    } else {
                        customer.setCustLevel(map.get(customer.getCustLevel()));
                    }
                } else {
                    customer.setCustLevel("1");
                }
                if (ToolUtil.isNotEmpty((Object)customer.getTrade())) {
                    if (!customerTradeDicMap.containsKey(customer.getTrade())) {
                        customer.setTrade("19");
                        customer.setOtherTrade(customer.getTrade());
                    } else {
                        customer.setTrade(customerTradeDicMap.get(customer.getTrade()));
                    }
                }
                if (ToolUtil.isNotEmpty((Object)customer.getCustomerAttribute())) {
                    if (!customerAttributeDicMap.containsKey(customer.getCustomerAttribute())) {
                        fail = true;
                        arrayList.add("\u5ba2\u6237\u6027\u8d28");
                    } else {
                        customer.setCustomerAttribute(customerAttributeDicMap.get(customer.getCustomerAttribute()));
                    }
                }
                if (ToolUtil.isNotEmpty((Object)customer.getCustomerStage())) {
                    if (!customerStageDicMap.containsKey(customer.getCustomerStage())) {
                        fail = true;
                        arrayList.add("\u5ba2\u6237\u9636\u6bb5");
                    } else {
                        customer.setCustomerStage(customerStageDicMap.get(customer.getCustomerStage()));
                    }
                }
                if (ToolUtil.isNotEmpty((Object)customer.getCustomerOrigin())) {
                    if (!customerOriginDicMap.containsKey(customer.getCustomerOrigin())) {
                        fail = true;
                        arrayList.add("\u5ba2\u6237\u6765\u6e90");
                    } else {
                        customer.setCustomerOrigin(customerOriginDicMap.get(customer.getCustomerOrigin()));
                    }
                }
                if (ToolUtil.isNotEmpty((Object)customer.getCorporateScale())) {
                    if (!corporateScaleDicMap.containsKey(customer.getCorporateScale())) {
                        fail = true;
                        arrayList.add("\u4f01\u4e1a\u89c4\u6a21");
                    } else {
                        customer.setCorporateScale(corporateScaleDicMap.get(customer.getCorporateScale()));
                    }
                }
                if (ToolUtil.isNotEmpty((Object)customer.getCorporateImpact())) {
                    if (!corporateImpactDicMap.containsKey(customer.getCorporateImpact())) {
                        fail = true;
                        arrayList.add("\u4f01\u4e1a\u5f71\u54cd\u529b");
                    } else {
                        customer.setCorporateImpact(corporateImpactDicMap.get(customer.getCorporateImpact()));
                    }
                }
                if (ToolUtil.isNotEmpty((Object)customer.getListingStatus())) {
                    if (!listingStatusDicMap.containsKey(customer.getListingStatus())) {
                        fail = true;
                        arrayList.add("\u4e0a\u5e02\u72b6\u6001");
                    } else {
                        customer.setListingStatus(listingStatusDicMap.get(customer.getListingStatus()));
                    }
                }
                if (ToolUtil.isNotEmpty((Object)customer.getCustomerRelation())) {
                    if (!customerRelationDicMap.containsKey(customer.getCustomerRelation())) {
                        fail = true;
                        arrayList.add("\u5ba2\u60c5\u5173\u7cfb");
                    } else {
                        customer.setCustomerRelation(customerRelationDicMap.get(customer.getCustomerRelation()));
                    }
                }
                if (!fail) continue;
                matchFailMap.put(customerId, arrayList);
                failCustomerIdSet.add(customerId);
            }
            addCustomerList = customerEntityList.stream().filter(customerEntity -> !failCustomerIdSet.contains(customerEntity.getCustomerId())).collect(Collectors.toList());
            failCustomerList = customerEntityList.stream().filter(customerEntity -> failCustomerIdSet.contains(customerEntity.getCustomerId())).collect(Collectors.toList());
            ArrayList<Iterator<Object>> teamMeberEntityList = new ArrayList<Iterator<Object>>();
            ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
            List staffNumDic = this.dicRefService.getDicListByType("staff_nums");
            for (CustomerEntity customerEntity3 : addCustomerList) {
                try {
                    CompanyBusinessInfoVo companyBusinessInfoVo = this.commonService.getCompanyBusinessInfo(customerEntity3.getCustomerName());
                    Map<String, Object> map2 = this.commonMapper.getProvinceByCity(companyBusinessInfoVo.getCity(), companyBusinessInfoVo.getDistrict());
                    if (HussarUtils.isNotEmpty(map2)) {
                        customerEntity3.setProvince(String.valueOf(map2.get("provinceId")));
                        customerEntity3.setCity(String.valueOf(map2.get("cityId")));
                        customerEntity3.setCounty(String.valueOf(map2.get("districtId")));
                    }
                    customerEntity3.setAddressDetail(companyBusinessInfoVo.getRegLocation());
                    for (DicVo dicVo : staffNumDic) {
                        if (HussarUtils.isEmpty((Object)companyBusinessInfoVo.getStaffNumRange())) {
                            customerEntity3.setStaffNumber("1");
                        } else {
                            if (!dicVo.getLabel().equals(companyBusinessInfoVo.getStaffNumRange())) continue;
                            customerEntity3.setStaffNumber(dicVo.getValue());
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    customerEntity3.setStaffNumber("1");
                }
                customerEntity3.setCustomerRisk("4");
                customerEntity3.setCreateTime(date);
                customerEntity3.setChangePerson(userId);
                customerEntity3.setCreatePersonName(userName);
                customerEntity3.setCreateDepartment(deptId);
                customerEntity3.setCreateDepartmentName(deptName);
                customerEntity3.setChangeTime(date);
                customerEntity3.setChangePerson(userId);
                customerEntity3.setChangePersonName(userName);
                customerEntity3.setOwnDepartment(deptId);
                customerEntity3.setOwnDepartmentName(deptName);
                customerEntity3.setChargePersonId(userId);
                customerEntity3.setChargePersonName(userName);
                customerEntity3.setDelFlag("0");
                Object teamMeber = this.saveTeamMember(user, date, customerEntity3.getCustomerId());
                teamMeberEntityList.add((Iterator<Object>)teamMeber);
                OperateRecordAPIVo operateRecordAPIVo = this.saveTrackRecord(user, date, customerEntity3.getCustomerId(), customerEntity3.getCustomerName());
                trackRecordList.add(operateRecordAPIVo);
            }
            this.customerService.saveBatch(addCustomerList);
            this.teamMeberService.saveBatch(teamMeberEntityList);
            this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
            FileInputStream fileInputStream = null;
            try {
                ApiResponse response = this.attachmentManagerService.uploadFileWithDrag(file, fileImportId);
                attachment = (AttachmentManagerModelVo)response.getData();
                if (CollectionUtil.isNotEmpty(failCustomerList)) {
                    for (CustomerEntity customerEntity4 : failCustomerList) {
                        String text;
                        Long customerId = customerEntity4.getCustomerId();
                        if (emptyFieldMap.containsKey(customerId)) {
                            text = "\u672a\u586b\u5199" + String.join((CharSequence)"\u3001", (Iterable)emptyFieldMap.get(customerId)) + "\u4fe1\u606f";
                            this.addErrorMsg(errorMsgMap, customerId, text);
                        }
                        if (!matchFailMap.containsKey(customerId)) continue;
                        text = String.join((CharSequence)"\u3001", (Iterable)matchFailMap.get(customerId)) + "\u5339\u914d\u5931\u8d25";
                        this.addErrorMsg(errorMsgMap, customerId, text);
                    }
                    File file1 = this.exportExcelPaper(failCustomerList, errorMsgMap);
                    FileInputStream fileInputStream2 = new FileInputStream(file1);
                    MockMultipartFile mockMultipartFile = new MockMultipartFile(file1.getName(), file1.getName(), "application/octet-stream", (InputStream)fileInputStream2);
                    ApiResponse suspectedResponse = this.attachmentManagerService.uploadFileWithDrag((MultipartFile)mockMultipartFile, null);
                    suspectedAttachment = (AttachmentManagerModelVo)suspectedResponse.getData();
                    file1.delete();
                }
                if (var41_59 == null) break block86;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            try {
                var41_59.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FileImportAPIDto fileImport = new FileImportAPIDto();
        String string = attachment.getFileName();
        String finishMessage = "";
        if (flag >= 0) {
            fileImport.setSuccessFail("1");
            finishMessage = "\u5bfc\u5165\u6210\u529f" + addCustomerList.size() + "\u6761\uff0c\u81ea\u52a8\u8fc7\u6ee4" + failCustomerList.size() + "\u6761\u5f02\u5e38\u5ba2\u6237";
        } else {
            fileImport.setSuccessFail("0");
            if (flag == -1) {
                finishMessage = "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728";
            } else if (flag == -2) {
                finishMessage = "\u8bf7\u4e0a\u4f20\u6307\u5b9a\u683c\u5f0f\u6587\u4ef6";
            } else if (flag == -3) {
                finishMessage = "\u4e0a\u4f20\u5931\u8d25";
            }
        }
        fileImport.setFileImportId(fileImportId);
        Long sourceFileId = attachment.getId();
        fileImport.setSourceFileId(sourceFileId);
        fileImport.setSourceFileName(string);
        fileImport.setImportResult(finishMessage);
        fileImport.setModuleId(LabelModuleEnum.CUSTOMER.getModuleId());
        if (CollectionUtil.isNotEmpty(failCustomerList)) {
            Long suspectedFileId = suspectedAttachment.getId();
            fileImport.setSuspectedFileId(suspectedFileId);
            fileImport.setSuspectedFileName(suspectedAttachment.getFileName());
        }
        fileImport.setCreateTime(date);
        fileImport.setCreator(userId);
        fileImport.setCreatorName(userName);
        fileImport.setLastTime(date);
        fileImport.setLastEditor(userId);
        fileImport.setLastEditorName(userName);
        fileImport.setDelFlag("0");
        this.fileImportAPIService.save(fileImport);
        return "\u5171\u5bfc\u5165" + addCustomerList.size() + "\u6761\u6570\u636e";
    }

    private TeamMeberEntity saveTeamMember(SecurityUser user, LocalDateTime date, long businessId) {
        TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
        teamMeberEntity.setTeamMeberName(user.getUserName());
        teamMeberEntity.setPersonId(user.getUserId());
        teamMeberEntity.setBusinessId(businessId);
        teamMeberEntity.setBusinessType("1");
        teamMeberEntity.setModifyPower("1");
        teamMeberEntity.setIsCharge("1");
        teamMeberEntity.setCreatePerson(user.getUserId());
        teamMeberEntity.setCreatePersonName(user.getUserName());
        teamMeberEntity.setCreateTime(date);
        teamMeberEntity.setOwnDepartment(user.getDeptId());
        teamMeberEntity.setOwnDepartmentName(user.getDeptName());
        teamMeberEntity.setUpdatePerson(user.getUserId());
        teamMeberEntity.setUpdateTime(date);
        teamMeberEntity.setUpdatePersonName(user.getUserName());
        teamMeberEntity.setDelFlag("0");
        return teamMeberEntity;
    }

    private OperateRecordAPIVo saveTrackRecord(SecurityUser user, LocalDateTime date, long businessId, String businessName) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setBusinessType(CrmBusinessTypeEnum.CUSTOMER.getId());
        operateRecordDO.setTypeId(Long.valueOf(businessId));
        operateRecordDO.setBusinessName(businessName);
        operateRecordDO.setCreatePerson(user.getUserId());
        operateRecordDO.setCreatePersonName(user.getUserName());
        operateRecordDO.setCreateTime(date);
        operateRecordDO.setChangePerson(user.getUserId());
        operateRecordDO.setChangeTime(date);
        operateRecordDO.setChangePersonName(user.getUserName());
        operateRecordDO.setDelflag("0");
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_IMPORT_CUSTOMER.getId());
        return operateRecordDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportExcelPaper(List<CustomerEntity> list, Map<Long, String> errorMsgMap) {
        int i;
        String[] title = new String[]{"\u5bfc\u5165\u5ba2\u6237\u540d\u79f0", "\u5f02\u5e38\u539f\u56e0"};
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = null;
        for (i = 0; i < title.length; ++i) {
            cell = row.createCell(i);
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            XSSFFont font = workbook.createFont();
            font.setFontName("\u5b8b\u4f53");
            font.setFontHeightInPoints((short)13);
            cellStyle.setFont((Font)font);
            cell.setCellStyle((CellStyle)cellStyle);
            cell.setCellValue(title[i]);
        }
        for (i = 1; i < list.size() + 1; ++i) {
            XSSFRow nextRow = sheet.createRow(i);
            for (int j = 0; j < title.length; ++j) {
                CustomerEntity customer = list.get(i - 1);
                XSSFCell cell2 = nextRow.createCell(j);
                if (j == 0) {
                    cell2.setCellValue(customer.getCustomerName());
                }
                if (j != 1) continue;
                cell2.setCellValue(errorMsgMap.get(customer.getCustomerId()));
            }
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        File file = new File("\u5bfc\u5165\u5931\u8d25\u5ba2\u6237" + LocalDateTime.now().format(dateTimeFormatter) + ".xlsx");
        OutputStream os = null;
        try {
            os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            workbook.write(os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return file;
    }

    private void addErrorMsg(Map<Long, String> errorMsgMap, Long customerId, String error) {
        if (!errorMsgMap.containsKey(customerId)) {
            errorMsgMap.put(customerId, error);
        } else {
            errorMsgMap.put(customerId, errorMsgMap.get(customerId) + "\uff1b" + error);
        }
    }
}

