/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.message.service.IMessagePushService;
import com.jxdinfo.crm.common.api.message.service.IMessageTemplateService;
import com.jxdinfo.crm.common.api.message.vo.MessagePushVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordRelationAPIService;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolEditConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dao.OpportunityPoolMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dao.OpportunityPoolMemberMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dto.OpportunityPoolDto;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dto.OpportunityPoolTransferDto;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dto.ReleaseToPublicPoolBatchDto;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dto.UpdateOrderNumDto;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.OpportunityPool;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.OpportunityPoolMember;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.PublicPoolRule;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IOpportunityPoolManageService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IOpportunityPoolMemberService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IPublicPoolRuleService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.OpportunityPoolService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OpportunityPoolMemberVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OpportunityPoolVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.PublicPoolRuleVo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.model.OpportunityPoolOppo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.service.OpportunityPoolOppoService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.task.model.TaskEntity;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpportunityPoolManageServiceImpl
extends HussarServiceImpl<OpportunityPoolMapper, OpportunityPool>
implements IOpportunityPoolManageService {
    @Resource
    private IPublicPoolRuleService poolRuleService;
    @Resource
    private IOpportunityPoolMemberService poolMemberService;
    @Resource
    private OpportunityPoolMapper opportunityPoolMapper;
    @Resource
    private OpportunityPoolOppoService opportunityPoolOppoService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private ITrackRecordRelationAPIService trackRecordRelationAPIService;
    @Resource
    private OpportunityPoolMemberMapper opportunityPoolMemberMapper;
    @Resource
    private IPublicPoolRuleService publicPoolRuleService;
    @Resource
    private ICrmBaseConfigBoService baseConfigBoService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private OpportunityPoolService opportunityPoolService;
    @Resource
    private TaskService taskService;
    @Resource
    private IMessagePushService messagePushService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private IMessageTemplateService messageTemplateService;

    @Override
    @Transactional
    public Long addOpportunityPool(OpportunityPoolDto dto) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        Long poolRuleId = HussarUtils.toLong((Object)CommonUtills.generateAssignId());
        Long oppoPoolId = HussarUtils.toLong((Object)CommonUtills.generateAssignId());
        OpportunityPool opportunityPool = (OpportunityPool)BeanUtil.copy((Object)dto, OpportunityPool.class);
        Integer maxOrderNumber = this.opportunityPoolMapper.selectMaxOrderNumber();
        if (maxOrderNumber == null) {
            maxOrderNumber = 0;
        }
        int orderNumber = maxOrderNumber + 1;
        opportunityPool.setOppoPoolId(oppoPoolId);
        opportunityPool.setCreateTime(date);
        opportunityPool.setLastTime(date);
        opportunityPool.setCreator(userId);
        opportunityPool.setCreatorName(user.getUserName());
        opportunityPool.setLastEditor(userId);
        opportunityPool.setLastEditorName(user.getUserName());
        opportunityPool.setOppoPoolRuleId(poolRuleId);
        opportunityPool.setCreateDepatmentId(user.getDeptId());
        opportunityPool.setCreateDepatmentName(((SysStru)this.sysStruService.getById((Serializable)user.getDeptId())).getOrganAlias());
        opportunityPool.setOppoPoolOrder(orderNumber);
        PublicPoolRule poolRule = (PublicPoolRule)((Object)BeanUtil.copy((Object)dto.getPoolRuleDto(), PublicPoolRule.class));
        poolRule.setCreateTime(date);
        poolRule.setLastTime(date);
        poolRule.setCreator(userId);
        poolRule.setLastEditor(userId);
        poolRule.setPublicPoolRuleId(poolRuleId);
        poolRule.setPublicPoolRuleModule(OpportunityPoolConstant.RULE_MODULE_OPPORTUNITY_POOL);
        List poolMemberList = BeanUtil.copy(dto.getMemberDtoList(), OpportunityPoolMember.class);
        poolMemberList.addAll(BeanUtil.copy(dto.getManagerDtoList(), OpportunityPoolMember.class));
        poolMemberList.forEach(member -> {
            member.setOppoPoolId(oppoPoolId);
            member.setCreateTime(date);
            member.setLastTime(date);
            member.setCreator(userId);
            member.setLastEditor(userId);
        });
        this.save(opportunityPool);
        this.poolRuleService.save((Object)poolRule);
        this.poolMemberService.saveBatch(poolMemberList);
        return oppoPoolId;
    }

    @Override
    @Transactional
    public String updateOpportunityPool(OpportunityPoolDto dto) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        PublicPoolRule poolRule = (PublicPoolRule)((Object)BeanUtil.copy((Object)dto.getPoolRuleDto(), PublicPoolRule.class));
        List poolMemberList = BeanUtil.copy(dto.getMemberDtoList(), OpportunityPoolMember.class);
        poolMemberList.addAll(BeanUtil.copy(dto.getManagerDtoList(), OpportunityPoolMember.class));
        poolRule.setLastTime(date);
        poolRule.setLastEditor(userId);
        poolRule.setPublicPoolRuleModule(OpportunityPoolConstant.RULE_MODULE_OPPORTUNITY_POOL);
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(OpportunityPool::getOppoPoolId, (Object)dto.getOppoPoolId())).set(OpportunityPool::getOppoPoolName, (Object)dto.getOppoPoolName())).set(OpportunityPool::getLastTime, (Object)date)).set(OpportunityPool::getLastEditor, (Object)userId)).set(OpportunityPool::getLastEditorName, (Object)user.getUserName()));
        this.poolRuleService.updateById((Object)poolRule);
        this.poolMemberService.remove((Wrapper)new LambdaUpdateWrapper().eq(OpportunityPoolMember::getOppoPoolId, (Object)dto.getOppoPoolId()));
        this.poolMemberService.saveBatch(poolMemberList);
        return "\u4fdd\u5b58\u6210\u529f";
    }

    @Override
    public String updateOrderNum(UpdateOrderNumDto dto) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        this.baseConfigBoService.updateConfigValue(dto.getConfigValue(), OpportunityPoolConstant.CONFIG_KEY_OLD_POOL_FIRST);
        this.opportunityPoolMapper.updateOrderNum(dto.getDtoList(), userId, date);
        return "\u4fee\u6539\u6210\u529f";
    }

    @Override
    public Map<String, Object> selectOpportunityPoolList(OpportunityPoolDto dto) {
        Page page = dto.getPage();
        if (HussarUtils.isNotEmpty((Object)dto.getOppoPoolName())) {
            dto.setOppoPoolName(dto.getOppoPoolName().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        List<OpportunityPoolVO> voList = this.opportunityPoolMapper.selectOpportunityPoolPage(page, dto);
        for (OpportunityPoolVO poolVO : voList) {
            StringBuilder managerName = new StringBuilder();
            StringBuilder memberName = new StringBuilder();
            if (CollectionUtil.isNotEmpty(poolVO.getMemberVOList())) {
                for (OpportunityPoolMemberVO memberVO : poolVO.getMemberVOList()) {
                    if ("2".equals(memberVO.getMemberRole())) {
                        managerName.append(memberVO.getMemberName()).append("\u3001");
                        continue;
                    }
                    memberName.append(memberVO.getMemberName()).append("\u3001");
                }
            }
            if (managerName.length() > 0) {
                managerName.deleteCharAt(managerName.length() - 1);
            }
            if (memberName.length() > 0) {
                memberName.deleteCharAt(memberName.length() - 1);
            }
            poolVO.setManagerNameList(managerName.toString());
            poolVO.setMemberNameList(memberName.toString());
            poolVO.setMemberVOList(null);
        }
        page.setRecords(voList);
        String configValue = this.baseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OLD_POOL_FIRST).getConfigValue();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("page", page);
        resultMap.put("configValue", configValue);
        return resultMap;
    }

    @Override
    @Transactional
    public String opportunityPoolTransfer(OpportunityPoolTransferDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        SysStru stru = (SysStru)this.sysStruService.getById((Serializable)user.getDeptId());
        Long struId = stru.getId();
        String struName = stru.getOrganAlias();
        List oppoList = this.opportunityPoolOppoService.list((Wrapper)new LambdaUpdateWrapper().eq(OpportunityPoolOppo::getOppoPoolId, (Object)dto.getOldOppoPoolId()));
        OpportunityPool newPool = (OpportunityPool)this.opportunityPoolService.getById(dto.getNewOppoPoolId());
        OpportunityPool oldPool = (OpportunityPool)this.opportunityPoolService.getById(dto.getOldOppoPoolId());
        List recordList = oppoList.stream().map(oppo -> {
            HashMap<String, String> field = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
            HashMap<String, Object> before = new HashMap<String, Object>();
            HashMap<String, Object> after = new HashMap<String, Object>();
            before.put(OpportunityPoolEditConstant.OPPORTUNITY_POOL_ID.getField(), oldPool.getOppoPoolId());
            after.put(OpportunityPoolEditConstant.OPPORTUNITY_POOL_ID.getField(), newPool.getOppoPoolId());
            before.put(OpportunityPoolEditConstant.OPPORTUNITY_POOL_NAME.getField(), oldPool.getOppoPoolName());
            after.put(OpportunityPoolEditConstant.OPPORTUNITY_POOL_NAME.getField(), newPool.getOppoPoolName());
            field.put("field", OpportunityPoolEditConstant.OPPORTUNITY_POOL_NAME.getField());
            field.put("fieldName", OpportunityPoolEditConstant.OPPORTUNITY_POOL_NAME.getName());
            changeField.add(field);
            return OpportunityPoolManageServiceImpl.getTrackRecord(oppo.getOpportunityId(), oppo.getOpportunityName(), CrmBusinessTypeEnum.OPPORTUNITY.getId(), date, userId, userName, JSON.toJSONString(before), JSON.toJSONString(after), JSON.toJSONString(changeField), RecordProductTypeEnum.PRODUCE_POOL_TRANSFER.getId(), null);
        }).collect(Collectors.toList());
        this.operateRecordAPIService.saveOperateLogBatch(recordList);
        this.opportunityPoolOppoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(OpportunityPoolOppo::getOppoPoolId, (Object)dto.getOldOppoPoolId())).set(OpportunityPoolOppo::getOppoPoolId, (Object)dto.getNewOppoPoolId())).set(OpportunityPoolOppo::getChangeTime, (Object)date)).set(OpportunityPoolOppo::getChangePerson, (Object)userId)).set(OpportunityPoolOppo::getChangePersonName, (Object)user.getUserName())).set(OpportunityPoolOppo::getLastJoinTime, (Object)date)).set(OpportunityPoolOppo::getLastJoinUser, (Object)userId)).set(OpportunityPoolOppo::getLastJoinUserName, (Object)user.getUserName())).set(OpportunityPoolOppo::getLastJoinType, (Object)OpportunityPoolConstant.JOIN_TYPE_TRANS)).set(OpportunityPoolOppo::getLastJoinReason, null));
        return "\u8f6c\u79fb\u6210\u529f";
    }

    @Override
    @Transactional
    public ApiResponse<String> opportunityPoolDelete(OpportunityPoolDto dto) {
        Long poolId = dto.getOppoPoolId();
        long count = this.opportunityPoolOppoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityPoolOppo::getOppoPoolId, (Object)poolId)).eq(OpportunityPoolOppo::getDelFlag, (Object)"0"));
        if (count > 0L) {
            return ApiResponse.fail((String)("\u516c\u6d77\u6c60\u5185\u6709" + count + "\u6761\u5546\u673a\uff0c\u65e0\u6cd5\u5220\u9664"));
        }
        long targetCount = this.publicPoolRuleService.count((Wrapper)new LambdaQueryWrapper().eq(PublicPoolRule::getTransTarget, (Object)poolId));
        if (targetCount > 0L) {
            return ApiResponse.fail((String)"\u516c\u6d77\u6c60\u88ab\u8bbe\u7f6e\u4e3a\u5176\u4ed6\u516c\u6d77\u6c60\u7684\u81ea\u52a8\u8f6c\u79fb\u76ee\u6807\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OpportunityPool::getDelFlag, (Object)"1")).eq(OpportunityPool::getOppoPoolId, (Object)String.valueOf(poolId)));
        this.poolMemberService.remove((Wrapper)new LambdaQueryWrapper().eq(OpportunityPoolMember::getOppoPoolId, (Object)poolId));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public OpportunityPoolVO selectDetail(OpportunityPoolDto dto) {
        Long poolId = dto.getOppoPoolId();
        OpportunityPool opportunityPool = (OpportunityPool)this.getById(poolId);
        List managerList = this.opportunityPoolMemberMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityPoolMember::getOppoPoolId, (Object)poolId)).eq(OpportunityPoolMember::getMemberRole, (Object)OpportunityPoolConstant.POOL_MEMBER_ROLE_MANAGER));
        List memberList = this.opportunityPoolMemberMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityPoolMember::getOppoPoolId, (Object)poolId)).eq(OpportunityPoolMember::getMemberRole, (Object)OpportunityPoolConstant.POOL_MEMBER_ROLE_NORMAL));
        PublicPoolRule poolRule = (PublicPoolRule)((Object)this.publicPoolRuleService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PublicPoolRule::getPublicPoolRuleId, (Object)opportunityPool.getOppoPoolRuleId())).eq(PublicPoolRule::getDelFlag, (Object)"0")).eq(PublicPoolRule::getPublicPoolRuleModule, (Object)OpportunityPoolConstant.RULE_MODULE_OPPORTUNITY_POOL)));
        OpportunityPoolVO vo = (OpportunityPoolVO)BeanUtil.copy((Object)opportunityPool, OpportunityPoolVO.class);
        vo.setMemberVOList(BeanUtil.copy((Collection)memberList, OpportunityPoolMemberVO.class));
        vo.setManagerVOList(BeanUtil.copy((Collection)managerList, OpportunityPoolMemberVO.class));
        vo.setPoolRuleVo((PublicPoolRuleVo)BeanUtil.copy((Object)((Object)poolRule), PublicPoolRuleVo.class));
        return vo;
    }

    @Override
    public ApiResponse<Map<String, Object>> selectCountAndNameList(OpportunityPoolDto dto) {
        Long poolId = dto.getOppoPoolId();
        List<Map<String, Object>> idNameMapList = this.opportunityPoolMapper.selectIdNameMapListExcludeSelf(poolId, null, null, null);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (poolId != null) {
            long count = this.opportunityPoolOppoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityPoolOppo::getOppoPoolId, (Object)poolId)).eq(OpportunityPoolOppo::getDelFlag, (Object)"0"));
            resultMap.put("count", count);
        }
        resultMap.put("idNameList", idNameMapList);
        return ApiResponse.success(resultMap);
    }

    @Override
    public List<Map<String, Object>> selectIdNameList(OpportunityPoolDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        List<Long> roleList = user.getRolesList();
        List deptIdList = this.organUserBoService.getParentOrganIncludeOneself(Collections.singletonList(user.getDeptId()));
        Long poolId = dto.getOppoPoolId();
        roleList = roleList.stream().distinct().collect(Collectors.toList());
        List<Map<String, Object>> idNameMapList = this.opportunityPoolMapper.selectIdNameMapListExcludeSelf(poolId, userId, deptIdList, roleList);
        return idNameMapList;
    }

    @Override
    @Transactional
    public ApiResponse<String> releaseToPublicPool(ReleaseToPublicPoolBatchDto dto) {
        if (CollectionUtil.isEmpty(dto.getOpportunityIdList())) {
            return ApiResponse.fail((String)"\u672a\u9009\u62e9\u5546\u673a");
        }
        List<Long> opportunityIdList = dto.getOpportunityIdList();
        Long poolId = dto.getOpportunityPoolId();
        OpportunityPool pool = (OpportunityPool)this.getById(poolId);
        String reason = dto.getReason();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        List opportunityList = this.opportunityService.listByIds(opportunityIdList);
        if (opportunityList.size() != opportunityIdList.size()) {
            if (dto.getOpportunityIdList().size() == 1) {
                return ApiResponse.fail((String)"\u9009\u62e9\u7684\u5546\u673a\u5df2\u4e0d\u5b58\u5728");
            }
            return ApiResponse.fail((String)"\u9009\u62e9\u7684\u90e8\u5206\u5546\u673a\u5df2\u4e0d\u5b58\u5728");
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List winStageIdList = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        for (Long winStageId : winStageIdList) {
            if (!opportunityList.stream().map(OpportunityEntity::getCustomerStageId).collect(Collectors.toList()).contains(winStageId.toString())) continue;
            if (opportunityList.size() > 1) {
                return ApiResponse.fail((String)"\u9009\u62e9\u7684\u90e8\u5206\u5546\u673a\u5df2\u8d62\u5355");
            }
            return ApiResponse.fail((String)"\u5f53\u524d\u5546\u673a\u5df2\u8d62\u5355");
        }
        List<OpportunityPoolOppo> poolOppoList = opportunityList.stream().map(opportunityEntity -> OpportunityPoolManageServiceImpl.getPoolOppoByOpportunityEntity(opportunityEntity, poolId, pool.getOppoPoolName(), date, reason, user)).collect(Collectors.toList());
        this.opportunityPoolOppoService.saveBatch(poolOppoList);
        this.teamMeberService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TeamMeberEntity::getBusinessType, (Object)"2")).in(TeamMeberEntity::getBusinessId, opportunityIdList)).set(TeamMeberEntity::getDelFlag, (Object)"1"));
        this.opportunityService.removeByIds(opportunityIdList);
        this.taskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskEntity::getBusinessType, (Object)"2")).in(TaskEntity::getBusinessId, opportunityIdList)).ne(TaskEntity::getState, (Object)"2")).set(TaskEntity::getState, (Object)"3")).set(TaskEntity::getLastTime, (Object)date));
        List recordList = opportunityList.stream().map(oppo -> {
            HashMap<String, String> field = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
            HashMap<String, Object> before = new HashMap<String, Object>();
            HashMap<String, Object> after = new HashMap<String, Object>();
            before.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), oppo.getChargePersonId());
            after.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), poolId);
            before.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), oppo.getChargePersonName());
            after.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), pool.getOppoPoolName());
            field.put("field", OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField());
            field.put("fieldName", OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getName());
            changeField.add(field);
            return OpportunityPoolManageServiceImpl.getTrackRecord(oppo.getOpportunityId(), oppo.getOpportunityName(), CrmBusinessTypeEnum.OPPORTUNITY.getId(), date, userId, userName, JSON.toJSONString(before), JSON.toJSONString(after), JSON.toJSONString(changeField), RecordProductTypeEnum.PRODUCE_POOL_MANUAL_RELEASE.getId(), reason);
        }).collect(Collectors.toList());
        this.operateRecordAPIService.saveOperateLogBatch(recordList);
        poolOppoList.removeIf(opportunityPoolOppo -> Objects.equals(userId, opportunityPoolOppo.getOldChargerPerson()));
        this.pushMessage(poolOppoList, userName, date);
        return ApiResponse.success((String)"\u91ca\u653e\u6210\u529f");
    }

    private void pushMessage(List<OpportunityPoolOppo> poolOppoList, String userName, LocalDateTime date) {
        List messagePushList = this.messageTemplateService.getMessagePushList("6");
        MessagePushVo pushToWeb = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("1")).collect(Collectors.toList()).get(0);
        MessagePushVo pushToMobile = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("2")).collect(Collectors.toList()).get(0);
        for (OpportunityPoolOppo oppo : poolOppoList) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userName", userName);
            params.put("opportunityName", oppo.getOpportunityName());
            params.put("poolName", oppo.getOppoPoolName());
            this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", date, params, Collections.singletonList(oppo.getOldChargerPerson()));
            this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", date, params, Collections.singletonList(oppo.getOldChargerPerson()));
        }
    }

    @Override
    public ApiResponse<Map<String, String>> opportunityPoolStatus() {
        String configValue = this.baseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("configValue", configValue);
        return ApiResponse.success(map);
    }

    @Override
    public ApiResponse<String> changePoolStatus(Map<String, String> map) {
        long countPool = this.count((Wrapper)new LambdaQueryWrapper().eq(OpportunityPool::getDelFlag, (Object)"0"));
        String value = map.get("configKey");
        if (countPool > 0L && "0".equals(value)) {
            return ApiResponse.fail((String)"\u5b58\u5728\u5546\u673a\u516c\u6d77\u6c60\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed");
        }
        boolean flag = this.baseConfigBoService.updateConfigValue(value, OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL);
        if (flag) {
            return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @NotNull
    private static OpportunityPoolOppo getPoolOppoByOpportunityEntity(OpportunityEntity opportunity, Long poolId, String poolName, LocalDateTime date, String reason, SecurityUser user) {
        OpportunityPoolOppo poolOppo = (OpportunityPoolOppo)BeanUtil.copy((Object)opportunity, OpportunityPoolOppo.class);
        poolOppo.setOppoPoolId(poolId);
        poolOppo.setOppoPoolName(poolName);
        poolOppo.setOldChargerPerson(opportunity.getChargePersonId());
        poolOppo.setOldChargerPersonName(opportunity.getChargePersonName());
        poolOppo.setLastJoinTime(date);
        poolOppo.setLastJoinReason(reason);
        poolOppo.setLastJoinType(OpportunityPoolConstant.JOIN_TYPE_MANUAL);
        poolOppo.setChangeTime(date);
        poolOppo.setChangePerson(user.getUserId());
        poolOppo.setChangePersonName(user.getUserName());
        poolOppo.setLastJoinUser(user.getUserId());
        poolOppo.setLastJoinUserName(user.getUserName());
        poolOppo.setChargePersonId(null);
        poolOppo.setChargePersonName(null);
        poolOppo.setOwnDepartment(null);
        poolOppo.setOwnDepartmentName(null);
        return poolOppo;
    }

    @NotNull
    private static OperateRecordAPIVo getTrackRecord(Long typeId, String businessName, String businessType, LocalDateTime date, Long userId, String userName, String before, String after, String changeField, String produceId, String content) {
        OperateRecordAPIVo record = new OperateRecordAPIVo();
        record.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        record.setProduceType(produceId);
        record.setBusinessType(businessType);
        record.setTypeId(typeId);
        record.setBusinessName(businessName);
        record.setChangeBefore(before);
        record.setChangeAfter(after);
        record.setChangeField(changeField);
        record.setCreateTime(date);
        record.setChangeTime(date);
        record.setCreatePerson(userId);
        record.setChangePerson(userId);
        record.setCreatePersonName(userName);
        record.setChangePersonName(userName);
        record.setChangePerson(userId);
        record.setChangePersonName(userName);
        record.setRecordContent(content);
        record.setChangeBatch(1);
        record.setDelflag("0");
        return record;
    }
}

