/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import com.jxdinfo.crm.core.utills.ExcelHeader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.multipart.MultipartFile;

public class ReadExcel {
    public static <T> List<T> readExcel(MultipartFile file, Class<T> clazz) throws Exception {
        return ReadExcel.readExcel(file, clazz, null);
    }

    public static <T> List<T> readExcel(MultipartFile file, Class<T> clazz, Integer dynamicRows) throws Exception {
        Field[] fields;
        ArrayList<T> resultList = new ArrayList<T>();
        byte[] byteArr = file.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(byteArr);
        String name = Objects.requireNonNull(file.getOriginalFilename()).toLowerCase();
        if (!name.contains(".xlsx") && !name.contains(".xls")) {
            throw new Exception();
        }
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        Sheet sheet = workbook.getSheetAt(0);
        int totalRowNum = sheet.getLastRowNum();
        int cellLength = 0;
        int headRowLength = 0;
        for (Field field : fields = clazz.getDeclaredFields()) {
            Field[] excelHeader = (Field[])AnnotationUtils.getAnnotation((AnnotatedElement)field, ExcelHeader.class);
            String[] titles = excelHeader.value();
            if (titles.length == 1 && titles[0].equals("")) continue;
            ++cellLength;
            headRowLength = Math.max(titles.length, headRowLength);
        }
        Field[] newFields = new Field[cellLength];
        if (null != dynamicRows && 0 != dynamicRows) {
            headRowLength += dynamicRows.intValue();
        }
        Row headRow = sheet.getRow(headRowLength - 1);
        block1: for (int i = 0; i < cellLength; ++i) {
            Cell cell = headRow.getCell(i);
            for (Field field : fields) {
                String[] annoValues = field.getAnnotation(ExcelHeader.class).value();
                if (!ReadExcel.getXCellVal(cell).equals(annoValues[annoValues.length - 1])) continue;
                newFields[i] = field;
                continue block1;
            }
        }
        for (int x = headRowLength; x <= totalRowNum; ++x) {
            T object = clazz.newInstance();
            Row row = sheet.getRow(x);
            int a = 0;
            for (int y = 0; y < cellLength; ++y) {
                if (row == null) continue;
                Cell cell = row.getCell(y);
                if (cell == null) {
                    ++a;
                    continue;
                }
                Field field = newFields[y];
                String value = ReadExcel.getXCellVal(cell);
                if (value != null && !value.equals("")) {
                    ReadExcel.setValue(field, value, object);
                    continue;
                }
                ++a;
            }
            if (a == cellLength || row == null) continue;
            resultList.add(object);
        }
        return resultList;
    }

    private static void setValue(Field field, String value, Object object) {
        try {
            if (field != null) {
                field.setAccessible(true);
                SimpleDateFormat datefmt = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat dateTimefmt = new SimpleDateFormat("yyyy-MM-dd");
                if (field.getGenericType().toString().contains("Integer")) {
                    field.set(object, Integer.valueOf(value));
                } else if (field.getGenericType().toString().contains("String")) {
                    field.set(object, value);
                } else if (field.getGenericType().toString().contains("Date")) {
                    field.set(object, datefmt.parse(value));
                } else if (field.getGenericType().toString().contains("Timestamp")) {
                    Timestamp timestamp = new Timestamp(dateTimefmt.parse(value).getTime());
                    field.set(object, timestamp);
                }
                field.setAccessible(false);
            }
        }
        catch (IllegalArgumentException | NullPointerException | ParseException e) {
            throw new NullPointerException();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getXCellVal(Cell cell) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DecimalFormat df = new DecimalFormat("0.0000");
        String val = "";
        switch (cell.getCellTypeEnum()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    val = fmt.format(cell.getDateCellValue());
                    break;
                }
                val = df.format(cell.getNumericCellValue());
                val = val.replaceAll("0+?$", "").replaceAll("[.]$", "");
                break;
            }
            case STRING: {
                val = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                val = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case BLANK: {
                val = cell.getStringCellValue();
                break;
            }
            case ERROR: {
                break;
            }
            case FORMULA: {
                try {
                    val = String.valueOf(cell.getStringCellValue());
                }
                catch (IllegalStateException e) {
                    val = String.valueOf(cell.getNumericCellValue());
                }
                break;
            }
            default: {
                val = cell.getRichStringCellValue() == null ? null : cell.getRichStringCellValue().toString();
            }
        }
        return val;
    }
}

