/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.service.impl;

import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.leads.service.ILeadDataRightModuleService;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityDataRightModuleService;
import com.jxdinfo.crm.core.leads.dao.LeadsPermissionMapper;
import com.jxdinfo.crm.core.leads.service.ILeadsPermissionService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LeadsPermissionServiceImpl
implements ILeadsPermissionService {
    @Resource
    private LeadsPermissionMapper leadsPermissionMapper;
    @Resource
    private ILeadDataRightModuleService leadDataRightModuleService;
    @Resource
    private IMarketingActivityDataRightModuleService marketingActivityDataRightModuleService;
    @Resource
    private IUserBoService userBoService;

    @Override
    public List<Long> getLeadsIdListByPermission(Long userId) {
        SecurityUser user = userId == null ? BaseSecurityUtil.getUser() : this.userBoService.selectSecurityByUserId(userId);
        PermissionDto permissionDto = this.leadDataRightModuleService.getUserRolePermission(user);
        if (permissionDto.getPermissionDeptIds() == null && permissionDto.getPermissionUserId() == null) {
            return null;
        }
        PermissionDto campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        List<Long> leadsIdList = this.leadsPermissionMapper.getLeadsIdList(permissionDto, campaignPermissionDto);
        if (CollectionUtil.isEmpty(leadsIdList)) {
            leadsIdList.add(-1L);
        }
        return leadsIdList;
    }
}

