/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.jxdIM.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.jxdIM.dao.CrmTeamImGroupMapper;
import com.jxdinfo.crm.core.jxdIM.dto.BusinessTypeAndIds;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.dto.GroupAdminDTO;
import com.jxdinfo.crm.core.jxdIM.dto.ImContactDto;
import com.jxdinfo.crm.core.jxdIM.dto.ImUser;
import com.jxdinfo.crm.core.jxdIM.model.CrmTeamImGroupEntity;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupService;
import com.jxdinfo.crm.core.jxdIM.util.HttpClientUtil;
import com.jxdinfo.crm.core.jxdIM.util.ImTokenUtil;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="crm.eim", name={"add-member"}, havingValue="true")
public class ImGroupMemberServiceImpl
implements ImGroupMemberService {
    private static Logger log = LogManager.getLogger(ImGroupMemberServiceImpl.class);
    @Resource
    private ImGroupService imGroupService;
    @Resource
    private CrmTeamImGroupMapper crmTeamImGroupMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CommonMapper commonMapper;

    @Override
    public int addGroupMembers(List<TeamMeberEntity> memberList) {
        String data;
        if (CollectionUtil.isEmpty(memberList)) {
            return 0;
        }
        String businessId = memberList.get(0).getBusinessId() == null ? null : memberList.get(0).getBusinessId().toString();
        String businessType = memberList.get(0).getBusinessType();
        CrmTeamImGroupEntity crmTeamImGroupEntity = (CrmTeamImGroupEntity)((Object)this.imGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmTeamImGroupEntity::getBusinessId, (Object)businessId)).eq(CrmTeamImGroupEntity::getBusinessType, (Object)businessType)));
        if (crmTeamImGroupEntity == null) {
            return 0;
        }
        List<ImUser> imUserList = this.imGroupService.teamMemberToGroupMember(memberList, null);
        ImContactDto imContactDto = new ImContactDto();
        imContactDto.setUsers(imUserList);
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        List<SysUsers> usersList = this.commonMapper.getSysUserChar1ByIds(Collections.singletonList(userId));
        String imUrl = this.crmProperties.getEim().getEimUrl();
        String imGroupId = crmTeamImGroupEntity.getImGroupId();
        StringBuffer url = new StringBuffer(imUrl).append("/im/v2/groups/addUser?roomID=").append(imGroupId).append("&inviteUserID=").append(usersList.get(0).getId());
        String jsonBody = JSONObject.toJSONString((Object)imContactDto);
        String imToken = ImTokenUtil.getIMToken();
        Map<String, Object> returnMap = HttpClientUtil.post(url.toString(), jsonBody, imToken, "eim_push");
        String string = data = returnMap.get("data") == null ? null : returnMap.get("data").toString();
        if ("true".equals(data)) {
            log.info("\u6dfb\u52a0\u56e2\u961f\u6210\u5458\u5230\u7fa4\u804a\u4e2d\u6210\u529f");
            return 1;
        }
        log.info("\u5c06\u56e2\u961f\u6210\u5458\u3010" + jsonBody + "\u3011\u6dfb\u52a0\u5230\u7fa4\u804a\u3010" + imGroupId + "\u3011\u4e2d\u5931\u8d25");
        return 0;
    }

    @Override
    public int addGroupMembersBatch(List<BusinessTypeAndIds> businessList, List<TeamMeberEntity> memberList) {
        String data;
        if (CollectionUtil.isEmpty(memberList) || CollectionUtil.isEmpty(businessList)) {
            return 0;
        }
        List<CrmTeamImGroupEntity> crmTeamImGroupEntityList = this.crmTeamImGroupMapper.selectByBusinessBatch(businessList);
        if (CollectionUtil.isEmpty(crmTeamImGroupEntityList)) {
            return 0;
        }
        String roomIdList = crmTeamImGroupEntityList.stream().map(CrmTeamImGroupEntity::getImGroupId).collect(Collectors.joining(","));
        List<ImUser> imUserList = this.imGroupService.teamMemberToGroupMember(memberList, null);
        ImContactDto imContactDto = new ImContactDto();
        imContactDto.setUsers(imUserList);
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        List<SysUsers> usersList = this.commonMapper.getSysUserChar1ByIds(Collections.singletonList(userId));
        String imUrl = this.crmProperties.getEim().getEimUrl();
        StringBuffer url = new StringBuffer(imUrl).append("/im/v2/groups/joinMultiGroups?inviteUserID=").append(usersList.get(0).getId()).append("&userID=").append(userId).append("&roomIDList=").append(roomIdList);
        String jsonBody = JSONObject.toJSONString((Object)imContactDto);
        String imToken = ImTokenUtil.getIMToken();
        Map<String, Object> returnMap = HttpClientUtil.post(url.toString(), jsonBody, imToken, "eim_push");
        String string = data = returnMap.get("data") == null ? null : returnMap.get("data").toString();
        if ("true".equals(data)) {
            log.info("\u6dfb\u52a0\u56e2\u961f\u6210\u5458\u5230\u7fa4\u804a\u4e2d\u6210\u529f");
            return 1;
        }
        log.info("\u5c06\u56e2\u961f\u6210\u5458\u3010" + jsonBody + "\u3011\u6dfb\u52a0\u5230\u7fa4\u804a\u3010" + roomIdList + "\u3011\u4e2d\u5931\u8d25");
        return 0;
    }

    @Override
    public int addToGroup(String imGroupId) {
        String data;
        if (StringUtil.isEmpty((Object)imGroupId)) {
            return 0;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
        teamMeberEntity.setPersonId(userId);
        ArrayList<TeamMeberEntity> memberList = new ArrayList<TeamMeberEntity>();
        memberList.add(teamMeberEntity);
        List<ImUser> imUserList = this.imGroupService.teamMemberToGroupMember(memberList, null);
        ImContactDto imContactDto = new ImContactDto();
        imContactDto.setUsers(imUserList);
        String imUrl = this.crmProperties.getEim().getEimUrl();
        StringBuffer url = new StringBuffer(imUrl).append("/im/v2/groups/addUser?roomID=").append(imGroupId).append("&userId=").append(userId);
        String jsonBody = JSONObject.toJSONString((Object)imContactDto);
        String imToken = ImTokenUtil.getIMToken();
        Map<String, Object> returnMap = HttpClientUtil.post(url.toString(), jsonBody, imToken, "eim_push");
        String string = data = returnMap.get("data") == null ? null : returnMap.get("data").toString();
        if ("true".equals(data)) {
            log.info("\u52a0\u5165\u7fa4\u804a\u6210\u529f");
            return 1;
        }
        log.info("\u3010" + jsonBody + "\u3011\u52a0\u5165\u7fa4\u804a\u3010" + imGroupId + "\u3011\u5931\u8d25");
        return 0;
    }

    @Override
    public int removeGroupMembers(List<Long> ids) {
        String data;
        List list = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getTeamMeberId, ids)).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return 0;
        }
        String businessType = ((TeamMeberEntity)((Object)list.get(0))).getBusinessType();
        Long businessId = ((TeamMeberEntity)((Object)list.get(0))).getBusinessId();
        CrmTeamImGroupEntity entity = (CrmTeamImGroupEntity)((Object)this.imGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmTeamImGroupEntity::getBusinessId, (Object)businessId)).eq(CrmTeamImGroupEntity::getBusinessType, (Object)businessType)));
        if (entity == null) {
            return 0;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        List<ImUser> imUserList = this.imGroupService.teamMemberToGroupMember(list, null);
        List<SysUsers> usersList = this.commonMapper.getSysUserChar1ByIds(Collections.singletonList(user.getUserId()));
        String url = this.crmProperties.getEim().getEimUrl() + "/im/v2/groups/deleteUser?roomID=" + entity.getImGroupId() + "&userId=" + usersList.get(0).getId();
        String imToken = ImTokenUtil.getIMToken();
        String jsonBody = JSONObject.toJSONString(imUserList);
        Map<String, Object> returnMap = HttpClientUtil.post(url, jsonBody, imToken, "eim_push");
        String string = data = returnMap.get("data") == null ? null : returnMap.get("data").toString();
        if ("true".equals(data)) {
            log.info("\u5c06\u56e2\u961f\u6210\u5458\u5728\u7fa4\u804a\u4e2d\u5220\u9664\u6210\u529f");
            return 1;
        }
        log.info("\u5c06\u56e2\u961f\u6210\u5458\u3010" + jsonBody + "\u3011\u5728\u7fa4\u804a\u4e2d\u5220\u9664\u5931\u8d25");
        return 0;
    }

    @Override
    public void transferAdmin(List<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        CompletableFuture.runAsync(() -> {
            String data;
            if (CollectionUtil.isEmpty((Collection)crmTeamAdminInfoDtoList)) {
                return;
            }
            HashMap<String, ArrayList<Long>> businessIdByType = new HashMap<String, ArrayList<Long>>();
            ArrayList<BusinessTypeAndIds> businessTypeAndIdsList = new ArrayList<BusinessTypeAndIds>();
            for (CrmTeamAdminInfoDto crmTeamAdminInfoDto : crmTeamAdminInfoDtoList) {
                String businessType = crmTeamAdminInfoDto.getBusinessType();
                Long businessId = crmTeamAdminInfoDto.getBusinessId();
                ArrayList<Long> businessIdList = (ArrayList<Long>)businessIdByType.get(businessType);
                if (CollectionUtil.isEmpty((Collection)businessIdList)) {
                    businessIdList = new ArrayList<Long>();
                    BusinessTypeAndIds businessTypeAndIds = new BusinessTypeAndIds();
                    businessTypeAndIds.setBusinessType(businessType);
                    businessTypeAndIds.setBusinessIdList(businessIdList);
                    businessTypeAndIdsList.add(businessTypeAndIds);
                }
                businessIdList.add(businessId);
                businessIdByType.put(businessType, businessIdList);
            }
            if (CollectionUtil.isEmpty(businessTypeAndIdsList)) {
                return;
            }
            List<CrmTeamImGroupEntity> crmTeamImGroupEntityList = this.crmTeamImGroupMapper.selectByBusinessBatch(businessTypeAndIdsList);
            if (CollectionUtil.isEmpty(crmTeamImGroupEntityList)) {
                return;
            }
            Map<Long, String> businessIdToRoomIdMap = crmTeamImGroupEntityList.stream().collect(Collectors.toMap(CrmTeamImGroupEntity::getBusinessId, CrmTeamImGroupEntity::getImGroupId));
            if (CollectionUtil.isEmpty(businessIdToRoomIdMap)) {
                return;
            }
            ArrayList<Long> userIdList = new ArrayList<Long>();
            for (Object crmTeamAdminInfoDto : crmTeamAdminInfoDtoList) {
                try {
                    Long newChargePersonId = Long.parseLong(((CrmTeamAdminInfoDto)crmTeamAdminInfoDto).getNewChargePersonId());
                    Long oldChargePersonId = Long.parseLong(((CrmTeamAdminInfoDto)crmTeamAdminInfoDto).getOldChargePersonId());
                    userIdList.add(newChargePersonId);
                    userIdList.add(oldChargePersonId);
                }
                catch (Exception e) {
                    log.info(JSONObject.toJSONString((Object)crmTeamAdminInfoDto));
                }
            }
            ArrayList<GroupAdminDTO> groupAdminDTOList = new ArrayList<GroupAdminDTO>();
            for (CrmTeamAdminInfoDto crmTeamAdminInfoDto : crmTeamAdminInfoDtoList) {
                Long businessId = crmTeamAdminInfoDto.getBusinessId();
                String roomId = businessIdToRoomIdMap.get(businessId);
                if (StringUtil.isEmpty((Object)roomId)) continue;
                GroupAdminDTO groupAdminDTO = new GroupAdminDTO();
                groupAdminDTO.setRoomID(roomId);
                groupAdminDTO.setUserID(crmTeamAdminInfoDto.getNewChargePersonId());
                groupAdminDTO.setAdminID(crmTeamAdminInfoDto.getOldChargePersonId());
                groupAdminDTO.setQuit("1");
                if ("1".equals(crmTeamAdminInfoDto.getKeepFlag())) {
                    groupAdminDTO.setQuit("0");
                }
                groupAdminDTOList.add(groupAdminDTO);
            }
            String url = this.crmProperties.getEim().getEimUrl() + "/im/v2/groups/transfer?userId=" + userId;
            String imToken = ImTokenUtil.getIMToken();
            String jsonBody = JSONObject.toJSONString(groupAdminDTOList);
            Map<String, Object> returnMap = HttpClientUtil.post(url, jsonBody, imToken, "eim_push");
            String string = data = returnMap.get("data") == null ? null : returnMap.get("data").toString();
            if ("true".equals(data)) {
                log.info("\u8f6c\u8ba9\u7fa4\u804a\u6210\u529f");
                log.info("\u4e1a\u52a1\u7c7b\u578b\uff1a" + ((CrmTeamAdminInfoDto)crmTeamAdminInfoDtoList.get(0)).getBusinessType());
            } else {
                log.info("\u3010" + jsonBody + "\u3011\u8f6c\u8ba9\u5931\u8d25");
            }
        });
    }

    @Override
    public int getUnreadMsgNum() {
        int num;
        SecurityUser user = BaseSecurityUtil.getUser();
        List<SysUsers> list = this.commonMapper.getSysUserChar1ByIds(CollectionUtil.toList((Object[])new Long[]{user.getUserId()}));
        if (CollectionUtil.isEmpty(list)) {
            return 0;
        }
        Long imId = list.get(0).getId();
        String url = this.crmProperties.getEim().getEimUrl() + "/im/v1/message/getUnreadMsgNumCRM?userId=" + imId;
        String imToken = ImTokenUtil.getIMToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("client-id", "eim_push");
        header.put("Authorization", imToken);
        Map<String, Object> result = HttpClientUtil.get(url, header);
        try {
            num = (Integer)result.get("data");
        }
        catch (Exception e) {
            num = 0;
        }
        return num;
    }
}

