/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.message.service.IMessagePushService;
import com.jxdinfo.crm.common.api.message.service.IMessageTemplateService;
import com.jxdinfo.crm.common.api.message.vo.MessagePushVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.sysCalendar.dto.DayTypeDto;
import com.jxdinfo.crm.common.api.sysCalendar.dto.RecycleReasonDate;
import com.jxdinfo.crm.common.api.sysCalendar.service.ISysCalendarBoService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dao.OpportunityPoolRuleMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.OpportunityPool;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.OpportunityPoolMember;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.RulePoolTrans;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.RuleRecycle;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.ScheduledMsgTemp;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.WhiteListMember;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IOpportunityPoolMemberService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IScheduledMsgTempService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.OpportunityPoolService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OppoRecycleMessageVo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OppoRuleVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OpportunityPoolMemberVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.ReRecycleVo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.RuleRecycleVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.model.OpportunityPoolOppo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.service.OpportunityPoolOppoService;
import com.jxdinfo.crm.core.job.model.OpportunityRecycleReason;
import com.jxdinfo.crm.core.job.service.IOpportunityPoolRemindService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpportunityPoolRemindServiceImpl
implements IOpportunityPoolRemindService {
    @Resource
    private OpportunityPoolRuleMapper opportunityPoolRuleMapper;
    @Resource
    private ISysCalendarBoService calendarBoService;
    @Resource
    private OpportunityPoolOppoService opportunityPoolOppoService;
    @Resource
    private OpportunityPoolService opportunityPoolService;
    @Resource
    private IOpportunityPoolMemberService opportunityPoolMemberService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ICrmBaseConfigBoService baseConfigBoService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private IScheduledMsgTempService scheduledMsgTempService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private IMessagePushService messagePushService;
    @Resource
    private IMessageTemplateService messageTemplateService;

    @Override
    @Transactional
    public ProcessResult remind() {
        try {
            LocalDateTime dateTimeNow = LocalDateTime.now();
            ArrayList<OpportunityEntity> updateRecycleTimeList = new ArrayList<OpportunityEntity>();
            this.poolAddOppoRemind(dateTimeNow);
            this.todayMsgPush(dateTimeNow);
            this.recycleWarningRemind(dateTimeNow, updateRecycleTimeList);
            this.transWarningRemind(dateTimeNow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ProcessResult(true);
    }

    private void poolAddOppoRemind(LocalDateTime dateTimeNow) {
        LocalDateTime startTime = dateTimeNow.minusDays(1L);
        List list = this.opportunityPoolOppoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityPoolOppo::getDelFlag, (Object)"0")).gt(OpportunityPoolOppo::getLastJoinTime, (Object)startTime)).le(OpportunityPoolOppo::getLastJoinTime, (Object)dateTimeNow));
        if (list.isEmpty()) {
            return;
        }
        Map<Long, List<OpportunityPoolOppo>> poolIdOppoMap = list.stream().collect(Collectors.groupingBy(OpportunityPoolOppo::getOppoPoolId));
        HashMap memberMsgMap = new HashMap();
        List<OppoRuleVO> ruleList = this.opportunityPoolRuleMapper.selectAllRecyclePoolRule();
        for (OppoRuleVO oppoRuleVO : ruleList) {
            List memberList = oppoRuleVO.getMemberVOList().stream().filter(o -> OpportunityPoolConstant.POOL_MEMBER_ROLE_NORMAL.equals(o.getMemberRole())).collect(Collectors.toList());
            ArrayList<Long> personIdList = new ArrayList<Long>();
            ArrayList<Long> deptIdList = new ArrayList<Long>();
            for (OpportunityPoolMemberVO memberVO : memberList) {
                if (OpportunityPoolConstant.POOL_MEMBER_TYPE_USER.equals(memberVO.getMemberType())) {
                    personIdList.add(memberVO.getMemberId());
                    continue;
                }
                if (OpportunityPoolConstant.POOL_MEMBER_TYPE_ROLE.equals(memberVO.getMemberType())) {
                    List<String> userIds = this.commonMapper.getUserByRoleId(memberVO.getMemberId());
                    personIdList.addAll(userIds.stream().map(Long::parseLong).collect(Collectors.toList()));
                    continue;
                }
                if (!OpportunityPoolConstant.POOL_MEMBER_TYPE_STRU.equals(memberVO.getMemberType())) continue;
                deptIdList.add(memberVO.getMemberId());
            }
            List userVos = this.organUserBoService.getUserListByDepartmentId(deptIdList);
            personIdList.addAll(userVos.stream().map(UserVo::getId).distinct().collect(Collectors.toList()));
            List<OpportunityPoolOppo> oppoList = poolIdOppoMap.get(oppoRuleVO.getOppoPoolId());
            if (!CollectionUtil.isNotEmpty(oppoList)) continue;
            for (Long personId : personIdList) {
                if (memberMsgMap.containsKey(personId)) {
                    ((List)memberMsgMap.get(personId)).add("\u516c\u6d77\u6c60\u540d\u79f0\uff1a" + oppoRuleVO.getOppoPoolName() + "\uff0c\u6628\u65e5\u65b0\u589e" + oppoList.size() + "\u6761\u5546\u673a\uff1b");
                    continue;
                }
                memberMsgMap.put(personId, new ArrayList());
                ((List)memberMsgMap.get(personId)).add("\u516c\u6d77\u6c60\u540d\u79f0\uff1a" + oppoRuleVO.getOppoPoolName() + "\uff0c\u6628\u65e5\u65b0\u589e" + oppoList.size() + "\u6761\u5546\u673a\uff1b");
            }
        }
        SecurityUser user = new SecurityUser();
        user.setUserId(Long.valueOf(1450756958461300737L));
        user.setDeptId(Long.valueOf(-1L));
        for (Map.Entry entry : memberMsgMap.entrySet()) {
            String userId = String.valueOf(entry.getKey());
            String msg = String.join((CharSequence)"\n", (Iterable)entry.getValue());
            String content = "\u3010\u516c\u6d77\u6c60\u5546\u673a\u65b0\u589e\u63d0\u9192\u3011\u4ee5\u4e0b\u516c\u6d77\u6c60\u6709\u65b0\u7684\u5546\u673a\u5212\u5165\u5566\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3002\n" + msg;
            String mobileContent = "\u4ee5\u4e0b\u516c\u6d77\u6c60\u6709\u65b0\u7684\u5546\u673a\u5212\u5165\u5566\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3002\n" + msg;
            this.sendMsg(dateTimeNow, Collections.singletonList(userId), Collections.singletonList(content), Collections.singletonList(mobileContent), "\u516c\u6d77\u6c60\u5546\u673a\u65b0\u589e\u63d0\u9192", user, "/crm/sj/sjxq/xxzl");
        }
    }

    private void recycleWarningRemind(LocalDateTime dateTimeNow, List<OpportunityEntity> updateRecycleTimeList) {
        LocalDate dateNow = dateTimeNow.toLocalDate();
        HashMap<Long, RuleRecycleVO> ruleVoMap = new HashMap<Long, RuleRecycleVO>();
        HashMap opportunityRecycleReasonMap = new HashMap();
        CrmBaseConfigVo configVo = this.baseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OLD_POOL_FIRST);
        boolean oldPoolFirst = "1".equals(configVo.getConfigValue());
        List<OppoRuleVO> ruleList = this.opportunityPoolRuleMapper.selectAllRecyclePoolRule();
        Map<Object, Object> poolIdRuleMap = new HashMap();
        poolIdRuleMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, oppoRuleVO -> oppoRuleVO));
        ruleList.forEach(oppoRuleVO -> oppoRuleVO.setRuleRecycle((RuleRecycle)JSON.parseObject((String)oppoRuleVO.getPublicPoolRuleRecycle(), RuleRecycle.class)));
        ArrayList<ReRecycleVo> reRecycleVos = new ArrayList<ReRecycleVo>();
        for (OppoRuleVO ruleVO : ruleList) {
            RuleRecycle ruleRecycle = ruleVO.getRuleRecycle();
            if (!"1".equals(ruleVO.getPublicPoolRuleRecycleSwitch()) || ruleRecycle.getCondition() == null) continue;
            ReRecycleVo reRecycleVo = new ReRecycleVo();
            reRecycleVo.setDateType(ruleRecycle.getTime());
            reRecycleVo.setPoolId(ruleVO.getOppoPoolId());
            reRecycleVo.setPoolName(ruleVO.getOppoPoolName());
            boolean addFlag = false;
            if (ruleRecycle.getCondition().contains(OpportunityPoolConstant.AUTO_RE_RECYCLE_RULE_1)) {
                reRecycleVo.setReRuleParam1(ruleVO.getRuleRecycle().getReRuleParam1());
                addFlag = true;
            }
            if (ruleRecycle.getCondition().contains(OpportunityPoolConstant.AUTO_RE_RECYCLE_RULE_2)) {
                reRecycleVo.setReRuleParam2(ruleVO.getRuleRecycle().getReRuleParam2());
                reRecycleVo.setReRuleParam3(ruleVO.getRuleRecycle().getReRuleParam3());
                addFlag = true;
            }
            if (!addFlag) continue;
            reRecycleVos.add(reRecycleVo);
        }
        List<Long> exceptOpportunityIds = this.reRecycle(reRecycleVos, dateTimeNow, updateRecycleTimeList);
        ruleList.removeIf(oppoRuleVO -> oppoRuleVO.getRuleRecycle().getCondition().isEmpty());
        HashMap poolIdOpportunityListMap = new HashMap();
        List noTrackDtoList = ruleList.stream().map(oppoRuleVO -> {
            DayTypeDto dto = new DayTypeDto();
            if (oppoRuleVO.getRuleRecycle().getNoTrackDay() != null) {
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoTrackDay())));
            }
            dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
            if (oppoRuleVO.getRuleRecycle().getCondition() == null || !oppoRuleVO.getRuleRecycle().getCondition().contains(OpportunityPoolConstant.AUTO_RECYCLE_RULE_1)) {
                dto.setSwitchFlag("-1");
            } else {
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
            }
            return dto;
        }).collect(Collectors.toList());
        List noTrackDateList = this.calendarBoService.getStartDate(noTrackDtoList, dateNow);
        List noWinDtoList = ruleList.stream().map(oppoRuleVO -> {
            DayTypeDto dto = new DayTypeDto();
            if (oppoRuleVO.getRuleRecycle().getNoWinDay() != null) {
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoWinDay())));
            }
            dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
            if (oppoRuleVO.getRuleRecycle().getCondition() == null || !oppoRuleVO.getRuleRecycle().getCondition().contains(OpportunityPoolConstant.AUTO_RECYCLE_RULE_2)) {
                dto.setSwitchFlag("-1");
            } else {
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
            }
            return dto;
        }).collect(Collectors.toList());
        List noWinDateList = this.calendarBoService.getStartDate(noWinDtoList, dateNow);
        Map<String, List<OpportunityStage>> stageNameMap = this.opportunityStageService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityStage::getDelFlag, (Object)"0")).stream().collect(Collectors.groupingBy(OpportunityStage::getStageNameValue));
        for (int i = 0; i < ruleList.size(); ++i) {
            List memberList = ruleList.get(i).getMemberVOList().stream().filter(o -> OpportunityPoolConstant.POOL_MEMBER_ROLE_NORMAL.equals(o.getMemberRole())).collect(Collectors.toList());
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ArrayList deptIdList = new ArrayList();
            RuleRecycle ruleRecycle = ruleList.get(i).getRuleRecycle();
            Iterator iterator = memberList.iterator();
            while (iterator.hasNext()) {
                OpportunityPoolMemberVO memberVO = (OpportunityPoolMemberVO)iterator.next();
                if (OpportunityPoolConstant.POOL_MEMBER_TYPE_USER.equals(memberVO.getMemberType())) {
                    arrayList.add(memberVO.getMemberId());
                    continue;
                }
                if (OpportunityPoolConstant.POOL_MEMBER_TYPE_ROLE.equals(memberVO.getMemberType())) {
                    List<String> userIds = this.commonMapper.getUserByRoleId(memberVO.getMemberId());
                    arrayList.addAll(userIds.stream().map(Long::parseLong).collect(Collectors.toList()));
                    continue;
                }
                if (!OpportunityPoolConstant.POOL_MEMBER_TYPE_STRU.equals(memberVO.getMemberType())) continue;
                deptIdList.add(memberVO.getMemberId());
            }
            List userVos = this.organUserBoService.getUserListByDepartmentId((List)deptIdList);
            arrayList.addAll(userVos.stream().map(UserVo::getId).distinct().collect(Collectors.toList()));
            List<WhiteListMember> whiteList = ruleRecycle.getWhite();
            List whitePersonId = whiteList.stream().map(whiteListMember -> Long.parseLong(whiteListMember.getValue())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(arrayList)) continue;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            List<String> list = ruleRecycle.getRange();
            ArrayList stageIds = new ArrayList();
            for (String value2 : list) {
                if (stageNameMap.get(value2) == null) continue;
                stageIds.addAll(stageNameMap.get(value2).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList()));
            }
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(OpportunityEntity::getChargePersonId, arrayList)).eq(OpportunityEntity::getDelFlag, (Object)"0")).in(OpportunityEntity::getCustomerStageId, stageIds);
            if (CollectionUtil.isNotEmpty(exceptOpportunityIds)) {
                queryWrapper.notIn(OpportunityEntity::getOpportunityId, exceptOpportunityIds);
            }
            if (CollectionUtil.isNotEmpty(whitePersonId)) {
                queryWrapper.notIn(OpportunityEntity::getChargePersonId, whitePersonId);
            }
            List opportunityEntityList = this.opportunityService.list((Wrapper)queryWrapper);
            List oppoReason = opportunityEntityList.stream().map(opportunityEntity -> {
                OpportunityRecycleReason opportunityRecycleReason = new OpportunityRecycleReason();
                opportunityRecycleReason.setOpportunityId(opportunityEntity.getOpportunityId());
                opportunityRecycleReason.setResourcePoolId(opportunityEntity.getResourcePoolId());
                if (HussarUtils.isNotEmpty((Object)opportunityEntity.getClaimTime())) {
                    opportunityRecycleReason.setNoWinDate(opportunityEntity.getClaimTime());
                } else if (HussarUtils.isNotEmpty((Object)opportunityEntity.getAllocateTime())) {
                    opportunityRecycleReason.setNoWinDate(opportunityEntity.getAllocateTime());
                } else {
                    opportunityRecycleReason.setNoWinDate(opportunityEntity.getCreateTime());
                }
                if (HussarUtils.isNotEmpty((Object)opportunityEntity.getTrackTime())) {
                    opportunityRecycleReason.setNoTrackDate(opportunityEntity.getTrackTime());
                } else {
                    opportunityRecycleReason.setNoTrackDate(opportunityRecycleReason.getNoWinDate());
                }
                opportunityRecycleReasonMap.put(opportunityEntity.getOpportunityId(), opportunityRecycleReason);
                return opportunityRecycleReason;
            }).collect(Collectors.toList());
            poolIdOpportunityListMap.put(ruleList.get(i).getOppoPoolId(), oppoReason);
            RuleRecycleVO ruleRecycleVO2 = new RuleRecycleVO();
            ruleRecycleVO2.setOppoPoolId(ruleList.get(i).getOppoPoolId());
            ruleRecycleVO2.setNoWinDate((LocalDate)noWinDateList.get(i));
            ruleRecycleVO2.setNoTrackDate((LocalDate)noTrackDateList.get(i));
            ruleRecycleVO2.setOppoPoolOrder(ruleList.get(i).getOppoPoolOrder());
            if (HussarUtils.isNotEmpty((Object)((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoTrackDay())) {
                ruleRecycleVO2.setNoTrackNum(Integer.valueOf(((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoTrackDay()));
            }
            if (HussarUtils.isNotEmpty((Object)((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoWinDay())) {
                ruleRecycleVO2.setNoWinNum(Integer.valueOf(((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoWinDay()));
            }
            ruleVoMap.put(ruleRecycleVO2.getOppoPoolId(), ruleRecycleVO2);
        }
        HashMap oppoIdAndPoolRuleMap = new HashMap();
        for (Map.Entry entry : poolIdOpportunityListMap.entrySet()) {
            for (OpportunityRecycleReason oppo : (List)entry.getValue()) {
                if (HussarUtils.isEmpty(oppoIdAndPoolRuleMap.get(oppo.getOpportunityId()))) {
                    ArrayList poolRule = new ArrayList();
                    poolRule.add(ruleVoMap.get(entry.getKey()));
                    oppoIdAndPoolRuleMap.put(oppo.getOpportunityId(), poolRule);
                    continue;
                }
                ((List)oppoIdAndPoolRuleMap.get(oppo.getOpportunityId())).add(ruleVoMap.get(entry.getKey()));
            }
        }
        ArrayList opportunityIdList = new ArrayList(oppoIdAndPoolRuleMap.keySet());
        if (opportunityIdList.isEmpty()) {
            return;
        }
        Map<Long, OpportunityEntity> map = this.opportunityService.list((Wrapper)new LambdaQueryWrapper().in(OpportunityEntity::getOpportunityId, opportunityIdList)).stream().collect(Collectors.toMap(OpportunityEntity::getOpportunityId, opportunityEntity -> opportunityEntity));
        HashMap oppoIdDateTypeMapNoTrack = new HashMap();
        HashMap oppoIdDateTypeMapNoWin = new HashMap();
        HashMap dateNoWinMap = new HashMap();
        HashMap dateNoTrackMap = new HashMap();
        Map<Long, OppoRuleVO> poolIdRuleVOMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, oppoRuleVO -> oppoRuleVO));
        for (Map.Entry entry : oppoIdAndPoolRuleMap.entrySet()) {
            OpportunityPoolOppo oppo;
            boolean oldPoolExist;
            LocalDateTime claimTime = map.get(entry.getKey()).getClaimTime();
            LocalDateTime allocateTime = map.get(entry.getKey()).getAllocateTime();
            LocalDateTime trackTime = map.get(entry.getKey()).getTrackTime();
            if (claimTime != null) {
                dateNoWinMap.put(entry.getKey(), claimTime.toLocalDate());
            } else if (allocateTime != null) {
                dateNoWinMap.put(entry.getKey(), allocateTime.toLocalDate());
            } else {
                dateNoWinMap.put(entry.getKey(), map.get(entry.getKey()).getCreateTime().toLocalDate());
            }
            if (trackTime != null) {
                dateNoTrackMap.put(entry.getKey(), trackTime.toLocalDate());
            } else {
                dateNoTrackMap.put(entry.getKey(), (LocalDate)dateNoWinMap.get(entry.getKey()));
            }
            List recycleVOList = (List)entry.getValue();
            recycleVOList.sort(Comparator.comparing(RuleRecycleVO::getOppoPoolOrder));
            OpportunityRecycleReason reason = (OpportunityRecycleReason)opportunityRecycleReasonMap.get(entry.getKey());
            String reasonStr = "";
            StringBuilder reasonStrTemp = new StringBuilder();
            boolean oldPoolRuleMatched = false;
            boolean bl = oldPoolExist = oldPoolFirst && recycleVOList.stream().map(RuleRecycleVO::getOppoPoolId).collect(Collectors.toList()).contains(((OpportunityRecycleReason)opportunityRecycleReasonMap.get(entry.getKey())).getResourcePoolId());
            if (oldPoolExist) {
                RuleRecycleVO vo = (RuleRecycleVO)recycleVOList.stream().filter(ruleRecycleVO -> ruleRecycleVO.getOppoPoolId().equals(((OpportunityRecycleReason)opportunityRecycleReasonMap.get(listEntry.getKey())).getResourcePoolId())).collect(Collectors.toList()).get(0);
                if (vo.getNoTrackDate() != null && !vo.getNoTrackDate().isBefore(LocalDate.from(reason.getNoTrackDate()))) {
                    reasonStrTemp.append("\u8d85").append(vo.getNoTrackNum()).append("\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
                }
                if (vo.getNoWinDate() != null && !vo.getNoWinDate().isBefore(LocalDate.from(reason.getNoWinDate())) && reasonStrTemp.length() == 0) {
                    reasonStrTemp.append("\u8d85").append(vo.getNoWinNum()).append("\u5929\u672a\u8d62\u5355");
                }
                if (reasonStrTemp.length() > 0) {
                    reasonStr = reasonStrTemp.toString();
                    oldPoolRuleMatched = true;
                }
            }
            if (!oldPoolRuleMatched) {
                for (RuleRecycleVO ruleRecycleVO3 : recycleVOList) {
                    reasonStrTemp = new StringBuilder();
                    if (ruleRecycleVO3.getNoTrackDate() != null && !ruleRecycleVO3.getNoTrackDate().isBefore(LocalDate.from(reason.getNoTrackDate()))) {
                        reasonStrTemp.append("\u8d85").append(ruleRecycleVO3.getNoTrackNum()).append("\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
                    }
                    if (reasonStrTemp.length() == 0 && ruleRecycleVO3.getNoWinDate() != null && !ruleRecycleVO3.getNoWinDate().isBefore(LocalDate.from(reason.getNoWinDate()))) {
                        reasonStrTemp.append("\u8d85").append(ruleRecycleVO3.getNoWinNum()).append("\u5929\u672a\u8d62\u5355");
                    }
                    if (reasonStrTemp.length() <= 0 || oldPoolExist) continue;
                    reasonStr = reasonStrTemp.toString();
                    break;
                }
            }
            if ((oppo = (OpportunityPoolOppo)BeanUtil.copy((Object)map.get(entry.getKey()), OpportunityPoolOppo.class)) == null) continue;
            List<Object> dayTypeDtoListNoTrack = new ArrayList();
            List<Object> dayTypeDtoListNoWin = new ArrayList();
            String finalReasonStr = reasonStr;
            dayTypeDtoListNoTrack = recycleVOList.stream().map(ruleRecycleVO -> {
                DayTypeDto dto = new DayTypeDto();
                OppoRuleVO oppoRuleVO = (OppoRuleVO)poolIdRuleVOMap.get(ruleRecycleVO.getOppoPoolId());
                if (!oppoRuleVO.getRuleRecycle().getCondition().contains(OpportunityPoolConstant.AUTO_RECYCLE_RULE_1)) {
                    return null;
                }
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoTrackDay())));
                dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
                dto.setReason(finalReasonStr);
                return dto;
            }).collect(Collectors.toList());
            dayTypeDtoListNoTrack.removeIf(Objects::isNull);
            dayTypeDtoListNoTrack = new ArrayList<DayTypeDto>(dayTypeDtoListNoTrack.stream().collect(Collectors.toMap(DayTypeDto::getDateType, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(DayTypeDto::getDay)))).values());
            if (CollectionUtil.isNotEmpty(dayTypeDtoListNoTrack)) {
                oppoIdDateTypeMapNoTrack.put(entry.getKey(), dayTypeDtoListNoTrack);
            }
            dayTypeDtoListNoWin = recycleVOList.stream().map(ruleRecycleVO -> {
                DayTypeDto dto = new DayTypeDto();
                OppoRuleVO oppoRuleVO = (OppoRuleVO)poolIdRuleVOMap.get(ruleRecycleVO.getOppoPoolId());
                if (!oppoRuleVO.getRuleRecycle().getCondition().contains(OpportunityPoolConstant.AUTO_RECYCLE_RULE_2)) {
                    return null;
                }
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoWinDay())));
                dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
                dto.setReason(finalReasonStr);
                return dto;
            }).collect(Collectors.toList());
            dayTypeDtoListNoWin.removeIf(Objects::isNull);
            if (!CollectionUtil.isNotEmpty(dayTypeDtoListNoWin = new ArrayList<DayTypeDto>(dayTypeDtoListNoWin.stream().collect(Collectors.toMap(DayTypeDto::getDateType, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(DayTypeDto::getDay)))).values()))) continue;
            oppoIdDateTypeMapNoWin.put(entry.getKey(), dayTypeDtoListNoWin);
        }
        if (CollectionUtil.isNotEmpty(oppoIdDateTypeMapNoWin) || CollectionUtil.isNotEmpty(oppoIdDateTypeMapNoTrack)) {
            Map noWinRecycle = this.calendarBoService.getRecycleTime(oppoIdDateTypeMapNoWin, dateNoWinMap);
            Map map2 = this.calendarBoService.getRecycleTime(oppoIdDateTypeMapNoTrack, dateNoTrackMap);
            noWinRecycle.forEach((key, value) -> noTrackRecycle.merge(key, value, (date1, date2) -> date1.getDate().isBefore(date2.getDate()) ? date1 : date2));
            for (OpportunityEntity opportunity : updateRecycleTimeList) {
                if (!noWinRecycle.containsKey(opportunity.getOpportunityId())) continue;
                LocalDate date = ((RecycleReasonDate)noWinRecycle.get(opportunity.getOpportunityId())).getDate();
                if (!date.isAfter(dateNow)) {
                    opportunity.setRecycleTime(dateNow.plusDays(1L).atStartOfDay());
                    continue;
                }
                opportunity.setRecycleTime(((RecycleReasonDate)noWinRecycle.get(opportunity.getOpportunityId())).getDate().atStartOfDay());
            }
            updateRecycleTimeList.addAll(this.updateRecycleTime(map2, dateNow, updateRecycleTimeList));
            LocalDate sevenDay = LocalDate.now().plusDays(7L);
            Map<LocalDate, List<OpportunityEntity>> listMap = updateRecycleTimeList.stream().collect(Collectors.groupingBy(opportunityEntity -> opportunityEntity.getRecycleTime().toLocalDate()));
            for (Map.Entry<LocalDate, List<OpportunityEntity>> entry : listMap.entrySet()) {
                List<OpportunityEntity> opportunityEntityList = entry.getValue();
                HashMap<Long, Integer> chargePersonNoTrackCount = new HashMap<Long, Integer>();
                HashMap<Long, Integer> chargePersonNoWinCount = new HashMap<Long, Integer>();
                for (OpportunityEntity opportunity : opportunityEntityList) {
                    Long chargePersonId;
                    OpportunityEntity opportunityEntity2;
                    if (!sevenDay.atStartOfDay().isAfter(opportunity.getRecycleTime()) || (opportunityEntity2 = map.get(opportunity.getOpportunityId())) == null || (chargePersonId = opportunityEntity2.getChargePersonId()) == null) continue;
                    if (opportunity.getAbandonedReason().contains("\u8ddf\u8fdb")) {
                        if (chargePersonNoTrackCount.containsKey(chargePersonId)) {
                            chargePersonNoTrackCount.put(chargePersonId, (Integer)chargePersonNoTrackCount.get(chargePersonId) + 1);
                            continue;
                        }
                        chargePersonNoTrackCount.put(chargePersonId, 1);
                        continue;
                    }
                    if (chargePersonNoWinCount.containsKey(chargePersonId)) {
                        chargePersonNoWinCount.put(chargePersonId, (Integer)chargePersonNoWinCount.get(chargePersonId) + 1);
                        continue;
                    }
                    chargePersonNoWinCount.put(chargePersonId, 1);
                }
                this.sendWarningMessage(entry, chargePersonNoTrackCount, chargePersonNoWinCount, dateTimeNow);
            }
        }
        if (CollectionUtil.isNotEmpty(updateRecycleTimeList)) {
            this.opportunityMapper.updateRecycleTimeBatch(updateRecycleTimeList);
            this.opportunityService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(OpportunityEntity::getOpportunityId, (Collection)updateRecycleTimeList.stream().map(OpportunityEntity::getOpportunityId).collect(Collectors.toList()))).set(OpportunityEntity::getRecycleTime, null));
        }
    }

    private List<OpportunityEntity> updateRecycleTime(Map<Long, RecycleReasonDate> noTrackRecycle, LocalDate dateNow, List<OpportunityEntity> updateRecycleTimeList) {
        for (Map.Entry<Long, RecycleReasonDate> entry : noTrackRecycle.entrySet()) {
            RecycleReasonDate recycleReasonDate = entry.getValue();
            if (!recycleReasonDate.getDate().isAfter(dateNow)) {
                recycleReasonDate.setDate(dateNow.plusDays(1L));
            }
            OpportunityEntity oppo = new OpportunityEntity();
            oppo.setOpportunityId(entry.getKey());
            oppo.setRecycleTime(recycleReasonDate.getDate().atStartOfDay());
            if (noTrackRecycle.get(entry.getKey()).getDate().isEqual(recycleReasonDate.getDate())) {
                oppo.setAbandonedReason("\u8d85" + recycleReasonDate.getDay() + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
            } else {
                oppo.setAbandonedReason("\u8d85" + recycleReasonDate.getDay() + "\u5929\u672a\u8d62\u5355");
            }
            updateRecycleTimeList.add(oppo);
        }
        return updateRecycleTimeList;
    }

    private void sendWarningMessage(Map.Entry<LocalDate, List<OpportunityEntity>> entry, Map<Long, Integer> chargePersonNoTrackCount, Map<Long, Integer> chargePersonNoWinCount, LocalDateTime dateTimeNow) {
        HashMap<String, String> params;
        List messagePushList = this.messageTemplateService.getMessagePushList("5");
        MessagePushVo pushToWeb = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("1")).collect(Collectors.toList()).get(0);
        MessagePushVo pushToMobile = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("2")).collect(Collectors.toList()).get(0);
        for (Map.Entry<Long, Integer> countEntry : chargePersonNoTrackCount.entrySet()) {
            params = new HashMap<String, String>();
            params.put("recycleDate", entry.getKey().toString());
            params.put("opportunityCount", String.valueOf(countEntry.getValue()));
            params.put("recycleReason", "\u8d85\u671f\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
            this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(countEntry.getKey()));
            this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(countEntry.getKey()));
        }
        for (Map.Entry<Long, Integer> countEntry : chargePersonNoWinCount.entrySet()) {
            params = new HashMap();
            params.put("recycleDate", entry.getKey().toString());
            params.put("opportunityCount", String.valueOf(countEntry.getValue()));
            params.put("recycleReason", "\u8d85\u671f\u672a\u8d62\u5355");
            this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(countEntry.getKey()));
            this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(countEntry.getKey()));
        }
    }

    private List<Long> reRecycle(List<ReRecycleVo> reRecycleVos, LocalDateTime dateTimeNow, List<OpportunityEntity> updateRecycleTimeList) {
        if (CollectionUtil.isEmpty(reRecycleVos)) {
            return null;
        }
        SecurityUser user = new SecurityUser();
        user.setUserId(Long.valueOf(1450756958461300737L));
        user.setDeptId(Long.valueOf(-1L));
        LocalDate dateNow = dateTimeNow.toLocalDate();
        LocalDate todayPlus7 = dateNow.plusDays(7L);
        List poolIds = reRecycleVos.stream().map(ReRecycleVo::getPoolId).collect(Collectors.toList());
        List opportunityEntityList = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getDelFlag, (Object)"0")).in(OpportunityEntity::getResourcePoolId, poolIds));
        List<Long> oppoIds = opportunityEntityList.stream().map(OpportunityEntity::getOpportunityId).collect(Collectors.toList());
        List<Long> trackTwiceOpportunityIds = this.opportunityMapper.selectTrackTwiceOpportunityIds(oppoIds);
        opportunityEntityList.removeIf(opportunityEntity -> trackTwiceOpportunityIds.contains(opportunityEntity.getOpportunityId()));
        Set existPoolIds = opportunityEntityList.stream().map(OpportunityEntity::getResourcePoolId).collect(Collectors.toSet());
        reRecycleVos.removeIf(reRecycleVo -> !existPoolIds.contains(reRecycleVo.getPoolId()));
        Map<Long, ReRecycleVo> ruleMap = reRecycleVos.stream().collect(Collectors.toMap(ReRecycleVo::getPoolId, o -> o));
        HashMap<Long, List<DayTypeDto>> dtoListMap = new HashMap<Long, List<DayTypeDto>>();
        HashMap<Long, LocalDate> dateMap = new HashMap<Long, LocalDate>();
        HashMap<Long, RecycleReasonDate> map = new HashMap<Long, RecycleReasonDate>();
        List noTrackOpportunityList = opportunityEntityList.stream().filter(opportunityEntity -> {
            LocalDateTime caTime = Stream.of(opportunityEntity.getClaimTime(), opportunityEntity.getAllocateTime()).filter(Objects::nonNull).max(LocalDateTime::compareTo).orElse(null);
            LocalDateTime trackTime = opportunityEntity.getTrackTime();
            return trackTime == null || caTime != null && trackTime.isBefore(caTime);
        }).collect(Collectors.toList());
        Map<Long, List<OpportunityEntity>> noTrackPoolOppoListMap = noTrackOpportunityList.stream().collect(Collectors.groupingBy(OpportunityEntity::getResourcePoolId));
        for (Map.Entry<Long, List<OpportunityEntity>> entry : noTrackPoolOppoListMap.entrySet()) {
            ReRecycleVo reRecycleVo2 = ruleMap.get(entry.getKey());
            Integer day1 = reRecycleVo2.getReRuleParam1();
            if (day1 == null) continue;
            List<OpportunityEntity> poolOppoList = entry.getValue();
            Map<Long, Long> opportunityIdUserIdMap = poolOppoList.stream().collect(Collectors.toMap(OpportunityEntity::getOpportunityId, OpportunityEntity::getChargePersonId));
            Map<Long, Map<Long, RecycleReasonDate>> reRecycleDateMap = this.getReRecycleDateMap(poolOppoList, dateMap, reRecycleVo2, dtoListMap, opportunityIdUserIdMap, map, reRecycleVo2.getReRuleParam1());
            String reason = "\u8ba4\u9886/\u5206\u914d\u540e\uff0c\u8d85\u8fc7" + day1 + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u81ea\u52a8\u5212\u5165\u81f3\u539f\u516c\u6d77";
            for (Map.Entry<Long, Map<Long, RecycleReasonDate>> rrdMap : reRecycleDateMap.entrySet()) {
                HashMap<String, Integer> dateCountMap = new HashMap<String, Integer>();
                for (Map.Entry<Long, RecycleReasonDate> dateEntry : rrdMap.getValue().entrySet()) {
                    if (!dateEntry.getValue().getDate().isAfter(dateNow)) {
                        dateEntry.getValue().setDate(dateNow.plusDays(1L));
                    }
                    if (dateEntry.getValue().getDate().isAfter(todayPlus7)) continue;
                    dateCountMap.merge(dateEntry.getValue().getDate().toString(), 1, Integer::sum);
                }
                ArrayList<String> msgList = new ArrayList<String>();
                ArrayList<String> mobileMsgList = new ArrayList<String>();
                dateCountMap.forEach((recycleDate, count) -> {
                    String msg = "\u3010\u5212\u5165\u516c\u6d77\u6c60\u9884\u8b66\u3011\u60a8\u6709" + count + "\u6761\u5546\u673a\uff0c\u9884\u8ba1\u5c06\u5728" + recycleDate + "\u88ab\u7cfb\u7edf\u56de\u6536\u81f3\u516c\u6d77\u6c60\uff0c\u56de\u6536\u539f\u56e0\uff1a" + reason + "\u3002\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
                    msgList.add(msg);
                    String mobileMsg = "\u60a8\u6709" + count + "\u6761\u5546\u673a\uff0c\u9884\u8ba1\u5c06\u5728" + recycleDate + "\u88ab\u7cfb\u7edf\u56de\u6536\u81f3\u516c\u6d77\u6c60\uff0c\u56de\u6536\u539f\u56e0\uff1a" + reason + "\u3002\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
                    mobileMsgList.add(mobileMsg);
                });
                this.sendMsg(dateTimeNow, Collections.singletonList(rrdMap.getKey().toString()), msgList, mobileMsgList, "\u5212\u5165\u516c\u6d77\u6c60\u9884\u8b66", user, "/crm/sj/sjxq/xxzl");
            }
        }
        Map<Long, List<OpportunityEntity>> poolOppoListMap = opportunityEntityList.stream().filter(opportunityEntity -> opportunityEntity.getTrackTime() != null).collect(Collectors.groupingBy(OpportunityEntity::getResourcePoolId));
        dtoListMap = new HashMap();
        dateMap = new HashMap();
        for (Map.Entry<Long, List<OpportunityEntity>> entry : poolOppoListMap.entrySet()) {
            Long poolId = entry.getKey();
            ReRecycleVo reRecycleVo3 = ruleMap.get(poolId);
            Integer day2 = reRecycleVo3.getReRuleParam2();
            if (day2 == null) continue;
            List<OpportunityEntity> poolOppoList = entry.getValue().stream().filter(opportunityEntity -> {
                Long opportunityId = opportunityEntity.getOpportunityId();
                LocalDateTime caTime = Stream.of(opportunityEntity.getClaimTime(), opportunityEntity.getAllocateTime()).filter(Objects::nonNull).max(LocalDateTime::compareTo).orElse(null);
                HashMap<Long, List<DayTypeDto>> dtoListMap1 = new HashMap<Long, List<DayTypeDto>>();
                HashMap<Long, LocalDate> dateMap1 = new HashMap<Long, LocalDate>();
                dateMap1.put(opportunityId, caTime.toLocalDate());
                DayTypeDto dayTypeDto = new DayTypeDto();
                dayTypeDto.setSwitchFlag("1");
                dayTypeDto.setDateType(reRecycleVo3.getDateType());
                dayTypeDto.setDay(reRecycleVo3.getReRuleParam2());
                dtoListMap1.put(opportunityId, Collections.singletonList(dayTypeDto));
                Map resultMap = this.calendarBoService.getRecycleTime(dtoListMap1, dateMap1);
                LocalDate claimTimePlusDay2 = ((RecycleReasonDate)resultMap.get(opportunityId)).getDate();
                return opportunityEntity.getTrackTime().isBefore(claimTimePlusDay2.atStartOfDay());
            }).collect(Collectors.toList());
            Map<Long, Long> opportunityIdUserIdMap = poolOppoList.stream().collect(Collectors.toMap(OpportunityEntity::getOpportunityId, OpportunityEntity::getChargePersonId));
            entry.setValue(poolOppoList);
            Map<Long, Map<Long, RecycleReasonDate>> reRecycleDateMap = this.getReRecycleDateMap(poolOppoList, dateMap, reRecycleVo3, dtoListMap, opportunityIdUserIdMap, map, reRecycleVo3.getReRuleParam3());
            String reason = "\u8ba4\u9886/\u5206\u914d\u540e\uff0c" + reRecycleVo3.getReRuleParam2() + "\u5929\u5185\u8ddf\u8fdb\u8fc7\uff1b\u53c8\u8d85\u8fc7" + reRecycleVo3.getReRuleParam3() + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u81ea\u52a8\u5212\u5165\u81f3\u539f\u516c\u6d77";
            for (Map.Entry<Long, Map<Long, RecycleReasonDate>> rrdMap : reRecycleDateMap.entrySet()) {
                HashMap<String, Integer> dateCountMap = new HashMap<String, Integer>();
                for (Map.Entry<Long, RecycleReasonDate> dateEntry : rrdMap.getValue().entrySet()) {
                    if (!dateEntry.getValue().getDate().isAfter(dateNow)) {
                        dateEntry.getValue().setDate(dateNow.plusDays(1L));
                    }
                    if (dateEntry.getValue().getDate().isAfter(todayPlus7)) continue;
                    dateCountMap.merge(dateEntry.getValue().getDate().toString(), 1, Integer::sum);
                }
                ArrayList<String> msgList = new ArrayList<String>();
                ArrayList<String> mobileMsgList = new ArrayList<String>();
                dateCountMap.forEach((recycleDate, count) -> {
                    String msg = "\u3010\u5212\u5165\u516c\u6d77\u6c60\u9884\u8b66\u3011\u60a8\u6709" + count + "\u6761\u5546\u673a\uff0c\u9884\u8ba1\u5c06\u5728" + recycleDate + "\u88ab\u7cfb\u7edf\u56de\u6536\u81f3\u516c\u6d77\u6c60\uff0c\u56de\u6536\u539f\u56e0\uff1a" + reason + "\u3002\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
                    msgList.add(msg);
                    String mobileMsg = "\u60a8\u6709" + count + "\u6761\u5546\u673a\uff0c\u9884\u8ba1\u5c06\u5728" + recycleDate + "\u88ab\u7cfb\u7edf\u56de\u6536\u81f3\u516c\u6d77\u6c60\uff0c\u56de\u6536\u539f\u56e0\uff1a" + reason + "\u3002\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
                    mobileMsgList.add(mobileMsg);
                });
                this.sendMsg(dateTimeNow, Collections.singletonList(rrdMap.getKey().toString()), msgList, mobileMsgList, "\u5212\u5165\u516c\u6d77\u6c60\u9884\u8b66", user, "/crm/sj/sjxq/xxzl");
            }
        }
        updateRecycleTimeList.addAll(this.updateRecycleTime(map, dateNow, updateRecycleTimeList));
        return oppoIds;
    }

    @NotNull
    private Map<Long, Map<Long, RecycleReasonDate>> getReRecycleDateMap(List<OpportunityEntity> poolOppoList, Map<Long, LocalDate> dateMap, ReRecycleVo reRecycleVo, Map<Long, List<DayTypeDto>> dtoListMap, Map<Long, Long> opportunityIdUserIdMap, Map<Long, RecycleReasonDate> map, int dayNum) {
        for (OpportunityEntity oppo : poolOppoList) {
            if (oppo.getTrackTime() == null) {
                LocalDateTime caTime = Stream.of(oppo.getClaimTime(), oppo.getAllocateTime()).filter(Objects::nonNull).max(LocalDateTime::compareTo).orElse(null);
                dateMap.put(oppo.getOpportunityId(), caTime.toLocalDate());
            } else {
                dateMap.put(oppo.getOpportunityId(), oppo.getTrackTime().toLocalDate());
            }
            DayTypeDto dayTypeDto = new DayTypeDto();
            dayTypeDto.setSwitchFlag("1");
            dayTypeDto.setDateType(reRecycleVo.getDateType());
            dayTypeDto.setDay(Integer.valueOf(dayNum));
            dtoListMap.put(oppo.getOpportunityId(), Collections.singletonList(dayTypeDto));
        }
        Map recycleReasonDateMap = this.calendarBoService.getRecycleTime(dtoListMap, dateMap);
        map.putAll(recycleReasonDateMap);
        Map<Long, Map<Long, RecycleReasonDate>> resultMap = opportunityIdUserIdMap.entrySet().stream().filter(e -> recycleReasonDateMap.containsKey(e.getKey())).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.toMap(Map.Entry::getKey, e -> (RecycleReasonDate)recycleReasonDateMap.get(e.getKey()))));
        return resultMap;
    }

    private void sendMsg(LocalDateTime dateTimeNow, List<String> sendUserList, List<String> msgList, List<String> mobileMsgList, String mobileTitle, SecurityUser msgCreator, String url) {
        for (int i = 0; i < msgList.size(); ++i) {
            String contentUnify = msgList.get(i);
            String contentMobile = mobileMsgList.get(i);
            EimPushUtil.pushJqxArticleMessage(mobileTitle, contentMobile, "/crm/sj/sjxq/xxzl", "", sendUserList);
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl();
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, dateTimeNow, msgCreator, String.join((CharSequence)",", sendUserList), "\u7cfb\u7edf", unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
    }

    private void transWarningRemind(LocalDateTime dateTimeNow) {
        List<OppoRuleVO> ruleList = this.opportunityPoolRuleMapper.selectAllTransRule();
        Map<Long, String> poolNameMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, OppoRuleVO::getOppoPoolName));
        ruleList.forEach(oppoRuleVO -> oppoRuleVO.setRulePoolTrans((RulePoolTrans)JSON.parseObject((String)oppoRuleVO.getPublicPoolRuleTrans(), RulePoolTrans.class)));
        ruleList.removeIf(oppoRuleVO -> CollectionUtil.isNotEmpty(oppoRuleVO.getRulePoolTrans().getCondition()) && oppoRuleVO.getRulePoolTrans().getCondition().contains("1"));
        if (ruleList.isEmpty()) {
            return;
        }
        List oppoList = this.opportunityPoolOppoService.list((Wrapper)new LambdaQueryWrapper().in(OpportunityPoolOppo::getOppoPoolId, (Collection)ruleList.stream().map(OppoRuleVO::getOppoPoolId).collect(Collectors.toList())));
        HashMap<Long, List<DayTypeDto>> dtoListMap = new HashMap<Long, List<DayTypeDto>>();
        HashMap<Long, LocalDate> dateMap = new HashMap<Long, LocalDate>();
        Map<Long, RulePoolTrans> ruleTransMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, OppoRuleVO::getRulePoolTrans));
        for (OpportunityPoolOppo oppo : oppoList) {
            RulePoolTrans rulePoolTrans = ruleTransMap.get(oppo.getOppoPoolId());
            dateMap.put(oppo.getOpportunityId(), oppo.getLastJoinTime().toLocalDate());
            DayTypeDto dayTypeDto = new DayTypeDto();
            dayTypeDto.setSwitchFlag("1");
            dayTypeDto.setDateType(rulePoolTrans.getTime());
            dayTypeDto.setDay(rulePoolTrans.getTransDay());
            dtoListMap.put(oppo.getOpportunityId(), Collections.singletonList(dayTypeDto));
        }
        Map<Long, List<OpportunityPoolOppo>> oppoMap = oppoList.stream().collect(Collectors.groupingBy(OpportunityPoolOppo::getOppoPoolId));
        Map recycleReasonDateMap = this.calendarBoService.getRecycleTime(dtoListMap, dateMap);
        LocalDate dateNow = dateTimeNow.toLocalDate();
        LocalDate datePlus5 = dateTimeNow.toLocalDate().plusDays(5L);
        SecurityUser user = new SecurityUser();
        user.setUserId(Long.valueOf(1450756958461300737L));
        user.setDeptId(Long.valueOf(-1L));
        for (Map.Entry<Long, RulePoolTrans> entry : ruleTransMap.entrySet()) {
            Long poolId = entry.getKey();
            RulePoolTrans rulePoolTrans = entry.getValue();
            OpportunityPool targetPool = (OpportunityPool)this.opportunityPoolService.getById(rulePoolTrans.getTargetPool());
            HashMap<String, Integer> dateCountMap = new HashMap<String, Integer>();
            List<OpportunityPoolOppo> poolOppoList = oppoMap.get(poolId);
            if (CollectionUtil.isEmpty(poolOppoList)) continue;
            for (OpportunityPoolOppo oppo : poolOppoList) {
                Long opportunityId = oppo.getOpportunityId();
                RecycleReasonDate recycleReasonDate = (RecycleReasonDate)recycleReasonDateMap.get(opportunityId);
                if (recycleReasonDate.getDate().isAfter(datePlus5)) continue;
                if (!recycleReasonDate.getDate().isAfter(dateNow)) {
                    dateCountMap.merge(dateNow.plusDays(1L).toString(), 1, Integer::sum);
                    continue;
                }
                dateCountMap.merge(recycleReasonDate.getDate().toString(), 1, Integer::sum);
            }
            if (dateCountMap.isEmpty()) continue;
            ArrayList<String> msgList = new ArrayList<String>();
            ArrayList<String> mobileMsgList = new ArrayList<String>();
            dateCountMap.forEach((transDate, count) -> {
                String msg = "\u3010\u8f6c\u79fb\u516c\u6d77\u6c60\u9884\u8b66\u3011\u516c\u6d77\u6c60\u540d\u79f0\uff1a" + (String)poolNameMap.get(poolId) + "\uff0c\u6709" + count + "\u6761\u6570\u636e\uff0c\u9884\u8ba1\u5c06\u5728" + transDate + "\u88ab\u7cfb\u7edf\u8f6c\u79fb\u81f3\u3010" + targetPool.getOppoPoolName() + "\u3011\uff0c\u8f6c\u79fb\u539f\u56e0\uff1a\u6700\u65b0\u5212\u5165\u516c\u6d77\u6c60\u8d85\u8fc7" + rulePoolTrans.getTransDay() + "\u5929\uff0c\u672a\u8ba4\u9886\u6216\u672a\u5206\u914d\uff0c\u81ea\u52a8\u8f6c\u79fb\u3002\u8bf7\u77e5\u6089\u3002";
                msgList.add(msg);
                String mobileMsg = "\u516c\u6d77\u6c60\u540d\u79f0\uff1a" + (String)poolNameMap.get(poolId) + "\uff0c\u6709" + count + "\u6761\u6570\u636e\uff0c\u9884\u8ba1\u5c06\u5728" + transDate + "\u88ab\u7cfb\u7edf\u8f6c\u79fb\u81f3\u3010" + targetPool.getOppoPoolName() + "\u3011\uff0c\u8f6c\u79fb\u539f\u56e0\uff1a\u6700\u65b0\u5212\u5165\u516c\u6d77\u6c60\u8d85\u8fc7" + rulePoolTrans.getTransDay() + "\u5929\uff0c\u672a\u8ba4\u9886\u6216\u672a\u5206\u914d\uff0c\u81ea\u52a8\u8f6c\u79fb\u3002\u8bf7\u77e5\u6089\u3002";
                mobileMsgList.add(mobileMsg);
            });
            List opportunityPoolMemberList = this.opportunityPoolMemberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityPoolMember::getOppoPoolId, (Object)poolId)).eq(OpportunityPoolMember::getMemberRole, (Object)OpportunityPoolConstant.POOL_MEMBER_ROLE_MANAGER));
            List<String> memberIds = opportunityPoolMemberList.stream().map(OpportunityPoolMember::getMemberId).map(String::valueOf).collect(Collectors.toList());
            this.sendMsg(dateTimeNow, memberIds, msgList, mobileMsgList, "\u5212\u5165\u516c\u6d77\u6c60\u9884\u8b66", user, "/crm/sy/yddsy");
        }
    }

    private void todayMsgPush(LocalDateTime dateTimeNow) {
        List scheduledMsgTemps = this.scheduledMsgTempService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ScheduledMsgTemp::getStatus, (Object)"0")).gt(ScheduledMsgTemp::getCreateTime, (Object)dateTimeNow.toLocalDate().atStartOfDay()));
        if (scheduledMsgTemps.isEmpty()) {
            return;
        }
        SecurityUser user = new SecurityUser();
        user.setUserId(Long.valueOf(1450756958461300737L));
        user.setDeptId(Long.valueOf(-1L));
        for (ScheduledMsgTemp scheduledMsgTemp : scheduledMsgTemps) {
            if ("1".equals(scheduledMsgTemp.getType())) {
                Map oppoRecycleMessageVoMap = JsonUtil.toMap((String)scheduledMsgTemp.getMsgJson(), OppoRecycleMessageVo.class);
                this.sendRecycleMessage(oppoRecycleMessageVoMap, dateTimeNow);
                continue;
            }
            if (!"2".equals(scheduledMsgTemp.getType())) continue;
            List msgJsonList = JsonUtil.readList((String)scheduledMsgTemp.getMsgJson(), String.class);
            for (String msgJson : msgJsonList) {
                Map map = JsonUtil.toMap((String)msgJson);
                String msgContent = (String)map.get("msgContent");
                String mobileContent = (String)map.get("mobileContent");
                String title = (String)map.get("title");
                List pushToUserId = (List)map.get("pushToUserId");
                this.sendMsg(dateTimeNow, pushToUserId, Collections.singletonList(msgContent), Collections.singletonList(mobileContent), title, user, "/crm/sy/yddsy");
            }
        }
        this.scheduledMsgTempService.removeBatchByIds(scheduledMsgTemps.stream().map(ScheduledMsgTemp::getId).collect(Collectors.toSet()));
    }

    private void sendRecycleMessage(Map<String, OppoRecycleMessageVo> oppoRecycleMessageVoMap, LocalDateTime dateTimeNow) {
        List messagePushList = this.messageTemplateService.getMessagePushList("4");
        MessagePushVo pushToWeb = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("1")).collect(Collectors.toList()).get(0);
        MessagePushVo pushToMobile = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("2")).collect(Collectors.toList()).get(0);
        for (Map.Entry<String, OppoRecycleMessageVo> entry : oppoRecycleMessageVoMap.entrySet()) {
            OppoRecycleMessageVo oppoRecycleMessageVo = entry.getValue();
            String[] idList = entry.getKey().split(",");
            if (idList.length < 2 || "null".equals(idList[0])) continue;
            Long personId = Long.parseLong(idList[0]);
            String poolName = idList[1];
            int countNoTrack = oppoRecycleMessageVo.getCountNoTrack();
            int countNoWin = oppoRecycleMessageVo.getCountNoWin();
            int countReNoTrack = oppoRecycleMessageVo.getReRecycleNoTrack();
            int countReNoTwiceTrack = oppoRecycleMessageVo.getReRecycleNoTwiceTrack();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("poolName", poolName);
            if (countNoTrack > 0) {
                params.put("opportunityCount", String.valueOf(countNoTrack));
                params.put("recycleReason", "\u8d85" + oppoRecycleMessageVo.getNoTrackDayNum() + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
                this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
                this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
            }
            if (countNoWin > 0) {
                params.put("opportunityCount", String.valueOf(countNoWin));
                params.put("recycleReason", "\u8d85" + oppoRecycleMessageVo.getNoWinDayNum() + "\u5929\u672a\u8d62\u5355");
                this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
                this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
            }
            if (countReNoTrack > 0) {
                params.put("opportunityCount", String.valueOf(countReNoTrack));
                params.put("recycleReason", "\u8ba4\u9886/\u5206\u914d\u540e\uff0c\u8d85\u8fc7" + oppoRecycleMessageVo.getReRecycleNoTrackNum() + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u81ea\u52a8\u5212\u5165\u81f3\u539f\u516c\u6d77");
                this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
                this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
            }
            if (countReNoTwiceTrack <= 0) continue;
            params.put("opportunityCount", String.valueOf(countReNoTwiceTrack));
            params.put("recycleReason", "\u8ba4\u9886/\u5206\u914d\u540e\uff0c" + oppoRecycleMessageVo.getReRecycleNoTwiceTrackNum1() + "\u5929\u5185\u8ddf\u8fdb\u8fc7\uff0c\u53c8\u8d85\u8fc7" + oppoRecycleMessageVo.getReRecycleNoTwiceTrackNum2() + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u81ea\u52a8\u5212\u5165\u81f3\u539f\u516c\u6d77");
            this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
            this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
        }
    }
}

