/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelStyle {
    private HSSFWorkbook workbook = null;
    private String address = "";
    private String titleFontType = "Arial Unicode MS";
    private String titleBackColor = "C1FBEE";
    private short titleFontSize = (short)12;
    private String contentFontType = "Arial Unicode MS";
    private short contentFontSize = (short)12;

    public static CellStyle getColumnTopStyle(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)14);
        font.setBold(true);
        font.setFontName("\u65b9\u6b63\u5c0f\u6807\u5b8b\u7b80\u4f53");
        CellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor((short)0);
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor((short)0);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor((short)0);
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor((short)0);
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public static CellStyle getColumnStyle(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        font.setFontName("\u65b9\u6b63\u5c0f\u6807\u5b8b\u7b80\u4f53");
        CellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor((short)0);
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor((short)0);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor((short)0);
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor((short)0);
        style.setFont(font);
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public static CellStyle getStyle(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("\u65b9\u6b63\u5c0f\u6807\u5b8b\u7b80\u4f53");
        CellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor((short)0);
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor((short)0);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor((short)0);
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor((short)0);
        style.setFont(font);
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public CellStyle setColor(CellStyle style, String color, short index) {
        if ("".equals(color)) {
            int r = Integer.parseInt(color.substring(0, 2), 16);
            int g = Integer.parseInt(color.substring(2, 4), 16);
            int b = Integer.parseInt(color.substring(4, 6), 16);
            HSSFPalette palette = this.workbook.getCustomPalette();
            palette.setColorAtIndex(index, (byte)r, (byte)g, (byte)b);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(index);
        }
        return style;
    }

    public CellStyle setFontAndBorder(CellStyle style, String fontName, short size) {
        HSSFFont font = this.workbook.createFont();
        font.setFontHeightInPoints(size);
        font.setFontName(fontName);
        font.setBold(true);
        style.setFont((Font)font);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        return style;
    }

    public void setTitleFontType(String titleFontType) {
        this.titleFontType = titleFontType;
    }

    public void setTitleBackColor(String titleBackColor) {
        this.titleBackColor = titleBackColor;
    }

    public void setTitleFontSize(short titleFontSize) {
        this.titleFontSize = titleFontSize;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setContentFontType(String contentFontType) {
        this.contentFontType = contentFontType;
    }

    public void setContentFontSize(short contentFontSize) {
        this.contentFontSize = contentFontSize;
    }
}

