/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.gson.Gson;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.fileInfo.dto.FileInfoAPIDto;
import com.jxdinfo.crm.common.api.fileInfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.common.api.util.sort.SortOrderQo;
import com.jxdinfo.crm.core.api.bid.service.IBidDataRightModuleService;
import com.jxdinfo.crm.core.api.bid.vo.BidVo;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.bid.constant.BidConstant;
import com.jxdinfo.crm.core.bid.dao.BidFileMapper;
import com.jxdinfo.crm.core.bid.dao.BidMapper;
import com.jxdinfo.crm.core.bid.dto.BidAssociativeQueryDto;
import com.jxdinfo.crm.core.bid.dto.BidDataDto;
import com.jxdinfo.crm.core.bid.dto.BidDto;
import com.jxdinfo.crm.core.bid.dto.BidTransDto;
import com.jxdinfo.crm.core.bid.model.Bid;
import com.jxdinfo.crm.core.bid.model.BidQuote;
import com.jxdinfo.crm.core.bid.service.BidService;
import com.jxdinfo.crm.core.bid.service.IBidAssociativeQueryService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.crm.datasourcefolder.sysfileinfo1.service.SysFileInfo1Service;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.focus.dao.FocusMapper;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BidServiceImpl
extends ServiceImpl<BidMapper, Bid>
implements BidService {
    private static final Logger log = LoggerFactory.getLogger(BidServiceImpl.class);
    @Resource
    private IBidAssociativeQueryService bidAssociativeQueryService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private BidMapper bidMapper;
    @Resource
    private CommonService commonService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private CustomerService customerService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private SysFileInfo1Service sysFileInfoService;
    @Resource
    private BidFileMapper bidFileMapper;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private FocusMapper focusMapper;
    @Resource
    private ITeamMemberApiService teamMemberApiService;
    @Resource
    private IBidDataRightModuleService bidDataRightModuleService;
    @Resource
    private IHussarBaseResourceAdapter hussarBaseResourceAdapter;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;
    @Resource
    private ITaskAPIService taskAPIService;

    @Override
    public ApiResponse<?> bidList(BidDto queryDto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto permissionDto = this.bidDataRightModuleService.getUserRolePermission(user);
        BidDto bidDto = queryDto;
        if (queryDto.getBidView() != null && !queryDto.getBidView().equals("preview")) {
            bidDto = this.getBidDtoList(queryDto);
        }
        this.handleBidDto(bidDto, queryDto);
        Page page = queryDto.getPage();
        String timeOrder = bidDto.getTimeOrder();
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        if (ToolUtil.isNotEmpty(bidDto.getSortOrderList())) {
            for (SortOrderQo sortOrder : bidDto.getSortOrderList()) {
                if (!ToolUtil.isNotEmpty((Object)sortOrder.getSortField()) || !ToolUtil.isNotEmpty((Object)sortOrder.getSortOrder())) continue;
                OrderItem orderItem = new OrderItem();
                orderItem.setColumn("A." + this.getSortField(sortOrder.getSortField()));
                orderItem.setAsc("asc".equals(sortOrder.getSortOrder()));
                orderItems.add(orderItem);
            }
        }
        if (ToolUtil.isEmpty(orderItems) && ToolUtil.isEmpty((Object)timeOrder)) {
            OrderItem defaultOrderItem = new OrderItem();
            defaultOrderItem.setColumn("A.CREATE_TIME");
            defaultOrderItem.setAsc(false);
            orderItems.add(defaultOrderItem);
            page.addOrder(orderItems);
        }
        page.addOrder(orderItems);
        bidDto.setDeleteState("0");
        bidDto.setCreateUser(BaseSecurityUtil.getUser().getUserId().toString());
        List<Bid> list = ((BidMapper)this.baseMapper).selectBidList(bidDto, permissionDto, (Page<Bid>)page);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("list", list);
        resultMap.put("totalCount", page.getTotal());
        return ApiResponse.success(resultMap);
    }

    @Override
    public ApiResponse deleteBidByIds(BidDto dto) {
        List<String> bidIds = dto.getBidIdList();
        List<String> states = ((BidMapper)this.baseMapper).selectBidListByIds(bidIds);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"BID_ID", bidIds);
        updateWrapper.set((Object)"DEL_STATE", (Object)"1");
        int count = ((BidMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
        if (count != bidIds.size()) {
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BidVo getBidDetail(Long id) {
        if (CommonConstant.noPermission.equals(this.isOperate(id))) {
            return null;
        }
        BidVo bidVo = new BidVo();
        Bid bid = (Bid)this.getById(id);
        bid.setChargePersonId(bid.getChargePerson());
        BeanUtil.copyProperties((Object)bid, (Object)bidVo);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(bid.getBidId());
        BidDto dto = new BidDto();
        dto.setBidId(id);
        List fileRecordIds = this.trackRecordAPIService.selectRelationRecordIds(bid.getBidId());
        if (CollectionUtil.isNotEmpty((Collection)fileRecordIds)) {
            businessIds.addAll(fileRecordIds);
        }
        FileInfoAPIDto fileInfoDto = new FileInfoAPIDto();
        fileInfoDto.setBusinessIds(businessIds);
        Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
        if (HussarUtils.isNotEmpty((Object)userSecurityLevel)) {
            fileInfoDto.setSecurityLevel(userSecurityLevel);
        }
        bidVo.setFileCount(this.fileInfoAPIService.countFile(fileInfoDto));
        List<Map<String, Object>> quoteList = this.bidFileMapper.getQuoteList(dto, null);
        bidVo.setQuoteList(quoteList);
        bidVo.setFocus(!this.focusMapper.selectCreateId("31", id).isEmpty());
        return bidVo;
    }

    @Override
    public ApiResponse addBid(BidDataDto dto) {
        Boolean result;
        Bid bid = new Bid();
        BeanUtil.copyProperties((Object)dto, (Object)bid);
        SecurityUser user = BaseSecurityUtil.getUser();
        String userName = user.getUserName();
        Date date = new Date();
        assert (bid != null);
        Long bidId = bid.getBidId();
        if (bid.getBidId() == null) {
            bidId = Long.parseLong(CommonUtills.generateAssignId());
            bid.setBidId(bidId);
            bid.setDelState("0");
            bid.setCreateTime(date);
            bid.setCreateUser(user.getUserId());
            bid.setCreateUserName(userName);
            bid.setCreateDepartment(user.getDeptId());
            bid.setCreateDepartmentName(user.getDeptName());
            Long chargePersonId = dto.getChargePerson();
            String chargePersonName = dto.getChargePersonName();
            if (chargePersonId != null && chargePersonName != null) {
                bid.setChargePerson(chargePersonId);
                bid.setChargePersonName(chargePersonName);
                this.teamMeberService.insertTeamMember(bid.getChargePersonName(), bid.getChargePerson(), bidId, "1", "1", LocalDateTime.now(), "31");
            }
            bid.setState("1");
            bid.setBidStage("1");
        }
        if ((result = Boolean.valueOf(this.saveOrUpdate(bid))).booleanValue()) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public ApiResponse editBid(BidDataDto dto) {
        Bid bid = new Bid();
        BeanUtil.copyProperties((Object)dto, (Object)bid);
        SecurityUser user = BaseSecurityUtil.getUser();
        String userName = user.getUserName();
        Date date = new Date();
        bid.setUpdateTime(date);
        bid.setUpdateUser(user.getUserId());
        bid.setUpdateUserName(userName);
        boolean result = this.saveOrUpdate(bid);
        this.fileInfoAPIService.deleteHighSecurityLevelFileInfo(bid.getBidId(), bid.getSecurityLevel());
        this.taskAPIService.updateTaskSecurityLevel(bid.getBidId(), bid.getSecurityLevel());
        this.fileInfoAPIService.updateTrackFileInfoSecurityLevel(bid.getBidId(), bid.getSecurityLevel());
        if (result) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ApiResponse transfer(List<BidTransDto> dtos) {
        ArrayList<String> msgList;
        void var21_28;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int dtoSize = dtos.size();
        int undistributedNum = 0;
        int noPermissionForOpportunityNum = 0;
        int noPermissionForCustomerNum = 0;
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId(dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        SecurityUser newChargePeron = this.commonMapper.selectSecurityByUserId(Long.valueOf(newChargePersonId));
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        ArrayList<Long> excludebidIdList = new ArrayList<Long>();
        List<Long> bidIdList = dtos.stream().map(BidTransDto::getBidId).collect(Collectors.toList());
        List bidList = this.listByIds(bidIdList);
        for (BidTransDto bidTransDto : dtos) {
            for (Object bid2 : bidList) {
                if (!((Bid)bid2).getBidId().equals(bidTransDto.getBidId())) continue;
                bidTransDto.setCustomerId(((Bid)bid2).getCustomerId() != null ? String.valueOf(((Bid)bid2).getCustomerId()) : null);
            }
            Bid bid2 = bidList.stream().filter(object -> Objects.equals(object.getBidId(), dto.getBidId())).findFirst().get();
            if (!ToolUtil.isEmpty((Object)bid2.getChargePerson())) continue;
            excludebidIdList.add(bidTransDto.getBidId());
            ++undistributedNum;
        }
        for (Long l : excludebidIdList) {
            dtos = dtos.stream().filter(bid -> !bid.getBidId().equals(l)).collect(Collectors.toList());
        }
        bidIdList = dtos.stream().map(BidTransDto::getBidId).collect(Collectors.toList());
        excludebidIdList.clear();
        Map<Object, Object> operateFlagMap = new HashMap();
        if (ToolUtil.isNotEmpty(bidIdList)) {
            operateFlagMap = this.isOperateByBatch(user, bidIdList, "transfer");
        }
        for (Map.Entry entry : operateFlagMap.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            excludebidIdList.add((Long)entry.getKey());
            ++noPermissionForOpportunityNum;
        }
        for (Long l : excludebidIdList) {
            dtos = dtos.stream().filter(bid -> !bid.getBidId().equals(excludeOpportunityId)).collect(Collectors.toList());
        }
        bidIdList = dtos.stream().map(BidTransDto::getBidId).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(bidIdList)) {
            List list = this.listByIds(bidIdList);
        } else {
            ArrayList arrayList = new ArrayList();
        }
        ArrayList arrayList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)var21_28)) {
            List<CustomerEntity> list = this.customerMapper.selectCustomerEntityList((List)var21_28);
        }
        excludebidIdList.clear();
        for (Bid bid4 : (List)var21_28) {
            Object customer2;
            Boolean customerOperate;
            void var22_40;
            Optional<CustomerEntity> optionalCustomer = var22_40.stream().filter(customer -> customer.getCustomerId().equals(bid4.getCustomerId())).findFirst();
            if (!optionalCustomer.isPresent() || (customerOperate = this.customerService.editCustomerOperate((CustomerEntity)(customer2 = optionalCustomer.get()), newChargePeron, "customer_edit")).booleanValue()) continue;
            excludebidIdList.add(bid4.getBidId());
            ++noPermissionForCustomerNum;
        }
        for (Long excludeOpportunityId : excludebidIdList) {
            dtos = dtos.stream().filter(bid -> !bid.getBidId().equals(excludeOpportunityId)).collect(Collectors.toList());
        }
        bidIdList = dtos.stream().map(BidTransDto::getBidId).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(bidIdList)) {
            List list = this.listByIds(bidIdList);
        } else {
            ArrayList arrayList2 = new ArrayList();
        }
        ArrayList<BidTransDto> dtoList = new ArrayList<BidTransDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        int alreadyChargePersonNum = 0;
        for (BidTransDto dto : dtos) {
            void var21_31;
            Iterator bid5 = ((List)var21_31).stream().filter(object -> Objects.equals(object.getBidId(), dto.getBidId())).findFirst().get();
            String string = dto.getOldChargePersonName();
            String string2 = dto.getOldChargePersonId();
            String string3 = dto.getKeepFlag();
            if (newChargePersonId.equals(string2)) {
                ++alreadyChargePersonNum;
                continue;
            }
            String bidName = ((Bid)((Object)bid5)).getBidName();
            dto.setChangeTime(LocalDateTime.now());
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setNewChargePersonId(newChargePersonId);
            dto.setBidName(bidName);
            dtoList.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(dto.getBidId());
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (dtoList.size() + alreadyChargePersonNum == dtoSize) {
            resultVo.setTransferResult(true);
            msgList = new ArrayList<String>();
            msgList.add("\u8f6c\u79fb\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(false);
            if (dtoSize == 1) {
                msgList = new ArrayList();
                if (undistributedNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u6295\u6807\u672a\u5206\u914d");
                } else if (noPermissionForOpportunityNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u6295\u6807\u65e0\u6743\u9650");
                } else if (noPermissionForCustomerNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u63a5\u53d7\u4eba\u65e0\u5ba2\u6237\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                String msg = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", dtoList.size() + alreadyChargePersonNum, dtoSize - dtoList.size() - alreadyChargePersonNum);
                if (noPermissionForOpportunityNum != 0) {
                    msg = msg + "\u6295\u6807\u65e0\u6743\u9650\uff08" + noPermissionForOpportunityNum + "\u6761\uff09\uff1b";
                }
                if (noPermissionForCustomerNum != 0) {
                    msg = msg + "\u63a5\u53d7\u4eba\u65e0\u5ba2\u6237\u6743\u9650\uff08" + noPermissionForCustomerNum + "\u6761\uff09\uff1b";
                }
                if (undistributedNum != 0) {
                    msg = msg + "\u6295\u6807\u672a\u5206\u914d\uff08" + undistributedNum + "\u6761\uff09\uff1b";
                }
                msg = msg.substring(0, msg.length() - 1);
                ArrayList<String> msgList2 = new ArrayList<String>();
                msgList2.add(msg);
                resultVo.setMsgList(msgList2);
            }
        }
        if (dtoList.isEmpty()) {
            return ApiResponse.success((Object)resultVo);
        }
        this.bidMapper.updateChargePersonByBatch(dtoList);
        if (ToolUtil.isNotEmpty(dtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList;
            String keepFlag = ((BidTransDto)dtoList.get(0)).getKeepFlag();
            if ("0".equals(keepFlag)) {
                teamMeberEntityList = new ArrayList<TeamMeberEntity>();
                for (BidTransDto bidTransDto : dtoList) {
                    TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                    teamMeberEntity.setBusinessId(bidTransDto.getBidId());
                    teamMeberEntity.setDelFlag("1");
                    teamMeberEntity.setPersonId(Long.valueOf(bidTransDto.getOldChargePersonId()));
                    teamMeberEntityList.add(teamMeberEntity);
                }
                this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
            } else if ("1".equals(keepFlag)) {
                teamMeberEntityList = new ArrayList();
                for (BidTransDto bidTransDto : dtoList) {
                    TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                    teamMeberEntity.setBusinessId(bidTransDto.getBidId());
                    teamMeberEntity.setPersonId(Long.valueOf(bidTransDto.getOldChargePersonId()));
                    teamMeberEntity.setIsCharge("0");
                    teamMeberEntity.setMemberRole("6");
                    teamMeberEntity.setModifyPower(null);
                    teamMeberEntityList.add(teamMeberEntity);
                }
                this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
            }
        }
        List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<BidTransDto> insertMemberDtoList = new ArrayList<BidTransDto>();
        ArrayList<BidTransDto> updateChargeDtoList = new ArrayList<BidTransDto>();
        for (BidTransDto bidTransDto : dtoList) {
            boolean bl = true;
            for (Map map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(bidTransDto.getBidId())) continue;
                updateChargeDtoList.add(bidTransDto);
                bl = false;
                break;
            }
            if (!bl) continue;
            insertMemberDtoList.add(bidTransDto);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> arrayList3 = new ArrayList<TeamMeberEntity>();
            for (BidTransDto bidTransDto : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(bidTransDto.getBidId());
                teamMeberEntity.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity.setIsCharge("1");
                teamMeberEntity.setMemberRole(null);
                teamMeberEntity.setModifyPower("1");
                arrayList3.add(teamMeberEntity);
            }
            this.teamMeberMapper.updateIsChargeBatch(arrayList3);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.parseLong(newChargePersonId), insertMemberDtoList.stream().map(BidTransDto::getBidId).collect(Collectors.toList()), "1", "1", ((BidTransDto)insertMemberDtoList.get(0)).getChangeTime(), "bid");
        }
        ArrayList<Long> arrayList4 = new ArrayList<Long>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        for (BidTransDto dto : dtoList) {
            arrayList4.add(Long.parseLong(dto.getOldChargePersonId()));
            arrayList5.add(dto.getOldChargePersonName());
        }
        this.addTrackRecordBatch(dtoList, arrayList4, arrayList5, newChargePersonId, newChargePersonName);
        for (BidTransDto dto : dtoList) {
            Long l = dto.getBidId();
            LocalDateTime date = dto.getChangeTime();
            String bidName = dto.getBidName();
            String oldChargePersonId = dto.getOldChargePersonId();
            String title = userName + "\u5c06\u6295\u6807\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8";
            String content = "\u6295\u6807\u540d\u79f0\u3010" + bidName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", l.toString(), Arrays.asList(newChargePersonId));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=\"" + l + "\"";
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u6295\u6807\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8\uff0c\u6295\u6807\u540d\u79f0\u3010" + bidName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, newChargePersonId, userName, unifyWebUrl, "");
            addSysMessageType.setMessageTypeId(BidConstant.MESSAGE_TYPE_BID);
            UnifyUtil.sendMessage(addSysMessageType);
            String oldTitle = userName + "\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u6295\u6807";
            String oldContent = "\u6295\u6807\u540d\u79f0\u3010" + bidName + "\u3011\uff0c\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushUtil.pushJqxArticleMessage(oldTitle, oldContent, "/crm/sj/sjxq/xxzl", l.toString(), Arrays.asList(oldChargePersonId));
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            String oldContentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + "\u5c06\u60a8\u8d1f\u8d23\u7684\u6295\u6807\u3010" + bidName + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage(oldAddSysMessageType, oldContentUnify, date, user, oldChargePersonId, userName, unifyWebUrl, "");
            addSysMessageType.setMessageTypeId(BidConstant.MESSAGE_TYPE_BID);
            UnifyUtil.sendMessage(oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("bid");
            crmTeamAdminInfoDto.setBusinessId(l);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(dto.getOldChargePersonId());
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return ApiResponse.success((Object)resultVo);
    }

    @Override
    public ApiResponse transferChargePerson(BidDto dto) {
        String type = dto.getOperateType();
        String newChargePersonId = dto.getNewChargePersonId();
        String newChargePersonName = dto.getNewChargePersonName();
        List bidList = this.list((Wrapper)new QueryWrapper().in((Object)"BID_ID", dto.getBidIdList()));
        List stateList = bidList.stream().map(Bid::getState).collect(Collectors.toList());
        this.dealMemberInfo(dto, bidList, newChargePersonId, newChargePersonName);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"CHARGE_PERSON", (Object)dto.getNewChargePersonId())).set((Object)"CHARGE_PERSON_NAME", (Object)dto.getNewChargePersonName())).set((Object)"UPDATE_TIME", (Object)new Date())).set((Object)"UPDATE_USER", (Object)BaseSecurityUtil.getUser().getUserId())).set((Object)"UPDATE_USER_NAME", (Object)BaseSecurityUtil.getUser().getUserName())).set("0".equals(type), (Object)"STATE", (Object)"1")).in((Object)"BID_ID", dto.getBidIdList());
        boolean result = this.update((Wrapper)updateWrapper);
        if (result) {
            return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    private void dealMemberInfo(BidDto dto, List<Bid> bidList, String newChargePersonId, String newChargePersonName) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        ArrayList<Object> dtoList = new ArrayList<Object>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        if (ToolUtil.isNotEmpty(bidList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList;
            String keepFlag = dto.getKeepFlag();
            if ("0".equals(keepFlag)) {
                teamMeberEntityList = new ArrayList<TeamMeberEntity>();
                for (Bid bid : bidList) {
                    TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                    teamMeberEntity.setBusinessId(bid.getBidId());
                    teamMeberEntity.setDelFlag("1");
                    teamMeberEntity.setPersonId((long)bid.getChargePerson());
                    teamMeberEntityList.add(teamMeberEntity);
                }
                this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
            } else if ("1".equals(keepFlag)) {
                teamMeberEntityList = new ArrayList();
                for (Bid bid : bidList) {
                    TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                    teamMeberEntity.setBusinessId(bid.getBidId());
                    teamMeberEntity.setPersonId((long)bid.getChargePerson());
                    teamMeberEntity.setIsCharge("0");
                    teamMeberEntity.setMemberRole("6");
                    teamMeberEntity.setModifyPower(null);
                    teamMeberEntityList.add(teamMeberEntity);
                }
                this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
            }
        }
        for (Bid bid : bidList) {
            Long oldChargePersonId = bid.getChargePerson();
            if (!ObjectUtils.isEmpty((Object)oldChargePersonId) && (ObjectUtils.isEmpty((Object)oldChargePersonId) || newChargePersonId.equals(oldChargePersonId.toString()))) continue;
            BidTransDto bidTransDto = new BidTransDto();
            String string = bid.getBidName();
            bidTransDto.setBidId(bid.getBidId());
            bidTransDto.setChangeTime(LocalDateTime.now());
            bidTransDto.setChangePerson(userId);
            bidTransDto.setChangePersonName(userName);
            bidTransDto.setOwnDepartment(newOwnDepartment);
            bidTransDto.setOwnDepartmentName(newOwnDepartmentName);
            bidTransDto.setNewChargePersonId(newChargePersonId);
            bidTransDto.setBidName(string);
            dtoList.add(bidTransDto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(bid.getBidId());
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<BidTransDto> insertMemberDtoList = new ArrayList<BidTransDto>();
        ArrayList<BidTransDto> updateChargeDtoList = new ArrayList<BidTransDto>();
        for (BidTransDto bidTransDto : dtoList) {
            boolean flag = true;
            for (Map<String, Object> map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(bidTransDto.getBidId())) continue;
                updateChargeDtoList.add(bidTransDto);
                flag = false;
                break;
            }
            if (!flag) continue;
            insertMemberDtoList.add(bidTransDto);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (BidTransDto bidTransDto : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(bidTransDto.getBidId());
                teamMeberEntity.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity.setIsCharge("1");
                teamMeberEntity.setMemberRole(null);
                teamMeberEntity.setModifyPower("1");
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.parseLong(newChargePersonId), insertMemberDtoList.stream().map(BidTransDto::getBidId).collect(Collectors.toList()), "1", "1", ((BidTransDto)insertMemberDtoList.get(0)).getChangeTime(), "bid");
        }
    }

    @Override
    public ApiResponse changeDept(BidDto dto) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"OWN_DEPARTMENT", (Object)dto.getOwnDepartment())).set((Object)"OWN_DEPARTMENT_NAME", (Object)dto.getOwnDepartmentName())).set((Object)"UPDATE_TIME", (Object)new Date())).set((Object)"UPDATE_USER", (Object)BaseSecurityUtil.getUser().getUserId())).set((Object)"UPDATE_USER_NAME", (Object)BaseSecurityUtil.getUser().getUserName())).in((Object)"BID_ID", dto.getBidIdList());
        boolean result = this.update((Wrapper)updateWrapper);
        if (result) {
            return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public ApiResponse changeStage(BidDto dto) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"BID_STAGE", (Object)dto.getBidStage())).set((Object)"STATE", (Object)"1")).set((Object)"UPDATE_TIME", (Object)new Date())).set((Object)"UPDATE_USER", (Object)BaseSecurityUtil.getUser().getUserId())).set((Object)"UPDATE_USER_NAME", (Object)BaseSecurityUtil.getUser().getUserName())).eq((Object)"BID_ID", (Object)dto.getBidId());
        Bid oldBid = (Bid)this.getById(dto.getBidId());
        boolean result = this.update((Wrapper)updateWrapper);
        if (result) {
            LocalDateTime date = LocalDateTime.now();
            String oldBidStage = "";
            String newBidStage = "";
            if (StringUtil.isNotBlank((CharSequence)oldBid.getBidStage()) && StringUtil.isNotBlank((CharSequence)dto.getBidStage())) {
                oldBidStage = this.sysDicRefService.getDictLabel("bid_stage", oldBid.getBidStage());
                newBidStage = this.sysDicRefService.getDictLabel("bid_stage", dto.getBidStage());
                HashMap<String, String> oldMap = new HashMap<String, String>();
                HashMap<String, String> newMap = new HashMap<String, String>();
                oldMap.put("bidStage", oldBidStage);
                newMap.put("bidStage", newBidStage);
                ArrayList changeFieList = new ArrayList();
                HashMap<String, String> changeFieMap = new HashMap<String, String>();
                changeFieMap.put("fieldName", "\u6295\u6807\u9636\u6bb5");
                changeFieMap.put("field", "bidStage");
                changeFieList.add(changeFieMap);
                Gson gson = new Gson();
                OperateRecordAPIVo trackRecord = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.BID_CHANGE_STAGE.getId(), new JSONObject(oldMap).toJSONString(), new JSONObject(newMap).toJSONString(), gson.toJson(changeFieList));
                this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.BID, dto.getBidId(), dto.getBidName(), date, false, Arrays.asList(dto.getBidId()));
            }
            return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public ApiResponse changeResult(BidDto dto) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"BID_STAGE", (Object)"6")).set("7".equals(dto.getResultType()), (Object)"STATE", (Object)"2")).set("8".equals(dto.getResultType()), (Object)"STATE", (Object)"3")).set("9".equals(dto.getResultType()), (Object)"STATE", (Object)"4")).set((Object)"RESULT_TYPE", (Object)dto.getResultType())).set((Object)"RESULT_TIME", (Object)dto.getResultTime())).set((Object)"RESULT_REMARK", (Object)dto.getResultRemark())).set((Object)"RESULT_REASON", (Object)dto.getResultReason())).set((Object)"UPDATE_TIME", (Object)new Date())).set((Object)"UPDATE_USER", (Object)BaseSecurityUtil.getUser().getUserId())).set((Object)"UPDATE_USER_NAME", (Object)BaseSecurityUtil.getUser().getUserName())).eq((Object)"BID_ID", (Object)dto.getBidId());
        Bid oldBid = (Bid)this.getById(dto.getBidId());
        boolean result = this.update((Wrapper)updateWrapper);
        if (result) {
            LocalDateTime date = LocalDateTime.now();
            String oldBidResult = "";
            String newBidResult = "";
            String oldBidStage = "";
            String newBidStage = "";
            if (StringUtil.isNotBlank((CharSequence)oldBid.getResultType())) {
                oldBidResult = this.sysDicRefService.getDictLabel("bidResultType", oldBid.getResultType());
            }
            if (StringUtil.isNotBlank((CharSequence)dto.getResultType())) {
                newBidResult = this.sysDicRefService.getDictLabel("bidResultType", dto.getResultType());
            }
            oldBidStage = this.sysDicRefService.getDictLabel("bid_stage", oldBid.getBidStage());
            newBidStage = this.sysDicRefService.getDictLabel("bid_stage", "6");
            LinkedHashMap<String, String> oldMap = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>();
            oldMap.put("bidStage", oldBidStage);
            oldMap.put("bidResult", oldBidResult);
            newMap.put("bidStage", newBidStage);
            newMap.put("bidResult", newBidResult);
            ArrayList changeFieList = new ArrayList();
            HashMap<String, String> changeFieMap1 = new HashMap<String, String>();
            changeFieMap1.put("fieldName", "\u6295\u6807\u9636\u6bb5");
            changeFieMap1.put("field", "bidStage");
            HashMap<String, String> changeFieMap2 = new HashMap<String, String>();
            changeFieMap2.put("fieldName", "\u6295\u6807\u7ed3\u679c");
            changeFieMap2.put("field", "bidResult");
            changeFieList.add(changeFieMap1);
            changeFieList.add(changeFieMap2);
            Gson gson = new Gson();
            OperateRecordAPIVo trackRecord = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.BID_CHANGE_RESULT.getId(), new JSONObject(oldMap).toJSONString(), new JSONObject(newMap).toJSONString(), gson.toJson(changeFieList));
            trackRecord.setRecordContent(dto.getResultReason());
            this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.BID, dto.getBidId(), dto.getBidName(), date, false, Arrays.asList(dto.getBidId()));
            return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public ApiResponse getQuoteList(BidDto bidDto) {
        Page page = new Page();
        page.setCurrent((long)bidDto.getCurrent().intValue());
        page.setSize((long)bidDto.getSize().intValue());
        List<Map<String, Object>> opportunityList = this.bidFileMapper.getQuoteList(bidDto, (Page<Map<String, String>>)page);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("list", opportunityList);
        resultMap.put("totalCount", page.getTotal());
        return ApiResponse.success(resultMap);
    }

    @Override
    public ApiResponse updateStage(BidDto bidDto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        List<Long> quoteIdList = bidDto.getQuoteIdList();
        int num = 0;
        for (Long quoteId : quoteIdList) {
            BidQuote bidQuote = new BidQuote();
            bidQuote.setBidId(bidDto.getBidId());
            bidQuote.setQuoteId(quoteId);
            bidQuote.setCreateUser(Long.parseLong(userId));
            bidQuote.setCreateUserName(userName);
            bidQuote.setCreateDepartment(user.getDeptId());
            bidQuote.setCreateDepartmentName(user.getDeptName());
            bidQuote.setCreateTime(new Date());
            boolean result = bidQuote.insert();
            if (!result) continue;
            ++num;
        }
        if (num == quoteIdList.size()) {
            return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    @Transactional
    public ApiResponse deleteQuoteIdList(BidDto bidDto) {
        List<Long> quoteIdList = bidDto.getQuoteIdList();
        boolean num = false;
        for (Long quoteId : quoteIdList) {
            BidQuote bidQuote = new BidQuote();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"BID_ID", (Object)bidDto.getBidId());
            wrapper.eq((Object)"QUOTE_ID", (Object)quoteId);
            boolean flag = bidQuote.delete((Wrapper)wrapper);
            if (flag) continue;
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public ApiResponse selectStage(BidDto bidDto) {
        String bidStage = bidDto.getBidStage();
        HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>();
        if (bidStage.equals("3")) {
            List<Map<String, String>> quoteList = this.bidFileMapper.getQuotesList(bidDto);
            map.put("quoteList", quoteList);
        }
        return ApiResponse.success(map);
    }

    public void addTrackRecordBatch(List<BidTransDto> dtoList, List<Long> oldContactPersonIdList, List<String> oldContactPersonNameList, String newChargePersonId, String newChargePersonName) {
        ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (int i = 0; i < dtoList.size(); ++i) {
            BidTransDto dto = dtoList.get(i);
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(Long.valueOf(Long.parseLong(newChargePersonId)));
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            if (HussarUtils.isNotEmpty((Object)oldContactPersonIdList.get(i))) {
                operateRecordDO.setOldContactId(oldContactPersonIdList.get(i));
            }
            operateRecordDO.setOldContactName(oldContactPersonNameList.get(i));
            operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType("bid");
            operateRecordDO.setTypeId(dto.getBidId());
            operateRecordDO.setBusinessName(dto.getBidName());
            operateRecordDO.setCreatePerson(user.getUserId());
            operateRecordDO.setCreatePersonName(user.getUserName());
            operateRecordDO.setCreateTime(date);
            operateRecordDO.setChangePerson(user.getUserId());
            operateRecordDO.setChangeTime(date);
            operateRecordDO.setChangePersonName(user.getUserName());
            operateRecordDO.setDelflag("0");
            if (operateRecordDO.getProduceType() == null) {
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            operateRecordDOList.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
    }

    public Map<Long, Boolean> isOperateByBatch(SecurityUser user, List<Long> bidIdList, String resourcePath) {
        HashMap<Long, Boolean> permissionFlagMap = new HashMap<Long, Boolean>();
        List bidList = this.listByIds(bidIdList);
        HashSet existingIds1 = new HashSet();
        bidList.stream().filter(bid -> user.getUserId().equals(bid.getChargePerson())).forEach(bid -> {
            existingIds1.add(bid.getBidId());
            permissionFlagMap.put(bid.getBidId(), true);
        });
        bidIdList.remove(existingIds1);
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getBusinessId, bidIdList)).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"31"));
        HashSet existingIds2 = new HashSet();
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            teamList.forEach(team -> {
                existingIds2.add(team.getBusinessId());
                permissionFlagMap.put(team.getBusinessId(), "1".equals(team.getModifyPower()));
            });
            bidIdList.removeAll(existingIds2);
        }
        if (!bidIdList.isEmpty()) {
            List elementResourceVos = this.hussarBaseResourceAdapter.elementResources("/tbModule/toubiaoguanli", user.getRolesList());
            Set<Object> resourceSet = new HashSet();
            if (CollectionUtil.isNotEmpty((Collection)elementResourceVos) && ((ElementResourceVo)elementResourceVos.get(0)).getPermission() != null) {
                resourceSet = Arrays.stream(((ElementResourceVo)elementResourceVos.get(0)).getPermission().split(",")).collect(Collectors.toSet());
            }
            for (Long bidId : bidIdList) {
                try {
                    if (resourceSet.contains(resourcePath)) {
                        permissionFlagMap.put(bidId, true);
                        continue;
                    }
                    permissionFlagMap.put(bidId, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    permissionFlagMap.put(bidId, false);
                }
            }
        }
        return permissionFlagMap;
    }

    @Override
    public List<AssociativeQueryVo> associativeQueryNew(BidAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getKeyWord();
        }
        IBidAssociativeQueryService adapterService = this.bidAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("keyWord");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    private BidDto getBidDtoList(BidDto bidDto) {
        BidDto queryDto = new BidDto();
        String view = bidDto.getBidView();
        if (StringUtil.isNotEmpty((Object)view)) {
            CrmScene crmScene;
            long queryType = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)queryType);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"bid");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)((Object)crmSceneList.get(0))).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        queryDto = (BidDto)((Object)JSONObject.parseObject((String)queryValue, BidDto.class));
                    }
                }
                catch (Exception var14) {
                    Exception e = var14;
                    throw new RuntimeException(e);
                }
            }
        }
        return queryDto;
    }

    private void handleBidDto(BidDto bidDto, BidDto queryDto) {
        DateConvertVo dateConvertVo;
        SecurityUser user = BaseSecurityUtil.getUser();
        bidDto.setLoginUserId(user.getUserId().toString());
        if (ToolUtil.isNotEmpty((Object)queryDto.getCreateTimeFlag()) && !"6".equals(queryDto.getCreateTimeFlag())) {
            dateConvertVo = CrmDateUtils.getCurrentTime((String)queryDto.getCreateTimeFlag());
            if (dateConvertVo != null) {
                bidDto.setStartTime(dateConvertVo.getStartDate());
                bidDto.setFinalTime(dateConvertVo.getEndDate());
            }
        } else if ("6".equals(queryDto.getCreateTimeFlag())) {
            bidDto.setStartTime(queryDto.getStartTime());
            bidDto.setFinalTime(queryDto.getFinalTime());
        }
        if (ToolUtil.isNotEmpty((Object)queryDto.getBidStartTimeFlag()) && !"6".equals(queryDto.getBidStartTimeFlag())) {
            dateConvertVo = CrmDateUtils.getCurrentTime((String)queryDto.getBidStartTimeFlag());
            if (dateConvertVo != null) {
                bidDto.setBidStartTime(dateConvertVo.getStartDate());
                bidDto.setBidFinalTime(dateConvertVo.getEndDate());
            }
        } else if ("6".equals(queryDto.getBidStartTimeFlag())) {
            bidDto.setBidStartTime(queryDto.getBidStartTime());
            bidDto.setBidFinalTime(queryDto.getBidFinalTime());
        }
        if (ToolUtil.isNotEmpty((Object)queryDto.getBidPurchaseEndTimeFlag()) && !"6".equals(queryDto.getBidPurchaseEndTimeFlag())) {
            dateConvertVo = CrmDateUtils.getCurrentTime((String)queryDto.getBidPurchaseEndTimeFlag());
            if (dateConvertVo != null) {
                bidDto.setBidPurchaseEndStartTime(dateConvertVo.getStartDate());
                bidDto.setBidPurchaseEndFinalTime(dateConvertVo.getEndDate());
            }
        } else if ("6".equals(queryDto.getBidPurchaseEndTimeFlag())) {
            bidDto.setBidPurchaseEndStartTime(queryDto.getBidPurchaseEndStartTime());
            bidDto.setBidPurchaseEndFinalTime(queryDto.getBidPurchaseEndFinalTime());
        }
        if (ToolUtil.isNotEmpty((Object)queryDto.getBidSubmitEndTimeFlag()) && !"6".equals(queryDto.getBidSubmitEndTimeFlag())) {
            dateConvertVo = CrmDateUtils.getCurrentTime((String)queryDto.getBidSubmitEndTimeFlag());
            if (dateConvertVo != null) {
                bidDto.setBidSubmitEndStartTime(dateConvertVo.getStartDate());
                bidDto.setBidSubmitEndFinalTime(dateConvertVo.getEndDate());
            }
        } else if ("6".equals(queryDto.getBidSubmitEndTimeFlag())) {
            bidDto.setBidSubmitEndStartTime(queryDto.getBidSubmitEndStartTime());
            bidDto.setBidSubmitEndFinalTime(queryDto.getBidSubmitEndFinalTime());
        }
        if (ToolUtil.isNotEmpty((Object)queryDto.getBidOpenDateFlag()) && !"6".equals(queryDto.getBidOpenDateFlag())) {
            dateConvertVo = CrmDateUtils.getCurrentTime((String)queryDto.getBidOpenDateFlag());
            if (dateConvertVo != null) {
                bidDto.setBidOpenDateStartTime(dateConvertVo.getStartDate());
                bidDto.setBidOpenDateFinalTime(dateConvertVo.getEndDate());
            }
        } else if ("6".equals(queryDto.getBidOpenDateFlag())) {
            bidDto.setBidOpenDateStartTime(queryDto.getBidOpenDateStartTime());
            bidDto.setBidOpenDateFinalTime(queryDto.getBidOpenDateFinalTime());
        }
        if (ToolUtil.isNotEmpty((Object)queryDto.getKeyWord())) {
            bidDto.setKeyWord(queryDto.getKeyWord());
        }
        if (ToolUtil.isNotEmpty((Object)queryDto.getBidName())) {
            bidDto.setBidName(queryDto.getBidName());
        }
        if (ToolUtil.isNotEmpty(queryDto.getCustomerIdList())) {
            bidDto.setCustomerIdList(queryDto.getCustomerIdList());
        }
        if (ToolUtil.isNotEmpty(queryDto.getBidStageList())) {
            bidDto.setBidStageList(queryDto.getBidStageList());
        }
        if (ToolUtil.isNotEmpty(queryDto.getChargePersonList())) {
            bidDto.setChargePersonList(queryDto.getChargePersonList());
        }
        if (ToolUtil.isNotEmpty(queryDto.getBidTypeList())) {
            bidDto.setBidTypeList(queryDto.getBidTypeList());
        }
        if (ToolUtil.isNotEmpty(queryDto.getOwnDepartmentList())) {
            bidDto.setOwnDepartmentList(queryDto.getOwnDepartmentList());
        }
        if (ToolUtil.isNotEmpty(queryDto.getOwnUnitList())) {
            bidDto.setOwnUnitList(queryDto.getOwnUnitList());
        }
        if (ToolUtil.isNotEmpty((Object)queryDto.getBidView())) {
            bidDto.setBidView(queryDto.getBidView());
        }
        if (ToolUtil.isNotEmpty(queryDto.getSortOrderList())) {
            bidDto.setSortOrderList(queryDto.getSortOrderList());
        }
        if (CollectionUtil.isNotEmpty(queryDto.getOwnDepartmentList())) {
            List<String> departments = queryDto.getOwnDepartmentList();
            ArrayList<String> odpIds = new ArrayList<String>();
            if (ToolUtil.isNotEmpty(departments) && !departments.isEmpty()) {
                for (String longOdpId : departments) {
                    ArrayList<String> Ids;
                    String odpId = String.valueOf(longOdpId);
                    String odpIsTemp = CommonUtills.translateDepId(odpId);
                    List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, Ids = new ArrayList<String>());
                    if (idsTemp.isEmpty()) continue;
                    for (int i = 0; i < idsTemp.size(); ++i) {
                        odpIds.add(idsTemp.get(i));
                    }
                }
                bidDto.setOwnDepartmentList(odpIds);
            }
        }
    }

    public String getSortField(String field) {
        StringBuffer buffer = new StringBuffer();
        for (char c : field.toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                buffer.append("_" + c);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString().toLowerCase();
    }

    public static List<Long> convertStringListToLongList(List<String> stringList) {
        ArrayList<Long> longList = new ArrayList<Long>();
        for (String str : stringList) {
            try {
                longList.add(Long.parseLong(str));
            }
            catch (NumberFormatException e) {
                System.err.println("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32 '" + str + "' \u8f6c\u6362\u4e3aLong\u7c7b\u578b");
            }
        }
        return longList;
    }

    public static List<String> convertLongListToStringList(List<Long> longList) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Long num : longList) {
            stringList.add(num.toString());
        }
        return stringList;
    }

    @Override
    public OperateVo isOperate(Long bidId) {
        PermissionDto invoicePermissionDto;
        Integer count;
        OperateVo operateVo = new OperateVo();
        if (bidId == null) {
            return operateVo;
        }
        Bid bid = (Bid)this.getById(bidId);
        if (bid == null || "1".equals(bid.getDelState())) {
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)user.getSecurityLevel()) && user.getSecurityLevel() < bid.getSecurityLevel()) {
            return operateVo;
        }
        if (Objects.equals(bid.getChargePerson(), user.getUserId())) {
            operateVo.setEditOperate(Integer.valueOf(1));
            operateVo.setViewOperate(Boolean.valueOf(true));
            return operateVo;
        }
        this.teamMemberApiService.teamMemberOperate(bidId, user, operateVo, "31");
        if (!operateVo.getViewOperate().booleanValue() && bid.getOpportunityId() != null && (count = this.opportunityMapper.getProductManagerByOpportunityId(bid.getOpportunityId(), "0", user.getUserId())) > 0) {
            operateVo.setViewOperate(Boolean.valueOf(true));
        }
        if (!operateVo.getViewOperate().booleanValue() && ((invoicePermissionDto = this.bidDataRightModuleService.getUserRolePermission(user)).getPermissionDeptIds() == null || invoicePermissionDto.getPermissionDeptIds().contains(bid.getOwnDepartment()))) {
            operateVo.setViewOperate(Boolean.valueOf(true));
        }
        return operateVo;
    }

    @Override
    public ApiResponse<?> bidOverdue() {
        BidDto dto = new BidDto();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate now = LocalDate.now();
        LocalDate sevenDate = now.plusDays(7L);
        LocalDate threeDate = now.plusDays(3L);
        String sevenDay = formatter.format(sevenDate);
        dto.setSubmitTime(sevenDay);
        List<Bid> bidSevenList = this.bidMapper.getBidOverdueList(dto);
        String threeDay = formatter.format(threeDate);
        dto.setSubmitTime(threeDay);
        List<Bid> bidThreeList = this.bidMapper.getBidOverdueList(dto);
        ArrayList<Bid> bidList = new ArrayList<Bid>();
        bidList.addAll(bidSevenList);
        bidList.addAll(bidThreeList);
        if (bidList != null && bidList.size() > 0) {
            for (Bid bid : bidList) {
                String userName = bid.getChargePersonName();
                Long userId = bid.getChargePerson();
                String customerName = bid.getCustomerName();
                String bidNumber = bid.getBidNumber();
                String bidName = bid.getBidName();
                String bidSubmitEndTime = sdf.format(bid.getBidSubmitEndTime());
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/tbModule/toubiaoDetails?row=" + "\"" + bid.getBidId() + "\"";
                String contentUnifyManager = "\u60a8\u7684\u5ba2\u6237\u3010" + customerName + "\u3011\u7684\u6295\u6807\u3010" + bidNumber + "," + bidName + "\u3011\u4e0b\u7684\u6295\u6807\u6587\u4ef6\u9012\u4ea4\u5c06\u4e8e\u3010" + bidSubmitEndTime + "\u3011\u622a\u6b62\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8";
                AddSysMessageType addSysMessageType1 = new AddSysMessageType();
                addSysMessageType1.setBusinessAddress(unifyWebUrl);
                addSysMessageType1.setBusinessType("bid");
                addSysMessageType1.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType1.setMessageContent(contentUnifyManager);
                addSysMessageType1.setReleaseDate(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                addSysMessageType1.setUserId(userId.toString());
                addSysMessageType1.setCreator(bid.getCreateUser());
                addSysMessageType1.setCreatoeDepartmentId(bid.getCreateDepartment().toString());
                if (ToolUtil.isNotEmpty((Object)bid.getUpdateUser())) {
                    addSysMessageType1.setLastEditor(bid.getUpdateUser());
                } else {
                    addSysMessageType1.setLastEditor(bid.getCreateUser());
                }
                addSysMessageType1.setMessageIssue("\u8d85\u7ea7\u7ba1\u7406\u5458");
                addSysMessageType1.setBusinessAddress(unifyWebUrl);
                addSysMessageType1.setMobileBusinessAddress("");
                addSysMessageType1.setOpenWay("1");
                UnifyUtil.sendMessage(addSysMessageType1);
            }
        }
        return ApiResponse.success((String)"\u5f53\u524d\u6295\u6807\u6587\u4ef6\u9012\u4ea4\u622a\u81f3\u65f6\u95f4\u63d0\u9192\u5df2\u63a8\u9001\u7ed9\u76f8\u5173\u8d1f\u8d23\u4eba\uff01");
    }

    @Override
    public ApiResponse<?> bidOpenOverdue() {
        BidDto dto = new BidDto();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate now = LocalDate.now();
        LocalDate sevenDate = now.plusDays(7L);
        LocalDate threeDate = now.plusDays(3L);
        String sevenDay = formatter.format(sevenDate);
        dto.setOpenTime(sevenDay);
        List<Bid> bidSevenList = this.bidMapper.getBidOverdueList(dto);
        String threeDay = formatter.format(threeDate);
        dto.setOpenTime(threeDay);
        List<Bid> bidThreeList = this.bidMapper.getBidOverdueList(dto);
        ArrayList<Bid> bidList = new ArrayList<Bid>();
        bidList.addAll(bidSevenList);
        bidList.addAll(bidThreeList);
        if (bidList != null && bidList.size() > 0) {
            for (Bid bid : bidList) {
                String userName = bid.getChargePersonName();
                Long userId = bid.getChargePerson();
                String customerName = bid.getCustomerName();
                String bidNumber = bid.getBidNumber();
                String bidName = bid.getBidName();
                String bidSubmitEndTime = sdf.format(bid.getBidSubmitEndTime());
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/tbModule/toubiaoDetails?row=" + "\"" + bid.getBidId() + "\"";
                String contentUnifyManager = "\u60a8\u7684\u5ba2\u6237\u3010" + customerName + "\u3011\u7684\u6295\u6807\u3010" + bidNumber + "," + bidName + "\u3011\u4e0b\u7684\u6295\u6807\u5c06\u4e8e\u3010" + bidSubmitEndTime + "\u3011\u622a\u6b62\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8";
                AddSysMessageType addSysMessageType1 = new AddSysMessageType();
                addSysMessageType1.setBusinessAddress(unifyWebUrl);
                addSysMessageType1.setBusinessType("bid");
                addSysMessageType1.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType1.setMessageContent(contentUnifyManager);
                addSysMessageType1.setReleaseDate(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                addSysMessageType1.setUserId(userId.toString());
                addSysMessageType1.setCreator(bid.getCreateUser());
                addSysMessageType1.setCreatoeDepartmentId(bid.getCreateDepartment().toString());
                if (ToolUtil.isNotEmpty((Object)bid.getUpdateUser())) {
                    addSysMessageType1.setLastEditor(bid.getUpdateUser());
                } else {
                    addSysMessageType1.setLastEditor(bid.getCreateUser());
                }
                addSysMessageType1.setMessageIssue("\u8d85\u7ea7\u7ba1\u7406\u5458");
                addSysMessageType1.setBusinessAddress(unifyWebUrl);
                addSysMessageType1.setMobileBusinessAddress("");
                addSysMessageType1.setOpenWay("1");
                UnifyUtil.sendMessage(addSysMessageType1);
            }
        }
        return ApiResponse.success((String)"\u5f53\u524d\u5f00\u6807\u65f6\u95f4\u63d0\u9192\u5df2\u63a8\u9001\u7ed9\u76f8\u5173\u8d1f\u8d23\u4eba\uff01");
    }
}

