/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.task.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.crm.common.api.fileInfo.dto.FileInfoAPIDto;
import com.jxdinfo.crm.common.api.fileInfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.task.dto.TaskAPIDto;
import com.jxdinfo.crm.core.api.task.dto.TaskPersonAPIDto;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.api.task.service.ITaskDataRightModuleService;
import com.jxdinfo.crm.core.task.dao.TaskMapper;
import com.jxdinfo.crm.core.task.dto.TaskDto;
import com.jxdinfo.crm.core.task.model.TaskEntity;
import com.jxdinfo.crm.core.task.model.TaskPersonEntity;
import com.jxdinfo.crm.core.task.service.TaskPersonService;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TaskAPIServiceImpl
implements ITaskAPIService {
    @Resource
    private TaskMapper taskMapper;
    @Resource
    private TaskService taskService;
    @Resource
    private TaskPersonService taskPersonService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;
    @Resource
    private ITaskDataRightModuleService taskDataRightModuleService;

    public long selectTaskCount(String businessType, Long businessId) {
        TaskDto taskDto = new TaskDto();
        taskDto.setBusinessType(businessType);
        taskDto.setBusinessId(businessId);
        taskDto.setDelFlag("0");
        taskDto.setCurrentTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        PermissionDto permissionDto = this.taskDataRightModuleService.getCurrentUserRolePermissions();
        SecurityUser user = BaseSecurityUtil.getUser();
        taskDto.setPersonId(user.getUserId());
        long taskCount = this.taskMapper.taskListSum(taskDto, permissionDto);
        return taskCount;
    }

    public Boolean saveTaskBatch(TaskAPIDto dto) {
        Map userMap = this.hussarBaseUserBoService.getUserInfo(dto.getChargePersonList());
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        ArrayList<TaskEntity> taskList = new ArrayList<TaskEntity>();
        ArrayList<FileInfoAPIDto> fileInfoDtoList = new ArrayList<FileInfoAPIDto>();
        ArrayList<TaskPersonEntity> taskPersonEntityList = new ArrayList<TaskPersonEntity>();
        for (Long chargePersonId : dto.getChargePersonList()) {
            TaskEntity entity = (TaskEntity)BeanUtil.copy((Object)dto, TaskEntity.class);
            Long taskId = Long.valueOf(CommonUtills.generateAssignId());
            entity.setTaskId(taskId);
            entity.setState("1");
            if (CollectionUtil.isNotEmpty((Collection)dto.getFileIds())) {
                FileInfoAPIDto fileInfoDto = new FileInfoAPIDto();
                fileInfoDto.setBusinessId(String.valueOf(taskId));
                fileInfoDto.setIds(dto.getFileIds());
                fileInfoDtoList.add(fileInfoDto);
            }
            entity.setCreatePerson(user.getUserId());
            entity.setCreatePersonName(user.getUserName());
            entity.setCreateTime(date);
            entity.setChangePerson(user.getUserId());
            entity.setChangePersonName(user.getUserName());
            entity.setChangeTime(date);
            entity.setChargePerson(String.valueOf(chargePersonId));
            entity.setChargePersonName(((SysUsers)userMap.get(chargePersonId)).getUserName());
            entity.setOwnDepartment(user.getDeptId());
            entity.setOwnDepartmentName(user.getDeptName());
            entity.setDelFlag("0");
            if (CollectionUtil.isNotEmpty((Collection)dto.getPersonList())) {
                for (TaskPersonAPIDto personAPIDto : dto.getPersonList()) {
                    TaskPersonEntity personEntity = (TaskPersonEntity)BeanUtil.copyProperties((Object)personAPIDto, TaskPersonEntity.class);
                    assert (personEntity != null);
                    personEntity.setDataStatus("0");
                    personEntity.setPersonId(CommonUtills.translateUserId(personEntity.getPersonId()));
                    personEntity.setTaskId(taskId);
                    taskPersonEntityList.add(personEntity);
                }
            }
            taskList.add(entity);
        }
        this.taskService.saveBatch(taskList);
        this.fileInfoAPIService.insertFileInfoBatch(fileInfoDtoList);
        this.taskPersonService.saveBatch(taskPersonEntityList);
        if (ToolUtil.isNotEmpty((Object)dto.getBusinessId())) {
            this.taskService.saveTrackRecordBatch(taskList, date, "1");
        }
        for (TaskEntity entity : taskList) {
            try {
                this.taskService.sendMessage(entity, "1", null, user, date);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void updateTaskSecurityLevel(Long businessId, Integer securityLevel) {
        this.taskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskEntity::getBusinessId, (Object)businessId)).eq(TaskEntity::getDelFlag, (Object)"0")).set(TaskEntity::getSecurityLevel, (Object)securityLevel));
    }
}

