/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.task.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.core.task.dto.TaskDto;
import com.jxdinfo.crm.core.task.model.TaskEntity;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.task.vo.TaskEntityVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"task"})
public class TaskController {
    @Resource
    private TaskService taskService;

    @PostMapping(value={"list"})
    @ApiOperation(value="\u4efb\u52a1\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u4efb\u52a1\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u4efb\u52a1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<TaskEntity>> listTask(@RequestBody @ApiParam(value="\u4efb\u52a1dto") TaskDto dto) {
        return ApiResponse.success(this.taskService.getTaskPage(dto));
    }

    @PostMapping(value={"taskSum"})
    @ApiOperation(value="\u4efb\u52a1\u5217\u8868\u603b\u8ba1", notes="\u4efb\u52a1\u5217\u8868\u603b\u8ba1")
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u4efb\u52a1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<TaskEntityVo> taskListSum(@RequestBody @ApiParam(value="\u4efb\u52a1dto") TaskDto dto) {
        return ApiResponse.success((Object)this.taskService.taskListSum(dto));
    }

    @GetMapping(value={"list/{taskId}"})
    @ApiOperation(value="\u4efb\u52a1\u8be6\u60c5", notes="\u4efb\u52a1\u8be6\u60c5")
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u4efb\u52a1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<TaskEntity> detail(@PathVariable @ApiParam(value="\u4efb\u52a1id") String taskId) {
        return ApiResponse.success((Object)this.taskService.getTaskById(taskId));
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u65b0\u589e\u4efb\u52a1", notes="\u65b0\u589e\u4efb\u52a1")
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u4efb\u52a1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> addTask(@RequestBody @ApiParam(value="\u4efb\u52a1\u5b9e\u4f53") TaskEntity entity) {
        return ApiResponse.success((Object)this.taskService.addTask(entity));
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1", notes="\u4fee\u6539\u4efb\u52a1")
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u4efb\u52a1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateTask(@RequestBody @ApiParam(value="\u4efb\u52a1\u5b9e\u4f53") TaskEntity entity) {
        return ApiResponse.success((Object)this.taskService.updateTask(entity));
    }

    @GetMapping(value={"delete/{taskId}"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1", notes="\u5220\u9664\u4efb\u52a1")
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u4efb\u52a1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> deleteTask(@PathVariable @ApiParam(value="\u4efb\u52a1id") Long taskId) {
        return ApiResponse.success((Object)this.taskService.deleteTask(taskId));
    }
}

